/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.internal;

import com.jgoodies.components.internal.JGTextComponent;
import com.jgoodies.components.internal.TextFieldSupport;
import com.jgoodies.fluent.BasicTheme;
import com.jgoodies.fluent.resources.WindowsThemes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

public final class FluentStatefulBorder
extends AbstractBorder {
    private static final Insets INSETS = new Insets(2, 4, 2, 2);
    private final BasicTheme theme;

    private FluentStatefulBorder(BasicTheme theme) {
        this.theme = theme != null ? theme : WindowsThemes.light();
    }

    public static void installOn(JTextComponent c, BasicTheme theme) {
        c.setBorder(new BorderUIResource.CompoundBorderUIResource(new FluentStatefulBorder(theme), new BasicBorders.MarginBorder()));
        if (c instanceof JGTextComponent) {
            TextFieldSupport.updateUI(c);
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        boolean debug = false;
        Color lightGray = new Color(231, 231, 231);
        Color lighterGray1 = new Color(237, 237, 237);
        Color lighterGray2 = new Color(234, 234, 234);
        Color darkGray = new Color(134, 134, 134);
        Color darkerGray1 = new Color(192, 192, 192);
        Color darkerGray2 = new Color(196, 196, 196);
        Color darkerGray3 = new Color(212, 212, 212);
        g.translate(x, y);
        g.setColor(this.theme.background());
        if (debug) {
            g.setColor(Color.ORANGE);
        }
        g.fillRect(0, 0, 2, 2);
        g.fillRect(w - 2, 0, 2, 2);
        g.fillRect(0, h - 2, 2, 2);
        g.fillRect(w - 2, h - 2, 2, 2);
        g.setColor(lightGray);
        if (debug) {
            g.setColor(Color.RED);
        }
        g.fillRect(3, 0, w - 6, 1);
        g.fillRect(0, 3, 1, h - 6);
        g.fillRect(w - 1, 3, 1, h - 6);
        g.setColor(lighterGray1);
        if (debug) {
            g.setColor(Color.CYAN);
        }
        g.fillRect(2, 0, 1, 1);
        g.fillRect(0, 2, 2, 1);
        g.fillRect(w - 3, 0, 1, 1);
        g.fillRect(w - 2, 2, 2, 1);
        g.setColor(lighterGray2);
        if (debug) {
            g.setColor(Color.PINK);
        }
        g.fillRect(1, 1, 2, 1);
        g.fillRect(w - 3, 1, 2, 1);
        g.setColor(lighterGray1);
        if (debug) {
            g.setColor(Color.CYAN);
        }
        g.fillRect(0, h - 3, 2, 1);
        g.fillRect(w - 2, h - 3, 2, 1);
        g.setColor(darkerGray1);
        if (debug) {
            g.setColor(Color.MAGENTA);
        }
        g.fillRect(1, h - 2, 1, 1);
        g.fillRect(w - 2, h - 2, 1, 1);
        g.setColor(darkerGray2);
        if (debug) {
            g.setColor(Color.GREEN);
        }
        g.fillRect(2, h - 2, 1, 1);
        g.fillRect(w - 3, h - 2, 1, 1);
        g.setColor(darkerGray3);
        if (debug) {
            g.setColor(Color.ORANGE);
        }
        g.fillRect(2, h - 1, 1, 1);
        g.fillRect(w - 3, h - 1, 1, 1);
        g.setColor(darkGray);
        if (debug) {
            g.setColor(Color.BLUE);
        }
        g.fillRect(3, h - 1, w - 6, 1);
        if (c.isFocusOwner()) {
            FluentStatefulBorder.paintFocus(c, g, x, y, w, h);
        }
        g.translate(-x, -y);
    }

    private static void paintFocus(Component c, Graphics g, int x, int y, int w, int h) {
        Color blue = new Color(0, 90, 158);
        g.setColor(blue);
        g.fillRect(2, h - 2, w - 4, 1);
        g.fillRect(4, h - 1, w - 8, 1);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets newInsets) {
        newInsets.top = FluentStatefulBorder.INSETS.top;
        newInsets.left = FluentStatefulBorder.INSETS.left;
        newInsets.bottom = FluentStatefulBorder.INSETS.bottom;
        newInsets.right = FluentStatefulBorder.INSETS.right;
        return newInsets;
    }
}

