/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithArrays;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.List;

public final class ReferenceType
extends Type<ReferenceType>
implements NodeWithType<ReferenceType>,
NodeWithAnnotations<ReferenceType>,
NodeWithArrays<ReferenceType> {
    private Type type;
    private int arrayCount;
    private List<List<AnnotationExpr>> arraysAnnotations;

    public ReferenceType() {
    }

    public ReferenceType(Type type) {
        this.setType(type);
    }

    public ReferenceType(Type type, int arrayCount) {
        this.setType(type);
        this.setArrayCount(arrayCount);
    }

    public ReferenceType(Range range, Type type, int arrayCount) {
        super(range);
        this.setType(type);
        this.setArrayCount(arrayCount);
    }

    public ReferenceType(int beginLine, int beginColumn, int endLine, int endColumn, Type type, int arrayCount, List<AnnotationExpr> annotations, List<List<AnnotationExpr>> arraysAnnotations) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), type, arrayCount, annotations, arraysAnnotations);
    }

    public ReferenceType(Range range, Type type, int arrayCount, List<AnnotationExpr> annotations, List<List<AnnotationExpr>> arraysAnnotations) {
        super(range, annotations);
        this.setType(type);
        this.setArrayCount(arrayCount);
        this.arraysAnnotations = arraysAnnotations;
    }

    public static ReferenceType create(String name, int arrayCount) {
        return new ReferenceType(new ClassOrInterfaceType(name), arrayCount);
    }

    public static ReferenceType create(PrimitiveType type, int arrayCount) {
        return new ReferenceType(type, arrayCount);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public int getArrayCount() {
        return this.arrayCount;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ReferenceType setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
        return this;
    }

    @Override
    public ReferenceType setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
        return this;
    }

    @Override
    public List<List<AnnotationExpr>> getArraysAnnotations() {
        this.arraysAnnotations = Utils.ensureNotNull(this.arraysAnnotations);
        return this.arraysAnnotations;
    }

    @Override
    public ReferenceType setArraysAnnotations(List<List<AnnotationExpr>> arraysAnnotations) {
        this.arraysAnnotations = arraysAnnotations;
        return this;
    }
}

