/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlinx.metadata.Flag;
import kotlinx.metadata.InconsistentKotlinMetadataException;
import kotlinx.metadata.KmAnnotation;
import kotlinx.metadata.KmClassExtensionVisitor;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmConstructorExtensionVisitor;
import kotlinx.metadata.KmConstructorVisitor;
import kotlinx.metadata.KmContractVisitor;
import kotlinx.metadata.KmEffectExpressionVisitor;
import kotlinx.metadata.KmEffectInvocationKind;
import kotlinx.metadata.KmEffectType;
import kotlinx.metadata.KmEffectVisitor;
import kotlinx.metadata.KmExtensionType;
import kotlinx.metadata.KmFunctionExtensionVisitor;
import kotlinx.metadata.KmFunctionVisitor;
import kotlinx.metadata.KmLambdaVisitor;
import kotlinx.metadata.KmPackageExtensionVisitor;
import kotlinx.metadata.KmPackageVisitor;
import kotlinx.metadata.KmPropertyExtensionVisitor;
import kotlinx.metadata.KmPropertyVisitor;
import kotlinx.metadata.KmTypeAliasVisitor;
import kotlinx.metadata.KmTypeExtensionVisitor;
import kotlinx.metadata.KmTypeParameterExtensionVisitor;
import kotlinx.metadata.KmTypeParameterVisitor;
import kotlinx.metadata.KmTypeVisitor;
import kotlinx.metadata.KmValueParameterVisitor;
import kotlinx.metadata.KmVariance;
import kotlinx.metadata.KmVersionRequirementLevel;
import kotlinx.metadata.KmVersionRequirementVersionKind;
import kotlinx.metadata.KmVersionRequirementVisitor;
import kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlinx.metadata.jvm.JvmClassExtensionVisitor;
import kotlinx.metadata.jvm.JvmConstructorExtensionVisitor;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmFlag;
import kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.JvmPackageExtensionVisitor;
import kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import kotlinx.metadata.jvm.JvmTypeExtensionVisitor;
import kotlinx.metadata.jvm.JvmTypeParameterExtensionVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import proguard.classfile.Clazz;
import proguard.classfile.FieldSignature;
import proguard.classfile.LibraryClass;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.KotlinAnnotation;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectInvocationKind;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinEffectType;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinTypeVariance;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementLevel;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementVersionKind;
import proguard.classfile.kotlin.flags.KotlinClassFlags;
import proguard.classfile.kotlin.flags.KotlinCommonFlags;
import proguard.classfile.kotlin.flags.KotlinConstructorFlags;
import proguard.classfile.kotlin.flags.KotlinEffectExpressionFlags;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.flags.KotlinModalityFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.flags.KotlinTypeAliasFlags;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.flags.KotlinTypeParameterFlags;
import proguard.classfile.kotlin.flags.KotlinValueParameterFlags;
import proguard.classfile.kotlin.flags.KotlinVisibilityFlags;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.util.kotlin.KotlinAnnotationUtilKt;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataInitializer
implements ClassVisitor,
AnnotationVisitor,
ElementValueVisitor,
ConstantVisitor {
    private int k;
    private int[] mv;
    private String[] d1;
    private String[] d2;
    private int xi;
    private String xs;
    private String pn;
    public static final KotlinMetadataVersion MAX_SUPPORTED_VERSION;
    private MetadataType currentType;
    private final BiConsumer<Clazz, String> errorHandler;

    public KotlinMetadataInitializer(WarningPrinter warningPrinter) {
        this((Clazz clazz, String message) -> warningPrinter.print(clazz.getName(), (String)message));
    }

    public KotlinMetadataInitializer(BiConsumer<Clazz, String> errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        clazz.accept(new AllAttributeVisitor(new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)this)))));
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.k = -1;
        this.mv = null;
        this.d1 = null;
        this.d2 = null;
        this.xi = 0;
        this.xs = null;
        this.pn = null;
        annotation.elementValuesAccept(clazz, this);
        KotlinClassMetadata md = KotlinClassMetadata.read(new KotlinClassHeader(this.k, this.mv, this.d1, this.d2, this.xs, this.pn, this.xi));
        if (md == null) {
            String version = this.mv == null ? "unknown" : Arrays.stream(this.mv).mapToObj(Integer::toString).collect(Collectors.joining("."));
            this.errorHandler.accept(clazz, "Encountered corrupt @kotlin/Metadata for class " + clazz.getName() + " (version " + version + ").");
            return;
        }
        try {
            switch (this.k) {
                case 1: {
                    KotlinClassKindMetadata kotlinClassKindMetadata = new KotlinClassKindMetadata(this.mv, this.xi, this.xs, this.pn);
                    ((KotlinClassMetadata.Class)md).accept(new ClassReader(kotlinClassKindMetadata));
                    kotlinClassKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinClassKindMetadata));
                    break;
                }
                case 2: {
                    KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata = new KotlinFileFacadeKindMetadata(this.mv, this.xi, this.xs, this.pn);
                    ((KotlinClassMetadata.FileFacade)md).accept(new PackageReader(kotlinFileFacadeKindMetadata));
                    kotlinFileFacadeKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinFileFacadeKindMetadata));
                    break;
                }
                case 3: {
                    KotlinClassMetadata.SyntheticClass smd = (KotlinClassMetadata.SyntheticClass)md;
                    KotlinSyntheticClassKindMetadata.Flavor flavor = smd.isLambda() ? KotlinSyntheticClassKindMetadata.Flavor.LAMBDA : (clazz.getName().endsWith("$DefaultImpls") ? KotlinSyntheticClassKindMetadata.Flavor.DEFAULT_IMPLS : (clazz.getName().endsWith("$WhenMappings") ? KotlinSyntheticClassKindMetadata.Flavor.WHEN_MAPPINGS : KotlinSyntheticClassKindMetadata.Flavor.REGULAR));
                    KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata = new KotlinSyntheticClassKindMetadata(this.mv, this.xi, this.xs, this.pn, flavor);
                    if (smd.isLambda()) {
                        smd.accept(new LambdaReader(kotlinSyntheticClassKindMetadata));
                    } else {
                        kotlinSyntheticClassKindMetadata.functions = KotlinMetadataInitializer.trimmed(new ArrayList(0));
                    }
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinSyntheticClassKindMetadata));
                    break;
                }
                case 4: {
                    clazz.accept(new SimpleKotlinMetadataSetter(new KotlinMultiFileFacadeKindMetadata(this.mv, this.d1, this.xi, this.xs, this.pn)));
                    break;
                }
                case 5: {
                    KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata = new KotlinMultiFilePartKindMetadata(this.mv, this.xi, this.xs, this.pn);
                    ((KotlinClassMetadata.MultiFileClassPart)md).accept(new PackageReader(kotlinMultiFilePartKindMetadata));
                    kotlinMultiFilePartKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinMultiFilePartKindMetadata));
                    break;
                }
                default: {
                    this.errorHandler.accept(clazz, "Unknown Kotlin class kind in class " + clazz.getName() + ". The metadata for this class will not be processed.");
                    break;
                }
            }
        }
        catch (InconsistentKotlinMetadataException e) {
            this.errorHandler.accept(clazz, "Encountered corrupt Kotlin metadata in class " + clazz.getName() + ". The metadata for this class will not be processed (" + e.getMessage() + ")");
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.currentType = MetadataType.valueOf(constantElementValue.getMethodName(clazz));
        clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        MetadataType arrayElementType = MetadataType.valueOf(arrayElementValue.getMethodName(clazz));
        switch (arrayElementType) {
            case mv: {
                this.mv = new int[arrayElementValue.u2elementValuesCount];
                break;
            }
            case d1: {
                this.d1 = new String[arrayElementValue.u2elementValuesCount];
                break;
            }
            case d2: {
                this.d2 = new String[arrayElementValue.u2elementValuesCount];
            }
        }
        arrayElementValue.elementValuesAccept(clazz, annotation, new ArrayElementValueCollector(arrayElementType));
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (this.currentType == MetadataType.xs) {
            this.xs = utf8Constant.getString();
        } else if (this.currentType == MetadataType.pn) {
            this.pn = utf8Constant.getString();
        } else {
            throw new UnsupportedOperationException("Cannot store Utf8Constant in int");
        }
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        if (this.currentType == MetadataType.k) {
            this.k = integerConstant.getValue();
        } else if (this.currentType == MetadataType.xi) {
            this.xi = integerConstant.getValue();
        } else {
            throw new UnsupportedOperationException("Cannot store Utf8Constant in int");
        }
    }

    private static <K> List<K> trimmed(ArrayList<K> list) {
        list.trimToSize();
        return list;
    }

    private static MethodSignature fromKotlinJvmMethodSignature(JvmMethodSignature jvmMethodSignature) {
        if (jvmMethodSignature == null) {
            return null;
        }
        try {
            return new MethodSignature(null, jvmMethodSignature.getName(), jvmMethodSignature.getDesc());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FieldSignature fromKotlinJvmFieldSignature(JvmFieldSignature jvmFieldSignature) {
        if (jvmFieldSignature == null) {
            return null;
        }
        return new FieldSignature(null, jvmFieldSignature.getName(), jvmFieldSignature.getDesc());
    }

    private static KotlinTypeVariance fromKmVariance(KmVariance variance) {
        switch (variance) {
            case IN: {
                return KotlinTypeVariance.IN;
            }
            case INVARIANT: {
                return KotlinTypeVariance.INVARIANT;
            }
            case OUT: {
                return KotlinTypeVariance.OUT;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVariance.");
    }

    private static KotlinVersionRequirementVersionKind fromKmVersionRequirementVersionKind(KmVersionRequirementVersionKind kotlinVersionRequirementVersionKind) {
        switch (kotlinVersionRequirementVersionKind) {
            case API_VERSION: {
                return KotlinVersionRequirementVersionKind.API_VERSION;
            }
            case COMPILER_VERSION: {
                return KotlinVersionRequirementVersionKind.COMPILER_VERSION;
            }
            case LANGUAGE_VERSION: {
                return KotlinVersionRequirementVersionKind.LANGUAGE_VERSION;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVersionRequirementVersionKind.");
    }

    private static KotlinVersionRequirementLevel fromKmVersionRequirementLevel(KmVersionRequirementLevel kmVersionRequirementLevel) {
        switch (kmVersionRequirementLevel) {
            case ERROR: {
                return KotlinVersionRequirementLevel.ERROR;
            }
            case HIDDEN: {
                return KotlinVersionRequirementLevel.HIDDEN;
            }
            case WARNING: {
                return KotlinVersionRequirementLevel.WARNING;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVersionRequirementLevel.");
    }

    private static KotlinEffectType fromKmEffectType(KmEffectType effectType) {
        switch (effectType) {
            case CALLS: {
                return KotlinEffectType.CALLS;
            }
            case RETURNS_CONSTANT: {
                return KotlinEffectType.RETURNS_CONSTANT;
            }
            case RETURNS_NOT_NULL: {
                return KotlinEffectType.RETURNS_NOT_NULL;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectType.");
    }

    private static KotlinEffectInvocationKind fromKmEffectInvocationKind(KmEffectInvocationKind invocationKind) {
        if (invocationKind == null) {
            return null;
        }
        switch (invocationKind) {
            case AT_MOST_ONCE: {
                return KotlinEffectInvocationKind.AT_MOST_ONCE;
            }
            case EXACTLY_ONCE: {
                return KotlinEffectInvocationKind.EXACTLY_ONCE;
            }
            case AT_LEAST_ONCE: {
                return KotlinEffectInvocationKind.AT_LEAST_ONCE;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectInvocationKind.");
    }

    private KotlinCommonFlags convertCommonFlags(int kotlinFlags) {
        KotlinCommonFlags flags = new KotlinCommonFlags();
        flags.hasAnnotations = Flag.HAS_ANNOTATIONS.invoke(kotlinFlags);
        return flags;
    }

    private KotlinVisibilityFlags convertVisibilityFlags(int kotlinFlags) {
        KotlinVisibilityFlags flags = new KotlinVisibilityFlags();
        flags.isInternal = Flag.IS_INTERNAL.invoke(kotlinFlags);
        flags.isLocal = Flag.IS_LOCAL.invoke(kotlinFlags);
        flags.isPrivate = Flag.IS_PRIVATE.invoke(kotlinFlags);
        flags.isProtected = Flag.IS_PROTECTED.invoke(kotlinFlags);
        flags.isPublic = Flag.IS_PUBLIC.invoke(kotlinFlags);
        flags.isPrivateToThis = Flag.IS_PRIVATE_TO_THIS.invoke(kotlinFlags);
        return flags;
    }

    private KotlinModalityFlags convertModalityFlags(int kotlinFlags) {
        KotlinModalityFlags flags = new KotlinModalityFlags();
        flags.isAbstract = Flag.IS_ABSTRACT.invoke(kotlinFlags);
        flags.isFinal = Flag.IS_FINAL.invoke(kotlinFlags);
        flags.isOpen = Flag.IS_OPEN.invoke(kotlinFlags);
        flags.isSealed = Flag.IS_SEALED.invoke(kotlinFlags);
        return flags;
    }

    private KotlinFunctionFlags convertFunctionFlags(int kotlinFlags) {
        KotlinFunctionFlags flags = new KotlinFunctionFlags(this.convertCommonFlags(kotlinFlags), this.convertVisibilityFlags(kotlinFlags), this.convertModalityFlags(kotlinFlags));
        flags.isDeclaration = Flag.Function.IS_DECLARATION.invoke(kotlinFlags);
        flags.isFakeOverride = Flag.Function.IS_FAKE_OVERRIDE.invoke(kotlinFlags);
        flags.isDelegation = Flag.Function.IS_DELEGATION.invoke(kotlinFlags);
        flags.isSynthesized = Flag.Function.IS_SYNTHESIZED.invoke(kotlinFlags);
        flags.isOperator = Flag.Function.IS_OPERATOR.invoke(kotlinFlags);
        flags.isInfix = Flag.Function.IS_INFIX.invoke(kotlinFlags);
        flags.isInline = Flag.Function.IS_INLINE.invoke(kotlinFlags);
        flags.isTailrec = Flag.Function.IS_TAILREC.invoke(kotlinFlags);
        flags.isExternal = Flag.Function.IS_EXTERNAL.invoke(kotlinFlags);
        flags.isSuspend = Flag.Function.IS_SUSPEND.invoke(kotlinFlags);
        flags.isExpect = Flag.Function.IS_EXPECT.invoke(kotlinFlags);
        return flags;
    }

    private KotlinTypeFlags convertTypeFlags(int kotlinFlags) {
        KotlinTypeFlags flags = new KotlinTypeFlags(this.convertCommonFlags(kotlinFlags));
        flags.isNullable = Flag.Type.IS_NULLABLE.invoke(kotlinFlags);
        flags.isSuspend = Flag.Type.IS_SUSPEND.invoke(kotlinFlags);
        return flags;
    }

    private KotlinTypeParameterFlags convertTypeParameterFlags(int kotlinFlags) {
        KotlinTypeParameterFlags flags = new KotlinTypeParameterFlags(this.convertCommonFlags(kotlinFlags));
        flags.isReified = Flag.TypeParameter.IS_REIFIED.invoke(kotlinFlags);
        return flags;
    }

    private KotlinTypeAliasFlags convertTypeAliasFlags(int kotlinFlags) {
        return new KotlinTypeAliasFlags(this.convertCommonFlags(kotlinFlags), this.convertVisibilityFlags(kotlinFlags));
    }

    private KotlinPropertyFlags convertPropertyFlags(int kotlinFlags) {
        KotlinPropertyFlags flags = new KotlinPropertyFlags(this.convertCommonFlags(kotlinFlags), this.convertVisibilityFlags(kotlinFlags), this.convertModalityFlags(kotlinFlags));
        flags.isDeclared = Flag.Property.IS_DECLARATION.invoke(kotlinFlags);
        flags.isFakeOverride = Flag.Property.IS_FAKE_OVERRIDE.invoke(kotlinFlags);
        flags.isDelegation = Flag.Property.IS_DELEGATION.invoke(kotlinFlags);
        flags.isSynthesized = Flag.Property.IS_SYNTHESIZED.invoke(kotlinFlags);
        flags.isVar = Flag.Property.IS_VAR.invoke(kotlinFlags);
        flags.hasGetter = Flag.Property.HAS_GETTER.invoke(kotlinFlags);
        flags.hasSetter = Flag.Property.HAS_SETTER.invoke(kotlinFlags);
        flags.isConst = Flag.Property.IS_CONST.invoke(kotlinFlags);
        flags.isLateinit = Flag.Property.IS_LATEINIT.invoke(kotlinFlags);
        flags.hasConstant = Flag.Property.HAS_CONSTANT.invoke(kotlinFlags);
        flags.isExternal = Flag.Property.IS_EXTERNAL.invoke(kotlinFlags);
        flags.isDelegated = Flag.Property.IS_DELEGATED.invoke(kotlinFlags);
        flags.isExpect = Flag.Property.IS_EXPECT.invoke(kotlinFlags);
        return flags;
    }

    private void setPropertyJvmFlags(KotlinPropertyFlags flags, int jvmFlags) {
        flags.isMovedFromInterfaceCompanion = JvmFlag.Property.IS_MOVED_FROM_INTERFACE_COMPANION.invoke(jvmFlags);
    }

    private void setClassJvmFlags(KotlinClassFlags flags, int jvmFlags) {
        flags.hasMethodBodiesInInterface = JvmFlag.Class.HAS_METHOD_BODIES_IN_INTERFACE.invoke(jvmFlags);
        flags.isCompiledInCompatibilityMode = JvmFlag.Class.IS_COMPILED_IN_COMPATIBILITY_MODE.invoke(jvmFlags);
    }

    private KotlinPropertyAccessorFlags convertPropertyAccessorFlags(int kotlinFlags) {
        KotlinPropertyAccessorFlags flags = new KotlinPropertyAccessorFlags(this.convertCommonFlags(kotlinFlags), this.convertVisibilityFlags(kotlinFlags), this.convertModalityFlags(kotlinFlags));
        flags.isDefault = !Flag.PropertyAccessor.IS_NOT_DEFAULT.invoke(kotlinFlags);
        flags.isExternal = Flag.PropertyAccessor.IS_EXTERNAL.invoke(kotlinFlags);
        flags.isInline = Flag.PropertyAccessor.IS_INLINE.invoke(kotlinFlags);
        return flags;
    }

    private KotlinValueParameterFlags convertValueParameterFlags(int kotlinFlags) {
        KotlinValueParameterFlags flags = new KotlinValueParameterFlags(this.convertCommonFlags(kotlinFlags));
        flags.hasDefaultValue = Flag.ValueParameter.DECLARES_DEFAULT_VALUE.invoke(kotlinFlags);
        flags.isCrossInline = Flag.ValueParameter.IS_CROSSINLINE.invoke(kotlinFlags);
        flags.isNoInline = Flag.ValueParameter.IS_NOINLINE.invoke(kotlinFlags);
        return flags;
    }

    private KotlinEffectExpressionFlags convertEffectExpressionFlags(int kotlinFlags) {
        KotlinEffectExpressionFlags flags = new KotlinEffectExpressionFlags();
        flags.isNullCheckPredicate = Flag.EffectExpression.IS_NULL_CHECK_PREDICATE.invoke(kotlinFlags);
        flags.isNegated = Flag.EffectExpression.IS_NEGATED.invoke(kotlinFlags);
        return flags;
    }

    public static boolean isSupportedMetadataVersion(KotlinMetadataVersion mv) {
        return new JvmMetadataVersion(mv.major, mv.minor, mv.patch).isCompatible();
    }

    static {
        int[] version = JvmMetadataVersion.INSTANCE.toArray();
        MAX_SUPPORTED_VERSION = new KotlinMetadataVersion(version[0], version[1] + 1);
    }

    private class VersionRequirementReader
    extends KmVersionRequirementVisitor {
        private final KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata;

        VersionRequirementReader(KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kotlinVersionRequirementMetadata = kotlinVersionRequirementMetadata;
        }

        @Override
        public void visit(KmVersionRequirementVersionKind kind, KmVersionRequirementLevel level, Integer errorCode, String message) {
            this.kotlinVersionRequirementMetadata.kind = KotlinMetadataInitializer.fromKmVersionRequirementVersionKind(kind);
            this.kotlinVersionRequirementMetadata.level = KotlinMetadataInitializer.fromKmVersionRequirementLevel(level);
            this.kotlinVersionRequirementMetadata.errorCode = errorCode;
            this.kotlinVersionRequirementMetadata.message = message;
        }

        @Override
        public void visitVersion(int major, int minor, int patch) {
            this.kotlinVersionRequirementMetadata.major = major;
            this.kotlinVersionRequirementMetadata.minor = minor;
            this.kotlinVersionRequirementMetadata.patch = patch;
        }

        @Override
        public void visitEnd() {
        }
    }

    private class TypeParameterReader
    extends KmTypeParameterVisitor {
        private final KotlinTypeParameterMetadata kotlinTypeParameterMetadata;
        private final ArrayList<KotlinTypeMetadata> upperBounds;

        TypeParameterReader(KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kotlinTypeParameterMetadata = kotlinTypeParameterMetadata;
            this.upperBounds = new ArrayList();
        }

        @Override
        public KmTypeParameterExtensionVisitor visitExtensions(KmExtensionType type) {
            return new TypeParameterExtensionReader();
        }

        @Override
        public KmTypeVisitor visitUpperBound(int flags) {
            KotlinTypeMetadata upperBound = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            this.upperBounds.add(upperBound);
            return new TypeReader(upperBound);
        }

        @Override
        public void visitEnd() {
            this.kotlinTypeParameterMetadata.upperBounds = this.upperBounds;
        }

        private class TypeParameterExtensionReader
        extends JvmTypeParameterExtensionVisitor {
            private final ArrayList<KotlinAnnotation> annotations = new ArrayList(1);

            private TypeParameterExtensionReader() {
            }

            @Override
            public void visitAnnotation(KmAnnotation annotation) {
                this.annotations.add(KotlinAnnotationUtilKt.convertAnnotation(annotation));
            }

            @Override
            public void visitEnd() {
                ((TypeParameterReader)TypeParameterReader.this).kotlinTypeParameterMetadata.annotations = KotlinMetadataInitializer.trimmed(this.annotations);
                ((TypeParameterReader)TypeParameterReader.this).kotlinTypeParameterMetadata.flags.common.hasAnnotations = !this.annotations.isEmpty();
            }
        }
    }

    private class TypeReader
    extends KmTypeVisitor {
        private KotlinTypeMetadata kotlinTypeMetadata;
        private final ArrayList<KotlinTypeMetadata> typeArguments;
        private final ArrayList<KotlinTypeMetadata> upperBounds;
        private final ArrayList<KotlinAnnotation> annotations;

        TypeReader(KotlinTypeMetadata kotlinTypeMetadata) {
            this.kotlinTypeMetadata = kotlinTypeMetadata;
            this.typeArguments = new ArrayList(2);
            this.annotations = new ArrayList(1);
            this.upperBounds = new ArrayList();
        }

        @Override
        public KmTypeVisitor visitAbbreviatedType(int flags) {
            KotlinTypeMetadata abbreviatedType;
            this.kotlinTypeMetadata.abbreviation = abbreviatedType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(abbreviatedType);
        }

        @Override
        public void visitClass(String className) {
            if (ClassUtil.isInternalClassType(className)) {
                className = ClassUtil.internalClassNameFromClassType(className);
            }
            if (className.startsWith(".")) {
                className = className.substring(1);
            }
            this.kotlinTypeMetadata.className = className = className.replace('.', '$');
        }

        @Override
        public void visitTypeParameter(int id) {
            this.kotlinTypeMetadata.typeParamID = id;
        }

        @Override
        public void visitTypeAlias(String aliasName) {
            this.kotlinTypeMetadata.aliasName = aliasName;
        }

        @Override
        public KmTypeVisitor visitOuterType(int flags) {
            KotlinTypeMetadata outerType;
            this.kotlinTypeMetadata.outerClassType = outerType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(outerType);
        }

        @Override
        public KmTypeVisitor visitArgument(int flags, KmVariance variance) {
            KotlinTypeMetadata typeArgument = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags), KotlinMetadataInitializer.fromKmVariance(variance));
            this.typeArguments.add(typeArgument);
            return new TypeReader(typeArgument);
        }

        @Override
        public void visitStarProjection() {
            this.typeArguments.add(KotlinTypeMetadata.starProjection());
        }

        @Override
        public KmTypeVisitor visitFlexibleTypeUpperBound(int flags, String typeFlexibilityId) {
            this.kotlinTypeMetadata.flexibilityID = typeFlexibilityId;
            KotlinTypeMetadata upperBound = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            this.upperBounds.add(upperBound);
            return new TypeReader(upperBound);
        }

        @Override
        public KmTypeExtensionVisitor visitExtensions(KmExtensionType extensionType) {
            return new TypeExtensionReader();
        }

        @Override
        public void visitEnd() {
            this.kotlinTypeMetadata.typeArguments = KotlinMetadataInitializer.trimmed(this.typeArguments);
            this.kotlinTypeMetadata.annotations = KotlinMetadataInitializer.trimmed(this.annotations);
            this.kotlinTypeMetadata.upperBounds = KotlinMetadataInitializer.trimmed(this.upperBounds);
            this.kotlinTypeMetadata.flags.common.hasAnnotations = !this.annotations.isEmpty();
        }

        private class TypeExtensionReader
        extends JvmTypeExtensionVisitor {
            private TypeExtensionReader() {
            }

            @Override
            public void visit(boolean isRaw) {
                ((TypeReader)TypeReader.this).kotlinTypeMetadata.isRaw = isRaw;
            }

            @Override
            public void visitAnnotation(KmAnnotation annotation) {
                TypeReader.this.annotations.add(KotlinAnnotationUtilKt.convertAnnotation(annotation));
            }

            @Override
            public void visitEnd() {
            }
        }
    }

    private class ValueParameterReader
    extends KmValueParameterVisitor {
        private final KotlinValueParameterMetadata kotlinValueParameterMetadata;

        ValueParameterReader(KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.kotlinValueParameterMetadata = kotlinValueParameterMetadata;
        }

        @Override
        public KmTypeVisitor visitType(int flags) {
            KotlinTypeMetadata type;
            this.kotlinValueParameterMetadata.type = type = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(type);
        }

        @Override
        public KmTypeVisitor visitVarargElementType(int flags) {
            KotlinTypeMetadata varArgType;
            this.kotlinValueParameterMetadata.varArgElementType = varArgType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(varArgType);
        }

        @Override
        public void visitEnd() {
        }
    }

    private class EffectExpressionReader
    extends KmEffectExpressionVisitor {
        private final KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata;
        private final List<KotlinEffectExpressionMetadata> andRightHandSides = new ArrayList<KotlinEffectExpressionMetadata>();
        private final List<KotlinEffectExpressionMetadata> orRightHandSides = new ArrayList<KotlinEffectExpressionMetadata>();

        EffectExpressionReader(KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.kotlinEffectExpressionMetadata = kotlinEffectExpressionMetadata;
        }

        @Override
        public void visit(int flags, Integer parameterIndex) {
            this.kotlinEffectExpressionMetadata.flags = KotlinMetadataInitializer.this.convertEffectExpressionFlags(flags);
            if (parameterIndex != null) {
                this.kotlinEffectExpressionMetadata.parameterIndex = parameterIndex;
            }
        }

        @Override
        public void visitConstantValue(Object o) {
            this.kotlinEffectExpressionMetadata.hasConstantValue = true;
            this.kotlinEffectExpressionMetadata.constantValue = o;
        }

        @Override
        public KmTypeVisitor visitIsInstanceType(int flags) {
            KotlinTypeMetadata typeOfIs;
            this.kotlinEffectExpressionMetadata.typeOfIs = typeOfIs = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(typeOfIs);
        }

        @Override
        public KmEffectExpressionVisitor visitAndArgument() {
            KotlinEffectExpressionMetadata andRHS = new KotlinEffectExpressionMetadata();
            this.andRightHandSides.add(andRHS);
            return new EffectExpressionReader(andRHS);
        }

        @Override
        public KmEffectExpressionVisitor visitOrArgument() {
            KotlinEffectExpressionMetadata orRHS = new KotlinEffectExpressionMetadata();
            this.orRightHandSides.add(orRHS);
            return new EffectExpressionReader(orRHS);
        }

        @Override
        public void visitEnd() {
            this.kotlinEffectExpressionMetadata.andRightHandSides = this.andRightHandSides;
            this.kotlinEffectExpressionMetadata.orRightHandSides = this.orRightHandSides;
        }
    }

    private class EffectReader
    extends KmEffectVisitor {
        private final KotlinEffectMetadata kotlinEffectMetadata;
        private final ArrayList<KotlinEffectExpressionMetadata> constructorArguments = new ArrayList();

        EffectReader(KotlinEffectMetadata kotlinEffectMetadata) {
            this.kotlinEffectMetadata = kotlinEffectMetadata;
        }

        @Override
        public KmEffectExpressionVisitor visitConclusionOfConditionalEffect() {
            KotlinEffectExpressionMetadata conclusion;
            this.kotlinEffectMetadata.conclusionOfConditionalEffect = conclusion = new KotlinEffectExpressionMetadata();
            return new EffectExpressionReader(conclusion);
        }

        @Override
        public KmEffectExpressionVisitor visitConstructorArgument() {
            KotlinEffectExpressionMetadata constructorArg = new KotlinEffectExpressionMetadata();
            this.constructorArguments.add(constructorArg);
            return new EffectExpressionReader(constructorArg);
        }

        @Override
        public void visitEnd() {
            this.kotlinEffectMetadata.constructorArguments = KotlinMetadataInitializer.trimmed(this.constructorArguments);
        }
    }

    private class ContractReader
    extends KmContractVisitor {
        private final KotlinContractMetadata kotlinContractMetadata;
        private final ArrayList<KotlinEffectMetadata> effects;

        ContractReader(KotlinContractMetadata kotlinContractMetadata) {
            this.kotlinContractMetadata = kotlinContractMetadata;
            this.effects = new ArrayList(2);
        }

        @Override
        public KmEffectVisitor visitEffect(KmEffectType effectType, KmEffectInvocationKind invocationKind) {
            KotlinEffectMetadata effect = new KotlinEffectMetadata(KotlinMetadataInitializer.fromKmEffectType(effectType), KotlinMetadataInitializer.fromKmEffectInvocationKind(invocationKind));
            this.effects.add(effect);
            return new EffectReader(effect);
        }

        @Override
        public void visitEnd() {
            this.kotlinContractMetadata.effects = KotlinMetadataInitializer.trimmed(this.effects);
        }
    }

    private class FunctionReader
    extends KmFunctionVisitor {
        private final KotlinFunctionMetadata kotlinFunctionMetadata;
        private final ArrayList<KotlinContractMetadata> contracts;
        private final ArrayList<KotlinValueParameterMetadata> valueParameters;
        private final ArrayList<KotlinTypeParameterMetadata> typeParameters;

        FunctionReader(KotlinFunctionMetadata kotlinFunctionMetadata) {
            this.kotlinFunctionMetadata = kotlinFunctionMetadata;
            this.contracts = new ArrayList(1);
            this.valueParameters = new ArrayList(4);
            this.typeParameters = new ArrayList(1);
        }

        @Override
        public KmContractVisitor visitContract() {
            KotlinContractMetadata contract = new KotlinContractMetadata();
            this.contracts.add(contract);
            return new ContractReader(contract);
        }

        @Override
        public KmTypeVisitor visitReceiverParameterType(int flags) {
            KotlinTypeMetadata receiverType;
            this.kotlinFunctionMetadata.receiverType = receiverType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(receiverType);
        }

        @Override
        public KmTypeVisitor visitReturnType(int flags) {
            KotlinTypeMetadata returnType;
            this.kotlinFunctionMetadata.returnType = returnType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(returnType);
        }

        @Override
        public KmTypeParameterVisitor visitTypeParameter(int flags, String name, int id, KmVariance variance) {
            KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(KotlinMetadataInitializer.this.convertTypeParameterFlags(flags), name, id, KotlinMetadataInitializer.fromKmVariance(variance));
            this.typeParameters.add(kotlinTypeParameterMetadata);
            return new TypeParameterReader(kotlinTypeParameterMetadata);
        }

        @Override
        public KmValueParameterVisitor visitValueParameter(int flags, String name) {
            KotlinValueParameterMetadata valueParameter = new KotlinValueParameterMetadata(KotlinMetadataInitializer.this.convertValueParameterFlags(flags), this.valueParameters.size(), name);
            this.valueParameters.add(valueParameter);
            return new ValueParameterReader(valueParameter);
        }

        @Override
        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinFunctionMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        @Override
        public KmFunctionExtensionVisitor visitExtensions(KmExtensionType extensionType) {
            return new FunctionExtensionReader();
        }

        @Override
        public void visitEnd() {
            this.kotlinFunctionMetadata.contracts = KotlinMetadataInitializer.trimmed(this.contracts);
            this.kotlinFunctionMetadata.valueParameters = KotlinMetadataInitializer.trimmed(this.valueParameters);
            this.kotlinFunctionMetadata.typeParameters = KotlinMetadataInitializer.trimmed(this.typeParameters);
        }

        private class FunctionExtensionReader
        extends JvmFunctionExtensionVisitor {
            private FunctionExtensionReader() {
            }

            @Override
            public void visit(JvmMethodSignature signature) {
                ((FunctionReader)FunctionReader.this).kotlinFunctionMetadata.jvmSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(signature);
            }

            @Override
            public void visitLambdaClassOriginName(String internalName) {
                ((FunctionReader)FunctionReader.this).kotlinFunctionMetadata.lambdaClassOriginName = internalName;
            }

            @Override
            public void visitEnd() {
            }
        }
    }

    private class PackageReader
    extends KmPackageVisitor {
        private final KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata;
        private final ArrayList<KotlinPropertyMetadata> properties;
        private final ArrayList<KotlinFunctionMetadata> functions;
        private final ArrayList<KotlinTypeAliasMetadata> typeAliases;
        private final ArrayList<KotlinPropertyMetadata> localDelegatedProperties;

        PackageReader(KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            this.kotlinDeclarationContainerMetadata = kotlinDeclarationContainerMetadata;
            this.properties = new ArrayList(8);
            this.functions = new ArrayList(8);
            this.typeAliases = new ArrayList(2);
            this.localDelegatedProperties = new ArrayList(2);
        }

        @Override
        public KmFunctionVisitor visitFunction(int flags, String name) {
            KotlinFunctionMetadata function = new KotlinFunctionMetadata(KotlinMetadataInitializer.this.convertFunctionFlags(flags), name);
            this.functions.add(function);
            return new FunctionReader(function);
        }

        @Override
        public KmPropertyVisitor visitProperty(int flags, String name, int getterFlags, int setterFlags) {
            KotlinPropertyMetadata property = new KotlinPropertyMetadata(KotlinMetadataInitializer.this.convertPropertyFlags(flags), name, KotlinMetadataInitializer.this.convertPropertyAccessorFlags(getterFlags), KotlinMetadataInitializer.this.convertPropertyAccessorFlags(setterFlags));
            this.properties.add(property);
            return new PropertyReader(property);
        }

        @Override
        public KmTypeAliasVisitor visitTypeAlias(int flags, String name) {
            KotlinTypeAliasMetadata typeAlias = new KotlinTypeAliasMetadata(KotlinMetadataInitializer.this.convertTypeAliasFlags(flags), name);
            this.typeAliases.add(typeAlias);
            return new TypeAliasReader(typeAlias);
        }

        @Override
        public KmPackageExtensionVisitor visitExtensions(KmExtensionType type) {
            return new PackageExtensionReader();
        }

        @Override
        public void visitEnd() {
            this.kotlinDeclarationContainerMetadata.properties = KotlinMetadataInitializer.trimmed(this.properties);
            this.kotlinDeclarationContainerMetadata.functions = KotlinMetadataInitializer.trimmed(this.functions);
            this.kotlinDeclarationContainerMetadata.typeAliases = KotlinMetadataInitializer.trimmed(this.typeAliases);
            this.kotlinDeclarationContainerMetadata.localDelegatedProperties = KotlinMetadataInitializer.trimmed(this.localDelegatedProperties);
        }

        private class PackageExtensionReader
        extends JvmPackageExtensionVisitor {
            private PackageExtensionReader() {
            }

            @Override
            public KmPropertyVisitor visitLocalDelegatedProperty(int flags, String name, int getterFlags, int setterFlags) {
                KotlinPropertyMetadata delegatedProperty = new KotlinPropertyMetadata(KotlinMetadataInitializer.this.convertPropertyFlags(flags), name, KotlinMetadataInitializer.this.convertPropertyAccessorFlags(getterFlags), KotlinMetadataInitializer.this.convertPropertyAccessorFlags(setterFlags));
                PackageReader.this.localDelegatedProperties.add(delegatedProperty);
                return new PropertyReader(delegatedProperty);
            }

            @Override
            public void visitEnd() {
            }
        }
    }

    private class TypeAliasReader
    extends KmTypeAliasVisitor {
        private final KotlinTypeAliasMetadata kotlinTypeAliasMetadata;
        private final ArrayList<KotlinAnnotation> annotations;
        private final ArrayList<KotlinTypeParameterMetadata> typeParameters;

        TypeAliasReader(KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            this.kotlinTypeAliasMetadata = kotlinTypeAliasMetadata;
            this.annotations = new ArrayList(1);
            this.typeParameters = new ArrayList(1);
        }

        @Override
        public void visitAnnotation(KmAnnotation annotation) {
            this.annotations.add(KotlinAnnotationUtilKt.convertAnnotation(annotation));
        }

        @Override
        public KmTypeParameterVisitor visitTypeParameter(int flags, String name, int id, KmVariance variance) {
            KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(KotlinMetadataInitializer.this.convertTypeParameterFlags(flags), name, id, KotlinMetadataInitializer.fromKmVariance(variance));
            this.typeParameters.add(kotlinTypeParameterMetadata);
            return new TypeParameterReader(kotlinTypeParameterMetadata);
        }

        @Override
        public KmTypeVisitor visitUnderlyingType(int flags) {
            KotlinTypeMetadata underlyingType;
            this.kotlinTypeAliasMetadata.underlyingType = underlyingType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(underlyingType);
        }

        @Override
        public KmTypeVisitor visitExpandedType(int flags) {
            KotlinTypeMetadata expandedType;
            this.kotlinTypeAliasMetadata.expandedType = expandedType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(expandedType);
        }

        @Override
        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinTypeAliasMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        @Override
        public void visitEnd() {
            this.kotlinTypeAliasMetadata.annotations = KotlinMetadataInitializer.trimmed(this.annotations);
            this.kotlinTypeAliasMetadata.typeParameters = KotlinMetadataInitializer.trimmed(this.typeParameters);
        }
    }

    private class PropertyReader
    extends KmPropertyVisitor {
        private final KotlinPropertyMetadata kotlinPropertyMetadata;
        private final ArrayList<KotlinValueParameterMetadata> setterParameters;
        private final ArrayList<KotlinTypeParameterMetadata> typeParameters;

        PropertyReader(KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kotlinPropertyMetadata = kotlinPropertyMetadata;
            this.setterParameters = new ArrayList(4);
            this.typeParameters = new ArrayList(1);
        }

        @Override
        public KmTypeVisitor visitReceiverParameterType(int flags) {
            KotlinTypeMetadata receiverType;
            this.kotlinPropertyMetadata.receiverType = receiverType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(receiverType);
        }

        @Override
        public KmTypeVisitor visitReturnType(int flags) {
            KotlinTypeMetadata returnType;
            this.kotlinPropertyMetadata.type = returnType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(returnType);
        }

        @Override
        public KmValueParameterVisitor visitSetterParameter(int flags, String name) {
            KotlinValueParameterMetadata valueParameter = new KotlinValueParameterMetadata(KotlinMetadataInitializer.this.convertValueParameterFlags(flags), this.setterParameters.size(), name);
            this.setterParameters.add(valueParameter);
            return new ValueParameterReader(valueParameter);
        }

        @Override
        public KmTypeParameterVisitor visitTypeParameter(int flags, String name, int id, KmVariance variance) {
            KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(KotlinMetadataInitializer.this.convertTypeParameterFlags(flags), name, id, KotlinMetadataInitializer.fromKmVariance(variance));
            this.typeParameters.add(kotlinTypeParameterMetadata);
            return new TypeParameterReader(kotlinTypeParameterMetadata);
        }

        @Override
        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinPropertyMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        @Override
        public KmPropertyExtensionVisitor visitExtensions(KmExtensionType type) {
            return new PropertyExtensionReader();
        }

        @Override
        public void visitEnd() {
            this.kotlinPropertyMetadata.setterParameters = KotlinMetadataInitializer.trimmed(this.setterParameters);
            this.kotlinPropertyMetadata.typeParameters = KotlinMetadataInitializer.trimmed(this.typeParameters);
        }

        private class PropertyExtensionReader
        extends JvmPropertyExtensionVisitor {
            private PropertyExtensionReader() {
            }

            @Override
            public void visit(int jvmFlags, JvmFieldSignature fieldSignature, JvmMethodSignature getterSignature, JvmMethodSignature setterSignature) {
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.backingFieldSignature = KotlinMetadataInitializer.fromKotlinJvmFieldSignature(fieldSignature);
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.getterSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(getterSignature);
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.setterSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(setterSignature);
                KotlinMetadataInitializer.this.setPropertyJvmFlags(((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.flags, jvmFlags);
            }

            @Override
            public void visitSyntheticMethodForAnnotations(JvmMethodSignature jvmMethodSignature) {
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.syntheticMethodForAnnotations = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(jvmMethodSignature);
            }

            @Override
            public void visitSyntheticMethodForDelegate(JvmMethodSignature jvmMethodSignature) {
                ((PropertyReader)PropertyReader.this).kotlinPropertyMetadata.syntheticMethodForDelegate = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(jvmMethodSignature);
            }

            @Override
            public void visitEnd() {
            }
        }
    }

    private class ConstructorReader
    extends KmConstructorVisitor {
        private final boolean hasValidJvmSignature;
        private final KotlinConstructorMetadata kotlinConstructorMetadata;
        private final ArrayList<KotlinValueParameterMetadata> valueParameters;

        ConstructorReader(boolean hasValidJvmSignature, KotlinConstructorMetadata kotlinConstructorMetadata) {
            this.hasValidJvmSignature = hasValidJvmSignature;
            this.kotlinConstructorMetadata = kotlinConstructorMetadata;
            this.valueParameters = new ArrayList(4);
        }

        @Override
        public KmValueParameterVisitor visitValueParameter(int flags, String name) {
            KotlinValueParameterMetadata valueParameter = new KotlinValueParameterMetadata(KotlinMetadataInitializer.this.convertValueParameterFlags(flags), this.valueParameters.size(), name);
            this.valueParameters.add(valueParameter);
            return new ValueParameterReader(valueParameter);
        }

        @Override
        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinConstructorMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        @Override
        public KmConstructorExtensionVisitor visitExtensions(KmExtensionType extensionType) {
            return new ConstructorExtensionReader();
        }

        @Override
        public void visitEnd() {
            this.kotlinConstructorMetadata.valueParameters = KotlinMetadataInitializer.trimmed(this.valueParameters);
        }

        private class ConstructorExtensionReader
        extends JvmConstructorExtensionVisitor {
            private ConstructorExtensionReader() {
            }

            @Override
            public void visit(JvmMethodSignature jvmSignature) {
                if (ConstructorReader.this.hasValidJvmSignature) {
                    ((ConstructorReader)ConstructorReader.this).kotlinConstructorMetadata.jvmSignature = KotlinMetadataInitializer.fromKotlinJvmMethodSignature(jvmSignature);
                }
            }
        }
    }

    private class LambdaReader
    extends KmLambdaVisitor {
        private final KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata;
        private final ArrayList<KotlinFunctionMetadata> functions;

        LambdaReader(KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            this.kotlinSyntheticClassKindMetadata = kotlinSyntheticClassKindMetadata;
            this.functions = new ArrayList(1);
        }

        @Override
        public KmFunctionVisitor visitFunction(int flags, String name) {
            KotlinFunctionMetadata function = new KotlinFunctionMetadata(KotlinMetadataInitializer.this.convertFunctionFlags(flags), name);
            this.functions.add(function);
            return new FunctionReader(function);
        }

        @Override
        public void visitEnd() {
            this.kotlinSyntheticClassKindMetadata.functions = KotlinMetadataInitializer.trimmed(this.functions);
        }
    }

    private class ClassReader
    extends KmClassVisitor {
        private final KotlinClassKindMetadata kotlinClassKindMetadata;
        private final ArrayList<KotlinTypeMetadata> superTypes;
        private final ArrayList<KotlinConstructorMetadata> constructors;
        private final ArrayList<KotlinFunctionMetadata> functions;
        private final ArrayList<KotlinPropertyMetadata> properties;
        private final ArrayList<KotlinPropertyMetadata> localDelegatedProperties;
        private final ArrayList<String> enumEntryNames;
        private final ArrayList<String> nestedClassNames;
        private final ArrayList<String> sealedSubClassNames;
        private final ArrayList<KotlinTypeAliasMetadata> typeAliases;
        private final ArrayList<KotlinTypeParameterMetadata> typeParameters;

        ClassReader(KotlinClassKindMetadata kotlinClassKindMetadata) {
            this.kotlinClassKindMetadata = kotlinClassKindMetadata;
            this.superTypes = new ArrayList(1);
            this.constructors = new ArrayList(4);
            this.enumEntryNames = new ArrayList(4);
            this.nestedClassNames = new ArrayList(1);
            this.sealedSubClassNames = new ArrayList(2);
            this.typeParameters = new ArrayList(2);
            this.properties = new ArrayList(8);
            this.functions = new ArrayList(8);
            this.typeAliases = new ArrayList(2);
            this.localDelegatedProperties = new ArrayList(2);
        }

        @Override
        public void visit(int flags, String className) {
            if (className.startsWith(".")) {
                className = className.substring(1);
            }
            className = className.replace('.', '$');
            this.kotlinClassKindMetadata.flags = this.convertClassFlags(flags);
            this.kotlinClassKindMetadata.className = className;
        }

        @Override
        public KmTypeVisitor visitSupertype(int flags) {
            KotlinTypeMetadata superType = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            this.superTypes.add(superType);
            return new TypeReader(superType);
        }

        @Override
        public void visitCompanionObject(String companionName) {
            this.kotlinClassKindMetadata.companionObjectName = companionName;
        }

        @Override
        public KmConstructorVisitor visitConstructor(int flags) {
            KotlinConstructorMetadata constructor = new KotlinConstructorMetadata(this.convertConstructorFlags(flags));
            this.constructors.add(constructor);
            return new ConstructorReader(!this.kotlinClassKindMetadata.flags.isAnnotationClass, constructor);
        }

        @Override
        public void visitEnumEntry(String enumName) {
            this.enumEntryNames.add(enumName);
        }

        @Override
        public void visitNestedClass(String nestedClassName) {
            this.nestedClassNames.add(nestedClassName);
        }

        @Override
        public void visitSealedSubclass(String subClassName) {
            subClassName = subClassName.replace(".", "$");
            this.sealedSubClassNames.add(subClassName);
        }

        @Override
        public KmTypeParameterVisitor visitTypeParameter(int flags, String parameterName, int id, KmVariance variance) {
            KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(KotlinMetadataInitializer.this.convertTypeParameterFlags(flags), parameterName, id, KotlinMetadataInitializer.fromKmVariance(variance));
            this.typeParameters.add(kotlinTypeParameterMetadata);
            return new TypeParameterReader(kotlinTypeParameterMetadata);
        }

        @Override
        public KmVersionRequirementVisitor visitVersionRequirement() {
            KotlinVersionRequirementMetadata versionReq;
            this.kotlinClassKindMetadata.versionRequirement = versionReq = new KotlinVersionRequirementMetadata();
            return new VersionRequirementReader(versionReq);
        }

        @Override
        public KmFunctionVisitor visitFunction(int flags, String name) {
            KotlinFunctionMetadata function = new KotlinFunctionMetadata(KotlinMetadataInitializer.this.convertFunctionFlags(flags), name);
            this.functions.add(function);
            return new FunctionReader(function);
        }

        @Override
        public KmPropertyVisitor visitProperty(int flags, String name, int getterFlags, int setterFlags) {
            KotlinPropertyMetadata property = new KotlinPropertyMetadata(KotlinMetadataInitializer.this.convertPropertyFlags(flags), name, KotlinMetadataInitializer.this.convertPropertyAccessorFlags(getterFlags), KotlinMetadataInitializer.this.convertPropertyAccessorFlags(setterFlags));
            this.properties.add(property);
            return new PropertyReader(property);
        }

        @Override
        public KmTypeAliasVisitor visitTypeAlias(int flags, String name) {
            KotlinTypeAliasMetadata typeAlias = new KotlinTypeAliasMetadata(KotlinMetadataInitializer.this.convertTypeAliasFlags(flags), name);
            this.typeAliases.add(typeAlias);
            return new TypeAliasReader(typeAlias);
        }

        @Override
        public KmClassExtensionVisitor visitExtensions(KmExtensionType extensionType) {
            return new ClassExtensionReader();
        }

        @Override
        public void visitEnd() {
            this.kotlinClassKindMetadata.superTypes = KotlinMetadataInitializer.trimmed(this.superTypes);
            this.kotlinClassKindMetadata.constructors = KotlinMetadataInitializer.trimmed(this.constructors);
            this.kotlinClassKindMetadata.enumEntryNames = KotlinMetadataInitializer.trimmed(this.enumEntryNames);
            this.kotlinClassKindMetadata.nestedClassNames = KotlinMetadataInitializer.trimmed(this.nestedClassNames);
            this.kotlinClassKindMetadata.sealedSubclassNames = KotlinMetadataInitializer.trimmed(this.sealedSubClassNames);
            this.kotlinClassKindMetadata.typeParameters = KotlinMetadataInitializer.trimmed(this.typeParameters);
            this.kotlinClassKindMetadata.properties = KotlinMetadataInitializer.trimmed(this.properties);
            this.kotlinClassKindMetadata.functions = KotlinMetadataInitializer.trimmed(this.functions);
            this.kotlinClassKindMetadata.typeAliases = KotlinMetadataInitializer.trimmed(this.typeAliases);
            this.kotlinClassKindMetadata.localDelegatedProperties = KotlinMetadataInitializer.trimmed(this.localDelegatedProperties);
        }

        @Override
        public void visitInlineClassUnderlyingPropertyName(String name) {
            this.kotlinClassKindMetadata.underlyingPropertyName = name;
        }

        @Override
        public KmTypeVisitor visitInlineClassUnderlyingType(int flags) {
            KotlinTypeMetadata type;
            this.kotlinClassKindMetadata.underlyingPropertyType = type = new KotlinTypeMetadata(KotlinMetadataInitializer.this.convertTypeFlags(flags));
            return new TypeReader(type);
        }

        private KotlinClassFlags convertClassFlags(int kotlinFlags) {
            KotlinClassFlags flags = new KotlinClassFlags(KotlinMetadataInitializer.this.convertCommonFlags(kotlinFlags), KotlinMetadataInitializer.this.convertVisibilityFlags(kotlinFlags), KotlinMetadataInitializer.this.convertModalityFlags(kotlinFlags));
            flags.isUsualClass = Flag.Class.IS_CLASS.invoke(kotlinFlags);
            flags.isInterface = Flag.Class.IS_INTERFACE.invoke(kotlinFlags);
            flags.isEnumClass = Flag.Class.IS_ENUM_CLASS.invoke(kotlinFlags);
            flags.isEnumEntry = Flag.Class.IS_ENUM_ENTRY.invoke(kotlinFlags);
            flags.isAnnotationClass = Flag.Class.IS_ANNOTATION_CLASS.invoke(kotlinFlags);
            flags.isObject = Flag.Class.IS_OBJECT.invoke(kotlinFlags);
            flags.isCompanionObject = Flag.Class.IS_COMPANION_OBJECT.invoke(kotlinFlags);
            flags.isInner = Flag.Class.IS_INNER.invoke(kotlinFlags);
            flags.isData = Flag.Class.IS_DATA.invoke(kotlinFlags);
            flags.isExternal = Flag.Class.IS_EXTERNAL.invoke(kotlinFlags);
            flags.isExpect = Flag.Class.IS_EXPECT.invoke(kotlinFlags);
            flags.isInline = Flag.Class.IS_INLINE.invoke(kotlinFlags);
            flags.isValue = Flag.Class.IS_VALUE.invoke(kotlinFlags);
            flags.isFun = Flag.Class.IS_FUN.invoke(kotlinFlags);
            return flags;
        }

        private KotlinConstructorFlags convertConstructorFlags(int kotlinFlags) {
            KotlinConstructorFlags flags = new KotlinConstructorFlags(KotlinMetadataInitializer.this.convertCommonFlags(kotlinFlags), KotlinMetadataInitializer.this.convertVisibilityFlags(kotlinFlags));
            flags.isPrimary = Flag.Constructor.IS_PRIMARY.invoke(kotlinFlags);
            flags.isSecondary = this.kotlinClassKindMetadata.mv[0] == 1 && this.kotlinClassKindMetadata.mv[1] == 1 ? !flags.isPrimary : Flag.Constructor.IS_SECONDARY.invoke(kotlinFlags);
            flags.hasNonStableParameterNames = Flag.Constructor.HAS_NON_STABLE_PARAMETER_NAMES.invoke(kotlinFlags);
            return flags;
        }

        private class ClassExtensionReader
        extends JvmClassExtensionVisitor {
            private ClassExtensionReader() {
            }

            @Override
            public void visitAnonymousObjectOriginName(String internalName) {
                ((ClassReader)ClassReader.this).kotlinClassKindMetadata.anonymousObjectOriginName = internalName;
            }

            @Override
            public KmPropertyVisitor visitLocalDelegatedProperty(int flags, String name, int getterFlags, int setterFlags) {
                KotlinPropertyMetadata delegatedProperty = new KotlinPropertyMetadata(KotlinMetadataInitializer.this.convertPropertyFlags(flags), name, KotlinMetadataInitializer.this.convertPropertyAccessorFlags(getterFlags), KotlinMetadataInitializer.this.convertPropertyAccessorFlags(setterFlags));
                ClassReader.this.localDelegatedProperties.add(delegatedProperty);
                return new PropertyReader(delegatedProperty);
            }

            @Override
            public void visitJvmFlags(int flags) {
                KotlinMetadataInitializer.this.setClassJvmFlags(((ClassReader)ClassReader.this).kotlinClassKindMetadata.flags, flags);
            }

            @Override
            public void visitEnd() {
            }
        }
    }

    private static class SimpleKotlinMetadataSetter
    implements ClassVisitor {
        private final KotlinMetadata kmd;

        SimpleKotlinMetadataSetter(KotlinMetadata kmd) {
            this.kmd = kmd;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            programClass.kotlinMetadata = this.kmd;
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            libraryClass.kotlinMetadata = this.kmd;
        }
    }

    public static enum MetadataType {
        k,
        mv,
        d1,
        d2,
        xi,
        xs,
        pn,
        bv;

    }

    private class ArrayElementValueCollector
    implements ElementValueVisitor,
    ConstantVisitor {
        private final MetadataType arrayType;
        private int index;

        ArrayElementValueCollector(MetadataType array) {
            this.arrayType = array;
            this.index = 0;
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
        }

        @Override
        public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
            if (this.arrayType == MetadataType.d1) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).d1[this.index++] = utf8Constant.getString();
            } else if (this.arrayType == MetadataType.d2) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).d2[this.index++] = utf8Constant.getString();
            } else {
                throw new UnsupportedOperationException("Cannot store UTF8Constant in int[]");
            }
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            if (this.arrayType == MetadataType.mv) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).mv[this.index++] = integerConstant.getValue();
            } else if (this.arrayType != MetadataType.bv) {
                throw new UnsupportedOperationException("Cannot store IntegerConstant in String[]");
            }
        }
    }
}

