/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class FileUtils {
    public static String readFile(InputStream is, Charset encoding) throws IOException {
        return FileUtils.readFile(is, encoding, -1L);
    }

    public static String readFile(InputStream is, Charset encoding, long length) throws IOException {
        byte[] bytes;
        if (length < 0L) {
            int numRead;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((numRead = is.read(buffer)) > 0) {
                out.write(buffer, 0, numRead);
            }
            out.close();
            bytes = out.toByteArray();
        } else {
            int offset;
            int numRead;
            bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file");
            }
        }
        if (encoding == null) {
            return new String(bytes);
        }
        return new String(bytes, encoding);
    }
}

