/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.graphics;

import java.util.ArrayList;
import java.util.List;
import org.stathissideris.ditaa.graphics.Diagram;
import org.stathissideris.ditaa.graphics.DiagramComponent;
import org.stathissideris.ditaa.graphics.DiagramShape;
import org.stathissideris.ditaa.text.CellSet;
import org.stathissideris.ditaa.text.TextGrid;

public class CompositeDiagramShape
extends DiagramComponent {
    private static final boolean DEBUG = false;
    private ArrayList<DiagramShape> shapes = new ArrayList();

    public static DiagramComponent createOpenFromBoundaryCells(TextGrid grid, CellSet boundaryCells, int cellWidth, int cellHeight, boolean allRound) {
        if (boundaryCells.getType(grid) != 1) {
            throw new IllegalArgumentException("This shape is closed and cannot be handled by this method");
        }
        if (boundaryCells.size() == 0) {
            return null;
        }
        CompositeDiagramShape compositeShape = new CompositeDiagramShape();
        TextGrid workGrid = new TextGrid(grid.getWidth(), grid.getHeight());
        grid.copyCellsTo(boundaryCells, workGrid);
        CellSet visitedCells = new CellSet();
        ArrayList<DiagramShape> shapes = new ArrayList<DiagramShape>(100);
        for (TextGrid.Cell cell : boundaryCells) {
            if (!workGrid.isLinesEnd(cell)) continue;
            CellSet nextCells = workGrid.followCell(cell);
            shapes.addAll(CompositeDiagramShape.growEdgesFromCell(workGrid, cellWidth, cellHeight, allRound, nextCells.getFirst(), cell, visitedCells));
            break;
        }
        boolean dashedShapeExists = false;
        for (DiagramShape shape : shapes) {
            if (!shape.isStrokeDashed()) continue;
            dashedShapeExists = true;
        }
        for (DiagramShape shape : shapes) {
            if (dashedShapeExists) {
                shape.setStrokeDashed(true);
            }
            compositeShape.addToShapes(shape);
        }
        return compositeShape;
    }

    private static List<DiagramShape> growEdgesFromCell(TextGrid workGrid, int cellWidth, int cellHeight, boolean allRound, TextGrid.Cell cell, TextGrid.Cell previousCell, CellSet visitedCells) {
        ArrayList<DiagramShape> result = new ArrayList<DiagramShape>(50);
        visitedCells.add(previousCell);
        DiagramShape shape = new DiagramShape();
        shape.addToPoints(CompositeDiagramShape.makePointForCell(previousCell, workGrid, cellWidth, cellHeight, allRound));
        if (workGrid.cellContainsDashedLineChar(previousCell)) {
            shape.setStrokeDashed(true);
        }
        boolean finished = false;
        while (!finished) {
            CellSet nextCells;
            visitedCells.add(cell);
            if (workGrid.isPointCell(cell)) {
                shape.addToPoints(CompositeDiagramShape.makePointForCell(cell, workGrid, cellWidth, cellHeight, allRound));
            }
            if (workGrid.cellContainsDashedLineChar(cell)) {
                shape.setStrokeDashed(true);
            }
            if (workGrid.isLinesEnd(cell)) {
                finished = true;
            }
            if ((nextCells = workGrid.followCell(cell, previousCell)).size() == 1) {
                previousCell = cell;
                cell = nextCells.getFirst();
                continue;
            }
            if (nextCells.size() <= 1 && nextCells.size() != 0) continue;
            finished = true;
            for (TextGrid.Cell nextCell : nextCells) {
                result.addAll(CompositeDiagramShape.growEdgesFromCell(workGrid, cellWidth, cellHeight, allRound, nextCell, cell, visitedCells));
            }
        }
        result.add(shape);
        return result;
    }

    public void connectEndsToAnchors(TextGrid grid, Diagram diagram) {
        for (DiagramShape shape : this.shapes) {
            if (shape.isClosed()) continue;
            shape.connectEndsToAnchors(grid, diagram);
        }
    }

    public void addToShapes(DiagramShape shape) {
        this.shapes.add(shape);
    }

    public ArrayList<DiagramShape> getShapes() {
        return this.shapes;
    }
}

