%define     req_libvirt_version 1.2.8

%if 0%{?suse_version}
%define     php_confdir %{_sysconfdir}/php5/conf.d
%define     php_extdir  %{_libdir}/php5/extensions
%else
%define     php_confdir %{_sysconfdir}/php.d
%define     php_extdir  %{_libdir}/php/modules
%endif

Name:       libvirt-php
Version:    0.5.8
Release:    1%{?dist}%{?extra_release}
Summary:    PHP language binding for Libvirt

%if 0%{?suse_version}
Group:      Development/Libraries/PHP
%else
Group:      Development/Libraries
%endif
License:    PHP
URL:        https://php.libvirt.org
Source0:    https://download.libvirt.org/php/libvirt-php-%{version}.tar.xz
BuildRoot:  %{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires:  php-devel
BuildRequires:  libvirt-devel >= %{req_libvirt_version}
BuildRequires:  libxml2-devel
BuildRequires:  libxslt
%if 0%{?suse_version}
BuildRequires:  xhtml-dtd
%else
BuildRequires:  xhtml1-dtds
%endif
%if 0%{?suse_version}
Requires:   php5
%else
Requires:   php
%endif

%description
PHP language bindings for Libvirt API.
For more details see: https://php.libvirt.org/

%package -n libvirt-php-doc
Summary:    Document of libvirt-php
Group:      Development/Libraries/PHP
BuildArch:  noarch
Requires:   libvirt-php = %{version}

%description -n libvirt-php-doc
PHP language bindings for Libvirt API.
For more details see: https://php.libvirt.org/ http://www.php.net/

This package contain the document for libvirt-php.

%prep
%setup -q -n libvirt-php-%{version}

%build
%configure --with-html-dir=%{_datadir}/doc \
           --with-html-subdir=%{name}-%{version}/html \
           --with-php-extensiondir=%{php_extdir} \
           --with-php-confdir=%{php_confdir}
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}
rm -f ${RPM_BUILD_ROOT}%{php_extdir}/*.la

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{php_extdir}/libvirt-php.so
%config(noreplace) %{php_confdir}/libvirt-php.ini

%files -n libvirt-php-doc
%defattr(-,root,root)
%doc
%dir %{_datadir}/doc/%{name}-%{version}
%{_datadir}/doc/%{name}-%{version}/html

%changelog
