/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.cache.Cache;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.internal.CacheAccessSerializer;
import org.gradle.cache.internal.MapBackedCache;
import org.gradle.internal.file.Chmod;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.PersistentDaemonRegistry;

public class DaemonRegistryServices {
    private final File daemonBaseDir;
    private final Cache<File, DaemonRegistry> daemonRegistryCache;
    private static final Map<File, DaemonRegistry> REGISTRY_STORAGE = new HashMap<File, DaemonRegistry>();
    private static final Cache<File, DaemonRegistry> REGISTRY_CACHE = new CacheAccessSerializer((Cache)new MapBackedCache(REGISTRY_STORAGE));

    public DaemonRegistryServices(File daemonBaseDir) {
        this(daemonBaseDir, REGISTRY_CACHE);
    }

    DaemonRegistryServices(File daemonBaseDir, Cache<File, DaemonRegistry> daemonRegistryCache) {
        this.daemonBaseDir = daemonBaseDir;
        this.daemonRegistryCache = daemonRegistryCache;
    }

    DaemonDir createDaemonDir() {
        return new DaemonDir(this.daemonBaseDir);
    }

    DaemonRegistry createDaemonRegistry(DaemonDir daemonDir, FileLockManager fileLockManager, Chmod chmod) {
        File daemonRegistryFile = daemonDir.getRegistry();
        return (DaemonRegistry)this.daemonRegistryCache.get((Object)daemonRegistryFile, () -> new PersistentDaemonRegistry(daemonRegistryFile, fileLockManager, chmod));
    }

    Properties createProperties() {
        return System.getProperties();
    }
}

