/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContextForProvider;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.PersistentImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u009d\u0001\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\u0006\u0010\u001b\u001a\u00020\u0015\u0012\u0006\u0010\u001c\u001a\u00020\u0015\u0012\u0006\u0010\u001d\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u001eJ\u0010\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0011H\u0016J\u0010\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u000bH\u0016J\u0010\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u0013H\u0016J\u0010\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u000fH\u0016J\u001e\u00108\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010:2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030<H\u0016J\u0010\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\rH\u0016J.\u0010?\u001a\u00020\u00012\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001a0A2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020CH\u0016J\b\u0010E\u001a\u00020CH\u0016J\b\u0010F\u001a\u00020CH\u0016J\b\u0010G\u001a\u00020CH\u0016J\b\u0010H\u001a\u00020\u0001H\u0016J\u0010\u0010I\u001a\u00020\u00012\u0006\u0010J\u001a\u00020\u0017H\u0016J\b\u0010K\u001a\u00020\u0001H\u0016J\u0010\u0010L\u001a\u00020\u00012\u0006\u0010J\u001a\u00020\u0017H\u0016R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010 R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010*\"\u0004\b+\u0010,R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010 R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006M"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/MutableCheckerContext;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextForProvider;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "(Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;)V", "implicitReceiverStack", "Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "qualifiedAccessOrAssignmentsOrAnnotationCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getClassCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "annotationContainers", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "containingElements", "Lorg/jetbrains/kotlin/fir/FirElement;", "isContractBody", "", "containingFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "suppressedDiagnostics", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentSet;", "", "allInfosSuppressed", "allWarningsSuppressed", "allErrorsSuppressed", "(Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;Lkotlinx/collections/immutable/PersistentSet;ZZZ)V", "getAnnotationContainers", "()Ljava/util/List;", "getContainingDeclarations", "getContainingElements", "getContainingFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "setContainingFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "getGetClassCalls", "getImplicitReceiverStack", "()Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;", "()Z", "setContractBody", "(Z)V", "getQualifiedAccessOrAssignmentsOrAnnotationCalls", "getSuppressedDiagnostics", "()Lkotlinx/collections/immutable/PersistentSet;", "addAnnotationContainer", "annotationContainer", "addDeclaration", "declaration", "addElement", "element", "addGetClassCall", "getClassCall", "addImplicitReceiver", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "addQualifiedAccessOrAnnotationCall", "qualifiedAccessOrAnnotationCall", "addSuppressedDiagnostics", "diagnosticNames", "", "dropAnnotationContainer", "", "dropDeclaration", "dropElement", "dropGetClassCall", "dropQualifiedAccessOrAnnotationCall", "enterContractBody", "enterFile", "file", "exitContractBody", "exitFile", "checkers"})
public final class MutableCheckerContext
extends CheckerContextForProvider {
    @NotNull
    private final PersistentImplicitReceiverStack implicitReceiverStack;
    @NotNull
    private final List<FirDeclaration> containingDeclarations;
    @NotNull
    private final List<FirStatement> qualifiedAccessOrAssignmentsOrAnnotationCalls;
    @NotNull
    private final List<FirGetClassCall> getClassCalls;
    @NotNull
    private final List<FirAnnotationContainer> annotationContainers;
    @NotNull
    private final List<FirElement> containingElements;
    private boolean isContractBody;
    @Nullable
    private FirFile containingFile;
    @NotNull
    private final PersistentSet<String> suppressedDiagnostics;

    private MutableCheckerContext(PersistentImplicitReceiverStack implicitReceiverStack, List<FirDeclaration> containingDeclarations, List<FirStatement> qualifiedAccessOrAssignmentsOrAnnotationCalls, List<FirGetClassCall> getClassCalls, List<FirAnnotationContainer> annotationContainers, List<FirElement> containingElements, boolean isContractBody, FirFile containingFile, SessionHolder sessionHolder, ReturnTypeCalculator returnTypeCalculator, PersistentSet<String> suppressedDiagnostics, boolean allInfosSuppressed, boolean allWarningsSuppressed, boolean allErrorsSuppressed) {
        super(sessionHolder, returnTypeCalculator, allInfosSuppressed, allWarningsSuppressed, allErrorsSuppressed);
        this.implicitReceiverStack = implicitReceiverStack;
        this.containingDeclarations = containingDeclarations;
        this.qualifiedAccessOrAssignmentsOrAnnotationCalls = qualifiedAccessOrAssignmentsOrAnnotationCalls;
        this.getClassCalls = getClassCalls;
        this.annotationContainers = annotationContainers;
        this.containingElements = containingElements;
        this.isContractBody = isContractBody;
        this.containingFile = containingFile;
        this.suppressedDiagnostics = suppressedDiagnostics;
    }

    @Override
    @NotNull
    public PersistentImplicitReceiverStack getImplicitReceiverStack() {
        return this.implicitReceiverStack;
    }

    @Override
    @NotNull
    public List<FirDeclaration> getContainingDeclarations() {
        return this.containingDeclarations;
    }

    @Override
    @NotNull
    public List<FirStatement> getQualifiedAccessOrAssignmentsOrAnnotationCalls() {
        return this.qualifiedAccessOrAssignmentsOrAnnotationCalls;
    }

    @Override
    @NotNull
    public List<FirGetClassCall> getGetClassCalls() {
        return this.getClassCalls;
    }

    @Override
    @NotNull
    public List<FirAnnotationContainer> getAnnotationContainers() {
        return this.annotationContainers;
    }

    @Override
    @NotNull
    public List<FirElement> getContainingElements() {
        return this.containingElements;
    }

    @Override
    public boolean isContractBody() {
        return this.isContractBody;
    }

    public void setContractBody(boolean bl) {
        this.isContractBody = bl;
    }

    @Override
    @Nullable
    public FirFile getContainingFile() {
        return this.containingFile;
    }

    public void setContainingFile(@Nullable FirFile firFile) {
        this.containingFile = firFile;
    }

    @NotNull
    public PersistentSet<String> getSuppressedDiagnostics() {
        return this.suppressedDiagnostics;
    }

    public MutableCheckerContext(@NotNull SessionHolder sessionHolder, @NotNull ReturnTypeCalculator returnTypeCalculator) {
        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
        Intrinsics.checkNotNullParameter((Object)returnTypeCalculator, (String)"returnTypeCalculator");
        this(new PersistentImplicitReceiverStack(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), false, null, sessionHolder, returnTypeCalculator, ExtensionsKt.persistentSetOf(), false, false, false);
    }

    @Override
    @NotNull
    public MutableCheckerContext addImplicitReceiver(@Nullable Name name2, @NotNull ImplicitReceiverValue<?> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return new MutableCheckerContext(PersistentImplicitReceiverStack.add$default(this.getImplicitReceiverStack(), name2, value2, null, 4, null), this.getContainingDeclarations(), this.getQualifiedAccessOrAssignmentsOrAnnotationCalls(), this.getGetClassCalls(), this.getAnnotationContainers(), this.getContainingElements(), this.isContractBody(), this.getContainingFile(), this.getSessionHolder(), this.getReturnTypeCalculator(), (PersistentSet<String>)this.getSuppressedDiagnostics(), this.getAllInfosSuppressed(), this.getAllWarningsSuppressed(), this.getAllErrorsSuppressed());
    }

    @Override
    @NotNull
    public MutableCheckerContext addDeclaration(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.getContainingDeclarations().add(declaration);
        return this;
    }

    @Override
    public void dropDeclaration() {
        CollectionsKt.removeLast(this.getContainingDeclarations());
    }

    @Override
    @NotNull
    public MutableCheckerContext addQualifiedAccessOrAnnotationCall(@NotNull FirStatement qualifiedAccessOrAnnotationCall) {
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessOrAnnotationCall, (String)"qualifiedAccessOrAnnotationCall");
        this.getQualifiedAccessOrAssignmentsOrAnnotationCalls().add(qualifiedAccessOrAnnotationCall);
        return this;
    }

    @Override
    public void dropQualifiedAccessOrAnnotationCall() {
        CollectionsKt.removeLast(this.getQualifiedAccessOrAssignmentsOrAnnotationCalls());
    }

    @Override
    @NotNull
    public MutableCheckerContext addGetClassCall(@NotNull FirGetClassCall getClassCall) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        this.getGetClassCalls().add(getClassCall);
        return this;
    }

    @Override
    public void dropGetClassCall() {
        CollectionsKt.removeLast(this.getGetClassCalls());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addAnnotationContainer(@NotNull FirAnnotationContainer annotationContainer) {
        Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
        this.getAnnotationContainers().add(annotationContainer);
        return this;
    }

    @Override
    public void dropAnnotationContainer() {
        CollectionsKt.removeLast(this.getAnnotationContainers());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addElement(@NotNull FirElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean bl2 = bl = CollectionsKt.lastOrNull(this.getContainingElements()) != element;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.getContainingElements().add(element);
        return this;
    }

    @Override
    public void dropElement() {
        CollectionsKt.removeLast(this.getContainingElements());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addSuppressedDiagnostics(@NotNull Collection<String> diagnosticNames, boolean allInfosSuppressed, boolean allWarningsSuppressed, boolean allErrorsSuppressed) {
        Intrinsics.checkNotNullParameter(diagnosticNames, (String)"diagnosticNames");
        if (diagnosticNames.isEmpty()) {
            return this;
        }
        return new MutableCheckerContext(this.getImplicitReceiverStack(), this.getContainingDeclarations(), this.getQualifiedAccessOrAssignmentsOrAnnotationCalls(), this.getGetClassCalls(), this.getAnnotationContainers(), this.getContainingElements(), this.isContractBody(), this.getContainingFile(), this.getSessionHolder(), this.getReturnTypeCalculator(), this.getSuppressedDiagnostics().addAll(diagnosticNames), this.getAllInfosSuppressed() || allInfosSuppressed, this.getAllWarningsSuppressed() || allWarningsSuppressed, this.getAllErrorsSuppressed() || allErrorsSuppressed);
    }

    @Override
    @NotNull
    public CheckerContextForProvider enterContractBody() {
        if (!(!this.isContractBody())) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        this.setContractBody(true);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider exitContractBody() {
        if (!this.isContractBody()) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        this.setContractBody(false);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider enterFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.setContainingFile(file2);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider exitFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.setContainingFile(file2);
        return this;
    }
}

