/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	context "context"

	certmanagerv1 "github.com/cert-manager/cert-manager/pkg/apis/certmanager/v1"
	scheme "github.com/cert-manager/cert-manager/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ClusterIssuersGetter has a method to return a ClusterIssuerInterface.
// A group's client should implement this interface.
type ClusterIssuersGetter interface {
	ClusterIssuers() ClusterIssuerInterface
}

// ClusterIssuerInterface has methods to work with ClusterIssuer resources.
type ClusterIssuerInterface interface {
	Create(ctx context.Context, clusterIssuer *certmanagerv1.ClusterIssuer, opts metav1.CreateOptions) (*certmanagerv1.ClusterIssuer, error)
	Update(ctx context.Context, clusterIssuer *certmanagerv1.ClusterIssuer, opts metav1.UpdateOptions) (*certmanagerv1.ClusterIssuer, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, clusterIssuer *certmanagerv1.ClusterIssuer, opts metav1.UpdateOptions) (*certmanagerv1.ClusterIssuer, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*certmanagerv1.ClusterIssuer, error)
	List(ctx context.Context, opts metav1.ListOptions) (*certmanagerv1.ClusterIssuerList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *certmanagerv1.ClusterIssuer, err error)
	ClusterIssuerExpansion
}

// clusterIssuers implements ClusterIssuerInterface
type clusterIssuers struct {
	*gentype.ClientWithList[*certmanagerv1.ClusterIssuer, *certmanagerv1.ClusterIssuerList]
}

// newClusterIssuers returns a ClusterIssuers
func newClusterIssuers(c *CertmanagerV1Client) *clusterIssuers {
	return &clusterIssuers{
		gentype.NewClientWithList[*certmanagerv1.ClusterIssuer, *certmanagerv1.ClusterIssuerList](
			"clusterissuers",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *certmanagerv1.ClusterIssuer { return &certmanagerv1.ClusterIssuer{} },
			func() *certmanagerv1.ClusterIssuerList { return &certmanagerv1.ClusterIssuerList{} },
		),
	}
}
