   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.40  05/29/19            */
   /*                                                     */
   /*              FACT FUNCTIONS HEADER FILE             */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.23: Correction for FalseSymbol/TrueSymbol. DR0859  */
/*                                                           */
/*            Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*      6.24: Added ppfact function.                         */
/*                                                           */
/*      6.30: Support for long long integers.                */
/*                                                           */
/*            Removed conditional code for unsupported       */
/*            compilers/operating systems (IBM_MCW,          */
/*            MAC_MCW, and IBM_TBC).                         */
/*                                                           */
/*            Added const qualifiers to remove C++           */
/*            deprecation warnings.                          */
/*                                                           */
/*            Converted API macros to function calls.        */
/*                                                           */
/*      6.40: Removed LOCALE definition.                     */
/*                                                           */
/*            Pragma once and other inclusion changes.       */
/*                                                           */
/*            Added support for booleans with <stdbool.h>.   */
/*                                                           */
/*            Removed use of void pointers for specific      */
/*            data structures.                               */
/*                                                           */
/*            UDF redesign.                                  */
/*                                                           */
/*            Added fact-addressp function.                  */
/*                                                           */
/*************************************************************/

#ifndef _H_factfun

#pragma once

#define _H_factfun

#include "factmngr.h"

   void                           FactFunctionDefinitions(Environment *);
   void                           FactRelationFunction(Environment *,UDFContext *,UDFValue *);
   CLIPSLexeme                   *FactRelation(Fact *);
   Deftemplate                   *FactDeftemplate(Fact *);
   void                           FactExistpFunction(Environment *,UDFContext *,UDFValue *);
   bool                           FactExistp(Fact *);
   void                           FactSlotValueFunction(Environment *,UDFContext *,UDFValue *);
   void                           FactSlotValue(Environment *,Fact *,const char *,CLIPSValue *);
   void                           FactSlotNamesFunction(Environment *,UDFContext *,UDFValue *);
   void                           FactSlotNames(Fact *,CLIPSValue *);
   void                           GetFactListFunction(Environment *,UDFContext *,UDFValue *);
   void                           GetFactList(Environment *,CLIPSValue *,Defmodule *);
   void                           PPFactFunction(Environment *,UDFContext *,UDFValue *);
   void                           PPFact(Fact *,const char *,bool);
   Fact                          *GetFactAddressOrIndexArgument(UDFContext *,bool);
   void                           FactAddresspFunction(Environment *,UDFContext *,UDFValue *);

#endif /* _H_factfun */
