#!/bin/bash
#
# Oracle Linux DTrace.
# Copyright (c) 2006, 2021, Oracle and/or its affiliates. All rights reserved.
# Licensed under the Universal Permissive License v 1.0 as shown at
# http://oss.oracle.com/licenses/upl.

##
#
# ASSERTION:
# The -Z option can be used to permit descriptions that match
# zero probes.
#
# SECTION: dtrace Utility/-Z Option;
# 	dtrace Utility/-P Option
#
##

if [ $# != 1 ]; then
	echo expected one argument: '<'dtrace-path'>'
	exit 2
fi

dtrace=$1

$dtrace $dt_flags -qZP wassup'{printf("Iamkool");}' \
-qP profile'{printf("I am done\n"); exit(0);}' | uniq

status=$?

if [ "$status" -ne 0 ]; then
	echo $tst: dtrace failed
fi

exit $status
