//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallDelete.json
func ExampleAzureFirewallsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginDelete(ctx, "rg1", "azurefirewall", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallGet.json
func ExampleAzureFirewallsClient_Get_getAzureFirewall() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureFirewallsClient().Get(ctx, "rg1", "azurefirewall", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				IPGroups: []*armnetwork.AzureFirewallIPGroups{
	// 				},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																			},
	// 																		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallGetWithAdditionalProperties.json
func ExampleAzureFirewallsClient_Get_getAzureFirewallWithAdditionalProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureFirewallsClient().Get(ctx, "rg1", "azurefirewall", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 			"key1": to.Ptr("value1"),
	// 			"key2": to.Ptr("value2"),
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																			},
	// 																		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallGetWithIpGroups.json
func ExampleAzureFirewallsClient_Get_getAzureFirewallWithIpGroups() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureFirewallsClient().Get(ctx, "rg1", "azurefirewall", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceIPGroups: []*string{
	// 								to.Ptr("/subscriptions/subId/providers/Microsoft.Network/resourceGroup/myResourceGroup/ipGroups/ipGroups1")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				IPGroups: []*armnetwork.AzureFirewallIPGroups{
	// 					{
	// 						ChangeNumber: to.Ptr("5"),
	// 						ID: to.Ptr("/subscriptions/subId/providers/Microsoft.Network/resourceGroup/myResourceGroup/ipGroups/ipGroups1"),
	// 					},
	// 					{
	// 						ChangeNumber: to.Ptr("4"),
	// 						ID: to.Ptr("/subscriptions/subId/providers/Microsoft.Network/resourceGroup/myResourceGroup/ipGroups/ipGroups2"),
	// 					},
	// 					{
	// 						ChangeNumber: to.Ptr("1"),
	// 						ID: to.Ptr("/subscriptions/subId/providers/Microsoft.Network/resourceGroup/myResourceGroup/ipGroups/ipGroups3"),
	// 				}},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceIPGroups: []*string{
	// 																	to.Ptr("/subscriptions/subId/providers/Microsoft.Network/resourceGroup/myResourceGroup/ipGroups/ipGroups1")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationIPGroups: []*string{
	// 																		to.Ptr("/subscriptions/subId/providers/Microsoft.Network/resourceGroup/myResourceGroup/ipGroups/ipGroups2")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceIPGroups: []*string{
	// 																									to.Ptr("/subscriptions/subId/providers/Microsoft.Network/resourceGroup/myResourceGroup/ipGroups/ipGroups3")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																			},
	// 																		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallGetWithZones.json
func ExampleAzureFirewallsClient_Get_getAzureFirewallWithZones() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureFirewallsClient().Get(ctx, "rg1", "azurefirewall", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US 2"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				IPGroups: []*armnetwork.AzureFirewallIPGroups{
	// 				},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																				to.Ptr("1"),
	// 																				to.Ptr("2"),
	// 																				to.Ptr("3")},
	// 																			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallGetWithMgmtSubnet.json
func ExampleAzureFirewallsClient_Get_getAzureFirewallWithManagementSubnet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAzureFirewallsClient().Get(ctx, "rg1", "azurefirewall", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				ManagementIPConfiguration: &armnetwork.AzureFirewallIPConfiguration{
	// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewallgw/ipConfigurations/azureFirewallMgmtIpConfiguration"),
	// 					Name: to.Ptr("azureFirewallMgmtIpConfiguration"),
	// 					Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 					Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 						PublicIPAddress: &armnetwork.SubResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName"),
	// 						},
	// 						Subnet: &armnetwork.SubResource{
	// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"),
	// 						},
	// 					},
	// 				},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																			},
	// 																		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallPut.json
func ExampleAzureFirewallsClient_BeginCreateOrUpdate_createAzureFirewall() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginCreateOrUpdate(ctx, "rg1", "azurefirewall", armnetwork.AzureFirewall{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armnetwork.AzureFirewallPropertiesFormat{
			ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
				{
					Name: to.Ptr("apprulecoll"),
					Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](110),
						Rules: []*armnetwork.AzureFirewallApplicationRule{
							{
								Name:        to.Ptr("rule1"),
								Description: to.Ptr("Deny inbound rule"),
								Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
									{
										Port:         to.Ptr[int32](443),
										ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
									}},
								SourceAddresses: []*string{
									to.Ptr("216.58.216.164"),
									to.Ptr("10.0.0.0/24")},
								TargetFqdns: []*string{
									to.Ptr("www.test.com")},
							}},
					},
				}},
			IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
				{
					Name: to.Ptr("azureFirewallIpConfiguration"),
					Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
						PublicIPAddress: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
						},
						Subnet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
						},
					},
				}},
			NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
				{
					Name: to.Ptr("natrulecoll"),
					Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
						Action: &armnetwork.AzureFirewallNatRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNatRule{
							{
								Name:        to.Ptr("DNAT-HTTPS-traffic"),
								Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedAddress: to.Ptr("1.2.3.5"),
								TranslatedPort:    to.Ptr("8443"),
							},
							{
								Name:        to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
								Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("80")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedFqdn: to.Ptr("internalhttpserver"),
								TranslatedPort: to.Ptr("880"),
							}},
					},
				}},
			NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
				{
					Name: to.Ptr("netrulecoll"),
					Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNetworkRule{
							{
								Name:        to.Ptr("L4-traffic"),
								Description: to.Ptr("Block traffic based on source IPs and ports"),
								DestinationAddresses: []*string{
									to.Ptr("*")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("192.168.1.1-192.168.1.12"),
									to.Ptr("10.1.4.12-10.1.4.255")},
							},
							{
								Name:        to.Ptr("L4-traffic-with-FQDN"),
								Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
								DestinationFqdns: []*string{
									to.Ptr("www.amazon.com")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("10.2.4.12-10.2.4.255")},
							}},
					},
				}},
			SKU: &armnetwork.AzureFirewallSKU{
				Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
				Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
			},
			ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
		},
		Zones: []*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				IPGroups: []*armnetwork.AzureFirewallIPGroups{
	// 				},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																			},
	// 																		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallPutWithAdditionalProperties.json
func ExampleAzureFirewallsClient_BeginCreateOrUpdate_createAzureFirewallWithAdditionalProperties() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginCreateOrUpdate(ctx, "rg1", "azurefirewall", armnetwork.AzureFirewall{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armnetwork.AzureFirewallPropertiesFormat{
			AdditionalProperties: map[string]*string{
				"key1": to.Ptr("value1"),
				"key2": to.Ptr("value2"),
			},
			ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
				{
					Name: to.Ptr("apprulecoll"),
					Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](110),
						Rules: []*armnetwork.AzureFirewallApplicationRule{
							{
								Name:        to.Ptr("rule1"),
								Description: to.Ptr("Deny inbound rule"),
								Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
									{
										Port:         to.Ptr[int32](443),
										ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
									}},
								SourceAddresses: []*string{
									to.Ptr("216.58.216.164"),
									to.Ptr("10.0.0.0/24")},
								TargetFqdns: []*string{
									to.Ptr("www.test.com")},
							}},
					},
				}},
			IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
				{
					Name: to.Ptr("azureFirewallIpConfiguration"),
					Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
						PublicIPAddress: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
						},
						Subnet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
						},
					},
				}},
			IPGroups: []*armnetwork.AzureFirewallIPGroups{},
			NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
				{
					Name: to.Ptr("natrulecoll"),
					Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
						Action: &armnetwork.AzureFirewallNatRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNatRule{
							{
								Name:        to.Ptr("DNAT-HTTPS-traffic"),
								Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedAddress: to.Ptr("1.2.3.5"),
								TranslatedPort:    to.Ptr("8443"),
							},
							{
								Name:        to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
								Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("80")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedFqdn: to.Ptr("internalhttpserver"),
								TranslatedPort: to.Ptr("880"),
							}},
					},
				}},
			NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
				{
					Name: to.Ptr("netrulecoll"),
					Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNetworkRule{
							{
								Name:        to.Ptr("L4-traffic"),
								Description: to.Ptr("Block traffic based on source IPs and ports"),
								DestinationAddresses: []*string{
									to.Ptr("*")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("192.168.1.1-192.168.1.12"),
									to.Ptr("10.1.4.12-10.1.4.255")},
							},
							{
								Name:        to.Ptr("L4-traffic-with-FQDN"),
								Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
								DestinationFqdns: []*string{
									to.Ptr("www.amazon.com")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("10.2.4.12-10.2.4.255")},
							}},
					},
				}},
			SKU: &armnetwork.AzureFirewallSKU{
				Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
				Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
			},
			ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
		},
		Zones: []*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 			"key1": to.Ptr("value1"),
	// 			"key2": to.Ptr("value2"),
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																			},
	// 																		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallPutWithIpGroups.json
func ExampleAzureFirewallsClient_BeginCreateOrUpdate_createAzureFirewallWithIpGroups() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginCreateOrUpdate(ctx, "rg1", "azurefirewall", armnetwork.AzureFirewall{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armnetwork.AzureFirewallPropertiesFormat{
			ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
				{
					Name: to.Ptr("apprulecoll"),
					Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](110),
						Rules: []*armnetwork.AzureFirewallApplicationRule{
							{
								Name:        to.Ptr("rule1"),
								Description: to.Ptr("Deny inbound rule"),
								Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
									{
										Port:         to.Ptr[int32](443),
										ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
									}},
								SourceAddresses: []*string{
									to.Ptr("216.58.216.164"),
									to.Ptr("10.0.0.0/24")},
								TargetFqdns: []*string{
									to.Ptr("www.test.com")},
							}},
					},
				}},
			IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
				{
					Name: to.Ptr("azureFirewallIpConfiguration"),
					Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
						PublicIPAddress: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
						},
						Subnet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
						},
					},
				}},
			NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
				{
					Name: to.Ptr("natrulecoll"),
					Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
						Action: &armnetwork.AzureFirewallNatRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNatRule{
							{
								Name:        to.Ptr("DNAT-HTTPS-traffic"),
								Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedAddress: to.Ptr("1.2.3.5"),
								TranslatedPort:    to.Ptr("8443"),
							},
							{
								Name:        to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
								Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("80")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedFqdn: to.Ptr("internalhttpserver"),
								TranslatedPort: to.Ptr("880"),
							}},
					},
				}},
			NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
				{
					Name: to.Ptr("netrulecoll"),
					Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNetworkRule{
							{
								Name:        to.Ptr("L4-traffic"),
								Description: to.Ptr("Block traffic based on source IPs and ports"),
								DestinationAddresses: []*string{
									to.Ptr("*")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("192.168.1.1-192.168.1.12"),
									to.Ptr("10.1.4.12-10.1.4.255")},
							},
							{
								Name:        to.Ptr("L4-traffic-with-FQDN"),
								Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
								DestinationFqdns: []*string{
									to.Ptr("www.amazon.com")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("10.2.4.12-10.2.4.255")},
							}},
					},
				}},
			SKU: &armnetwork.AzureFirewallSKU{
				Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
				Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
			},
			ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
		},
		Zones: []*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																			},
	// 																		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallPutWithZones.json
func ExampleAzureFirewallsClient_BeginCreateOrUpdate_createAzureFirewallWithZones() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginCreateOrUpdate(ctx, "rg1", "azurefirewall", armnetwork.AzureFirewall{
		Location: to.Ptr("West US 2"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armnetwork.AzureFirewallPropertiesFormat{
			ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
				{
					Name: to.Ptr("apprulecoll"),
					Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](110),
						Rules: []*armnetwork.AzureFirewallApplicationRule{
							{
								Name:        to.Ptr("rule1"),
								Description: to.Ptr("Deny inbound rule"),
								Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
									{
										Port:         to.Ptr[int32](443),
										ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
									}},
								SourceAddresses: []*string{
									to.Ptr("216.58.216.164"),
									to.Ptr("10.0.0.0/24")},
								TargetFqdns: []*string{
									to.Ptr("www.test.com")},
							}},
					},
				}},
			IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
				{
					Name: to.Ptr("azureFirewallIpConfiguration"),
					Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
						PublicIPAddress: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
						},
						Subnet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
						},
					},
				}},
			NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
				{
					Name: to.Ptr("natrulecoll"),
					Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
						Action: &armnetwork.AzureFirewallNatRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNatRule{
							{
								Name:        to.Ptr("DNAT-HTTPS-traffic"),
								Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedAddress: to.Ptr("1.2.3.5"),
								TranslatedPort:    to.Ptr("8443"),
							},
							{
								Name:        to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
								Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("80")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedFqdn: to.Ptr("internalhttpserver"),
								TranslatedPort: to.Ptr("880"),
							}},
					},
				}},
			NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
				{
					Name: to.Ptr("netrulecoll"),
					Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNetworkRule{
							{
								Name:        to.Ptr("L4-traffic"),
								Description: to.Ptr("Block traffic based on source IPs and ports"),
								DestinationAddresses: []*string{
									to.Ptr("*")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("192.168.1.1-192.168.1.12"),
									to.Ptr("10.1.4.12-10.1.4.255")},
							},
							{
								Name:        to.Ptr("L4-traffic-with-FQDN"),
								Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
								DestinationFqdns: []*string{
									to.Ptr("www.amazon.com")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("10.2.4.12-10.2.4.255")},
							}},
					},
				}},
			SKU: &armnetwork.AzureFirewallSKU{
				Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
				Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
			},
			ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
		},
		Zones: []*string{
			to.Ptr("1"),
			to.Ptr("2"),
			to.Ptr("3")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US 2"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				IPGroups: []*armnetwork.AzureFirewallIPGroups{
	// 				},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																				to.Ptr("1"),
	// 																				to.Ptr("2"),
	// 																				to.Ptr("3")},
	// 																			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallPutWithMgmtSubnet.json
func ExampleAzureFirewallsClient_BeginCreateOrUpdate_createAzureFirewallWithManagementSubnet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginCreateOrUpdate(ctx, "rg1", "azurefirewall", armnetwork.AzureFirewall{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armnetwork.AzureFirewallPropertiesFormat{
			ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
				{
					Name: to.Ptr("apprulecoll"),
					Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](110),
						Rules: []*armnetwork.AzureFirewallApplicationRule{
							{
								Name:        to.Ptr("rule1"),
								Description: to.Ptr("Deny inbound rule"),
								Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
									{
										Port:         to.Ptr[int32](443),
										ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
									}},
								SourceAddresses: []*string{
									to.Ptr("216.58.216.164"),
									to.Ptr("10.0.0.0/24")},
								TargetFqdns: []*string{
									to.Ptr("www.test.com")},
							}},
					},
				}},
			IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
				{
					Name: to.Ptr("azureFirewallIpConfiguration"),
					Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
						PublicIPAddress: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
						},
						Subnet: &armnetwork.SubResource{
							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
						},
					},
				}},
			ManagementIPConfiguration: &armnetwork.AzureFirewallIPConfiguration{
				Name: to.Ptr("azureFirewallMgmtIpConfiguration"),
				Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
					PublicIPAddress: &armnetwork.SubResource{
						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName"),
					},
					Subnet: &armnetwork.SubResource{
						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"),
					},
				},
			},
			NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
				{
					Name: to.Ptr("natrulecoll"),
					Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
						Action: &armnetwork.AzureFirewallNatRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNatRule{
							{
								Name:        to.Ptr("DNAT-HTTPS-traffic"),
								Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedAddress: to.Ptr("1.2.3.5"),
								TranslatedPort:    to.Ptr("8443"),
							},
							{
								Name:        to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
								Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
								DestinationAddresses: []*string{
									to.Ptr("1.2.3.4")},
								DestinationPorts: []*string{
									to.Ptr("80")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("*")},
								TranslatedFqdn: to.Ptr("internalhttpserver"),
								TranslatedPort: to.Ptr("880"),
							}},
					},
				}},
			NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
				{
					Name: to.Ptr("netrulecoll"),
					Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
						Action: &armnetwork.AzureFirewallRCAction{
							Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
						},
						Priority: to.Ptr[int32](112),
						Rules: []*armnetwork.AzureFirewallNetworkRule{
							{
								Name:        to.Ptr("L4-traffic"),
								Description: to.Ptr("Block traffic based on source IPs and ports"),
								DestinationAddresses: []*string{
									to.Ptr("*")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("192.168.1.1-192.168.1.12"),
									to.Ptr("10.1.4.12-10.1.4.255")},
							},
							{
								Name:        to.Ptr("L4-traffic-with-FQDN"),
								Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
								DestinationFqdns: []*string{
									to.Ptr("www.amazon.com")},
								DestinationPorts: []*string{
									to.Ptr("443-444"),
									to.Ptr("8443")},
								Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
									to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
								SourceAddresses: []*string{
									to.Ptr("10.2.4.12-10.2.4.255")},
							}},
					},
				}},
			SKU: &armnetwork.AzureFirewallSKU{
				Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
				Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
			},
			ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
		},
		Zones: []*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
	// 			{
	// 				Name: to.Ptr("apprulecoll"),
	// 				Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
	// 					Action: &armnetwork.AzureFirewallRCAction{
	// 						Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 					},
	// 					Priority: to.Ptr[int32](110),
	// 					Rules: []*armnetwork.AzureFirewallApplicationRule{
	// 						{
	// 							Name: to.Ptr("rule1"),
	// 							Description: to.Ptr("Deny inbound rule"),
	// 							Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
	// 								{
	// 									Port: to.Ptr[int32](443),
	// 									ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
	// 							}},
	// 							SourceAddresses: []*string{
	// 								to.Ptr("216.58.216.164"),
	// 								to.Ptr("10.0.0.0/24")},
	// 								TargetFqdns: []*string{
	// 									to.Ptr("www.test.com")},
	// 							}},
	// 						},
	// 				}},
	// 				IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
	// 					{
	// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
	// 						Name: to.Ptr("azureFirewallIpConfiguration"),
	// 						Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 						Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
	// 							PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 							PublicIPAddress: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
	// 							},
	// 							Subnet: &armnetwork.SubResource{
	// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
	// 							},
	// 						},
	// 				}},
	// 				NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
	// 					{
	// 						Name: to.Ptr("natrulecoll"),
	// 						Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
	// 							Action: &armnetwork.AzureFirewallNatRCAction{
	// 								Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
	// 							},
	// 							Priority: to.Ptr[int32](112),
	// 							Rules: []*armnetwork.AzureFirewallNatRule{
	// 								{
	// 									Name: to.Ptr("DNAT-HTTPS-traffic"),
	// 									Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
	// 									DestinationAddresses: []*string{
	// 										to.Ptr("1.2.3.4")},
	// 										DestinationPorts: []*string{
	// 											to.Ptr("443")},
	// 											Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 												to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 												SourceAddresses: []*string{
	// 													to.Ptr("*")},
	// 													TranslatedAddress: to.Ptr("1.2.3.5"),
	// 													TranslatedPort: to.Ptr("8443"),
	// 												},
	// 												{
	// 													Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
	// 													Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
	// 													DestinationAddresses: []*string{
	// 														to.Ptr("1.2.3.4")},
	// 														DestinationPorts: []*string{
	// 															to.Ptr("80")},
	// 															Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																SourceAddresses: []*string{
	// 																	to.Ptr("*")},
	// 																	TranslatedFqdn: to.Ptr("internalhttpserver"),
	// 																	TranslatedPort: to.Ptr("880"),
	// 															}},
	// 														},
	// 												}},
	// 												NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
	// 													{
	// 														Name: to.Ptr("netrulecoll"),
	// 														Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
	// 															Action: &armnetwork.AzureFirewallRCAction{
	// 																Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
	// 															},
	// 															Priority: to.Ptr[int32](112),
	// 															Rules: []*armnetwork.AzureFirewallNetworkRule{
	// 																{
	// 																	Name: to.Ptr("L4-traffic"),
	// 																	Description: to.Ptr("Block traffic based on source IPs and ports"),
	// 																	DestinationAddresses: []*string{
	// 																		to.Ptr("*")},
	// 																		DestinationPorts: []*string{
	// 																			to.Ptr("443-444"),
	// 																			to.Ptr("8443")},
	// 																			Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																				to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																				SourceAddresses: []*string{
	// 																					to.Ptr("192.168.1.1-192.168.1.12"),
	// 																					to.Ptr("10.1.4.12-10.1.4.255")},
	// 																				},
	// 																				{
	// 																					Name: to.Ptr("L4-traffic-with-FQDN"),
	// 																					Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
	// 																					DestinationFqdns: []*string{
	// 																						to.Ptr("www.amazon.com")},
	// 																						DestinationPorts: []*string{
	// 																							to.Ptr("443-444"),
	// 																							to.Ptr("8443")},
	// 																							Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
	// 																								to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
	// 																								SourceAddresses: []*string{
	// 																									to.Ptr("10.2.4.12-10.2.4.255")},
	// 																							}},
	// 																						},
	// 																				}},
	// 																				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 																				SKU: &armnetwork.AzureFirewallSKU{
	// 																					Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWVnet),
	// 																					Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 																				},
	// 																				ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 																			},
	// 																			Zones: []*string{
	// 																			},
	// 																		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallPutInHub.json
func ExampleAzureFirewallsClient_BeginCreateOrUpdate_createAzureFirewallInVirtualHub() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginCreateOrUpdate(ctx, "rg1", "azurefirewall", armnetwork.AzureFirewall{
		Location: to.Ptr("West US"),
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
		},
		Properties: &armnetwork.AzureFirewallPropertiesFormat{
			FirewallPolicy: &armnetwork.SubResource{
				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1"),
			},
			HubIPAddresses: &armnetwork.HubIPAddresses{
				PublicIPs: &armnetwork.HubPublicIPAddresses{
					Addresses: []*armnetwork.AzureFirewallPublicIPAddress{},
					Count:     to.Ptr[int32](1),
				},
			},
			SKU: &armnetwork.AzureFirewallSKU{
				Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWHub),
				Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
			},
			ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
			VirtualHub: &armnetwork.SubResource{
				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
			},
		},
		Zones: []*string{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("azurefirewall"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 	},
	// 	Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		AdditionalProperties: map[string]*string{
	// 		},
	// 		FirewallPolicy: &armnetwork.SubResource{
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1"),
	// 		},
	// 		HubIPAddresses: &armnetwork.HubIPAddresses{
	// 			PrivateIPAddress: to.Ptr("10.0.0.0"),
	// 			PublicIPs: &armnetwork.HubPublicIPAddresses{
	// 				Addresses: []*armnetwork.AzureFirewallPublicIPAddress{
	// 					{
	// 						Address: to.Ptr("13.73.240.12"),
	// 				}},
	// 				Count: to.Ptr[int32](1),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		SKU: &armnetwork.AzureFirewallSKU{
	// 			Name: to.Ptr(armnetwork.AzureFirewallSKUNameAZFWHub),
	// 			Tier: to.Ptr(armnetwork.AzureFirewallSKUTierStandard),
	// 		},
	// 		ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 		VirtualHub: &armnetwork.SubResource{
	// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
	// 		},
	// 	},
	// 	Zones: []*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallUpdateTags.json
func ExampleAzureFirewallsClient_BeginUpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginUpdateTags(ctx, "azfwtest", "fw1", armnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AzureFirewall = armnetwork.AzureFirewall{
	// 	Name: to.Ptr("fw1"),
	// 	Type: to.Ptr("Microsoft.Network/azureFirewalls"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/azfwtest/providers/Microsoft.Network/azureFirewalls/fw1"),
	// 	Location: to.Ptr("brazilsouth"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armnetwork.AzureFirewallPropertiesFormat{
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallListByResourceGroup.json
func ExampleAzureFirewallsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAzureFirewallsClient().NewListPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AzureFirewallListResult = armnetwork.AzureFirewallListResult{
		// 	Value: []*armnetwork.AzureFirewall{
		// 		{
		// 			Name: to.Ptr("azurefirewall"),
		// 			Type: to.Ptr("Microsoft.Network/azureFirewalls"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 			},
		// 			Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 			Properties: &armnetwork.AzureFirewallPropertiesFormat{
		// 				AdditionalProperties: map[string]*string{
		// 					"key1": to.Ptr("value1"),
		// 					"key2": to.Ptr("value2"),
		// 				},
		// 				ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
		// 					{
		// 						Name: to.Ptr("apprulecoll"),
		// 						Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
		// 							Action: &armnetwork.AzureFirewallRCAction{
		// 								Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
		// 							},
		// 							Priority: to.Ptr[int32](110),
		// 							Rules: []*armnetwork.AzureFirewallApplicationRule{
		// 								{
		// 									Name: to.Ptr("rule1"),
		// 									Description: to.Ptr("Deny inbound rule"),
		// 									Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
		// 										{
		// 											Port: to.Ptr[int32](443),
		// 											ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
		// 									}},
		// 									SourceAddresses: []*string{
		// 										to.Ptr("216.58.216.164"),
		// 										to.Ptr("10.0.0.0/24")},
		// 										TargetFqdns: []*string{
		// 											to.Ptr("www.test.com")},
		// 									}},
		// 								},
		// 						}},
		// 						IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
		// 								Name: to.Ptr("azureFirewallIpConfiguration"),
		// 								Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 								Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
		// 									PrivateIPAddress: to.Ptr("10.0.0.0"),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 									PublicIPAddress: &armnetwork.SubResource{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
		// 									},
		// 									Subnet: &armnetwork.SubResource{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
		// 									},
		// 								},
		// 						}},
		// 						IPGroups: []*armnetwork.AzureFirewallIPGroups{
		// 						},
		// 						ManagementIPConfiguration: &armnetwork.AzureFirewallIPConfiguration{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewallgw/ipConfigurations/azureFirewallMgmtIpConfiguration"),
		// 							Name: to.Ptr("azureFirewallMgmtIpConfiguration"),
		// 							Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 							Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
		// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								PublicIPAddress: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName"),
		// 								},
		// 								Subnet: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"),
		// 								},
		// 							},
		// 						},
		// 						NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
		// 							{
		// 								Name: to.Ptr("natrulecoll"),
		// 								Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
		// 									Action: &armnetwork.AzureFirewallNatRCAction{
		// 										Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
		// 									},
		// 									Priority: to.Ptr[int32](112),
		// 									Rules: []*armnetwork.AzureFirewallNatRule{
		// 										{
		// 											Name: to.Ptr("DNAT-HTTPS-traffic"),
		// 											Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
		// 											DestinationAddresses: []*string{
		// 												to.Ptr("1.2.3.4")},
		// 												DestinationPorts: []*string{
		// 													to.Ptr("443")},
		// 													Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
		// 														to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
		// 														SourceAddresses: []*string{
		// 															to.Ptr("*")},
		// 															TranslatedAddress: to.Ptr("1.2.3.5"),
		// 															TranslatedPort: to.Ptr("8443"),
		// 														},
		// 														{
		// 															Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
		// 															Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
		// 															DestinationAddresses: []*string{
		// 																to.Ptr("1.2.3.4")},
		// 																DestinationPorts: []*string{
		// 																	to.Ptr("80")},
		// 																	Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
		// 																		to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
		// 																		SourceAddresses: []*string{
		// 																			to.Ptr("*")},
		// 																			TranslatedFqdn: to.Ptr("internalhttpserver"),
		// 																			TranslatedPort: to.Ptr("880"),
		// 																	}},
		// 																},
		// 														}},
		// 														NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
		// 															{
		// 																Name: to.Ptr("netrulecoll"),
		// 																Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
		// 																	Action: &armnetwork.AzureFirewallRCAction{
		// 																		Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
		// 																	},
		// 																	Priority: to.Ptr[int32](112),
		// 																	Rules: []*armnetwork.AzureFirewallNetworkRule{
		// 																		{
		// 																			Name: to.Ptr("L4-traffic"),
		// 																			Description: to.Ptr("Block traffic based on source IPs and ports"),
		// 																			DestinationAddresses: []*string{
		// 																				to.Ptr("*")},
		// 																				DestinationPorts: []*string{
		// 																					to.Ptr("443-444"),
		// 																					to.Ptr("8443")},
		// 																					Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
		// 																						to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
		// 																						SourceAddresses: []*string{
		// 																							to.Ptr("192.168.1.1-192.168.1.12"),
		// 																							to.Ptr("10.1.4.12-10.1.4.255")},
		// 																						},
		// 																						{
		// 																							Name: to.Ptr("L4-traffic-with-FQDN"),
		// 																							Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
		// 																							DestinationFqdns: []*string{
		// 																								to.Ptr("www.amazon.com")},
		// 																								DestinationPorts: []*string{
		// 																									to.Ptr("443-444"),
		// 																									to.Ptr("8443")},
		// 																									Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
		// 																										to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
		// 																										SourceAddresses: []*string{
		// 																											to.Ptr("10.2.4.12-10.2.4.255")},
		// 																									}},
		// 																								},
		// 																						}},
		// 																						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																						ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
		// 																					},
		// 																					Zones: []*string{
		// 																					},
		// 																			}},
		// 																		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallListBySubscription.json
func ExampleAzureFirewallsClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAzureFirewallsClient().NewListAllPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AzureFirewallListResult = armnetwork.AzureFirewallListResult{
		// 	Value: []*armnetwork.AzureFirewall{
		// 		{
		// 			Name: to.Ptr("azurefirewall"),
		// 			Type: to.Ptr("Microsoft.Network/azureFirewalls"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewall"),
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 				"key1": to.Ptr("value1"),
		// 			},
		// 			Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 			Properties: &armnetwork.AzureFirewallPropertiesFormat{
		// 				AdditionalProperties: map[string]*string{
		// 					"key1": to.Ptr("value1"),
		// 					"key2": to.Ptr("value2"),
		// 				},
		// 				ApplicationRuleCollections: []*armnetwork.AzureFirewallApplicationRuleCollection{
		// 					{
		// 						Name: to.Ptr("apprulecoll"),
		// 						Properties: &armnetwork.AzureFirewallApplicationRuleCollectionPropertiesFormat{
		// 							Action: &armnetwork.AzureFirewallRCAction{
		// 								Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
		// 							},
		// 							Priority: to.Ptr[int32](110),
		// 							Rules: []*armnetwork.AzureFirewallApplicationRule{
		// 								{
		// 									Name: to.Ptr("rule1"),
		// 									Description: to.Ptr("Deny inbound rule"),
		// 									Protocols: []*armnetwork.AzureFirewallApplicationRuleProtocol{
		// 										{
		// 											Port: to.Ptr[int32](443),
		// 											ProtocolType: to.Ptr(armnetwork.AzureFirewallApplicationRuleProtocolTypeHTTPS),
		// 									}},
		// 									SourceAddresses: []*string{
		// 										to.Ptr("216.58.216.164"),
		// 										to.Ptr("10.0.0.0/24")},
		// 										TargetFqdns: []*string{
		// 											to.Ptr("www.test.com")},
		// 									}},
		// 								},
		// 						}},
		// 						IPConfigurations: []*armnetwork.AzureFirewallIPConfiguration{
		// 							{
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfirewallgw/ipConfigurations/azureFirewallIpConfiguration"),
		// 								Name: to.Ptr("azureFirewallIpConfiguration"),
		// 								Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 								Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
		// 									PrivateIPAddress: to.Ptr("10.0.0.0"),
		// 									ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 									PublicIPAddress: &armnetwork.SubResource{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
		// 									},
		// 									Subnet: &armnetwork.SubResource{
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
		// 									},
		// 								},
		// 						}},
		// 						IPGroups: []*armnetwork.AzureFirewallIPGroups{
		// 						},
		// 						ManagementIPConfiguration: &armnetwork.AzureFirewallIPConfiguration{
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azurefirewallgw/ipConfigurations/azureFirewallMgmtIpConfiguration"),
		// 							Name: to.Ptr("azureFirewallMgmtIpConfiguration"),
		// 							Etag: to.Ptr("w/\\00000000-0000-0000-0000-000000000000\\"),
		// 							Properties: &armnetwork.AzureFirewallIPConfigurationPropertiesFormat{
		// 								ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 								PublicIPAddress: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName"),
		// 								},
		// 								Subnet: &armnetwork.SubResource{
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"),
		// 								},
		// 							},
		// 						},
		// 						NatRuleCollections: []*armnetwork.AzureFirewallNatRuleCollection{
		// 							{
		// 								Name: to.Ptr("natrulecoll"),
		// 								Properties: &armnetwork.AzureFirewallNatRuleCollectionProperties{
		// 									Action: &armnetwork.AzureFirewallNatRCAction{
		// 										Type: to.Ptr(armnetwork.AzureFirewallNatRCActionTypeDnat),
		// 									},
		// 									Priority: to.Ptr[int32](112),
		// 									Rules: []*armnetwork.AzureFirewallNatRule{
		// 										{
		// 											Name: to.Ptr("DNAT-HTTPS-traffic"),
		// 											Description: to.Ptr("D-NAT all outbound web traffic for inspection"),
		// 											DestinationAddresses: []*string{
		// 												to.Ptr("1.2.3.4")},
		// 												DestinationPorts: []*string{
		// 													to.Ptr("443")},
		// 													Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
		// 														to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
		// 														SourceAddresses: []*string{
		// 															to.Ptr("*")},
		// 															TranslatedAddress: to.Ptr("1.2.3.5"),
		// 															TranslatedPort: to.Ptr("8443"),
		// 														},
		// 														{
		// 															Name: to.Ptr("DNAT-HTTP-traffic-With-FQDN"),
		// 															Description: to.Ptr("D-NAT all inbound web traffic for inspection"),
		// 															DestinationAddresses: []*string{
		// 																to.Ptr("1.2.3.4")},
		// 																DestinationPorts: []*string{
		// 																	to.Ptr("80")},
		// 																	Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
		// 																		to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
		// 																		SourceAddresses: []*string{
		// 																			to.Ptr("*")},
		// 																			TranslatedFqdn: to.Ptr("internalhttpserver"),
		// 																			TranslatedPort: to.Ptr("880"),
		// 																	}},
		// 																},
		// 														}},
		// 														NetworkRuleCollections: []*armnetwork.AzureFirewallNetworkRuleCollection{
		// 															{
		// 																Name: to.Ptr("netrulecoll"),
		// 																Properties: &armnetwork.AzureFirewallNetworkRuleCollectionPropertiesFormat{
		// 																	Action: &armnetwork.AzureFirewallRCAction{
		// 																		Type: to.Ptr(armnetwork.AzureFirewallRCActionTypeDeny),
		// 																	},
		// 																	Priority: to.Ptr[int32](112),
		// 																	Rules: []*armnetwork.AzureFirewallNetworkRule{
		// 																		{
		// 																			Name: to.Ptr("L4-traffic"),
		// 																			Description: to.Ptr("Block traffic based on source IPs and ports"),
		// 																			DestinationAddresses: []*string{
		// 																				to.Ptr("*")},
		// 																				DestinationPorts: []*string{
		// 																					to.Ptr("443-444"),
		// 																					to.Ptr("8443")},
		// 																					Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
		// 																						to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
		// 																						SourceAddresses: []*string{
		// 																							to.Ptr("192.168.1.1-192.168.1.12"),
		// 																							to.Ptr("10.1.4.12-10.1.4.255")},
		// 																						},
		// 																						{
		// 																							Name: to.Ptr("L4-traffic-with-FQDN"),
		// 																							Description: to.Ptr("Block traffic based on source IPs and ports to amazon"),
		// 																							DestinationFqdns: []*string{
		// 																								to.Ptr("www.amazon.com")},
		// 																								DestinationPorts: []*string{
		// 																									to.Ptr("443-444"),
		// 																									to.Ptr("8443")},
		// 																									Protocols: []*armnetwork.AzureFirewallNetworkRuleProtocol{
		// 																										to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolTCP)},
		// 																										SourceAddresses: []*string{
		// 																											to.Ptr("10.2.4.12-10.2.4.255")},
		// 																									}},
		// 																								},
		// 																						}},
		// 																						ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 																						ThreatIntelMode: to.Ptr(armnetwork.AzureFirewallThreatIntelModeAlert),
		// 																					},
		// 																					Zones: []*string{
		// 																					},
		// 																			}},
		// 																		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallListLearnedIPPrefixes.json
func ExampleAzureFirewallsClient_BeginListLearnedPrefixes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginListLearnedPrefixes(ctx, "rg1", "azureFirewall1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IPPrefixesList = armnetwork.IPPrefixesList{
	// 	IPPrefixes: []*string{
	// 		to.Ptr("10.101.0.0/16"),
	// 		to.Ptr("10.102.0.0/16")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/AzureFirewallPacketCapture.json
func ExampleAzureFirewallsClient_BeginPacketCapture() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAzureFirewallsClient().BeginPacketCapture(ctx, "rg1", "azureFirewall1", armnetwork.FirewallPacketCaptureParameters{
		Properties: &armnetwork.FirewallPacketCaptureParametersFormat{
			DurationInSeconds: to.Ptr[int32](300),
			FileName:          to.Ptr("azureFirewallPacketCapture"),
			Filters: []*armnetwork.AzureFirewallPacketCaptureRule{
				{
					DestinationPorts: []*string{
						to.Ptr("4500")},
					Destinations: []*string{
						to.Ptr("20.1.2.0")},
					Sources: []*string{
						to.Ptr("20.1.1.0")},
				},
				{
					DestinationPorts: []*string{
						to.Ptr("123"),
						to.Ptr("80")},
					Destinations: []*string{
						to.Ptr("10.1.2.0")},
					Sources: []*string{
						to.Ptr("10.1.1.0"),
						to.Ptr("10.1.1.1")},
				}},
			Flags: []*armnetwork.AzureFirewallPacketCaptureFlags{
				{
					Type: to.Ptr(armnetwork.AzureFirewallPacketCaptureFlagsTypeSyn),
				},
				{
					Type: to.Ptr(armnetwork.AzureFirewallPacketCaptureFlagsTypeFin),
				}},
			NumberOfPacketsToCapture: to.Ptr[int32](5000),
			SasURL:                   to.Ptr("someSASURL"),
			Protocol:                 to.Ptr(armnetwork.AzureFirewallNetworkRuleProtocolAny),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
