// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package safebrowsing provides access to the Safe Browsing API.
//
// For product documentation, see: https://developers.google.com/safe-browsing/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/safebrowsing/v5"
//	...
//	ctx := context.Background()
//	safebrowsingService, err := safebrowsing.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	safebrowsingService, err := safebrowsing.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	safebrowsingService, err := safebrowsing.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package safebrowsing // import "google.golang.org/api/safebrowsing/v5"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "safebrowsing:v5"
const apiName = "safebrowsing"
const apiVersion = "v5"
const basePath = "https://safebrowsing.googleapis.com/"
const basePathTemplate = "https://safebrowsing.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://safebrowsing.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Hashes = NewHashesService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Hashes *HashesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewHashesService(s *Service) *HashesService {
	rs := &HashesService{s: s}
	return rs
}

type HashesService struct {
	s *Service
}

// GoogleSecuritySafebrowsingV5FullHash: The full hash identified with one or
// more matches.
type GoogleSecuritySafebrowsingV5FullHash struct {
	// FullHash: The matching full hash. This is the SHA256 hash. The length will
	// be exactly 32 bytes.
	FullHash string `json:"fullHash,omitempty"`
	// FullHashDetails: Unordered list. A repeated field identifying the details
	// relevant to this full hash.
	FullHashDetails []*GoogleSecuritySafebrowsingV5FullHashFullHashDetail `json:"fullHashDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullHash") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullHash") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleSecuritySafebrowsingV5FullHash) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSecuritySafebrowsingV5FullHash
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleSecuritySafebrowsingV5FullHashFullHashDetail: Details about a matching
// full hash. An important note about forward compatibility: new threat types
// and threat attributes may be added by the server at any time; those
// additions are considered minor version changes. It is Google's policy not to
// expose minor version numbers in APIs (see
// https://cloud.google.com/apis/design/versioning for the versioning policy),
// so clients MUST be prepared to receive `FullHashDetail` messages containing
// `ThreatType` enum values or `ThreatAttribute` enum values that are
// considered invalid by the client. Therefore, it is the client's
// responsibility to check for the validity of all `ThreatType` and
// `ThreatAttribute` enum values; if any value is considered invalid, the
// client MUST disregard the entire `FullHashDetail` message.
type GoogleSecuritySafebrowsingV5FullHashFullHashDetail struct {
	// Attributes: Unordered list. Additional attributes about those full hashes.
	// This may be empty.
	//
	// Possible values:
	//   "THREAT_ATTRIBUTE_UNSPECIFIED" - Unknown attribute. If this is returned by
	// the server, the client shall disregard the enclosing `FullHashDetail`
	// altogether.
	//   "CANARY" - Indicates that the threat_type should not be used for
	// enforcement.
	//   "FRAME_ONLY" - Indicates that the threat_type should only be used for
	// enforcement on frames.
	Attributes []string `json:"attributes,omitempty"`
	// ThreatType: The type of threat. This field will never be empty.
	//
	// Possible values:
	//   "THREAT_TYPE_UNSPECIFIED" - Unknown threat type. If this is returned by
	// the server, the client shall disregard the enclosing `FullHashDetail`
	// altogether.
	//   "MALWARE" - Malware threat type. Malware is any software or mobile
	// application specifically designed to harm a computer, a mobile device, the
	// software it's running, or its users. Malware exhibits malicious behavior
	// that can include installing software without user consent and installing
	// harmful software such as viruses. More information can be found
	// [here](https://developers.google.com/search/docs/monitor-debug/security/malwa
	// re).
	//   "SOCIAL_ENGINEERING" - Social engineering threat type. Social engineering
	// pages falsely purport to act on behalf of a third party with the intention
	// of confusing viewers into performing an action with which the viewer would
	// only trust a true agent of that third party. Phishing is a type of social
	// engineering that tricks the viewer into performing the specific action of
	// providing information, such as login credentials. More information can be
	// found
	// [here](https://developers.google.com/search/docs/monitor-debug/security/socia
	// l-engineering).
	//   "UNWANTED_SOFTWARE" - Unwanted software threat type. Unwanted software is
	// any software that does not adhere to [Google's Software
	// Principles](https://www.google.com/about/software-principles.html) but isn't
	// malware.
	//   "POTENTIALLY_HARMFUL_APPLICATION" - Potentially harmful application threat
	// type [as used by Google Play Protect for the Play
	// Store](https://developers.google.com/android/play-protect/potentially-harmful
	// -applications).
	ThreatType string `json:"threatType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleSecuritySafebrowsingV5FullHashFullHashDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSecuritySafebrowsingV5FullHashFullHashDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleSecuritySafebrowsingV5SearchHashesResponse: The response returned
// after searching threat hashes. If nothing is found, the server will return
// an OK status (HTTP status code 200) with the `full_hashes` field empty,
// rather than returning a NOT_FOUND status (HTTP status code 404). **What's
// new in V5**: There is a separation between `FullHash` and `FullHashDetail`.
// In the case when a hash represents a site having multiple threats (e.g. both
// MALWARE and SOCIAL_ENGINEERING), the full hash does not need to be sent
// twice as in V4. Furthermore, the cache duration has been simplified into a
// single `cache_duration` field.
type GoogleSecuritySafebrowsingV5SearchHashesResponse struct {
	// CacheDuration: The client-side cache duration. The client MUST add this
	// duration to the current time to determine the expiration time. The
	// expiration time then applies to every hash prefix queried by the client in
	// the request, regardless of how many full hashes are returned in the
	// response. Even if the server returns no full hashes for a particular hash
	// prefix, this fact MUST also be cached by the client. If and only if the
	// field `full_hashes` is empty, the client MAY increase the `cache_duration`
	// to determine a new expiration that is later than that specified by the
	// server. In any case, the increased cache duration must not be longer than 24
	// hours. Important: the client MUST NOT assume that the server will return the
	// same cache duration for all responses. The server MAY choose different cache
	// durations for different responses depending on the situation.
	CacheDuration string `json:"cacheDuration,omitempty"`
	// FullHashes: Unordered list. The unordered list of full hashes found.
	FullHashes []*GoogleSecuritySafebrowsingV5FullHash `json:"fullHashes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CacheDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheDuration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleSecuritySafebrowsingV5SearchHashesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSecuritySafebrowsingV5SearchHashesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type HashesSearchCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Search for full hashes matching the specified prefixes. This is a
// custom method as defined by https://google.aip.dev/136 (the custom method
// refers to this method having a custom name within Google's general API
// development nomenclature; it does not refer to using a custom HTTP method).
func (r *HashesService) Search() *HashesSearchCall {
	c := &HashesSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// HashPrefixes sets the optional parameter "hashPrefixes": Required. The hash
// prefixes to be looked up. Clients MUST NOT send more than 1000 hash
// prefixes. However, following the URL processing procedure, clients SHOULD
// NOT need to send more than 30 hash prefixes. Currently each hash prefix is
// required to be exactly 4 bytes long. This MAY be relaxed in the future.
func (c *HashesSearchCall) HashPrefixes(hashPrefixes ...string) *HashesSearchCall {
	c.urlParams_.SetMulti("hashPrefixes", append([]string{}, hashPrefixes...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *HashesSearchCall) Fields(s ...googleapi.Field) *HashesSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *HashesSearchCall) IfNoneMatch(entityTag string) *HashesSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *HashesSearchCall) Context(ctx context.Context) *HashesSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *HashesSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *HashesSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v5/hashes:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "safebrowsing.hashes.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "safebrowsing.hashes.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleSecuritySafebrowsingV5SearchHashesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *HashesSearchCall) Do(opts ...googleapi.CallOption) (*GoogleSecuritySafebrowsingV5SearchHashesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleSecuritySafebrowsingV5SearchHashesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "safebrowsing.hashes.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
