// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package translate provides access to the Cloud Translation API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/translate instead.
//
// For product documentation, see: https://cloud.google.com/translate/docs/quickstarts
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/translate/v3"
//	...
//	ctx := context.Background()
//	translateService, err := translate.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	translateService, err := translate.NewService(ctx, option.WithScopes(translate.CloudTranslationScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	translateService, err := translate.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	translateService, err := translate.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package translate // import "google.golang.org/api/translate/v3"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "translate:v3"
const apiName = "translate"
const apiVersion = "v3"
const basePath = "https://translation.googleapis.com/"
const basePathTemplate = "https://translation.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://translation.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// Translate text from one language to another using Google Translate
	CloudTranslationScope = "https://www.googleapis.com/auth/cloud-translation"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-translation",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AdaptiveMtDatasets = NewProjectsLocationsAdaptiveMtDatasetsService(s)
	rs.Datasets = NewProjectsLocationsDatasetsService(s)
	rs.Glossaries = NewProjectsLocationsGlossariesService(s)
	rs.Models = NewProjectsLocationsModelsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AdaptiveMtDatasets *ProjectsLocationsAdaptiveMtDatasetsService

	Datasets *ProjectsLocationsDatasetsService

	Glossaries *ProjectsLocationsGlossariesService

	Models *ProjectsLocationsModelsService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsAdaptiveMtDatasetsService(s *Service) *ProjectsLocationsAdaptiveMtDatasetsService {
	rs := &ProjectsLocationsAdaptiveMtDatasetsService{s: s}
	rs.AdaptiveMtFiles = NewProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService(s)
	rs.AdaptiveMtSentences = NewProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesService(s)
	return rs
}

type ProjectsLocationsAdaptiveMtDatasetsService struct {
	s *Service

	AdaptiveMtFiles *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService

	AdaptiveMtSentences *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesService
}

func NewProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService(s *Service) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService {
	rs := &ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService{s: s}
	rs.AdaptiveMtSentences = NewProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesService(s)
	return rs
}

type ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService struct {
	s *Service

	AdaptiveMtSentences *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesService
}

func NewProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesService(s *Service) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesService {
	rs := &ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesService{s: s}
	return rs
}

type ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesService struct {
	s *Service
}

func NewProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesService(s *Service) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesService {
	rs := &ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesService{s: s}
	return rs
}

type ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsService(s *Service) *ProjectsLocationsDatasetsService {
	rs := &ProjectsLocationsDatasetsService{s: s}
	rs.Examples = NewProjectsLocationsDatasetsExamplesService(s)
	return rs
}

type ProjectsLocationsDatasetsService struct {
	s *Service

	Examples *ProjectsLocationsDatasetsExamplesService
}

func NewProjectsLocationsDatasetsExamplesService(s *Service) *ProjectsLocationsDatasetsExamplesService {
	rs := &ProjectsLocationsDatasetsExamplesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsExamplesService struct {
	s *Service
}

func NewProjectsLocationsGlossariesService(s *Service) *ProjectsLocationsGlossariesService {
	rs := &ProjectsLocationsGlossariesService{s: s}
	rs.GlossaryEntries = NewProjectsLocationsGlossariesGlossaryEntriesService(s)
	return rs
}

type ProjectsLocationsGlossariesService struct {
	s *Service

	GlossaryEntries *ProjectsLocationsGlossariesGlossaryEntriesService
}

func NewProjectsLocationsGlossariesGlossaryEntriesService(s *Service) *ProjectsLocationsGlossariesGlossaryEntriesService {
	rs := &ProjectsLocationsGlossariesGlossaryEntriesService{s: s}
	return rs
}

type ProjectsLocationsGlossariesGlossaryEntriesService struct {
	s *Service
}

func NewProjectsLocationsModelsService(s *Service) *ProjectsLocationsModelsService {
	rs := &ProjectsLocationsModelsService{s: s}
	return rs
}

type ProjectsLocationsModelsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// AdaptiveMtDataset: An Adaptive MT Dataset.
type AdaptiveMtDataset struct {
	// CreateTime: Output only. Timestamp when this dataset was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The name of the dataset to show in the interface. The name can
	// be up to 32 characters long and can consist only of ASCII Latin letters A-Z
	// and a-z, underscores (_), and ASCII digits 0-9.
	DisplayName string `json:"displayName,omitempty"`
	// ExampleCount: The number of examples in the dataset.
	ExampleCount int64 `json:"exampleCount,omitempty"`
	// Name: Required. The resource name of the dataset, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{
	// dataset_id}`
	Name string `json:"name,omitempty"`
	// SourceLanguageCode: The BCP-47 language code of the source language.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCode: The BCP-47 language code of the target language.
	TargetLanguageCode string `json:"targetLanguageCode,omitempty"`
	// UpdateTime: Output only. Timestamp when this dataset was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdaptiveMtDataset) MarshalJSON() ([]byte, error) {
	type NoMethod AdaptiveMtDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdaptiveMtFile: An AdaptiveMtFile.
type AdaptiveMtFile struct {
	// CreateTime: Output only. Timestamp when this file was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The file's display name.
	DisplayName string `json:"displayName,omitempty"`
	// EntryCount: The number of entries that the file contains.
	EntryCount int64 `json:"entryCount,omitempty"`
	// Name: Required. The resource name of the file, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{
	// dataset}/adaptiveMtFiles/{file}`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when this file was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdaptiveMtFile) MarshalJSON() ([]byte, error) {
	type NoMethod AdaptiveMtFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdaptiveMtSentence: An AdaptiveMt sentence entry.
type AdaptiveMtSentence struct {
	// CreateTime: Output only. Timestamp when this sentence was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Required. The resource name of the file, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{
	// dataset}/adaptiveMtFiles/{file}/adaptiveMtSentences/{sentence}`
	Name string `json:"name,omitempty"`
	// SourceSentence: Required. The source sentence.
	SourceSentence string `json:"sourceSentence,omitempty"`
	// TargetSentence: Required. The target sentence.
	TargetSentence string `json:"targetSentence,omitempty"`
	// UpdateTime: Output only. Timestamp when this sentence was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdaptiveMtSentence) MarshalJSON() ([]byte, error) {
	type NoMethod AdaptiveMtSentence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdaptiveMtTranslateRequest: The request for sending an AdaptiveMt
// translation query.
type AdaptiveMtTranslateRequest struct {
	// Content: Required. The content of the input in string format.
	Content []string `json:"content,omitempty"`
	// Dataset: Required. The resource name for the dataset to use for adaptive MT.
	// `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
	Dataset string `json:"dataset,omitempty"`
	// GlossaryConfig: Optional. Glossary to be applied. The glossary must be
	// within the same region (have the same location-id) as the model, otherwise
	// an INVALID_ARGUMENT (400) error is returned.
	GlossaryConfig *GlossaryConfig `json:"glossaryConfig,omitempty"`
	// ReferenceSentenceConfig: Configuration for caller provided reference
	// sentences.
	ReferenceSentenceConfig *ReferenceSentenceConfig `json:"referenceSentenceConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdaptiveMtTranslateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AdaptiveMtTranslateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdaptiveMtTranslateResponse: An AdaptiveMtTranslate response.
type AdaptiveMtTranslateResponse struct {
	// GlossaryTranslations: Text translation response if a glossary is provided in
	// the request. This could be the same as 'translation' above if no terms
	// apply.
	GlossaryTranslations []*AdaptiveMtTranslation `json:"glossaryTranslations,omitempty"`
	// LanguageCode: Output only. The translation's language code.
	LanguageCode string `json:"languageCode,omitempty"`
	// Translations: Output only. The translation.
	Translations []*AdaptiveMtTranslation `json:"translations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GlossaryTranslations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlossaryTranslations") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdaptiveMtTranslateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AdaptiveMtTranslateResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdaptiveMtTranslation: An AdaptiveMt translation.
type AdaptiveMtTranslation struct {
	// TranslatedText: Output only. The translated text.
	TranslatedText string `json:"translatedText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranslatedText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranslatedText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdaptiveMtTranslation) MarshalJSON() ([]byte, error) {
	type NoMethod AdaptiveMtTranslation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDocumentInputConfig: Input configuration for BatchTranslateDocument
// request.
type BatchDocumentInputConfig struct {
	// GcsSource: Google Cloud Storage location for the source input. This can be a
	// single file (for example, `gs://translation-test/input.docx`) or a wildcard
	// (for example, `gs://translation-test/*`). File mime type is determined based
	// on extension. Supported mime type includes: - `pdf`, application/pdf -
	// `docx`,
	// application/vnd.openxmlformats-officedocument.wordprocessingml.document -
	// `pptx`,
	// application/vnd.openxmlformats-officedocument.presentationml.presentation -
	// `xlsx`, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
	// The max file size to support for `.docx`, `.pptx` and `.xlsx` is 100MB. The
	// max file size to support for `.pdf` is 1GB and the max page limit is 1000
	// pages. The max file size to support for all input documents is 1GB.
	GcsSource *GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDocumentInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDocumentInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDocumentOutputConfig: Output configuration for BatchTranslateDocument
// request.
type BatchDocumentOutputConfig struct {
	// GcsDestination: Google Cloud Storage destination for output content. For
	// every single input document (for example, gs://a/b/c.[extension]), we
	// generate at most 2 * n output files. (n is the # of target_language_codes in
	// the BatchTranslateDocumentRequest). While the input documents are being
	// processed, we write/update an index file `index.csv` under
	// `gcs_destination.output_uri_prefix` (for example,
	// gs://translation_output/index.csv) The index file is generated/updated as
	// new files are being translated. The format is:
	// input_document,target_language_code,translation_output,error_output,
	// glossary_translation_output,glossary_error_output `input_document` is one
	// file we matched using gcs_source.input_uri. `target_language_code` is
	// provided in the request. `translation_output` contains the translations.
	// (details provided below) `error_output` contains the error message during
	// processing of the file. Both translations_file and errors_file could be
	// empty strings if we have no content to output. `glossary_translation_output`
	// and `glossary_error_output` are the translated output/error when we apply
	// glossaries. They could also be empty if we have no content to output. Once a
	// row is present in index.csv, the input/output matching never changes.
	// Callers should also expect all the content in input_file are processed and
	// ready to be consumed (that is, no partial output file is written). Since
	// index.csv will be keeping updated during the process, please make sure there
	// is no custom retention policy applied on the output bucket that may avoid
	// file updating.
	// (https://cloud.google.com/storage/docs/bucket-lock#retention-policy) The
	// naming format of translation output files follows (for target language code
	// [trg]): `translation_output`:
	// `gs://translation_output/a_b_c_[trg]_translation.[extension]`
	// `glossary_translation_output`:
	// `gs://translation_test/a_b_c_[trg]_glossary_translation.[extension]`. The
	// output document will maintain the same file format as the input document.
	// The naming format of error output files follows (for target language code
	// [trg]): `error_output`: `gs://translation_test/a_b_c_[trg]_errors.txt`
	// `glossary_error_output`:
	// `gs://translation_test/a_b_c_[trg]_glossary_translation.txt`. The error
	// output is a txt file containing error details.
	GcsDestination *GcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDocumentOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDocumentOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchTranslateDocumentRequest: The BatchTranslateDocument request.
type BatchTranslateDocumentRequest struct {
	// CustomizedAttribution: Optional. This flag is to support user customized
	// attribution. If not provided, the default is `Machine Translated by Google`.
	// Customized attribution should follow rules in
	// https://cloud.google.com/translate/attribution#attribution_and_logos
	CustomizedAttribution string `json:"customizedAttribution,omitempty"`
	// EnableRotationCorrection: Optional. If true, enable auto rotation correction
	// in DVS.
	EnableRotationCorrection bool `json:"enableRotationCorrection,omitempty"`
	// EnableShadowRemovalNativePdf: Optional. If true, use the text removal server
	// to remove the shadow text on background image for native pdf translation.
	// Shadow removal feature can only be enabled when
	// is_translate_native_pdf_only: false && pdf_native_only: false
	EnableShadowRemovalNativePdf bool `json:"enableShadowRemovalNativePdf,omitempty"`
	// FormatConversions: Optional. The file format conversion map that is applied
	// to all input files. The map key is the original mime_type. The map value is
	// the target mime_type of translated documents. Supported file format
	// conversion includes: - `application/pdf` to
	// `application/vnd.openxmlformats-officedocument.wordprocessingml.document` If
	// nothing specified, output files will be in the same format as the original
	// file.
	FormatConversions map[string]string `json:"formatConversions,omitempty"`
	// Glossaries: Optional. Glossaries to be applied. It's keyed by target
	// language code.
	Glossaries map[string]TranslateTextGlossaryConfig `json:"glossaries,omitempty"`
	// InputConfigs: Required. Input configurations. The total number of files
	// matched should be <= 100. The total content size to translate should be <=
	// 100M Unicode codepoints. The files must use UTF-8 encoding.
	InputConfigs []*BatchDocumentInputConfig `json:"inputConfigs,omitempty"`
	// Models: Optional. The models to use for translation. Map's key is target
	// language code. Map's value is the model name. Value can be a built-in
	// general model, or an AutoML Translation model. The value format depends on
	// model type: - AutoML Translation models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	// - General (built-in) models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//  If the map is empty or a specific model is not requested for a language
	// pair, then default google model (nmt) is used.
	Models map[string]string `json:"models,omitempty"`
	// OutputConfig: Required. Output configuration. If 2 input configs match to
	// the same file (that is, same input path), we don't generate output for
	// duplicate inputs.
	OutputConfig *BatchDocumentOutputConfig `json:"outputConfig,omitempty"`
	// SourceLanguageCode: Required. The ISO-639 language code of the input
	// document if known, for example, "en-US" or "sr-Latn". Supported language
	// codes are listed in Language Support
	// (https://cloud.google.com/translate/docs/languages).
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCodes: Required. The ISO-639 language code to use for
	// translation of the input document. Specify up to 10 language codes here.
	TargetLanguageCodes []string `json:"targetLanguageCodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomizedAttribution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomizedAttribution") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchTranslateDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchTranslateDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchTranslateTextRequest: The batch translation request.
type BatchTranslateTextRequest struct {
	// Glossaries: Optional. Glossaries to be applied for translation. It's keyed
	// by target language code.
	Glossaries map[string]TranslateTextGlossaryConfig `json:"glossaries,omitempty"`
	// InputConfigs: Required. Input configurations. The total number of files
	// matched should be <= 100. The total content size should be <= 100M Unicode
	// codepoints. The files must use UTF-8 encoding.
	InputConfigs []*InputConfig `json:"inputConfigs,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request.
	// Label keys and values can be no longer than 63 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter. See
	// https://cloud.google.com/translate/docs/advanced/labels for more
	// information.
	Labels map[string]string `json:"labels,omitempty"`
	// Models: Optional. The models to use for translation. Map's key is target
	// language code. Map's value is model name. Value can be a built-in general
	// model, or an AutoML Translation model. The value format depends on model
	// type: - AutoML Translation models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	// - General (built-in) models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//  If the map is empty or a specific model is not requested for a language
	// pair, then default google model (nmt) is used.
	Models map[string]string `json:"models,omitempty"`
	// OutputConfig: Required. Output configuration. If 2 input configs match to
	// the same file (that is, same input path), we don't generate output for
	// duplicate inputs.
	OutputConfig *OutputConfig `json:"outputConfig,omitempty"`
	// SourceLanguageCode: Required. Source language code.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCodes: Required. Specify up to 10 language codes here.
	TargetLanguageCodes []string `json:"targetLanguageCodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Glossaries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Glossaries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchTranslateTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchTranslateTextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// Dataset: A dataset that hosts the examples (sentence pairs) used for
// translation models.
type Dataset struct {
	// CreateTime: Output only. Timestamp when this dataset was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The name of the dataset to show in the interface. The name can
	// be up to 32 characters long and can consist only of ASCII Latin letters A-Z
	// and a-z, underscores (_), and ASCII digits 0-9.
	DisplayName string `json:"displayName,omitempty"`
	// ExampleCount: Output only. The number of examples in the dataset.
	ExampleCount int64 `json:"exampleCount,omitempty"`
	// Name: The resource name of the dataset, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/datasets/{dataset_id
	// }`
	Name string `json:"name,omitempty"`
	// SourceLanguageCode: The BCP-47 language code of the source language.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCode: The BCP-47 language code of the target language.
	TargetLanguageCode string `json:"targetLanguageCode,omitempty"`
	// TestExampleCount: Output only. Number of test examples (sentence pairs).
	TestExampleCount int64 `json:"testExampleCount,omitempty"`
	// TrainExampleCount: Output only. Number of training examples (sentence
	// pairs).
	TrainExampleCount int64 `json:"trainExampleCount,omitempty"`
	// UpdateTime: Output only. Timestamp when this dataset was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ValidateExampleCount: Output only. Number of validation examples (sentence
	// pairs).
	ValidateExampleCount int64 `json:"validateExampleCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatasetInputConfig: Input configuration for datasets.
type DatasetInputConfig struct {
	// InputFiles: Files containing the sentence pairs to be imported to the
	// dataset.
	InputFiles []*InputFile `json:"inputFiles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputFiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputFiles") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatasetInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DatasetInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatasetOutputConfig: Output configuration for datasets.
type DatasetOutputConfig struct {
	// GcsDestination: Google Cloud Storage destination to write the output.
	GcsDestination *GcsOutputDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatasetOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DatasetOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DetectLanguageRequest: The request message for language detection.
type DetectLanguageRequest struct {
	// Content: The content of the input stored as a string.
	Content string `json:"content,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request.
	// Label keys and values can be no longer than 63 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter. See
	// https://cloud.google.com/translate/docs/advanced/labels for more
	// information.
	Labels map[string]string `json:"labels,omitempty"`
	// MimeType: Optional. The format of the source text, for example, "text/html",
	// "text/plain". If left blank, the MIME type defaults to "text/html".
	MimeType string `json:"mimeType,omitempty"`
	// Model: Optional. The language detection model to be used. Format:
	// `projects/{project-number-or-id}/locations/{location-id}/models/language-dete
	// ction/{model-id}` Only one language detection model is currently supported:
	// `projects/{project-number-or-id}/locations/{location-id}/models/language-dete
	// ction/default`. If not specified, the default model is used.
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DetectLanguageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DetectLanguageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DetectLanguageResponse: The response message for language detection.
type DetectLanguageResponse struct {
	// Languages: The most probable language detected by the Translation API. For
	// each request, the Translation API will always return only one result.
	Languages []*DetectedLanguage `json:"languages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Languages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Languages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DetectLanguageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DetectLanguageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DetectedLanguage: The response message for language detection.
type DetectedLanguage struct {
	// Confidence: The confidence of the detection result for this language.
	Confidence float64 `json:"confidence,omitempty"`
	// LanguageCode: The ISO-639 language code of the source content in the
	// request, detected automatically.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DetectedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod DetectedLanguage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DetectedLanguage) UnmarshalJSON(data []byte) error {
	type NoMethod DetectedLanguage
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// DocumentInputConfig: A document translation request input config.
type DocumentInputConfig struct {
	// Content: Document's content represented as a stream of bytes.
	Content string `json:"content,omitempty"`
	// GcsSource: Google Cloud Storage location. This must be a single file. For
	// example: gs://example_bucket/example_file.pdf
	GcsSource *GcsSource `json:"gcsSource,omitempty"`
	// MimeType: Specifies the input document's mime_type. If not specified it will
	// be determined using the file extension for gcs_source provided files. For a
	// file provided through bytes content the mime_type must be provided.
	// Currently supported mime types are: - application/pdf -
	// application/vnd.openxmlformats-officedocument.wordprocessingml.document -
	// application/vnd.openxmlformats-officedocument.presentationml.presentation -
	// application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DocumentOutputConfig: A document translation request output config.
type DocumentOutputConfig struct {
	// GcsDestination: Optional. Google Cloud Storage destination for the
	// translation output, e.g., `gs://my_bucket/my_directory/`. The destination
	// directory provided does not have to be empty, but the bucket must exist. If
	// a file with the same name as the output file already exists in the
	// destination an error will be returned. For a DocumentInputConfig.contents
	// provided document, the output file will have the name
	// "output_[trg]_translations.[ext]", where - [trg] corresponds to the
	// translated file's language code, - [ext] corresponds to the translated
	// file's extension according to its mime type. For a
	// DocumentInputConfig.gcs_uri provided document, the output file will have a
	// name according to its URI. For example: an input file with URI:
	// `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
	// "my_bucket" will have an output URI:
	// `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where - [trg] corresponds
	// to the translated file's language code, - [ext] corresponds to the
	// translated file's extension according to its mime type. If the document was
	// directly provided through the request, then the output document will have
	// the format: `gs://my_bucket/translated_document_[trg]_translations.[ext]`,
	// where - [trg] corresponds to the translated file's language code, - [ext]
	// corresponds to the translated file's extension according to its mime type.
	// If a glossary was provided, then the output URI for the glossary translation
	// will be equal to the default output URI but have `glossary_translations`
	// instead of `translations`. For the previous example, its glossary URI would
	// be: `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`. Thus the max
	// number of output files will be 2 (Translated document, Glossary translated
	// document). Callers should expect no partial outputs. If there is any error
	// during document translation, no output will be stored in the Cloud Storage
	// bucket.
	GcsDestination *GcsDestination `json:"gcsDestination,omitempty"`
	// MimeType: Optional. Specifies the translated document's mime_type. If not
	// specified, the translated file's mime type will be the same as the input
	// file's mime type. Currently only support the output mime type to be the same
	// as input mime type. - application/pdf -
	// application/vnd.openxmlformats-officedocument.wordprocessingml.document -
	// application/vnd.openxmlformats-officedocument.presentationml.presentation -
	// application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DocumentTranslation: A translated document message.
type DocumentTranslation struct {
	// ByteStreamOutputs: The array of translated documents. It is expected to be
	// size 1 for now. We may produce multiple translated documents in the future
	// for other type of file formats.
	ByteStreamOutputs []string `json:"byteStreamOutputs,omitempty"`
	// DetectedLanguageCode: The detected language for the input document. If the
	// user did not provide the source language for the input document, this field
	// will have the language code automatically detected. If the source language
	// was passed, auto-detection of the language does not occur and this field is
	// empty.
	DetectedLanguageCode string `json:"detectedLanguageCode,omitempty"`
	// MimeType: The translated document's mime type.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ByteStreamOutputs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ByteStreamOutputs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DocumentTranslation) MarshalJSON() ([]byte, error) {
	type NoMethod DocumentTranslation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Example: A sentence pair.
type Example struct {
	// Name: Output only. The resource name of the example, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/datasets/{dataset_id
	// }/examples/{example_id}`
	Name string `json:"name,omitempty"`
	// SourceText: Sentence in source language.
	SourceText string `json:"sourceText,omitempty"`
	// TargetText: Sentence in target language.
	TargetText string `json:"targetText,omitempty"`
	// Usage: Output only. Usage of the sentence pair. Options are
	// TRAIN|VALIDATION|TEST.
	Usage string `json:"usage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Example) MarshalJSON() ([]byte, error) {
	type NoMethod Example
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportDataRequest: Request message for ExportData.
type ExportDataRequest struct {
	// OutputConfig: Required. The config for the output content.
	OutputConfig *DatasetOutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FileInputSource: An inlined file.
type FileInputSource struct {
	// Content: Required. The file's byte contents.
	Content string `json:"content,omitempty"`
	// DisplayName: Required. The file's display name.
	DisplayName string `json:"displayName,omitempty"`
	// MimeType: Required. The file's mime type.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FileInputSource) MarshalJSON() ([]byte, error) {
	type NoMethod FileInputSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsDestination: The Google Cloud Storage location for the output content.
type GcsDestination struct {
	// OutputUriPrefix: Required. The bucket used in 'output_uri_prefix' must exist
	// and there must be no files under 'output_uri_prefix'. 'output_uri_prefix'
	// must end with "/" and start with "gs://". One 'output_uri_prefix' can only
	// be used by one batch translation job at a time. Otherwise an
	// INVALID_ARGUMENT (400) error is returned.
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUriPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsInputSource: The Google Cloud Storage location for the input content.
type GcsInputSource struct {
	// InputUri: Required. Source data URI. For example,
	// `gs://my_bucket/my_object`.
	InputUri string `json:"inputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsInputSource) MarshalJSON() ([]byte, error) {
	type NoMethod GcsInputSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsOutputDestination: The Google Cloud Storage location for the output
// content.
type GcsOutputDestination struct {
	// OutputUriPrefix: Required. Google Cloud Storage URI to output directory. For
	// example, `gs://bucket/directory`. The requesting user must have write
	// permission to the bucket. The directory will be created if it doesn't exist.
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUriPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsOutputDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GcsOutputDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GcsSource: The Google Cloud Storage location for the input content.
type GcsSource struct {
	// InputUri: Required. Source data URI. For example,
	// `gs://my_bucket/my_object`.
	InputUri string `json:"inputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Glossary: Represents a glossary built from user-provided data.
type Glossary struct {
	// DisplayName: Optional. The display name of the glossary.
	DisplayName string `json:"displayName,omitempty"`
	// EndTime: Output only. When the glossary creation was finished.
	EndTime string `json:"endTime,omitempty"`
	// EntryCount: Output only. The number of entries defined in the glossary.
	EntryCount int64 `json:"entryCount,omitempty"`
	// InputConfig: Required. Provides examples to build the glossary from. Total
	// glossary must not exceed 10M Unicode codepoints.
	InputConfig *GlossaryInputConfig `json:"inputConfig,omitempty"`
	// LanguageCodesSet: Used with equivalent term set glossaries.
	LanguageCodesSet *LanguageCodesSet `json:"languageCodesSet,omitempty"`
	// LanguagePair: Used with unidirectional glossaries.
	LanguagePair *LanguageCodePair `json:"languagePair,omitempty"`
	// Name: Required. The resource name of the glossary. Glossary names have the
	// form
	// `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary
	// -id}`.
	Name string `json:"name,omitempty"`
	// SubmitTime: Output only. When CreateGlossary was called.
	SubmitTime string `json:"submitTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Glossary) MarshalJSON() ([]byte, error) {
	type NoMethod Glossary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GlossaryConfig: Configures which glossary is used for a specific target
// language and defines options for applying that glossary.
type GlossaryConfig struct {
	// ContextualTranslationEnabled: Optional. If set to true, the glossary will be
	// used for contextual translation.
	ContextualTranslationEnabled bool `json:"contextualTranslationEnabled,omitempty"`
	// Glossary: Required. The `glossary` to be applied for this translation. The
	// format depends on the glossary: - User-provided custom glossary:
	// `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary
	// -id}`
	Glossary string `json:"glossary,omitempty"`
	// IgnoreCase: Optional. Indicates match is case insensitive. The default value
	// is `false` if missing.
	IgnoreCase bool `json:"ignoreCase,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ContextualTranslationEnabled") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextualTranslationEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlossaryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GlossaryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GlossaryEntry: Represents a single entry in a glossary.
type GlossaryEntry struct {
	// Description: Describes the glossary entry.
	Description string `json:"description,omitempty"`
	// Name: Identifier. The resource name of the entry. Format:
	// `projects/*/locations/*/glossaries/*/glossaryEntries/*`
	Name string `json:"name,omitempty"`
	// TermsPair: Used for an unidirectional glossary.
	TermsPair *GlossaryTermsPair `json:"termsPair,omitempty"`
	// TermsSet: Used for an equivalent term sets glossary.
	TermsSet *GlossaryTermsSet `json:"termsSet,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlossaryEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GlossaryEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GlossaryInputConfig: Input configuration for glossaries.
type GlossaryInputConfig struct {
	// GcsSource: Required. Google Cloud Storage location of glossary data. File
	// format is determined based on the filename extension. API returns
	// [google.rpc.Code.INVALID_ARGUMENT] for unsupported URI-s and file formats.
	// Wildcards are not allowed. This must be a single file in one of the
	// following formats: For unidirectional glossaries: - TSV/CSV (`.tsv`/`.csv`):
	// Two column file, tab- or comma-separated. The first column is source text.
	// The second column is target text. No headers in this file. The first row
	// contains data and not column names. - TMX (`.tmx`): TMX file with parallel
	// data defining source/target term pairs. For equivalent term sets glossaries:
	// - CSV (`.csv`): Multi-column CSV file defining equivalent glossary terms in
	// multiple languages. See documentation for more information - glossaries
	// (https://cloud.google.com/translate/docs/advanced/glossary).
	GcsSource *GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlossaryInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GlossaryInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GlossaryTerm: Represents a single glossary term
type GlossaryTerm struct {
	// LanguageCode: The language for this glossary term.
	LanguageCode string `json:"languageCode,omitempty"`
	// Text: The text for the glossary term.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlossaryTerm) MarshalJSON() ([]byte, error) {
	type NoMethod GlossaryTerm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GlossaryTermsPair: Represents a single entry for an unidirectional glossary.
type GlossaryTermsPair struct {
	// SourceTerm: The source term is the term that will get match in the text,
	SourceTerm *GlossaryTerm `json:"sourceTerm,omitempty"`
	// TargetTerm: The term that will replace the match source term.
	TargetTerm *GlossaryTerm `json:"targetTerm,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceTerm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceTerm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlossaryTermsPair) MarshalJSON() ([]byte, error) {
	type NoMethod GlossaryTermsPair
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GlossaryTermsSet: Represents a single entry for an equivalent term set
// glossary. This is used for equivalent term sets where each term can be
// replaced by the other terms in the set.
type GlossaryTermsSet struct {
	// Terms: Each term in the set represents a term that can be replaced by the
	// other terms.
	Terms []*GlossaryTerm `json:"terms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Terms") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Terms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlossaryTermsSet) MarshalJSON() ([]byte, error) {
	type NoMethod GlossaryTermsSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportAdaptiveMtFileRequest: The request for importing an AdaptiveMt file
// along with its sentences.
type ImportAdaptiveMtFileRequest struct {
	// FileInputSource: Inline file source.
	FileInputSource *FileInputSource `json:"fileInputSource,omitempty"`
	// GcsInputSource: Google Cloud Storage file source.
	GcsInputSource *GcsInputSource `json:"gcsInputSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileInputSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileInputSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportAdaptiveMtFileRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportAdaptiveMtFileRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportAdaptiveMtFileResponse: The response for importing an AdaptiveMtFile
type ImportAdaptiveMtFileResponse struct {
	// AdaptiveMtFile: Output only. The Adaptive MT file that was imported.
	AdaptiveMtFile *AdaptiveMtFile `json:"adaptiveMtFile,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdaptiveMtFile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdaptiveMtFile") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportAdaptiveMtFileResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ImportAdaptiveMtFileResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportDataRequest: Request message for ImportData.
type ImportDataRequest struct {
	// InputConfig: Required. The config for the input content.
	InputConfig *DatasetInputConfig `json:"inputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ImportDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputConfig: Input configuration for BatchTranslateText request.
type InputConfig struct {
	// GcsSource: Required. Google Cloud Storage location for the source input.
	// This can be a single file (for example, `gs://translation-test/input.tsv`)
	// or a wildcard (for example, `gs://translation-test/*`). If a file extension
	// is `.tsv`, it can contain either one or two columns. The first column
	// (optional) is the id of the text request. If the first column is missing, we
	// use the row number (0-based) from the input file as the ID in the output
	// file. The second column is the actual text to be translated. We recommend
	// each row be <= 10K Unicode codepoints, otherwise an error might be returned.
	// Note that the input tsv must be RFC 4180 compliant. You could use
	// https://github.com/Clever/csvlint to check potential formatting errors in
	// your tsv file. csvlint --delimiter='\t' your_input_file.tsv The other
	// supported file extensions are `.txt` or `.html`, which is treated as a
	// single large chunk of text.
	GcsSource *GcsSource `json:"gcsSource,omitempty"`
	// MimeType: Optional. Can be "text/plain" or "text/html". For `.tsv`,
	// "text/html" is used if mime_type is missing. For `.html`, this field must be
	// "text/html" or empty. For `.txt`, this field must be "text/plain" or empty.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputFile: An input file.
type InputFile struct {
	// GcsSource: Google Cloud Storage file source.
	GcsSource *GcsInputSource `json:"gcsSource,omitempty"`
	// Usage: Optional. Usage of the file contents. Options are
	// TRAIN|VALIDATION|TEST, or UNASSIGNED (by default) for auto split.
	Usage string `json:"usage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputFile) MarshalJSON() ([]byte, error) {
	type NoMethod InputFile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LanguageCodePair: Used with unidirectional glossaries.
type LanguageCodePair struct {
	// SourceLanguageCode: Required. The ISO-639 language code of the input text,
	// for example, "en-US". Expected to be an exact match for
	// GlossaryTerm.language_code.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCode: Required. The ISO-639 language code for translation
	// output, for example, "zh-CN". Expected to be an exact match for
	// GlossaryTerm.language_code.
	TargetLanguageCode string `json:"targetLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceLanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceLanguageCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LanguageCodePair) MarshalJSON() ([]byte, error) {
	type NoMethod LanguageCodePair
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LanguageCodesSet: Used with equivalent term set glossaries.
type LanguageCodesSet struct {
	// LanguageCodes: The ISO-639 language code(s) for terms defined in the
	// glossary. All entries are unique. The list contains at least two entries.
	// Expected to be an exact match for GlossaryTerm.language_code.
	LanguageCodes []string `json:"languageCodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCodes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCodes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LanguageCodesSet) MarshalJSON() ([]byte, error) {
	type NoMethod LanguageCodesSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAdaptiveMtDatasetsResponse: A list of AdaptiveMtDatasets.
type ListAdaptiveMtDatasetsResponse struct {
	// AdaptiveMtDatasets: Output only. A list of Adaptive MT datasets.
	AdaptiveMtDatasets []*AdaptiveMtDataset `json:"adaptiveMtDatasets,omitempty"`
	// NextPageToken: Optional. A token to retrieve a page of results. Pass this
	// value in the [ListAdaptiveMtDatasetsRequest.page_token] field in the
	// subsequent call to `ListAdaptiveMtDatasets` method to retrieve the next page
	// of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdaptiveMtDatasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdaptiveMtDatasets") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAdaptiveMtDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAdaptiveMtDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAdaptiveMtFilesResponse: The response for listing all AdaptiveMt files
// under a given dataset.
type ListAdaptiveMtFilesResponse struct {
	// AdaptiveMtFiles: Output only. The Adaptive MT files.
	AdaptiveMtFiles []*AdaptiveMtFile `json:"adaptiveMtFiles,omitempty"`
	// NextPageToken: Optional. A token to retrieve a page of results. Pass this
	// value in the ListAdaptiveMtFilesRequest.page_token field in the subsequent
	// call to `ListAdaptiveMtFiles` method to retrieve the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdaptiveMtFiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdaptiveMtFiles") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAdaptiveMtFilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAdaptiveMtFilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAdaptiveMtSentencesResponse: List AdaptiveMt sentences response.
type ListAdaptiveMtSentencesResponse struct {
	// AdaptiveMtSentences: Output only. The list of AdaptiveMtSentences.
	AdaptiveMtSentences []*AdaptiveMtSentence `json:"adaptiveMtSentences,omitempty"`
	// NextPageToken: Optional.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdaptiveMtSentences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdaptiveMtSentences") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAdaptiveMtSentencesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAdaptiveMtSentencesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDatasetsResponse: Response message for ListDatasets.
type ListDatasetsResponse struct {
	// Datasets: The datasets read.
	Datasets []*Dataset `json:"datasets,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Pass this token to
	// the page_token field in the ListDatasetsRequest to obtain the corresponding
	// page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListExamplesResponse: Response message for ListExamples.
type ListExamplesResponse struct {
	// Examples: The sentence pairs.
	Examples []*Example `json:"examples,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Pass this token to
	// the page_token field in the ListExamplesRequest to obtain the corresponding
	// page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListExamplesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExamplesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGlossariesResponse: Response message for ListGlossaries.
type ListGlossariesResponse struct {
	// Glossaries: The list of glossaries for a project.
	Glossaries []*Glossary `json:"glossaries,omitempty"`
	// NextPageToken: A token to retrieve a page of results. Pass this value in the
	// [ListGlossariesRequest.page_token] field in the subsequent call to
	// `ListGlossaries` method to retrieve the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Glossaries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Glossaries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGlossariesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGlossariesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListGlossaryEntriesResponse: Response message for ListGlossaryEntries
type ListGlossaryEntriesResponse struct {
	// GlossaryEntries: Optional. The Glossary Entries
	GlossaryEntries []*GlossaryEntry `json:"glossaryEntries,omitempty"`
	// NextPageToken: Optional. A token to retrieve a page of results. Pass this
	// value in the [ListGLossaryEntriesRequest.page_token] field in the subsequent
	// calls.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GlossaryEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlossaryEntries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListGlossaryEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGlossaryEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListModelsResponse: Response message for ListModels.
type ListModelsResponse struct {
	// Models: The models read.
	Models []*Model `json:"models,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Pass this token to
	// the page_token field in the ListModelsRequest to obtain the corresponding
	// page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Model: A trained translation model.
type Model struct {
	// CreateTime: Output only. Timestamp when the model resource was created,
	// which is also when the training started.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: The dataset from which the model is trained, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/datasets/{dataset_id
	// }`
	Dataset string `json:"dataset,omitempty"`
	// DisplayName: The name of the model to show in the interface. The name can be
	// up to 32 characters long and can consist only of ASCII Latin letters A-Z and
	// a-z, underscores (_), and ASCII digits 0-9.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The resource name of the model, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/models/{model_id}`
	Name string `json:"name,omitempty"`
	// SourceLanguageCode: Output only. The BCP-47 language code of the source
	// language.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCode: Output only. The BCP-47 language code of the target
	// language.
	TargetLanguageCode string `json:"targetLanguageCode,omitempty"`
	// TestExampleCount: Output only. Number of examples (sentence pairs) used to
	// test the model.
	TestExampleCount int64 `json:"testExampleCount,omitempty"`
	// TrainExampleCount: Output only. Number of examples (sentence pairs) used to
	// train the model.
	TrainExampleCount int64 `json:"trainExampleCount,omitempty"`
	// UpdateTime: Output only. Timestamp when this model was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ValidateExampleCount: Output only. Number of examples (sentence pairs) used
	// to validate the model.
	ValidateExampleCount int64 `json:"validateExampleCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Model) MarshalJSON() ([]byte, error) {
	type NoMethod Model
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OutputConfig: Output configuration for BatchTranslateText request.
type OutputConfig struct {
	// GcsDestination: Google Cloud Storage destination for output content. For
	// every single input file (for example, gs://a/b/c.[extension]), we generate
	// at most 2 * n output files. (n is the # of target_language_codes in the
	// BatchTranslateTextRequest). Output files (tsv) generated are compliant with
	// RFC 4180 except that record delimiters are '\n' instead of '\r\n'. We don't
	// provide any way to change record delimiters. While the input files are being
	// processed, we write/update an index file 'index.csv' under
	// 'output_uri_prefix' (for example, gs://translation-test/index.csv) The index
	// file is generated/updated as new files are being translated. The format is:
	// input_file,target_language_code,translations_file,errors_file,
	// glossary_translations_file,glossary_errors_file input_file is one file we
	// matched using gcs_source.input_uri. target_language_code is provided in the
	// request. translations_file contains the translations. (details provided
	// below) errors_file contains the errors during processing of the file.
	// (details below). Both translations_file and errors_file could be empty
	// strings if we have no content to output. glossary_translations_file and
	// glossary_errors_file are always empty strings if the input_file is tsv. They
	// could also be empty if we have no content to output. Once a row is present
	// in index.csv, the input/output matching never changes. Callers should also
	// expect all the content in input_file are processed and ready to be consumed
	// (that is, no partial output file is written). Since index.csv will be
	// keeping updated during the process, please make sure there is no custom
	// retention policy applied on the output bucket that may avoid file updating.
	// (https://cloud.google.com/storage/docs/bucket-lock#retention-policy) The
	// format of translations_file (for target language code 'trg') is:
	// `gs://translation_test/a_b_c_'trg'_translations.[extension]` If the input
	// file extension is tsv, the output has the following columns: Column 1: ID of
	// the request provided in the input, if it's not provided in the input, then
	// the input row number is used (0-based). Column 2: source sentence. Column 3:
	// translation without applying a glossary. Empty string if there is an error.
	// Column 4 (only present if a glossary is provided in the request):
	// translation after applying the glossary. Empty string if there is an error
	// applying the glossary. Could be same string as column 3 if there is no
	// glossary applied. If input file extension is a txt or html, the translation
	// is directly written to the output file. If glossary is requested, a separate
	// glossary_translations_file has format of
	// `gs://translation_test/a_b_c_'trg'_glossary_translations.[extension]` The
	// format of errors file (for target language code 'trg') is:
	// `gs://translation_test/a_b_c_'trg'_errors.[extension]` If the input file
	// extension is tsv, errors_file contains the following: Column 1: ID of the
	// request provided in the input, if it's not provided in the input, then the
	// input row number is used (0-based). Column 2: source sentence. Column 3:
	// Error detail for the translation. Could be empty. Column 4 (only present if
	// a glossary is provided in the request): Error when applying the glossary. If
	// the input file extension is txt or html, glossary_error_file will be
	// generated that contains error details. glossary_error_file has format of
	// `gs://translation_test/a_b_c_'trg'_glossary_errors.[extension]`
	GcsDestination *GcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReferenceSentenceConfig: Message of caller-provided reference configuration.
type ReferenceSentenceConfig struct {
	// ReferenceSentencePairLists: Reference sentences pair lists. Each list will
	// be used as the references to translate the sentence under "content" field at
	// the corresponding index. Length of the list is required to be equal to the
	// length of "content" field.
	ReferenceSentencePairLists []*ReferenceSentencePairList `json:"referenceSentencePairLists,omitempty"`
	// SourceLanguageCode: Source language code.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCode: Target language code.
	TargetLanguageCode string `json:"targetLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceSentencePairLists")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceSentencePairLists") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReferenceSentenceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ReferenceSentenceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReferenceSentencePair: A pair of sentences used as reference in source and
// target languages.
type ReferenceSentencePair struct {
	// SourceSentence: Source sentence in the sentence pair.
	SourceSentence string `json:"sourceSentence,omitempty"`
	// TargetSentence: Target sentence in the sentence pair.
	TargetSentence string `json:"targetSentence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceSentence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceSentence") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReferenceSentencePair) MarshalJSON() ([]byte, error) {
	type NoMethod ReferenceSentencePair
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReferenceSentencePairList: A list of reference sentence pairs.
type ReferenceSentencePairList struct {
	// ReferenceSentencePairs: Reference sentence pairs.
	ReferenceSentencePairs []*ReferenceSentencePair `json:"referenceSentencePairs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferenceSentencePairs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferenceSentencePairs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReferenceSentencePairList) MarshalJSON() ([]byte, error) {
	type NoMethod ReferenceSentencePairList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Romanization: A single romanization response.
type Romanization struct {
	// DetectedLanguageCode: The ISO-639 language code of source text in the
	// initial request, detected automatically, if no source language was passed
	// within the initial request. If the source language was passed,
	// auto-detection of the language does not occur and this field is empty.
	DetectedLanguageCode string `json:"detectedLanguageCode,omitempty"`
	// RomanizedText: Romanized text. If an error occurs during romanization, this
	// field might be excluded from the response.
	RomanizedText string `json:"romanizedText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguageCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Romanization) MarshalJSON() ([]byte, error) {
	type NoMethod Romanization
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RomanizeTextRequest: The request message for synchronous romanization.
type RomanizeTextRequest struct {
	// Contents: Required. The content of the input in string format.
	Contents []string `json:"contents,omitempty"`
	// SourceLanguageCode: Optional. The ISO-639 language code of the input text if
	// known, for example, "hi" or "zh". If the source language isn't specified,
	// the API attempts to identify the source language automatically and returns
	// the source language for each content in the response.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RomanizeTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RomanizeTextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RomanizeTextResponse: The response message for synchronous romanization.
type RomanizeTextResponse struct {
	// Romanizations: Text romanization responses. This field has the same length
	// as `contents`.
	Romanizations []*Romanization `json:"romanizations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Romanizations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Romanizations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RomanizeTextResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RomanizeTextResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SupportedLanguage: A single supported language response corresponds to
// information related to one supported language.
type SupportedLanguage struct {
	// DisplayName: Human-readable name of the language localized in the display
	// language specified in the request.
	DisplayName string `json:"displayName,omitempty"`
	// LanguageCode: Supported language code, generally consisting of its ISO 639-1
	// identifier, for example, 'en', 'ja'. In certain cases, ISO-639 codes
	// including language and region identifiers are returned (for example, 'zh-TW'
	// and 'zh-CN').
	LanguageCode string `json:"languageCode,omitempty"`
	// SupportSource: Can be used as a source language.
	SupportSource bool `json:"supportSource,omitempty"`
	// SupportTarget: Can be used as a target language.
	SupportTarget bool `json:"supportTarget,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SupportedLanguage) MarshalJSON() ([]byte, error) {
	type NoMethod SupportedLanguage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SupportedLanguages: The response message for discovering supported
// languages.
type SupportedLanguages struct {
	// Languages: A list of supported language responses. This list contains an
	// entry for each language the Translation API supports.
	Languages []*SupportedLanguage `json:"languages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Languages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Languages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SupportedLanguages) MarshalJSON() ([]byte, error) {
	type NoMethod SupportedLanguages
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TranslateDocumentRequest: A document translation request.
type TranslateDocumentRequest struct {
	// CustomizedAttribution: Optional. This flag is to support user customized
	// attribution. If not provided, the default is `Machine Translated by Google`.
	// Customized attribution should follow rules in
	// https://cloud.google.com/translate/attribution#attribution_and_logos
	CustomizedAttribution string `json:"customizedAttribution,omitempty"`
	// DocumentInputConfig: Required. Input configurations.
	DocumentInputConfig *DocumentInputConfig `json:"documentInputConfig,omitempty"`
	// DocumentOutputConfig: Optional. Output configurations. Defines if the output
	// file should be stored within Cloud Storage as well as the desired output
	// format. If not provided the translated file will only be returned through a
	// byte-stream and its output mime type will be the same as the input file's
	// mime type.
	DocumentOutputConfig *DocumentOutputConfig `json:"documentOutputConfig,omitempty"`
	// EnableRotationCorrection: Optional. If true, enable auto rotation correction
	// in DVS.
	EnableRotationCorrection bool `json:"enableRotationCorrection,omitempty"`
	// EnableShadowRemovalNativePdf: Optional. If true, use the text removal server
	// to remove the shadow text on background image for native pdf translation.
	// Shadow removal feature can only be enabled when
	// is_translate_native_pdf_only: false && pdf_native_only: false
	EnableShadowRemovalNativePdf bool `json:"enableShadowRemovalNativePdf,omitempty"`
	// GlossaryConfig: Optional. Glossary to be applied. The glossary must be
	// within the same region (have the same location-id) as the model, otherwise
	// an INVALID_ARGUMENT (400) error is returned.
	GlossaryConfig *TranslateTextGlossaryConfig `json:"glossaryConfig,omitempty"`
	// IsTranslateNativePdfOnly: Optional. is_translate_native_pdf_only field for
	// external customers. If true, the page limit of online native pdf translation
	// is 300 and only native pdf pages will be translated.
	IsTranslateNativePdfOnly bool `json:"isTranslateNativePdfOnly,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request.
	// Label keys and values can be no longer than 63 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter. See
	// https://cloud.google.com/translate/docs/advanced/labels for more
	// information.
	Labels map[string]string `json:"labels,omitempty"`
	// Model: Optional. The `model` type requested for this translation. The format
	// depends on model type: - AutoML Translation models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	// - General (built-in) models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//  If not provided, the default Google model (NMT) will be used for
	// translation.
	Model string `json:"model,omitempty"`
	// SourceLanguageCode: Optional. The ISO-639 language code of the input
	// document if known, for example, "en-US" or "sr-Latn". Supported language
	// codes are listed in Language Support. If the source language isn't
	// specified, the API attempts to identify the source language automatically
	// and returns the source language within the response. Source language must be
	// specified if the request contains a glossary or a custom model.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCode: Required. The ISO-639 language code to use for
	// translation of the input document, set to one of the language codes listed
	// in Language Support.
	TargetLanguageCode string `json:"targetLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomizedAttribution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomizedAttribution") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TranslateDocumentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TranslateDocumentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TranslateDocumentResponse: A translated document response message.
type TranslateDocumentResponse struct {
	// DocumentTranslation: Translated document.
	DocumentTranslation *DocumentTranslation `json:"documentTranslation,omitempty"`
	// GlossaryConfig: The `glossary_config` used for this translation.
	GlossaryConfig *TranslateTextGlossaryConfig `json:"glossaryConfig,omitempty"`
	// GlossaryDocumentTranslation: The document's translation output if a glossary
	// is provided in the request. This can be the same as
	// [TranslateDocumentResponse.document_translation] if no glossary terms apply.
	GlossaryDocumentTranslation *DocumentTranslation `json:"glossaryDocumentTranslation,omitempty"`
	// Model: Only present when 'model' is present in the request. 'model' is
	// normalized to have a project number. For example: If the 'model' field in
	// TranslateDocumentRequest is:
	// `projects/{project-id}/locations/{location-id}/models/general/nmt` then
	// `model` here would be normalized to
	// `projects/{project-number}/locations/{location-id}/models/general/nmt`.
	Model string `json:"model,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DocumentTranslation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentTranslation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TranslateDocumentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TranslateDocumentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TranslateTextGlossaryConfig: Configures which glossary is used for a
// specific target language and defines options for applying that glossary.
type TranslateTextGlossaryConfig struct {
	// ContextualTranslationEnabled: Optional. If set to true, the glossary will be
	// used for contextual translation.
	ContextualTranslationEnabled bool `json:"contextualTranslationEnabled,omitempty"`
	// Glossary: Required. The `glossary` to be applied for this translation. The
	// format depends on the glossary: - User-provided custom glossary:
	// `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary
	// -id}`
	Glossary string `json:"glossary,omitempty"`
	// IgnoreCase: Optional. Indicates match is case insensitive. The default value
	// is `false` if missing.
	IgnoreCase bool `json:"ignoreCase,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ContextualTranslationEnabled") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextualTranslationEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TranslateTextGlossaryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod TranslateTextGlossaryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TranslateTextRequest: The request message for synchronous translation.
type TranslateTextRequest struct {
	// Contents: Required. The content of the input in string format. We recommend
	// the total content be less than 30,000 codepoints. The max length of this
	// field is 1024. Use BatchTranslateText for larger text.
	Contents []string `json:"contents,omitempty"`
	// GlossaryConfig: Optional. Glossary to be applied. The glossary must be
	// within the same region (have the same location-id) as the model, otherwise
	// an INVALID_ARGUMENT (400) error is returned.
	GlossaryConfig *TranslateTextGlossaryConfig `json:"glossaryConfig,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request.
	// Label keys and values can be no longer than 63 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter. See
	// https://cloud.google.com/translate/docs/advanced/labels for more
	// information.
	Labels map[string]string `json:"labels,omitempty"`
	// MimeType: Optional. The format of the source text, for example, "text/html",
	// "text/plain". If left blank, the MIME type defaults to "text/html".
	MimeType string `json:"mimeType,omitempty"`
	// Model: Optional. The `model` type requested for this translation. The format
	// depends on model type: - AutoML Translation models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
	// - General (built-in) models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
	//  - Translation LLM models:
	// `projects/{project-number-or-id}/locations/{location-id}/models/general/trans
	// lation-llm`, For global (non-regionalized) requests, use `location-id`
	// `global`. For example,
	// `projects/{project-number-or-id}/locations/global/models/general/nmt`. If
	// not provided, the default Google model (NMT) will be used
	Model string `json:"model,omitempty"`
	// SourceLanguageCode: Optional. The ISO-639 language code of the input text if
	// known, for example, "en-US" or "sr-Latn". Supported language codes are
	// listed in Language Support. If the source language isn't specified, the API
	// attempts to identify the source language automatically and returns the
	// source language within the response.
	SourceLanguageCode string `json:"sourceLanguageCode,omitempty"`
	// TargetLanguageCode: Required. The ISO-639 language code to use for
	// translation of the input text, set to one of the language codes listed in
	// Language Support.
	TargetLanguageCode string `json:"targetLanguageCode,omitempty"`
	// TransliterationConfig: Optional. Transliteration to be applied.
	TransliterationConfig *TransliterationConfig `json:"transliterationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TranslateTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TranslateTextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TranslateTextResponse struct {
	// GlossaryTranslations: Text translation responses if a glossary is provided
	// in the request. This can be the same as `translations` if no terms apply.
	// This field has the same length as `contents`.
	GlossaryTranslations []*Translation `json:"glossaryTranslations,omitempty"`
	// Translations: Text translation responses with no glossary applied. This
	// field has the same length as `contents`.
	Translations []*Translation `json:"translations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GlossaryTranslations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlossaryTranslations") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TranslateTextResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TranslateTextResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Translation: A single translation response.
type Translation struct {
	// DetectedLanguageCode: The ISO-639 language code of source text in the
	// initial request, detected automatically, if no source language was passed
	// within the initial request. If the source language was passed,
	// auto-detection of the language does not occur and this field is empty.
	DetectedLanguageCode string `json:"detectedLanguageCode,omitempty"`
	// GlossaryConfig: The `glossary_config` used for this translation.
	GlossaryConfig *TranslateTextGlossaryConfig `json:"glossaryConfig,omitempty"`
	// Model: Only present when `model` is present in the request. `model` here is
	// normalized to have project number. For example: If the `model` requested in
	// TranslationTextRequest is
	// `projects/{project-id}/locations/{location-id}/models/general/nmt` then
	// `model` here would be normalized to
	// `projects/{project-number}/locations/{location-id}/models/general/nmt`.
	Model string `json:"model,omitempty"`
	// TranslatedText: Text translated into the target language. If an error occurs
	// during translation, this field might be excluded from the response.
	TranslatedText string `json:"translatedText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectedLanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectedLanguageCode") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Translation) MarshalJSON() ([]byte, error) {
	type NoMethod Translation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransliterationConfig: Configures transliteration feature on top of
// translation.
type TransliterationConfig struct {
	// EnableTransliteration: If true, source text in romanized form can be
	// translated to the target language.
	EnableTransliteration bool `json:"enableTransliteration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableTransliteration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableTransliteration") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransliterationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod TransliterationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WaitOperationRequest: The request message for Operations.WaitOperation.
type WaitOperationRequest struct {
	// Timeout: The maximum duration to wait before timing out. If left blank, the
	// wait will be at most the time permitted by the underlying HTTP/RPC protocol.
	// If RPC context deadline is also specified, the shorter one will be used.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Timeout") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Timeout") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WaitOperationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod WaitOperationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsDetectLanguageCall struct {
	s                     *Service
	parent                string
	detectlanguagerequest *DetectLanguageRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// DetectLanguage: Detects the language of text within a request.
//
//   - parent: Project or location to make a call. Must refer to a caller's
//     project. Format: `projects/{project-number-or-id}/locations/{location-id}`
//     or `projects/{project-number-or-id}`. For global calls, use
//     `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`. Only models within the same region (has
//     same location-id) can be used. Otherwise an INVALID_ARGUMENT (400) error
//     is returned.
func (r *ProjectsService) DetectLanguage(parent string, detectlanguagerequest *DetectLanguageRequest) *ProjectsDetectLanguageCall {
	c := &ProjectsDetectLanguageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.detectlanguagerequest = detectlanguagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDetectLanguageCall) Fields(s ...googleapi.Field) *ProjectsDetectLanguageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDetectLanguageCall) Context(ctx context.Context) *ProjectsDetectLanguageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDetectLanguageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDetectLanguageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.detectlanguagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:detectLanguage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.detectLanguage", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.detectLanguage" call.
// Any non-2xx status code is an error. Response headers are in either
// *DetectLanguageResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDetectLanguageCall) Do(opts ...googleapi.CallOption) (*DetectLanguageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DetectLanguageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.detectLanguage", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGetSupportedLanguagesCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSupportedLanguages: Returns a list of supported languages for
// translation.
//
//   - parent: Project or location to make a call. Must refer to a caller's
//     project. Format: `projects/{project-number-or-id}` or
//     `projects/{project-number-or-id}/locations/{location-id}`. For global
//     calls, use `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`. Non-global location is required for
//     AutoML models. Only models within the same region (have same location-id)
//     can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
func (r *ProjectsService) GetSupportedLanguages(parent string) *ProjectsGetSupportedLanguagesCall {
	c := &ProjectsGetSupportedLanguagesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// DisplayLanguageCode sets the optional parameter "displayLanguageCode": The
// language to use to return localized, human readable names of supported
// languages. If missing, then display names are not returned in a response.
func (c *ProjectsGetSupportedLanguagesCall) DisplayLanguageCode(displayLanguageCode string) *ProjectsGetSupportedLanguagesCall {
	c.urlParams_.Set("displayLanguageCode", displayLanguageCode)
	return c
}

// Model sets the optional parameter "model": Get supported languages of this
// model. The format depends on model type: - AutoML Translation models:
// `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
// - General (built-in) models:
// `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
//
//	Returns languages supported by the specified model. If missing, we get
//
// supported languages of Google general NMT model.
func (c *ProjectsGetSupportedLanguagesCall) Model(model string) *ProjectsGetSupportedLanguagesCall {
	c.urlParams_.Set("model", model)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetSupportedLanguagesCall) Fields(s ...googleapi.Field) *ProjectsGetSupportedLanguagesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetSupportedLanguagesCall) IfNoneMatch(entityTag string) *ProjectsGetSupportedLanguagesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetSupportedLanguagesCall) Context(ctx context.Context) *ProjectsGetSupportedLanguagesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetSupportedLanguagesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetSupportedLanguagesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/supportedLanguages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.getSupportedLanguages", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.getSupportedLanguages" call.
// Any non-2xx status code is an error. Response headers are in either
// *SupportedLanguages.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsGetSupportedLanguagesCall) Do(opts ...googleapi.CallOption) (*SupportedLanguages, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SupportedLanguages{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.getSupportedLanguages", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRomanizeTextCall struct {
	s                   *Service
	parent              string
	romanizetextrequest *RomanizeTextRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// RomanizeText: Romanize input text written in non-Latin scripts to Latin
// text.
//
//   - parent: Project or location to make a call. Must refer to a caller's
//     project. Format: `projects/{project-number-or-id}/locations/{location-id}`
//     or `projects/{project-number-or-id}`. For global calls, use
//     `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`.
func (r *ProjectsService) RomanizeText(parent string, romanizetextrequest *RomanizeTextRequest) *ProjectsRomanizeTextCall {
	c := &ProjectsRomanizeTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.romanizetextrequest = romanizetextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRomanizeTextCall) Fields(s ...googleapi.Field) *ProjectsRomanizeTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRomanizeTextCall) Context(ctx context.Context) *ProjectsRomanizeTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRomanizeTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRomanizeTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.romanizetextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:romanizeText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.romanizeText", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.romanizeText" call.
// Any non-2xx status code is an error. Response headers are in either
// *RomanizeTextResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsRomanizeTextCall) Do(opts ...googleapi.CallOption) (*RomanizeTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RomanizeTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.romanizeText", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTranslateTextCall struct {
	s                    *Service
	parent               string
	translatetextrequest *TranslateTextRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// TranslateText: Translates input text and returns translated text.
//
//   - parent: Project or location to make a call. Must refer to a caller's
//     project. Format: `projects/{project-number-or-id}` or
//     `projects/{project-number-or-id}/locations/{location-id}`. For global
//     calls, use `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`. Non-global location is required for
//     requests using AutoML models or custom glossaries. Models and glossaries
//     must be within the same region (have same location-id), otherwise an
//     INVALID_ARGUMENT (400) error is returned.
func (r *ProjectsService) TranslateText(parent string, translatetextrequest *TranslateTextRequest) *ProjectsTranslateTextCall {
	c := &ProjectsTranslateTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.translatetextrequest = translatetextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTranslateTextCall) Fields(s ...googleapi.Field) *ProjectsTranslateTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTranslateTextCall) Context(ctx context.Context) *ProjectsTranslateTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTranslateTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTranslateTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.translatetextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:translateText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.translateText", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.translateText" call.
// Any non-2xx status code is an error. Response headers are in either
// *TranslateTextResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsTranslateTextCall) Do(opts ...googleapi.CallOption) (*TranslateTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TranslateTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.translateText", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAdaptiveMtTranslateCall struct {
	s                          *Service
	parent                     string
	adaptivemttranslaterequest *AdaptiveMtTranslateRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// AdaptiveMtTranslate: Translate text using Adaptive MT.
//
//   - parent: Location to make a regional call. Format:
//     `projects/{project-number-or-id}/locations/{location-id}`.
func (r *ProjectsLocationsService) AdaptiveMtTranslate(parent string, adaptivemttranslaterequest *AdaptiveMtTranslateRequest) *ProjectsLocationsAdaptiveMtTranslateCall {
	c := &ProjectsLocationsAdaptiveMtTranslateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.adaptivemttranslaterequest = adaptivemttranslaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtTranslateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtTranslateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtTranslateCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtTranslateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtTranslateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtTranslateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.adaptivemttranslaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:adaptiveMtTranslate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtTranslate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtTranslate" call.
// Any non-2xx status code is an error. Response headers are in either
// *AdaptiveMtTranslateResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtTranslateCall) Do(opts ...googleapi.CallOption) (*AdaptiveMtTranslateResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AdaptiveMtTranslateResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtTranslate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchTranslateDocumentCall struct {
	s                             *Service
	parent                        string
	batchtranslatedocumentrequest *BatchTranslateDocumentRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// BatchTranslateDocument: Translates a large volume of document in
// asynchronous batch mode. This function provides real-time output as the
// inputs are being processed. If caller cancels a request, the partial results
// (for an input file, it's all or nothing) may still be available on the
// specified output location. This call returns immediately and you can use
// google.longrunning.Operation.name to poll the status of the call.
//
//   - parent: Location to make a regional call. Format:
//     `projects/{project-number-or-id}/locations/{location-id}`. The `global`
//     location is not supported for batch translation. Only AutoML Translation
//     models or glossaries within the same region (have the same location-id)
//     can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
func (r *ProjectsLocationsService) BatchTranslateDocument(parent string, batchtranslatedocumentrequest *BatchTranslateDocumentRequest) *ProjectsLocationsBatchTranslateDocumentCall {
	c := &ProjectsLocationsBatchTranslateDocumentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchtranslatedocumentrequest = batchtranslatedocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchTranslateDocumentCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchTranslateDocumentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchTranslateDocumentCall) Context(ctx context.Context) *ProjectsLocationsBatchTranslateDocumentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchTranslateDocumentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchTranslateDocumentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchtranslatedocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:batchTranslateDocument")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.batchTranslateDocument", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.batchTranslateDocument" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchTranslateDocumentCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.batchTranslateDocument", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchTranslateTextCall struct {
	s                         *Service
	parent                    string
	batchtranslatetextrequest *BatchTranslateTextRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// BatchTranslateText: Translates a large volume of text in asynchronous batch
// mode. This function provides real-time output as the inputs are being
// processed. If caller cancels a request, the partial results (for an input
// file, it's all or nothing) may still be available on the specified output
// location. This call returns immediately and you can use
// google.longrunning.Operation.name to poll the status of the call.
//
//   - parent: Location to make a call. Must refer to a caller's project. Format:
//     `projects/{project-number-or-id}/locations/{location-id}`. The `global`
//     location is not supported for batch translation. Only AutoML Translation
//     models or glossaries within the same region (have the same location-id)
//     can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
func (r *ProjectsLocationsService) BatchTranslateText(parent string, batchtranslatetextrequest *BatchTranslateTextRequest) *ProjectsLocationsBatchTranslateTextCall {
	c := &ProjectsLocationsBatchTranslateTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batchtranslatetextrequest = batchtranslatetextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchTranslateTextCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchTranslateTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchTranslateTextCall) Context(ctx context.Context) *ProjectsLocationsBatchTranslateTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchTranslateTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchTranslateTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchtranslatetextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:batchTranslateText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.batchTranslateText", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.batchTranslateText" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchTranslateTextCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.batchTranslateText", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDetectLanguageCall struct {
	s                     *Service
	parent                string
	detectlanguagerequest *DetectLanguageRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// DetectLanguage: Detects the language of text within a request.
//
//   - parent: Project or location to make a call. Must refer to a caller's
//     project. Format: `projects/{project-number-or-id}/locations/{location-id}`
//     or `projects/{project-number-or-id}`. For global calls, use
//     `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`. Only models within the same region (has
//     same location-id) can be used. Otherwise an INVALID_ARGUMENT (400) error
//     is returned.
func (r *ProjectsLocationsService) DetectLanguage(parent string, detectlanguagerequest *DetectLanguageRequest) *ProjectsLocationsDetectLanguageCall {
	c := &ProjectsLocationsDetectLanguageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.detectlanguagerequest = detectlanguagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDetectLanguageCall) Fields(s ...googleapi.Field) *ProjectsLocationsDetectLanguageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDetectLanguageCall) Context(ctx context.Context) *ProjectsLocationsDetectLanguageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDetectLanguageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDetectLanguageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.detectlanguagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:detectLanguage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.detectLanguage", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.detectLanguage" call.
// Any non-2xx status code is an error. Response headers are in either
// *DetectLanguageResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDetectLanguageCall) Do(opts ...googleapi.CallOption) (*DetectLanguageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DetectLanguageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.detectLanguage", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetSupportedLanguagesCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSupportedLanguages: Returns a list of supported languages for
// translation.
//
//   - parent: Project or location to make a call. Must refer to a caller's
//     project. Format: `projects/{project-number-or-id}` or
//     `projects/{project-number-or-id}/locations/{location-id}`. For global
//     calls, use `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`. Non-global location is required for
//     AutoML models. Only models within the same region (have same location-id)
//     can be used, otherwise an INVALID_ARGUMENT (400) error is returned.
func (r *ProjectsLocationsService) GetSupportedLanguages(parent string) *ProjectsLocationsGetSupportedLanguagesCall {
	c := &ProjectsLocationsGetSupportedLanguagesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// DisplayLanguageCode sets the optional parameter "displayLanguageCode": The
// language to use to return localized, human readable names of supported
// languages. If missing, then display names are not returned in a response.
func (c *ProjectsLocationsGetSupportedLanguagesCall) DisplayLanguageCode(displayLanguageCode string) *ProjectsLocationsGetSupportedLanguagesCall {
	c.urlParams_.Set("displayLanguageCode", displayLanguageCode)
	return c
}

// Model sets the optional parameter "model": Get supported languages of this
// model. The format depends on model type: - AutoML Translation models:
// `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
// - General (built-in) models:
// `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
//
//	Returns languages supported by the specified model. If missing, we get
//
// supported languages of Google general NMT model.
func (c *ProjectsLocationsGetSupportedLanguagesCall) Model(model string) *ProjectsLocationsGetSupportedLanguagesCall {
	c.urlParams_.Set("model", model)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetSupportedLanguagesCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetSupportedLanguagesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetSupportedLanguagesCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetSupportedLanguagesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetSupportedLanguagesCall) Context(ctx context.Context) *ProjectsLocationsGetSupportedLanguagesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetSupportedLanguagesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetSupportedLanguagesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/supportedLanguages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.getSupportedLanguages", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.getSupportedLanguages" call.
// Any non-2xx status code is an error. Response headers are in either
// *SupportedLanguages.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGetSupportedLanguagesCall) Do(opts ...googleapi.CallOption) (*SupportedLanguages, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SupportedLanguages{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.getSupportedLanguages", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsRomanizeTextCall struct {
	s                   *Service
	parent              string
	romanizetextrequest *RomanizeTextRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// RomanizeText: Romanize input text written in non-Latin scripts to Latin
// text.
//
//   - parent: Project or location to make a call. Must refer to a caller's
//     project. Format: `projects/{project-number-or-id}/locations/{location-id}`
//     or `projects/{project-number-or-id}`. For global calls, use
//     `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`.
func (r *ProjectsLocationsService) RomanizeText(parent string, romanizetextrequest *RomanizeTextRequest) *ProjectsLocationsRomanizeTextCall {
	c := &ProjectsLocationsRomanizeTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.romanizetextrequest = romanizetextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRomanizeTextCall) Fields(s ...googleapi.Field) *ProjectsLocationsRomanizeTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRomanizeTextCall) Context(ctx context.Context) *ProjectsLocationsRomanizeTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRomanizeTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRomanizeTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.romanizetextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:romanizeText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.romanizeText", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.romanizeText" call.
// Any non-2xx status code is an error. Response headers are in either
// *RomanizeTextResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRomanizeTextCall) Do(opts ...googleapi.CallOption) (*RomanizeTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RomanizeTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.romanizeText", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTranslateDocumentCall struct {
	s                        *Service
	parent                   string
	translatedocumentrequest *TranslateDocumentRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// TranslateDocument: Translates documents in synchronous mode.
//
//   - parent: Location to make a regional call. Format:
//     `projects/{project-number-or-id}/locations/{location-id}`. For global
//     calls, use `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`. Non-global location is required for
//     requests using AutoML models or custom glossaries. Models and glossaries
//     must be within the same region (have the same location-id), otherwise an
//     INVALID_ARGUMENT (400) error is returned.
func (r *ProjectsLocationsService) TranslateDocument(parent string, translatedocumentrequest *TranslateDocumentRequest) *ProjectsLocationsTranslateDocumentCall {
	c := &ProjectsLocationsTranslateDocumentCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.translatedocumentrequest = translatedocumentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTranslateDocumentCall) Fields(s ...googleapi.Field) *ProjectsLocationsTranslateDocumentCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTranslateDocumentCall) Context(ctx context.Context) *ProjectsLocationsTranslateDocumentCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTranslateDocumentCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTranslateDocumentCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.translatedocumentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:translateDocument")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.translateDocument", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.translateDocument" call.
// Any non-2xx status code is an error. Response headers are in either
// *TranslateDocumentResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsTranslateDocumentCall) Do(opts ...googleapi.CallOption) (*TranslateDocumentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TranslateDocumentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.translateDocument", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsTranslateTextCall struct {
	s                    *Service
	parent               string
	translatetextrequest *TranslateTextRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// TranslateText: Translates input text and returns translated text.
//
//   - parent: Project or location to make a call. Must refer to a caller's
//     project. Format: `projects/{project-number-or-id}` or
//     `projects/{project-number-or-id}/locations/{location-id}`. For global
//     calls, use `projects/{project-number-or-id}/locations/global` or
//     `projects/{project-number-or-id}`. Non-global location is required for
//     requests using AutoML models or custom glossaries. Models and glossaries
//     must be within the same region (have same location-id), otherwise an
//     INVALID_ARGUMENT (400) error is returned.
func (r *ProjectsLocationsService) TranslateText(parent string, translatetextrequest *TranslateTextRequest) *ProjectsLocationsTranslateTextCall {
	c := &ProjectsLocationsTranslateTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.translatetextrequest = translatetextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsTranslateTextCall) Fields(s ...googleapi.Field) *ProjectsLocationsTranslateTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsTranslateTextCall) Context(ctx context.Context) *ProjectsLocationsTranslateTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsTranslateTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsTranslateTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.translatetextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:translateText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.translateText", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.translateText" call.
// Any non-2xx status code is an error. Response headers are in either
// *TranslateTextResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsTranslateTextCall) Do(opts ...googleapi.CallOption) (*TranslateTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TranslateTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.translateText", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAdaptiveMtDatasetsCreateCall struct {
	s                 *Service
	parent            string
	adaptivemtdataset *AdaptiveMtDataset
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates an Adaptive MT dataset.
//
//   - parent: Name of the parent project. In form of
//     `projects/{project-number-or-id}/locations/{location-id}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsService) Create(parent string, adaptivemtdataset *AdaptiveMtDataset) *ProjectsLocationsAdaptiveMtDatasetsCreateCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.adaptivemtdataset = adaptivemtdataset
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsCreateCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.adaptivemtdataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/adaptiveMtDatasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AdaptiveMtDataset.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsCreateCall) Do(opts ...googleapi.CallOption) (*AdaptiveMtDataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AdaptiveMtDataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAdaptiveMtDatasetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an Adaptive MT dataset, including all its entries and
// associated metadata.
//
//   - name: Name of the dataset. In the form of
//     `projects/{project-number-or-id}/locations/{location-id}/adaptiveMtDatasets
//     /{adaptive-mt-dataset-id}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsService) Delete(name string) *ProjectsLocationsAdaptiveMtDatasetsDeleteCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAdaptiveMtDatasetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the Adaptive MT dataset.
//
//   - name: Name of the dataset. In the form of
//     `projects/{project-number-or-id}/locations/{location-id}/adaptiveMtDatasets
//     /{adaptive-mt-dataset-id}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsService) Get(name string) *ProjectsLocationsAdaptiveMtDatasetsGetCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAdaptiveMtDatasetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAdaptiveMtDatasetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsGetCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AdaptiveMtDataset.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsGetCall) Do(opts ...googleapi.CallOption) (*AdaptiveMtDataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AdaptiveMtDataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall struct {
	s                           *Service
	parent                      string
	importadaptivemtfilerequest *ImportAdaptiveMtFileRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// ImportAdaptiveMtFile: Imports an AdaptiveMtFile and adds all of its
// sentences into the AdaptiveMtDataset.
//
//   - parent: The resource name of the file, in form of
//     `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets
//     /{dataset}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsService) ImportAdaptiveMtFile(parent string, importadaptivemtfilerequest *ImportAdaptiveMtFileRequest) *ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.importadaptivemtfilerequest = importadaptivemtfilerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importadaptivemtfilerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}:importAdaptiveMtFile")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.importAdaptiveMtFile", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.importAdaptiveMtFile" call.
// Any non-2xx status code is an error. Response headers are in either
// *ImportAdaptiveMtFileResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsImportAdaptiveMtFileCall) Do(opts ...googleapi.CallOption) (*ImportAdaptiveMtFileResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ImportAdaptiveMtFileResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.importAdaptiveMtFile", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAdaptiveMtDatasetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all Adaptive MT datasets for which the caller has read
// permission.
//
//   - parent: The resource name of the project from which to list the Adaptive
//     MT datasets. `projects/{project-number-or-id}/locations/{location-id}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsService) List(parent string) *ProjectsLocationsAdaptiveMtDatasetsListCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request. Filter is not supported yet.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) Filter(filter string) *ProjectsLocationsAdaptiveMtDatasetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. If unspecified, the server
// picks an appropriate default.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) PageSize(pageSize int64) *ProjectsLocationsAdaptiveMtDatasetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListAdaptiveMtDatasetsResponse.next_page_token returned from the previous
// call to `ListAdaptiveMtDatasets` method. The first page is returned if
// `page_token`is empty or missing.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) PageToken(pageToken string) *ProjectsLocationsAdaptiveMtDatasetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAdaptiveMtDatasetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/adaptiveMtDatasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAdaptiveMtDatasetsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) Do(opts ...googleapi.CallOption) (*ListAdaptiveMtDatasetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAdaptiveMtDatasetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAdaptiveMtDatasetsListCall) Pages(ctx context.Context, f func(*ListAdaptiveMtDatasetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an AdaptiveMtFile along with its sentences.
//
//   - name: The resource name of the file to delete, in form of
//     `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets
//     /{dataset}/adaptiveMtFiles/{file}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService) Delete(name string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets and AdaptiveMtFile
//
//   - name: The resource name of the file, in form of
//     `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets
//     /{dataset}/adaptiveMtFiles/{file}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService) Get(name string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AdaptiveMtFile.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesGetCall) Do(opts ...googleapi.CallOption) (*AdaptiveMtFile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AdaptiveMtFile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all AdaptiveMtFiles associated to an AdaptiveMtDataset.
//
//   - parent: The resource name of the project from which to list the Adaptive
//     MT files.
//     `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesService) List(parent string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) PageSize(pageSize int64) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListAdaptiveMtFilesResponse.next_page_token returned from the previous call
// to `ListAdaptiveMtFiles` method. The first page is returned if
// `page_token`is empty or missing.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) PageToken(pageToken string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/adaptiveMtFiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAdaptiveMtFilesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) Do(opts ...googleapi.CallOption) (*ListAdaptiveMtFilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAdaptiveMtFilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesListCall) Pages(ctx context.Context, f func(*ListAdaptiveMtFilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all AdaptiveMtSentences under a given file/dataset.
//
//   - parent: The resource name of the project from which to list the Adaptive
//     MT files. The following format lists all sentences under a file.
//     `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adapt
//     iveMtFiles/{file}` The following format lists all sentences within a
//     dataset.
//     `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesService) List(parent string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) PageSize(pageSize int64) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListAdaptiveMtSentencesRequest.next_page_token returned from the previous
// call to `ListTranslationMemories` method. The first page is returned if
// `page_token` is empty or missing.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) PageToken(pageToken string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/adaptiveMtSentences")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.adaptiveMtSentences.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.adaptiveMtSentences.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAdaptiveMtSentencesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) Do(opts ...googleapi.CallOption) (*ListAdaptiveMtSentencesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAdaptiveMtSentencesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtFiles.adaptiveMtSentences.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtFilesAdaptiveMtSentencesListCall) Pages(ctx context.Context, f func(*ListAdaptiveMtSentencesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all AdaptiveMtSentences under a given file/dataset.
//
//   - parent: The resource name of the project from which to list the Adaptive
//     MT files. The following format lists all sentences under a file.
//     `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adapt
//     iveMtFiles/{file}` The following format lists all sentences within a
//     dataset.
//     `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`.
func (r *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesService) List(parent string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall {
	c := &ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) PageSize(pageSize int64) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListAdaptiveMtSentencesRequest.next_page_token returned from the previous
// call to `ListTranslationMemories` method. The first page is returned if
// `page_token` is empty or missing.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) PageToken(pageToken string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) Context(ctx context.Context) *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/adaptiveMtSentences")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtSentences.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.adaptiveMtDatasets.adaptiveMtSentences.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAdaptiveMtSentencesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) Do(opts ...googleapi.CallOption) (*ListAdaptiveMtSentencesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAdaptiveMtSentencesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.adaptiveMtDatasets.adaptiveMtSentences.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAdaptiveMtDatasetsAdaptiveMtSentencesListCall) Pages(ctx context.Context, f func(*ListAdaptiveMtSentencesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsCreateCall struct {
	s          *Service
	parent     string
	dataset    *Dataset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a Dataset.
//
// - parent: The project name.
func (r *ProjectsLocationsDatasetsService) Create(parent string, dataset *Dataset) *ProjectsLocationsDatasetsCreateCall {
	c := &ProjectsLocationsDatasetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.dataset = dataset
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsCreateCall) Context(ctx context.Context) *ProjectsLocationsDatasetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.datasets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a dataset and all of its contents.
//
// - name: The name of the dataset to delete.
func (r *ProjectsLocationsDatasetsService) Delete(name string) *ProjectsLocationsDatasetsDeleteCall {
	c := &ProjectsLocationsDatasetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDatasetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.datasets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsExportDataCall struct {
	s                 *Service
	dataset           string
	exportdatarequest *ExportDataRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// ExportData: Exports dataset's data to the provided output location.
//
//   - dataset: Name of the dataset. In form of
//     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-
//     id}`.
func (r *ProjectsLocationsDatasetsService) ExportData(dataset string, exportdatarequest *ExportDataRequest) *ProjectsLocationsDatasetsExportDataCall {
	c := &ProjectsLocationsDatasetsExportDataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataset = dataset
	c.exportdatarequest = exportdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsExportDataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsExportDataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsExportDataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsExportDataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsExportDataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsExportDataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exportdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+dataset}:exportData")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataset": c.dataset,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.exportData", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.datasets.exportData" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsExportDataCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.exportData", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Dataset.
//
// - name: The resource name of the dataset to retrieve.
func (r *ProjectsLocationsDatasetsService) Get(name string) *ProjectsLocationsDatasetsGetCall {
	c := &ProjectsLocationsDatasetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsGetCall) Context(ctx context.Context) *ProjectsLocationsDatasetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.datasets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsGetCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsImportDataCall struct {
	s                 *Service
	dataset           string
	importdatarequest *ImportDataRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// ImportData: Import sentence pairs into translation Dataset.
//
//   - dataset: Name of the dataset. In form of
//     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-
//     id}`.
func (r *ProjectsLocationsDatasetsService) ImportData(dataset string, importdatarequest *ImportDataRequest) *ProjectsLocationsDatasetsImportDataCall {
	c := &ProjectsLocationsDatasetsImportDataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.dataset = dataset
	c.importdatarequest = importdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsImportDataCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsImportDataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsImportDataCall) Context(ctx context.Context) *ProjectsLocationsDatasetsImportDataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsImportDataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsImportDataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.importdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+dataset}:importData")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"dataset": c.dataset,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.importData", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.datasets.importData" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDatasetsImportDataCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.importData", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDatasetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists datasets.
//
//   - parent: Name of the parent project. In form of
//     `projects/{project-number-or-id}/locations/{location-id}`.
func (r *ProjectsLocationsDatasetsService) List(parent string) *ProjectsLocationsDatasetsListCall {
	c := &ProjectsLocationsDatasetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server can return fewer results than requested.
func (c *ProjectsLocationsDatasetsListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained from
// next_page_token field in the response of a ListDatasets call.
func (c *ProjectsLocationsDatasetsListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.datasets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDatasetsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsListCall) Do(opts ...googleapi.CallOption) (*ListDatasetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDatasetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsListCall) Pages(ctx context.Context, f func(*ListDatasetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsDatasetsExamplesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists sentence pairs in the dataset.
//
//   - parent: Name of the parent dataset. In form of
//     `projects/{project-number-or-id}/locations/{location-id}/datasets/{dataset-
//     id}`.
func (r *ProjectsLocationsDatasetsExamplesService) List(parent string) *ProjectsLocationsDatasetsExamplesListCall {
	c := &ProjectsLocationsDatasetsExamplesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// examples that will be returned. Example filter: * `usage=TRAIN`
func (c *ProjectsLocationsDatasetsExamplesListCall) Filter(filter string) *ProjectsLocationsDatasetsExamplesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server can return fewer results than requested.
func (c *ProjectsLocationsDatasetsExamplesListCall) PageSize(pageSize int64) *ProjectsLocationsDatasetsExamplesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained from
// next_page_token field in the response of a ListExamples call.
func (c *ProjectsLocationsDatasetsExamplesListCall) PageToken(pageToken string) *ProjectsLocationsDatasetsExamplesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDatasetsExamplesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDatasetsExamplesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDatasetsExamplesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDatasetsExamplesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDatasetsExamplesListCall) Context(ctx context.Context) *ProjectsLocationsDatasetsExamplesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDatasetsExamplesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDatasetsExamplesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/examples")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.examples.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.datasets.examples.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExamplesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDatasetsExamplesListCall) Do(opts ...googleapi.CallOption) (*ListExamplesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExamplesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.datasets.examples.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDatasetsExamplesListCall) Pages(ctx context.Context, f func(*ListExamplesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGlossariesCreateCall struct {
	s          *Service
	parent     string
	glossary   *Glossary
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a glossary and returns the long-running operation. Returns
// NOT_FOUND, if the project doesn't exist.
//
// - parent: The project name.
func (r *ProjectsLocationsGlossariesService) Create(parent string, glossary *Glossary) *ProjectsLocationsGlossariesCreateCall {
	c := &ProjectsLocationsGlossariesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.glossary = glossary
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesCreateCall) Context(ctx context.Context) *ProjectsLocationsGlossariesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.glossary)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/glossaries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlossariesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a glossary, or cancels glossary construction if the glossary
// isn't created yet. Returns NOT_FOUND, if the glossary doesn't exist.
//
// - name: The name of the glossary to delete.
func (r *ProjectsLocationsGlossariesService) Delete(name string) *ProjectsLocationsGlossariesDeleteCall {
	c := &ProjectsLocationsGlossariesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesDeleteCall) Context(ctx context.Context) *ProjectsLocationsGlossariesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlossariesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a glossary. Returns NOT_FOUND, if the glossary doesn't exist.
//
// - name: The name of the glossary to retrieve.
func (r *ProjectsLocationsGlossariesService) Get(name string) *ProjectsLocationsGlossariesGetCall {
	c := &ProjectsLocationsGlossariesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlossariesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlossariesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesGetCall) Context(ctx context.Context) *ProjectsLocationsGlossariesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Glossary.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesGetCall) Do(opts ...googleapi.CallOption) (*Glossary, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Glossary{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlossariesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists glossaries in a project. Returns NOT_FOUND, if the project
// doesn't exist.
//
// - parent: The name of the project from which to list all of the glossaries.
func (r *ProjectsLocationsGlossariesService) List(parent string) *ProjectsLocationsGlossariesListCall {
	c := &ProjectsLocationsGlossariesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter specifying constraints
// of a list operation. Specify the constraint by the format of "key=value",
// where key must be "src" or "tgt", and the value must be a valid language
// code. For multiple restrictions, concatenate them by "AND" (uppercase only),
// such as: "src=en-US AND tgt=zh-CN". Notice that the exact match is used
// here, which means using 'en-US' and 'en' can lead to different results,
// which depends on the language code you used when you create the glossary.
// For the unidirectional glossaries, the "src" and "tgt" add restrictions on
// the source and target language code separately. For the equivalent term set
// glossaries, the "src" and/or "tgt" add restrictions on the term set. For
// example: "src=en-US AND tgt=zh-CN" will only pick the unidirectional
// glossaries which exactly match the source language code as "en-US" and the
// target language code "zh-CN", but all equivalent term set glossaries which
// contain "en-US" and "zh-CN" in their language set will be picked. If
// missing, no filtering is performed.
func (c *ProjectsLocationsGlossariesListCall) Filter(filter string) *ProjectsLocationsGlossariesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer glossaries than requested. If unspecified, the
// server picks an appropriate default.
func (c *ProjectsLocationsGlossariesListCall) PageSize(pageSize int64) *ProjectsLocationsGlossariesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// [ListGlossariesResponse.next_page_token] returned from the previous call to
// `ListGlossaries` method. The first page is returned if `page_token`is empty
// or missing.
func (c *ProjectsLocationsGlossariesListCall) PageToken(pageToken string) *ProjectsLocationsGlossariesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlossariesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlossariesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesListCall) Context(ctx context.Context) *ProjectsLocationsGlossariesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/glossaries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGlossariesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsGlossariesListCall) Do(opts ...googleapi.CallOption) (*ListGlossariesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGlossariesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGlossariesListCall) Pages(ctx context.Context, f func(*ListGlossariesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGlossariesPatchCall struct {
	s          *Service
	name       string
	glossary   *Glossary
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a glossary. A LRO is used since the update can be async if
// the glossary's entry file is updated.
//
//   - name: The resource name of the glossary. Glossary names have the form
//     `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossa
//     ry-id}`.
func (r *ProjectsLocationsGlossariesService) Patch(name string, glossary *Glossary) *ProjectsLocationsGlossariesPatchCall {
	c := &ProjectsLocationsGlossariesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.glossary = glossary
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. Currently only `display_name` and 'input_config'
func (c *ProjectsLocationsGlossariesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsGlossariesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesPatchCall) Context(ctx context.Context) *ProjectsLocationsGlossariesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.glossary)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlossariesGlossaryEntriesCreateCall struct {
	s             *Service
	parent        string
	glossaryentry *GlossaryEntry
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Creates a glossary entry.
//
// - parent: The resource name of the glossary to create the entry under.
func (r *ProjectsLocationsGlossariesGlossaryEntriesService) Create(parent string, glossaryentry *GlossaryEntry) *ProjectsLocationsGlossariesGlossaryEntriesCreateCall {
	c := &ProjectsLocationsGlossariesGlossaryEntriesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.glossaryentry = glossaryentry
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesGlossaryEntriesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesGlossaryEntriesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesGlossaryEntriesCreateCall) Context(ctx context.Context) *ProjectsLocationsGlossariesGlossaryEntriesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesGlossaryEntriesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesGlossaryEntriesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.glossaryentry)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/glossaryEntries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.glossaryEntries.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GlossaryEntry.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesGlossaryEntriesCreateCall) Do(opts ...googleapi.CallOption) (*GlossaryEntry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GlossaryEntry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlossariesGlossaryEntriesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single entry from the glossary
//
// - name: The resource name of the glossary entry to delete.
func (r *ProjectsLocationsGlossariesGlossaryEntriesService) Delete(name string) *ProjectsLocationsGlossariesGlossaryEntriesDeleteCall {
	c := &ProjectsLocationsGlossariesGlossaryEntriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesGlossaryEntriesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesGlossaryEntriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesGlossaryEntriesDeleteCall) Context(ctx context.Context) *ProjectsLocationsGlossariesGlossaryEntriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesGlossaryEntriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesGlossaryEntriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.glossaryEntries.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesGlossaryEntriesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlossariesGlossaryEntriesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single glossary entry by the given id.
//
// - name: The resource name of the glossary entry to get.
func (r *ProjectsLocationsGlossariesGlossaryEntriesService) Get(name string) *ProjectsLocationsGlossariesGlossaryEntriesGetCall {
	c := &ProjectsLocationsGlossariesGlossaryEntriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesGlossaryEntriesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesGlossaryEntriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlossariesGlossaryEntriesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlossariesGlossaryEntriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesGlossaryEntriesGetCall) Context(ctx context.Context) *ProjectsLocationsGlossariesGlossaryEntriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesGlossaryEntriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesGlossaryEntriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.glossaryEntries.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GlossaryEntry.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesGlossaryEntriesGetCall) Do(opts ...googleapi.CallOption) (*GlossaryEntry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GlossaryEntry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGlossariesGlossaryEntriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List the entries for the glossary.
//
//   - parent: The parent glossary resource name for listing the glossary's
//     entries.
func (r *ProjectsLocationsGlossariesGlossaryEntriesService) List(parent string) *ProjectsLocationsGlossariesGlossaryEntriesListCall {
	c := &ProjectsLocationsGlossariesGlossaryEntriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer glossary entries than requested. If unspecified, the
// server picks an appropriate default.
func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) PageSize(pageSize int64) *ProjectsLocationsGlossariesGlossaryEntriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// [ListGlossaryEntriesResponse.next_page_token] returned from the previous
// call. The first page is returned if `page_token`is empty or missing.
func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) PageToken(pageToken string) *ProjectsLocationsGlossariesGlossaryEntriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesGlossaryEntriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsGlossariesGlossaryEntriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) Context(ctx context.Context) *ProjectsLocationsGlossariesGlossaryEntriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/glossaryEntries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.glossaryEntries.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListGlossaryEntriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) Do(opts ...googleapi.CallOption) (*ListGlossaryEntriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListGlossaryEntriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsGlossariesGlossaryEntriesListCall) Pages(ctx context.Context, f func(*ListGlossaryEntriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsGlossariesGlossaryEntriesPatchCall struct {
	s             *Service
	name          string
	glossaryentry *GlossaryEntry
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates a glossary entry.
//
//   - name: Identifier. The resource name of the entry. Format:
//     `projects/*/locations/*/glossaries/*/glossaryEntries/*`.
func (r *ProjectsLocationsGlossariesGlossaryEntriesService) Patch(name string, glossaryentry *GlossaryEntry) *ProjectsLocationsGlossariesGlossaryEntriesPatchCall {
	c := &ProjectsLocationsGlossariesGlossaryEntriesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.glossaryentry = glossaryentry
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGlossariesGlossaryEntriesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsGlossariesGlossaryEntriesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGlossariesGlossaryEntriesPatchCall) Context(ctx context.Context) *ProjectsLocationsGlossariesGlossaryEntriesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGlossariesGlossaryEntriesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGlossariesGlossaryEntriesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.glossaryentry)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.glossaries.glossaryEntries.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GlossaryEntry.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGlossariesGlossaryEntriesPatchCall) Do(opts ...googleapi.CallOption) (*GlossaryEntry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GlossaryEntry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.glossaries.glossaryEntries.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsModelsCreateCall struct {
	s          *Service
	parent     string
	model      *Model
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a Model.
//
//   - parent: The project name, in form of
//     `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsModelsService) Create(parent string, model *Model) *ProjectsLocationsModelsCreateCall {
	c := &ProjectsLocationsModelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.model = model
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsModelsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsModelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsModelsCreateCall) Context(ctx context.Context) *ProjectsLocationsModelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsModelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsModelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.model)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/models")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.models.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.models.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsModelsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.models.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsModelsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a model.
//
// - name: The name of the model to delete.
func (r *ProjectsLocationsModelsService) Delete(name string) *ProjectsLocationsModelsDeleteCall {
	c := &ProjectsLocationsModelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsModelsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsModelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsModelsDeleteCall) Context(ctx context.Context) *ProjectsLocationsModelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsModelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsModelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.models.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.models.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsModelsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.models.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsModelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a model.
//
// - name: The resource name of the model to retrieve.
func (r *ProjectsLocationsModelsService) Get(name string) *ProjectsLocationsModelsGetCall {
	c := &ProjectsLocationsModelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsModelsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsModelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsModelsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsModelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsModelsGetCall) Context(ctx context.Context) *ProjectsLocationsModelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsModelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsModelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.models.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.models.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Model.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsModelsGetCall) Do(opts ...googleapi.CallOption) (*Model, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Model{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.models.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsModelsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists models.
//
//   - parent: Name of the parent project. In form of
//     `projects/{project-number-or-id}/locations/{location-id}`.
func (r *ProjectsLocationsModelsService) List(parent string) *ProjectsLocationsModelsListCall {
	c := &ProjectsLocationsModelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// models that will be returned. Supported filter: `dataset_id=${dataset_id}`
func (c *ProjectsLocationsModelsListCall) Filter(filter string) *ProjectsLocationsModelsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server can return fewer results than requested.
func (c *ProjectsLocationsModelsListCall) PageSize(pageSize int64) *ProjectsLocationsModelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained from
// next_page_token field in the response of a ListModels call.
func (c *ProjectsLocationsModelsListCall) PageToken(pageToken string) *ProjectsLocationsModelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsModelsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsModelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsModelsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsModelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsModelsListCall) Context(ctx context.Context) *ProjectsLocationsModelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsModelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsModelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/models")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.models.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.models.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListModelsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsModelsListCall) Do(opts ...googleapi.CallOption) (*ListModelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListModelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.models.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsModelsListCall) Pages(ctx context.Context, f func(*ListModelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsWaitCall struct {
	s                    *Service
	name                 string
	waitoperationrequest *WaitOperationRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Wait: Waits until the specified long-running operation is done or reaches at
// most a specified timeout, returning the latest state. If the operation is
// already done, the latest state is immediately returned. If the timeout
// specified is greater than the default HTTP/RPC timeout, the HTTP/RPC timeout
// is used. If the server does not support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Note that this method is on a best-effort
// basis. It may return the latest state before the specified timeout
// (including immediately), meaning even an immediate response is no guarantee
// that the operation is done.
//
// - name: The name of the operation resource to wait on.
func (r *ProjectsLocationsOperationsService) Wait(name string, waitoperationrequest *WaitOperationRequest) *ProjectsLocationsOperationsWaitCall {
	c := &ProjectsLocationsOperationsWaitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.waitoperationrequest = waitoperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsWaitCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsWaitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsWaitCall) Context(ctx context.Context) *ProjectsLocationsOperationsWaitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsWaitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsWaitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.waitoperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}:wait")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.wait", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "translate.projects.locations.operations.wait" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsWaitCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "translate.projects.locations.operations.wait", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
