//
// metadata.proto - File which contains all of the metadata structures which we
// write to metadata files. Must be compiled with protoc to use the library.
// Compilation can be invoked with go generate.
//
// Copyright 2017 Google Inc.
// Author: Joe Richey (joerichey@google.com)
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not
// use this file except in compliance with the License. You may obtain a copy of
// the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
// WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
// License for the specific language governing permissions and limitations under
// the License.

// If the *.proto file is modified, be sure to run "make gen" (at the project
// root) to recreate the *.pb.go file.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v3.6.1
// source: metadata/metadata.proto

package metadata

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the method in which an outside secret is obtained for a Protector
type SourceType int32

const (
	SourceType_default           SourceType = 0
	SourceType_pam_passphrase    SourceType = 1
	SourceType_custom_passphrase SourceType = 2
	SourceType_raw_key           SourceType = 3
)

// Enum value maps for SourceType.
var (
	SourceType_name = map[int32]string{
		0: "default",
		1: "pam_passphrase",
		2: "custom_passphrase",
		3: "raw_key",
	}
	SourceType_value = map[string]int32{
		"default":           0,
		"pam_passphrase":    1,
		"custom_passphrase": 2,
		"raw_key":           3,
	}
)

func (x SourceType) Enum() *SourceType {
	p := new(SourceType)
	*p = x
	return p
}

func (x SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_metadata_metadata_proto_enumTypes[0].Descriptor()
}

func (SourceType) Type() protoreflect.EnumType {
	return &file_metadata_metadata_proto_enumTypes[0]
}

func (x SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SourceType.Descriptor instead.
func (SourceType) EnumDescriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{0}
}

// Type of encryption; should match declarations of unix.FSCRYPT_MODE
type EncryptionOptions_Mode int32

const (
	EncryptionOptions_default       EncryptionOptions_Mode = 0
	EncryptionOptions_AES_256_XTS   EncryptionOptions_Mode = 1
	EncryptionOptions_AES_256_GCM   EncryptionOptions_Mode = 2
	EncryptionOptions_AES_256_CBC   EncryptionOptions_Mode = 3
	EncryptionOptions_AES_256_CTS   EncryptionOptions_Mode = 4
	EncryptionOptions_AES_128_CBC   EncryptionOptions_Mode = 5
	EncryptionOptions_AES_128_CTS   EncryptionOptions_Mode = 6
	EncryptionOptions_Adiantum      EncryptionOptions_Mode = 9
	EncryptionOptions_AES_256_HCTR2 EncryptionOptions_Mode = 10
)

// Enum value maps for EncryptionOptions_Mode.
var (
	EncryptionOptions_Mode_name = map[int32]string{
		0:  "default",
		1:  "AES_256_XTS",
		2:  "AES_256_GCM",
		3:  "AES_256_CBC",
		4:  "AES_256_CTS",
		5:  "AES_128_CBC",
		6:  "AES_128_CTS",
		9:  "Adiantum",
		10: "AES_256_HCTR2",
	}
	EncryptionOptions_Mode_value = map[string]int32{
		"default":       0,
		"AES_256_XTS":   1,
		"AES_256_GCM":   2,
		"AES_256_CBC":   3,
		"AES_256_CTS":   4,
		"AES_128_CBC":   5,
		"AES_128_CTS":   6,
		"Adiantum":      9,
		"AES_256_HCTR2": 10,
	}
)

func (x EncryptionOptions_Mode) Enum() *EncryptionOptions_Mode {
	p := new(EncryptionOptions_Mode)
	*p = x
	return p
}

func (x EncryptionOptions_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionOptions_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_metadata_metadata_proto_enumTypes[1].Descriptor()
}

func (EncryptionOptions_Mode) Type() protoreflect.EnumType {
	return &file_metadata_metadata_proto_enumTypes[1]
}

func (x EncryptionOptions_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptionOptions_Mode.Descriptor instead.
func (EncryptionOptions_Mode) EnumDescriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{3, 0}
}

// Cost parameters to be used in our hashing functions.
type HashingCosts struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	Time        int64                  `protobuf:"varint,2,opt,name=time,proto3" json:"time,omitempty"`
	Memory      int64                  `protobuf:"varint,3,opt,name=memory,proto3" json:"memory,omitempty"`
	Parallelism int64                  `protobuf:"varint,4,opt,name=parallelism,proto3" json:"parallelism,omitempty"`
	// If true, parallelism should no longer be truncated to 8 bits.
	TruncationFixed bool `protobuf:"varint,5,opt,name=truncation_fixed,json=truncationFixed,proto3" json:"truncation_fixed,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *HashingCosts) Reset() {
	*x = HashingCosts{}
	mi := &file_metadata_metadata_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HashingCosts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HashingCosts) ProtoMessage() {}

func (x *HashingCosts) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HashingCosts.ProtoReflect.Descriptor instead.
func (*HashingCosts) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *HashingCosts) GetTime() int64 {
	if x != nil {
		return x.Time
	}
	return 0
}

func (x *HashingCosts) GetMemory() int64 {
	if x != nil {
		return x.Memory
	}
	return 0
}

func (x *HashingCosts) GetParallelism() int64 {
	if x != nil {
		return x.Parallelism
	}
	return 0
}

func (x *HashingCosts) GetTruncationFixed() bool {
	if x != nil {
		return x.TruncationFixed
	}
	return false
}

// This structure is used for our authenticated wrapping/unwrapping of keys.
type WrappedKeyData struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	IV            []byte                 `protobuf:"bytes,1,opt,name=IV,proto3" json:"IV,omitempty"`
	EncryptedKey  []byte                 `protobuf:"bytes,2,opt,name=encrypted_key,json=encryptedKey,proto3" json:"encrypted_key,omitempty"`
	Hmac          []byte                 `protobuf:"bytes,3,opt,name=hmac,proto3" json:"hmac,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WrappedKeyData) Reset() {
	*x = WrappedKeyData{}
	mi := &file_metadata_metadata_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WrappedKeyData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WrappedKeyData) ProtoMessage() {}

func (x *WrappedKeyData) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WrappedKeyData.ProtoReflect.Descriptor instead.
func (*WrappedKeyData) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *WrappedKeyData) GetIV() []byte {
	if x != nil {
		return x.IV
	}
	return nil
}

func (x *WrappedKeyData) GetEncryptedKey() []byte {
	if x != nil {
		return x.EncryptedKey
	}
	return nil
}

func (x *WrappedKeyData) GetHmac() []byte {
	if x != nil {
		return x.Hmac
	}
	return nil
}

// The associated data for each protector
type ProtectorData struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	ProtectorDescriptor string                 `protobuf:"bytes,1,opt,name=protector_descriptor,json=protectorDescriptor,proto3" json:"protector_descriptor,omitempty"`
	Source              SourceType             `protobuf:"varint,2,opt,name=source,proto3,enum=metadata.SourceType" json:"source,omitempty"`
	// These are only used by some of the protector types
	Name          string          `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Costs         *HashingCosts   `protobuf:"bytes,4,opt,name=costs,proto3" json:"costs,omitempty"`
	Salt          []byte          `protobuf:"bytes,5,opt,name=salt,proto3" json:"salt,omitempty"`
	Uid           int64           `protobuf:"varint,6,opt,name=uid,proto3" json:"uid,omitempty"`
	WrappedKey    *WrappedKeyData `protobuf:"bytes,7,opt,name=wrapped_key,json=wrappedKey,proto3" json:"wrapped_key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProtectorData) Reset() {
	*x = ProtectorData{}
	mi := &file_metadata_metadata_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProtectorData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProtectorData) ProtoMessage() {}

func (x *ProtectorData) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProtectorData.ProtoReflect.Descriptor instead.
func (*ProtectorData) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *ProtectorData) GetProtectorDescriptor() string {
	if x != nil {
		return x.ProtectorDescriptor
	}
	return ""
}

func (x *ProtectorData) GetSource() SourceType {
	if x != nil {
		return x.Source
	}
	return SourceType_default
}

func (x *ProtectorData) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProtectorData) GetCosts() *HashingCosts {
	if x != nil {
		return x.Costs
	}
	return nil
}

func (x *ProtectorData) GetSalt() []byte {
	if x != nil {
		return x.Salt
	}
	return nil
}

func (x *ProtectorData) GetUid() int64 {
	if x != nil {
		return x.Uid
	}
	return 0
}

func (x *ProtectorData) GetWrappedKey() *WrappedKeyData {
	if x != nil {
		return x.WrappedKey
	}
	return nil
}

// Encryption policy specifics, corresponds to the fscrypt_policy struct
type EncryptionOptions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Padding       int64                  `protobuf:"varint,1,opt,name=padding,proto3" json:"padding,omitempty"`
	Contents      EncryptionOptions_Mode `protobuf:"varint,2,opt,name=contents,proto3,enum=metadata.EncryptionOptions_Mode" json:"contents,omitempty"`
	Filenames     EncryptionOptions_Mode `protobuf:"varint,3,opt,name=filenames,proto3,enum=metadata.EncryptionOptions_Mode" json:"filenames,omitempty"`
	PolicyVersion int64                  `protobuf:"varint,4,opt,name=policy_version,json=policyVersion,proto3" json:"policy_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EncryptionOptions) Reset() {
	*x = EncryptionOptions{}
	mi := &file_metadata_metadata_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionOptions) ProtoMessage() {}

func (x *EncryptionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionOptions.ProtoReflect.Descriptor instead.
func (*EncryptionOptions) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *EncryptionOptions) GetPadding() int64 {
	if x != nil {
		return x.Padding
	}
	return 0
}

func (x *EncryptionOptions) GetContents() EncryptionOptions_Mode {
	if x != nil {
		return x.Contents
	}
	return EncryptionOptions_default
}

func (x *EncryptionOptions) GetFilenames() EncryptionOptions_Mode {
	if x != nil {
		return x.Filenames
	}
	return EncryptionOptions_default
}

func (x *EncryptionOptions) GetPolicyVersion() int64 {
	if x != nil {
		return x.PolicyVersion
	}
	return 0
}

type WrappedPolicyKey struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	ProtectorDescriptor string                 `protobuf:"bytes,1,opt,name=protector_descriptor,json=protectorDescriptor,proto3" json:"protector_descriptor,omitempty"`
	WrappedKey          *WrappedKeyData        `protobuf:"bytes,2,opt,name=wrapped_key,json=wrappedKey,proto3" json:"wrapped_key,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *WrappedPolicyKey) Reset() {
	*x = WrappedPolicyKey{}
	mi := &file_metadata_metadata_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WrappedPolicyKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WrappedPolicyKey) ProtoMessage() {}

func (x *WrappedPolicyKey) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WrappedPolicyKey.ProtoReflect.Descriptor instead.
func (*WrappedPolicyKey) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{4}
}

func (x *WrappedPolicyKey) GetProtectorDescriptor() string {
	if x != nil {
		return x.ProtectorDescriptor
	}
	return ""
}

func (x *WrappedPolicyKey) GetWrappedKey() *WrappedKeyData {
	if x != nil {
		return x.WrappedKey
	}
	return nil
}

// The associated data for each policy
type PolicyData struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	KeyDescriptor     string                 `protobuf:"bytes,1,opt,name=key_descriptor,json=keyDescriptor,proto3" json:"key_descriptor,omitempty"`
	Options           *EncryptionOptions     `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	WrappedPolicyKeys []*WrappedPolicyKey    `protobuf:"bytes,3,rep,name=wrapped_policy_keys,json=wrappedPolicyKeys,proto3" json:"wrapped_policy_keys,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *PolicyData) Reset() {
	*x = PolicyData{}
	mi := &file_metadata_metadata_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyData) ProtoMessage() {}

func (x *PolicyData) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyData.ProtoReflect.Descriptor instead.
func (*PolicyData) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{5}
}

func (x *PolicyData) GetKeyDescriptor() string {
	if x != nil {
		return x.KeyDescriptor
	}
	return ""
}

func (x *PolicyData) GetOptions() *EncryptionOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *PolicyData) GetWrappedPolicyKeys() []*WrappedPolicyKey {
	if x != nil {
		return x.WrappedPolicyKeys
	}
	return nil
}

// Data stored in the config file
type Config struct {
	state                     protoimpl.MessageState `protogen:"open.v1"`
	Source                    SourceType             `protobuf:"varint,1,opt,name=source,proto3,enum=metadata.SourceType" json:"source,omitempty"`
	HashCosts                 *HashingCosts          `protobuf:"bytes,2,opt,name=hash_costs,json=hashCosts,proto3" json:"hash_costs,omitempty"`
	Options                   *EncryptionOptions     `protobuf:"bytes,4,opt,name=options,proto3" json:"options,omitempty"`
	UseFsKeyringForV1Policies bool                   `protobuf:"varint,5,opt,name=use_fs_keyring_for_v1_policies,json=useFsKeyringForV1Policies,proto3" json:"use_fs_keyring_for_v1_policies,omitempty"`
	AllowCrossUserMetadata    bool                   `protobuf:"varint,6,opt,name=allow_cross_user_metadata,json=allowCrossUserMetadata,proto3" json:"allow_cross_user_metadata,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *Config) Reset() {
	*x = Config{}
	mi := &file_metadata_metadata_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Config) ProtoMessage() {}

func (x *Config) ProtoReflect() protoreflect.Message {
	mi := &file_metadata_metadata_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Config.ProtoReflect.Descriptor instead.
func (*Config) Descriptor() ([]byte, []int) {
	return file_metadata_metadata_proto_rawDescGZIP(), []int{6}
}

func (x *Config) GetSource() SourceType {
	if x != nil {
		return x.Source
	}
	return SourceType_default
}

func (x *Config) GetHashCosts() *HashingCosts {
	if x != nil {
		return x.HashCosts
	}
	return nil
}

func (x *Config) GetOptions() *EncryptionOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Config) GetUseFsKeyringForV1Policies() bool {
	if x != nil {
		return x.UseFsKeyringForV1Policies
	}
	return false
}

func (x *Config) GetAllowCrossUserMetadata() bool {
	if x != nil {
		return x.AllowCrossUserMetadata
	}
	return false
}

var File_metadata_metadata_proto protoreflect.FileDescriptor

const file_metadata_metadata_proto_rawDesc = "" +
	"\n" +
	"\x17metadata/metadata.proto\x12\bmetadata\"\x87\x01\n" +
	"\fHashingCosts\x12\x12\n" +
	"\x04time\x18\x02 \x01(\x03R\x04time\x12\x16\n" +
	"\x06memory\x18\x03 \x01(\x03R\x06memory\x12 \n" +
	"\vparallelism\x18\x04 \x01(\x03R\vparallelism\x12)\n" +
	"\x10truncation_fixed\x18\x05 \x01(\bR\x0ftruncationFixed\"Y\n" +
	"\x0eWrappedKeyData\x12\x0e\n" +
	"\x02IV\x18\x01 \x01(\fR\x02IV\x12#\n" +
	"\rencrypted_key\x18\x02 \x01(\fR\fencryptedKey\x12\x12\n" +
	"\x04hmac\x18\x03 \x01(\fR\x04hmac\"\x93\x02\n" +
	"\rProtectorData\x121\n" +
	"\x14protector_descriptor\x18\x01 \x01(\tR\x13protectorDescriptor\x12,\n" +
	"\x06source\x18\x02 \x01(\x0e2\x14.metadata.SourceTypeR\x06source\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12,\n" +
	"\x05costs\x18\x04 \x01(\v2\x16.metadata.HashingCostsR\x05costs\x12\x12\n" +
	"\x04salt\x18\x05 \x01(\fR\x04salt\x12\x10\n" +
	"\x03uid\x18\x06 \x01(\x03R\x03uid\x129\n" +
	"\vwrapped_key\x18\a \x01(\v2\x18.metadata.WrappedKeyDataR\n" +
	"wrappedKey\"\xef\x02\n" +
	"\x11EncryptionOptions\x12\x18\n" +
	"\apadding\x18\x01 \x01(\x03R\apadding\x12<\n" +
	"\bcontents\x18\x02 \x01(\x0e2 .metadata.EncryptionOptions.ModeR\bcontents\x12>\n" +
	"\tfilenames\x18\x03 \x01(\x0e2 .metadata.EncryptionOptions.ModeR\tfilenames\x12%\n" +
	"\x0epolicy_version\x18\x04 \x01(\x03R\rpolicyVersion\"\x9a\x01\n" +
	"\x04Mode\x12\v\n" +
	"\adefault\x10\x00\x12\x0f\n" +
	"\vAES_256_XTS\x10\x01\x12\x0f\n" +
	"\vAES_256_GCM\x10\x02\x12\x0f\n" +
	"\vAES_256_CBC\x10\x03\x12\x0f\n" +
	"\vAES_256_CTS\x10\x04\x12\x0f\n" +
	"\vAES_128_CBC\x10\x05\x12\x0f\n" +
	"\vAES_128_CTS\x10\x06\x12\f\n" +
	"\bAdiantum\x10\t\x12\x11\n" +
	"\rAES_256_HCTR2\x10\n" +
	"\"\x80\x01\n" +
	"\x10WrappedPolicyKey\x121\n" +
	"\x14protector_descriptor\x18\x01 \x01(\tR\x13protectorDescriptor\x129\n" +
	"\vwrapped_key\x18\x02 \x01(\v2\x18.metadata.WrappedKeyDataR\n" +
	"wrappedKey\"\xb6\x01\n" +
	"\n" +
	"PolicyData\x12%\n" +
	"\x0ekey_descriptor\x18\x01 \x01(\tR\rkeyDescriptor\x125\n" +
	"\aoptions\x18\x02 \x01(\v2\x1b.metadata.EncryptionOptionsR\aoptions\x12J\n" +
	"\x13wrapped_policy_keys\x18\x03 \x03(\v2\x1a.metadata.WrappedPolicyKeyR\x11wrappedPolicyKeys\"\xb7\x02\n" +
	"\x06Config\x12,\n" +
	"\x06source\x18\x01 \x01(\x0e2\x14.metadata.SourceTypeR\x06source\x125\n" +
	"\n" +
	"hash_costs\x18\x02 \x01(\v2\x16.metadata.HashingCostsR\thashCosts\x125\n" +
	"\aoptions\x18\x04 \x01(\v2\x1b.metadata.EncryptionOptionsR\aoptions\x12A\n" +
	"\x1euse_fs_keyring_for_v1_policies\x18\x05 \x01(\bR\x19useFsKeyringForV1Policies\x129\n" +
	"\x19allow_cross_user_metadata\x18\x06 \x01(\bR\x16allowCrossUserMetadataJ\x04\b\x03\x10\x04R\rcompatibility*Q\n" +
	"\n" +
	"SourceType\x12\v\n" +
	"\adefault\x10\x00\x12\x12\n" +
	"\x0epam_passphrase\x10\x01\x12\x15\n" +
	"\x11custom_passphrase\x10\x02\x12\v\n" +
	"\araw_key\x10\x03B$Z\"github.com/google/fscrypt/metadatab\x06proto3"

var (
	file_metadata_metadata_proto_rawDescOnce sync.Once
	file_metadata_metadata_proto_rawDescData []byte
)

func file_metadata_metadata_proto_rawDescGZIP() []byte {
	file_metadata_metadata_proto_rawDescOnce.Do(func() {
		file_metadata_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_metadata_metadata_proto_rawDesc), len(file_metadata_metadata_proto_rawDesc)))
	})
	return file_metadata_metadata_proto_rawDescData
}

var file_metadata_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_metadata_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_metadata_metadata_proto_goTypes = []any{
	(SourceType)(0),             // 0: metadata.SourceType
	(EncryptionOptions_Mode)(0), // 1: metadata.EncryptionOptions.Mode
	(*HashingCosts)(nil),        // 2: metadata.HashingCosts
	(*WrappedKeyData)(nil),      // 3: metadata.WrappedKeyData
	(*ProtectorData)(nil),       // 4: metadata.ProtectorData
	(*EncryptionOptions)(nil),   // 5: metadata.EncryptionOptions
	(*WrappedPolicyKey)(nil),    // 6: metadata.WrappedPolicyKey
	(*PolicyData)(nil),          // 7: metadata.PolicyData
	(*Config)(nil),              // 8: metadata.Config
}
var file_metadata_metadata_proto_depIdxs = []int32{
	0,  // 0: metadata.ProtectorData.source:type_name -> metadata.SourceType
	2,  // 1: metadata.ProtectorData.costs:type_name -> metadata.HashingCosts
	3,  // 2: metadata.ProtectorData.wrapped_key:type_name -> metadata.WrappedKeyData
	1,  // 3: metadata.EncryptionOptions.contents:type_name -> metadata.EncryptionOptions.Mode
	1,  // 4: metadata.EncryptionOptions.filenames:type_name -> metadata.EncryptionOptions.Mode
	3,  // 5: metadata.WrappedPolicyKey.wrapped_key:type_name -> metadata.WrappedKeyData
	5,  // 6: metadata.PolicyData.options:type_name -> metadata.EncryptionOptions
	6,  // 7: metadata.PolicyData.wrapped_policy_keys:type_name -> metadata.WrappedPolicyKey
	0,  // 8: metadata.Config.source:type_name -> metadata.SourceType
	2,  // 9: metadata.Config.hash_costs:type_name -> metadata.HashingCosts
	5,  // 10: metadata.Config.options:type_name -> metadata.EncryptionOptions
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_metadata_metadata_proto_init() }
func file_metadata_metadata_proto_init() {
	if File_metadata_metadata_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_metadata_metadata_proto_rawDesc), len(file_metadata_metadata_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_metadata_metadata_proto_goTypes,
		DependencyIndexes: file_metadata_metadata_proto_depIdxs,
		EnumInfos:         file_metadata_metadata_proto_enumTypes,
		MessageInfos:      file_metadata_metadata_proto_msgTypes,
	}.Build()
	File_metadata_metadata_proto = out.File
	file_metadata_metadata_proto_goTypes = nil
	file_metadata_metadata_proto_depIdxs = nil
}
