/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBorder
extends AbstractBorder {
    private List<Border> borders;
    private static final Dimension EMPTY = new Dimension();

    public MultiBorder() {
        this.borders = Collections.emptyList();
    }

    public MultiBorder(Border singleBorder) {
        this.borders = Collections.singletonList(singleBorder);
    }

    public MultiBorder(List<Border> borders) {
        this.borders = new ArrayList<Border>(borders);
    }

    public MultiBorder(Border ... borders) {
        this.borders = Arrays.asList(borders);
    }

    public List<Border> getBorders() {
        return new ArrayList<Border>(this.borders);
    }

    public Insets getInsets(IFigure figure) {
        Insets ins = null;
        for (Border border : this.borders) {
            Insets i = border == null ? IFigure.NO_INSETS : border.getInsets(figure);
            Insets insets = ins = ins == null ? new Insets(i) : ins.getAdded(ins);
        }
        return ins == null ? new Insets() : ins;
    }

    public Dimension getPreferredSize(IFigure f) {
        Dimension prefSize = null;
        for (Border border : this.borders) {
            if (prefSize != null) {
                Insets ins = this.getInsets(f);
                prefSize.expand(ins.getWidth(), ins.getHeight());
            }
            Dimension d = border == null ? EMPTY : border.getPreferredSize(f);
            Dimension dimension = prefSize = prefSize == null ? new Dimension(d) : prefSize.expand(d);
        }
        return prefSize == null ? new Dimension() : prefSize;
    }

    public boolean isOpaque() {
        boolean opaque = false;
        for (Border border : this.borders) {
            opaque &= border == null ? false : border.isOpaque();
        }
        return opaque;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        for (Border border : this.borders) {
            if (border == null) continue;
            graphics.pushState();
            border.paint(figure, graphics, insets);
            graphics.popState();
            insets = insets.getAdded(border.getInsets(figure));
        }
    }
}

