/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.IComment;
import org.xmind.core.ICommentManager;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.dom.CommentImpl;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.NodeAdaptableRegistry;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentManagerImpl
implements ICommentManager,
INodeAdaptableFactory {
    private final WorkbookImpl ownedWorkbook;
    private final Document implementation;
    private final NodeAdaptableRegistry registry;
    private final Set<CommentImpl> pendingComments;

    public CommentManagerImpl(WorkbookImpl ownerWorkbook, Document implementation) {
        this.ownedWorkbook = ownerWorkbook;
        this.implementation = implementation;
        this.registry = new NodeAdaptableRegistry(implementation, this);
        this.pendingComments = new HashSet<CommentImpl>();
        this.init();
    }

    private void init() {
        Element m = DOMUtils.ensureChildElement(this.implementation, "comments");
        NS.setNS(NS.Comments, m, new NS[0]);
        InternalDOMUtils.addVersion(this.implementation);
    }

    private Element getCommentsElement() {
        return this.implementation.getDocumentElement();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (Node.class.equals(adapter) || Document.class.equals(adapter)) {
            return adapter.cast(this.implementation);
        }
        return null;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return false;
    }

    protected void objectAddNotify(String objectId, Object obj) {
        Element p = this.getCommentsElement();
        Iterator<CommentImpl> it = this.pendingComments.iterator();
        while (it.hasNext()) {
            CommentImpl c = it.next();
            if (!objectId.equals(c.getObjectId())) continue;
            it.remove();
            Element ele = c.getImplementation();
            if (ele.getParentNode() == p) continue;
            p.appendChild(ele);
            if (!(obj instanceof ICoreEventSource)) continue;
            this.ownedWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)obj, "commentAdd", c);
        }
    }

    protected void objectRemoveNotify(String objectId, Object obj) {
        Element p = this.getCommentsElement();
        int i = 0;
        while (i < p.getChildNodes().getLength()) {
            Element ele;
            Node n = p.getChildNodes().item(i);
            if (n instanceof Element && "comment".equals(((Element)n).getTagName()) && objectId.equals(DOMUtils.getAttribute(ele = (Element)n, "object-id"))) {
                p.removeChild(ele);
                IAdaptable a = this.registry.getAdaptable(ele);
                if (!(a instanceof CommentImpl)) continue;
                CommentImpl c = (CommentImpl)a;
                this.pendingComments.add(c);
                if (!(obj instanceof ICoreEventSource)) continue;
                this.ownedWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)obj, "commentRemove", c);
                continue;
            }
            ++i;
        }
    }

    @Override
    public IComment createComment(String author, long time, String objectId) {
        if (author == null) {
            throw new IllegalArgumentException();
        }
        if (time <= 0L) {
            throw new IllegalArgumentException();
        }
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        Element ele = this.implementation.createElement("comment");
        DOMUtils.setAttribute(ele, "author", author);
        DOMUtils.setAttribute(ele, "time", Long.toString(time));
        DOMUtils.setAttribute(ele, "object-id", objectId);
        CommentImpl c = new CommentImpl(this.ownedWorkbook, this, ele);
        this.registry.register((IAdaptable)c, ele);
        return c;
    }

    private static boolean isObjectOrphan(Object obj) {
        return !(obj instanceof IWorkbookComponent) || ((IWorkbookComponent)obj).isOrphan();
    }

    @Override
    public void addComment(IComment comment) {
        if (!(comment instanceof CommentImpl) || comment.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        CommentImpl c = (CommentImpl)comment;
        Element ele = c.getImplementation();
        Element p = this.getCommentsElement();
        if (ele.getParentNode() == p) {
            return;
        }
        Object obj = this.ownedWorkbook.getElementById(c.getObjectId());
        if (obj == null || CommentManagerImpl.isObjectOrphan(obj)) {
            this.pendingComments.add(c);
            return;
        }
        p.appendChild(ele);
        if (obj instanceof ICoreEventSource) {
            this.ownedWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)obj, "commentAdd", c);
        }
        this.updateModificationInfo();
    }

    @Override
    public void removeComment(IComment comment) {
        if (!(comment instanceof CommentImpl) || comment.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        CommentImpl c = (CommentImpl)comment;
        Element ele = c.getImplementation();
        Element p = this.getCommentsElement();
        this.pendingComments.remove(c);
        if (ele.getParentNode() != p) {
            return;
        }
        p.removeChild(ele);
        Object obj = this.ownedWorkbook.getElementById(c.getObjectId());
        if (obj instanceof ICoreEventSource) {
            this.ownedWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)obj, "commentRemove", c);
        }
        this.updateModificationInfo();
    }

    @Override
    public Set<IComment> getComments(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        Object o = this.getOwnedWorkbook().getElementById(objectId);
        if (o == null || CommentManagerImpl.isObjectOrphan(o)) {
            return Collections.emptySet();
        }
        HashSet<IComment> set = new HashSet<IComment>();
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getCommentsElement(), "comment");
        while (it.hasNext()) {
            IAdaptable a;
            Element ele = it.next();
            if (!objectId.equals(DOMUtils.getAttribute(ele, "object-id")) || !((a = this.registry.getAdaptable(ele)) instanceof CommentImpl)) continue;
            set.add((CommentImpl)a);
        }
        return set;
    }

    @Override
    public boolean hasComments(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        Object o = this.getOwnedWorkbook().getElementById(objectId);
        if (o == null || CommentManagerImpl.isObjectOrphan(o)) {
            return false;
        }
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getCommentsElement(), "comment");
        while (it.hasNext()) {
            IAdaptable a;
            Element ele = it.next();
            if (!objectId.equals(DOMUtils.getAttribute(ele, "object-id")) || !((a = this.registry.getAdaptable(ele)) instanceof CommentImpl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IComment> getAllComments() {
        HashSet<IComment> set = new HashSet<IComment>();
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getCommentsElement(), "comment");
        while (it.hasNext()) {
            Element ele = it.next();
            IAdaptable a = this.registry.getAdaptable(ele);
            if (!(a instanceof CommentImpl)) continue;
            CommentImpl c = (CommentImpl)a;
            Object o = this.getOwnedWorkbook().getElementById(c.getObjectId());
            if (o == null || CommentManagerImpl.isObjectOrphan(o)) continue;
            set.add(c);
        }
        return set;
    }

    @Override
    public boolean isEmpty() {
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getCommentsElement(), "comment");
        while (it.hasNext()) {
            Element ele = it.next();
            IAdaptable a = this.registry.getAdaptable(ele);
            if (!(a instanceof CommentImpl)) continue;
            CommentImpl c = (CommentImpl)a;
            Object o = this.getOwnedWorkbook().getElementById(c.getObjectId());
            if (o == null || CommentManagerImpl.isObjectOrphan(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IAdaptable createAdaptable(Node node) {
        Element ele;
        String tag;
        if (node instanceof Element && "comment".equals(tag = (ele = (Element)node).getTagName())) {
            return new CommentImpl(this.ownedWorkbook, this, ele);
        }
        return null;
    }

    protected void updateModificationInfo() {
        if (this.ownedWorkbook != null) {
            this.ownedWorkbook.updateModificationInfo();
        }
    }
}

