/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xmind.core.ITopic;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;

public abstract class SelectionRetargetAction
extends PageAction
implements ISelectionAction,
IPropertyChangeListener {
    private IAction handler = null;
    private String oldText = null;
    private String oldToolTipText = null;
    private ImageDescriptor oldImage = null;
    private ImageDescriptor oldDisabledImage = null;
    private ImageDescriptor oldHoverImage = null;
    private boolean oldEnabled = false;

    protected SelectionRetargetAction(IGraphicalEditorPage page) {
        super(page);
    }

    protected SelectionRetargetAction(String id, IGraphicalEditorPage page) {
        super(id, page);
    }

    public void run() {
        if (this.isDisposed()) {
            return;
        }
        if (this.handler != null) {
            this.handler.run();
        } else {
            this.runWithNoHandler();
        }
    }

    protected abstract void runWithNoHandler();

    protected void setHandler(IAction handler) {
        if (handler != this.handler) {
            if (this.handler != null) {
                this.handler.removePropertyChangeListener((IPropertyChangeListener)this);
            }
            if (handler != null) {
                handler.addPropertyChangeListener((IPropertyChangeListener)this);
            }
        }
        this.handler = handler;
        this.update(null);
    }

    public void setText(String text) {
        this.oldText = text;
        this.update("text");
    }

    public void setToolTipText(String toolTipText) {
        this.oldToolTipText = toolTipText;
        this.update("toolTipText");
    }

    public void setImageDescriptor(ImageDescriptor newImage) {
        this.oldImage = newImage;
        this.update("image");
    }

    public void setDisabledImageDescriptor(ImageDescriptor newImage) {
        this.oldDisabledImage = newImage;
        this.update("image");
    }

    public void setHoverImageDescriptor(ImageDescriptor newImage) {
        this.oldHoverImage = newImage;
        this.update("image");
    }

    public void setEnabled(boolean enabled) {
        this.oldEnabled = enabled;
        this.update("enabled");
    }

    protected void doSetText(String text) {
        super.setText(text);
    }

    protected void doSetToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
    }

    protected void doSetImageDescriptor(ImageDescriptor image) {
        super.setImageDescriptor(image);
    }

    protected void doSetDisabledImageDescriptor(ImageDescriptor image) {
        super.setDisabledImageDescriptor(image);
    }

    protected void doSetHoverImageDescriptor(ImageDescriptor image) {
        super.setHoverImageDescriptor(image);
    }

    protected void doSetEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    protected void update(String id) {
        boolean enabledChanged;
        boolean textChanged = id == null || "text".equals(id);
        boolean tooltipChanged = id == null || "toolTipText".equals(id);
        boolean imageChanged = id == null || "image".equals(id);
        boolean bl = enabledChanged = id == null || "enabled".equals(id);
        if (textChanged) {
            this.doSetText(this.handler == null ? this.oldText : this.handler.getText());
        }
        if (tooltipChanged) {
            this.doSetToolTipText(this.handler == null ? this.oldToolTipText : this.handler.getToolTipText());
        }
        if (imageChanged) {
            this.doSetImageDescriptor(this.handler == null ? this.oldImage : this.handler.getImageDescriptor());
            this.doSetDisabledImageDescriptor(this.handler == null ? this.oldDisabledImage : this.handler.getDisabledImageDescriptor());
            this.doSetHoverImageDescriptor(this.handler == null ? this.oldHoverImage : this.handler.getHoverImageDescriptor());
        }
        if (enabledChanged) {
            this.doSetEnabled(this.handler == null ? this.oldEnabled : this.handler.isEnabled());
        }
    }

    protected IAction getHandler() {
        return this.handler;
    }

    public void setSelection(ISelection selection) {
        this.setHandler(this.findHandler(selection));
    }

    private IAction findHandler(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() != 1) {
                return null;
            }
            Object o = ss.getFirstElement();
            if (o instanceof ITopic) {
                IGraphicalViewer viewer = this.getViewer();
                if (viewer == null) {
                    return null;
                }
                IPart part = viewer.findPart(o);
                if (part == null) {
                    return null;
                }
                IActionRegistry actionRegistry = (IActionRegistry)part.getAdapter(IActionRegistry.class);
                if (actionRegistry == null) {
                    return null;
                }
                IAction action = actionRegistry.getAction(this.getHandlerId());
                if (action == this) {
                    return null;
                }
                return action;
            }
        }
        return null;
    }

    protected abstract String getHandlerId();

    public void propertyChange(PropertyChangeEvent event) {
        this.update(event.getProperty());
    }
}

