/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.geometry;

import java.awt.Dimension;
import net.coobird.thumbnailator.geometry.Size;

public class RelativeSize
implements Size {
    private final double scalingFactor;

    public RelativeSize(double scalingFactor) {
        if (scalingFactor < 0.0 || scalingFactor > 1.0) {
            throw new IllegalArgumentException("The scaling factor must be between 0.0d and 1.0d, inclusive.");
        }
        this.scalingFactor = scalingFactor;
    }

    public Dimension calculate(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be greater than 0.");
        }
        int newWidth = (int)Math.round((double)width * this.scalingFactor);
        int newHeight = (int)Math.round((double)height * this.scalingFactor);
        return new Dimension(newWidth, newHeight);
    }

    public String toString() {
        return "RelativeSize [scalingFactor=" + this.scalingFactor + "]";
    }
}

