/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tabfolder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.tabfolder.IDelegatedSelectionProvider;

public class DelegatedSelectionProvider
implements IDelegatedSelectionProvider,
IPostSelectionProvider {
    private Display display;
    private ISelectionProvider delegate = null;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            DelegatedSelectionProvider.this.delegateSelectionChanged(event.getSelection());
        }
    };
    private ISelectionChangedListener postListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            DelegatedSelectionProvider.this.postDelegateSelectionChanged(event.getSelection());
        }
    };
    private List<ISelectionChangedListener> listeners = null;
    private List<ISelectionChangedListener> postListeners = null;
    private List<ISelectionChangedListener> asyncListeners = null;
    private List<ISelectionChangedListener> asyncPostListeners = null;

    public void setDisplay(Display display) {
        this.display = display;
    }

    @Override
    public void setDelegate(ISelectionProvider delegate) {
        if (delegate == this.delegate) {
            return;
        }
        ISelectionProvider oldDelegate = this.delegate;
        ISelectionProvider newDelegate = delegate;
        this.delegate = delegate;
        if (oldDelegate != null) {
            oldDelegate.removeSelectionChangedListener(this.listener);
            if (oldDelegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)oldDelegate).removePostSelectionChangedListener(this.postListener);
            }
        }
        final ISelection newSelection = this.getSelection();
        if (newDelegate != null) {
            newDelegate.addSelectionChangedListener(this.listener);
            this.delegateSelectionChanged(newSelection);
            if (newDelegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)newDelegate).addPostSelectionChangedListener(this.postListener);
            } else {
                newDelegate.addSelectionChangedListener(this.postListener);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DelegatedSelectionProvider.this.postDelegateSelectionChanged(newSelection);
                }
            });
        } else {
            this.delegateSelectionChanged(newSelection);
            this.postDelegateSelectionChanged(newSelection);
        }
    }

    public ISelectionProvider getDelegate() {
        return this.delegate;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ISelectionChangedListener>();
        }
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.delegate == null ? StructuredSelection.EMPTY : this.delegate.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.delegate != null) {
            this.delegate.setSelection(selection);
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.postListeners == null) {
            this.postListeners = new ArrayList<ISelectionChangedListener>();
        }
        this.postListeners.add(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.postListeners != null) {
            this.postListeners.remove(listener);
        }
    }

    public void addAsyncSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.asyncListeners == null) {
            this.asyncListeners = new ArrayList<ISelectionChangedListener>();
        }
        this.asyncListeners.add(listener);
    }

    public void removeAsyncSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.asyncListeners != null) {
            this.asyncListeners.remove(listener);
        }
    }

    public void addAsyncPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.asyncPostListeners == null) {
            this.asyncPostListeners = new ArrayList<ISelectionChangedListener>();
        }
        this.asyncPostListeners.add(listener);
    }

    public void removeAsyncPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.asyncPostListeners != null) {
            this.asyncPostListeners.remove(listener);
        }
    }

    private void delegateSelectionChanged(ISelection selection) {
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, selection), this.listeners);
        this.fireAsyncSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, selection), this.asyncListeners);
    }

    private void postDelegateSelectionChanged(ISelection selection) {
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, selection), this.postListeners);
        this.fireAsyncSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, selection), this.asyncPostListeners);
    }

    private void fireSelectionChangedEvent(final SelectionChangedEvent event, List<ISelectionChangedListener> listeners) {
        if (listeners == null) {
            return;
        }
        Object[] ls = listeners.toArray();
        int i = 0;
        while (i < ls.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)ls[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    private void fireAsyncSelectionChangedEvent(final SelectionChangedEvent event, List<ISelectionChangedListener> listeners) {
        if (listeners == null) {
            return;
        }
        final Object[] ls = listeners.toArray();
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < ls.length) {
                        final ISelectionChangedListener l = (ISelectionChangedListener)ls[i];
                        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                            public void run() {
                                l.selectionChanged(event);
                            }
                        });
                        ++i;
                    }
                }
            });
        } else {
            int i = 0;
            while (i < ls.length) {
                final ISelectionChangedListener l = (ISelectionChangedListener)ls[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(event);
                    }
                });
                ++i;
            }
        }
    }
}

