/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.org.freehep.graphicsio.pdf;

import java.awt.font.FontRenderContext;
import java.io.IOException;
import org.xmind.org.freehep.graphics2d.font.CharTable;
import org.xmind.org.freehep.graphicsio.font.FontEmbedder;
import org.xmind.org.freehep.graphicsio.pdf.PDFCharTableWriter;
import org.xmind.org.freehep.graphicsio.pdf.PDFDictionary;
import org.xmind.org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.xmind.org.freehep.graphicsio.pdf.PDFWriter;

public abstract class PDFFontEmbedder
extends FontEmbedder {
    protected PDFWriter pdf;
    private PDFDictionary fontDict;
    private String reference;
    private PDFRedundanceTracker redundanceTracker;

    public PDFFontEmbedder(FontRenderContext context, PDFWriter pdf, String reference, PDFRedundanceTracker tracker) {
        super(context);
        this.pdf = pdf;
        this.reference = reference;
        this.redundanceTracker = tracker;
    }

    protected abstract String getSubtype();

    protected abstract void addAdditionalEntries(PDFDictionary var1) throws IOException;

    protected abstract void addAdditionalInitDicts() throws IOException;

    protected String getReference() {
        return this.reference;
    }

    protected void openIncludeFont() throws IOException {
        this.fontDict = this.pdf.openDictionary(this.reference);
        this.fontDict.entry("Type", this.pdf.name("Font"));
        this.fontDict.entry("Subtype", this.pdf.name(this.getSubtype()));
        this.fontDict.entry("Name", this.pdf.name(this.getFontName()));
        this.fontDict.entry("FirstChar", 0);
        this.fontDict.entry("LastChar", 255);
        this.fontDict.entry("Encoding", this.redundanceTracker.getReference(this.getEncodingTable(), PDFCharTableWriter.getInstance()));
        this.fontDict.entry("Widths", this.pdf.ref(String.valueOf(this.reference) + "Widths"));
        this.addAdditionalEntries(this.fontDict);
        this.pdf.close(this.fontDict);
        this.addAdditionalInitDicts();
    }

    protected void closeEmbedFont() {
    }

    protected void writeWidths(double[] widths) throws IOException {
        Object[] widthsObj = new Object[256];
        int i = 0;
        while (i < widthsObj.length) {
            widthsObj[i] = new Double(widths[i]);
            ++i;
        }
        this.pdf.object(String.valueOf(this.reference) + "Widths", widthsObj);
    }

    protected void writeEncoding(CharTable charTable) throws IOException {
    }

    public static void writeEncoding(PDFWriter pdf, String ref, CharTable charTable) throws IOException {
        PDFDictionary encoding = pdf.openDictionary(ref);
        encoding.entry("Type", pdf.name("Encoding"));
        Object[] differences = new Object[257];
        differences[0] = new Integer(0);
        int i = 0;
        while (i < 256) {
            String charName = charTable.toName(i);
            differences[i + 1] = charName != null ? pdf.name(charName) : pdf.name(".notdef");
            ++i;
        }
        encoding.entry("Differences", differences);
        pdf.close(encoding);
    }

    protected String createCharacterReference(String characterName) {
        return "Glyph_" + this.reference + ":" + characterName;
    }
}

