/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.IAdaptable;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.gef.IInputChangedListener;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.e4handlers.StartPresentationStoryHandler;
import org.xmind.ui.internal.editor.IEditorLayoutManager;
import org.xmind.ui.internal.presentation.Presentation;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.slide.AddSlideCommand;
import org.xmind.ui.internal.presentation.slide.DeleteSlideCommand;
import org.xmind.ui.internal.presentation.slide.DeleteStoryCommand;
import org.xmind.ui.internal.presentation.slide.IPresentationEventListener;
import org.xmind.ui.internal.presentation.slide.PPTExportWizard;
import org.xmind.ui.internal.presentation.slide.PresentationEvent;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryGalleryViewer;
import org.xmind.ui.internal.presentation.slide.PresentationStoryLabelProvider;
import org.xmind.ui.internal.presentation.slide.PresentationStoryManager;
import org.xmind.ui.internal.presentation.slide.PresentationStoryPage;
import org.xmind.ui.internal.presentation.slide.SelectionSpliter;
import org.xmind.ui.internal.presentation.slide.SlidePreviewGenerator;
import org.xmind.ui.internal.presentation.slide.StoryTitleEditor;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class PresentationStoryEditCover
implements ISelectionChangedListener,
IPresentationEventListener {
    public static final String DATA_STORY_DELETE_SLIDE_HELPER = "org.xmind.ui.story.deleteSlideHelper";
    private static final String SLIDE_EDITING_CONTEXT_ID = "org.xmind.ui.context.presentation.slide.editing";
    private static final String DATA_RUNNABLE = "dataRunnable";
    private static final String DATA_TYPE = "dataType";
    private static final String DATA_ENABLED = "dataEnabled";
    private static final String TYPE_ADD = "add";
    private static final String TYPE_PLAY = "play";
    private static final String TYPE_EXIT = "exit";
    private static final String ICON_PATH = "icons/";
    private static final int TOTAL_SIZE = 10;
    private static final String[] BORDER_COLORS = new String[]{"#b1b1b1", "#b9b9b9", "#c1c1c1", "#c9c9c9", "#d1d1d1", "#d8d8d8", "#e0e0e0", "#e8e8e8", "#ececec", "#f0f0f0"};
    private static final String[] FILL_COLORS = new String[]{"#e4e4e4", "#e7e7e7", "#eaeaea", "#ededed", "#efefef", "#f2f2f2", "#f5f5f5", "#f7f7f7", "#f9f9f9", "#fafafa"};
    private static final String[] FONT_COLORS = new String[]{"#1e1e1e", "#353535", "#4b4b4b", "#626262", "#787878", "#8f8f8f", "#a5a5a5", "#a3aab2", "#c7c7c7", "#d2d2d2"};
    private IEditorLayoutManager layoutManager;
    private IGraphicalEditor editor;
    private Composite parent;
    private Composite previewPanel;
    private Control editorContainer;
    private Composite titleContainer;
    private Label title;
    private StoryTitleEditor textEditor;
    private PresentationStory story;
    private PresentationStoryGalleryViewer viewer;
    private ISelection editorCurrentSelection;
    private Control[] controlButtons = new Control[3];
    private Region[] regions = new Region[2];
    private PresentationSlide previewingSlide = null;
    private ResourceManager resources;
    private Composite controlPanel;
    private Composite mainPanel;
    private Composite tipPanel;
    private Control escTooltip;
    private String partId;
    private Map<String, Runnable> runnables = new HashMap<String, Runnable>();
    private Composite escTooltipComposite;
    private Label escTooltipLabel;
    private Hyperlink exitHyperlink;
    private Timer timer;
    private int count;
    private IAction exportPPTAction;

    public PresentationStoryEditCover(Composite parent, PresentationStory story, IEditorLayoutManager layoutManager, IGraphicalEditor editor, ISelectionProvider selectionProvider) {
        this.parent = parent;
        this.story = story;
        this.layoutManager = layoutManager;
        this.editor = editor;
        this.editorCurrentSelection = selectionProvider.getSelection();
    }

    public void create() {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.parent);
        this.parent.setLayout((Layout)PresentationStoryEditCover.createGridLayoutTemplate(2, false));
        this.parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite(this.parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createStoryPanel(composite);
        this.createMainPanel(composite);
        PresentationStoryManager.instance.registerStoryEventListener(this);
        this.story.registerSlideEventListener(this);
        this.updateButtonStatus();
        this.updateTipStatus();
    }

    private void createStoryPanel(Composite parent) {
        Composite border = new Composite(parent, 0);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cecece")));
        GridData gridData = new GridData(1, 4, false, true);
        gridData.verticalSpan = 2;
        gridData.widthHint = 230;
        border.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        border.setLayout((Layout)layout);
        Composite composite = new Composite(border, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f6f6f6")));
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)PresentationStoryEditCover.createGridLayoutTemplate(1, false));
        this.createTopBar(composite);
        this.createSlideGallery(composite);
        this.initDeleteSlideHelper(border);
    }

    private void initDeleteSlideHelper(Composite parent) {
        final Shell shell = parent.getShell();
        shell.setData(DATA_STORY_DELETE_SLIDE_HELPER, (Object)new Runnable(){

            public void run() {
                PresentationStoryEditCover.this.deleteSlideFromCurrentSelections();
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                shell.setData(PresentationStoryEditCover.DATA_STORY_DELETE_SLIDE_HELPER, null);
            }
        });
    }

    private void createTopBar(Composite parent) {
        Composite border = new Composite(parent, 0);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cecece")));
        GridData gridData = new GridData(4, 1, true, false);
        gridData.heightHint = 28;
        border.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 1;
        border.setLayout((Layout)layout);
        Composite composite = new Composite(border, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#eaeaea")));
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout2 = PresentationStoryEditCover.createGridLayoutTemplate(2, false);
        layout2.marginLeft = 1;
        composite.setLayout((Layout)layout2);
        this.createLeftBarArea(composite);
        this.createRightBarArea(composite);
    }

    private void createLeftBarArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = PresentationStoryEditCover.createGridLayoutTemplate(3, false);
        layout.marginLeft = 20;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.titleContainer = new Composite(composite, 0);
        GridData layoutData = new GridData(16384, 0x1000000, false, true);
        layoutData.widthHint = 90;
        this.titleContainer.setLayoutData((Object)layoutData);
        StackLayout stackLayout = new StackLayout();
        this.titleContainer.setLayout((Layout)stackLayout);
        Composite titleParent = new Composite(this.titleContainer, 0);
        GridLayout layout2 = PresentationStoryEditCover.createGridLayoutTemplate(1, false);
        titleParent.setLayout((Layout)layout2);
        this.title = new Label(titleParent, 0);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.title.setAlignment(16384);
        this.title.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.title.getFont().getFontData(), (int)1))));
        String t = this.story.getName();
        if (t.length() > 13) {
            this.title.setText(String.valueOf(t.substring(0, 10)) + "...");
        } else {
            this.title.setText(t);
        }
        stackLayout.topControl = titleParent;
        Composite editorParent = new Composite(this.titleContainer, 0);
        editorParent.setLayout((Layout)new GridLayout(1, false));
        this.textEditor = new StoryTitleEditor(this.editor, this.story, this);
        TitleMouseClickListener li = new TitleMouseClickListener(composite);
        this.title.addMouseListener((MouseListener)li);
        composite.addMouseListener((MouseListener)li);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(16384, 4, false, true));
        GridLayout layout3 = PresentationStoryEditCover.createGridLayoutTemplate(1, false);
        layout3.marginLeft = 0;
        composite2.setLayout((Layout)layout3);
        Label img = PresentationStoryEditCover.createImageLabel(composite2, "icons/down.png");
        img.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        if (img != null) {
            img.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
            img.addMouseListener((MouseListener)li);
        }
    }

    private void createRightBarArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, false, true));
        GridLayout layout2 = PresentationStoryEditCover.createGridLayoutTemplate(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.marginRight = 5;
        composite.setLayout((Layout)layout2);
        ToolBar toolBar = new ToolBar(composite, 0x820000);
        toolBar.setBackground(composite.getBackground());
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolItem ti = new ToolItem(toolBar, 8);
        ti.setImage((Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/refresh.png")));
        ti.setToolTipText(PresentationMessages.PresentationStoryEditCover_Tip_Refresh_Slide);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PresentationStoryEditCover.this.refreshSlides();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createSlideGallery(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f6f6f6")));
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.viewer = new PresentationStoryGalleryViewer((IEditorPart)this.editor){

            public void setSelection(ISelection selection, boolean reveal) {
                if (!PresentationStoryEditCover.this.isPreviewingSlide() || !selection.isEmpty()) {
                    super.setSelection(selection, reveal);
                }
            }
        };
        this.viewer.createControl(composite, 0);
        this.viewer.getControl().setBackground(composite.getBackground());
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PresentationStoryEditCover.this.turnOnPreviewMode();
            }
        });
        this.createNullContent(composite, this.viewer);
        this.refresh();
        final EContextService contextService = (EContextService)this.editor.getSite().getService(EContextService.class);
        this.viewer.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                contextService.deactivateContext(PresentationStoryEditCover.SLIDE_EDITING_CONTEXT_ID);
            }

            public void focusGained(FocusEvent e) {
                contextService.activateContext(PresentationStoryEditCover.SLIDE_EDITING_CONTEXT_ID);
            }
        });
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                contextService.deactivateContext(PresentationStoryEditCover.SLIDE_EDITING_CONTEXT_ID);
            }
        });
    }

    private void createNullContent(Composite parent, final GalleryViewer galleryViewer) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 20;
        composite.setLayout((Layout)gridLayout);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        imageLabel.setBackground(composite.getBackground());
        imageLabel.setImage((Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/null_story.png")));
        Label tipLabel = new Label(composite, 64);
        tipLabel.setBackground(composite.getBackground());
        tipLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        tipLabel.setAlignment(0x1000000);
        tipLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#aaaaaa")));
        tipLabel.setText(PresentationMessages.PresentationStoryEditCover_Tip_Select_Message);
        Composite nullControl = composite;
        Control viewerControl = galleryViewer.getControl();
        nullControl.setVisible(false);
        ((GridData)nullControl.getLayoutData()).exclude = true;
        galleryViewer.addInputChangedListener(new IInputChangedListener((Control)nullControl, viewerControl, parent){
            private final /* synthetic */ Control val$nullControl;
            private final /* synthetic */ Control val$viewerControl;
            private final /* synthetic */ Composite val$parent;
            {
                this.val$nullControl = control;
                this.val$viewerControl = control2;
                this.val$parent = composite;
            }

            public void inputChanged(IViewer viewer, Object newInput, Object oldInput) {
                if (galleryViewer.getContentProvider() == null) {
                    return;
                }
                Object[] elements = galleryViewer.getContentProvider().getElements(newInput);
                boolean isNull = elements == null || elements.length == 0;
                this.val$nullControl.setVisible(isNull);
                ((GridData)this.val$nullControl.getLayoutData()).exclude = !isNull;
                this.val$viewerControl.setVisible(!isNull);
                ((GridData)this.val$viewerControl.getLayoutData()).exclude = isNull;
                this.val$parent.layout();
            }
        });
    }

    private void createControlPanel(Composite parent) {
        Region region;
        Composite composite;
        this.controlPanel = composite = new Composite(parent, 0);
        this.controlPanel.moveAbove(null);
        GridData gridData = new GridData(0x1000000, 128, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        Image image = (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom("icons/control_panel_region.png"));
        this.regions[0] = region = this.getImageRegion(image);
        composite.setRegion(region);
        GridData layoutData = (GridData)composite.getLayoutData();
        layoutData.widthHint = image.getBounds().width;
        layoutData.heightHint = image.getBounds().height;
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                region.dispose();
            }
        });
        this.controlButtons[0] = this.createButton(composite, TYPE_ADD);
        this.controlButtons[1] = this.createButton(composite, TYPE_PLAY);
        this.controlButtons[2] = this.createButton(composite, TYPE_EXIT);
    }

    private Region getImageRegion(Image image) {
        Rectangle imageBounds = image.getBounds();
        Region region = new Region();
        region.add(new Rectangle(imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height));
        ImageData data = image.getImageData();
        Rectangle pixel = new Rectangle(0, 0, 1, 1);
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                if (data.getAlpha(x, y) == 0) {
                    pixel.x = data.x + x;
                    pixel.y = data.y + y;
                    region.subtract(pixel);
                }
                ++x;
            }
            ++y;
        }
        return region;
    }

    private Label createButton(Composite parent, String type) {
        Label buttonLabel = new Label(parent, 0);
        GridData gridData = new GridData(16384, 4, false, true);
        buttonLabel.setLayoutData((Object)gridData);
        buttonLabel.setData(DATA_ENABLED, (Object)true);
        buttonLabel.setData(DATA_TYPE, (Object)type);
        buttonLabel.setImage(this.getImage(type, false, true));
        buttonLabel.setToolTipText(this.getTooltip(type));
        buttonLabel.setData(DATA_RUNNABLE, (Object)this.getRunnable(type));
        buttonLabel.setCursor(parent.getDisplay().getSystemCursor(21));
        this.installMouseListener(buttonLabel);
        return buttonLabel;
    }

    private void installMouseListener(final Label label) {
        label.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (((Boolean)label.getData(PresentationStoryEditCover.DATA_ENABLED)).booleanValue()) {
                    label.setImage(PresentationStoryEditCover.this.getImage((String)label.getData(PresentationStoryEditCover.DATA_TYPE), true, true));
                }
            }

            public void mouseExit(MouseEvent e) {
                if (((Boolean)label.getData(PresentationStoryEditCover.DATA_ENABLED)).booleanValue()) {
                    label.setImage(PresentationStoryEditCover.this.getImage((String)label.getData(PresentationStoryEditCover.DATA_TYPE), false, true));
                }
            }
        });
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Runnable runnable;
                if (((Boolean)label.getData(PresentationStoryEditCover.DATA_ENABLED)).booleanValue() && (runnable = (Runnable)label.getData(PresentationStoryEditCover.DATA_RUNNABLE)) != null) {
                    runnable.run();
                }
            }
        });
    }

    private void createMainPanel(Composite parent) {
        Composite previewPanel;
        Composite mainPanel;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new ContentsLayout());
        this.mainPanel = mainPanel = new Composite(composite, 0);
        StackLayout sl = new StackLayout();
        mainPanel.setLayout((Layout)sl);
        this.editorContainer = this.parent.getChildren()[0];
        this.editorContainer.setParent(mainPanel);
        this.previewPanel = previewPanel = this.createPreviewPanel(mainPanel);
        sl.topControl = this.editorContainer;
        this.createTipPanel(composite);
        this.createControlPanel(composite);
        this.createEscTooltip(composite);
    }

    private void createTipPanel(Composite parent) {
        Composite border;
        this.tipPanel = border = new Composite(parent, 0);
        this.tipPanel.moveAbove(null);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#d6c951")));
        GridData gridData = new GridData(0x1000000, 128, true, false);
        border.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        border.setLayout((Layout)layout);
        Composite composite = new Composite(border, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#fff6a1")));
        GridData gridData2 = new GridData(0x1000000, 0x1000000, false, false);
        gridData2.widthHint = 338;
        gridData2.heightHint = 28;
        composite.setLayoutData((Object)gridData2);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        composite.setLayout((Layout)layout2);
        Label label = new Label(composite, 0);
        label.setBackground(composite.getBackground());
        label.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#1e1e1e")));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        label.setText(PresentationMessages.PresentationStoryEditCover_Tip_Message);
    }

    private void createEscTooltip(final Composite parent) {
        Label label;
        Composite composite;
        Composite border = new Composite(parent, 0);
        this.escTooltip = border;
        this.escTooltip.setVisible(false);
        this.escTooltip.moveAbove(null);
        border.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)BORDER_COLORS[0])));
        GridData gridData = new GridData(0x1000000, 128, true, false);
        border.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        border.setLayout((Layout)layout);
        this.escTooltipComposite = composite = new Composite(border, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FILL_COLORS[0])));
        GridData gridData2 = new GridData(0x1000000, 0x1000000, false, false);
        gridData2.heightHint = 28;
        composite.setLayoutData((Object)gridData2);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 10;
        layout2.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout2);
        this.escTooltipLabel = label = new Label(composite, 0);
        label.setBackground(composite.getBackground());
        label.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FONT_COLORS[0])));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        label.setText(PresentationMessages.PresentationStoryEditCover_esc_tootip_label);
        this.exitHyperlink = new Hyperlink(composite, 0);
        this.exitHyperlink.setUnderlined(true);
        this.exitHyperlink.setBackground(composite.getBackground());
        this.exitHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FONT_COLORS[0])));
        this.exitHyperlink.setText(PresentationMessages.PresentationStoryEditCover_exit_hyperlink_label);
        this.exitHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                PresentationStoryEditCover.this.viewer.setSelection((ISelection)new StructuredSelection());
                PresentationStoryEditCover.this.turnOnNormalMode();
            }
        });
        final Listener traverseFilter = new Listener(){

            public void handleEvent(Event event) {
                IWorkbenchPart activePart;
                IWorkbenchWindow workbenchWindow;
                if (event.detail == 2 && PresentationStoryEditCover.this.isPreviewingSlide() && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && workbenchWindow.getActivePage() != null && (activePart = workbenchWindow.getActivePage().getActivePart()) instanceof IGraphicalEditor) {
                    PresentationStoryEditCover.this.viewer.setSelection((ISelection)new StructuredSelection());
                    PresentationStoryEditCover.this.turnOnNormalMode();
                }
            }
        };
        parent.getDisplay().addFilter(31, traverseFilter);
        this.escTooltip.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                parent.getDisplay().removeFilter(31, traverseFilter);
            }
        });
        MouseTrackListener mouseTrackListener = new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (Arrays.asList(PresentationStoryEditCover.this.escTooltipComposite.getChildren()).contains(e.display.getCursorControl())) {
                    return;
                }
                if (PresentationStoryEditCover.this.timer != null) {
                    return;
                }
                PresentationStoryEditCover.this.timer = new Timer();
                PresentationStoryEditCover.this.count = 1;
                PresentationStoryEditCover.this.timer.schedule(PresentationStoryEditCover.this.getChangingColorTask(), 2000L, 100L);
            }

            public void mouseEnter(MouseEvent e) {
                if (PresentationStoryEditCover.this.timer != null) {
                    PresentationStoryEditCover.this.timer.cancel();
                    PresentationStoryEditCover.this.timer = null;
                    PresentationStoryEditCover.this.count = 1;
                }
                PresentationStoryEditCover.this.escTooltip.setBackground((Color)PresentationStoryEditCover.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)BORDER_COLORS[0])));
                PresentationStoryEditCover.this.escTooltipComposite.setBackground((Color)PresentationStoryEditCover.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FILL_COLORS[0])));
                PresentationStoryEditCover.this.escTooltipLabel.setBackground(PresentationStoryEditCover.this.escTooltipComposite.getBackground());
                PresentationStoryEditCover.this.escTooltipLabel.setForeground((Color)PresentationStoryEditCover.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FONT_COLORS[0])));
                PresentationStoryEditCover.this.exitHyperlink.setBackground(PresentationStoryEditCover.this.escTooltipComposite.getBackground());
                PresentationStoryEditCover.this.exitHyperlink.setForeground((Color)PresentationStoryEditCover.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FONT_COLORS[0])));
            }
        };
        this.escTooltipComposite.addMouseTrackListener(mouseTrackListener);
        this.escTooltipLabel.addMouseTrackListener(mouseTrackListener);
        this.exitHyperlink.addMouseTrackListener(mouseTrackListener);
    }

    private Composite createPreviewPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        PresentationStoryPage page = new PresentationStoryPage(this.editor, this.story);
        page.createControl(composite);
        composite.setData("PresentationStoryPage", (Object)page);
        return composite;
    }

    private void turnOnNormalMode() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.partId != null && PresentationStoryEditCover.getVisiblePartId(workbenchWindow, "org.xmind.ui.stack.right") == null) {
            PresentationStoryEditCover.showHiddenPart(workbenchWindow, this.partId);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                PresentationStoryEditCover.this.previewingSlide = null;
                PresentationStoryEditCover.this.changeButtonType(PresentationStoryEditCover.this.controlButtons[0], PresentationStoryEditCover.TYPE_ADD);
                PresentationStoryEditCover.this.changeButtonType(PresentationStoryEditCover.this.controlButtons[2], PresentationStoryEditCover.TYPE_EXIT);
                PresentationStoryEditCover.this.switchMainPanelContent("Editor");
                PresentationStoryEditCover.this.updateControlPanel();
                PresentationStoryEditCover.this.updateTooltip();
                PresentationStoryEditCover.this.updateButtonStatus();
                PresentationStoryEditCover.this.updateTipStatus();
                PresentationStoryEditCover.this.updateViewerSelection();
            }
        });
        Control control = this.viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        Object o = control.getData("KeyDownListener");
        if (o instanceof Listener) {
            this.viewer.getControl().removeListener(1, (Listener)o);
            this.viewer.getControl().setData("KeyDownListener", null);
        }
    }

    private void updateViewerSelection() {
        if (this.viewer != null) {
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void turnOnPreviewMode() {
        if (this.previewPanel == null || this.previewPanel.isDisposed()) {
            return;
        }
        PresentationSlide slide = this.getSlideFromSelection();
        if (slide == null) {
            return;
        }
        if (this.isOrphan(slide)) {
            MessageDialog dialog = new MessageDialog(this.parent.getShell(), null, null, PresentationMessages.RefreshSlidesConfirm_message, 5, new String[]{PresentationMessages.Refresh_label, IDialogConstants.CANCEL_LABEL}, 0);
            if (dialog.open() == 0) {
                this.refreshSlides();
            }
            return;
        }
        this.turnOnPreviewMode(slide);
        Control viewerControl = this.viewer.getControl();
        if (viewerControl == null || viewerControl.isDisposed()) {
            return;
        }
        Object o = viewerControl.getData("KeyDownListener");
        if (o == null) {
            Listener l = new Listener(){

                public void handleEvent(Event event) {
                    int index;
                    if (event.keyCode == 0x1000002 || event.keyCode == 0x1000004) {
                        int index2 = PresentationStoryEditCover.this.getLastSlideIndexFromCurrentSelections();
                        if (index2 >= 0 && index2 < PresentationStoryEditCover.this.story.getSlidesSize() - 1) {
                            PresentationSlide target = PresentationStoryEditCover.this.story.getSlides().get(index2 + 1);
                            PresentationStoryEditCover.this.viewer.setSelection((ISelection)new StructuredSelection((Object)target));
                        }
                    } else if ((event.keyCode == 0x1000001 || event.keyCode == 0x1000003) && (index = PresentationStoryEditCover.this.getLastSlideIndexFromCurrentSelections()) > 0 && index < PresentationStoryEditCover.this.story.getSlidesSize()) {
                        PresentationSlide target = PresentationStoryEditCover.this.story.getSlides().get(index - 1);
                        PresentationStoryEditCover.this.viewer.setSelection((ISelection)new StructuredSelection((Object)target));
                    }
                }
            };
            viewerControl.addListener(1, l);
            viewerControl.setData("KeyDownListener", (Object)l);
        }
    }

    private boolean isOrphan(PresentationSlide slide) {
        IAdaptable parent = slide.getParent();
        return parent == null || !(parent instanceof IWorkbookComponent) || ((IWorkbookComponent)parent).isOrphan();
    }

    private PresentationSlide getSlideFromSelection() {
        Object o;
        IStructuredSelection selections;
        ISelection s = this.viewer.getSelection();
        if (s instanceof IStructuredSelection && (selections = (IStructuredSelection)s).size() == 1 && (o = selections.getFirstElement()) instanceof PresentationSlide) {
            return (PresentationSlide)o;
        }
        return null;
    }

    private void turnOnPreviewMode(final PresentationSlide slide) {
        this.partId = PresentationStoryEditCover.hideVisiblePart(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.xmind.ui.stack.right");
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (PresentationStoryEditCover.this.previewPanel != null && !PresentationStoryEditCover.this.previewPanel.isDisposed()) {
                    Object o = PresentationStoryEditCover.this.previewPanel.getData("PresentationStoryPage");
                    if (!(o instanceof PresentationStoryPage)) {
                        throw new IllegalArgumentException();
                    }
                    PresentationStoryPage page = (PresentationStoryPage)o;
                    page.showSlide(slide);
                    PresentationStoryEditCover.this.switchMainPanelContent("Preview");
                    PresentationStoryEditCover.this.previewingSlide = slide;
                    PresentationStoryEditCover.this.updateControlPanel();
                    PresentationStoryEditCover.this.updateTooltip();
                }
            }
        });
    }

    private void deleteSlideFromCurrentSelections() {
        List<PresentationSlide> selections = this.viewer.getSlideSelections();
        if (!selections.isEmpty()) {
            DeleteSlideCommand cmd = new DeleteSlideCommand(this.story, selections);
            this.editor.getCommandStack().execute((Command)cmd);
            this.refresh();
        }
    }

    private int getLastSlideIndexFromCurrentSelections() {
        List<PresentationSlide> selections = this.viewer.getSlideSelections();
        if (!selections.isEmpty()) {
            return selections.get(selections.size() - 1).getIndex();
        }
        return -1;
    }

    private void updateTooltip() {
        boolean newVisible;
        boolean oldVisible = this.escTooltip.getVisible();
        if (this.escTooltip != null) {
            if (this.isPreviewingSlide()) {
                this.escTooltip.setVisible(true);
            } else {
                this.escTooltip.setVisible(false);
            }
        }
        if (oldVisible == (newVisible = this.escTooltip.getVisible())) {
            return;
        }
        if (this.escTooltip.isVisible()) {
            this.escTooltip.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)BORDER_COLORS[0])));
            this.escTooltipComposite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FILL_COLORS[0])));
            this.escTooltipLabel.setBackground(this.escTooltipComposite.getBackground());
            this.escTooltipLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FONT_COLORS[0])));
            this.exitHyperlink.setBackground(this.escTooltipComposite.getBackground());
            this.exitHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FONT_COLORS[0])));
            if (this.timer != null) {
                return;
            }
            this.timer = new Timer();
            this.count = 1;
            this.timer.schedule(this.getChangingColorTask(), 2000L, 100L);
        } else if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.count = 1;
        }
    }

    private TimerTask getChangingColorTask() {
        return new TimerTask(){

            public void run() {
                if (PresentationStoryEditCover.this.count > 9) {
                    PresentationStoryEditCover.this.timer.cancel();
                    PresentationStoryEditCover.this.timer = null;
                    PresentationStoryEditCover.this.count = 1;
                    return;
                }
                if (PresentationStoryEditCover.this.escTooltip == null || PresentationStoryEditCover.this.escTooltip.isDisposed()) {
                    return;
                }
                PresentationStoryEditCover.this.escTooltip.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (PresentationStoryEditCover.this.escTooltip == null || PresentationStoryEditCover.this.escTooltip.isDisposed() || PresentationStoryEditCover.this.count > 9) {
                            return;
                        }
                        PresentationStoryEditCover.this.escTooltip.setBackground((Color)PresentationStoryEditCover.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)BORDER_COLORS[PresentationStoryEditCover.this.count])));
                        PresentationStoryEditCover.this.escTooltipComposite.setBackground((Color)PresentationStoryEditCover.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FILL_COLORS[PresentationStoryEditCover.this.count])));
                        PresentationStoryEditCover.this.escTooltipLabel.setBackground(PresentationStoryEditCover.this.escTooltipComposite.getBackground());
                        PresentationStoryEditCover.this.escTooltipLabel.setForeground((Color)PresentationStoryEditCover.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FONT_COLORS[PresentationStoryEditCover.this.count])));
                        PresentationStoryEditCover.this.exitHyperlink.setBackground(PresentationStoryEditCover.this.escTooltipComposite.getBackground());
                        PresentationStoryEditCover.this.exitHyperlink.setForeground((Color)PresentationStoryEditCover.this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)FONT_COLORS[PresentationStoryEditCover.this.count])));
                        PresentationStoryEditCover presentationStoryEditCover = PresentationStoryEditCover.this;
                        presentationStoryEditCover.count = presentationStoryEditCover.count + 1;
                        if (PresentationStoryEditCover.this.count > 9) {
                            PresentationStoryEditCover.this.timer.cancel();
                            PresentationStoryEditCover.this.timer = null;
                            PresentationStoryEditCover.this.count = 1;
                        }
                    }
                });
            }
        };
    }

    private void changeButtonType(Control button, String type) {
        if (button == null || button.isDisposed()) {
            return;
        }
        button.setData(DATA_TYPE, (Object)type);
        this.updateButton(button);
    }

    private void updateButton(Control button) {
        if (button == null || button.isDisposed()) {
            return;
        }
        Label buttonLabel = (Label)button;
        String type = (String)button.getData(DATA_TYPE);
        boolean isHovered = button.getDisplay().getCursorControl() == button;
        boolean isEnabled = (Boolean)button.getData(DATA_ENABLED);
        buttonLabel.setImage(this.getImage(type, isHovered, isEnabled));
        buttonLabel.setToolTipText(isEnabled ? this.getTooltip(type) : null);
        buttonLabel.setData(DATA_RUNNABLE, (Object)this.getRunnable(type));
        this.controlPanel.layout();
    }

    private Image getImage(String type, boolean hovered, boolean isEnabled) {
        if (type == null) {
            return null;
        }
        String imagePath = ICON_PATH;
        if (TYPE_ADD.equals(type)) {
            imagePath = String.valueOf(imagePath) + "slide_add";
        } else if (TYPE_PLAY.equals(type)) {
            imagePath = String.valueOf(imagePath) + "slide_play";
        } else if (TYPE_EXIT.equals(type)) {
            imagePath = String.valueOf(imagePath) + "slide_exit";
        }
        if (!isEnabled) {
            imagePath = String.valueOf(imagePath) + "_disabled";
        }
        if (hovered) {
            imagePath = String.valueOf(imagePath) + "_hover";
        }
        imagePath = String.valueOf(imagePath) + ".png";
        return (Image)this.resources.get((DeviceResourceDescriptor)Presentation.imageFrom(imagePath));
    }

    private String getTooltip(String type) {
        if (TYPE_ADD.equals(type)) {
            return PresentationMessages.PresentationStoryEditCover_Tip_Add_Slide;
        }
        if (TYPE_PLAY.equals(type)) {
            return PresentationMessages.PresentationStoryEditCover_Tip_Paly_Story;
        }
        if (TYPE_EXIT.equals(type)) {
            return PresentationMessages.PresentationStoryEditCover_Tip_Quit_Story;
        }
        return null;
    }

    private Runnable getRunnable(String type) {
        if (type == null) {
            return null;
        }
        if (this.runnables.isEmpty()) {
            this.initRunnables();
        }
        return this.runnables.get(type);
    }

    private void initRunnables() {
        this.runnables.put(TYPE_PLAY, new Runnable(){

            public void run() {
                for (PresentationSlide s : PresentationStoryEditCover.this.story.getSlides()) {
                    if (!PresentationStoryEditCover.this.isOrphan(s)) continue;
                    MessageDialog dialog = new MessageDialog(PresentationStoryEditCover.this.parent.getShell(), null, null, PresentationMessages.RefreshSlidesConfirm_message, 5, new String[]{PresentationMessages.Refresh_label, IDialogConstants.CANCEL_LABEL}, 0);
                    if (dialog.open() == 0) {
                        PresentationStoryEditCover.this.refreshSlides();
                    }
                    return;
                }
                if (PresentationStoryEditCover.this.controlPanel != null && !PresentationStoryEditCover.this.controlPanel.isDisposed() && PresentationStoryEditCover.this.story != null) {
                    StartPresentationStoryHandler.execute(PresentationStoryEditCover.this.controlPanel.getShell(), (IEditorPart)PresentationStoryEditCover.this.editor, PresentationStoryEditCover.this.story);
                }
            }
        });
        this.runnables.put(TYPE_EXIT, new Runnable(){

            public void run() {
                if (PresentationStoryEditCover.this.isPreviewingSlide()) {
                    PresentationStoryEditCover.this.viewer.setSelection((ISelection)new StructuredSelection());
                    PresentationStoryEditCover.this.turnOnNormalMode();
                } else {
                    PresentationStoryEditCover.this.layoutManager.restoreDefault();
                }
            }
        });
        this.runnables.put(TYPE_ADD, new Runnable(){

            public void run() {
                PresentationStoryEditCover.this.addSlideFromCurrentSelection();
                PresentationStoryEditCover.this.refresh();
            }
        });
    }

    private void switchMainPanelContent(String id) {
        if (this.mainPanel != null && !this.mainPanel.isDisposed()) {
            StackLayout sl = (StackLayout)this.mainPanel.getLayout();
            if ("Editor".equals(id) && sl.topControl != this.editorContainer) {
                sl.topControl = this.editorContainer;
                this.mainPanel.layout();
            } else if ("Preview".equals(id) && sl.topControl != this.previewPanel) {
                sl.topControl = this.previewPanel;
                this.mainPanel.layout();
            }
        }
    }

    private void updateControlPanel() {
        if (this.isPreviewingSlide()) {
            this.controlPanel.setVisible(false);
        } else {
            this.controlPanel.setVisible(true);
        }
        this.controlPanel.getParent().layout(true, true);
    }

    private void updateButtonStatus() {
        Control button;
        Control[] controlArray = this.controlButtons;
        int n = this.controlButtons.length;
        int n2 = 0;
        while (n2 < n) {
            button = controlArray[n2];
            if (button != null && !button.isDisposed()) {
                button.setData(DATA_ENABLED, (Object)true);
            }
            ++n2;
        }
        controlArray = this.controlButtons;
        n = this.controlButtons.length;
        n2 = 0;
        while (n2 < n) {
            button = controlArray[n2];
            if (button != null && !button.isDisposed() && !this.isPreviewingSlide()) {
                if (TYPE_ADD.equals(button.getData(DATA_TYPE))) {
                    IStructuredSelection ss;
                    if (this.editorCurrentSelection instanceof IStructuredSelection && !SelectionSpliter.instance.canSplit(ss = (IStructuredSelection)this.editorCurrentSelection)) {
                        button.setData(DATA_ENABLED, (Object)false);
                    }
                } else if (TYPE_PLAY.equals(button.getData(DATA_TYPE))) {
                    boolean enabled = this.story != null && this.story.getSlides().size() != 0;
                    button.setData(DATA_ENABLED, (Object)enabled);
                }
            }
            ++n2;
        }
        controlArray = this.controlButtons;
        n = this.controlButtons.length;
        n2 = 0;
        while (n2 < n) {
            button = controlArray[n2];
            if (button != null && !button.isDisposed()) {
                if (((Boolean)button.getData(DATA_ENABLED)).booleanValue()) {
                    button.setCursor(this.parent.getDisplay().getSystemCursor(21));
                } else {
                    button.setCursor(null);
                }
                this.updateButton(button);
            }
            ++n2;
        }
    }

    private void updateTipStatus() {
        if (this.tipPanel == null || this.tipPanel.isDisposed()) {
            return;
        }
        boolean isMultiCategories = false;
        if (this.editorCurrentSelection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)this.editorCurrentSelection;
            isMultiCategories = ss.size() > 1 && !SelectionSpliter.instance.canSplit(ss);
        }
        boolean tipVisible = !this.isPreviewingSlide() && isMultiCategories;
        this.tipPanel.setVisible(tipVisible);
        if (tipVisible) {
            VerifyUI20141031.getUsageDataCollector().increase("ShowSideStoryWarningTipCount");
        }
    }

    private void renameStory() {
        this.textEditor.setStory(this.story);
        this.textEditor.setSource(this.title);
        this.textEditor.startEditing();
    }

    private void deleteStory(Shell parentShell) {
        String[] labels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
        String msg = NLS.bind((String)PresentationMessages.DeleteConfirm_message, (Object)this.story.getName());
        MessageDialog dialog = new MessageDialog(parentShell, null, null, msg, 5, labels, 0);
        int result = dialog.open();
        if (result == 0) {
            DeleteStoryCommand cmd = new DeleteStoryCommand(this.story, this.editor);
            this.editor.getCommandStack().execute((Command)cmd);
        }
    }

    private void refreshSlides() {
        this.story.refreshSlides();
        for (PresentationSlide s : this.story.getSlides()) {
            SlidePreviewGenerator.regeneratePreview(s);
        }
        ((PresentationStoryLabelProvider)this.viewer.getLabelProvider()).invalidateImageCache();
        this.refresh();
    }

    private void addSlideFromCurrentSelection() {
        if (this.editorCurrentSelection instanceof IStructuredSelection) {
            List<PresentationSlide> slides = this.story.createSlides((IStructuredSelection)this.editorCurrentSelection);
            AddSlideCommand cmd = new AddSlideCommand(this.story, slides);
            this.editor.getCommandStack().execute((Command)cmd);
        }
    }

    private boolean isPreviewingSlide() {
        return this.previewingSlide != null;
    }

    public void handleEvent(PresentationEvent event) {
        if ("removeSlide".equals(event.getType())) {
            this.turnOnNormalMode();
        }
        this.refresh();
        this.updateButtonStatus();
        this.updateTipStatus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.editorCurrentSelection = event.getSelection();
        this.updateButtonStatus();
        this.updateTipStatus();
    }

    public void dispose() {
        Control content = this.parent.getChildren()[0];
        this.editorContainer.setParent(this.parent);
        this.story.unregisterSlideEventListener(this);
        PresentationStoryManager.instance.unregisterStoryEventListener(this);
        content.dispose();
    }

    public Layout getParentLayout() {
        return this.parent.getLayout();
    }

    public void setCurrentStory(PresentationStory story) {
        this.story = story;
        if (this.isPreviewingSlide()) {
            this.turnOnNormalMode();
        }
        this.refresh();
        this.updateActions();
    }

    private void updateActions() {
        if (this.exportPPTAction != null) {
            this.exportPPTAction.setEnabled(this.story.getSlidesSize() > 0);
        }
    }

    private void refresh() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            if (this.story != null) {
                final String t = this.story.getName();
                if (this.title != null && !this.title.isDisposed() && t != null && !"".equals(t)) {
                    this.title.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PresentationStoryEditCover.this.refreshTitle(PresentationStoryEditCover.this.title, t);
                        }
                    });
                }
                this.viewer.setInput(this.story.getSlides());
            } else {
                this.viewer.setInput(null);
            }
            this.viewer.setStory(this.story);
            if (this.titleContainer != null && !this.titleContainer.isDisposed()) {
                this.titleContainer.getParent().computeSize(-1, -1);
                this.titleContainer.getParent().layout();
            }
        }
    }

    public void refreshTitle(String content) {
        this.refreshTitle(this.title, content);
    }

    private void refreshTitle(Label title, String content) {
        if (title == null || title.isDisposed()) {
            return;
        }
        if (content == null || content.length() == 0) {
            title.setText(content);
            return;
        }
        Font font = title.getFont();
        Dimension size = GraphicsUtils.getAdvanced().getTextSize(content, font);
        int titleLength = title.getBounds().width;
        if (titleLength > 0 && size.width > titleLength) {
            int ellipsisLength = GraphicsUtils.getAdvanced().getTextSize((String)"...", (Font)font).width;
            String shortenedContent = content.substring(0, content.length() * (titleLength - ellipsisLength) / size.width);
            title.setText(String.valueOf(shortenedContent) + "...");
        } else {
            title.setText(content);
        }
    }

    private static boolean switchTopControl(Composite container, Composite control) {
        Layout layout = container.getLayout();
        if (layout instanceof StackLayout) {
            StackLayout sl = (StackLayout)layout;
            if (sl.topControl != control) {
                sl.topControl = control;
                container.layout();
                return true;
            }
        }
        return false;
    }

    private static Label createImageLabel(Composite parent, String path) {
        URL url = Platform.getBundle((String)"org.xmind.ui.presentation").getEntry(path);
        if (url != null) {
            try {
                Label img = new Label(parent, 0);
                img.setImage(new Image(null, url.openStream()));
                return img;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static GridLayout createGridLayoutTemplate(int numColumns, boolean makeColumnsEqualWidth) {
        GridLayout layout = new GridLayout(numColumns, makeColumnsEqualWidth);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    private static final String hideVisiblePart(IWorkbenchWindow window, String partStackId) {
        if (window == null || partStackId == null) {
            return null;
        }
        EModelService modelService = (EModelService)window.getService(EModelService.class);
        EPartService partService = (EPartService)window.getService(EPartService.class);
        MApplication appli = ((Workbench)window.getWorkbench()).getApplication();
        List partStacks = modelService.findElements((MUIElement)appli, partStackId, MPartStack.class, null);
        if (partStacks.isEmpty()) {
            return null;
        }
        MPartStack partStack = (MPartStack)partStacks.get(0);
        MPart visiblePart = null;
        MStackElement selectedElement = (MStackElement)partStack.getSelectedElement();
        if (selectedElement instanceof MPlaceholder) {
            MPlaceholder placeholder = (MPlaceholder)selectedElement;
            visiblePart = partService.findPart(placeholder.getElementId());
        } else if (selectedElement instanceof MPart) {
            visiblePart = (MPart)selectedElement;
        }
        if (visiblePart != null) {
            visiblePart.setVisible(false);
            partService.hidePart(visiblePart);
            return visiblePart.getElementId();
        }
        return null;
    }

    private static final String getVisiblePartId(IWorkbenchWindow window, String partStackId) {
        if (window == null || partStackId == null) {
            return null;
        }
        EModelService modelService = (EModelService)window.getService(EModelService.class);
        EPartService partService = (EPartService)window.getService(EPartService.class);
        MApplication appli = ((Workbench)window.getWorkbench()).getApplication();
        List partStacks = modelService.findElements((MUIElement)appli, partStackId, MPartStack.class, null);
        if (partStacks.isEmpty()) {
            return null;
        }
        MPartStack partStack = (MPartStack)partStacks.get(0);
        MPart visiblePart = null;
        MStackElement selectedElement = (MStackElement)partStack.getSelectedElement();
        if (selectedElement instanceof MPlaceholder) {
            MPlaceholder placeholder = (MPlaceholder)selectedElement;
            visiblePart = partService.findPart(placeholder.getElementId());
        } else if (selectedElement instanceof MPart) {
            visiblePart = (MPart)selectedElement;
        }
        return visiblePart == null ? null : visiblePart.getElementId();
    }

    private static final String showHiddenPart(IWorkbenchWindow window, String partId) {
        if (window == null || partId == null) {
            return null;
        }
        EPartService partService = (EPartService)window.getService(EPartService.class);
        MPart hiddenPart = partService.findPart(partId);
        if (hiddenPart != null) {
            hiddenPart.setVisible(true);
            partService.activate(hiddenPart, true);
            return hiddenPart.getElementId();
        }
        return null;
    }

    private class ContentsLayout
    extends Layout {
        private ContentsLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return new Point(wHint, hHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle area = composite.getClientArea();
            PresentationStoryEditCover.this.mainPanel.setBounds(area);
            GridData layoutData = (GridData)PresentationStoryEditCover.this.controlPanel.getLayoutData();
            Point size = new Point(layoutData.widthHint, layoutData.heightHint);
            PresentationStoryEditCover.this.controlPanel.setBounds(area.x + (area.width - size.x) / 2, 20, size.x, size.y);
            Point tipSize = PresentationStoryEditCover.this.tipPanel.computeSize(-1, -1);
            PresentationStoryEditCover.this.tipPanel.setBounds(area.x + (area.width - tipSize.x) / 2, 20 + size.y + 15, tipSize.x, tipSize.y);
            Point tooltipSize = PresentationStoryEditCover.this.escTooltip.computeSize(-1, -1);
            PresentationStoryEditCover.this.escTooltip.setBounds(area.x + (area.width - tooltipSize.x) / 2, 5, tooltipSize.x, tooltipSize.y);
        }
    }

    private class TitleMouseClickListener
    extends MouseAdapter {
        private Composite parent;
        protected Menu menu = null;
        protected boolean visible = false;

        public TitleMouseClickListener(Composite parent) {
            this.parent = parent;
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 1) {
                if (this.isMouseInParent(e) && this.menu == null && !this.visible) {
                    this.createMenu();
                    this.visible = true;
                } else {
                    this.visible = false;
                }
            }
        }

        private boolean isMouseInParent(MouseEvent e) {
            Point size = this.parent.getSize();
            return e.x >= 0 && e.x < size.x && e.y >= 0 && e.y < size.y;
        }

        private Menu createMenu() {
            Menu m = new Menu((Control)this.parent);
            m.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent e) {
                    TitleMouseClickListener.this.menu = null;
                }
            });
            this.fillMenuItem(m);
            m.setLocation(this.getLocation());
            m.setVisible(true);
            return m;
        }

        protected void fillMenuItem(Menu m) {
            List<PresentationStory> stories = PresentationStoryManager.instance.getStories(PresentationStoryEditCover.this.story.getOwnedWorkbook());
            if (stories == null || stories.size() == 0) {
                stories = new ArrayList<PresentationStory>();
                stories.add(PresentationStoryEditCover.this.story);
            }
            for (PresentationStory story : stories) {
                MenuItem item = new MenuItem(m, 8);
                String text = story.getName();
                if (text.length() > 23) {
                    text = String.valueOf(text.substring(0, 20)) + "...";
                }
                item.setText(text);
                item.setData("story", (Object)story);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TitleMouseClickListener.this.handleOpenStoryEvent(e);
                        TitleMouseClickListener.this.clean();
                    }
                });
            }
            Action renameAction = new Action(PresentationMessages.PresentationStoryEditCover_Menu_Rename){

                public void run() {
                    PresentationStoryEditCover.this.renameStory();
                }
            };
            Action deleteAction = new Action(PresentationMessages.PresentationStoryEditCover_Menu_Delete){

                public void run() {
                    PresentationStoryEditCover.this.deleteStory(TitleMouseClickListener.this.parent.getShell());
                }
            };
            PresentationStoryEditCover.this.exportPPTAction = (IAction)new Action(PresentationMessages.PresentationStoryEditCover_exportStoryPPT_actionText){

                public void run() {
                    TitleMouseClickListener.this.exportPPT();
                }
            };
            CommandAction createStoryAction = new CommandAction((IServiceLocator)PlatformUI.getWorkbench(), "org.xmind.ui.menu.pro.command.presentation.newstory");
            createStoryAction.setText(PresentationMessages.PresentationStoryEditCover_createStory_actionText);
            new MenuItem(m, 2);
            new ActionContributionItem((IAction)createStoryAction).fill(m, -1);
            new ActionContributionItem((IAction)renameAction).fill(m, -1);
            new ActionContributionItem((IAction)deleteAction).fill(m, -1);
            new MenuItem(m, 2);
            new ActionContributionItem(PresentationStoryEditCover.this.exportPPTAction).fill(m, -1);
            PresentationStoryEditCover.this.updateActions();
        }

        private void exportPPT() {
            IWorkbook workbook = PresentationStoryEditCover.this.story.getOwnedWorkbook();
            String storyId = PresentationStoryEditCover.this.story.getId();
            PPTExportWizard wizard = new PPTExportWizard(workbook, storyId);
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.open();
        }

        private void handleOpenStoryEvent(SelectionEvent e) {
            Object source = e.getSource();
            if (source instanceof MenuItem) {
                MenuItem i = (MenuItem)source;
                PresentationStoryEditCover.this.setCurrentStory((PresentationStory)i.getData("story"));
                PresentationStoryEditCover.this.refresh();
            }
        }

        private Point getLocation() {
            Rectangle bounds = this.parent.getBounds();
            Point menuLocation = new Point(0, bounds.y + bounds.height);
            return this.parent.getShell().getDisplay().map((Control)this.parent, null, menuLocation);
        }

        protected void clean() {
            this.menu = null;
            this.visible = false;
        }
    }
}

