/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef CFG_GPIO_H
#define CFG_GPIO_H

#include <gpio.h>

/* Pad configuration was generated automatically using intelp2m utility */
static const struct pad_config gpio_table[] = {
	/* ------- GPIO Community 0 ------- */

	/* ------- GPIO Group GPP_B ------- */
	_PAD_CFG_STRUCT(GPP_B0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* CORE_VID0 */
	_PAD_CFG_STRUCT(GPP_B1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* CORE_VID1 */
	_PAD_CFG_STRUCT(GPP_B2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* VRALERT# */
	PAD_NC(GPP_B3, NONE),	/* GPIO */
	PAD_NC(GPP_B4, NONE),	/* GPIO */
	PAD_NC(GPP_B5, NONE),	/* GPIO */
	PAD_NC(GPP_B6, NONE),	/* GPIO */
	PAD_NC(GPP_B7, NONE),	/* GPIO */
	PAD_NC(GPP_B8, NONE),	/* GPIO */
	PAD_NC(GPP_B9, NONE),	/* GPIO */
	PAD_NC(GPP_B10, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_B11, PAD_FUNC(NF1) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* PMCALERT# */
	_PAD_CFG_STRUCT(GPP_B12, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* SLP_S0# */
	_PAD_CFG_STRUCT(GPP_B13, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* PLTRST# */
	_PAD_CFG_STRUCT(GPP_B14, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),	/* SPKR */
	PAD_NC(GPP_B15, NONE),	/* GPIO */
	PAD_NC(GPP_B16, NONE),	/* GPIO */
	PAD_NC(GPP_B17, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_B18, 0, PLTRST),	/* GPIO */
	PAD_NC(GPP_B19, NONE),	/* GPIO */
	PAD_NC(GPP_B20, NONE),	/* GPIO */
	PAD_NC(GPP_B21, NONE),	/* GPIO */
	PAD_NC(GPP_B22, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_B23, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_B24, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* GSPI0_CLK_LOOPBK */
	_PAD_CFG_STRUCT(GPP_B25, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* GSPI1_CLK_LOOPBK */

	/* ------- GPIO Group GPP_T ------- */
	PAD_NC(GPP_T0, NONE),	/* GPIO */
	PAD_NC(GPP_T1, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_T2, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K)),	/* FUSA_DIAGTEST_EN */
	_PAD_CFG_STRUCT(GPP_T3, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K)),	/* FUSA_DIAGTEST_MODE */
	PAD_NC(GPP_T4, NONE),	/* GPIO */
	PAD_NC(GPP_T5, NONE),	/* GPIO */
	PAD_NC(GPP_T6, NONE),	/* GPIO */
	PAD_NC(GPP_T7, NONE),	/* GPIO */
	PAD_NC(GPP_T8, NONE),	/* GPIO */
	PAD_NC(GPP_T9, NONE),	/* GPIO */
	PAD_NC(GPP_T10, NONE),	/* GPIO */
	PAD_NC(GPP_T11, NONE),	/* GPIO */
	PAD_NC(GPP_T12, NONE),	/* GPIO */
	PAD_NC(GPP_T13, NONE),	/* GPIO */
	PAD_NC(GPP_T14, NONE),	/* GPIO */
	PAD_NC(GPP_T15, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_A ------- */
	_PAD_CFG_STRUCT(GPP_A0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE)),	/* ESPI_IO0 */
	_PAD_CFG_STRUCT(GPP_A1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE)),	/* ESPI_IO1 */
	_PAD_CFG_STRUCT(GPP_A2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE)),	/* ESPI_IO2 */
	_PAD_CFG_STRUCT(GPP_A3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE)),	/* ESPI_IO3 */
	_PAD_CFG_STRUCT(GPP_A4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K) | PAD_IOSSTATE(IGNORE)),	/* ESPI_CS0# */
	_PAD_CFG_STRUCT(GPP_A5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),	/* ESPI_ALERT0# */
	_PAD_CFG_STRUCT(GPP_A6, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),	/* ESPI_ALERT1# */
	PAD_CFG_GPO(GPP_A7, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_A8, 0, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_A9, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(DN_20K) | PAD_IOSSTATE(IGNORE)),	/* ESPI_CLK */
	_PAD_CFG_STRUCT(GPP_A10, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* ESPI_RESET# */
	PAD_CFG_GPO(GPP_A11, 1, PLTRST),	/* GPIO */
	PAD_CFG_NF(GPP_A12, UP_20K, DEEP, NF1), /* SATAXPCIE1 */
	PAD_CFG_GPO(GPP_A13, 1, DEEP),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_A14, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* USB_OC1# */
	_PAD_CFG_STRUCT(GPP_A15, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(EDGE_SINGLE) | PAD_IRQ_ROUTE(IOAPIC) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_A16, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* USB_OC3# */
	PAD_NC(GPP_A17, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_A18, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(TxDRxE)),	/* DDSP_HPDB */
	_PAD_CFG_STRUCT(GPP_A19, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* DDSP_HPD1 */
	PAD_NC(GPP_A20, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_A21, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_A22, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_A23, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(UP_20K)),	/* ESPI_CS1# */
	_PAD_CFG_STRUCT(GPP_ESPI_CLK_LOOPBK, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* GPP_ESPI_CLK_LOOPBK */

	/* ------- GPIO Community 1 ------- */

	/* ------- GPIO Group GPP_S ------- */
	PAD_NC(GPP_S0, NONE),	/* GPIO */
	PAD_NC(GPP_S1, NONE),	/* GPIO */
	PAD_NC(GPP_S2, NONE),	/* GPIO */
	PAD_NC(GPP_S3, NONE),	/* GPIO */
	PAD_NC(GPP_S4, NONE),	/* GPIO */
	PAD_NC(GPP_S5, NONE),	/* GPIO */
	PAD_NC(GPP_S6, NONE),	/* GPIO */
	PAD_NC(GPP_S7, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_I ------- */
	PAD_NC(GPP_I0, NONE),	/* GPIO */
	PAD_NC(GPP_I1, NONE),	/* GPIO */
	PAD_NC(GPP_I2, NONE),	/* GPIO */
	PAD_NC(GPP_I3, NONE),	/* GPIO */
	PAD_NC(GPP_I4, NONE),	/* GPIO */
	PAD_NC(GPP_I5, NONE),	/* GPIO */
	PAD_NC(GPP_I6, NONE),	/* GPIO */
	PAD_NC(GPP_I7, NONE),	/* GPIO */
	PAD_NC(GPP_I8, NONE),	/* GPIO */
	PAD_NC(GPP_I9, NONE),	/* GPIO */
	PAD_NC(GPP_I10, NONE),	/* GPIO */
	PAD_NC(GPP_I11, NONE),	/* GPIO */
	PAD_NC(GPP_I12, NONE),	/* GPIO */
	PAD_NC(GPP_I13, NONE),	/* GPIO */
	PAD_NC(GPP_I14, NONE),	/* GPIO */
	PAD_NC(GPP_I15, NONE),	/* GPIO */
	PAD_NC(GPP_I16, NONE),	/* GPIO */
	PAD_NC(GPP_I17, NONE),	/* GPIO */
	PAD_NC(GPP_I18, NONE),	/* GPIO */
	PAD_NC(GPP_I19, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_H ------- */
	PAD_CFG_GPO(GPP_H0, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H1, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_H2, 1, RSMRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_H3, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_IRQ_ROUTE(IOAPIC) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	PAD_NC(GPP_H4, NONE),	/* GPIO */
	PAD_NC(GPP_H5, NONE),	/* GPIO */
	PAD_NC(GPP_H6, NONE),	/* GPIO */
	PAD_NC(GPP_H7, NONE),	/* GPIO */
	PAD_NC(GPP_H8, NONE),	/* GPIO */
	PAD_NC(GPP_H9, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_H10, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_IOSSTATE(HIZCRx1) | PAD_IOSTERM(DISPUPD)),	/* UART0_RXD */
	_PAD_CFG_STRUCT(GPP_H11, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSTERM(DISPUPD)),	/* UART0_TXD */
	PAD_NC(GPP_H12, NONE),	/* GPIO */
	PAD_NC(GPP_H13, NONE),	/* GPIO */
	PAD_NC(GPP_H14, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_H15, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* DDPB_CTRLCLK */
	PAD_NC(GPP_H16, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_H17, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* DDPB_CTRLDATA */
	_PAD_CFG_STRUCT(GPP_H18, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* PROC_C10_GATE# */
	_PAD_CFG_STRUCT(GPP_H19, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SRCCLKREQ4# */
	PAD_NC(GPP_H20, NONE),	/* GPIO */
	PAD_NC(GPP_H21, NONE),	/* GPIO */
	PAD_NC(GPP_H22, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_H23, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SRCCLKREQ5# */

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),	/* GPIO */
	PAD_NC(GPP_D1, NONE),	/* GPIO */
	PAD_NC(GPP_D2, NONE),	/* GPIO */
	PAD_NC(GPP_D3, NONE),	/* GPIO */
	PAD_NC(GPP_D4, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_D5, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SRCCLKREQ0# */
	_PAD_CFG_STRUCT(GPP_D6, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SRCCLKREQ1# */
	_PAD_CFG_STRUCT(GPP_D7, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SRCCLKREQ2# */
	_PAD_CFG_STRUCT(GPP_D8, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SRCCLKREQ3# */
	_PAD_CFG_STRUCT(GPP_D9, PAD_FUNC(NF5) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE)),	/* BSSB_LS2_RX */
	_PAD_CFG_STRUCT(GPP_D10, PAD_FUNC(NF5) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), PAD_PULL(NATIVE)),	/* BSSB_LS2_TX */
	_PAD_CFG_STRUCT(GPP_D11, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_IRQ_ROUTE(SCI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_D12, PAD_FUNC(NF5) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), PAD_PULL(NATIVE)),	/* BSSB_LS3_TX */
	_PAD_CFG_STRUCT(GPP_D13, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_IRQ_ROUTE(SCI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_D14, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_IRQ_ROUTE(SCI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	PAD_NC(GPP_D15, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_D16, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_D17, NONE),	/* GPIO */
	PAD_NC(GPP_D18, NONE),	/* GPIO */
	PAD_NC(GPP_D19, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_GSPI2_CLK_LOOPBK, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* GPP_GSPI2_CLK_LOOPBK */

	/* ------- GPIO Group vGPIO ------- */
	PAD_CFG_GPO(GPP_VGPIO_0, 0, DEEP),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_VGPIO_4, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_VGPIO_5, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | (1 << 1) | 1, 0),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_VGPIO_6, PAD_FUNC(NF1) | PAD_RESET(DEEP) | (1 << 1), 0),	/* GPP_VGPIO_6 */
	PAD_CFG_NF(GPP_VGPIO_7, NONE, DEEP, NF1),	/* GPP_VGPIO_7 */
	PAD_CFG_NF(GPP_VGPIO_8, NONE, DEEP, NF1),	/* GPP_VGPIO_8 */
	_PAD_CFG_STRUCT(GPP_VGPIO_9, PAD_FUNC(NF1) | PAD_RESET(DEEP) | (1 << 1), 0),	/* GPP_VGPIO_9 */
	_PAD_CFG_STRUCT(GPP_VGPIO_10, PAD_FUNC(NF1) | PAD_RESET(DEEP) | (1 << 1), 0),	/* GPP_VGPIO_10 */
	PAD_CFG_NF(GPP_VGPIO_11, NONE, DEEP, NF1),	/* GPP_VGPIO_11 */
	PAD_CFG_NF(GPP_VGPIO_12, NONE, DEEP, NF1),	/* GPP_VGPIO_12 */
	_PAD_CFG_STRUCT(GPP_VGPIO_13, PAD_FUNC(NF1) | PAD_RESET(DEEP) | (1 << 1), 0),	/* GPP_VGPIO_13 */
	_PAD_CFG_STRUCT(GPP_VGPIO_18, PAD_FUNC(NF1) | PAD_RESET(DEEP) | (1 << 1), 0),	/* GPP_VGPIO_18 */
	PAD_CFG_NF(GPP_VGPIO_19, NONE, DEEP, NF1),	/* GPP_VGPIO_19 */
	PAD_CFG_NF(GPP_VGPIO_20, NONE, DEEP, NF1),	/* GPP_VGPIO_20 */
	PAD_CFG_NF(GPP_VGPIO_21, NONE, DEEP, NF1),	/* GPP_VGPIO_21 */
	_PAD_CFG_STRUCT(GPP_VGPIO_22, PAD_FUNC(NF1) | PAD_RESET(DEEP) | (1 << 1), 0),	/* GPP_VGPIO_22 */
	PAD_CFG_NF(GPP_VGPIO_23, NONE, DEEP, NF1),	/* GPP_VGPIO_23 */
	PAD_CFG_NF(GPP_VGPIO_24, NONE, DEEP, NF1),	/* GPP_VGPIO_24 */
	_PAD_CFG_STRUCT(GPP_VGPIO_25, PAD_FUNC(NF1) | PAD_RESET(DEEP) | (1 << 1), 0),	/* GPP_VGPIO_25 */
	PAD_CFG_NF(GPP_VGPIO_30, NONE, DEEP, NF1),	/* GPP_VGPIO_30 */
	PAD_CFG_NF(GPP_VGPIO_31, NONE, DEEP, NF1),	/* GPP_VGPIO_31 */
	PAD_CFG_NF(GPP_VGPIO_32, NONE, DEEP, NF1),	/* GPP_VGPIO_32 */
	PAD_CFG_NF(GPP_VGPIO_33, NONE, DEEP, NF1),	/* GPP_VGPIO_33 */
	PAD_CFG_NF(GPP_VGPIO_34, NONE, DEEP, NF1),	/* GPP_VGPIO_34 */
	PAD_CFG_NF(GPP_VGPIO_35, NONE, DEEP, NF1),	/* GPP_VGPIO_35 */
	PAD_CFG_NF(GPP_VGPIO_36, NONE, DEEP, NF1),	/* GPP_VGPIO_36 */
	PAD_CFG_NF(GPP_VGPIO_37, NONE, DEEP, NF1),	/* GPP_VGPIO_37 */

	/* ------- GPIO Community 2 ------- */

	/* ------- GPIO Group GPP_GPD ------- */
	_PAD_CFG_STRUCT(GPD0, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),	/* BATLOW# */
	_PAD_CFG_STRUCT(GPD1, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(NATIVE)),	/* ACPRESENT */
	_PAD_CFG_STRUCT(GPD2, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_IRQ_ROUTE(SCI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	_PAD_CFG_STRUCT(GPD3, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),	/* PWRBTN# */
	_PAD_CFG_STRUCT(GPD4, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),	/* SLP_S3# */
	_PAD_CFG_STRUCT(GPD5, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),	/* SLP_S4# */
	_PAD_CFG_STRUCT(GPD6, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),	/* SLP_A# */
	PAD_CFG_GPO(GPD7, 1, PLTRST),	/* GPIO */
	_PAD_CFG_STRUCT(GPD8, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* SUSCLK */
	_PAD_CFG_STRUCT(GPD9, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),	/* SLP_WLAN# */
	_PAD_CFG_STRUCT(GPD10, PAD_FUNC(NF1) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), 0),	/* SLP_S5# */
	PAD_CFG_GPO(GPD11, 0, PWROK),	/* GPIO */
	_PAD_CFG_STRUCT(GPD_INPUT3VSEL, PAD_FUNC(NF1) | PAD_BUF(TX_RX_DISABLE), 0),	/* GPD_INPUT3VSEL */
	_PAD_CFG_STRUCT(GPD_SLP_LANB, PAD_FUNC(NF1) | PAD_BUF(TX_RX_DISABLE), 0),	/* GPD_SLP_LANB */
	_PAD_CFG_STRUCT(GPD_SLP_SUSB, PAD_FUNC(NF1) | PAD_BUF(TX_RX_DISABLE), 0),	/* GPD_SLP_SUSB */
	_PAD_CFG_STRUCT(GPD_WAKEB, PAD_FUNC(NF1) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* GPD_WAKEB */
	_PAD_CFG_STRUCT(GPD_DRAM_RESETB, PAD_FUNC(NF1) | PAD_BUF(TX_RX_DISABLE), 0),	/* GPD_DRAM_RESETB */

	/* ------- GPIO Community 4 ------- */

	/* ------- GPIO Group GPP_C ------- */
	_PAD_CFG_STRUCT(GPP_C0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* SMBCLK */
	_PAD_CFG_STRUCT(GPP_C1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* SMBDATA */
	PAD_CFG_GPO(GPP_C2, 0, DEEP),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_C3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SML0CLK */
	_PAD_CFG_STRUCT(GPP_C4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SML0DATA */
	PAD_CFG_GPO(GPP_C5, 0, DEEP),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_C6, PAD_FUNC(NF1) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SML1CLK */
	_PAD_CFG_STRUCT(GPP_C7, PAD_FUNC(NF1) | PAD_RESET(RSMRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), 0),	/* SML1DATA */
	PAD_NC(GPP_C8, NONE),	/* GPIO */
	PAD_NC(GPP_C9, NONE),	/* GPIO */
	PAD_NC(GPP_C10, NONE),	/* GPIO */
	PAD_NC(GPP_C11, NONE),	/* GPIO */
	PAD_NC(GPP_C12, NONE),	/* GPIO */
	PAD_NC(GPP_C13, NONE),	/* GPIO */
	PAD_NC(GPP_C14, NONE),	/* GPIO */
	PAD_NC(GPP_C15, NONE),	/* GPIO */
	PAD_NC(GPP_C16, NONE),	/* GPIO */
	PAD_NC(GPP_C17, NONE),	/* GPIO */
	PAD_NC(GPP_C18, NONE),	/* GPIO */
	PAD_NC(GPP_C19, NONE),	/* GPIO */
	PAD_NC(GPP_C20, NONE),	/* GPIO */
	PAD_NC(GPP_C21, NONE),	/* GPIO */
	PAD_NC(GPP_C22, NONE),	/* GPIO */
	PAD_NC(GPP_C23, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_F ------- */
	_PAD_CFG_STRUCT(GPP_F0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CNV_BRI_DT */
	_PAD_CFG_STRUCT(GPP_F1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),	/* CNV_BRI_RSP */
	_PAD_CFG_STRUCT(GPP_F2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CNV_RGI_DT */
	_PAD_CFG_STRUCT(GPP_F3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_PULL(UP_20K)),	/* CNV_RGI_RSP */
	_PAD_CFG_STRUCT(GPP_F4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* CNV_RF_RESET# */
	_PAD_CFG_STRUCT(GPP_F5, PAD_FUNC(NF2) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* MODEM_CLKREQ */
	PAD_NC(GPP_F6, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_F7, 0, DEEP),	/* GPIO */
	PAD_NC(GPP_F8, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_F9, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* BOOTMPC */
	PAD_CFG_GPO(GPP_F10, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_F11, NONE),	/* GPIO */
	PAD_NC(GPP_F12, NONE),	/* GPIO */
	PAD_NC(GPP_F13, NONE),	/* GPIO */
	PAD_NC(GPP_F14, NONE),	/* GPIO */
	PAD_NC(GPP_F15, NONE),	/* GPIO */
	PAD_NC(GPP_F16, NONE),	/* GPIO */
	PAD_NC(GPP_F17, NONE),	/* GPIO */
	PAD_NC(GPP_F18, NONE),	/* GPIO */
	PAD_NC(GPP_F19, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_F20, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* Reserved */
	_PAD_CFG_STRUCT(GPP_F21, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* Reserved */
	PAD_NC(GPP_F22, NONE),	/* GPIO */
	PAD_NC(GPP_F23, NONE),	/* GPIO */
	PAD_NC(GPP_F_CLK_LOOPBK, NONE),	/* GPIO */

	/* ------- GPIO Group GPP_HVCMOS ------- */
	_PAD_CFG_STRUCT(GPP_L_BKLTEN, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* n/a */
	_PAD_CFG_STRUCT(GPP_L_BKLTCTL, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* n/a */
	_PAD_CFG_STRUCT(GPP_L_VDDEN, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* n/a */
	_PAD_CFG_STRUCT(GPP_SYS_PWROK, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* n/a */
	_PAD_CFG_STRUCT(GPP_SYS_RESETB, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* n/a */
	_PAD_CFG_STRUCT(GPP_MLK_RSTB, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_BUF(TX_RX_DISABLE), 0),	/* n/a */

	/* ------- GPIO Group GPP_E ------- */
	_PAD_CFG_STRUCT(GPP_E0, PAD_FUNC(GPIO) | PAD_RESET(DEEP) | PAD_IRQ_ROUTE(SCI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	PAD_NC(GPP_E1, NONE),	/* GPIO */
	PAD_NC(GPP_E2, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_E3, 1, DEEP),	/* GPIO */
	PAD_CFG_GPO(GPP_E4, 1, PLTRST),	/* GPIO */
	PAD_NC(GPP_E5, NONE),	/* GPIO */
	PAD_CFG_GPO(GPP_E6, 0, DEEP),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_E7, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_IRQ_ROUTE(SMI) | PAD_RX_POL(INVERT) | PAD_BUF(TX_DISABLE) | (1 << 1), 0),	/* GPIO */
	PAD_NC(GPP_E8, NONE),	/* GPIO */
	PAD_NC(GPP_E9, NONE),	/* GPIO */
	PAD_NC(GPP_E10, NONE),	/* GPIO */
	PAD_NC(GPP_E11, NONE),	/* GPIO */
	PAD_NC(GPP_E12, NONE),	/* GPIO */
	PAD_NC(GPP_E13, NONE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_E14, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(TxDRxE)),	/* DDSP_HPDA */
	PAD_CFG_GPO(GPP_E15, 1, PLTRST),	/* GPIO */
	PAD_CFG_GPO(GPP_E16, 0, PLTRST),	/* GPIO */
	PAD_NC(GPP_E17, NONE),	/* GPIO */
	PAD_NC(GPP_E18, NATIVE),	/* GPIO */
	PAD_NC(GPP_E19, NATIVE),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_E20, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE) | 1, 0),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_E21, PAD_FUNC(GPIO) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), 0),	/* GPIO */
	_PAD_CFG_STRUCT(GPP_E22, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* DDPA_CTRLCLK */
	_PAD_CFG_STRUCT(GPP_E23, PAD_FUNC(NF1) | PAD_RESET(PLTRST) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE) | (1 << 1), PAD_IOSSTATE(IGNORE)),	/* DDPA_CTRLDATA */
	PAD_NC(GPP_E_CLK_LOOPBK, NONE),	/* GPIO */

	/* ------- GPIO Community 5 ------- */

	/* ------- GPIO Group GPP_R ------- */
	_PAD_CFG_STRUCT(GPP_R0, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* HDA_BCLK */
	_PAD_CFG_STRUCT(GPP_R1, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE) | PAD_IOSSTATE(IGNORE)),	/* HDA_SYNC */
	_PAD_CFG_STRUCT(GPP_R2, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(RX_DISABLE), PAD_PULL(NATIVE) | PAD_IOSSTATE(IGNORE)),	/* HDA_SDO */
	_PAD_CFG_STRUCT(GPP_R3, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_PULL(NATIVE) | PAD_IOSSTATE(IGNORE)),	/* HDA_SDI0 */
	_PAD_CFG_STRUCT(GPP_R4, PAD_FUNC(NF1) | PAD_RESET(DEEP) | PAD_TRIG(OFF) | PAD_BUF(TX_RX_DISABLE), PAD_IOSSTATE(IGNORE)),	/* HDA_RST# */
	PAD_NC(GPP_R5, NONE),	/* GPIO */
	PAD_NC(GPP_R6, NONE),	/* GPIO */
	PAD_NC(GPP_R7, NONE),	/* GPIO */
};

#endif /* CFG_GPIO_H */
