#!/bin/sh
#
# set_version.sh
#
progpath="$0"
prog=`basename -- "$0"`
prognoext=`echo "$prog" | sed 's/\..*//;'`
progpathfull=`realpath -e "$progpath" 2>/dev/null`
[ -n "$progpathfull" ] && progdir=`dirname "$progpathfull"`
[ -z "$progpathfull" ] && progdir=`dirname "$progpath"`

verbose="no"
debug="no"
NewVer=""
CurVer=""


sed_i () {
	DebugMsg "sed_i($#)" "$@"
	[ $# -ge 2 ] || return 1

	sed_expr="$1"; shift
	sed_f=""
	sed_i_n=0

	for sed_f in "$@"
	do
		[ ${sed_i_n:-0} -gt 0 ] && DebugMsg ""
		if [ -e "$sed_f" ] ; then
			sed_i_n=`expr $sed_i_n + 1`
			! sed "$sed_expr" "$sed_f" > "$sed_f.NEW" && continue
			if cmp "$sed_f" "$sed_f.NEW" >/dev/null 2>/dev/null; then
				DebugMsg "$sed_f: no changes"
				/bin/rm "$sed_f.NEW"
			else
				# Something changed, the files are now different
				DebugMsg "$sed_f: changed"
				[ "$debug" = "yes" ] && /bin/ls -ld "$sed_f" "$sed_f.NEW"
				[ "$debug" = "yes" ] && diff -wu "$sed_f" "$sed_f.NEW"
				! cat "$sed_f.NEW" > "$sed_f" && continue
				! /bin/rm "$sed_f.NEW" && continue
				VerboseMsg "$sed_f: changed"
			fi
		fi
	done
}	# sed_i




SetVersion () {
	DebugMsg "SetVersion" "$@"

	cd .. || Usage "Can't get PWD"
	[ ! -e "ncftp/version.c" ] && Usage "Missing ./ncftp/version.c -- are you in the right place?"

	CurVer=`sed -n '/gVersion/{s/^.*gVersion.*NcFTP.//;s%/.*%%;p;q;}' "ncftp/version.c"`
	DebugMsg "CurVer=[$CurVer]"
	[ -z "$CurVer" ] && ErrExit "Cannot determine current version from ncftp/version.c."
	[ -z "$NewVer" ] && Usage

	CurVerRE=`echo "$CurVer" | sed "s/\./\\\\\\\\./g;"`
	DebugMsg "CurVerRE=[$CurVerRE]"

	LIBdt=`date '+%B %-d, %Y'`
	CLIdt=`date '+%B %-d %Y'`

	sed_i "s/$CurVerRE/$NewVer/g;" "Makefile" "libncftp/Makefile" "config.status"
	sed_i "s/LibNcFTP $CurVerRE [(][^()]*[)]/LibNcFTP $NewVer ($LIBdt)/;s/LibNcFTP $CurVerRE/LibNcFTP $NewVer/g;" "libncftp/ncftp.h"
	sed_i "s/$CurVerRE/$NewVer/g;" "ncftp/version.c"	# Does not change date; recompile to update

	return 0
}	# SetVersion



Usage () {
	if [ $# -gt 0 ] ; then echo "$@" 1>&2 ; echo "" 1>&2 ; fi
	echo "Usage: ${prog-program} [options] NEW.VER.SION" 1>&2
	echo "" 1>&2
	echo "Options:" 1>&2
	echo "  --verbose" 1>&2
	echo "  --debug" 1>&2
	exit 2
}	# Usage



ProcessCommandLineArguments () {
	doneargs="no"
	xshifts=""
	while [ "$doneargs" = "no" ] ; do
		case "$1" in
			"--user"*=*)
				user=`echo "$1" | cut -d = -f 2-`
				shift; if [ $# -le 0 ] ; then doneargs="yes" ; fi
				xshifts="$xshifts a"
				;;
			"--host"*=*)
				h=`echo "$1" | sed 's/^--[^=]*=//;s/,/ /g;'`
				shift; if [ $# -le 0 ] ; then doneargs="yes" ; fi
				xshifts="$xshifts a"
				;;
			"--no"*"dry"*"run"|"-N")
				dryrun="no"
				shift; if [ $# -le 0 ] ; then doneargs="yes" ; fi
				xshifts="$xshifts a"
				;;
			"--dry"*"run"|"-n")
				dryrun="yes"
				shift; if [ $# -le 0 ] ; then doneargs="yes" ; fi
				xshifts="$xshifts a"
				;;
			"--verbose"|"-v")
				verbose="yes"
				shift; if [ $# -le 0 ] ; then doneargs="yes" ; fi
				xshifts="$xshifts a"
				;;
			"--debug"|"-d")
				debug="yes"; verbose="yes"
				shift; if [ $# -le 0 ] ; then doneargs="yes" ; fi
				xshifts="$xshifts a"
				;;
			"--")
				shift; if [ $# -le 0 ] ; then doneargs="yes" ; fi
				doneargs="yes"
				xshifts="$xshifts a"
				;;
			"--help"|"-h"|"-help") Usage ;;
			"-"*) Usage "Unknown option, $1." ;;
			*) doneargs="yes" ;;
		esac
	done
	unset doneargs
}	# ProcessCommandLineArguments




Main () {
	ProcessCommandLineArguments "$@"

	# We need to do this because ProcessCommandLineArguments can't save the changes to $@.
	if [ -n "$xshifts" ] ; then
		for arg in $xshifts; do shift; done
	fi

	cdToProgDir "$0" || ErrExit "Could not change directory to the location of this program ($0)"

	[ $# -gt 0 ] || Usage "Specify a new version."
	NewVer="$1"

	# Print out the parameters we collected for debugging.
	DebugMsg "verbose=$verbose" "debug=$debug" "dryrun=$dryrun" "env_file=$env_file" "NewVer=[$NewVer]"

	SetVersion "$@"
	my_exit_status=$?
}	# Main

##### Nothing else should need to be changed beyond here:



ErrExit () {
	if [ $# -gt 0 ] ; then echo "$@" 1>&2 ; fi
	exit 1
}	# ErrExit




VerboseMsg () {
	[ "$verbose" = "yes" ] && echo "$@" && return 0
	return 1
}	# VerboseMsg




DebugMsg () {
	[ "$debug" = "yes" ] && echo "#DBG#" "$@" 1>&2 && return 0
	return 1
}	# DebugMsg




ErrorMsg () {
	echo "#!# ERROR:" "$@" 1>&2
}	# ErrorMsg 




cdToProgDir () {
	local pardir=""
	local pardira=""
	local progpath="$1"
	local cwdP=""
	local prog=`basename "$progpath"`

	DebugMsg "cdToProgDir" "$@"
	cwdP=`pwd -P` 2>/dev/null
	[ -z "$cwdP" ] && cwdP=`pwd`
	cd "$cwdP" || exit 1

	case "$progpath" in
		"")
			ErrorMsg "Usage: cdToProgDir \"\$0\""
			return 2
			;;
		/*)
			;;
		*)
			if [ -f "$prog" ] ; then
				pardir="."
			else
				f=`which "$prog" 2>/dev/null`
				if [ -n "$f" ] ; then
					pardir=`dirname "$f"`
				fi
				unset f
			fi
			;;
	esac

	if [ -n "$pardir" ] ; then
		if ! cd "$pardir" ; then ErrorMsg "Could not cd $pardir" ; return 1 ; fi
		pardir=`pwd`
	else
		pardir=`dirname "$progpath"`
		pardira=`readlink -e "$pardir" 2>/dev/null`
		if [ -d "$pardira" ] ; then
			if ! cd "$pardira" ; then ErrorMsg "Could not cd $pardira" ; return 1 ; fi
		elif [ -d "$pardir" ] ; then
			if ! cd "$pardir" ; then ErrorMsg "Could not cd $pardir" ; return 1 ; fi
			pardira=`pwd -P 2>/dev/null`
		fi
	fi
	return 0
}	# cdToProgDir




Main "$@"
exit ${my_exit_status-1}
