# auto-generated by “generate-chinese-variants.py”, do not edit here!
#
# Copyright (c) 2013 Mike FABIAN <mfabian@redhat.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 3.0 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
Module to check whether characters are used in simplified Chinese, traditional Chinese
or used in both.
'''

# pylint: disable=too-many-lines

VARIANTS_TABLE = {
    # Meaning of the bits in the values:
    # 1 = 1 << 0       simplified Chinese
    # 2 = 1 << 1       traditional Chinese
    # 3 = (1 | 1 << 1) used both in simplified *and* traditional Chinese
    # 4 = 1 << 2       mixture of simplified and traditional Chinese
    '〇': 3,
    '㐷': 1,
    '㐹': 1,
    '㐽': 1,
    '㑇': 1,
    '㑈': 1,
    '㑔': 1,
    '㑩': 1,
    '㑮': 2,
    '㑯': 2,
    '㑳': 2,
    '㑶': 2,
    '㑺': 1,
    '㒓': 2,
    '㒖': 2,
    '㒜': 2,
    '㒣': 2,
    '㒿': 2,
    '㓄': 2,
    '㓖': 2,
    '㓥': 1,
    '㓨': 2,
    '㔃': 2,
    '㔅': 2,
    '㔉': 1,
    '㔋': 2,
    '㔝': 2,
    '㔢': 2,
    '㕒': 2,
    '㕢': 2,
    '㖊': 1,
    '㖞': 1,
    '㖦': 2,
    '㖮': 2,
    '㗙': 2,
    '㗢': 2,
    '㗣': 2,
    '㗰': 2,
    '㗲': 2,
    '㗶': 2,
    '㗻': 2,
    '㗼': 2,
    '㗿': 2,
    '㘎': 1,
    '㘓': 2,
    '㘔': 2,
    '㘖': 2,
    '㘙': 2,
    '㘚': 2,
    '㘤': 2,
    '㙔': 2,
    '㙡': 2,
    '㙢': 2,
    '㙬': 2,
    '㙺': 2,
    '㙾': 2,
    '㚯': 1,
    '㛀': 1,
    '㛍': 2,
    '㛝': 2,
    '㛟': 1,
    '㛠': 1,
    '㛣': 1,
    '㛤': 1,
    '㛿': 1,
    '㜄': 2,
    '㜏': 2,
    '㜐': 2,
    '㜕': 2,
    '㜗': 2,
    '㜞': 2,
    '㜢': 2,
    '㜥': 2,
    '㜭': 2,
    '㜮': 2,
    '㜰': 2,
    '㜷': 2,
    '㜺': 2,
    '㝞': 2,
    '㝟': 2,
    '㝦': 1,
    '㞞': 2,
    '㟆': 1,
    '㟜': 1,
    '㟥': 1,
    '㟦': 2,
    '㟺': 2,
    '㠁': 2,
    '㠆': 2,
    '㠏': 2,
    '㠠': 2,
    '㠣': 2,
    '㡎': 1,
    '㡓': 2,
    '㡞': 2,
    '㢗': 2,
    '㢝': 2,
    '㤖': 1,
    '㤘': 1,
    '㤭': 1,
    '㤲': 2,
    '㤽': 1,
    '㥪': 1,
    '㥮': 2,
    '㥷': 2,
    '㦈': 1,
    '㦊': 2,
    '㦎': 2,
    '㦖': 2,
    '㦛': 2,
    '㦞': 2,
    '㦡': 2,
    '㦦': 2,
    '㦬': 2,
    '㦭': 2,
    '㧏': 1,
    '㧐': 1,
    '㧑': 1,
    '㧛': 1,
    '㧟': 1,
    '㧰': 1,
    '㨛': 2,
    '㨟': 2,
    '㨥': 2,
    '㨫': 1,
    '㨻': 2,
    '㩇': 2,
    '㩋': 2,
    '㩌': 2,
    '㩜': 2,
    '㩣': 2,
    '㩭': 2,
    '㩳': 2,
    '㩵': 2,
    '㩷': 2,
    '㩹': 2,
    '㪎': 2,
    '㪹': 2,
    '㬢': 2,
    '㬣': 2,
    '㬮': 2,
    '㭎': 1,
    '㭏': 1,
    '㭣': 1,
    '㭤': 1,
    '㭴': 1,
    '㮓': 2,
    '㮝': 2,
    '㮠': 1,
    '㮲': 2,
    '㮿': 2,
    '㯂': 2,
    '㯆': 2,
    '㯤': 2,
    '㯸': 2,
    '㯼': 2,
    '㰂': 2,
    '㰄': 2,
    '㰅': 2,
    '㰍': 2,
    '㰰': 2,
    '㰳': 2,
    '㱩': 1,
    '㱮': 1,
    '㲯': 2,
    '㲰': 2,
    '㲲': 2,
    '㲿': 1,
    '㳔': 1,
    '㳕': 1,
    '㳠': 1,
    '㳡': 1,
    '㳢': 1,
    '㳽': 3,
    '㴋': 1,
    '㴸': 2,
    '㴿': 2,
    '㵍': 2,
    '㵑': 2,
    '㵒': 2,
    '㵗': 2,
    '㵤': 2,
    '㵾': 2,
    '㶆': 2,
    '㶉': 1,
    '㶌': 2,
    '㶍': 2,
    '㶏': 2,
    '㶒': 2,
    '㶕': 2,
    '㶶': 1,
    '㶽': 1,
    '㷃': 2,
    '㷍': 2,
    '㷪': 1,
    '㷲': 2,
    '㷶': 2,
    '㷻': 2,
    '㷿': 2,
    '㸅': 2,
    '㸊': 2,
    '㸐': 2,
    '㹓': 2,
    '㹽': 2,
    '㺍': 1,
    '㺏': 2,
    '㺑': 2,
    '㺜': 2,
    '㻅': 1,
    '㻏': 1,
    '㻘': 1,
    '㻪': 1,
    '㻶': 2,
    '㻽': 2,
    '㼀': 2,
    '㼁': 2,
    '㼆': 2,
    '㼈': 2,
    '㼻': 2,
    '㾡': 1,
    '㾵': 2,
    '㾺': 2,
    '㿉': 2,
    '㿎': 2,
    '㿖': 2,
    '㿗': 2,
    '㿧': 2,
    '㿹': 2,
    '䀉': 2,
    '䀍': 2,
    '䀥': 1,
    '䀴': 2,
    '䀹': 2,
    '䁖': 1,
    '䁝': 2,
    '䁪': 2,
    '䁱': 2,
    '䁻': 2,
    '䂎': 2,
    '䂓': 2,
    '䂵': 1,
    '䃁': 2,
    '䃅': 1,
    '䃕': 2,
    '䃘': 2,
    '䃢': 2,
    '䃣': 2,
    '䃤': 2,
    '䃮': 2,
    '䃴': 2,
    '䅉': 1,
    '䅐': 2,
    '䅘': 2,
    '䅟': 1,
    '䅪': 1,
    '䅳': 2,
    '䆅': 2,
    '䆉': 2,
    '䇓': 2,
    '䇚': 1,
    '䇲': 1,
    '䉆': 2,
    '䉍': 2,
    '䉐': 2,
    '䉑': 2,
    '䉙': 2,
    '䉤': 1,
    '䉬': 2,
    '䉱': 2,
    '䉲': 2,
    '䉶': 2,
    '䊜': 2,
    '䊟': 2,
    '䊭': 2,
    '䊲': 2,
    '䊵': 2,
    '䊷': 2,
    '䊺': 2,
    '䋃': 2,
    '䋆': 2,
    '䋍': 2,
    '䋎': 2,
    '䋏': 2,
    '䋐': 2,
    '䋑': 2,
    '䋔': 2,
    '䋙': 2,
    '䋚': 2,
    '䋦': 2,
    '䋫': 2,
    '䋹': 2,
    '䋺': 2,
    '䋻': 2,
    '䋼': 2,
    '䋽': 2,
    '䋾': 2,
    '䋿': 2,
    '䌁': 2,
    '䌇': 2,
    '䌈': 2,
    '䌋': 2,
    '䌌': 2,
    '䌐': 2,
    '䌖': 2,
    '䌝': 2,
    '䌞': 2,
    '䌟': 2,
    '䌥': 2,
    '䌪': 2,
    '䌰': 2,
    '䌶': 1,
    '䌷': 1,
    '䌸': 1,
    '䌹': 1,
    '䌺': 1,
    '䌻': 1,
    '䌼': 1,
    '䌽': 1,
    '䌾': 1,
    '䌿': 1,
    '䍀': 1,
    '䍁': 1,
    '䍤': 2,
    '䍷': 2,
    '䍽': 2,
    '䎘': 2,
    '䎙': 2,
    '䎬': 1,
    '䎱': 2,
    '䏊': 2,
    '䏝': 1,
    '䐢': 2,
    '䐣': 2,
    '䐪': 1,
    '䐷': 2,
    '䐹': 2,
    '䐽': 2,
    '䑗': 2,
    '䑼': 2,
    '䒿': 1,
    '䓓': 1,
    '䓕': 1,
    '䓖': 1,
    '䓣': 2,
    '䓨': 1,
    '䔇': 2,
    '䔈': 2,
    '䔡': 2,
    '䕏': 2,
    '䕡': 2,
    '䕤': 2,
    '䕳': 2,
    '䕹': 2,
    '䕼': 2,
    '䖀': 2,
    '䖅': 2,
    '䖚': 2,
    '䖼': 1,
    '䗃': 2,
    '䗅': 2,
    '䗖': 1,
    '䗥': 2,
    '䗻': 2,
    '䗽': 2,
    '䗿': 2,
    '䘛': 1,
    '䘞': 1,
    '䙊': 1,
    '䙌': 1,
    '䙓': 1,
    '䙔': 2,
    '䙡': 2,
    '䙱': 2,
    '䙼': 2,
    '䚆': 2,
    '䚉': 2,
    '䚕': 2,
    '䚞': 2,
    '䚩': 2,
    '䚳': 2,
    '䚵': 2,
    '䚽': 2,
    '䛀': 2,
    '䛄': 2,
    '䛌': 2,
    '䛍': 2,
    '䛓': 1,
    '䛘': 2,
    '䛛': 2,
    '䛞': 2,
    '䛠': 2,
    '䛤': 2,
    '䛬': 2,
    '䛭': 2,
    '䛳': 2,
    '䛴': 2,
    '䛽': 2,
    '䛿': 2,
    '䜀': 2,
    '䜄': 2,
    '䜉': 2,
    '䜋': 2,
    '䜍': 2,
    '䜎': 2,
    '䜏': 2,
    '䜒': 2,
    '䜖': 2,
    '䜚': 2,
    '䜝': 2,
    '䜣': 1,
    '䜤': 1,
    '䜥': 1,
    '䜧': 1,
    '䜩': 1,
    '䝏': 2,
    '䝕': 2,
    '䝙': 1,
    '䝭': 2,
    '䝯': 2,
    '䝻': 2,
    '䝼': 2,
    '䞀': 2,
    '䞁': 2,
    '䞂': 2,
    '䞈': 2,
    '䞉': 2,
    '䞋': 2,
    '䞌': 1,
    '䞍': 1,
    '䞎': 1,
    '䞐': 1,
    '䞓': 2,
    '䟃': 2,
    '䟆': 2,
    '䟏': 2,
    '䟐': 2,
    '䟢': 1,
    '䟺': 2,
    '䠆': 2,
    '䠟': 2,
    '䠠': 2,
    '䠩': 2,
    '䠮': 2,
    '䠱': 2,
    '䡁': 2,
    '䡄': 2,
    '䡅': 2,
    '䡇': 2,
    '䡊': 2,
    '䡐': 2,
    '䡗': 2,
    '䡘': 2,
    '䡝': 2,
    '䡟': 2,
    '䡦': 2,
    '䡩': 2,
    '䡰': 2,
    '䡴': 2,
    '䡵': 2,
    '䡶': 2,
    '䡷': 2,
    '䡻': 2,
    '䡾': 2,
    '䢀': 1,
    '䢁': 1,
    '䢂': 1,
    '䢈': 2,
    '䢨': 2,
    '䤌': 2,
    '䤍': 2,
    '䤠': 2,
    '䤤': 2,
    '䤥': 2,
    '䤨': 2,
    '䤩': 2,
    '䤪': 2,
    '䤬': 2,
    '䤭': 2,
    '䤵': 2,
    '䤸': 2,
    '䤻': 2,
    '䤼': 2,
    '䥄': 2,
    '䥇': 2,
    '䥑': 2,
    '䥓': 2,
    '䥕': 2,
    '䥖': 2,
    '䥗': 2,
    '䥛': 2,
    '䥝': 2,
    '䥞': 2,
    '䥩': 2,
    '䥯': 2,
    '䥱': 2,
    '䥴': 2,
    '䥶': 2,
    '䥷': 2,
    '䥸': 2,
    '䥺': 1,
    '䥽': 1,
    '䥾': 1,
    '䥿': 1,
    '䦀': 1,
    '䦁': 1,
    '䦂': 1,
    '䦃': 1,
    '䦅': 1,
    '䦆': 1,
    '䦌': 2,
    '䦎': 2,
    '䦖': 2,
    '䦘': 2,
    '䦛': 2,
    '䦝': 2,
    '䦟': 2,
    '䦣': 2,
    '䦪': 2,
    '䦯': 2,
    '䦱': 2,
    '䦳': 2,
    '䦶': 1,
    '䦷': 1,
    '䧞': 2,
    '䧢': 2,
    '䨴': 2,
    '䩄': 1,
    '䩤': 2,
    '䩫': 2,
    '䪊': 2,
    '䪍': 2,
    '䪏': 2,
    '䪐': 2,
    '䪓': 2,
    '䪗': 2,
    '䪘': 2,
    '䪜': 2,
    '䪝': 2,
    '䪥': 2,
    '䪴': 2,
    '䪼': 2,
    '䪾': 2,
    '䫀': 2,
    '䫂': 2,
    '䫈': 2,
    '䫉': 2,
    '䫌': 2,
    '䫏': 2,
    '䫐': 2,
    '䫜': 2,
    '䫟': 2,
    '䫠': 2,
    '䫥': 2,
    '䫩': 2,
    '䫴': 2,
    '䫶': 2,
    '䫻': 2,
    '䫼': 2,
    '䫾': 2,
    '䬀': 2,
    '䬂': 2,
    '䬅': 2,
    '䬍': 2,
    '䬎': 2,
    '䬐': 2,
    '䬓': 2,
    '䬔': 2,
    '䬘': 2,
    '䬝': 2,
    '䬞': 2,
    '䬟': 2,
    '䬣': 2,
    '䬧': 2,
    '䬪': 2,
    '䬫': 2,
    '䬬': 2,
    '䬯': 2,
    '䬲': 2,
    '䬳': 2,
    '䬶': 2,
    '䬹': 2,
    '䬾': 2,
    '䭀': 2,
    '䭃': 2,
    '䭅': 2,
    '䭇': 2,
    '䭈': 2,
    '䭉': 2,
    '䭑': 2,
    '䭒': 2,
    '䭓': 2,
    '䭔': 2,
    '䭕': 2,
    '䭘': 2,
    '䭞': 2,
    '䭡': 2,
    '䭢': 2,
    '䭣': 2,
    '䭪': 1,
    '䭭': 2,
    '䭿': 2,
    '䮂': 2,
    '䮄': 2,
    '䮈': 2,
    '䮗': 2,
    '䮝': 2,
    '䮞': 2,
    '䮠': 2,
    '䮧': 2,
    '䮫': 2,
    '䮰': 2,
    '䮲': 2,
    '䮳': 2,
    '䮸': 2,
    '䮽': 2,
    '䮾': 2,
    '䮿': 2,
    '䯀': 2,
    '䯃': 1,
    '䯄': 1,
    '䯅': 1,
    '䯤': 2,
    '䰎': 2,
    '䰐': 2,
    '䰖': 2,
    '䰫': 2,
    '䰲': 2,
    '䰷': 2,
    '䰻': 2,
    '䰽': 2,
    '䰾': 2,
    '䱀': 2,
    '䱁': 2,
    '䱂': 2,
    '䱅': 2,
    '䱇': 2,
    '䱌': 2,
    '䱍': 2,
    '䱎': 2,
    '䱐': 2,
    '䱒': 2,
    '䱓': 2,
    '䱗': 2,
    '䱙': 2,
    '䱚': 2,
    '䱛': 2,
    '䱜': 2,
    '䱟': 2,
    '䱡': 2,
    '䱤': 2,
    '䱥': 2,
    '䱧': 2,
    '䱬': 2,
    '䱭': 2,
    '䱰': 2,
    '䱱': 2,
    '䱴': 2,
    '䱵': 2,
    '䱷': 2,
    '䱸': 2,
    '䱹': 2,
    '䱻': 2,
    '䱽': 2,
    '䱾': 2,
    '䲁': 2,
    '䲅': 2,
    '䲉': 2,
    '䲏': 2,
    '䲕': 2,
    '䲖': 2,
    '䲗': 2,
    '䲘': 2,
    '䲙': 2,
    '䲚': 2,
    '䲛': 2,
    '䲝': 1,
    '䲞': 1,
    '䲟': 1,
    '䲠': 1,
    '䲡': 1,
    '䲢': 1,
    '䲣': 1,
    '䲤': 1,
    '䲨': 2,
    '䲰': 2,
    '䲸': 2,
    '䲹': 2,
    '䲼': 2,
    '䳅': 2,
    '䳇': 2,
    '䳍': 2,
    '䳏': 2,
    '䳒': 2,
    '䳓': 2,
    '䳕': 2,
    '䳚': 2,
    '䳜': 2,
    '䳟': 2,
    '䳢': 2,
    '䳤': 2,
    '䳥': 2,
    '䳧': 2,
    '䳨': 2,
    '䳫': 2,
    '䳭': 2,
    '䳮': 2,
    '䳲': 2,
    '䳺': 2,
    '䳽': 2,
    '䴇': 2,
    '䴈': 2,
    '䴉': 2,
    '䴋': 2,
    '䴏': 2,
    '䴓': 1,
    '䴔': 1,
    '䴕': 1,
    '䴖': 1,
    '䴗': 1,
    '䴘': 1,
    '䴙': 1,
    '䴚': 2,
    '䴝': 2,
    '䴬': 2,
    '䴭': 2,
    '䴮': 2,
    '䴱': 2,
    '䴲': 2,
    '䴳': 2,
    '䴴': 2,
    '䴵': 2,
    '䴷': 2,
    '䴸': 2,
    '䴹': 2,
    '䴺': 2,
    '䴽': 2,
    '䵂': 2,
    '䵃': 2,
    '䵆': 2,
    '䵐': 2,
    '䵘': 2,
    '䵳': 2,
    '䵴': 2,
    '䵶': 2,
    '䵷': 2,
    '䶕': 2,
    '䶗': 2,
    '䶢': 2,
    '䶣': 2,
    '䶦': 2,
    '䶧': 2,
    '䶨': 2,
    '䶪': 2,
    '䶮': 1,
    '䶱': 2,
    '䶲': 2,
    '万': 3,
    '与': 1,
    '丑': 3,
    '专': 1,
    '业': 1,
    '丛': 1,
    '东': 1,
    '丝': 1,
    '丟': 2,
    '丢': 3,
    '两': 3,
    '严': 1,
    '並': 2,
    '丧': 1,
    '个': 3,
    '丰': 3,
    '临': 1,
    '为': 1,
    '丽': 1,
    '举': 1,
    '么': 3,
    '义': 3,
    '乌': 1,
    '乐': 3,
    '乔': 3,
    '习': 1,
    '乡': 1,
    '书': 1,
    '买': 1,
    '乱': 3,
    '乾': 3,
    '亂': 2,
    '了': 3,
    '争': 3,
    '于': 3,
    '亏': 3,
    '云': 3,
    '亚': 1,
    '亞': 2,
    '产': 1,
    '亩': 1,
    '亲': 1,
    '亵': 1,
    '亸': 1,
    '亿': 1,
    '仅': 3,
    '仆': 3,
    '从': 3,
    '仑': 1,
    '仓': 1,
    '仪': 3,
    '们': 1,
    '价': 3,
    '众': 3,
    '优': 3,
    '伙': 3,
    '会': 3,
    '伛': 1,
    '伞': 1,
    '伟': 1,
    '传': 1,
    '伡': 1,
    '伣': 1,
    '伤': 3,
    '伥': 1,
    '伦': 1,
    '伧': 1,
    '伪': 1,
    '伫': 1,
    '佇': 2,
    '体': 3,
    '余': 3,
    '佣': 3,
    '佥': 1,
    '併': 2,
    '來': 2,
    '侖': 2,
    '侠': 3,
    '侣': 1,
    '侥': 1,
    '侦': 1,
    '侧': 1,
    '侨': 1,
    '侩': 3,
    '侪': 1,
    '侬': 1,
    '侶': 2,
    '俁': 2,
    '係': 2,
    '俓': 2,
    '俔': 2,
    '俠': 2,
    '俣': 1,
    '俥': 2,
    '俦': 3,
    '俨': 1,
    '俩': 1,
    '俪': 1,
    '俫': 1,
    '俭': 1,
    '倀': 2,
    '倆': 2,
    '倈': 2,
    '倉': 2,
    '個': 2,
    '們': 2,
    '借': 3,
    '倫': 2,
    '倲': 2,
    '债': 1,
    '倾': 1,
    '偉': 2,
    '偑': 2,
    '偩': 2,
    '偬': 3,
    '側': 2,
    '偵': 2,
    '偻': 3,
    '偽': 2,
    '偾': 1,
    '偿': 1,
    '傌': 2,
    '傑': 2,
    '傖': 2,
    '傘': 2,
    '備': 2,
    '傢': 2,
    '傥': 1,
    '傧': 1,
    '储': 1,
    '傩': 1,
    '傪': 2,
    '傭': 2,
    '傯': 2,
    '傱': 2,
    '傳': 2,
    '傴': 2,
    '債': 2,
    '傷': 2,
    '傾': 2,
    '僀': 2,
    '僂': 2,
    '僅': 2,
    '僆': 2,
    '僉': 2,
    '働': 2,
    '僑': 2,
    '僓': 2,
    '僕': 2,
    '僗': 2,
    '僞': 2,
    '僤': 2,
    '僥': 2,
    '僨': 2,
    '僩': 2,
    '僴': 2,
    '價': 2,
    '僾': 2,
    '儀': 2,
    '儁': 2,
    '儂': 2,
    '億': 2,
    '儅': 2,
    '儈': 2,
    '儉': 2,
    '儐': 2,
    '儔': 2,
    '儕': 2,
    '儖': 2,
    '儘': 2,
    '償': 2,
    '儢': 2,
    '儣': 2,
    '儥': 2,
    '儩': 2,
    '優': 2,
    '儮': 2,
    '儰': 2,
    '儱': 2,
    '儲': 2,
    '儷': 2,
    '儸': 2,
    '儹': 2,
    '儺': 2,
    '儻': 2,
    '儼': 2,
    '儿': 3,
    '克': 3,
    '兌': 2,
    '兑': 3,
    '兒': 2,
    '兖': 1,
    '兗': 2,
    '党': 3,
    '內': 2,
    '兩': 2,
    '兰': 1,
    '关': 1,
    '兴': 1,
    '兹': 1,
    '养': 1,
    '兽': 1,
    '冁': 1,
    '内': 3,
    '冈': 1,
    '冊': 2,
    '册': 3,
    '写': 1,
    '军': 1,
    '农': 1,
    '冪': 2,
    '冬': 3,
    '冯': 1,
    '冲': 3,
    '决': 1,
    '况': 3,
    '冻': 1,
    '净': 1,
    '准': 3,
    '凈': 2,
    '凉': 3,
    '凍': 2,
    '减': 3,
    '凑': 3,
    '凔': 2,
    '凙': 2,
    '凛': 1,
    '凜': 2,
    '凟': 2,
    '几': 3,
    '凤': 3,
    '凫': 1,
    '凭': 3,
    '凯': 1,
    '凱': 2,
    '凴': 2,
    '出': 3,
    '击': 1,
    '凿': 1,
    '刍': 1,
    '划': 3,
    '刘': 3,
    '则': 1,
    '刚': 1,
    '创': 1,
    '删': 3,
    '別': 2,
    '刪': 2,
    '别': 3,
    '刬': 1,
    '刭': 1,
    '刮': 3,
    '制': 3,
    '刹': 3,
    '刽': 1,
    '刾': 3,
    '刿': 1,
    '剀': 1,
    '剂': 1,
    '剄': 2,
    '則': 2,
    '剋': 2,
    '剎': 2,
    '剐': 1,
    '剑': 1,
    '剗': 2,
    '剛': 2,
    '剝': 2,
    '剥': 1,
    '剧': 3,
    '剮': 2,
    '剴': 2,
    '創': 2,
    '剸': 2,
    '剾': 2,
    '劃': 2,
    '劇': 2,
    '劉': 2,
    '劊': 2,
    '劌': 2,
    '劍': 2,
    '劏': 2,
    '劑': 2,
    '劗': 2,
    '劚': 2,
    '劝': 3,
    '办': 3,
    '务': 1,
    '劢': 1,
    '动': 3,
    '励': 3,
    '劲': 1,
    '劳': 3,
    '势': 3,
    '勁': 2,
    '勋': 1,
    '勑': 2,
    '動': 2,
    '務': 2,
    '勚': 1,
    '勛': 2,
    '勝': 2,
    '勞': 2,
    '勢': 2,
    '勣': 2,
    '勩': 2,
    '勱': 2,
    '勴': 2,
    '勵': 2,
    '勸': 2,
    '勻': 2,
    '匀': 3,
    '匦': 1,
    '匭': 2,
    '匮': 1,
    '匯': 2,
    '匰': 2,
    '匱': 2,
    '匵': 2,
    '区': 3,
    '医': 3,
    '區': 2,
    '千': 3,
    '华': 1,
    '协': 1,
    '協': 2,
    '单': 3,
    '卖': 1,
    '卜': 3,
    '卢': 1,
    '卤': 1,
    '卨': 2,
    '卫': 1,
    '却': 3,
    '卷': 3,
    '卻': 2,
    '厂': 3,
    '厅': 1,
    '历': 3,
    '厉': 3,
    '压': 3,
    '厌': 1,
    '厍': 1,
    '厐': 1,
    '厕': 1,
    '厘': 3,
    '厙': 2,
    '厠': 2,
    '厢': 1,
    '厣': 1,
    '厦': 3,
    '厨': 3,
    '厩': 3,
    '厭': 2,
    '厮': 3,
    '厱': 2,
    '厲': 2,
    '厴': 2,
    '县': 1,
    '叁': 1,
    '参': 3,
    '參': 2,
    '叄': 2,
    '叆': 1,
    '叇': 1,
    '双': 3,
    '发': 1,
    '变': 1,
    '叙': 3,
    '叠': 3,
    '叢': 2,
    '只': 3,
    '台': 3,
    '叶': 3,
    '号': 3,
    '叹': 1,
    '叽': 1,
    '吁': 3,
    '合': 3,
    '同': 3,
    '后': 3,
    '向': 3,
    '吒': 2,
    '吓': 3,
    '吕': 1,
    '吗': 1,
    '吣': 1,
    '吨': 1,
    '听': 3,
    '启': 1,
    '吳': 2,
    '吴': 3,
    '吶': 2,
    '呂': 2,
    '呐': 1,
    '呒': 1,
    '呓': 1,
    '呕': 1,
    '呖': 1,
    '呗': 1,
    '员': 1,
    '呙': 1,
    '呛': 1,
    '呜': 1,
    '咏': 3,
    '咙': 1,
    '咛': 1,
    '咝': 1,
    '咤': 3,
    '咸': 3,
    '咼': 2,
    '响': 3,
    '哑': 1,
    '哒': 1,
    '哓': 1,
    '哔': 1,
    '哕': 1,
    '哗': 1,
    '哙': 1,
    '哜': 1,
    '哝': 1,
    '哟': 1,
    '員': 2,
    '哯': 2,
    '唄': 2,
    '唊': 2,
    '唓': 2,
    '唚': 2,
    '唛': 1,
    '唝': 1,
    '唠': 1,
    '唡': 1,
    '唢': 1,
    '唤': 1,
    '唻': 2,
    '問': 2,
    '啓': 2,
    '啞': 2,
    '啟': 2,
    '啢': 2,
    '啧': 1,
    '啬': 1,
    '啭': 1,
    '啮': 1,
    '啯': 1,
    '啰': 3,
    '啴': 1,
    '啸': 1,
    '喎': 2,
    '喚': 2,
    '喡': 2,
    '喪': 2,
    '喬': 2,
    '單': 2,
    '喲': 2,
    '喷': 1,
    '喽': 3,
    '喾': 1,
    '嗆': 2,
    '嗇': 2,
    '嗊': 2,
    '嗎': 2,
    '嗚': 2,
    '嗧': 2,
    '嗩': 2,
    '嗫': 1,
    '嗳': 1,
    '嗶': 2,
    '嗹': 2,
    '嗿': 2,
    '嘄': 2,
    '嘆': 2,
    '嘇': 2,
    '嘍': 2,
    '嘓': 2,
    '嘔': 2,
    '嘖': 2,
    '嘗': 2,
    '嘘': 1,
    '嘜': 2,
    '嘤': 1,
    '嘩': 2,
    '嘪': 2,
    '嘮': 2,
    '嘯': 2,
    '嘰': 2,
    '嘱': 3,
    '嘳': 2,
    '嘵': 2,
    '嘸': 2,
    '嘺': 2,
    '嘽': 2,
    '噁': 2,
    '噅': 2,
    '噓': 2,
    '噚': 2,
    '噜': 1,
    '噝': 2,
    '噞': 2,
    '噠': 2,
    '噥': 2,
    '噦': 2,
    '噯': 2,
    '噲': 2,
    '噴': 2,
    '噸': 2,
    '噹': 2,
    '嚀': 2,
    '嚂': 2,
    '嚇': 2,
    '嚈': 2,
    '嚌': 2,
    '嚍': 2,
    '嚐': 2,
    '嚕': 2,
    '嚙': 2,
    '嚛': 2,
    '嚝': 2,
    '嚠': 2,
    '嚣': 1,
    '嚦': 2,
    '嚧': 2,
    '嚨': 2,
    '嚩': 2,
    '嚪': 2,
    '嚫': 2,
    '嚬': 2,
    '嚮': 2,
    '嚱': 2,
    '嚲': 2,
    '嚳': 2,
    '嚴': 2,
    '嚶': 2,
    '嚸': 2,
    '嚽': 2,
    '嚿': 2,
    '囀': 2,
    '囁': 2,
    '囂': 2,
    '囃': 2,
    '囅': 2,
    '囇': 2,
    '囈': 2,
    '囉': 2,
    '囋': 2,
    '囌': 2,
    '囐': 2,
    '囑': 2,
    '囒': 2,
    '囕': 2,
    '回': 3,
    '团': 1,
    '囪': 2,
    '园': 3,
    '困': 3,
    '囱': 1,
    '围': 1,
    '囵': 1,
    '国': 1,
    '图': 3,
    '圆': 1,
    '圇': 2,
    '國': 2,
    '圍': 2,
    '園': 2,
    '圓': 2,
    '圖': 2,
    '團': 2,
    '圞': 2,
    '圣': 1,
    '圹': 1,
    '场': 1,
    '坂': 3,
    '坏': 3,
    '块': 3,
    '坚': 1,
    '坛': 3,
    '坜': 1,
    '坝': 1,
    '坞': 1,
    '坟': 1,
    '坠': 1,
    '垄': 1,
    '垅': 1,
    '垆': 1,
    '垒': 1,
    '垦': 1,
    '垩': 1,
    '垫': 1,
    '垭': 1,
    '垯': 1,
    '垱': 1,
    '垲': 1,
    '垴': 1,
    '垵': 2,
    '垷': 2,
    '垻': 2,
    '埉': 2,
    '埘': 1,
    '埙': 1,
    '埚': 1,
    '埡': 2,
    '埨': 2,
    '埬': 2,
    '埯': 1,
    '埰': 2,
    '執': 2,
    '堅': 2,
    '堈': 2,
    '堊': 2,
    '堑': 1,
    '堕': 3,
    '堖': 2,
    '堚': 2,
    '堝': 2,
    '堯': 2,
    '報': 2,
    '場': 2,
    '塆': 1,
    '塊': 2,
    '塋': 2,
    '塏': 2,
    '塒': 2,
    '塗': 2,
    '塢': 2,
    '塤': 2,
    '塵': 2,
    '塸': 2,
    '塹': 2,
    '塼': 2,
    '塿': 2,
    '墆': 2,
    '墊': 2,
    '墋': 2,
    '墏': 2,
    '墙': 1,
    '墜': 2,
    '墝': 2,
    '墠': 2,
    '墢': 2,
    '墧': 2,
    '墮': 2,
    '墳': 2,
    '墶': 2,
    '墷': 2,
    '墻': 2,
    '墾': 2,
    '墿': 2,
    '壇': 2,
    '壈': 2,
    '壋': 2,
    '壍': 2,
    '壏': 2,
    '壐': 2,
    '壒': 2,
    '壓': 2,
    '壔': 2,
    '壗': 2,
    '壘': 2,
    '壙': 2,
    '壚': 2,
    '壛': 2,
    '壝': 2,
    '壞': 2,
    '壟': 2,
    '壠': 2,
    '壢': 2,
    '壣': 2,
    '壧': 2,
    '壩': 2,
    '壪': 2,
    '壮': 3,
    '壯': 2,
    '声': 3,
    '壳': 3,
    '壶': 1,
    '壸': 1,
    '壺': 2,
    '壼': 2,
    '壽': 2,
    '处': 1,
    '备': 1,
    '复': 3,
    '够': 3,
    '夠': 2,
    '夢': 2,
    '夥': 3,
    '头': 3,
    '夸': 3,
    '夹': 1,
    '夺': 1,
    '夾': 2,
    '奁': 1,
    '奂': 1,
    '奋': 1,
    '奐': 2,
    '奖': 1,
    '奥': 1,
    '奧': 2,
    '奨': 1,
    '奩': 2,
    '奪': 2,
    '奫': 2,
    '奬': 2,
    '奮': 2,
    '奯': 2,
    '奲': 2,
    '奸': 3,
    '奼': 2,
    '妆': 1,
    '妇': 1,
    '妈': 1,
    '妝': 2,
    '妩': 1,
    '妪': 1,
    '妫': 1,
    '姍': 2,
    '姗': 3,
    '姜': 3,
    '姦': 2,
    '姹': 3,
    '娄': 3,
    '娅': 1,
    '娆': 1,
    '娇': 3,
    '娈': 3,
    '娙': 2,
    '娛': 2,
    '娱': 3,
    '娲': 1,
    '娴': 1,
    '婁': 2,
    '婡': 2,
    '婦': 2,
    '婭': 2,
    '婳': 1,
    '婴': 1,
    '婵': 1,
    '婶': 1,
    '婸': 2,
    '媁': 2,
    '媈': 2,
    '媜': 2,
    '媧': 2,
    '媪': 1,
    '媭': 1,
    '媯': 2,
    '媰': 2,
    '媼': 2,
    '媽': 2,
    '嫈': 2,
    '嫒': 1,
    '嫔': 1,
    '嫗': 2,
    '嫢': 2,
    '嫥': 2,
    '嫧': 2,
    '嫱': 1,
    '嫵': 2,
    '嫻': 2,
    '嫿': 2,
    '嬀': 2,
    '嬃': 2,
    '嬅': 2,
    '嬇': 2,
    '嬈': 2,
    '嬋': 2,
    '嬌': 2,
    '嬐': 2,
    '嬒': 2,
    '嬙': 2,
    '嬝': 2,
    '嬟': 2,
    '嬡': 2,
    '嬣': 2,
    '嬤': 2,
    '嬦': 2,
    '嬧': 2,
    '嬪': 2,
    '嬮': 2,
    '嬰': 2,
    '嬷': 1,
    '嬸': 2,
    '嬻': 2,
    '嬾': 2,
    '孄': 2,
    '孆': 2,
    '孇': 2,
    '孋': 2,
    '孌': 2,
    '孎': 2,
    '孏': 2,
    '孙': 3,
    '学': 1,
    '孪': 3,
    '孫': 2,
    '孲': 2,
    '學': 2,
    '孻': 2,
    '孾': 2,
    '孿': 2,
    '宁': 3,
    '宝': 3,
    '实': 3,
    '宠': 1,
    '审': 1,
    '宪': 1,
    '宫': 1,
    '宮': 2,
    '家': 3,
    '宽': 1,
    '宾': 3,
    '寝': 1,
    '寠': 2,
    '寢': 2,
    '實': 2,
    '寧': 2,
    '審': 2,
    '寪': 2,
    '寫': 2,
    '寬': 2,
    '寯': 2,
    '寵': 2,
    '寶': 2,
    '寷': 2,
    '对': 3,
    '寻': 1,
    '导': 1,
    '寿': 3,
    '将': 1,
    '將': 2,
    '專': 2,
    '尋': 2,
    '對': 2,
    '導': 2,
    '尔': 3,
    '尘': 1,
    '尝': 3,
    '尧': 1,
    '尴': 1,
    '尷': 2,
    '尸': 3,
    '尽': 3,
    '层': 1,
    '屃': 1,
    '屆': 2,
    '屉': 1,
    '届': 3,
    '屍': 2,
    '屓': 2,
    '屜': 2,
    '属': 3,
    '屡': 3,
    '屢': 2,
    '層': 2,
    '屦': 1,
    '屨': 2,
    '屩': 2,
    '屬': 2,
    '屿': 1,
    '岁': 3,
    '岂': 1,
    '岖': 1,
    '岗': 1,
    '岘': 1,
    '岙': 1,
    '岚': 1,
    '岛': 1,
    '岡': 2,
    '岭': 1,
    '岽': 1,
    '岿': 1,
    '峃': 1,
    '峄': 1,
    '峡': 1,
    '峣': 1,
    '峤': 1,
    '峥': 1,
    '峦': 3,
    '峴': 2,
    '島': 2,
    '峽': 2,
    '崂': 1,
    '崃': 1,
    '崄': 1,
    '崍': 2,
    '崗': 2,
    '崙': 2,
    '崠': 2,
    '崢': 2,
    '崬': 2,
    '崭': 1,
    '崱': 2,
    '崵': 2,
    '嵐': 2,
    '嵘': 1,
    '嵚': 1,
    '嵝': 1,
    '嵷': 2,
    '嵸': 2,
    '嵼': 2,
    '嵽': 2,
    '嵾': 2,
    '嶁': 2,
    '嶄': 2,
    '嶇': 2,
    '嶈': 2,
    '嶔': 2,
    '嶗': 2,
    '嶠': 2,
    '嶢': 2,
    '嶤': 2,
    '嶧': 2,
    '嶨': 2,
    '嶩': 2,
    '嶪': 2,
    '嶮': 2,
    '嶴': 2,
    '嶸': 2,
    '嶹': 2,
    '嶺': 2,
    '嶼': 2,
    '嶽': 2,
    '巃': 2,
    '巅': 1,
    '巆': 2,
    '巊': 2,
    '巋': 2,
    '巑': 2,
    '巒': 2,
    '巔': 2,
    '巖': 2,
    '巗': 2,
    '巘': 2,
    '巚': 2,
    '巠': 2,
    '巩': 1,
    '巯': 1,
    '巰': 2,
    '币': 1,
    '帅': 1,
    '师': 3,
    '帏': 1,
    '帐': 1,
    '帘': 3,
    '帜': 1,
    '帥': 2,
    '带': 1,
    '帧': 1,
    '師': 2,
    '帮': 3,
    '帱': 1,
    '帳': 2,
    '帴': 2,
    '帶': 2,
    '帻': 1,
    '帼': 1,
    '幀': 2,
    '幂': 3,
    '幃': 2,
    '幓': 2,
    '幗': 2,
    '幘': 2,
    '幟': 2,
    '幠': 2,
    '幣': 2,
    '幩': 2,
    '幫': 2,
    '幬': 2,
    '幰': 2,
    '幱': 2,
    '干': 3,
    '并': 3,
    '幹': 2,
    '幺': 2,
    '幾': 2,
    '广': 3,
    '庄': 3,
    '庆': 1,
    '庐': 3,
    '庑': 1,
    '库': 1,
    '应': 3,
    '庙': 3,
    '庞': 1,
    '废': 1,
    '庫': 2,
    '庲': 2,
    '庼': 1,
    '廁': 2,
    '廂': 2,
    '廄': 2,
    '廈': 2,
    '廎': 2,
    '廔': 2,
    '廕': 2,
    '廗': 2,
    '廚': 2,
    '廝': 2,
    '廞': 2,
    '廟': 2,
    '廠': 2,
    '廡': 2,
    '廢': 2,
    '廣': 2,
    '廥': 2,
    '廧': 2,
    '廩': 2,
    '廪': 1,
    '廬': 2,
    '廮': 2,
    '廳': 2,
    '开': 3,
    '异': 1,
    '弃': 3,
    '弑': 1,
    '弒': 2,
    '张': 1,
    '弥': 1,
    '弪': 1,
    '弯': 3,
    '弳': 2,
    '張': 2,
    '強': 2,
    '弹': 3,
    '强': 3,
    '彄': 2,
    '彆': 2,
    '彈': 2,
    '彌': 2,
    '彍': 2,
    '彎': 2,
    '归': 3,
    '当': 3,
    '录': 1,
    '彙': 2,
    '彝': 1,
    '彞': 2,
    '彟': 1,
    '彠': 2,
    '彥': 2,
    '彦': 3,
    '彨': 1,
    '彲': 2,
    '彻': 1,
    '征': 3,
    '径': 1,
    '後': 2,
    '徑': 2,
    '徕': 1,
    '從': 2,
    '徠': 2,
    '御': 3,
    '復': 3,
    '徵': 3,
    '徹': 2,
    '徿': 2,
    '忆': 1,
    '忏': 1,
    '志': 3,
    '忧': 1,
    '忾': 1,
    '怀': 3,
    '态': 1,
    '怂': 1,
    '怃': 1,
    '怄': 1,
    '怅': 1,
    '怆': 1,
    '怜': 3,
    '总': 1,
    '怼': 1,
    '怿': 1,
    '恆': 2,
    '恋': 3,
    '恒': 3,
    '恥': 2,
    '恳': 1,
    '恶': 1,
    '恸': 1,
    '恹': 1,
    '恺': 1,
    '恻': 1,
    '恼': 3,
    '恽': 1,
    '悅': 2,
    '悏': 2,
    '悓': 2,
    '悞': 2,
    '悦': 1,
    '悫': 1,
    '悬': 1,
    '悭': 1,
    '悮': 1,
    '悯': 1,
    '悵': 2,
    '悶': 2,
    '惀': 2,
    '惊': 1,
    '惡': 2,
    '惧': 3,
    '惨': 1,
    '惩': 3,
    '惫': 1,
    '惬': 1,
    '惭': 1,
    '惮': 1,
    '惯': 1,
    '惱': 2,
    '惲': 2,
    '惻': 2,
    '愇': 2,
    '愛': 2,
    '愜': 2,
    '愠': 3,
    '愤': 1,
    '愦': 1,
    '愨': 2,
    '愩': 2,
    '愴': 2,
    '愷': 2,
    '愾': 2,
    '愿': 3,
    '慄': 2,
    '態': 2,
    '慍': 2,
    '慐': 2,
    '慑': 1,
    '慖': 2,
    '慘': 2,
    '慙': 2,
    '慚': 2,
    '慟': 2,
    '慣': 2,
    '慤': 2,
    '慪': 2,
    '慫': 2,
    '慭': 1,
    '慮': 2,
    '慯': 2,
    '慱': 2,
    '慲': 2,
    '慳': 2,
    '慶': 2,
    '慸': 2,
    '慹': 2,
    '慺': 2,
    '憂': 2,
    '憅': 2,
    '憊': 2,
    '憍': 2,
    '憐': 2,
    '憑': 2,
    '憒': 2,
    '憖': 2,
    '憚': 2,
    '憢': 2,
    '憤': 2,
    '憦': 2,
    '憪': 2,
    '憫': 2,
    '憮': 2,
    '憲': 2,
    '憴': 2,
    '憶': 2,
    '憸': 2,
    '憹': 2,
    '懀': 2,
    '懇': 2,
    '應': 2,
    '懌': 2,
    '懍': 2,
    '懑': 1,
    '懒': 1,
    '懓': 2,
    '懔': 1,
    '懕': 2,
    '懘': 2,
    '懙': 2,
    '懜': 2,
    '懞': 2,
    '懟': 2,
    '懠': 2,
    '懣': 2,
    '懤': 2,
    '懧': 2,
    '懨': 2,
    '懩': 2,
    '懫': 2,
    '懭': 2,
    '懰': 2,
    '懲': 2,
    '懶': 2,
    '懷': 2,
    '懸': 2,
    '懺': 2,
    '懼': 2,
    '懾': 2,
    '戀': 2,
    '戁': 2,
    '戃': 2,
    '戆': 1,
    '戇': 2,
    '戋': 1,
    '戏': 3,
    '戔': 2,
    '戗': 1,
    '战': 3,
    '戠': 3,
    '戧': 2,
    '戩': 2,
    '戬': 1,
    '戯': 1,
    '戰': 2,
    '戱': 2,
    '戲': 2,
    '戶': 2,
    '户': 3,
    '才': 3,
    '扑': 3,
    '执': 3,
    '扩': 1,
    '扪': 1,
    '扫': 1,
    '扬': 1,
    '扰': 1,
    '折': 3,
    '抚': 1,
    '抛': 3,
    '抟': 1,
    '抠': 1,
    '抡': 1,
    '抢': 1,
    '护': 1,
    '报': 3,
    '担': 3,
    '拋': 2,
    '拟': 1,
    '拢': 1,
    '拣': 1,
    '拥': 1,
    '拦': 1,
    '拧': 1,
    '拨': 1,
    '择': 1,
    '挂': 3,
    '挙': 1,
    '挚': 1,
    '挛': 3,
    '挜': 1,
    '挝': 1,
    '挞': 1,
    '挟': 3,
    '挠': 1,
    '挡': 3,
    '挢': 1,
    '挣': 1,
    '挤': 1,
    '挥': 1,
    '挦': 1,
    '挩': 2,
    '挽': 3,
    '挾': 2,
    '捝': 1,
    '捞': 1,
    '损': 1,
    '捡': 1,
    '换': 1,
    '捣': 1,
    '捨': 2,
    '捫': 2,
    '据': 3,
    '捲': 2,
    '掁': 2,
    '掃': 2,
    '掄': 2,
    '掆': 2,
    '掗': 2,
    '掙': 2,
    '掚': 2,
    '掛': 2,
    '採': 2,
    '掳': 1,
    '掴': 1,
    '掷': 3,
    '掸': 1,
    '掺': 1,
    '掼': 1,
    '揀': 2,
    '揚': 2,
    '換': 2,
    '揮': 2,
    '揽': 1,
    '揾': 3,
    '揿': 1,
    '搀': 1,
    '搁': 1,
    '搂': 1,
    '搅': 1,
    '搊': 2,
    '損': 2,
    '搎': 2,
    '搖': 2,
    '搗': 2,
    '搵': 2,
    '搶': 2,
    '携': 3,
    '摀': 2,
    '摃': 2,
    '摄': 1,
    '摅': 1,
    '摆': 3,
    '摇': 1,
    '摈': 3,
    '摊': 3,
    '摋': 2,
    '摐': 2,
    '摑': 2,
    '摕': 2,
    '摙': 2,
    '摜': 2,
    '摟': 2,
    '摪': 2,
    '摫': 2,
    '摯': 2,
    '摲': 2,
    '摳': 2,
    '摶': 2,
    '摺': 3,
    '摻': 2,
    '摼': 2,
    '撄': 1,
    '撈': 2,
    '撊': 2,
    '撋': 2,
    '撌': 2,
    '撏': 2,
    '撐': 2,
    '撑': 3,
    '撓': 2,
    '撝': 2,
    '撟': 2,
    '撣': 2,
    '撥': 2,
    '撧': 2,
    '撫': 2,
    '撲': 2,
    '撳': 2,
    '撵': 1,
    '撶': 2,
    '撷': 1,
    '撸': 1,
    '撺': 1,
    '撻': 2,
    '撾': 2,
    '撿': 2,
    '擁': 2,
    '擃': 2,
    '擄': 2,
    '擇': 2,
    '擈': 2,
    '擊': 2,
    '擋': 2,
    '擓': 2,
    '擔': 2,
    '據': 2,
    '擜': 1,
    '擞': 1,
    '擟': 2,
    '擠': 2,
    '擣': 2,
    '擥': 2,
    '擧': 2,
    '擪': 2,
    '擫': 2,
    '擬': 2,
    '擯': 2,
    '擰': 2,
    '擱': 2,
    '擲': 2,
    '擳': 2,
    '擴': 2,
    '擷': 2,
    '擺': 2,
    '擻': 2,
    '擼': 2,
    '擽': 2,
    '擾': 2,
    '攄': 2,
    '攆': 2,
    '攋': 2,
    '攎': 2,
    '攏': 2,
    '攑': 2,
    '攒': 1,
    '攔': 2,
    '攖': 2,
    '攙': 2,
    '攛': 2,
    '攜': 2,
    '攝': 2,
    '攞': 2,
    '攢': 2,
    '攣': 2,
    '攤': 2,
    '攦': 2,
    '攧': 2,
    '攩': 2,
    '攪': 2,
    '攬': 2,
    '攳': 2,
    '敌': 1,
    '敗': 2,
    '敘': 2,
    '敛': 1,
    '敩': 1,
    '数': 3,
    '敳': 2,
    '敵': 2,
    '數': 2,
    '敺': 2,
    '敿': 2,
    '斁': 2,
    '斂': 2,
    '斃': 2,
    '斄': 2,
    '斅': 2,
    '斆': 2,
    '斋': 3,
    '斓': 1,
    '斕': 2,
    '斗': 3,
    '斩': 1,
    '斬': 2,
    '断': 3,
    '斷': 2,
    '斸': 2,
    '於': 2,
    '旋': 3,
    '旝': 2,
    '旟': 2,
    '无': 3,
    '旧': 1,
    '时': 3,
    '旷': 3,
    '旸': 1,
    '昙': 1,
    '昜': 2,
    '昼': 3,
    '昽': 1,
    '显': 1,
    '時': 2,
    '晉': 2,
    '晋': 3,
    '晒': 3,
    '晓': 1,
    '晔': 1,
    '晕': 1,
    '晖': 1,
    '晛': 2,
    '晝': 2,
    '暂': 1,
    '暅': 1,
    '暈': 2,
    '暉': 2,
    '暊': 2,
    '暐': 2,
    '暘': 2,
    '暟': 2,
    '暢': 2,
    '暧': 1,
    '暫': 2,
    '曄': 2,
    '曆': 2,
    '曇': 2,
    '曉': 2,
    '曊': 2,
    '曏': 2,
    '曖': 2,
    '曠': 2,
    '曥': 2,
    '曨': 2,
    '曬': 2,
    '曭': 2,
    '曮': 2,
    '曲': 3,
    '書': 2,
    '會': 2,
    '朥': 2,
    '朧': 2,
    '术': 3,
    '朱': 3,
    '朴': 3,
    '机': 3,
    '杀': 1,
    '杂': 1,
    '权': 3,
    '杆': 3,
    '条': 1,
    '来': 1,
    '杨': 1,
    '杩': 1,
    '杰': 3,
    '東': 2,
    '松': 3,
    '板': 3,
    '极': 3,
    '构': 3,
    '枞': 1,
    '枢': 1,
    '枣': 1,
    '枥': 1,
    '枧': 1,
    '枨': 1,
    '枪': 1,
    '枫': 1,
    '枭': 1,
    '柜': 3,
    '柠': 1,
    '柵': 2,
    '柽': 1,
    '栀': 3,
    '栅': 3,
    '标': 3,
    '栈': 1,
    '栉': 1,
    '栊': 1,
    '栋': 1,
    '栌': 1,
    '栎': 1,
    '栏': 1,
    '树': 1,
    '栖': 3,
    '栗': 3,
    '样': 1,
    '栾': 3,
    '桠': 1,
    '桡': 1,
    '桢': 1,
    '档': 1,
    '桤': 1,
    '桥': 1,
    '桦': 1,
    '桧': 1,
    '桨': 1,
    '桩': 1,
    '桪': 1,
    '桱': 2,
    '桿': 2,
    '梔': 2,
    '梖': 2,
    '梘': 2,
    '梜': 2,
    '條': 2,
    '梟': 2,
    '梦': 3,
    '梲': 2,
    '梼': 1,
    '梾': 1,
    '梿': 1,
    '检': 1,
    '棁': 1,
    '棂': 1,
    '棄': 2,
    '棆': 2,
    '棖': 2,
    '棗': 2,
    '棟': 2,
    '棡': 2,
    '棧': 2,
    '棲': 2,
    '棶': 2,
    '椁': 1,
    '椏': 2,
    '椚': 2,
    '椝': 1,
    '椟': 1,
    '椠': 1,
    '椢': 1,
    '椤': 1,
    '椫': 1,
    '椭': 1,
    '椮': 1,
    '椲': 2,
    '楇': 2,
    '楊': 2,
    '楎': 2,
    '楓': 2,
    '楨': 2,
    '業': 2,
    '極': 2,
    '楼': 3,
    '榄': 1,
    '榅': 1,
    '榇': 1,
    '榈': 1,
    '榉': 1,
    '榝': 2,
    '榪': 2,
    '榮': 2,
    '榯': 2,
    '榲': 2,
    '榿': 2,
    '構': 2,
    '槍': 2,
    '槚': 1,
    '槛': 1,
    '槟': 1,
    '槠': 1,
    '槤': 2,
    '槧': 2,
    '槨': 2,
    '槫': 2,
    '槮': 2,
    '槳': 2,
    '槶': 2,
    '槻': 2,
    '槼': 2,
    '樁': 2,
    '樂': 2,
    '樅': 2,
    '樓': 2,
    '標': 2,
    '樞': 2,
    '樠': 2,
    '樢': 2,
    '樣': 2,
    '横': 1,
    '樫': 2,
    '樯': 1,
    '樱': 1,
    '樲': 2,
    '樳': 2,
    '樸': 2,
    '樹': 2,
    '樺': 2,
    '樻': 2,
    '樿': 2,
    '橃': 2,
    '橅': 2,
    '橈': 2,
    '橋': 2,
    '橚': 2,
    '機': 2,
    '橢': 2,
    '橥': 1,
    '橨': 2,
    '橫': 2,
    '橯': 2,
    '橱': 1,
    '橹': 1,
    '橼': 1,
    '檁': 2,
    '檂': 2,
    '檉': 2,
    '檋': 2,
    '檒': 2,
    '檔': 2,
    '檛': 2,
    '檜': 2,
    '檟': 2,
    '檡': 2,
    '檢': 2,
    '檣': 2,
    '檥': 2,
    '檩': 1,
    '檭': 2,
    '檮': 2,
    '檯': 2,
    '檰': 2,
    '檲': 2,
    '檳': 2,
    '檵': 2,
    '檸': 2,
    '檻': 2,
    '檾': 2,
    '檿': 2,
    '櫃': 2,
    '櫅': 2,
    '櫍': 2,
    '櫎': 2,
    '櫏': 2,
    '櫓': 2,
    '櫚': 2,
    '櫛': 2,
    '櫝': 2,
    '櫞': 2,
    '櫟': 2,
    '櫠': 2,
    '櫢': 2,
    '櫥': 2,
    '櫦': 2,
    '櫧': 2,
    '櫨': 2,
    '櫩': 2,
    '櫪': 2,
    '櫫': 2,
    '櫬': 2,
    '櫯': 2,
    '櫱': 2,
    '櫳': 2,
    '櫴': 2,
    '櫶': 2,
    '櫸': 2,
    '櫹': 2,
    '櫻': 2,
    '櫽': 2,
    '欄': 2,
    '欆': 2,
    '欇': 2,
    '權': 2,
    '欍': 2,
    '欏': 2,
    '欐': 2,
    '欑': 2,
    '欒': 2,
    '欓': 2,
    '欖': 2,
    '欘': 2,
    '欞': 2,
    '欢': 3,
    '欤': 3,
    '欧': 1,
    '欽': 2,
    '歄': 2,
    '歍': 2,
    '歐': 2,
    '歕': 2,
    '歗': 2,
    '歛': 2,
    '歞': 2,
    '歟': 2,
    '歡': 2,
    '歲': 2,
    '歷': 2,
    '歸': 2,
    '歼': 1,
    '歿': 2,
    '殁': 1,
    '殇': 1,
    '残': 1,
    '殒': 1,
    '殓': 1,
    '殘': 2,
    '殚': 1,
    '殞': 2,
    '殡': 3,
    '殢': 2,
    '殤': 2,
    '殨': 2,
    '殫': 2,
    '殮': 2,
    '殯': 2,
    '殰': 2,
    '殲': 2,
    '殴': 1,
    '殺': 2,
    '殻': 2,
    '殼': 2,
    '毀': 2,
    '毁': 1,
    '毂': 1,
    '毄': 2,
    '毆': 2,
    '毊': 2,
    '毕': 1,
    '毙': 1,
    '毚': 2,
    '毡': 3,
    '毵': 1,
    '毶': 1,
    '毿': 2,
    '氀': 2,
    '氂': 2,
    '氇': 1,
    '氈': 2,
    '氌': 2,
    '气': 3,
    '氢': 1,
    '氣': 2,
    '氩': 1,
    '氫': 2,
    '氬': 2,
    '氭': 2,
    '氲': 1,
    '氳': 2,
    '汇': 1,
    '汉': 1,
    '汤': 1,
    '汹': 3,
    '決': 2,
    '沄': 3,
    '沈': 3,
    '沒': 2,
    '沖': 2,
    '沟': 1,
    '没': 3,
    '沣': 1,
    '沤': 1,
    '沥': 1,
    '沦': 1,
    '沧': 1,
    '沨': 1,
    '沩': 1,
    '沪': 3,
    '況': 2,
    '泞': 1,
    '注': 3,
    '泪': 3,
    '泶': 1,
    '泷': 1,
    '泸': 1,
    '泺': 1,
    '泻': 1,
    '泼': 1,
    '泽': 1,
    '泾': 1,
    '洁': 1,
    '洒': 3,
    '洶': 2,
    '洼': 3,
    '浃': 1,
    '浅': 3,
    '浆': 1,
    '浇': 1,
    '浈': 1,
    '浉': 1,
    '浊': 1,
    '测': 1,
    '浍': 1,
    '济': 1,
    '浏': 1,
    '浐': 1,
    '浑': 1,
    '浒': 1,
    '浓': 1,
    '浔': 1,
    '浕': 1,
    '浹': 2,
    '浿': 2,
    '涂': 3,
    '涇': 2,
    '涛': 3,
    '涝': 1,
    '涞': 1,
    '涟': 1,
    '涠': 1,
    '涡': 1,
    '涢': 1,
    '涣': 1,
    '涤': 1,
    '润': 1,
    '涧': 1,
    '涨': 1,
    '涩': 1,
    '涷': 2,
    '涼': 2,
    '淀': 3,
    '淚': 2,
    '淥': 2,
    '淪': 2,
    '淵': 2,
    '淶': 2,
    '淺': 2,
    '渊': 3,
    '渌': 1,
    '渍': 1,
    '渎': 1,
    '渐': 1,
    '渑': 1,
    '渔': 1,
    '渖': 1,
    '渗': 1,
    '渙': 2,
    '減': 2,
    '渢': 2,
    '渦': 2,
    '温': 3,
    '測': 2,
    '渾': 2,
    '湊': 2,
    '湋': 2,
    '湞': 2,
    '湯': 2,
    '湾': 3,
    '湿': 1,
    '溁': 1,
    '溃': 1,
    '溅': 1,
    '溆': 1,
    '溇': 1,
    '溈': 2,
    '準': 2,
    '溝': 2,
    '溡': 2,
    '溤': 2,
    '溫': 2,
    '溮': 2,
    '溰': 2,
    '溳': 2,
    '滄': 2,
    '滅': 2,
    '滌': 2,
    '滎': 2,
    '滗': 1,
    '滚': 3,
    '滞': 1,
    '滟': 1,
    '滠': 1,
    '满': 1,
    '滢': 1,
    '滤': 1,
    '滥': 1,
    '滦': 3,
    '滨': 3,
    '滩': 3,
    '滪': 1,
    '滬': 2,
    '滭': 2,
    '滯': 2,
    '滲': 2,
    '滷': 2,
    '滸': 2,
    '滻': 2,
    '滾': 2,
    '滿': 2,
    '漁': 2,
    '漊': 2,
    '漍': 2,
    '漎': 2,
    '漐': 2,
    '漓': 3,
    '漙': 2,
    '漚': 2,
    '漢': 2,
    '漣': 2,
    '漬': 2,
    '漲': 2,
    '漵': 2,
    '漸': 2,
    '漿': 2,
    '潁': 2,
    '潆': 1,
    '潇': 1,
    '潋': 1,
    '潍': 1,
    '潑': 2,
    '潔': 2,
    '潕': 2,
    '潙': 2,
    '潚': 2,
    '潛': 2,
    '潜': 1,
    '潣': 2,
    '潤': 2,
    '潬': 2,
    '潯': 2,
    '潰': 2,
    '潴': 1,
    '潷': 2,
    '潿': 2,
    '澀': 2,
    '澅': 2,
    '澆': 2,
    '澇': 2,
    '澐': 2,
    '澒': 2,
    '澕': 2,
    '澖': 2,
    '澗': 2,
    '澛': 1,
    '澜': 1,
    '澠': 2,
    '澢': 2,
    '澤': 2,
    '澦': 2,
    '澩': 2,
    '澫': 2,
    '澬': 2,
    '澮': 2,
    '澰': 2,
    '澱': 2,
    '澾': 2,
    '濁': 2,
    '濃': 2,
    '濄': 2,
    '濆': 2,
    '濇': 2,
    '濊': 2,
    '濑': 1,
    '濒': 1,
    '濕': 2,
    '濘': 2,
    '濚': 2,
    '濛': 2,
    '濜': 2,
    '濟': 2,
    '濤': 2,
    '濧': 2,
    '濫': 2,
    '濰': 2,
    '濱': 2,
    '濴': 2,
    '濺': 2,
    '濼': 2,
    '濾': 2,
    '濿': 2,
    '瀁': 2,
    '瀂': 2,
    '瀃': 2,
    '瀄': 2,
    '瀅': 2,
    '瀆': 2,
    '瀇': 2,
    '瀈': 2,
    '瀉': 2,
    '瀋': 2,
    '瀏': 2,
    '瀕': 2,
    '瀗': 2,
    '瀘': 2,
    '瀙': 2,
    '瀝': 2,
    '瀟': 2,
    '瀠': 2,
    '瀢': 2,
    '瀦': 2,
    '瀧': 2,
    '瀨': 2,
    '瀭': 2,
    '瀯': 2,
    '瀰': 2,
    '瀲': 2,
    '瀳': 2,
    '瀴': 2,
    '瀵': 2,
    '瀾': 2,
    '灃': 2,
    '灄': 2,
    '灍': 2,
    '灏': 1,
    '灑': 2,
    '灒': 2,
    '灓': 2,
    '灕': 2,
    '灘': 2,
    '灙': 2,
    '灝': 2,
    '灟': 2,
    '灠': 2,
    '灡': 2,
    '灣': 2,
    '灤': 2,
    '灦': 2,
    '灧': 2,
    '灭': 1,
    '灯': 3,
    '灵': 1,
    '灶': 3,
    '災': 2,
    '灾': 3,
    '灿': 1,
    '炀': 1,
    '炉': 3,
    '炜': 1,
    '炝': 1,
    '点': 3,
    '為': 2,
    '炼': 1,
    '炽': 1,
    '烁': 1,
    '烂': 1,
    '烃': 1,
    '烏': 2,
    '烛': 3,
    '烟': 3,
    '烦': 1,
    '烧': 1,
    '烨': 1,
    '烩': 3,
    '烫': 1,
    '烬': 3,
    '热': 3,
    '烴': 2,
    '焕': 1,
    '焖': 1,
    '焘': 1,
    '焛': 2,
    '無': 2,
    '煇': 2,
    '煈': 2,
    '煉': 2,
    '煒': 2,
    '煙': 2,
    '煢': 2,
    '煥': 2,
    '煩': 2,
    '煬': 2,
    '煱': 2,
    '煴': 1,
    '煼': 2,
    '熂': 2,
    '熅': 2,
    '熉': 2,
    '熌': 2,
    '熒': 2,
    '熓': 2,
    '熕': 2,
    '熗': 2,
    '熞': 2,
    '熡': 2,
    '熰': 2,
    '熱': 2,
    '熲': 2,
    '熾': 2,
    '燀': 2,
    '燁': 2,
    '燆': 2,
    '燈': 2,
    '燌': 2,
    '燒': 2,
    '燖': 2,
    '燘': 2,
    '燙': 2,
    '燜': 2,
    '營': 2,
    '燡': 2,
    '燦': 2,
    '燭': 2,
    '燰': 2,
    '燴': 2,
    '燵': 2,
    '燶': 2,
    '燼': 2,
    '燽': 2,
    '燾': 2,
    '爁': 2,
    '爃': 2,
    '爄': 2,
    '爍': 2,
    '爐': 2,
    '爓': 2,
    '爖': 2,
    '爗': 2,
    '爛': 2,
    '爣': 2,
    '爥': 2,
    '爧': 2,
    '爭': 2,
    '爱': 1,
    '爲': 2,
    '爷': 1,
    '爺': 2,
    '爾': 2,
    '牆': 2,
    '牋': 2,
    '牍': 1,
    '牘': 2,
    '牦': 1,
    '牵': 1,
    '牺': 1,
    '牼': 2,
    '牽': 2,
    '犅': 2,
    '犊': 1,
    '犓': 2,
    '犖': 2,
    '犞': 2,
    '犢': 2,
    '犤': 2,
    '犧': 2,
    '状': 1,
    '犷': 1,
    '犸': 1,
    '犹': 3,
    '狀': 2,
    '狈': 1,
    '狝': 1,
    '狞': 1,
    '独': 3,
    '狭': 1,
    '狮': 1,
    '狯': 3,
    '狰': 1,
    '狱': 1,
    '狲': 1,
    '狹': 2,
    '狽': 2,
    '猃': 1,
    '猌': 2,
    '猍': 2,
    '猎': 1,
    '猕': 3,
    '猙': 2,
    '猡': 1,
    '猧': 2,
    '猪': 3,
    '猫': 3,
    '猬': 3,
    '献': 3,
    '猶': 2,
    '猻': 2,
    '獁': 2,
    '獄': 2,
    '獅': 2,
    '獊': 2,
    '獎': 2,
    '獑': 2,
    '獖': 2,
    '獟': 2,
    '獢': 2,
    '獨': 2,
    '獩': 2,
    '獪': 2,
    '獫': 2,
    '獭': 1,
    '獮': 2,
    '獰': 2,
    '獱': 2,
    '獲': 2,
    '獵': 2,
    '獷': 2,
    '獸': 2,
    '獹': 2,
    '獺': 2,
    '獻': 2,
    '獼': 2,
    '玀': 2,
    '玁': 2,
    '玂': 2,
    '玑': 1,
    '玙': 1,
    '玚': 1,
    '玛': 1,
    '玮': 1,
    '环': 3,
    '现': 1,
    '玱': 1,
    '玺': 1,
    '珐': 3,
    '珑': 1,
    '珰': 1,
    '珲': 1,
    '珼': 2,
    '現': 2,
    '琎': 1,
    '琏': 1,
    '琐': 1,
    '琖': 2,
    '琺': 2,
    '琼': 3,
    '琿': 2,
    '瑋': 2,
    '瑒': 2,
    '瑙': 2,
    '瑣': 2,
    '瑤': 2,
    '瑩': 2,
    '瑪': 2,
    '瑲': 2,
    '瑶': 1,
    '瑷': 1,
    '瑸': 1,
    '瑻': 2,
    '瑽': 2,
    '璉': 2,
    '璊': 2,
    '璍': 2,
    '璎': 1,
    '璕': 2,
    '璗': 2,
    '璛': 2,
    '璝': 2,
    '璡': 2,
    '璣': 2,
    '璦': 2,
    '璫': 2,
    '璯': 2,
    '環': 2,
    '璵': 2,
    '璸': 2,
    '璹': 2,
    '璼': 2,
    '璽': 2,
    '璾': 2,
    '瓄': 2,
    '瓅': 2,
    '瓊': 2,
    '瓏': 2,
    '瓐': 2,
    '瓒': 1,
    '瓓': 2,
    '瓔': 2,
    '瓕': 2,
    '瓚': 2,
    '瓛': 2,
    '瓯': 1,
    '甊': 2,
    '甌': 2,
    '甒': 2,
    '甖': 2,
    '產': 2,
    '産': 2,
    '电': 3,
    '画': 3,
    '畅': 1,
    '畝': 2,
    '畢': 2,
    '畫': 2,
    '異': 2,
    '畴': 1,
    '當': 2,
    '疇': 2,
    '疊': 2,
    '疖': 1,
    '疗': 1,
    '疟': 1,
    '疠': 1,
    '疡': 1,
    '疬': 1,
    '疭': 1,
    '疮': 1,
    '疯': 1,
    '疱': 3,
    '疴': 3,
    '症': 3,
    '痈': 1,
    '痉': 1,
    '痒': 3,
    '痖': 1,
    '痙': 2,
    '痨': 1,
    '痪': 1,
    '痫': 1,
    '痮': 2,
    '痾': 2,
    '瘂': 2,
    '瘅': 1,
    '瘆': 1,
    '瘋': 2,
    '瘍': 2,
    '瘑': 2,
    '瘒': 2,
    '瘓': 2,
    '瘗': 1,
    '瘘': 3,
    '瘞': 2,
    '瘡': 2,
    '瘧': 2,
    '瘪': 1,
    '瘫': 1,
    '瘮': 2,
    '瘱': 2,
    '瘲': 2,
    '瘺': 2,
    '瘻': 2,
    '瘾': 1,
    '瘿': 1,
    '療': 2,
    '癆': 2,
    '癇': 2,
    '癈': 2,
    '癉': 2,
    '癎': 2,
    '癐': 2,
    '癘': 2,
    '癞': 1,
    '癟': 2,
    '癠': 2,
    '癢': 2,
    '癣': 1,
    '癤': 2,
    '癥': 2,
    '癧': 2,
    '癩': 2,
    '癪': 2,
    '癫': 1,
    '癬': 2,
    '癭': 2,
    '癮': 2,
    '癰': 2,
    '癱': 2,
    '癲': 2,
    '癴': 2,
    '發': 2,
    '皑': 1,
    '皚': 2,
    '皟': 2,
    '皪': 2,
    '皰': 2,
    '皱': 3,
    '皲': 1,
    '皸': 2,
    '皺': 2,
    '皾': 2,
    '盏': 1,
    '盐': 1,
    '监': 1,
    '盖': 3,
    '盗': 1,
    '盘': 1,
    '盜': 2,
    '盞': 2,
    '盡': 2,
    '監': 2,
    '盤': 2,
    '盧': 2,
    '盨': 2,
    '盪': 2,
    '眍': 1,
    '眥': 2,
    '眦': 3,
    '眬': 1,
    '眾': 2,
    '着': 3,
    '睁': 1,
    '睍': 2,
    '睏': 2,
    '睐': 1,
    '睑': 1,
    '睔': 2,
    '睜': 2,
    '睞': 2,
    '睪': 2,
    '睴': 2,
    '瞆': 1,
    '瞒': 1,
    '瞓': 2,
    '瞘': 2,
    '瞛': 2,
    '瞜': 2,
    '瞞': 2,
    '瞡': 2,
    '瞤': 2,
    '瞩': 1,
    '瞭': 3,
    '瞯': 2,
    '瞱': 2,
    '瞶': 2,
    '瞷': 2,
    '瞼': 2,
    '矇': 2,
    '矉': 2,
    '矊': 2,
    '矑': 2,
    '矓': 2,
    '矕': 2,
    '矖': 2,
    '矘': 2,
    '矚': 2,
    '矫': 3,
    '矯': 2,
    '矲': 2,
    '矶': 1,
    '矾': 1,
    '矿': 1,
    '砀': 1,
    '码': 1,
    '砖': 1,
    '砗': 1,
    '砚': 1,
    '砜': 1,
    '砺': 1,
    '砻': 1,
    '砾': 1,
    '础': 1,
    '硁': 1,
    '硃': 2,
    '硕': 1,
    '硖': 1,
    '硗': 1,
    '硙': 1,
    '硚': 1,
    '硜': 2,
    '硤': 2,
    '硨': 2,
    '确': 3,
    '硯': 2,
    '硵': 1,
    '硷': 1,
    '碍': 3,
    '碙': 2,
    '碛': 1,
    '碜': 1,
    '碢': 2,
    '碩': 2,
    '碭': 2,
    '碸': 2,
    '確': 2,
    '碼': 2,
    '碽': 2,
    '磑': 2,
    '磒': 2,
    '磚': 2,
    '磠': 2,
    '磣': 2,
    '磧': 2,
    '磯': 2,
    '磱': 2,
    '磵': 2,
    '磽': 2,
    '磾': 2,
    '礄': 2,
    '礆': 2,
    '礋': 2,
    '礎': 2,
    '礏': 2,
    '礐': 2,
    '礒': 2,
    '礙': 2,
    '礚': 2,
    '礛': 2,
    '礥': 2,
    '礦': 2,
    '礩': 2,
    '礪': 2,
    '礫': 2,
    '礬': 2,
    '礮': 2,
    '礰': 2,
    '礱': 2,
    '礲': 2,
    '礹': 2,
    '礼': 3,
    '祃': 1,
    '祎': 1,
    '祢': 3,
    '祯': 1,
    '祷': 3,
    '祸': 1,
    '祿': 2,
    '禀': 3,
    '禄': 1,
    '禅': 1,
    '禍': 2,
    '禎': 2,
    '禓': 2,
    '禕': 2,
    '禜': 2,
    '禡': 2,
    '禦': 2,
    '禪': 2,
    '禬': 2,
    '禮': 2,
    '禯': 2,
    '禰': 2,
    '禱': 2,
    '禵': 2,
    '离': 1,
    '禿': 2,
    '秃': 3,
    '秆': 3,
    '秈': 2,
    '秋': 3,
    '种': 3,
    '积': 1,
    '称': 3,
    '秽': 1,
    '秾': 1,
    '稅': 2,
    '稆': 1,
    '稈': 2,
    '税': 1,
    '稏': 2,
    '稟': 2,
    '稣': 1,
    '稦': 2,
    '種': 2,
    '稱': 2,
    '稳': 3,
    '穀': 2,
    '穇': 2,
    '穌': 2,
    '積': 2,
    '穎': 2,
    '穑': 1,
    '穖': 2,
    '穠': 2,
    '穡': 2,
    '穢': 2,
    '穧': 2,
    '穨': 2,
    '穩': 2,
    '穫': 2,
    '穬': 2,
    '穭': 2,
    '穷': 3,
    '窃': 3,
    '窍': 1,
    '窎': 1,
    '窑': 1,
    '窜': 1,
    '窝': 1,
    '窥': 1,
    '窦': 1,
    '窩': 2,
    '窪': 2,
    '窭': 1,
    '窮': 2,
    '窯': 2,
    '窱': 2,
    '窵': 2,
    '窶': 2,
    '窺': 2,
    '竀': 2,
    '竄': 2,
    '竅': 2,
    '竇': 2,
    '竈': 2,
    '竉': 2,
    '竊': 2,
    '竖': 1,
    '竞': 1,
    '竪': 2,
    '竱': 2,
    '競': 2,
    '笃': 1,
    '笋': 3,
    '笔': 3,
    '笕': 1,
    '笺': 1,
    '笼': 1,
    '笾': 1,
    '筆': 2,
    '筍': 2,
    '筑': 3,
    '筚': 1,
    '筛': 1,
    '筜': 1,
    '筝': 1,
    '筧': 2,
    '筴': 2,
    '筹': 1,
    '筼': 1,
    '签': 1,
    '简': 1,
    '箂': 2,
    '箋': 2,
    '箏': 2,
    '箓': 1,
    '箦': 1,
    '箧': 1,
    '箨': 1,
    '箩': 3,
    '箪': 1,
    '箫': 1,
    '箹': 2,
    '節': 2,
    '範': 2,
    '築': 2,
    '篋': 2,
    '篑': 1,
    '篓': 3,
    '篔': 2,
    '篘': 2,
    '篢': 2,
    '篤': 2,
    '篩': 2,
    '篮': 1,
    '篯': 1,
    '篱': 3,
    '篳': 2,
    '篵': 2,
    '篸': 2,
    '篿': 2,
    '簀': 2,
    '簂': 2,
    '簍': 2,
    '簖': 1,
    '簜': 2,
    '簞': 2,
    '簡': 2,
    '簢': 2,
    '簣': 2,
    '簥': 2,
    '簫': 2,
    '簵': 2,
    '簹': 2,
    '簻': 2,
    '簽': 2,
    '簾': 2,
    '籁': 1,
    '籃': 2,
    '籋': 2,
    '籌': 2,
    '籔': 2,
    '籙': 2,
    '籚': 2,
    '籛': 2,
    '籜': 2,
    '籟': 2,
    '籠': 2,
    '籣': 2,
    '籤': 2,
    '籦': 2,
    '籩': 2,
    '籪': 2,
    '籫': 2,
    '籬': 2,
    '籭': 2,
    '籮': 2,
    '籯': 2,
    '籲': 2,
    '籴': 3,
    '类': 1,
    '籼': 1,
    '粜': 3,
    '粝': 1,
    '粤': 1,
    '粪': 1,
    '粮': 3,
    '粯': 2,
    '粵': 2,
    '粻': 2,
    '糁': 1,
    '糇': 3,
    '糝': 2,
    '糞': 2,
    '糧': 2,
    '糮': 2,
    '糰': 2,
    '糲': 2,
    '糴': 2,
    '糶': 2,
    '糷': 2,
    '糹': 2,
    '糺': 2,
    '系': 3,
    '糽': 2,
    '糾': 2,
    '紀': 2,
    '紁': 2,
    '紂': 2,
    '紃': 2,
    '約': 2,
    '紅': 2,
    '紆': 2,
    '紇': 2,
    '紈': 2,
    '紉': 2,
    '紋': 2,
    '紌': 2,
    '納': 2,
    '紐': 2,
    '紑': 2,
    '紒': 2,
    '紓': 2,
    '純': 2,
    '紕': 2,
    '紖': 2,
    '紗': 2,
    '紘': 2,
    '紙': 2,
    '級': 2,
    '紛': 2,
    '紜': 2,
    '紝': 2,
    '紞': 2,
    '紟': 2,
    '紡': 2,
    '紧': 1,
    '紨': 2,
    '紩': 2,
    '紬': 2,
    '紭': 2,
    '累': 3,
    '細': 2,
    '紱': 2,
    '紲': 2,
    '紳': 2,
    '紵': 2,
    '紶': 2,
    '紸': 2,
    '紹': 2,
    '紺': 2,
    '紼': 2,
    '紽': 2,
    '紾': 2,
    '紿': 2,
    '絀': 2,
    '絁': 2,
    '終': 2,
    '絃': 2,
    '組': 2,
    '絅': 2,
    '絆': 2,
    '絇': 2,
    '絍': 2,
    '絎': 2,
    '結': 2,
    '絑': 2,
    '絓': 2,
    '絕': 2,
    '絖': 2,
    '絘': 2,
    '絙': 2,
    '絚': 2,
    '絛': 2,
    '絝': 2,
    '絞': 2,
    '絟': 2,
    '絠': 2,
    '絡': 2,
    '絢': 2,
    '絣': 2,
    '絤': 2,
    '絥': 2,
    '給': 2,
    '絧': 2,
    '絨': 2,
    '絪': 2,
    '絯': 2,
    '絰': 2,
    '統': 2,
    '絲': 2,
    '絳': 2,
    '絶': 2,
    '絷': 1,
    '絸': 2,
    '絹': 2,
    '絺': 2,
    '絻': 2,
    '絼': 2,
    '絽': 2,
    '絾': 2,
    '絿': 2,
    '綀': 2,
    '綁': 2,
    '綃': 2,
    '綄': 2,
    '綅': 2,
    '綆': 2,
    '綇': 2,
    '綈': 2,
    '綉': 2,
    '綊': 2,
    '綋': 2,
    '綌': 2,
    '綍': 2,
    '綎': 2,
    '綏': 2,
    '綐': 2,
    '經': 2,
    '綕': 2,
    '綖': 2,
    '綘': 2,
    '綜': 2,
    '綝': 2,
    '綞': 2,
    '綟': 2,
    '綠': 2,
    '綡': 2,
    '綢': 2,
    '綣': 2,
    '綧': 2,
    '綪': 2,
    '綫': 2,
    '綬': 2,
    '維': 2,
    '綯': 2,
    '綰': 2,
    '綱': 2,
    '網': 2,
    '綳': 2,
    '綴': 2,
    '綵': 2,
    '綷': 2,
    '綸': 2,
    '綹': 2,
    '綺': 2,
    '綻': 2,
    '綼': 2,
    '綽': 2,
    '綾': 2,
    '綿': 2,
    '緀': 2,
    '緁': 2,
    '緂': 2,
    '緄': 2,
    '緅': 2,
    '緆': 2,
    '緇': 2,
    '緉': 2,
    '緊': 2,
    '緋': 2,
    '緌': 2,
    '緍': 2,
    '緎': 2,
    '総': 2,
    '緑': 2,
    '緒': 2,
    '緓': 2,
    '緔': 2,
    '緗': 2,
    '緘': 2,
    '緙': 2,
    '線': 2,
    '緛': 2,
    '緝': 2,
    '緞': 2,
    '緟': 2,
    '締': 2,
    '緡': 2,
    '緢': 2,
    '緣': 2,
    '緤': 2,
    '緦': 2,
    '緧': 2,
    '編': 2,
    '緩': 2,
    '緪': 2,
    '緫': 2,
    '緬': 2,
    '緮': 2,
    '緯': 2,
    '緰': 2,
    '緱': 2,
    '緲': 2,
    '練': 2,
    '緵': 2,
    '緶': 2,
    '緷': 2,
    '緸': 2,
    '緹': 2,
    '緺': 2,
    '緻': 2,
    '緼': 2,
    '縈': 2,
    '縉': 2,
    '縊': 2,
    '縋': 2,
    '縌': 2,
    '縍': 2,
    '縎': 2,
    '縐': 2,
    '縑': 2,
    '縒': 2,
    '縓': 2,
    '縕': 2,
    '縖': 2,
    '縗': 2,
    '縚': 2,
    '縛': 2,
    '縜': 2,
    '縝': 2,
    '縞': 2,
    '縟': 2,
    '縡': 2,
    '縣': 2,
    '縧': 2,
    '縩': 2,
    '縪': 2,
    '縫': 2,
    '縬': 2,
    '縭': 2,
    '縮': 2,
    '縯': 2,
    '縰': 2,
    '縱': 2,
    '縲': 2,
    '縳': 2,
    '縴': 2,
    '縵': 2,
    '縶': 2,
    '縷': 2,
    '縸': 2,
    '縹': 2,
    '縺': 2,
    '縼': 2,
    '總': 2,
    '績': 2,
    '縿': 2,
    '繀': 2,
    '繂': 2,
    '繃': 2,
    '繅': 2,
    '繆': 2,
    '繈': 2,
    '繎': 2,
    '繏': 2,
    '繐': 2,
    '繑': 2,
    '繒': 2,
    '繓': 2,
    '織': 2,
    '繕': 2,
    '繖': 2,
    '繗': 2,
    '繘': 2,
    '繙': 2,
    '繚': 2,
    '繜': 2,
    '繞': 2,
    '繟': 2,
    '繡': 2,
    '繢': 2,
    '繣': 2,
    '繨': 2,
    '繩': 2,
    '繪': 2,
    '繫': 2,
    '繬': 2,
    '繭': 2,
    '繮': 2,
    '繯': 2,
    '繰': 2,
    '繲': 2,
    '繳': 2,
    '繵': 2,
    '繶': 2,
    '繷': 2,
    '繸': 2,
    '繹': 2,
    '繻': 2,
    '繼': 2,
    '繽': 2,
    '繾': 2,
    '繿': 2,
    '纀': 2,
    '纁': 2,
    '纃': 2,
    '纆': 2,
    '纇': 2,
    '纈': 2,
    '纊': 2,
    '纋': 2,
    '續': 2,
    '纍': 2,
    '纏': 2,
    '纑': 2,
    '纓': 2,
    '纔': 2,
    '纕': 2,
    '纖': 2,
    '纗': 2,
    '纘': 2,
    '纚': 2,
    '纜': 2,
    '纟': 1,
    '纠': 1,
    '纡': 1,
    '红': 1,
    '纣': 1,
    '纤': 1,
    '纥': 1,
    '约': 1,
    '级': 1,
    '纨': 1,
    '纩': 1,
    '纪': 1,
    '纫': 1,
    '纬': 1,
    '纭': 1,
    '纮': 1,
    '纯': 1,
    '纰': 1,
    '纱': 1,
    '纲': 1,
    '纳': 1,
    '纴': 1,
    '纵': 1,
    '纶': 1,
    '纷': 1,
    '纸': 1,
    '纹': 1,
    '纺': 1,
    '纻': 1,
    '纼': 1,
    '纽': 1,
    '纾': 1,
    '线': 1,
    '绀': 1,
    '绁': 1,
    '绂': 1,
    '练': 1,
    '组': 1,
    '绅': 1,
    '细': 1,
    '织': 1,
    '终': 1,
    '绉': 1,
    '绊': 1,
    '绋': 1,
    '绌': 1,
    '绍': 1,
    '绎': 1,
    '经': 1,
    '绐': 1,
    '绑': 1,
    '绒': 1,
    '结': 1,
    '绔': 1,
    '绕': 1,
    '绖': 1,
    '绗': 1,
    '绘': 1,
    '给': 1,
    '绚': 1,
    '绛': 1,
    '络': 1,
    '绝': 1,
    '绞': 1,
    '统': 1,
    '绠': 1,
    '绡': 1,
    '绢': 1,
    '绣': 1,
    '绤': 1,
    '绥': 1,
    '绦': 1,
    '继': 1,
    '绨': 1,
    '绩': 1,
    '绪': 1,
    '绫': 1,
    '绬': 1,
    '续': 1,
    '绮': 1,
    '绯': 1,
    '绰': 1,
    '绱': 1,
    '绲': 1,
    '绳': 1,
    '维': 1,
    '绵': 1,
    '绶': 1,
    '绷': 1,
    '绸': 1,
    '绹': 1,
    '绺': 1,
    '绻': 1,
    '综': 1,
    '绽': 1,
    '绾': 1,
    '绿': 1,
    '缀': 1,
    '缁': 1,
    '缂': 1,
    '缃': 1,
    '缄': 1,
    '缅': 1,
    '缆': 1,
    '缇': 1,
    '缈': 1,
    '缉': 1,
    '缊': 1,
    '缋': 1,
    '缌': 1,
    '缍': 1,
    '缎': 1,
    '缏': 1,
    '缐': 1,
    '缑': 1,
    '缒': 1,
    '缓': 1,
    '缔': 1,
    '缕': 1,
    '编': 1,
    '缗': 1,
    '缘': 1,
    '缙': 1,
    '缚': 1,
    '缛': 1,
    '缜': 1,
    '缝': 1,
    '缞': 1,
    '缟': 1,
    '缠': 1,
    '缡': 1,
    '缢': 1,
    '缣': 1,
    '缤': 1,
    '缥': 1,
    '缦': 1,
    '缧': 1,
    '缨': 1,
    '缩': 1,
    '缪': 1,
    '缫': 1,
    '缬': 1,
    '缭': 1,
    '缮': 1,
    '缯': 1,
    '缰': 1,
    '缱': 1,
    '缲': 1,
    '缳': 1,
    '缴': 1,
    '缵': 1,
    '缽': 2,
    '罂': 1,
    '罃': 2,
    '罆': 2,
    '罈': 2,
    '罌': 2,
    '罎': 2,
    '罏': 2,
    '网': 3,
    '罗': 3,
    '罚': 1,
    '罢': 3,
    '罰': 2,
    '罴': 1,
    '罵': 2,
    '罷': 2,
    '罼': 2,
    '羁': 1,
    '羂': 2,
    '羅': 2,
    '羆': 2,
    '羈': 2,
    '羋': 2,
    '羟': 1,
    '羥': 2,
    '義': 2,
    '羵': 2,
    '習': 2,
    '翘': 1,
    '翙': 1,
    '翚': 1,
    '翜': 2,
    '翬': 2,
    '翹': 2,
    '翽': 2,
    '翿': 2,
    '耢': 1,
    '耧': 1,
    '耬': 2,
    '耮': 2,
    '耸': 1,
    '耻': 3,
    '聂': 1,
    '聋': 1,
    '职': 3,
    '聍': 1,
    '联': 3,
    '聖': 2,
    '聞': 2,
    '聩': 1,
    '聪': 1,
    '聯': 2,
    '聰': 2,
    '聲': 2,
    '聳': 2,
    '聵': 2,
    '聶': 2,
    '職': 2,
    '聹': 2,
    '聻': 2,
    '聽': 2,
    '聾': 2,
    '肃': 1,
    '肅': 2,
    '肠': 1,
    '肤': 1,
    '肮': 3,
    '肴': 3,
    '肾': 1,
    '肿': 1,
    '胀': 1,
    '胁': 1,
    '胆': 3,
    '胜': 3,
    '胡': 3,
    '胧': 1,
    '胨': 1,
    '胪': 1,
    '胫': 1,
    '胶': 1,
    '脅': 2,
    '脈': 2,
    '脉': 3,
    '脍': 3,
    '脏': 1,
    '脐': 1,
    '脑': 1,
    '脓': 1,
    '脔': 3,
    '脚': 3,
    '脛': 2,
    '脥': 2,
    '脫': 2,
    '脱': 1,
    '脶': 1,
    '脸': 1,
    '脹': 2,
    '腊': 3,
    '腎': 2,
    '腖': 2,
    '腘': 1,
    '腡': 2,
    '腦': 2,
    '腪': 2,
    '腫': 2,
    '腭': 3,
    '腳': 2,
    '腸': 2,
    '腻': 1,
    '腼': 3,
    '腽': 1,
    '腾': 1,
    '膃': 2,
    '膋': 2,
    '膑': 3,
    '膒': 2,
    '膕': 2,
    '膚': 2,
    '膞': 2,
    '膠': 2,
    '膢': 2,
    '膩': 2,
    '膮': 2,
    '膴': 2,
    '膶': 2,
    '膷': 2,
    '膹': 2,
    '膽': 2,
    '膾': 2,
    '膿': 2,
    '臇': 2,
    '臉': 2,
    '臍': 2,
    '臏': 2,
    '臗': 2,
    '臘': 2,
    '臚': 2,
    '臜': 1,
    '臟': 2,
    '臠': 2,
    '臡': 2,
    '臢': 2,
    '臤': 3,
    '臨': 2,
    '致': 3,
    '臺': 2,
    '舆': 1,
    '與': 2,
    '興': 2,
    '舉': 2,
    '舊': 2,
    '舍': 3,
    '舣': 1,
    '舰': 1,
    '舱': 1,
    '舻': 1,
    '艙': 2,
    '艛': 2,
    '艜': 2,
    '艤': 2,
    '艦': 2,
    '艫': 2,
    '艭': 2,
    '艰': 1,
    '艱': 2,
    '艳': 3,
    '艷': 2,
    '艺': 1,
    '节': 1,
    '芈': 1,
    '芗': 1,
    '芜': 1,
    '芦': 3,
    '芸': 3,
    '芻': 2,
    '苁': 1,
    '苇': 1,
    '苈': 1,
    '苋': 1,
    '苌': 1,
    '苍': 1,
    '苎': 1,
    '苏': 3,
    '苧': 2,
    '苹': 3,
    '范': 3,
    '茎': 1,
    '茏': 1,
    '茑': 1,
    '茔': 1,
    '茕': 1,
    '茧': 1,
    '茲': 2,
    '荆': 3,
    '荊': 2,
    '荐': 3,
    '荙': 1,
    '荚': 1,
    '荛': 1,
    '荜': 1,
    '荝': 1,
    '荞': 1,
    '荟': 1,
    '荠': 1,
    '荡': 1,
    '荣': 3,
    '荤': 1,
    '荥': 1,
    '荦': 1,
    '荧': 1,
    '荨': 1,
    '荩': 1,
    '荪': 1,
    '荫': 1,
    '荬': 1,
    '荭': 1,
    '荮': 1,
    '药': 1,
    '莅': 3,
    '莊': 2,
    '莖': 2,
    '莢': 2,
    '莧': 2,
    '莱': 1,
    '莲': 1,
    '莳': 1,
    '莴': 1,
    '莶': 1,
    '获': 1,
    '莸': 1,
    '莹': 1,
    '莺': 1,
    '莼': 1,
    '菕': 2,
    '華': 2,
    '萇': 2,
    '萊': 2,
    '萚': 1,
    '萝': 3,
    '萤': 1,
    '营': 1,
    '萦': 1,
    '萧': 1,
    '萨': 1,
    '萬': 2,
    '萯': 2,
    '萴': 2,
    '萵': 2,
    '葉': 2,
    '葒': 2,
    '著': 3,
    '葝': 2,
    '葤': 2,
    '葦': 2,
    '葯': 2,
    '葱': 3,
    '葷': 2,
    '葻': 2,
    '蒇': 1,
    '蒉': 1,
    '蒋': 1,
    '蒌': 1,
    '蒍': 2,
    '蒏': 1,
    '蒒': 2,
    '蒓': 2,
    '蒔': 2,
    '蒙': 3,
    '蒞': 2,
    '蒭': 2,
    '蒳': 2,
    '蒶': 2,
    '蒼': 2,
    '蓀': 2,
    '蓋': 2,
    '蓝': 1,
    '蓟': 1,
    '蓠': 1,
    '蓣': 1,
    '蓥': 1,
    '蓦': 1,
    '蓮': 2,
    '蓯': 2,
    '蓲': 2,
    '蓴': 2,
    '蓽': 2,
    '蔂': 3,
    '蔄': 2,
    '蔎': 2,
    '蔑': 3,
    '蔔': 2,
    '蔞': 2,
    '蔠': 2,
    '蔣': 2,
    '蔥': 2,
    '蔦': 2,
    '蔪': 2,
    '蔭': 2,
    '蔮': 2,
    '蔯': 2,
    '蔱': 2,
    '蔷': 1,
    '蔹': 1,
    '蔺': 1,
    '蔼': 1,
    '蔿': 2,
    '蕁': 2,
    '蕄': 2,
    '蕆': 2,
    '蕎': 2,
    '蕑': 2,
    '蕒': 2,
    '蕓': 2,
    '蕕': 2,
    '蕘': 2,
    '蕝': 2,
    '蕟': 2,
    '蕡': 2,
    '蕢': 2,
    '蕧': 2,
    '蕩': 2,
    '蕪': 2,
    '蕭': 2,
    '蕰': 1,
    '蕲': 1,
    '蕳': 2,
    '蕴': 1,
    '蕷': 2,
    '蕽': 2,
    '薀': 2,
    '薆': 2,
    '薈': 2,
    '薉': 2,
    '薊': 2,
    '薋': 2,
    '薌': 2,
    '薑': 2,
    '薔': 2,
    '薖': 2,
    '薘': 2,
    '薟': 2,
    '薠': 2,
    '薦': 2,
    '薩': 2,
    '薮': 1,
    '薱': 2,
    '薲': 2,
    '薳': 2,
    '薴': 2,
    '薵': 2,
    '薺': 2,
    '藇': 2,
    '藉': 3,
    '藍': 2,
    '藎': 2,
    '藓': 1,
    '藖': 2,
    '藘': 2,
    '藚': 2,
    '藝': 2,
    '藣': 2,
    '藥': 2,
    '藪': 2,
    '藬': 2,
    '藭': 2,
    '藰': 2,
    '藴': 2,
    '藶': 2,
    '藷': 2,
    '藹': 2,
    '藺': 2,
    '藾': 2,
    '蘀': 2,
    '蘄': 2,
    '蘆': 2,
    '蘇': 2,
    '蘈': 2,
    '蘊': 2,
    '蘋': 2,
    '蘖': 3,
    '蘚': 2,
    '蘞': 2,
    '蘟': 2,
    '蘡': 2,
    '蘢': 2,
    '蘫': 2,
    '蘬': 2,
    '蘭': 2,
    '蘱': 2,
    '蘵': 2,
    '蘹': 2,
    '蘺': 2,
    '蘿': 2,
    '虅': 2,
    '虆': 2,
    '虉': 2,
    '虏': 1,
    '虑': 1,
    '處': 2,
    '虚': 1,
    '虛': 2,
    '虜': 2,
    '號': 2,
    '虦': 2,
    '虧': 2,
    '虫': 3,
    '虬': 3,
    '虮': 1,
    '虯': 2,
    '虽': 1,
    '虾': 3,
    '虿': 1,
    '蚀': 1,
    '蚁': 3,
    '蚂': 1,
    '蚃': 1,
    '蚕': 3,
    '蚬': 1,
    '蛊': 1,
    '蛎': 1,
    '蛏': 1,
    '蛮': 3,
    '蛰': 3,
    '蛱': 1,
    '蛲': 1,
    '蛳': 1,
    '蛴': 1,
    '蛵': 2,
    '蛺': 2,
    '蛻': 2,
    '蛼': 2,
    '蜆': 2,
    '蜕': 1,
    '蜗': 1,
    '蜡': 3,
    '蜦': 2,
    '蜸': 2,
    '蜽': 2,
    '蝀': 2,
    '蝁': 2,
    '蝇': 1,
    '蝈': 1,
    '蝉': 1,
    '蝕': 2,
    '蝜': 2,
    '蝟': 2,
    '蝦': 2,
    '蝸': 2,
    '蝼': 3,
    '蝾': 1,
    '螀': 1,
    '螄': 2,
    '螘': 2,
    '螞': 2,
    '螢': 2,
    '螨': 1,
    '螮': 2,
    '螴': 2,
    '螹': 2,
    '螻': 2,
    '螿': 2,
    '蟂': 2,
    '蟄': 2,
    '蟈': 2,
    '蟎': 2,
    '蟏': 1,
    '蟘': 2,
    '蟜': 2,
    '蟡': 2,
    '蟣': 2,
    '蟦': 2,
    '蟬': 2,
    '蟯': 2,
    '蟱': 2,
    '蟲': 2,
    '蟳': 2,
    '蟶': 2,
    '蟷': 2,
    '蟻': 2,
    '蟽': 2,
    '蠀': 2,
    '蠁': 2,
    '蠅': 2,
    '蠆': 2,
    '蠈': 2,
    '蠌': 2,
    '蠐': 2,
    '蠑': 2,
    '蠒': 2,
    '蠙': 2,
    '蠞': 2,
    '蠟': 2,
    '蠣': 2,
    '蠦': 2,
    '蠨': 2,
    '蠪': 2,
    '蠱': 2,
    '蠳': 2,
    '蠶': 2,
    '蠻': 2,
    '蠾': 2,
    '衅': 3,
    '衆': 2,
    '衊': 2,
    '術': 2,
    '衔': 1,
    '衕': 2,
    '衚': 2,
    '衛': 2,
    '衝': 2,
    '补': 3,
    '表': 3,
    '衬': 1,
    '衮': 3,
    '衹': 2,
    '袄': 3,
    '袅': 1,
    '袆': 1,
    '袜': 3,
    '袞': 2,
    '袭': 1,
    '袯': 1,
    '装': 1,
    '裆': 1,
    '裈': 1,
    '裊': 2,
    '裌': 2,
    '裏': 2,
    '補': 2,
    '裝': 2,
    '裡': 3,
    '裢': 1,
    '裣': 1,
    '裤': 1,
    '裥': 1,
    '裲': 2,
    '製': 2,
    '複': 2,
    '褌': 2,
    '褘': 2,
    '褛': 1,
    '褝': 1,
    '褭': 2,
    '褲': 2,
    '褳': 2,
    '褴': 1,
    '褸': 2,
    '褺': 2,
    '褻': 2,
    '襀': 2,
    '襂': 2,
    '襇': 2,
    '襌': 2,
    '襏': 2,
    '襓': 2,
    '襕': 1,
    '襖': 2,
    '襗': 2,
    '襘': 2,
    '襛': 2,
    '襝': 2,
    '襠': 2,
    '襤': 2,
    '襨': 2,
    '襪': 2,
    '襬': 2,
    '襭': 2,
    '襯': 2,
    '襰': 2,
    '襱': 2,
    '襲': 2,
    '襴': 2,
    '襵': 2,
    '襸': 2,
    '襹': 2,
    '襼': 2,
    '覆': 3,
    '見': 2,
    '覎': 2,
    '規': 2,
    '覒': 2,
    '覓': 2,
    '覕': 2,
    '視': 2,
    '覗': 2,
    '覘': 2,
    '覛': 2,
    '覜': 2,
    '覟': 2,
    '覠': 2,
    '覡': 2,
    '覢': 2,
    '覤': 2,
    '覥': 2,
    '覦': 2,
    '覩': 2,
    '親': 2,
    '覬': 2,
    '覭': 2,
    '覮': 2,
    '覯': 2,
    '覰': 2,
    '覲': 2,
    '覴': 2,
    '覶': 2,
    '覷': 2,
    '覸': 2,
    '覹': 2,
    '覺': 2,
    '覻': 2,
    '覼': 2,
    '覽': 2,
    '覿': 2,
    '觀': 2,
    '见': 1,
    '观': 1,
    '觃': 1,
    '规': 1,
    '觅': 1,
    '视': 1,
    '觇': 1,
    '览': 1,
    '觉': 1,
    '觊': 1,
    '觋': 1,
    '觌': 1,
    '觍': 1,
    '觎': 1,
    '觏': 1,
    '觐': 1,
    '觑': 1,
    '觞': 1,
    '触': 1,
    '觯': 1,
    '觴': 2,
    '觶': 2,
    '觷': 2,
    '觸': 2,
    '觹': 2,
    '觻': 2,
    '觽': 2,
    '訁': 2,
    '訂': 2,
    '訃': 2,
    '訆': 2,
    '計': 2,
    '訊': 2,
    '訌': 2,
    '討': 2,
    '訏': 2,
    '訐': 2,
    '訑': 2,
    '訒': 2,
    '訓': 2,
    '訕': 2,
    '訖': 2,
    '託': 2,
    '記': 2,
    '訚': 1,
    '訛': 2,
    '訜': 2,
    '訝': 2,
    '訞': 2,
    '訟': 2,
    '訢': 2,
    '訣': 2,
    '訥': 2,
    '訦': 2,
    '訧': 2,
    '訨': 2,
    '訩': 2,
    '訪': 2,
    '訬': 2,
    '設': 2,
    '訰': 2,
    '許': 2,
    '訴': 2,
    '訶': 2,
    '訸': 2,
    '訹': 2,
    '診': 2,
    '註': 2,
    '訽': 2,
    '詀': 2,
    '詁': 2,
    '詃': 2,
    '詄': 2,
    '詅': 2,
    '詆': 2,
    '詇': 2,
    '詉': 2,
    '詊': 2,
    '詌': 2,
    '詍': 2,
    '詎': 2,
    '詏': 2,
    '詐': 2,
    '詑': 2,
    '詒': 2,
    '詓': 2,
    '詔': 2,
    '評': 2,
    '詖': 2,
    '詗': 2,
    '詘': 2,
    '詛': 2,
    '詜': 2,
    '詝': 2,
    '詞': 2,
    '詟': 1,
    '詠': 2,
    '詡': 2,
    '詢': 2,
    '詣': 2,
    '詥': 2,
    '試': 2,
    '詨': 2,
    '詩': 2,
    '詪': 2,
    '詫': 2,
    '詬': 2,
    '詭': 2,
    '詮': 2,
    '詯': 2,
    '詰': 2,
    '話': 2,
    '該': 2,
    '詳': 2,
    '詴': 2,
    '詵': 2,
    '詶': 2,
    '詷': 2,
    '詺': 2,
    '詻': 2,
    '詼': 2,
    '詿': 2,
    '誁': 2,
    '誂': 2,
    '誃': 2,
    '誄': 2,
    '誅': 2,
    '誆': 2,
    '誇': 2,
    '誉': 3,
    '誊': 1,
    '誋': 2,
    '誌': 2,
    '認': 2,
    '誎': 2,
    '誏': 2,
    '誐': 2,
    '誑': 2,
    '誒': 2,
    '誔': 2,
    '誕': 2,
    '誗': 2,
    '誘': 2,
    '誙': 2,
    '誚': 2,
    '誜': 2,
    '語': 2,
    '誠': 2,
    '誡': 2,
    '誣': 2,
    '誤': 2,
    '誥': 2,
    '誦': 2,
    '誧': 2,
    '誨': 2,
    '說': 2,
    '誫': 2,
    '説': 2,
    '誰': 2,
    '課': 2,
    '誳': 2,
    '誴': 2,
    '誶': 2,
    '誷': 2,
    '誹': 2,
    '誺': 2,
    '誻': 2,
    '誼': 2,
    '誽': 2,
    '誾': 2,
    '調': 2,
    '諁': 2,
    '諂': 2,
    '諃': 2,
    '諄': 2,
    '諆': 2,
    '談': 2,
    '諈': 2,
    '諉': 2,
    '請': 2,
    '諌': 2,
    '諍': 2,
    '諎': 2,
    '諏': 2,
    '諑': 2,
    '諒': 2,
    '諓': 2,
    '諔': 2,
    '諕': 2,
    '論': 2,
    '諗': 2,
    '諛': 2,
    '諜': 2,
    '諝': 2,
    '諞': 2,
    '諟': 2,
    '諠': 2,
    '諢': 2,
    '諣': 2,
    '諤': 2,
    '諥': 2,
    '諦': 2,
    '諧': 2,
    '諫': 2,
    '諭': 2,
    '諮': 2,
    '諯': 2,
    '諰': 2,
    '諱': 2,
    '諲': 2,
    '諳': 2,
    '諴': 2,
    '諶': 2,
    '諷': 2,
    '諸': 2,
    '諹': 2,
    '諺': 2,
    '諻': 2,
    '諼': 2,
    '諾': 2,
    '謀': 2,
    '謁': 2,
    '謂': 2,
    '謄': 2,
    '謅': 2,
    '謆': 2,
    '謉': 2,
    '謊': 2,
    '謋': 2,
    '謌': 2,
    '謍': 2,
    '謎': 2,
    '謏': 2,
    '謐': 2,
    '謑': 2,
    '謔': 2,
    '謖': 2,
    '謗': 2,
    '謙': 2,
    '謚': 2,
    '講': 2,
    '謜': 2,
    '謝': 2,
    '謞': 2,
    '謟': 2,
    '謠': 2,
    '謡': 2,
    '謣': 2,
    '謥': 2,
    '謨': 2,
    '謫': 2,
    '謬': 2,
    '謭': 2,
    '謯': 2,
    '謰': 2,
    '謱': 2,
    '謲': 2,
    '謳': 2,
    '謴': 2,
    '謵': 2,
    '謸': 2,
    '謹': 2,
    '謻': 2,
    '謼': 2,
    '謾': 2,
    '譀': 2,
    '譂': 2,
    '譄': 2,
    '譅': 2,
    '譆': 2,
    '譇': 2,
    '譈': 2,
    '證': 2,
    '譊': 2,
    '譌': 2,
    '譎': 2,
    '譏': 2,
    '譐': 2,
    '譑': 2,
    '譒': 2,
    '譓': 2,
    '譔': 2,
    '譖': 2,
    '識': 2,
    '譙': 2,
    '譚': 2,
    '譜': 2,
    '譞': 2,
    '譟': 2,
    '譠': 2,
    '譡': 2,
    '譨': 2,
    '譩': 2,
    '譫': 2,
    '譯': 2,
    '議': 2,
    '譳': 2,
    '譴': 2,
    '護': 2,
    '譸': 2,
    '譹': 2,
    '譺': 2,
    '譻': 2,
    '譼': 2,
    '譽': 2,
    '譾': 2,
    '譿': 2,
    '讀': 2,
    '讂': 2,
    '讅': 2,
    '讆': 2,
    '讇': 2,
    '讉': 2,
    '變': 2,
    '讋': 2,
    '讌': 2,
    '讎': 2,
    '讑': 2,
    '讒': 2,
    '讓': 2,
    '讔': 2,
    '讕': 2,
    '讖': 2,
    '讘': 2,
    '讙': 2,
    '讚': 2,
    '讛': 2,
    '讜': 2,
    '讝': 2,
    '讞': 2,
    '讟': 2,
    '讠': 1,
    '计': 1,
    '订': 1,
    '讣': 1,
    '认': 1,
    '讥': 1,
    '讦': 1,
    '讧': 1,
    '讨': 1,
    '让': 1,
    '讪': 1,
    '讫': 1,
    '讬': 1,
    '训': 1,
    '议': 1,
    '讯': 1,
    '记': 1,
    '讱': 1,
    '讲': 1,
    '讳': 1,
    '讴': 1,
    '讵': 1,
    '讶': 1,
    '讷': 1,
    '许': 1,
    '讹': 1,
    '论': 1,
    '讻': 1,
    '讼': 1,
    '讽': 1,
    '设': 1,
    '访': 1,
    '诀': 1,
    '证': 1,
    '诂': 1,
    '诃': 1,
    '评': 1,
    '诅': 1,
    '识': 1,
    '诇': 1,
    '诈': 1,
    '诉': 1,
    '诊': 1,
    '诋': 1,
    '诌': 1,
    '词': 1,
    '诎': 1,
    '诏': 1,
    '诐': 1,
    '译': 1,
    '诒': 1,
    '诓': 1,
    '诔': 1,
    '试': 1,
    '诖': 1,
    '诗': 1,
    '诘': 1,
    '诙': 1,
    '诚': 1,
    '诛': 1,
    '诜': 1,
    '话': 1,
    '诞': 1,
    '诟': 1,
    '诠': 1,
    '诡': 1,
    '询': 1,
    '诣': 1,
    '诤': 1,
    '该': 1,
    '详': 1,
    '诧': 1,
    '诨': 1,
    '诩': 1,
    '诪': 1,
    '诫': 1,
    '诬': 1,
    '语': 1,
    '诮': 1,
    '误': 1,
    '诰': 1,
    '诱': 1,
    '诲': 1,
    '诳': 1,
    '说': 1,
    '诵': 1,
    '诶': 1,
    '请': 1,
    '诸': 1,
    '诹': 1,
    '诺': 1,
    '读': 1,
    '诼': 1,
    '诽': 1,
    '课': 1,
    '诿': 1,
    '谀': 1,
    '谁': 1,
    '谂': 1,
    '调': 1,
    '谄': 1,
    '谅': 1,
    '谆': 1,
    '谇': 1,
    '谈': 1,
    '谉': 1,
    '谊': 1,
    '谋': 1,
    '谌': 1,
    '谍': 1,
    '谎': 1,
    '谏': 1,
    '谐': 1,
    '谑': 1,
    '谒': 1,
    '谓': 1,
    '谔': 1,
    '谕': 1,
    '谖': 1,
    '谗': 1,
    '谘': 1,
    '谙': 1,
    '谚': 1,
    '谛': 1,
    '谜': 1,
    '谝': 1,
    '谞': 1,
    '谟': 1,
    '谠': 1,
    '谡': 1,
    '谢': 1,
    '谣': 1,
    '谤': 1,
    '谥': 1,
    '谦': 1,
    '谧': 1,
    '谨': 1,
    '谩': 1,
    '谪': 1,
    '谫': 1,
    '谬': 1,
    '谭': 1,
    '谮': 1,
    '谯': 1,
    '谰': 1,
    '谱': 1,
    '谲': 1,
    '谳': 1,
    '谴': 1,
    '谵': 1,
    '谶': 1,
    '谷': 3,
    '豄': 2,
    '豅': 2,
    '豈': 2,
    '豎': 2,
    '豐': 2,
    '豬': 2,
    '豮': 1,
    '豵': 2,
    '豶': 2,
    '貓': 2,
    '貗': 2,
    '貙': 2,
    '貝': 2,
    '貞': 2,
    '貟': 2,
    '負': 2,
    '財': 2,
    '貢': 2,
    '貣': 2,
    '貤': 2,
    '貦': 2,
    '貧': 2,
    '貨': 2,
    '販': 2,
    '貪': 2,
    '貫': 2,
    '責': 2,
    '貯': 2,
    '貰': 2,
    '貱': 2,
    '貲': 2,
    '貳': 2,
    '貴': 2,
    '貶': 2,
    '買': 2,
    '貸': 2,
    '貺': 2,
    '費': 2,
    '貼': 2,
    '貽': 2,
    '貾': 2,
    '貿': 2,
    '賀': 2,
    '賁': 2,
    '賂': 2,
    '賃': 2,
    '賄': 2,
    '賅': 2,
    '資': 2,
    '賈': 2,
    '賊': 2,
    '賑': 2,
    '賒': 2,
    '賓': 2,
    '賕': 2,
    '賗': 2,
    '賙': 2,
    '賚': 2,
    '賜': 2,
    '賝': 2,
    '賞': 2,
    '賟': 2,
    '賠': 2,
    '賡': 2,
    '賢': 2,
    '賣': 2,
    '賤': 2,
    '賥': 2,
    '賦': 2,
    '賧': 2,
    '賨': 2,
    '質': 2,
    '賫': 2,
    '賬': 2,
    '賭': 2,
    '賮': 2,
    '賰': 2,
    '賴': 2,
    '賵': 2,
    '賶': 2,
    '賸': 2,
    '賹': 2,
    '賺': 2,
    '賻': 2,
    '購': 2,
    '賽': 2,
    '賾': 2,
    '贃': 2,
    '贄': 2,
    '贅': 2,
    '贆': 2,
    '贇': 2,
    '贈': 2,
    '贉': 2,
    '贊': 2,
    '贋': 2,
    '贍': 2,
    '贏': 2,
    '贐': 2,
    '贑': 2,
    '贓': 2,
    '贔': 2,
    '贕': 2,
    '贖': 2,
    '贗': 2,
    '贙': 2,
    '贚': 2,
    '贛': 2,
    '贜': 2,
    '贝': 1,
    '贞': 1,
    '负': 1,
    '贠': 1,
    '贡': 1,
    '财': 1,
    '责': 1,
    '贤': 1,
    '败': 1,
    '账': 1,
    '货': 1,
    '质': 1,
    '贩': 1,
    '贪': 1,
    '贫': 1,
    '贬': 1,
    '购': 1,
    '贮': 1,
    '贯': 1,
    '贰': 1,
    '贱': 1,
    '贲': 1,
    '贳': 1,
    '贴': 1,
    '贵': 1,
    '贶': 1,
    '贷': 1,
    '贸': 1,
    '费': 1,
    '贺': 1,
    '贻': 1,
    '贼': 1,
    '贽': 1,
    '贾': 1,
    '贿': 1,
    '赀': 1,
    '赁': 1,
    '赂': 1,
    '赃': 1,
    '资': 1,
    '赅': 1,
    '赆': 1,
    '赇': 1,
    '赈': 1,
    '赉': 1,
    '赊': 1,
    '赋': 1,
    '赌': 1,
    '赍': 1,
    '赎': 1,
    '赏': 1,
    '赐': 1,
    '赑': 1,
    '赒': 1,
    '赓': 1,
    '赔': 1,
    '赕': 1,
    '赖': 1,
    '赗': 1,
    '赘': 1,
    '赙': 1,
    '赚': 1,
    '赛': 1,
    '赜': 1,
    '赝': 1,
    '赞': 1,
    '赟': 1,
    '赠': 1,
    '赡': 1,
    '赢': 1,
    '赣': 1,
    '赪': 1,
    '赬': 2,
    '赵': 1,
    '赶': 3,
    '趋': 3,
    '趕': 2,
    '趙': 2,
    '趨': 2,
    '趫': 2,
    '趬': 2,
    '趱': 1,
    '趲': 2,
    '趸': 1,
    '跃': 1,
    '跄': 1,
    '跞': 1,
    '跡': 2,
    '践': 1,
    '跶': 1,
    '跷': 1,
    '跸': 1,
    '跹': 1,
    '跻': 1,
    '踊': 3,
    '踌': 1,
    '踐': 2,
    '踚': 2,
    '踪': 3,
    '踬': 1,
    '踯': 1,
    '踴': 2,
    '蹌': 2,
    '蹑': 1,
    '蹒': 1,
    '蹔': 2,
    '蹕': 2,
    '蹛': 2,
    '蹡': 2,
    '蹣': 2,
    '蹤': 2,
    '蹥': 2,
    '蹪': 2,
    '蹰': 3,
    '蹳': 2,
    '蹺': 2,
    '蹻': 2,
    '蹿': 1,
    '躀': 2,
    '躂': 2,
    '躉': 2,
    '躊': 2,
    '躋': 2,
    '躍': 2,
    '躎': 2,
    '躏': 1,
    '躑': 2,
    '躒': 2,
    '躓': 2,
    '躕': 2,
    '躘': 2,
    '躚': 2,
    '躜': 1,
    '躝': 2,
    '躡': 2,
    '躥': 2,
    '躦': 2,
    '躧': 2,
    '躪': 2,
    '躯': 3,
    '軀': 2,
    '軂': 2,
    '軃': 2,
    '軇': 2,
    '軉': 2,
    '車': 2,
    '軋': 2,
    '軌': 2,
    '軍': 2,
    '軎': 2,
    '軏': 2,
    '軑': 2,
    '軒': 2,
    '軓': 2,
    '軔': 2,
    '軕': 2,
    '軖': 2,
    '軗': 2,
    '軘': 2,
    '軚': 2,
    '軛': 2,
    '軜': 2,
    '軝': 2,
    '軞': 2,
    '軟': 2,
    '軤': 2,
    '軥': 2,
    '軧': 2,
    '軨': 2,
    '軫': 2,
    '軬': 2,
    '軮': 2,
    '軯': 2,
    '軱': 2,
    '軲': 2,
    '軳': 2,
    '軵': 2,
    '軷': 2,
    '軸': 2,
    '軹': 2,
    '軺': 2,
    '軻': 2,
    '軼': 2,
    '軾': 2,
    '軿': 2,
    '輀': 2,
    '輁': 2,
    '輂': 2,
    '較': 2,
    '輄': 2,
    '輅': 2,
    '輆': 2,
    '輇': 2,
    '輈': 2,
    '載': 2,
    '輊': 2,
    '輋': 2,
    '輐': 2,
    '輑': 2,
    '輒': 2,
    '輓': 2,
    '輔': 2,
    '輕': 2,
    '輖': 2,
    '輗': 2,
    '輘': 2,
    '輙': 2,
    '輚': 2,
    '輛': 2,
    '輜': 2,
    '輝': 2,
    '輞': 2,
    '輟': 2,
    '輠': 2,
    '輡': 2,
    '輢': 2,
    '輣': 2,
    '輤': 2,
    '輥': 2,
    '輦': 2,
    '輨': 2,
    '輩': 2,
    '輪': 2,
    '輫': 2,
    '輬': 2,
    '輮': 2,
    '輯': 2,
    '輲': 2,
    '輳': 2,
    '輴': 2,
    '輵': 2,
    '輶': 2,
    '輷': 2,
    '輸': 2,
    '輹': 2,
    '輻': 2,
    '輼': 2,
    '輾': 2,
    '輿': 2,
    '轀': 2,
    '轁': 2,
    '轂': 2,
    '轃': 2,
    '轄': 2,
    '轅': 2,
    '轆': 2,
    '轇': 2,
    '轈': 2,
    '轉': 2,
    '轊': 2,
    '轍': 2,
    '轎': 2,
    '轏': 2,
    '轐': 2,
    '轑': 2,
    '轒': 2,
    '轓': 2,
    '轔': 2,
    '轕': 2,
    '轖': 2,
    '轗': 2,
    '轘': 2,
    '轙': 2,
    '轚': 2,
    '轛': 2,
    '轝': 2,
    '轞': 2,
    '轟': 2,
    '轠': 2,
    '轡': 2,
    '轢': 2,
    '轣': 2,
    '轤': 2,
    '轥': 2,
    '车': 1,
    '轧': 1,
    '轨': 1,
    '轩': 1,
    '轪': 1,
    '轫': 1,
    '转': 1,
    '轭': 1,
    '轮': 1,
    '软': 1,
    '轰': 1,
    '轱': 1,
    '轲': 1,
    '轳': 1,
    '轴': 1,
    '轵': 1,
    '轶': 1,
    '轷': 1,
    '轸': 1,
    '轹': 1,
    '轺': 1,
    '轻': 1,
    '轼': 1,
    '载': 1,
    '轾': 1,
    '轿': 1,
    '辀': 1,
    '辁': 1,
    '辂': 1,
    '较': 1,
    '辄': 1,
    '辅': 1,
    '辆': 1,
    '辇': 1,
    '辈': 1,
    '辉': 1,
    '辊': 1,
    '辋': 1,
    '辌': 1,
    '辍': 1,
    '辎': 1,
    '辏': 1,
    '辐': 1,
    '辑': 1,
    '辒': 1,
    '输': 1,
    '辔': 1,
    '辕': 1,
    '辖': 1,
    '辗': 1,
    '辘': 1,
    '辙': 1,
    '辚': 1,
    '辞': 3,
    '辟': 3,
    '辦': 2,
    '辩': 1,
    '辫': 1,
    '辭': 2,
    '辮': 2,
    '辯': 2,
    '農': 2,
    '边': 3,
    '辽': 1,
    '达': 1,
    '迁': 3,
    '过': 3,
    '迈': 1,
    '运': 1,
    '还': 3,
    '这': 3,
    '进': 1,
    '远': 3,
    '违': 1,
    '连': 1,
    '迟': 1,
    '迩': 3,
    '迳': 1,
    '迴': 2,
    '迹': 3,
    '适': 3,
    '选': 3,
    '逊': 3,
    '递': 3,
    '逕': 2,
    '這': 2,
    '連': 2,
    '逦': 1,
    '進': 2,
    '逻': 3,
    '逿': 2,
    '運': 2,
    '過': 2,
    '達': 2,
    '違': 2,
    '遗': 1,
    '遙': 2,
    '遜': 2,
    '遞': 2,
    '遠': 2,
    '遥': 1,
    '適': 2,
    '遰': 2,
    '遱': 2,
    '遲': 2,
    '遶': 2,
    '遷': 2,
    '選': 2,
    '遺': 2,
    '遼': 2,
    '邁': 2,
    '還': 2,
    '邇': 2,
    '邊': 2,
    '邏': 2,
    '邐': 2,
    '邓': 1,
    '邝': 1,
    '邬': 1,
    '邮': 1,
    '邹': 1,
    '邺': 1,
    '邻': 1,
    '郁': 3,
    '郏': 1,
    '郐': 1,
    '郑': 3,
    '郓': 1,
    '郟': 2,
    '郦': 1,
    '郧': 1,
    '郲': 2,
    '郵': 2,
    '郸': 1,
    '鄆': 2,
    '鄉': 2,
    '鄒': 2,
    '鄔': 2,
    '鄖': 2,
    '鄟': 2,
    '鄡': 2,
    '鄦': 2,
    '鄧': 2,
    '鄩': 2,
    '鄪': 2,
    '鄬': 2,
    '鄭': 2,
    '鄮': 2,
    '鄰': 2,
    '鄲': 2,
    '鄳': 2,
    '鄴': 2,
    '鄶': 2,
    '鄺': 2,
    '酂': 1,
    '酇': 2,
    '酈': 2,
    '酝': 1,
    '酦': 1,
    '酱': 1,
    '酽': 1,
    '酾': 1,
    '酿': 1,
    '醆': 2,
    '醖': 2,
    '醜': 2,
    '醞': 2,
    '醟': 2,
    '醦': 2,
    '醧': 2,
    '醫': 2,
    '醬': 2,
    '醱': 2,
    '醲': 2,
    '醳': 2,
    '醶': 2,
    '釀': 2,
    '釁': 2,
    '釃': 2,
    '釅': 2,
    '采': 3,
    '释': 1,
    '釋': 2,
    '里': 3,
    '釐': 2,
    '釒': 2,
    '釓': 2,
    '釔': 2,
    '釕': 2,
    '釗': 2,
    '釘': 2,
    '釙': 2,
    '釚': 2,
    '釛': 2,
    '針': 2,
    '釟': 2,
    '釣': 2,
    '釤': 2,
    '釥': 2,
    '釦': 2,
    '釧': 2,
    '釨': 2,
    '釩': 2,
    '釪': 2,
    '釫': 2,
    '釬': 2,
    '釭': 2,
    '釱': 2,
    '釲': 2,
    '釳': 2,
    '釴': 2,
    '釵': 2,
    '釷': 2,
    '釹': 2,
    '釺': 2,
    '釽': 2,
    '釾': 2,
    '釿': 2,
    '鈀': 2,
    '鈁': 2,
    '鈂': 2,
    '鈃': 2,
    '鈄': 2,
    '鈆': 2,
    '鈇': 2,
    '鈈': 2,
    '鈉': 2,
    '鈋': 2,
    '鈍': 2,
    '鈎': 2,
    '鈏': 2,
    '鈐': 2,
    '鈑': 2,
    '鈒': 2,
    '鈓': 2,
    '鈔': 2,
    '鈕': 2,
    '鈖': 2,
    '鈗': 2,
    '鈚': 2,
    '鈛': 2,
    '鈜': 2,
    '鈞': 2,
    '鈠': 2,
    '鈣': 2,
    '鈤': 2,
    '鈥': 2,
    '鈦': 2,
    '鈧': 2,
    '鈨': 2,
    '鈪': 2,
    '鈮': 2,
    '鈯': 2,
    '鈰': 2,
    '鈲': 2,
    '鈳': 2,
    '鈴': 2,
    '鈵': 2,
    '鈶': 2,
    '鈷': 2,
    '鈸': 2,
    '鈹': 2,
    '鈺': 2,
    '鈼': 2,
    '鈽': 2,
    '鈾': 2,
    '鈿': 2,
    '鉀': 2,
    '鉁': 2,
    '鉅': 2,
    '鉈': 2,
    '鉉': 2,
    '鉊': 2,
    '鉋': 2,
    '鉌': 2,
    '鉍': 2,
    '鉎': 2,
    '鉏': 2,
    '鉐': 2,
    '鉑': 2,
    '鉒': 2,
    '鉔': 2,
    '鉕': 2,
    '鉗': 2,
    '鉘': 2,
    '鉙': 2,
    '鉚': 2,
    '鉛': 2,
    '鉜': 2,
    '鉝': 2,
    '鉞': 2,
    '鉟': 2,
    '鉠': 2,
    '鉡': 2,
    '鉢': 2,
    '鉤': 2,
    '鉥': 2,
    '鉦': 2,
    '鉧': 2,
    '鉨': 2,
    '鉬': 2,
    '鉭': 2,
    '鉮': 2,
    '鉲': 2,
    '鉴': 1,
    '鉵': 2,
    '鉶': 2,
    '鉷': 2,
    '鉸': 2,
    '鉹': 2,
    '鉺': 2,
    '鉻': 2,
    '鉼': 2,
    '鉽': 2,
    '鉾': 2,
    '鉿': 2,
    '銀': 2,
    '銁': 2,
    '銂': 2,
    '銃': 2,
    '銅': 2,
    '銈': 2,
    '銊': 2,
    '銋': 2,
    '銍': 2,
    '銏': 2,
    '銑': 2,
    '銓': 2,
    '銔': 2,
    '銖': 2,
    '銗': 2,
    '銘': 2,
    '銙': 2,
    '銚': 2,
    '銛': 2,
    '銜': 2,
    '銠': 2,
    '銡': 2,
    '銣': 2,
    '銥': 2,
    '銦': 2,
    '銧': 2,
    '銨': 2,
    '銩': 2,
    '銪': 2,
    '銫': 2,
    '銬': 2,
    '銮': 3,
    '銱': 2,
    '銲': 2,
    '銳': 2,
    '銶': 2,
    '銷': 2,
    '銸': 2,
    '銹': 2,
    '銻': 2,
    '銼': 2,
    '銾': 2,
    '鋁': 2,
    '鋂': 2,
    '鋃': 2,
    '鋅': 2,
    '鋇': 2,
    '鋉': 2,
    '鋊': 2,
    '鋋': 2,
    '鋌': 2,
    '鋍': 2,
    '鋏': 2,
    '鋐': 2,
    '鋑': 2,
    '鋒': 2,
    '鋓': 2,
    '鋗': 2,
    '鋘': 2,
    '鋙': 2,
    '鋜': 2,
    '鋝': 2,
    '鋟': 2,
    '鋠': 2,
    '鋡': 2,
    '鋣': 2,
    '鋤': 2,
    '鋥': 2,
    '鋦': 2,
    '鋧': 2,
    '鋨': 2,
    '鋩': 2,
    '鋪': 2,
    '鋭': 2,
    '鋮': 2,
    '鋯': 2,
    '鋰': 2,
    '鋱': 2,
    '鋶': 2,
    '鋸': 2,
    '鋹': 2,
    '鋼': 2,
    '鋾': 2,
    '錀': 2,
    '錁': 2,
    '錂': 2,
    '錄': 2,
    '錆': 2,
    '錇': 2,
    '錈': 2,
    '錋': 2,
    '錍': 2,
    '錏': 2,
    '錐': 2,
    '錑': 2,
    '錒': 2,
    '錔': 2,
    '錕': 2,
    '錗': 2,
    '錘': 2,
    '錙': 2,
    '錚': 2,
    '錛': 2,
    '錜': 2,
    '錝': 2,
    '錞': 2,
    '錟': 2,
    '錠': 2,
    '錡': 2,
    '錢': 2,
    '錣': 2,
    '錤': 2,
    '錥': 2,
    '錦': 2,
    '錧': 2,
    '錨': 2,
    '錩': 2,
    '錪': 2,
    '錫': 2,
    '錭': 2,
    '錮': 2,
    '錯': 2,
    '録': 2,
    '錳': 2,
    '錶': 2,
    '錸': 2,
    '錺': 2,
    '錽': 2,
    '錾': 1,
    '鍀': 2,
    '鍁': 2,
    '鍂': 2,
    '鍃': 2,
    '鍄': 2,
    '鍆': 2,
    '鍇': 2,
    '鍈': 2,
    '鍉': 2,
    '鍊': 2,
    '鍋': 2,
    '鍍': 2,
    '鍏': 2,
    '鍐': 2,
    '鍑': 2,
    '鍒': 2,
    '鍔': 2,
    '鍕': 2,
    '鍖': 2,
    '鍘': 2,
    '鍚': 2,
    '鍛': 2,
    '鍜': 2,
    '鍝': 2,
    '鍟': 2,
    '鍠': 2,
    '鍡': 2,
    '鍢': 2,
    '鍣': 2,
    '鍤': 2,
    '鍥': 2,
    '鍦': 2,
    '鍧': 2,
    '鍨': 2,
    '鍩': 2,
    '鍬': 2,
    '鍭': 2,
    '鍮': 2,
    '鍯': 2,
    '鍰': 2,
    '鍱': 2,
    '鍴': 2,
    '鍵': 2,
    '鍶': 2,
    '鍺': 2,
    '鍼': 2,
    '鍾': 2,
    '鎂': 2,
    '鎄': 2,
    '鎅': 2,
    '鎇': 2,
    '鎈': 2,
    '鎉': 2,
    '鎊': 2,
    '鎋': 2,
    '鎌': 2,
    '鎍': 2,
    '鎑': 2,
    '鎒': 2,
    '鎓': 2,
    '鎔': 2,
    '鎕': 2,
    '鎖': 2,
    '鎗': 2,
    '鎘': 2,
    '鎙': 2,
    '鎚': 2,
    '鎛': 2,
    '鎝': 2,
    '鎞': 2,
    '鎡': 2,
    '鎢': 2,
    '鎣': 2,
    '鎦': 2,
    '鎧': 2,
    '鎩': 2,
    '鎪': 2,
    '鎬': 2,
    '鎮': 2,
    '鎯': 2,
    '鎰': 2,
    '鎲': 2,
    '鎳': 2,
    '鎵': 2,
    '鎶': 2,
    '鎷': 2,
    '鎸': 2,
    '鎿': 2,
    '鏁': 2,
    '鏂': 2,
    '鏃': 2,
    '鏆': 2,
    '鏇': 2,
    '鏈': 2,
    '鏉': 2,
    '鏌': 2,
    '鏍': 2,
    '鏏': 2,
    '鏐': 2,
    '鏑': 2,
    '鏒': 2,
    '鏓': 2,
    '鏔': 2,
    '鏕': 2,
    '鏗': 2,
    '鏘': 2,
    '鏙': 2,
    '鏚': 2,
    '鏛': 2,
    '鏜': 2,
    '鏝': 2,
    '鏞': 2,
    '鏟': 2,
    '鏡': 2,
    '鏢': 2,
    '鏤': 2,
    '鏥': 2,
    '鏦': 2,
    '鏨': 2,
    '鏩': 2,
    '鏰': 2,
    '鏵': 2,
    '鏷': 2,
    '鏸': 2,
    '鏹': 2,
    '鏺': 2,
    '鏻': 2,
    '鏽': 2,
    '鏾': 2,
    '鐀': 2,
    '鐁': 2,
    '鐃': 2,
    '鐄': 2,
    '鐇': 2,
    '鐈': 2,
    '鐉': 2,
    '鐊': 2,
    '鐋': 2,
    '鐍': 2,
    '鐎': 2,
    '鐏': 2,
    '鐐': 2,
    '鐒': 2,
    '鐓': 2,
    '鐔': 2,
    '鐕': 2,
    '鐖': 2,
    '鐘': 2,
    '鐙': 2,
    '鐚': 2,
    '鐝': 2,
    '鐠': 2,
    '鐤': 2,
    '鐥': 2,
    '鐦': 2,
    '鐧': 2,
    '鐨': 2,
    '鐩': 2,
    '鐪': 2,
    '鐫': 2,
    '鐬': 2,
    '鐮': 2,
    '鐯': 2,
    '鐲': 2,
    '鐳': 2,
    '鐴': 2,
    '鐵': 2,
    '鐶': 2,
    '鐸': 2,
    '鐹': 2,
    '鐺': 2,
    '鐼': 2,
    '鐽': 2,
    '鐿': 2,
    '鑀': 2,
    '鑄': 2,
    '鑇': 2,
    '鑈': 2,
    '鑉': 2,
    '鑊': 2,
    '鑋': 2,
    '鑌': 2,
    '鑏': 2,
    '鑐': 2,
    '鑑': 2,
    '鑒': 2,
    '鑔': 2,
    '鑕': 2,
    '鑖': 2,
    '鑘': 2,
    '鑙': 2,
    '鑛': 2,
    '鑞': 2,
    '鑠': 2,
    '鑡': 2,
    '鑢': 2,
    '鑣': 2,
    '鑥': 2,
    '鑧': 2,
    '鑨': 2,
    '鑪': 2,
    '鑭': 2,
    '鑮': 2,
    '鑯': 2,
    '鑰': 2,
    '鑱': 2,
    '鑲': 2,
    '鑴': 2,
    '鑷': 2,
    '鑸': 2,
    '鑹': 2,
    '鑼': 2,
    '鑽': 2,
    '鑾': 2,
    '鑿': 2,
    '钀': 2,
    '钁': 2,
    '钂': 2,
    '钃': 2,
    '钅': 1,
    '钆': 1,
    '钇': 1,
    '针': 1,
    '钉': 1,
    '钊': 1,
    '钋': 1,
    '钌': 1,
    '钍': 1,
    '钎': 1,
    '钏': 1,
    '钐': 1,
    '钑': 1,
    '钒': 1,
    '钓': 1,
    '钔': 1,
    '钕': 1,
    '钖': 1,
    '钗': 1,
    '钘': 1,
    '钙': 1,
    '钚': 1,
    '钛': 1,
    '钜': 1,
    '钝': 1,
    '钞': 1,
    '钟': 1,
    '钠': 1,
    '钡': 1,
    '钢': 1,
    '钣': 1,
    '钤': 1,
    '钥': 1,
    '钦': 1,
    '钧': 1,
    '钨': 1,
    '钩': 1,
    '钪': 1,
    '钫': 1,
    '钬': 1,
    '钭': 1,
    '钮': 1,
    '钯': 1,
    '钰': 1,
    '钱': 1,
    '钲': 1,
    '钳': 1,
    '钴': 1,
    '钵': 1,
    '钶': 1,
    '钷': 1,
    '钸': 1,
    '钹': 1,
    '钺': 1,
    '钻': 1,
    '钼': 1,
    '钽': 1,
    '钾': 1,
    '钿': 1,
    '铀': 1,
    '铁': 1,
    '铂': 1,
    '铃': 1,
    '铄': 1,
    '铅': 1,
    '铆': 1,
    '铇': 1,
    '铈': 1,
    '铉': 1,
    '铊': 1,
    '铋': 1,
    '铌': 1,
    '铍': 1,
    '铎': 1,
    '铏': 1,
    '铐': 1,
    '铑': 1,
    '铒': 1,
    '铓': 1,
    '铔': 1,
    '铕': 1,
    '铖': 1,
    '铗': 1,
    '铘': 1,
    '铙': 1,
    '铚': 1,
    '铛': 1,
    '铜': 1,
    '铝': 1,
    '铞': 1,
    '铟': 1,
    '铠': 1,
    '铡': 1,
    '铢': 1,
    '铣': 1,
    '铤': 1,
    '铥': 1,
    '铦': 1,
    '铧': 1,
    '铨': 1,
    '铩': 1,
    '铪': 1,
    '铫': 1,
    '铬': 1,
    '铭': 1,
    '铮': 1,
    '铯': 1,
    '铰': 1,
    '铱': 1,
    '铲': 1,
    '铳': 1,
    '铴': 1,
    '铵': 1,
    '银': 1,
    '铷': 1,
    '铸': 1,
    '铹': 1,
    '铺': 1,
    '铻': 1,
    '铼': 1,
    '铽': 1,
    '链': 1,
    '铿': 1,
    '销': 1,
    '锁': 1,
    '锂': 1,
    '锃': 1,
    '锄': 1,
    '锅': 1,
    '锆': 1,
    '锇': 1,
    '锈': 1,
    '锉': 1,
    '锊': 1,
    '锋': 1,
    '锌': 1,
    '锍': 1,
    '锎': 1,
    '锏': 1,
    '锐': 1,
    '锑': 1,
    '锒': 1,
    '锓': 1,
    '锔': 1,
    '锕': 1,
    '锖': 1,
    '锗': 1,
    '锘': 1,
    '错': 1,
    '锚': 1,
    '锛': 1,
    '锜': 1,
    '锝': 1,
    '锞': 1,
    '锟': 1,
    '锠': 1,
    '锡': 1,
    '锢': 1,
    '锣': 1,
    '锤': 1,
    '锥': 1,
    '锦': 1,
    '锧': 1,
    '锨': 1,
    '锩': 1,
    '锪': 1,
    '锫': 1,
    '锬': 1,
    '锭': 1,
    '键': 1,
    '锯': 1,
    '锰': 1,
    '锱': 1,
    '锲': 1,
    '锳': 1,
    '锴': 1,
    '锵': 1,
    '锶': 1,
    '锷': 1,
    '锸': 1,
    '锹': 1,
    '锺': 1,
    '锻': 1,
    '锼': 1,
    '锽': 1,
    '锾': 1,
    '锿': 1,
    '镀': 1,
    '镁': 1,
    '镂': 1,
    '镃': 1,
    '镄': 1,
    '镅': 1,
    '镆': 1,
    '镇': 1,
    '镈': 1,
    '镉': 1,
    '镊': 1,
    '镋': 1,
    '镌': 1,
    '镍': 1,
    '镎': 1,
    '镏': 1,
    '镐': 1,
    '镑': 1,
    '镒': 1,
    '镓': 1,
    '镔': 1,
    '镕': 1,
    '镖': 1,
    '镗': 1,
    '镘': 1,
    '镙': 1,
    '镚': 1,
    '镛': 1,
    '镜': 1,
    '镝': 1,
    '镞': 1,
    '镟': 1,
    '镠': 1,
    '镡': 1,
    '镢': 1,
    '镣': 1,
    '镤': 1,
    '镥': 1,
    '镦': 1,
    '镧': 1,
    '镨': 1,
    '镩': 1,
    '镪': 1,
    '镫': 1,
    '镬': 1,
    '镭': 1,
    '镮': 1,
    '镯': 1,
    '镰': 1,
    '镱': 1,
    '镲': 1,
    '镳': 1,
    '镴': 1,
    '镵': 1,
    '镶': 1,
    '長': 2,
    '长': 1,
    '門': 2,
    '閂': 2,
    '閃': 2,
    '閄': 2,
    '閅': 2,
    '閆': 2,
    '閈': 2,
    '閉': 2,
    '開': 2,
    '閌': 2,
    '閍': 2,
    '閎': 2,
    '閏': 2,
    '閐': 2,
    '閑': 2,
    '閒': 2,
    '間': 2,
    '閔': 2,
    '閕': 2,
    '閗': 2,
    '閘': 2,
    '閛': 2,
    '閜': 2,
    '閝': 2,
    '閞': 2,
    '閟': 2,
    '閡': 2,
    '閣': 2,
    '閤': 2,
    '閥': 2,
    '閦': 2,
    '閧': 2,
    '閨': 2,
    '閩': 2,
    '閫': 2,
    '閬': 2,
    '閭': 2,
    '閯': 2,
    '閱': 2,
    '閲': 2,
    '閵': 2,
    '閶': 2,
    '閷': 2,
    '閹': 2,
    '閻': 2,
    '閼': 2,
    '閽': 2,
    '閾': 2,
    '閿': 2,
    '闃': 2,
    '闄': 2,
    '闆': 2,
    '闇': 2,
    '闈': 2,
    '闉': 2,
    '闊': 2,
    '闋': 2,
    '闌': 2,
    '闍': 2,
    '闐': 2,
    '闑': 2,
    '闒': 2,
    '闓': 2,
    '闔': 2,
    '闕': 2,
    '闖': 2,
    '闚': 2,
    '闛': 2,
    '關': 2,
    '闞': 2,
    '闟': 2,
    '闠': 2,
    '闡': 2,
    '闢': 2,
    '闤': 2,
    '闥': 2,
    '门': 1,
    '闩': 1,
    '闪': 1,
    '闫': 1,
    '闬': 1,
    '闭': 1,
    '问': 1,
    '闯': 1,
    '闰': 1,
    '闱': 1,
    '闲': 1,
    '闳': 1,
    '间': 1,
    '闵': 1,
    '闶': 1,
    '闷': 1,
    '闸': 1,
    '闹': 1,
    '闺': 1,
    '闻': 1,
    '闼': 1,
    '闽': 1,
    '闾': 1,
    '闿': 1,
    '阀': 1,
    '阁': 1,
    '阂': 1,
    '阃': 1,
    '阄': 1,
    '阅': 1,
    '阆': 1,
    '阇': 1,
    '阈': 1,
    '阉': 1,
    '阊': 1,
    '阋': 1,
    '阌': 1,
    '阍': 1,
    '阎': 1,
    '阏': 1,
    '阐': 1,
    '阑': 1,
    '阒': 1,
    '阓': 1,
    '阔': 1,
    '阕': 1,
    '阖': 1,
    '阗': 1,
    '阘': 1,
    '阙': 1,
    '阚': 1,
    '阛': 1,
    '队': 1,
    '阪': 2,
    '阳': 1,
    '阴': 1,
    '阵': 1,
    '阶': 1,
    '际': 3,
    '陆': 1,
    '陇': 1,
    '陈': 1,
    '陉': 1,
    '陕': 1,
    '陘': 2,
    '陝': 2,
    '陣': 2,
    '陦': 1,
    '陧': 1,
    '陨': 1,
    '险': 1,
    '陰': 2,
    '陳': 2,
    '陸': 2,
    '陽': 2,
    '陿': 2,
    '隉': 2,
    '隊': 2,
    '階': 2,
    '随': 3,
    '隐': 3,
    '隑': 2,
    '隕': 2,
    '隖': 2,
    '際': 2,
    '隤': 2,
    '隨': 2,
    '險': 2,
    '隫': 2,
    '隮': 2,
    '隯': 2,
    '隱': 2,
    '隲': 2,
    '隴': 2,
    '隶': 3,
    '隸': 2,
    '隻': 2,
    '隽': 3,
    '难': 3,
    '雋': 2,
    '雏': 1,
    '雖': 2,
    '雙': 2,
    '雛': 2,
    '雜': 2,
    '雞': 2,
    '雠': 1,
    '離': 2,
    '難': 2,
    '雲': 2,
    '雳': 1,
    '電': 2,
    '雾': 1,
    '霁': 1,
    '霉': 3,
    '霡': 3,
    '霢': 2,
    '霣': 2,
    '霧': 2,
    '霭': 1,
    '霼': 2,
    '霽': 2,
    '靂': 2,
    '靄': 2,
    '靅': 2,
    '靆': 2,
    '靈': 2,
    '靉': 2,
    '靓': 1,
    '静': 3,
    '靚': 2,
    '靜': 2,
    '面': 3,
    '靥': 1,
    '靦': 2,
    '靧': 2,
    '靨': 2,
    '鞀': 2,
    '鞏': 2,
    '鞑': 1,
    '鞒': 1,
    '鞝': 2,
    '鞦': 2,
    '鞯': 1,
    '鞸': 2,
    '鞻': 2,
    '鞼': 2,
    '鞽': 2,
    '鞾': 2,
    '韁': 2,
    '韃': 2,
    '韆': 2,
    '韇': 2,
    '韉': 2,
    '韊': 2,
    '韋': 2,
    '韌': 2,
    '韍': 2,
    '韏': 2,
    '韐': 2,
    '韒': 2,
    '韓': 2,
    '韔': 2,
    '韗': 2,
    '韘': 2,
    '韙': 2,
    '韚': 2,
    '韛': 2,
    '韜': 2,
    '韝': 2,
    '韞': 2,
    '韠': 2,
    '韡': 2,
    '韢': 2,
    '韣': 2,
    '韦': 1,
    '韧': 1,
    '韨': 1,
    '韩': 1,
    '韪': 1,
    '韫': 1,
    '韬': 1,
    '韵': 3,
    '韻': 2,
    '響': 2,
    '頁': 2,
    '頂': 2,
    '頃': 2,
    '頄': 2,
    '項': 2,
    '順': 2,
    '頇': 2,
    '須': 2,
    '頊': 2,
    '頌': 2,
    '頍': 2,
    '頎': 2,
    '頏': 2,
    '預': 2,
    '頑': 2,
    '頒': 2,
    '頓': 2,
    '頔': 2,
    '頕': 2,
    '頖': 2,
    '頗': 2,
    '領': 2,
    '頛': 2,
    '頜': 2,
    '頞': 2,
    '頟': 2,
    '頠': 2,
    '頡': 2,
    '頢': 2,
    '頤': 2,
    '頦': 2,
    '頩': 2,
    '頪': 2,
    '頫': 2,
    '頭': 2,
    '頮': 2,
    '頯': 2,
    '頰': 2,
    '頲': 2,
    '頴': 2,
    '頵': 2,
    '頷': 2,
    '頸': 2,
    '頹': 2,
    '頻': 2,
    '頽': 2,
    '顀': 2,
    '顁': 2,
    '顃': 2,
    '顄': 2,
    '顅': 2,
    '顆': 2,
    '顇': 2,
    '顉': 2,
    '顊': 2,
    '顋': 2,
    '題': 2,
    '額': 2,
    '顎': 2,
    '顏': 2,
    '顐': 2,
    '顑': 2,
    '顒': 2,
    '顓': 2,
    '顔': 2,
    '顖': 2,
    '顗': 2,
    '願': 2,
    '顙': 2,
    '顛': 2,
    '顜': 2,
    '顝': 2,
    '類': 2,
    '顠': 2,
    '顢': 2,
    '顣': 2,
    '顤': 2,
    '顥': 2,
    '顦': 2,
    '顧': 2,
    '顩': 2,
    '顪': 2,
    '顫': 2,
    '顬': 2,
    '顮': 2,
    '顯': 2,
    '顰': 2,
    '顱': 2,
    '顳': 2,
    '顴': 2,
    '页': 1,
    '顶': 1,
    '顷': 1,
    '顸': 1,
    '项': 1,
    '顺': 1,
    '须': 1,
    '顼': 1,
    '顽': 1,
    '顾': 1,
    '顿': 1,
    '颀': 1,
    '颁': 1,
    '颂': 1,
    '颃': 1,
    '预': 1,
    '颅': 1,
    '领': 1,
    '颇': 1,
    '颈': 1,
    '颉': 1,
    '颊': 1,
    '颋': 1,
    '颌': 1,
    '颍': 1,
    '颎': 1,
    '颏': 1,
    '颐': 1,
    '频': 1,
    '颒': 1,
    '颓': 1,
    '颔': 1,
    '颕': 1,
    '颖': 1,
    '颗': 1,
    '题': 1,
    '颙': 1,
    '颚': 1,
    '颛': 1,
    '颜': 1,
    '额': 1,
    '颞': 1,
    '颟': 1,
    '颠': 1,
    '颡': 1,
    '颢': 1,
    '颣': 1,
    '颤': 1,
    '颥': 1,
    '颦': 1,
    '颧': 1,
    '風': 2,
    '颩': 2,
    '颬': 2,
    '颭': 2,
    '颮': 2,
    '颯': 2,
    '颰': 2,
    '颱': 2,
    '颲': 2,
    '颳': 2,
    '颴': 2,
    '颶': 2,
    '颷': 2,
    '颸': 2,
    '颹': 2,
    '颺': 2,
    '颻': 2,
    '颼': 2,
    '颽': 2,
    '颾': 2,
    '颿': 2,
    '飀': 2,
    '飁': 2,
    '飂': 2,
    '飄': 2,
    '飆': 2,
    '飇': 2,
    '飈': 2,
    '飉': 2,
    '飊': 2,
    '飋': 2,
    '飍': 2,
    '风': 3,
    '飏': 1,
    '飐': 1,
    '飑': 1,
    '飒': 1,
    '飓': 1,
    '飔': 1,
    '飕': 1,
    '飖': 1,
    '飗': 1,
    '飘': 1,
    '飙': 1,
    '飚': 1,
    '飛': 2,
    '飝': 2,
    '飞': 1,
    '飠': 2,
    '飢': 2,
    '飣': 2,
    '飤': 2,
    '飥': 2,
    '飦': 2,
    '飨': 1,
    '飩': 2,
    '飪': 2,
    '飫': 2,
    '飭': 2,
    '飯': 2,
    '飰': 2,
    '飲': 2,
    '飴': 2,
    '飵': 2,
    '飶': 2,
    '飷': 2,
    '飼': 2,
    '飽': 2,
    '飾': 2,
    '飿': 2,
    '餀': 2,
    '餂': 2,
    '餃': 2,
    '餄': 2,
    '餅': 2,
    '餉': 2,
    '養': 2,
    '餌': 2,
    '餍': 1,
    '餎': 2,
    '餏': 2,
    '餑': 2,
    '餒': 2,
    '餓': 2,
    '餔': 2,
    '餕': 2,
    '餖': 2,
    '餗': 2,
    '餘': 2,
    '餚': 2,
    '餛': 2,
    '餜': 2,
    '餞': 2,
    '餟': 2,
    '餡': 2,
    '餢': 2,
    '餣': 2,
    '餤': 2,
    '餦': 2,
    '餧': 2,
    '館': 2,
    '餩': 2,
    '餪': 2,
    '餫': 2,
    '餬': 2,
    '餭': 2,
    '餯': 2,
    '餰': 2,
    '餱': 2,
    '餲': 2,
    '餳': 2,
    '餴': 2,
    '餵': 2,
    '餶': 2,
    '餷': 2,
    '餸': 2,
    '餹': 2,
    '餺': 2,
    '餼': 2,
    '餾': 2,
    '餿': 2,
    '饀': 2,
    '饁': 2,
    '饃': 2,
    '饅': 2,
    '饆': 2,
    '饇': 2,
    '饈': 2,
    '饉': 2,
    '饊': 2,
    '饋': 2,
    '饌': 2,
    '饎': 2,
    '饐': 2,
    '饑': 2,
    '饒': 2,
    '饗': 2,
    '饘': 2,
    '饙': 2,
    '饛': 2,
    '饜': 2,
    '饞': 2,
    '饟': 2,
    '饠': 2,
    '饡': 2,
    '饢': 2,
    '饣': 1,
    '饤': 1,
    '饥': 1,
    '饦': 1,
    '饧': 1,
    '饨': 1,
    '饩': 1,
    '饪': 1,
    '饫': 1,
    '饬': 1,
    '饭': 1,
    '饮': 1,
    '饯': 1,
    '饰': 1,
    '饱': 1,
    '饲': 1,
    '饳': 1,
    '饴': 1,
    '饵': 1,
    '饶': 1,
    '饷': 1,
    '饸': 1,
    '饹': 1,
    '饺': 1,
    '饻': 1,
    '饼': 1,
    '饽': 1,
    '饾': 1,
    '饿': 1,
    '馀': 1,
    '馁': 1,
    '馂': 1,
    '馃': 1,
    '馄': 1,
    '馅': 1,
    '馆': 1,
    '馇': 1,
    '馈': 1,
    '馉': 1,
    '馊': 1,
    '馋': 1,
    '馌': 1,
    '馍': 1,
    '馎': 1,
    '馏': 1,
    '馐': 1,
    '馑': 1,
    '馒': 1,
    '馓': 1,
    '馔': 1,
    '馕': 1,
    '馩': 2,
    '馪': 2,
    '馬': 2,
    '馭': 2,
    '馮': 2,
    '馯': 2,
    '馱': 2,
    '馲': 2,
    '馳': 2,
    '馴': 2,
    '馵': 2,
    '馹': 2,
    '馺': 2,
    '馼': 2,
    '馽': 2,
    '駁': 2,
    '駂': 2,
    '駃': 2,
    '駉': 2,
    '駊': 2,
    '駍': 2,
    '駎': 2,
    '駏': 2,
    '駐': 2,
    '駑': 2,
    '駒': 2,
    '駓': 2,
    '駔': 2,
    '駕': 2,
    '駗': 2,
    '駘': 2,
    '駙': 2,
    '駚': 2,
    '駛': 2,
    '駜': 2,
    '駝': 2,
    '駞': 2,
    '駟': 2,
    '駡': 2,
    '駢': 2,
    '駣': 2,
    '駤': 2,
    '駥': 2,
    '駧': 2,
    '駩': 2,
    '駪': 2,
    '駫': 2,
    '駬': 2,
    '駭': 2,
    '駮': 2,
    '駰': 2,
    '駱': 2,
    '駴': 2,
    '駶': 2,
    '駷': 2,
    '駸': 2,
    '駹': 2,
    '駺': 2,
    '駻': 2,
    '駼': 2,
    '駽': 2,
    '駾': 2,
    '駿': 2,
    '騀': 2,
    '騁': 2,
    '騂': 2,
    '騃': 2,
    '騄': 2,
    '騅': 2,
    '騆': 2,
    '騇': 2,
    '騉': 2,
    '騊': 2,
    '騋': 2,
    '騌': 2,
    '騍': 2,
    '騎': 2,
    '騏': 2,
    '騑': 2,
    '騔': 2,
    '騕': 2,
    '騖': 2,
    '騗': 2,
    '騙': 2,
    '騚': 2,
    '騛': 2,
    '騜': 2,
    '騝': 2,
    '騞': 2,
    '騟': 2,
    '騠': 2,
    '騢': 2,
    '騣': 2,
    '騤': 2,
    '騥': 2,
    '騧': 2,
    '騩': 2,
    '騪': 2,
    '騫': 2,
    '騬': 2,
    '騭': 2,
    '騮': 2,
    '騯': 2,
    '騰': 2,
    '騱': 2,
    '騲': 2,
    '騳': 2,
    '騴': 2,
    '騵': 2,
    '騶': 2,
    '騷': 2,
    '騸': 2,
    '騹': 2,
    '騺': 2,
    '騻': 2,
    '騼': 2,
    '騽': 2,
    '騾': 2,
    '驀': 2,
    '驁': 2,
    '驂': 2,
    '驃': 2,
    '驄': 2,
    '驅': 2,
    '驈': 2,
    '驉': 2,
    '驊': 2,
    '驋': 2,
    '驌': 2,
    '驍': 2,
    '驎': 2,
    '驏': 2,
    '驐': 2,
    '驒': 2,
    '驓': 2,
    '驔': 2,
    '驕': 2,
    '驖': 2,
    '驗': 2,
    '驙': 2,
    '驚': 2,
    '驛': 2,
    '驞': 2,
    '驟': 2,
    '驠': 2,
    '驡': 2,
    '驢': 2,
    '驤': 2,
    '驥': 2,
    '驦': 2,
    '驨': 2,
    '驩': 2,
    '驪': 2,
    '驫': 2,
    '马': 1,
    '驭': 1,
    '驮': 1,
    '驯': 1,
    '驰': 1,
    '驱': 1,
    '驲': 1,
    '驳': 1,
    '驴': 1,
    '驵': 1,
    '驶': 1,
    '驷': 1,
    '驸': 1,
    '驹': 1,
    '驺': 1,
    '驻': 1,
    '驼': 1,
    '驽': 1,
    '驾': 1,
    '驿': 1,
    '骀': 1,
    '骁': 1,
    '骂': 1,
    '骃': 1,
    '骄': 1,
    '骅': 1,
    '骆': 1,
    '骇': 1,
    '骈': 1,
    '骉': 1,
    '骊': 1,
    '骋': 1,
    '验': 1,
    '骍': 1,
    '骎': 1,
    '骏': 1,
    '骐': 1,
    '骑': 1,
    '骒': 1,
    '骓': 1,
    '骔': 1,
    '骕': 1,
    '骖': 1,
    '骗': 1,
    '骘': 1,
    '骙': 1,
    '骚': 1,
    '骛': 1,
    '骜': 1,
    '骝': 1,
    '骞': 1,
    '骟': 1,
    '骠': 1,
    '骡': 1,
    '骢': 1,
    '骣': 1,
    '骤': 1,
    '骥': 1,
    '骦': 1,
    '骧': 1,
    '骯': 2,
    '髅': 1,
    '髋': 1,
    '髌': 1,
    '髏': 2,
    '髐': 2,
    '髒': 2,
    '體': 2,
    '髕': 2,
    '髖': 2,
    '髮': 2,
    '鬆': 2,
    '鬍': 2,
    '鬓': 1,
    '鬖': 2,
    '鬗': 2,
    '鬚': 2,
    '鬜': 2,
    '鬝': 2,
    '鬞': 2,
    '鬠': 2,
    '鬡': 2,
    '鬢': 2,
    '鬥': 2,
    '鬧': 2,
    '鬩': 2,
    '鬮': 2,
    '鬱': 2,
    '鬶': 1,
    '鬹': 2,
    '鬺': 2,
    '魇': 1,
    '魉': 1,
    '魎': 2,
    '魗': 2,
    '魘': 2,
    '魚': 2,
    '魛': 2,
    '魜': 2,
    '魝': 2,
    '魟': 2,
    '魠': 2,
    '魡': 2,
    '魢': 2,
    '魣': 2,
    '魥': 2,
    '魦': 2,
    '魧': 2,
    '魨': 2,
    '魪': 2,
    '魫': 2,
    '魬': 2,
    '魭': 2,
    '魮': 2,
    '魯': 2,
    '魱': 2,
    '魴': 2,
    '魵': 2,
    '魶': 2,
    '魷': 2,
    '魺': 2,
    '魻': 2,
    '魼': 2,
    '魽': 2,
    '魾': 2,
    '鮀': 2,
    '鮁': 2,
    '鮂': 2,
    '鮃': 2,
    '鮄': 2,
    '鮅': 2,
    '鮆': 2,
    '鮇': 2,
    '鮈': 2,
    '鮊': 2,
    '鮋': 2,
    '鮌': 2,
    '鮍': 2,
    '鮎': 2,
    '鮏': 2,
    '鮐': 2,
    '鮑': 2,
    '鮒': 2,
    '鮓': 2,
    '鮗': 2,
    '鮘': 2,
    '鮚': 2,
    '鮛': 2,
    '鮜': 2,
    '鮝': 2,
    '鮞': 2,
    '鮟': 2,
    '鮠': 2,
    '鮡': 2,
    '鮣': 2,
    '鮤': 2,
    '鮥': 2,
    '鮦': 2,
    '鮧': 2,
    '鮨': 2,
    '鮪': 2,
    '鮫': 2,
    '鮬': 2,
    '鮭': 2,
    '鮮': 2,
    '鮯': 2,
    '鮰': 2,
    '鮳': 2,
    '鮵': 2,
    '鮶': 2,
    '鮷': 2,
    '鮸': 2,
    '鮹': 2,
    '鮺': 2,
    '鮻': 2,
    '鮿': 2,
    '鯀': 2,
    '鯁': 2,
    '鯄': 2,
    '鯅': 2,
    '鯆': 2,
    '鯇': 2,
    '鯈': 2,
    '鯉': 2,
    '鯊': 2,
    '鯌': 2,
    '鯒': 2,
    '鯔': 2,
    '鯕': 2,
    '鯖': 2,
    '鯗': 2,
    '鯚': 2,
    '鯛': 2,
    '鯝': 2,
    '鯞': 2,
    '鯠': 2,
    '鯡': 2,
    '鯢': 2,
    '鯤': 2,
    '鯥': 2,
    '鯦': 2,
    '鯧': 2,
    '鯨': 2,
    '鯩': 2,
    '鯪': 2,
    '鯫': 2,
    '鯬': 2,
    '鯮': 2,
    '鯰': 2,
    '鯱': 2,
    '鯴': 2,
    '鯶': 2,
    '鯷': 2,
    '鯸': 2,
    '鯹': 2,
    '鯻': 2,
    '鯼': 2,
    '鯽': 2,
    '鯾': 2,
    '鯿': 2,
    '鰁': 2,
    '鰂': 2,
    '鰃': 2,
    '鰅': 2,
    '鰆': 2,
    '鰇': 2,
    '鰈': 2,
    '鰉': 2,
    '鰊': 2,
    '鰋': 2,
    '鰌': 2,
    '鰍': 2,
    '鰏': 2,
    '鰐': 2,
    '鰑': 2,
    '鰒': 2,
    '鰓': 2,
    '鰕': 2,
    '鰗': 2,
    '鰛': 2,
    '鰜': 2,
    '鰝': 2,
    '鰟': 2,
    '鰠': 2,
    '鰡': 2,
    '鰣': 2,
    '鰤': 2,
    '鰥': 2,
    '鰦': 2,
    '鰧': 2,
    '鰨': 2,
    '鰩': 2,
    '鰫': 2,
    '鰬': 2,
    '鰭': 2,
    '鰮': 2,
    '鰯': 2,
    '鰱': 2,
    '鰲': 2,
    '鰳': 2,
    '鰴': 2,
    '鰵': 2,
    '鰶': 2,
    '鰷': 2,
    '鰹': 2,
    '鰺': 2,
    '鰻': 2,
    '鰼': 2,
    '鰽': 2,
    '鰾': 2,
    '鰿': 2,
    '鱀': 2,
    '鱁': 2,
    '鱂': 2,
    '鱃': 2,
    '鱄': 2,
    '鱅': 2,
    '鱆': 2,
    '鱇': 2,
    '鱈': 2,
    '鱉': 2,
    '鱊': 2,
    '鱋': 2,
    '鱌': 2,
    '鱍': 2,
    '鱎': 2,
    '鱏': 2,
    '鱐': 2,
    '鱑': 2,
    '鱒': 2,
    '鱓': 2,
    '鱔': 2,
    '鱕': 2,
    '鱖': 2,
    '鱗': 2,
    '鱘': 2,
    '鱚': 2,
    '鱝': 2,
    '鱞': 2,
    '鱟': 2,
    '鱠': 2,
    '鱢': 2,
    '鱣': 2,
    '鱤': 2,
    '鱥': 2,
    '鱦': 2,
    '鱧': 2,
    '鱨': 2,
    '鱬': 2,
    '鱭': 2,
    '鱮': 2,
    '鱯': 2,
    '鱲': 2,
    '鱴': 2,
    '鱵': 2,
    '鱷': 2,
    '鱸': 2,
    '鱹': 2,
    '鱺': 2,
    '鱻': 2,
    '鱼': 1,
    '鱽': 1,
    '鱾': 1,
    '鱿': 1,
    '鲀': 1,
    '鲁': 1,
    '鲂': 1,
    '鲃': 1,
    '鲄': 1,
    '鲅': 1,
    '鲆': 1,
    '鲇': 1,
    '鲈': 1,
    '鲉': 1,
    '鲊': 1,
    '鲋': 1,
    '鲌': 1,
    '鲍': 1,
    '鲎': 1,
    '鲏': 1,
    '鲐': 1,
    '鲑': 1,
    '鲒': 1,
    '鲓': 1,
    '鲔': 1,
    '鲕': 1,
    '鲖': 1,
    '鲗': 1,
    '鲘': 1,
    '鲙': 1,
    '鲚': 1,
    '鲛': 1,
    '鲜': 1,
    '鲝': 1,
    '鲞': 1,
    '鲟': 1,
    '鲠': 1,
    '鲡': 1,
    '鲢': 1,
    '鲣': 1,
    '鲤': 1,
    '鲥': 1,
    '鲦': 1,
    '鲧': 1,
    '鲨': 1,
    '鲩': 1,
    '鲪': 1,
    '鲫': 1,
    '鲬': 1,
    '鲭': 1,
    '鲮': 1,
    '鲯': 1,
    '鲰': 1,
    '鲱': 1,
    '鲲': 1,
    '鲳': 1,
    '鲴': 1,
    '鲵': 1,
    '鲶': 1,
    '鲷': 1,
    '鲸': 1,
    '鲹': 1,
    '鲺': 1,
    '鲻': 1,
    '鲼': 1,
    '鲽': 1,
    '鲾': 1,
    '鲿': 1,
    '鳀': 1,
    '鳁': 1,
    '鳂': 1,
    '鳃': 1,
    '鳄': 1,
    '鳅': 1,
    '鳆': 1,
    '鳇': 1,
    '鳈': 1,
    '鳉': 1,
    '鳊': 1,
    '鳋': 1,
    '鳌': 1,
    '鳍': 1,
    '鳎': 1,
    '鳏': 1,
    '鳐': 1,
    '鳑': 1,
    '鳒': 1,
    '鳓': 1,
    '鳔': 1,
    '鳕': 1,
    '鳖': 1,
    '鳗': 1,
    '鳘': 1,
    '鳙': 1,
    '鳚': 1,
    '鳛': 1,
    '鳜': 1,
    '鳝': 1,
    '鳞': 1,
    '鳟': 1,
    '鳠': 1,
    '鳡': 1,
    '鳢': 1,
    '鳣': 1,
    '鳤': 1,
    '鳥': 2,
    '鳦': 2,
    '鳧': 2,
    '鳩': 2,
    '鳬': 2,
    '鳭': 2,
    '鳱': 2,
    '鳲': 2,
    '鳳': 2,
    '鳴': 2,
    '鳶': 2,
    '鳷': 2,
    '鳸': 2,
    '鳺': 2,
    '鳻': 2,
    '鳼': 2,
    '鳽': 2,
    '鳾': 2,
    '鳿': 2,
    '鴀': 2,
    '鴁': 2,
    '鴂': 2,
    '鴃': 2,
    '鴅': 2,
    '鴆': 2,
    '鴇': 2,
    '鴉': 2,
    '鴍': 2,
    '鴐': 2,
    '鴒': 2,
    '鴓': 2,
    '鴔': 2,
    '鴕': 2,
    '鴗': 2,
    '鴘': 2,
    '鴙': 2,
    '鴚': 2,
    '鴛': 2,
    '鴜': 2,
    '鴝': 2,
    '鴞': 2,
    '鴟': 2,
    '鴠': 2,
    '鴡': 2,
    '鴢': 2,
    '鴣': 2,
    '鴥': 2,
    '鴦': 2,
    '鴨': 2,
    '鴩': 2,
    '鴫': 2,
    '鴮': 2,
    '鴯': 2,
    '鴰': 2,
    '鴱': 2,
    '鴲': 2,
    '鴳': 2,
    '鴴': 2,
    '鴶': 2,
    '鴷': 2,
    '鴸': 2,
    '鴹': 2,
    '鴺': 2,
    '鴻': 2,
    '鴽': 2,
    '鴾': 2,
    '鴿': 2,
    '鵀': 2,
    '鵁': 2,
    '鵂': 2,
    '鵃': 2,
    '鵄': 2,
    '鵅': 2,
    '鵊': 2,
    '鵋': 2,
    '鵌': 2,
    '鵎': 2,
    '鵏': 2,
    '鵐': 2,
    '鵑': 2,
    '鵒': 2,
    '鵓': 2,
    '鵔': 2,
    '鵕': 2,
    '鵖': 2,
    '鵗': 2,
    '鵙': 2,
    '鵚': 2,
    '鵛': 2,
    '鵜': 2,
    '鵝': 2,
    '鵟': 2,
    '鵠': 2,
    '鵡': 2,
    '鵧': 2,
    '鵩': 2,
    '鵪': 2,
    '鵫': 2,
    '鵬': 2,
    '鵮': 2,
    '鵯': 2,
    '鵰': 2,
    '鵱': 2,
    '鵲': 2,
    '鵳': 2,
    '鵴': 2,
    '鵵': 2,
    '鵶': 2,
    '鵷': 2,
    '鵸': 2,
    '鵹': 2,
    '鵻': 2,
    '鵼': 2,
    '鵽': 2,
    '鵾': 2,
    '鶀': 2,
    '鶂': 2,
    '鶃': 2,
    '鶄': 2,
    '鶅': 2,
    '鶆': 2,
    '鶇': 2,
    '鶉': 2,
    '鶊': 2,
    '鶋': 2,
    '鶌': 2,
    '鶒': 2,
    '鶓': 2,
    '鶔': 2,
    '鶕': 2,
    '鶖': 2,
    '鶗': 2,
    '鶘': 2,
    '鶙': 2,
    '鶚': 2,
    '鶛': 2,
    '鶝': 2,
    '鶞': 2,
    '鶟': 2,
    '鶠': 2,
    '鶡': 2,
    '鶢': 2,
    '鶣': 2,
    '鶤': 2,
    '鶥': 2,
    '鶦': 2,
    '鶨': 2,
    '鶩': 2,
    '鶪': 2,
    '鶬': 2,
    '鶭': 2,
    '鶯': 2,
    '鶰': 2,
    '鶱': 2,
    '鶲': 2,
    '鶴': 2,
    '鶵': 2,
    '鶶': 2,
    '鶷': 2,
    '鶹': 2,
    '鶺': 2,
    '鶻': 2,
    '鶼': 2,
    '鶽': 2,
    '鷀': 2,
    '鷁': 2,
    '鷂': 2,
    '鷃': 2,
    '鷄': 2,
    '鷅': 2,
    '鷇': 2,
    '鷈': 2,
    '鷉': 2,
    '鷊': 2,
    '鷋': 2,
    '鷎': 2,
    '鷏': 2,
    '鷐': 2,
    '鷑': 2,
    '鷒': 2,
    '鷓': 2,
    '鷔': 2,
    '鷕': 2,
    '鷖': 2,
    '鷗': 2,
    '鷙': 2,
    '鷚': 2,
    '鷛': 2,
    '鷜': 2,
    '鷞': 2,
    '鷟': 2,
    '鷢': 2,
    '鷣': 2,
    '鷤': 2,
    '鷥': 2,
    '鷦': 2,
    '鷧': 2,
    '鷨': 2,
    '鷩': 2,
    '鷫': 2,
    '鷭': 2,
    '鷮': 2,
    '鷯': 2,
    '鷰': 2,
    '鷲': 2,
    '鷳': 2,
    '鷵': 2,
    '鷶': 2,
    '鷷': 2,
    '鷸': 2,
    '鷹': 2,
    '鷺': 2,
    '鷽': 2,
    '鷾': 2,
    '鷿': 2,
    '鸀': 2,
    '鸁': 2,
    '鸂': 2,
    '鸃': 2,
    '鸄': 2,
    '鸅': 2,
    '鸆': 2,
    '鸇': 2,
    '鸉': 2,
    '鸊': 2,
    '鸋': 2,
    '鸌': 2,
    '鸎': 2,
    '鸏': 2,
    '鸐': 2,
    '鸑': 2,
    '鸒': 2,
    '鸓': 2,
    '鸕': 2,
    '鸖': 2,
    '鸗': 2,
    '鸘': 2,
    '鸙': 2,
    '鸚': 2,
    '鸛': 2,
    '鸜': 2,
    '鸝': 2,
    '鸞': 2,
    '鸟': 1,
    '鸠': 1,
    '鸡': 1,
    '鸢': 1,
    '鸣': 1,
    '鸤': 1,
    '鸥': 1,
    '鸦': 1,
    '鸧': 1,
    '鸨': 1,
    '鸩': 1,
    '鸪': 1,
    '鸫': 1,
    '鸬': 1,
    '鸭': 1,
    '鸮': 1,
    '鸯': 1,
    '鸰': 1,
    '鸱': 1,
    '鸲': 1,
    '鸳': 1,
    '鸴': 1,
    '鸵': 1,
    '鸶': 1,
    '鸷': 1,
    '鸸': 1,
    '鸹': 1,
    '鸺': 1,
    '鸻': 1,
    '鸼': 1,
    '鸽': 1,
    '鸾': 1,
    '鸿': 1,
    '鹀': 1,
    '鹁': 1,
    '鹂': 1,
    '鹃': 1,
    '鹄': 1,
    '鹅': 1,
    '鹆': 1,
    '鹇': 1,
    '鹈': 1,
    '鹉': 1,
    '鹊': 1,
    '鹋': 1,
    '鹌': 1,
    '鹍': 1,
    '鹎': 1,
    '鹏': 1,
    '鹐': 1,
    '鹑': 1,
    '鹒': 1,
    '鹓': 1,
    '鹔': 1,
    '鹕': 1,
    '鹖': 1,
    '鹗': 1,
    '鹘': 1,
    '鹙': 1,
    '鹚': 1,
    '鹛': 1,
    '鹜': 1,
    '鹝': 1,
    '鹞': 1,
    '鹟': 1,
    '鹠': 1,
    '鹡': 1,
    '鹢': 1,
    '鹣': 1,
    '鹤': 1,
    '鹥': 1,
    '鹦': 1,
    '鹧': 1,
    '鹨': 1,
    '鹩': 1,
    '鹪': 1,
    '鹫': 1,
    '鹬': 1,
    '鹭': 1,
    '鹮': 1,
    '鹯': 1,
    '鹰': 1,
    '鹱': 1,
    '鹲': 1,
    '鹳': 1,
    '鹴': 1,
    '鹵': 2,
    '鹹': 2,
    '鹺': 2,
    '鹼': 2,
    '鹽': 2,
    '鹾': 1,
    '麗': 2,
    '麡': 2,
    '麥': 2,
    '麦': 3,
    '麧': 2,
    '麨': 2,
    '麩': 2,
    '麬': 2,
    '麮': 2,
    '麯': 2,
    '麰': 2,
    '麱': 2,
    '麲': 2,
    '麳': 2,
    '麴': 2,
    '麵': 2,
    '麷': 2,
    '麸': 1,
    '麹': 1,
    '麼': 2,
    '麽': 2,
    '黂': 2,
    '黃': 2,
    '黄': 3,
    '黉': 1,
    '黌': 2,
    '點': 2,
    '黡': 1,
    '黨': 2,
    '黩': 1,
    '黪': 1,
    '黲': 2,
    '黴': 2,
    '黶': 2,
    '黷': 2,
    '黸': 2,
    '黽': 2,
    '黾': 3,
    '黿': 2,
    '鼀': 2,
    '鼁': 2,
    '鼂': 2,
    '鼄': 2,
    '鼅': 2,
    '鼆': 2,
    '鼈': 2,
    '鼉': 2,
    '鼊': 2,
    '鼋': 1,
    '鼌': 1,
    '鼍': 1,
    '鼕': 2,
    '鼗': 3,
    '鼚': 2,
    '鼲': 2,
    '鼴': 2,
    '鼹': 3,
    '齈': 2,
    '齊': 2,
    '齋': 2,
    '齌': 2,
    '齍': 2,
    '齎': 2,
    '齏': 2,
    '齐': 1,
    '齑': 1,
    '齒': 2,
    '齔': 2,
    '齕': 2,
    '齖': 2,
    '齗': 2,
    '齘': 2,
    '齙': 2,
    '齚': 2,
    '齜': 2,
    '齝': 2,
    '齞': 2,
    '齟': 2,
    '齠': 2,
    '齡': 2,
    '齣': 2,
    '齤': 2,
    '齥': 2,
    '齦': 2,
    '齧': 2,
    '齩': 2,
    '齪': 2,
    '齬': 2,
    '齭': 2,
    '齮': 2,
    '齯': 2,
    '齰': 2,
    '齱': 2,
    '齲': 2,
    '齳': 2,
    '齴': 2,
    '齵': 2,
    '齶': 2,
    '齷': 2,
    '齸': 2,
    '齹': 2,
    '齺': 2,
    '齻': 2,
    '齼': 2,
    '齽': 2,
    '齾': 2,
    '齿': 1,
    '龀': 1,
    '龁': 1,
    '龂': 1,
    '龃': 1,
    '龄': 1,
    '龅': 1,
    '龆': 1,
    '龇': 1,
    '龈': 1,
    '龉': 1,
    '龊': 1,
    '龋': 1,
    '龌': 1,
    '龍': 2,
    '龎': 2,
    '龏': 2,
    '龐': 2,
    '龑': 2,
    '龓': 2,
    '龔': 2,
    '龕': 2,
    '龖': 2,
    '龘': 2,
    '龙': 1,
    '龚': 1,
    '龛': 1,
    '龜': 2,
    '龝': 2,
    '龞': 2,
    '龟': 3,
    '龥': 2,
    '龭': 2,
    '龯': 2,
    '龲': 2,
    '龻': 2,
    '龽': 2,
    '鿁': 2,
    '鿂': 2,
    '鿎': 1,
    '鿏': 1,
    '鿐': 2,
    '鿒': 1,
    '鿓': 2,
    '鿔': 1,
    '鿕': 1,
    '鿟': 1,
    '鿠': 2,
    '鿭': 1,
    '鿰': 1,
    '鿲': 1,
    '鿳': 2,
    '鿴': 1,
    '鿵': 1,
    '鿶': 1,
    '鿷': 1,
    '鿸': 1,
    '鿹': 1,
    '鿺': 1,
    '𠀾': 1,
    '𠁔': 2,
    '𠁞': 2,
    '𠂲': 1,
    '𠃓': 1,
    '𠆲': 1,
    '𠆿': 1,
    '𠇐': 1,
    '𠇹': 1,
    '𠉂': 1,
    '𠉗': 1,
    '𠌥': 2,
    '𠎅': 2,
    '𠎒': 2,
    '𠏄': 2,
    '𠏢': 2,
    '𠏮': 2,
    '𠏵': 2,
    '𠐇': 2,
    '𠐊': 2,
    '𠐍': 2,
    '𠐮': 2,
    '𠐽': 2,
    '𠑇': 2,
    '𠑙': 2,
    '𠑲': 2,
    '𠖥': 2,
    '𠖫': 2,
    '𠗿': 2,
    '𠘥': 2,
    '𠚳': 1,
    '𠛅': 1,
    '𠛆': 1,
    '𠛾': 1,
    '𠜲': 2,
    '𠝿': 2,
    '𠞆': 2,
    '𠞭': 2,
    '𠟪': 2,
    '𠠎': 2,
    '𠠏': 2,
    '𠠝': 2,
    '𠠫': 2,
    '𠡠': 1,
    '𠩘': 2,
    '𠩬': 2,
    '𠬙': 2,
    '𠬤': 1,
    '𠯟': 1,
    '𠯠': 1,
    '𠰷': 1,
    '𠱞': 1,
    '𠲥': 1,
    '𠳞': 1,
    '𠴢': 1,
    '𠵔': 2,
    '𠵘': 2,
    '𠵸': 1,
    '𠵹': 2,
    '𠵾': 1,
    '𠶸': 2,
    '𠶹': 2,
    '𠷌': 2,
    '𠷏': 2,
    '𠹛': 2,
    '𠺖': 2,
    '𠺮': 2,
    '𠼗': 2,
    '𠼤': 2,
    '𠼮': 2,
    '𠽈': 2,
    '𠽸': 2,
    '𠾬': 2,
    '𠿕': 2,
    '𠿘': 2,
    '𠿿': 2,
    '𡀠': 2,
    '𡀿': 2,
    '𡁚': 2,
    '𡁯': 2,
    '𡂒': 2,
    '𡂡': 2,
    '𡂿': 2,
    '𡃄': 2,
    '𡃈': 2,
    '𡃤': 2,
    '𡄔': 2,
    '𡄖': 2,
    '𡄣': 2,
    '𡄤': 2,
    '𡄩': 2,
    '𡅏': 2,
    '𡅘': 2,
    '𡅥': 2,
    '𡅧': 2,
    '𡈛': 1,
    '𡊑': 1,
    '𡋀': 1,
    '𡋗': 1,
    '𡋤': 1,
    '𡍫': 2,
    '𡏆': 1,
    '𡑍': 2,
    '𡑎': 2,
    '𡑑': 2,
    '𡑭': 2,
    '𡑯': 2,
    '𡒄': 1,
    '𡒶': 2,
    '𡓁': 2,
    '𡓗': 2,
    '𡓦': 2,
    '𡓾': 2,
    '𡗆': 2,
    '𡝠': 1,
    '𡞋': 1,
    '𡞱': 1,
    '𡞵': 2,
    '𡟫': 2,
    '𡠚': 2,
    '𡠟': 1,
    '𡠪': 2,
    '𡠹': 2,
    '𡡇': 1,
    '𡢃': 2,
    '𡢄': 2,
    '𡢘': 2,
    '𡢿': 2,
    '𡣨': 2,
    '𡤠': 2,
    '𡤡': 2,
    '𡤢': 2,
    '𡤫': 2,
    '𡤶': 2,
    '𡥧': 1,
    '𡭜': 1,
    '𡭬': 1,
    '𡮉': 2,
    '𡮣': 2,
    '𡮤': 2,
    '𡳃': 1,
    '𡳒': 1,
    '𡳳': 2,
    '𡵝': 1,
    '𡶴': 1,
    '𡷨': 2,
    '𡸃': 1,
    '𡸗': 2,
    '𡹬': 2,
    '𡺃': 1,
    '𡺠': 2,
    '𡺨': 2,
    '𡻘': 1,
    '𡼱': 2,
    '𡼾': 2,
    '𡽗': 2,
    '𡽳': 2,
    '𡽵': 2,
    '𡾆': 2,
    '𡾱': 2,
    '𡿖': 2,
    '𢀖': 1,
    '𢄋': 2,
    '𢄓': 2,
    '𢄼': 2,
    '𢅡': 2,
    '𢅣': 2,
    '𢉿': 2,
    '𢊃': 2,
    '𢋈': 1,
    '𢍰': 2,
    '𢐗': 2,
    '𢐟': 2,
    '𢓅': 1,
    '𢕩': 2,
    '𢖕': 2,
    '𢗓': 1,
    '𢘙': 1,
    '𢘝': 1,
    '𢘞': 1,
    '𢙐': 1,
    '𢙑': 1,
    '𢙒': 1,
    '𢙓': 1,
    '𢛔': 2,
    '𢛯': 1,
    '𢜭': 2,
    '𢞁': 2,
    '𢟼': 1,
    '𢠰': 2,
    '𢠼': 2,
    '𢢀': 2,
    '𢣏': 2,
    '𢣐': 2,
    '𢣚': 2,
    '𢣭': 2,
    '𢤌': 2,
    '𢤜': 2,
    '𢤧': 2,
    '𢤩': 2,
    '𢤱': 2,
    '𢤿': 2,
    '𢥠': 2,
    '𢧐': 1,
    '𢪓': 1,
    '𢪗': 1,
    '𢫊': 1,
    '𢫘': 1,
    '𢫞': 1,
    '𢫬': 1,
    '𢬍': 1,
    '𢬦': 1,
    '𢭏': 1,
    '𢯦': 2,
    '𢯩': 2,
    '𢯷': 2,
    '𢱡': 2,
    '𢲐': 2,
    '𢲩': 2,
    '𢲫': 2,
    '𢲸': 2,
    '𢲾': 2,
    '𢳂': 2,
    '𢳚': 2,
    '𢴦': 2,
    '𢴩': 2,
    '𢵣': 2,
    '𢵱': 2,
    '𢶑': 2,
    '𢶒': 2,
    '𢶣': 1,
    '𢶫': 2,
    '𢷃': 2,
    '𢷏': 2,
    '𢷞': 2,
    '𢷮': 2,
    '𢸁': 2,
    '𢸔': 2,
    '𢸙': 2,
    '𢸳': 2,
    '𢸴': 2,
    '𢸸': 2,
    '𢹏': 2,
    '𢹥': 2,
    '𢹼': 2,
    '𢹿': 2,
    '𢺎': 2,
    '𢺳': 2,
    '𢽾': 1,
    '𢿓': 2,
    '𢿡': 2,
    '𣀘': 2,
    '𣀷': 2,
    '𣀻': 2,
    '𣂈': 2,
    '𣃁': 1,
    '𣄸': 2,
    '𣆐': 1,
    '𣈣': 1,
    '𣈶': 2,
    '𣉼': 1,
    '𣊯': 2,
    '𣋋': 2,
    '𣋞': 2,
    '𣋪': 2,
    '𣌂': 2,
    '𣍐': 2,
    '𣍨': 1,
    '𣍯': 1,
    '𣍰': 1,
    '𣎄': 2,
    '𣎑': 1,
    '𣎜': 2,
    '𣏢': 1,
    '𣐕': 1,
    '𣐤': 1,
    '𣑝': 1,
    '𣑶': 1,
    '𣒌': 1,
    '𣒗': 1,
    '𣓿': 1,
    '𣔿': 2,
    '𣕲': 1,
    '𣗊': 1,
    '𣗋': 1,
    '𣘐': 1,
    '𣘓': 1,
    '𣘴': 1,
    '𣘷': 1,
    '𣘾': 1,
    '𣙎': 2,
    '𣙥': 1,
    '𣙿': 2,
    '𣚙': 2,
    '𣚚': 1,
    '𣛣': 2,
    '𣝕': 2,
    '𣝡': 2,
    '𣞁': 2,
    '𣞎': 1,
    '𣞐': 2,
    '𣞻': 2,
    '𣞼': 2,
    '𣠕': 2,
    '𣠩': 2,
    '𣠲': 2,
    '𣡌': 2,
    '𣡶': 2,
    '𣤋': 2,
    '𣤿': 2,
    '𣨼': 1,
    '𣩕': 2,
    '𣫒': 2,
    '𣭤': 1,
    '𣯣': 1,
    '𣯩': 2,
    '𣯴': 2,
    '𣯶': 2,
    '𣰛': 2,
    '𣰨': 2,
    '𣱝': 1,
    '𣲗': 1,
    '𣲘': 1,
    '𣳆': 1,
    '𣴇': 1,
    '𣵾': 2,
    '𣶩': 1,
    '𣶫': 1,
    '𣶯': 2,
    '𣸣': 1,
    '𣺼': 1,
    '𣺽': 1,
    '𣻏': 2,
    '𣻑': 2,
    '𣼊': 2,
    '𣼩': 2,
    '𣼼': 2,
    '𣽏': 2,
    '𣽷': 1,
    '𣾍': 1,
    '𣾷': 2,
    '𣿉': 2,
    '𣿭': 2,
    '𤀪': 2,
    '𤁐': 2,
    '𤁣': 2,
    '𤁪': 2,
    '𤄙': 2,
    '𤄷': 2,
    '𤅊': 2,
    '𤅙': 2,
    '𤅩': 2,
    '𤅷': 2,
    '𤆡': 1,
    '𤆢': 1,
    '𤆼': 2,
    '𤇃': 1,
    '𤇄': 1,
    '𤇭': 1,
    '𤇻': 1,
    '𤇾': 2,
    '𤈶': 1,
    '𤈷': 1,
    '𤊀': 1,
    '𤋏': 1,
    '𤍖': 2,
    '𤍜': 2,
    '𤎤': 2,
    '𤎱': 2,
    '𤎺': 1,
    '𤎻': 1,
    '𤏐': 2,
    '𤏩': 2,
    '𤏳': 2,
    '𤑚': 2,
    '𤑳': 2,
    '𤑹': 2,
    '𤒎': 2,
    '𤒦': 2,
    '𤒨': 2,
    '𤒻': 2,
    '𤓌': 2,
    '𤓎': 2,
    '𤓓': 2,
    '𤘀': 2,
    '𤙯': 1,
    '𤚴': 2,
    '𤛮': 2,
    '𤛱': 2,
    '𤜆': 2,
    '𤜵': 1,
    '𤝢': 1,
    '𤞃': 1,
    '𤞤': 1,
    '𤟤': 2,
    '𤠋': 1,
    '𤠔': 2,
    '𤠮': 2,
    '𤡲': 2,
    '𤢟': 2,
    '𤣎': 2,
    '𤣤': 2,
    '𤥭': 2,
    '𤥵': 2,
    '𤦀': 1,
    '𤦎': 2,
    '𤦩': 2,
    '𤧑': 2,
    '𤧸': 2,
    '𤩂': 2,
    '𤩊': 2,
    '𤩑': 2,
    '𤩝': 2,
    '𤩽': 1,
    '𤪤': 2,
    '𤪧': 2,
    '𤪺': 2,
    '𤫎': 2,
    '𤫟': 2,
    '𤫩': 2,
    '𤬅': 2,
    '𤮦': 2,
    '𤲓': 2,
    '𤲢': 2,
    '𤳄': 1,
    '𤳷': 2,
    '𤳸': 2,
    '𤶊': 1,
    '𤶧': 1,
    '𤷃': 2,
    '𤷽': 2,
    '𤸫': 2,
    '𤹺': 1,
    '𤺉': 2,
    '𤺔': 2,
    '𤻊': 1,
    '𤻜': 2,
    '𤻝': 2,
    '𤻲': 2,
    '𤼈': 2,
    '𤽯': 1,
    '𤾀': 1,
    '𤾉': 2,
    '𤿲': 1,
    '𥀬': 2,
    '𥀲': 2,
    '𥁢': 1,
    '𥂫': 2,
    '𥂸': 2,
    '𥅘': 1,
    '𥅴': 1,
    '𥆧': 1,
    '𥇔': 2,
    '𥇢': 1,
    '𥉸': 2,
    '𥋝': 2,
    '𥋟': 2,
    '𥌃': 2,
    '𥌚': 2,
    '𥎝': 1,
    '𥏝': 2,
    '𥐟': 1,
    '𥐯': 1,
    '𥐰': 1,
    '𥐻': 1,
    '𥔂': 2,
    '𥔬': 2,
    '𥕤': 1,
    '𥕥': 2,
    '𥖅': 2,
    '𥖏': 2,
    '𥖩': 2,
    '𥖲': 2,
    '𥗇': 2,
    '𥗴': 2,
    '𥗹': 2,
    '𥗺': 2,
    '𥗽': 2,
    '𥘃': 2,
    '𥚗': 2,
    '𥜐': 2,
    '𥜰': 2,
    '𥞦': 1,
    '𥞵': 2,
    '𥟂': 1,
    '𥢊': 2,
    '𥢢': 2,
    '𥢶': 2,
    '𥢷': 2,
    '𥣻': 2,
    '𥧂': 1,
    '𥨐': 2,
    '𥩺': 1,
    '𥪂': 2,
    '𥬀': 1,
    '𥬈': 1,
    '𥬞': 1,
    '𥬠': 1,
    '𥭉': 1,
    '𥮋': 1,
    '𥮜': 1,
    '𥮾': 1,
    '𥯤': 2,
    '𥱔': 1,
    '𥱸': 2,
    '𥳊': 2,
    '𥴨': 2,
    '𥴼': 2,
    '𥵃': 2,
    '𥵊': 2,
    '𥵛': 2,
    '𥵜': 2,
    '𥵝': 2,
    '𥸠': 2,
    '𥹥': 1,
    '𥺅': 1,
    '𥺇': 1,
    '𥺼': 2,
    '𥻤': 2,
    '𥻦': 2,
    '𥻵': 2,
    '𥼶': 2,
    '𥼽': 2,
    '𥽖': 2,
    '𥽭': 2,
    '𥽽': 2,
    '𥾂': 2,
    '𥾝': 2,
    '𥾯': 2,
    '𥿉': 2,
    '𥿊': 2,
    '𥿑': 2,
    '𥿯': 2,
    '𦀎': 2,
    '𦀖': 2,
    '𦁄': 2,
    '𦁕': 2,
    '𦁧': 2,
    '𦂅': 2,
    '𦂋': 2,
    '𦃄': 2,
    '𦃒': 2,
    '𦃘': 2,
    '𦃩': 2,
    '𦄋': 2,
    '𦄍': 2,
    '𦄧': 2,
    '𦄼': 2,
    '𦅇': 2,
    '𦅈': 2,
    '𦅋': 2,
    '𦅘': 2,
    '𦅷': 2,
    '𦆆': 2,
    '𦆈': 2,
    '𦆲': 2,
    '𦇎': 2,
    '𦇛': 2,
    '𦈈': 1,
    '𦈉': 1,
    '𦈋': 1,
    '𦈌': 1,
    '𦈎': 1,
    '𦈏': 1,
    '𦈐': 1,
    '𦈑': 1,
    '𦈒': 1,
    '𦈓': 1,
    '𦈔': 1,
    '𦈕': 1,
    '𦈖': 1,
    '𦈗': 1,
    '𦈘': 1,
    '𦈙': 1,
    '𦈚': 1,
    '𦈛': 1,
    '𦈜': 1,
    '𦈝': 1,
    '𦈞': 1,
    '𦈟': 1,
    '𦈠': 1,
    '𦈡': 1,
    '𦌾': 2,
    '𦍆': 2,
    '𦍠': 1,
    '𦎹': 2,
    '𦏑': 2,
    '𦒀': 2,
    '𦔖': 2,
    '𦘧': 2,
    '𦛨': 1,
    '𦜖': 2,
    '𦝛': 2,
    '𦝼': 1,
    '𦞌': 1,
    '𦞛': 2,
    '𦟐': 2,
    '𦟗': 1,
    '𦟼': 2,
    '𦠅': 2,
    '𦡏': 2,
    '𦡖': 2,
    '𦡝': 2,
    '𦡧': 2,
    '𦡶': 2,
    '𦢈': 2,
    '𦣇': 2,
    '𦣎': 2,
    '𦥯': 2,
    '𦧴': 2,
    '𦧺': 2,
    '𦨩': 1,
    '𦪭': 2,
    '𦪽': 2,
    '𦬙': 1,
    '𦭬': 1,
    '𦮜': 1,
    '𦰴': 1,
    '𦱌': 2,
    '𦳝': 2,
    '𦴇': 1,
    '𦴧': 2,
    '𦵕': 2,
    '𦶆': 2,
    '𦸷': 2,
    '𦺣': 2,
    '𦻕': 1,
    '𦼖': 1,
    '𦽒': 2,
    '𦾏': 2,
    '𦾵': 2,
    '𦾶': 2,
    '𦿍': 2,
    '𦿭': 2,
    '𧀀': 2,
    '𧁿': 2,
    '𧂂': 2,
    '𧂅': 2,
    '𧃽': 2,
    '𧈴': 1,
    '𧈿': 1,
    '𧉐': 1,
    '𧉞': 1,
    '𧍕': 2,
    '𧏖': 1,
    '𧏗': 1,
    '𧏻': 2,
    '𧐐': 2,
    '𧐱': 2,
    '𧑏': 1,
    '𧒖': 2,
    '𧒭': 1,
    '𧒯': 2,
    '𧔥': 2,
    '𧕟': 2,
    '𧕦': 2,
    '𧖦': 2,
    '𧛸': 2,
    '𧜁': 2,
    '𧜂': 2,
    '𧜗': 2,
    '𧜘': 2,
    '𧜡': 1,
    '𧜣': 2,
    '𧜭': 1,
    '𧜵': 2,
    '𧜶': 2,
    '𧝝': 1,
    '𧝞': 2,
    '𧞅': 2,
    '𧞔': 2,
    '𧞣': 2,
    '𧞫': 2,
    '𧞶': 2,
    '𧟌': 2,
    '𧠈': 2,
    '𧠥': 2,
    '𧠳': 2,
    '𧠵': 2,
    '𧡍': 2,
    '𧡪': 2,
    '𧡴': 2,
    '𧡸': 2,
    '𧢃': 2,
    '𧢄': 2,
    '𧢍': 2,
    '𧢢': 2,
    '𧣴': 2,
    '𧤤': 1,
    '𧥅': 1,
    '𧥣': 2,
    '𧥺': 2,
    '𧦝': 2,
    '𧦦': 2,
    '𧦧': 2,
    '𧦭': 2,
    '𧦵': 2,
    '𧧝': 2,
    '𧧭': 2,
    '𧧵': 2,
    '𧧸': 2,
    '𧨊': 2,
    '𧨝': 2,
    '𧨳': 2,
    '𧨾': 2,
    '𧩎': 2,
    '𧩕': 2,
    '𧩙': 2,
    '𧩦': 2,
    '𧩧': 2,
    '𧩪': 2,
    '𧩼': 2,
    '𧪞': 2,
    '𧪡': 2,
    '𧪦': 2,
    '𧪪': 2,
    '𧪮': 2,
    '𧫚': 2,
    '𧫝': 2,
    '𧬁': 2,
    '𧬅': 2,
    '𧬇': 2,
    '𧬌': 2,
    '𧬤': 2,
    '𧬨': 2,
    '𧬪': 2,
    '𧬮': 2,
    '𧬯': 2,
    '𧬻': 2,
    '𧭈': 2,
    '𧭥': 2,
    '𧭹': 2,
    '𧮆': 2,
    '𧮇': 2,
    '𧮈': 2,
    '𧮓': 2,
    '𧮪': 1,
    '𧰆': 2,
    '𧰎': 2,
    '𧱻': 2,
    '𧳕': 1,
    '𧳟': 2,
    '𧴪': 2,
    '𧵊': 2,
    '𧵳': 2,
    '𧶄': 2,
    '𧶔': 2,
    '𧶟': 2,
    '𧶧': 2,
    '𧶲': 2,
    '𧷎': 2,
    '𧷛': 2,
    '𧸖': 2,
    '𧸘': 2,
    '𧸦': 2,
    '𧸪': 2,
    '𧸫': 2,
    '𧹈': 2,
    '𧹑': 1,
    '𧹒': 1,
    '𧹓': 1,
    '𧹔': 1,
    '𧹕': 1,
    '𧹖': 1,
    '𧹗': 1,
    '𧺣': 1,
    '𧼮': 2,
    '𧽢': 2,
    '𧽯': 2,
    '𧽵': 2,
    '𧾥': 2,
    '𧿈': 1,
    '𧿛': 1,
    '𨀁': 1,
    '𨀱': 1,
    '𨁂': 2,
    '𨁴': 1,
    '𨂐': 2,
    '𨂺': 1,
    '𨃘': 2,
    '𨃜': 2,
    '𨄄': 1,
    '𨄉': 2,
    '𨄣': 2,
    '𨄰': 2,
    '𨅍': 2,
    '𨅛': 1,
    '𨅫': 1,
    '𨅬': 1,
    '𨆅': 2,
    '𨆉': 2,
    '𨆪': 2,
    '𨆱': 2,
    '𨇁': 2,
    '𨇍': 2,
    '𨇗': 2,
    '𨇞': 2,
    '𨇤': 2,
    '𨇯': 2,
    '𨇰': 2,
    '𨇽': 2,
    '𨈀': 2,
    '𨈆': 2,
    '𨈇': 2,
    '𨈊': 2,
    '𨈌': 2,
    '𨉖': 2,
    '𨉗': 1,
    '𨉹': 2,
    '𨊠': 2,
    '𨊰': 2,
    '𨊸': 2,
    '𨊹': 2,
    '𨊻': 2,
    '𨋁': 2,
    '𨋚': 2,
    '𨋢': 2,
    '𨋮': 2,
    '𨌄': 2,
    '𨌈': 2,
    '𨍈': 2,
    '𨍏': 2,
    '𨍐': 2,
    '𨍒': 2,
    '𨍰': 2,
    '𨍹': 2,
    '𨎌': 2,
    '𨎩': 2,
    '𨎪': 2,
    '𨎮': 2,
    '𨏒': 2,
    '𨏔': 2,
    '𨏠': 2,
    '𨏥': 2,
    '𨐅': 1,
    '𨐆': 1,
    '𨐇': 1,
    '𨐈': 1,
    '𨐉': 1,
    '𨐊': 1,
    '𨐶': 2,
    '𨑊': 2,
    '𨑹': 1,
    '𨘀': 2,
    '𨘌': 2,
    '𨝕': 1,
    '𨞨': 2,
    '𨞪': 2,
    '𨞺': 2,
    '𨟊': 2,
    '𨟑': 2,
    '𨟳': 1,
    '𨠨': 1,
    '𨡙': 1,
    '𨡺': 1,
    '𨢸': 1,
    '𨢿': 2,
    '𨣃': 2,
    '𨣈': 2,
    '𨣉': 2,
    '𨣞': 2,
    '𨣧': 2,
    '𨣨': 2,
    '𨤋': 2,
    '𨤡': 2,
    '𨤰': 1,
    '𨤻': 2,
    '𨥈': 2,
    '𨥕': 2,
    '𨥛': 2,
    '𨥜': 2,
    '𨥟': 2,
    '𨥤': 2,
    '𨥦': 2,
    '𨥭': 2,
    '𨥮': 2,
    '𨥺': 2,
    '𨦍': 2,
    '𨦡': 2,
    '𨦫': 2,
    '𨦱': 2,
    '𨧀': 2,
    '𨧐': 2,
    '𨧚': 2,
    '𨧜': 2,
    '𨧫': 2,
    '𨧮': 1,
    '𨧰': 2,
    '𨧱': 2,
    '𨨏': 2,
    '𨨛': 2,
    '𨨝': 2,
    '𨨢': 2,
    '𨨯': 2,
    '𨨹': 2,
    '𨩃': 2,
    '𨩎': 2,
    '𨩨': 2,
    '𨩰': 2,
    '𨪅': 2,
    '𨪋': 2,
    '𨪕': 2,
    '𨪜': 2,
    '𨪦': 2,
    '𨫀': 2,
    '𨫋': 2,
    '𨫒': 2,
    '𨫼': 2,
    '𨬂': 2,
    '𨬒': 2,
    '𨬖': 2,
    '𨬞': 2,
    '𨬟': 2,
    '𨭃': 2,
    '𨭆': 2,
    '𨭌': 2,
    '𨭎': 2,
    '𨭐': 2,
    '𨭖': 2,
    '𨭗': 2,
    '𨭚': 2,
    '𨭛': 2,
    '𨭥': 2,
    '𨭸': 2,
    '𨮁': 2,
    '𨮂': 2,
    '𨮅': 2,
    '𨮰': 2,
    '𨮳': 2,
    '𨯂': 2,
    '𨯅': 2,
    '𨯗': 2,
    '𨯙': 2,
    '𨯟': 2,
    '𨯵': 2,
    '𨰃': 2,
    '𨰋': 2,
    '𨰘': 2,
    '𨰠': 2,
    '𨰥': 2,
    '𨰭': 2,
    '𨰲': 2,
    '𨰵': 2,
    '𨰷': 2,
    '𨰹': 2,
    '𨰾': 1,
    '𨰿': 1,
    '𨱀': 1,
    '𨱁': 1,
    '𨱂': 1,
    '𨱃': 1,
    '𨱄': 1,
    '𨱅': 1,
    '𨱆': 1,
    '𨱇': 1,
    '𨱈': 1,
    '𨱉': 1,
    '𨱊': 1,
    '𨱋': 1,
    '𨱌': 1,
    '𨱍': 1,
    '𨱎': 1,
    '𨱏': 1,
    '𨱐': 1,
    '𨱑': 1,
    '𨱒': 1,
    '𨱓': 1,
    '𨱔': 1,
    '𨱕': 1,
    '𨱖': 1,
    '𨱥': 2,
    '𨲭': 2,
    '𨲳': 2,
    '𨳌': 2,
    '𨳐': 2,
    '𨳑': 2,
    '𨳒': 2,
    '𨳕': 2,
    '𨳙': 2,
    '𨳚': 2,
    '𨳨': 2,
    '𨳸': 2,
    '𨳿': 2,
    '𨴑': 2,
    '𨴗': 2,
    '𨴤': 2,
    '𨴹': 2,
    '𨵆': 2,
    '𨵌': 2,
    '𨵗': 2,
    '𨵤': 2,
    '𨵦': 2,
    '𨵩': 2,
    '𨵬': 2,
    '𨵸': 2,
    '𨶀': 2,
    '𨶏': 2,
    '𨶑': 2,
    '𨶮': 2,
    '𨶯': 2,
    '𨶰': 2,
    '𨶲': 2,
    '𨶻': 2,
    '𨶿': 2,
    '𨷈': 2,
    '𨷲': 2,
    '𨷻': 2,
    '𨷿': 1,
    '𨸀': 1,
    '𨸁': 1,
    '𨸂': 1,
    '𨸃': 1,
    '𨸄': 1,
    '𨸅': 1,
    '𨸆': 1,
    '𨸇': 1,
    '𨸉': 1,
    '𨸊': 1,
    '𨸋': 1,
    '𨸌': 1,
    '𨸎': 1,
    '𨸘': 1,
    '𨸟': 1,
    '𨻹': 1,
    '𨼳': 2,
    '𨽈': 2,
    '𨽏': 2,
    '𩀨': 2,
    '𩅙': 2,
    '𩅦': 2,
    '𩅾': 2,
    '𩇉': 2,
    '𩉍': 2,
    '𩉙': 2,
    '𩋬': 2,
    '𩋰': 2,
    '𩍜': 2,
    '𩎒': 2,
    '𩎕': 2,
    '𩎖': 2,
    '𩎟': 2,
    '𩎠': 2,
    '𩎢': 2,
    '𩏂': 2,
    '𩏌': 2,
    '𩏠': 2,
    '𩏪': 2,
    '𩏴': 2,
    '𩏷': 2,
    '𩏼': 1,
    '𩏽': 1,
    '𩏾': 1,
    '𩏿': 1,
    '𩐀': 1,
    '𩐌': 2,
    '𩐳': 2,
    '𩑃': 2,
    '𩑒': 2,
    '𩑔': 2,
    '𩑡': 2,
    '𩑣': 2,
    '𩑦': 2,
    '𩒎': 2,
    '𩒜': 2,
    '𩒝': 2,
    '𩒲': 2,
    '𩒺': 2,
    '𩒼': 2,
    '𩓣': 2,
    '𩓥': 2,
    '𩓸': 2,
    '𩓹': 2,
    '𩔇': 2,
    '𩔈': 2,
    '𩔊': 2,
    '𩔐': 2,
    '𩔑': 2,
    '𩔣': 2,
    '𩔳': 2,
    '𩕊': 2,
    '𩕰': 2,
    '𩖁': 2,
    '𩖕': 1,
    '𩖖': 1,
    '𩖗': 1,
    '𩖰': 2,
    '𩖿': 2,
    '𩗀': 2,
    '𩗓': 2,
    '𩗛': 2,
    '𩗡': 2,
    '𩗩': 2,
    '𩗴': 2,
    '𩗺': 2,
    '𩘀': 2,
    '𩘚': 2,
    '𩘝': 2,
    '𩘹': 2,
    '𩘺': 2,
    '𩘻': 2,
    '𩙈': 2,
    '𩙥': 1,
    '𩙦': 1,
    '𩙧': 1,
    '𩙨': 1,
    '𩙩': 1,
    '𩙪': 1,
    '𩙫': 1,
    '𩙬': 1,
    '𩙭': 1,
    '𩙮': 1,
    '𩙯': 1,
    '𩙰': 1,
    '𩚅': 2,
    '𩚚': 2,
    '𩚛': 2,
    '𩚥': 2,
    '𩚩': 2,
    '𩚵': 2,
    '𩛆': 2,
    '𩛌': 2,
    '𩛎': 2,
    '𩛞': 2,
    '𩛡': 2,
    '𩛩': 2,
    '𩛲': 2,
    '𩜇': 2,
    '𩜠': 2,
    '𩜦': 2,
    '𩜯': 2,
    '𩜰': 2,
    '𩜵': 2,
    '𩜶': 2,
    '𩝑': 2,
    '𩝔': 2,
    '𩝠': 2,
    '𩝡': 2,
    '𩝣': 2,
    '𩝧': 2,
    '𩝽': 2,
    '𩞃': 2,
    '𩞄': 2,
    '𩞆': 2,
    '𩞉': 2,
    '𩞡': 2,
    '𩞦': 2,
    '𩞧': 2,
    '𩞬': 2,
    '𩞯': 2,
    '𩟀': 2,
    '𩟂': 2,
    '𩟐': 2,
    '𩟗': 2,
    '𩟠': 2,
    '𩟿': 1,
    '𩠀': 1,
    '𩠁': 1,
    '𩠂': 1,
    '𩠃': 1,
    '𩠅': 1,
    '𩠆': 1,
    '𩠇': 1,
    '𩠈': 1,
    '𩠉': 1,
    '𩠊': 1,
    '𩠋': 1,
    '𩠌': 1,
    '𩠎': 1,
    '𩠏': 1,
    '𩠠': 1,
    '𩠴': 2,
    '𩡖': 1,
    '𩡚': 1,
    '𩡣': 2,
    '𩡤': 2,
    '𩡺': 2,
    '𩢀': 2,
    '𩢍': 2,
    '𩢖': 2,
    '𩢡': 2,
    '𩢰': 2,
    '𩢲': 2,
    '𩢴': 2,
    '𩢸': 2,
    '𩢼': 2,
    '𩢾': 2,
    '𩣊': 2,
    '𩣋': 2,
    '𩣏': 2,
    '𩣑': 2,
    '𩣔': 2,
    '𩣡': 2,
    '𩣫': 2,
    '𩣵': 2,
    '𩣺': 2,
    '𩤊': 2,
    '𩤙': 2,
    '𩤲': 2,
    '𩤵': 2,
    '𩤸': 2,
    '𩥃': 2,
    '𩥄': 2,
    '𩥅': 2,
    '𩥇': 2,
    '𩥈': 2,
    '𩥉': 2,
    '𩥎': 2,
    '𩥑': 2,
    '𩥲': 2,
    '𩥼': 2,
    '𩦃': 2,
    '𩦚': 2,
    '𩦠': 2,
    '𩦺': 2,
    '𩧆': 2,
    '𩧉': 2,
    '𩧐': 2,
    '𩧢': 2,
    '𩧦': 1,
    '𩧨': 1,
    '𩧩': 1,
    '𩧪': 1,
    '𩧫': 1,
    '𩧬': 1,
    '𩧭': 1,
    '𩧮': 1,
    '𩧯': 1,
    '𩧰': 1,
    '𩧱': 1,
    '𩧲': 1,
    '𩧳': 1,
    '𩧴': 1,
    '𩧵': 1,
    '𩧶': 1,
    '𩧸': 1,
    '𩧺': 1,
    '𩧻': 1,
    '𩧼': 1,
    '𩧿': 1,
    '𩨀': 1,
    '𩨁': 1,
    '𩨃': 1,
    '𩨄': 1,
    '𩨅': 1,
    '𩨆': 1,
    '𩨇': 1,
    '𩨈': 1,
    '𩨉': 1,
    '𩨊': 1,
    '𩨋': 1,
    '𩨌': 1,
    '𩨍': 1,
    '𩨎': 1,
    '𩨏': 1,
    '𩨐': 1,
    '𩩈': 1,
    '𩬣': 1,
    '𩬤': 1,
    '𩬾': 1,
    '𩭙': 2,
    '𩭯': 2,
    '𩭹': 1,
    '𩯁': 2,
    '𩯃': 2,
    '𩯆': 2,
    '𩯒': 1,
    '𩯳': 2,
    '𩰀': 2,
    '𩰰': 1,
    '𩰹': 2,
    '𩱈': 2,
    '𩲒': 1,
    '𩳤': 2,
    '𩴆': 2,
    '𩴌': 1,
    '𩴵': 2,
    '𩵚': 2,
    '𩵦': 2,
    '𩵩': 2,
    '𩵱': 2,
    '𩵳': 2,
    '𩵹': 2,
    '𩵺': 2,
    '𩶀': 2,
    '𩶁': 2,
    '𩶘': 2,
    '𩶯': 2,
    '𩶰': 2,
    '𩶱': 2,
    '𩷒': 2,
    '𩷓': 2,
    '𩷕': 2,
    '𩷰': 2,
    '𩷶': 2,
    '𩸃': 2,
    '𩸄': 2,
    '𩸆': 2,
    '𩸡': 2,
    '𩸣': 2,
    '𩸤': 2,
    '𩸦': 2,
    '𩸩': 2,
    '𩸬': 2,
    '𩹂': 2,
    '𩹊': 2,
    '𩹎': 2,
    '𩹝': 2,
    '𩹽': 2,
    '𩹾': 2,
    '𩺝': 2,
    '𩺞': 2,
    '𩻗': 2,
    '𩻛': 2,
    '𩻧': 2,
    '𩻬': 2,
    '𩻮': 2,
    '𩻰': 2,
    '𩻱': 2,
    '𩼔': 2,
    '𩼶': 2,
    '𩽅': 2,
    '𩽇': 2,
    '𩽈': 2,
    '𩽔': 2,
    '𩽷': 2,
    '𩽹': 1,
    '𩽺': 1,
    '𩽻': 1,
    '𩽼': 1,
    '𩽽': 1,
    '𩽾': 1,
    '𩽿': 1,
    '𩾁': 1,
    '𩾂': 1,
    '𩾃': 1,
    '𩾄': 1,
    '𩾅': 1,
    '𩾆': 1,
    '𩾇': 1,
    '𩾈': 1,
    '𩾊': 1,
    '𩾋': 1,
    '𩾌': 1,
    '𩾎': 1,
    '𩾐': 2,
    '𩾒': 2,
    '𩾝': 2,
    '𩿅': 2,
    '𩿊': 2,
    '𩿤': 2,
    '𩿧': 2,
    '𩿪': 2,
    '𩿱': 2,
    '𩿺': 2,
    '𪀉': 2,
    '𪀖': 2,
    '𪀗': 2,
    '𪀚': 2,
    '𪀛': 2,
    '𪀦': 2,
    '𪀻': 2,
    '𪀾': 2,
    '𪁈': 2,
    '𪁏': 2,
    '𪁐': 2,
    '𪁑': 2,
    '𪁖': 2,
    '𪁛': 2,
    '𪁜': 2,
    '𪁱': 2,
    '𪁿': 2,
    '𪂆': 2,
    '𪂈': 2,
    '𪂩': 2,
    '𪂫': 2,
    '𪃃': 2,
    '𪃍': 2,
    '𪃏': 2,
    '𪃒': 2,
    '𪃦': 2,
    '𪃧': 2,
    '𪃮': 2,
    '𪃿': 2,
    '𪄅': 2,
    '𪄆': 2,
    '𪄕': 2,
    '𪄠': 2,
    '𪄲': 2,
    '𪄳': 2,
    '𪅂': 2,
    '𪅃': 2,
    '𪅖': 2,
    '𪅜': 2,
    '𪅾': 2,
    '𪆃': 2,
    '𪆫': 2,
    '𪆰': 2,
    '𪆴': 2,
    '𪆷': 2,
    '𪇄': 2,
    '𪇖': 2,
    '𪇘': 2,
    '𪇰': 2,
    '𪇳': 2,
    '𪈏': 2,
    '𪈔': 2,
    '𪈗': 2,
    '𪈼': 2,
    '𪉂': 1,
    '𪉃': 1,
    '𪉄': 1,
    '𪉅': 1,
    '𪉆': 1,
    '𪉈': 1,
    '𪉉': 1,
    '𪉊': 1,
    '𪉋': 1,
    '𪉌': 1,
    '𪉍': 1,
    '𪉎': 1,
    '𪉏': 1,
    '𪉐': 1,
    '𪉑': 1,
    '𪉒': 1,
    '𪉔': 1,
    '𪉕': 1,
    '𪉖': 2,
    '𪉜': 2,
    '𪉣': 2,
    '𪉨': 2,
    '𪉮': 2,
    '𪉱': 2,
    '𪉸': 2,
    '𪉿': 2,
    '𪊉': 2,
    '𪋈': 1,
    '𪋼': 2,
    '𪋽': 2,
    '𪋿': 2,
    '𪌐': 2,
    '𪌒': 2,
    '𪌗': 2,
    '𪌘': 2,
    '𪌜': 2,
    '𪌣': 2,
    '𪌨': 2,
    '𪌬': 2,
    '𪌭': 2,
    '𪌮': 2,
    '𪌯': 2,
    '𪌰': 2,
    '𪌽': 2,
    '𪌾': 2,
    '𪌿': 2,
    '𪍀': 2,
    '𪍇': 2,
    '𪍍': 2,
    '𪍑': 2,
    '𪍒': 2,
    '𪍓': 2,
    '𪍘': 2,
    '𪍚': 2,
    '𪍞': 2,
    '𪍠': 2,
    '𪍣': 2,
    '𪍤': 2,
    '𪍬': 2,
    '𪍴': 2,
    '𪍶': 2,
    '𪍷': 2,
    '𪍿': 2,
    '𪎂': 2,
    '𪎈': 1,
    '𪎉': 1,
    '𪎊': 1,
    '𪎋': 1,
    '𪎌': 1,
    '𪑅': 1,
    '𪑚': 2,
    '𪑳': 2,
    '𪒬': 2,
    '𪒿': 2,
    '𪓛': 2,
    '𪓬': 2,
    '𪓰': 2,
    '𪓹': 2,
    '𪓽': 2,
    '𪔭': 1,
    '𪔵': 2,
    '𪕣': 2,
    '𪖨': 2,
    '𪗋': 2,
    '𪗜': 2,
    '𪗝': 2,
    '𪗪': 2,
    '𪗭': 2,
    '𪗳': 2,
    '𪗻': 2,
    '𪗽': 2,
    '𪘀': 2,
    '𪘅': 2,
    '𪘓': 2,
    '𪘞': 2,
    '𪘥': 2,
    '𪘧': 2,
    '𪘨': 2,
    '𪘩': 2,
    '𪘬': 2,
    '𪘯': 2,
    '𪘲': 2,
    '𪙉': 2,
    '𪙍': 2,
    '𪙏': 2,
    '𪙑': 2,
    '𪙕': 2,
    '𪙞': 2,
    '𪙤': 2,
    '𪚅': 2,
    '𪚏': 1,
    '𪚐': 1,
    '𪚔': 2,
    '𪚣': 2,
    '𪚭': 2,
    '𪚮': 2,
    '𪚰': 2,
    '𪛕': 2,
    '𪛞': 1,
    '𪜎': 1,
    '𪜺': 1,
    '𪝖': 2,
    '𪝵': 2,
    '𪞝': 1,
    '𪟎': 1,
    '𪟖': 2,
    '𪟝': 1,
    '𪟲': 1,
    '𪠀': 1,
    '𪠃': 1,
    '𪠏': 1,
    '𪠟': 1,
    '𪠡': 1,
    '𪠳': 1,
    '𪠵': 1,
    '𪠸': 1,
    '𪠽': 1,
    '𪡀': 1,
    '𪡃': 1,
    '𪡋': 1,
    '𪡏': 1,
    '𪡛': 1,
    '𪡞': 1,
    '𪡺': 1,
    '𪢈': 1,
    '𪢋': 1,
    '𪢌': 1,
    '𪢍': 2,
    '𪢐': 1,
    '𪢒': 1,
    '𪢕': 1,
    '𪢠': 1,
    '𪢥': 2,
    '𪢮': 1,
    '𪣆': 1,
    '𪣒': 1,
    '𪣻': 1,
    '𪤄': 1,
    '𪤅': 1,
    '𪤚': 1,
    '𪥠': 1,
    '𪥫': 1,
    '𪥰': 1,
    '𪥿': 1,
    '𪦯': 2,
    '𪧀': 1,
    '𪧘': 1,
    '𪨇': 1,
    '𪨊': 1,
    '𪨗': 1,
    '𪨧': 1,
    '𪨩': 1,
    '𪨶': 1,
    '𪨷': 1,
    '𪨹': 1,
    '𪩇': 1,
    '𪩎': 1,
    '𪩘': 1,
    '𪩛': 1,
    '𪩸': 1,
    '𪪑': 1,
    '𪪞': 1,
    '𪪴': 1,
    '𪫌': 1,
    '𪫡': 1,
    '𪫷': 1,
    '𪫸': 1,
    '𪫺': 1,
    '𪬚': 1,
    '𪬯': 1,
    '𪭝': 1,
    '𪭢': 1,
    '𪭧': 1,
    '𪭯': 1,
    '𪭵': 1,
    '𪭾': 1,
    '𪮃': 1,
    '𪮋': 1,
    '𪮖': 1,
    '𪮰': 2,
    '𪮳': 1,
    '𪮶': 1,
    '𪯂': 2,
    '𪯋': 1,
    '𪰶': 1,
    '𪱥': 1,
    '𪱷': 1,
    '𪲎': 1,
    '𪲔': 1,
    '𪲛': 1,
    '𪲮': 1,
    '𪳍': 1,
    '𪳷': 2,
    '𪴙': 1,
    '𪴥': 2,
    '𪴯': 1,
    '𪵇': 1,
    '𪵑': 1,
    '𪵢': 2,
    '𪵣': 1,
    '𪵱': 1,
    '𪶄': 1,
    '𪶒': 1,
    '𪶮': 1,
    '𪷈': 2,
    '𪷍': 1,
    '𪷽': 1,
    '𪸕': 1,
    '𪸩': 1,
    '𪹀': 1,
    '𪹠': 1,
    '𪹳': 1,
    '𪹹': 1,
    '𪺣': 1,
    '𪺪': 1,
    '𪺭': 1,
    '𪺷': 1,
    '𪺸': 1,
    '𪺻': 1,
    '𪺽': 1,
    '𪻐': 1,
    '𪻨': 1,
    '𪻲': 1,
    '𪻺': 1,
    '𪼋': 1,
    '𪼑': 2,
    '𪼴': 1,
    '𪽂': 1,
    '𪽝': 1,
    '𪽪': 1,
    '𪽭': 1,
    '𪽮': 1,
    '𪽴': 1,
    '𪽷': 1,
    '𪾔': 1,
    '𪾢': 1,
    '𪾦': 1,
    '𪾳': 2,
    '𪾸': 1,
    '𪿊': 1,
    '𪿞': 1,
    '𪿫': 1,
    '𪿵': 1,
    '𫀌': 1,
    '𫀓': 1,
    '𫀨': 1,
    '𫀬': 1,
    '𫀮': 1,
    '𫁂': 1,
    '𫁟': 1,
    '𫁡': 1,
    '𫁲': 1,
    '𫁳': 1,
    '𫁷': 1,
    '𫁺': 1,
    '𫂃': 1,
    '𫂆': 1,
    '𫂈': 1,
    '𫂖': 1,
    '𫂿': 1,
    '𫃐': 2,
    '𫃑': 2,
    '𫃗': 1,
    '𫃞': 2,
    '𫃥': 2,
    '𫃷': 2,
    '𫃻': 2,
    '𫄇': 2,
    '𫄙': 1,
    '𫄚': 1,
    '𫄛': 1,
    '𫄜': 1,
    '𫄝': 1,
    '𫄞': 1,
    '𫄟': 1,
    '𫄠': 1,
    '𫄡': 1,
    '𫄢': 1,
    '𫄣': 1,
    '𫄤': 1,
    '𫄥': 1,
    '𫄦': 1,
    '𫄧': 1,
    '𫄨': 1,
    '𫄩': 1,
    '𫄪': 1,
    '𫄫': 1,
    '𫄬': 1,
    '𫄭': 1,
    '𫄮': 1,
    '𫄯': 1,
    '𫄰': 1,
    '𫄱': 1,
    '𫄲': 1,
    '𫄳': 1,
    '𫄴': 1,
    '𫄵': 1,
    '𫄶': 1,
    '𫄷': 1,
    '𫄸': 1,
    '𫄹': 1,
    '𫅅': 1,
    '𫅗': 1,
    '𫅥': 1,
    '𫅭': 1,
    '𫅼': 1,
    '𫆏': 1,
    '𫆝': 1,
    '𫆫': 1,
    '𫇘': 1,
    '𫇠': 2,
    '𫇦': 1,
    '𫇪': 1,
    '𫇭': 1,
    '𫇴': 1,
    '𫇽': 1,
    '𫈉': 1,
    '𫈎': 1,
    '𫈟': 1,
    '𫈵': 1,
    '𫈹': 2,
    '𫉁': 1,
    '𫉄': 1,
    '𫉍': 2,
    '𫊪': 1,
    '𫊮': 1,
    '𫊱': 1,
    '𫊸': 1,
    '𫊹': 1,
    '𫊻': 1,
    '𫋇': 1,
    '𫋌': 1,
    '𫋐': 2,
    '𫋧': 2,
    '𫋲': 1,
    '𫋷': 1,
    '𫋹': 1,
    '𫋻': 1,
    '𫌀': 1,
    '𫌇': 1,
    '𫌋': 1,
    '𫌙': 2,
    '𫌨': 1,
    '𫌩': 1,
    '𫌪': 1,
    '𫌫': 1,
    '𫌬': 1,
    '𫌭': 1,
    '𫌯': 1,
    '𫍏': 1,
    '𫍐': 1,
    '𫍘': 2,
    '𫍙': 1,
    '𫍚': 1,
    '𫍛': 1,
    '𫍜': 1,
    '𫍞': 1,
    '𫍟': 1,
    '𫍠': 1,
    '𫍡': 1,
    '𫍢': 1,
    '𫍣': 1,
    '𫍤': 1,
    '𫍥': 1,
    '𫍦': 1,
    '𫍧': 1,
    '𫍨': 1,
    '𫍩': 1,
    '𫍪': 1,
    '𫍫': 1,
    '𫍬': 1,
    '𫍭': 1,
    '𫍮': 1,
    '𫍯': 1,
    '𫍰': 1,
    '𫍱': 1,
    '𫍲': 1,
    '𫍳': 1,
    '𫍴': 1,
    '𫍵': 1,
    '𫍶': 1,
    '𫍷': 1,
    '𫍸': 1,
    '𫍹': 1,
    '𫍺': 1,
    '𫍻': 1,
    '𫍼': 1,
    '𫍽': 1,
    '𫍾': 1,
    '𫍿': 1,
    '𫎆': 1,
    '𫎌': 1,
    '𫎦': 1,
    '𫎧': 1,
    '𫎨': 1,
    '𫎩': 1,
    '𫎪': 1,
    '𫎫': 1,
    '𫎬': 1,
    '𫎭': 1,
    '𫎱': 1,
    '𫎳': 1,
    '𫎸': 1,
    '𫎺': 1,
    '𫏃': 1,
    '𫏆': 1,
    '𫏋': 1,
    '𫏌': 1,
    '𫏐': 1,
    '𫏑': 1,
    '𫏕': 1,
    '𫏞': 1,
    '𫏨': 1,
    '𫐄': 1,
    '𫐅': 1,
    '𫐆': 1,
    '𫐇': 1,
    '𫐈': 1,
    '𫐉': 1,
    '𫐊': 1,
    '𫐋': 1,
    '𫐌': 1,
    '𫐍': 1,
    '𫐎': 1,
    '𫐏': 1,
    '𫐐': 1,
    '𫐑': 1,
    '𫐒': 1,
    '𫐓': 1,
    '𫐔': 1,
    '𫐕': 1,
    '𫐖': 1,
    '𫐗': 1,
    '𫐘': 1,
    '𫐙': 1,
    '𫐷': 1,
    '𫑘': 1,
    '𫑡': 1,
    '𫑷': 1,
    '𫒊': 2,
    '𫒋': 2,
    '𫒞': 2,
    '𫒟': 2,
    '𫒡': 2,
    '𫒢': 2,
    '𫒷': 2,
    '𫓔': 2,
    '𫓥': 1,
    '𫓦': 1,
    '𫓧': 1,
    '𫓨': 1,
    '𫓩': 1,
    '𫓪': 1,
    '𫓫': 1,
    '𫓬': 1,
    '𫓭': 1,
    '𫓮': 1,
    '𫓯': 1,
    '𫓰': 1,
    '𫓱': 1,
    '𫓲': 1,
    '𫓳': 1,
    '𫓴': 1,
    '𫓵': 1,
    '𫓶': 1,
    '𫓷': 1,
    '𫓸': 1,
    '𫓹': 1,
    '𫓺': 1,
    '𫓻': 1,
    '𫓼': 1,
    '𫓽': 1,
    '𫓾': 1,
    '𫓿': 1,
    '𫔀': 1,
    '𫔁': 1,
    '𫔂': 1,
    '𫔃': 1,
    '𫔄': 1,
    '𫔅': 1,
    '𫔆': 1,
    '𫔇': 1,
    '𫔈': 1,
    '𫔉': 1,
    '𫔊': 1,
    '𫔋': 1,
    '𫔌': 1,
    '𫔍': 1,
    '𫔎': 1,
    '𫔏': 1,
    '𫔐': 1,
    '𫔑': 1,
    '𫔒': 1,
    '𫔓': 1,
    '𫔔': 1,
    '𫔕': 1,
    '𫔖': 1,
    '𫔘': 2,
    '𫔡': 2,
    '𫔭': 1,
    '𫔯': 1,
    '𫔰': 1,
    '𫔱': 1,
    '𫔲': 1,
    '𫔴': 1,
    '𫔵': 1,
    '𫔶': 1,
    '𫔽': 1,
    '𫕚': 1,
    '𫕥': 1,
    '𫕨': 1,
    '𫖃': 1,
    '𫖅': 1,
    '𫖇': 1,
    '𫖑': 1,
    '𫖒': 1,
    '𫖓': 1,
    '𫖔': 1,
    '𫖕': 1,
    '𫖖': 1,
    '𫖞': 2,
    '𫖪': 1,
    '𫖫': 1,
    '𫖬': 1,
    '𫖭': 1,
    '𫖮': 1,
    '𫖯': 1,
    '𫖰': 1,
    '𫖱': 1,
    '𫖲': 1,
    '𫖳': 1,
    '𫖴': 1,
    '𫖵': 1,
    '𫖶': 1,
    '𫖷': 1,
    '𫖸': 1,
    '𫖹': 1,
    '𫖺': 1,
    '𫗇': 1,
    '𫗈': 1,
    '𫗉': 1,
    '𫗊': 1,
    '𫗋': 1,
    '𫗑': 2,
    '𫗕': 2,
    '𫗚': 1,
    '𫗞': 1,
    '𫗟': 1,
    '𫗠': 1,
    '𫗡': 1,
    '𫗢': 1,
    '𫗣': 1,
    '𫗤': 1,
    '𫗥': 1,
    '𫗦': 1,
    '𫗧': 1,
    '𫗨': 1,
    '𫗩': 1,
    '𫗪': 1,
    '𫗫': 1,
    '𫗬': 1,
    '𫗭': 1,
    '𫗮': 1,
    '𫗯': 1,
    '𫗰': 1,
    '𫗱': 1,
    '𫗲': 1,
    '𫗳': 1,
    '𫗴': 1,
    '𫗵': 1,
    '𫗻': 2,
    '𫘋': 2,
    '𫘛': 1,
    '𫘜': 1,
    '𫘝': 1,
    '𫘞': 1,
    '𫘟': 1,
    '𫘠': 1,
    '𫘡': 1,
    '𫘣': 1,
    '𫘤': 1,
    '𫘥': 1,
    '𫘦': 1,
    '𫘧': 1,
    '𫘨': 1,
    '𫘩': 1,
    '𫘪': 1,
    '𫘫': 1,
    '𫘬': 1,
    '𫘭': 1,
    '𫘮': 1,
    '𫘯': 1,
    '𫘰': 1,
    '𫘱': 1,
    '𫘽': 1,
    '𫙂': 1,
    '𫚈': 1,
    '𫚉': 1,
    '𫚊': 1,
    '𫚋': 1,
    '𫚌': 1,
    '𫚍': 1,
    '𫚎': 1,
    '𫚏': 1,
    '𫚐': 1,
    '𫚑': 1,
    '𫚒': 1,
    '𫚓': 1,
    '𫚔': 1,
    '𫚕': 1,
    '𫚖': 1,
    '𫚗': 1,
    '𫚘': 1,
    '𫚙': 1,
    '𫚚': 1,
    '𫚛': 1,
    '𫚜': 1,
    '𫚝': 1,
    '𫚞': 1,
    '𫚟': 1,
    '𫚠': 1,
    '𫚡': 1,
    '𫚢': 1,
    '𫚣': 1,
    '𫚤': 1,
    '𫚥': 1,
    '𫚦': 1,
    '𫚧': 1,
    '𫚨': 1,
    '𫚩': 1,
    '𫚪': 1,
    '𫚫': 1,
    '𫚬': 1,
    '𫚭': 1,
    '𫛚': 1,
    '𫛛': 1,
    '𫛜': 1,
    '𫛝': 1,
    '𫛞': 1,
    '𫛟': 1,
    '𫛠': 1,
    '𫛡': 1,
    '𫛢': 1,
    '𫛣': 1,
    '𫛤': 1,
    '𫛥': 1,
    '𫛦': 1,
    '𫛧': 1,
    '𫛨': 1,
    '𫛩': 1,
    '𫛪': 1,
    '𫛫': 1,
    '𫛬': 1,
    '𫛭': 1,
    '𫛮': 1,
    '𫛯': 1,
    '𫛰': 1,
    '𫛱': 1,
    '𫛲': 1,
    '𫛳': 1,
    '𫛴': 1,
    '𫛵': 1,
    '𫛶': 1,
    '𫛷': 1,
    '𫛸': 1,
    '𫛹': 1,
    '𫛺': 1,
    '𫛻': 1,
    '𫛼': 1,
    '𫛽': 1,
    '𫛾': 1,
    '𫜀': 1,
    '𫜁': 1,
    '𫜂': 1,
    '𫜃': 1,
    '𫜄': 1,
    '𫜅': 1,
    '𫜊': 1,
    '𫜑': 1,
    '𫜒': 1,
    '𫜓': 1,
    '𫜔': 1,
    '𫜕': 1,
    '𫜙': 1,
    '𫜟': 1,
    '𫜦': 2,
    '𫜨': 1,
    '𫜩': 1,
    '𫜪': 1,
    '𫜫': 1,
    '𫜬': 1,
    '𫜭': 1,
    '𫜮': 1,
    '𫜯': 1,
    '𫜰': 1,
    '𫜲': 1,
    '𫜳': 1,
    '𫜷': 1,
    '𫝈': 1,
    '𫝋': 1,
    '𫝡': 1,
    '𫝦': 1,
    '𫝧': 1,
    '𫝨': 1,
    '𫝩': 1,
    '𫝪': 1,
    '𫝫': 1,
    '𫝬': 1,
    '𫝭': 1,
    '𫝮': 1,
    '𫝵': 1,
    '𫞅': 1,
    '𫞗': 1,
    '𫞚': 1,
    '𫞛': 1,
    '𫞝': 1,
    '𫞠': 1,
    '𫞡': 1,
    '𫞢': 1,
    '𫞣': 1,
    '𫞥': 1,
    '𫞦': 1,
    '𫞧': 1,
    '𫞨': 1,
    '𫞩': 1,
    '𫞷': 1,
    '𫟃': 1,
    '𫟄': 1,
    '𫟅': 1,
    '𫟆': 1,
    '𫟇': 1,
    '𫟑': 1,
    '𫟕': 1,
    '𫟞': 1,
    '𫟟': 1,
    '𫟠': 1,
    '𫟡': 1,
    '𫟢': 1,
    '𫟤': 1,
    '𫟥': 1,
    '𫟦': 1,
    '𫟫': 1,
    '𫟬': 1,
    '𫟲': 1,
    '𫟳': 1,
    '𫟴': 1,
    '𫟵': 1,
    '𫟶': 1,
    '𫟷': 1,
    '𫟸': 1,
    '𫟹': 1,
    '𫟺': 1,
    '𫟻': 1,
    '𫟼': 1,
    '𫟽': 1,
    '𫟾': 1,
    '𫟿': 1,
    '𫠀': 1,
    '𫠁': 1,
    '𫠂': 1,
    '𫠅': 1,
    '𫠆': 1,
    '𫠇': 1,
    '𫠈': 1,
    '𫠊': 1,
    '𫠋': 1,
    '𫠌': 1,
    '𫠏': 1,
    '𫠐': 1,
    '𫠑': 1,
    '𫠒': 1,
    '𫠖': 1,
    '𫠜': 1,
    '𫡬': 1,
    '𫡶': 1,
    '𫢒': 1,
    '𫢔': 1,
    '𫢘': 1,
    '𫢙': 1,
    '𫢜': 1,
    '𫢟': 1,
    '𫢨': 1,
    '𫢪': 1,
    '𫢬': 1,
    '𫢭': 1,
    '𫢲': 1,
    '𫢸': 1,
    '𫢹': 1,
    '𫢺': 1,
    '𫣉': 1,
    '𫣊': 1,
    '𫣛': 1,
    '𫣫': 1,
    '𫣴': 2,
    '𫤸': 1,
    '𫤽': 1,
    '𫥍': 1,
    '𫥎': 1,
    '𫥔': 1,
    '𫥝': 2,
    '𫥳': 1,
    '𫥵': 1,
    '𫥺': 1,
    '𫥼': 1,
    '𫥽': 1,
    '𫦁': 1,
    '𫦅': 1,
    '𫦉': 1,
    '𫦋': 1,
    '𫦌': 1,
    '𫦔': 2,
    '𫦙': 2,
    '𫦩': 1,
    '𫦰': 1,
    '𫦳': 1,
    '𫦸': 2,
    '𫧃': 1,
    '𫧝': 2,
    '𫧮': 1,
    '𫧯': 1,
    '𫧷': 1,
    '𫧿': 1,
    '𫨆': 1,
    '𫨑': 2,
    '𫩕': 1,
    '𫩖': 1,
    '𫩚': 1,
    '𫩛': 1,
    '𫩤': 1,
    '𫩥': 1,
    '𫩩': 1,
    '𫩫': 1,
    '𫩯': 1,
    '𫩳': 1,
    '𫩸': 1,
    '𫩺': 1,
    '𫪀': 1,
    '𫪁': 1,
    '𫪂': 1,
    '𫪃': 1,
    '𫪄': 1,
    '𫪅': 1,
    '𫪑': 1,
    '𫪘': 1,
    '𫪚': 1,
    '𫪛': 2,
    '𫪧': 1,
    '𫪪': 1,
    '𫪺': 1,
    '𫪽': 1,
    '𫫇': 1,
    '𫫏': 1,
    '𫫦': 1,
    '𫫵': 1,
    '𫫾': 1,
    '𫬆': 2,
    '𫬐': 1,
    '𫬙': 1,
    '𫬟': 1,
    '𫬱': 2,
    '𫭞': 1,
    '𫭟': 1,
    '𫭢': 1,
    '𫭨': 1,
    '𫭪': 1,
    '𫭮': 1,
    '𫭯': 1,
    '𫭲': 1,
    '𫭼': 1,
    '𫮃': 1,
    '𫮅': 1,
    '𫮜': 1,
    '𫯒': 1,
    '𫯓': 2,
    '𫯥': 1,
    '𫯶': 1,
    '𫰂': 1,
    '𫰍': 1,
    '𫰛': 1,
    '𫰠': 1,
    '𫰡': 1,
    '𫰢': 1,
    '𫰣': 1,
    '𫰨': 1,
    '𫰰': 1,
    '𫰹': 1,
    '𫱕': 1,
    '𫱿': 1,
    '𫲉': 2,
    '𫲗': 1,
    '𫲴': 2,
    '𫲸': 1,
    '𫳃': 1,
    '𫴼': 1,
    '𫵵': 1,
    '𫵶': 1,
    '𫵷': 1,
    '𫵸': 1,
    '𫵹': 1,
    '𫶄': 1,
    '𫶅': 1,
    '𫶇': 1,
    '𫶊': 1,
    '𫶕': 1,
    '𫶦': 2,
    '𫶲': 1,
    '𫷅': 1,
    '𫷈': 1,
    '𫷉': 1,
    '𫷌': 1,
    '𫷘': 1,
    '𫷬': 1,
    '𫷮': 1,
    '𫷷': 1,
    '𫷹': 1,
    '𫷾': 1,
    '𫸩': 1,
    '𫹮': 1,
    '𫹴': 1,
    '𫹷': 1,
    '𫹼': 1,
    '𫹽': 1,
    '𫺁': 1,
    '𫺂': 1,
    '𫺆': 1,
    '𫺊': 1,
    '𫺌': 1,
    '𫺒': 1,
    '𫺓': 1,
    '𫺘': 1,
    '𫺤': 2,
    '𫺪': 1,
    '𫺫': 1,
    '𫺷': 1,
    '𫺹': 1,
    '𫻁': 1,
    '𫻇': 1,
    '𫻑': 2,
    '𫼗': 1,
    '𫼝': 1,
    '𫼣': 1,
    '𫼤': 1,
    '𫼥': 1,
    '𫼧': 1,
    '𫼫': 1,
    '𫼮': 1,
    '𫼱': 1,
    '𫼲': 1,
    '𫼵': 1,
    '𫼶': 1,
    '𫼽': 1,
    '𫼾': 1,
    '𫽀': 1,
    '𫽁': 1,
    '𫽇': 1,
    '𫽊': 1,
    '𫽋': 1,
    '𫽐': 1,
    '𫽔': 1,
    '𫽙': 1,
    '𫽢': 1,
    '𫽣': 1,
    '𫽥': 1,
    '𫽧': 1,
    '𫽫': 1,
    '𫽮': 1,
    '𫽲': 1,
    '𫽳': 1,
    '𫾁': 1,
    '𫾃': 1,
    '𫾉': 1,
    '𫾏': 1,
    '𫾡': 2,
    '𫾲': 1,
    '𫾳': 1,
    '𫿂': 1,
    '𫿗': 1,
    '𬀥': 1,
    '𬀩': 1,
    '𬀪': 1,
    '𬀮': 1,
    '𬀱': 1,
    '𬁑': 1,
    '𬁘': 1,
    '𬁳': 1,
    '𬁵': 1,
    '𬁸': 1,
    '𬁺': 1,
    '𬁽': 1,
    '𬂀': 1,
    '𬂂': 1,
    '𬂅': 1,
    '𬂉': 1,
    '𬂠': 1,
    '𬂩': 1,
    '𬂮': 1,
    '𬂰': 1,
    '𬂱': 1,
    '𬂻': 1,
    '𬃀': 1,
    '𬃊': 1,
    '𬃏': 1,
    '𬃘': 1,
    '𬃛': 1,
    '𬃦': 1,
    '𬃫': 1,
    '𬃮': 1,
    '𬃲': 1,
    '𬃳': 1,
    '𬄝': 2,
    '𬄞': 1,
    '𬄩': 1,
    '𬄬': 1,
    '𬅁': 2,
    '𬅢': 1,
    '𬅥': 1,
    '𬅫': 1,
    '𬆂': 1,
    '𬆉': 2,
    '𬆙': 1,
    '𬆦': 1,
    '𬆮': 1,
    '𬆾': 1,
    '𬇃': 1,
    '𬇄': 1,
    '𬇇': 1,
    '𬇕': 1,
    '𬇘': 1,
    '𬇙': 1,
    '𬇬': 1,
    '𬇰': 1,
    '𬇹': 1,
    '𬇼': 1,
    '𬈁': 1,
    '𬈏': 1,
    '𬈕': 1,
    '𬈜': 1,
    '𬈧': 1,
    '𬈱': 1,
    '𬈾': 1,
    '𬉂': 1,
    '𬉇': 1,
    '𬉋': 1,
    '𬉠': 1,
    '𬉤': 2,
    '𬉧': 2,
    '𬉼': 1,
    '𬊂': 1,
    '𬊈': 1,
    '𬊉': 1,
    '𬊍': 1,
    '𬊎': 1,
    '𬊖': 1,
    '𬊗': 1,
    '𬊜': 1,
    '𬊤': 1,
    '𬊦': 1,
    '𬊵': 1,
    '𬊶': 1,
    '𬊺': 1,
    '𬊾': 1,
    '𬊿': 2,
    '𬋃': 1,
    '𬋍': 1,
    '𬌝': 1,
    '𬌠': 1,
    '𬌦': 2,
    '𬌮': 1,
    '𬌴': 1,
    '𬌵': 1,
    '𬌷': 1,
    '𬍁': 2,
    '𬍙': 1,
    '𬍛': 1,
    '𬍡': 1,
    '𬍤': 1,
    '𬎆': 1,
    '𬎑': 1,
    '𬎟': 2,
    '𬎧': 1,
    '𬎬': 1,
    '𬏜': 1,
    '𬏟': 1,
    '𬏤': 1,
    '𬏦': 1,
    '𬏫': 1,
    '𬏮': 1,
    '𬏲': 2,
    '𬏷': 1,
    '𬐠': 1,
    '𬑆': 1,
    '𬑇': 1,
    '𬑍': 1,
    '𬑏': 1,
    '𬑒': 1,
    '𬑓': 1,
    '𬑕': 1,
    '𬑗': 1,
    '𬑙': 1,
    '𬑡': 2,
    '𬑧': 1,
    '𬒄': 1,
    '𬒆': 1,
    '𬒇': 1,
    '𬒈': 1,
    '𬒊': 1,
    '𬒍': 1,
    '𬒎': 1,
    '𬒒': 2,
    '𬒓': 1,
    '𬒕': 1,
    '𬒗': 1,
    '𬓠': 1,
    '𬓡': 2,
    '𬓫': 1,
    '𬓱': 1,
    '𬓸': 1,
    '𬓼': 1,
    '𬔯': 1,
    '𬔹': 1,
    '𬕂': 1,
    '𬕄': 1,
    '𬕊': 1,
    '𬕛': 1,
    '𬕜': 2,
    '𬕦': 1,
    '𬕬': 1,
    '𬖃': 1,
    '𬖑': 1,
    '𬖖': 1,
    '𬖘': 1,
    '𬖞': 1,
    '𬖟': 1,
    '𬖠': 1,
    '𬖮': 1,
    '𬖺': 1,
    '𬗈': 2,
    '𬗏': 2,
    '𬗺': 2,
    '𬘓': 1,
    '𬘔': 1,
    '𬘕': 1,
    '𬘖': 1,
    '𬘗': 1,
    '𬘘': 1,
    '𬘙': 1,
    '𬘚': 1,
    '𬘛': 1,
    '𬘜': 1,
    '𬘝': 1,
    '𬘞': 1,
    '𬘟': 1,
    '𬘠': 1,
    '𬘡': 1,
    '𬘢': 1,
    '𬘣': 1,
    '𬘤': 1,
    '𬘥': 1,
    '𬘦': 1,
    '𬘧': 1,
    '𬘨': 1,
    '𬘩': 1,
    '𬘪': 1,
    '𬘫': 1,
    '𬘬': 1,
    '𬘭': 1,
    '𬘮': 1,
    '𬘯': 1,
    '𬘰': 1,
    '𬘱': 1,
    '𬘲': 1,
    '𬘳': 1,
    '𬘴': 1,
    '𬘵': 1,
    '𬘶': 1,
    '𬘷': 1,
    '𬘸': 1,
    '𬘹': 1,
    '𬘺': 1,
    '𬘻': 1,
    '𬘼': 1,
    '𬘽': 1,
    '𬘾': 1,
    '𬘿': 1,
    '𬙀': 1,
    '𬙁': 1,
    '𬙂': 1,
    '𬙃': 1,
    '𬙄': 1,
    '𬙅': 1,
    '𬙆': 1,
    '𬙇': 1,
    '𬙈': 1,
    '𬙉': 1,
    '𬙊': 1,
    '𬙋': 1,
    '𬙎': 1,
    '𬙏': 1,
    '𬙔': 2,
    '𬙝': 1,
    '𬙪': 1,
    '𬙫': 1,
    '𬙭': 1,
    '𬚄': 1,
    '𬛕': 2,
    '𬛹': 1,
    '𬛼': 1,
    '𬜔': 1,
    '𬜥': 1,
    '𬜧': 1,
    '𬜨': 1,
    '𬜬': 1,
    '𬜯': 1,
    '𬜸': 1,
    '𬜺': 1,
    '𬜾': 1,
    '𬜿': 1,
    '𬝁': 1,
    '𬝃': 1,
    '𬝊': 1,
    '𬝋': 1,
    '𬝖': 1,
    '𬝠': 1,
    '𬝯': 1,
    '𬝴': 1,
    '𬞋': 1,
    '𬞕': 1,
    '𬞘': 1,
    '𬞟': 1,
    '𬞣': 1,
    '𬞫': 1,
    '𬞼': 2,
    '𬟁': 1,
    '𬟪': 1,
    '𬟺': 1,
    '𬟽': 1,
    '𬠃': 1,
    '𬠅': 1,
    '𬠈': 1,
    '𬠐': 2,
    '𬠠': 1,
    '𬠱': 1,
    '𬠷': 1,
    '𬡇': 1,
    '𬡍': 1,
    '𬡎': 1,
    '𬡒': 1,
    '𬡓': 1,
    '𬡔': 1,
    '𬡕': 1,
    '𬡠': 1,
    '𬡦': 1,
    '𬡱': 1,
    '𬡷': 1,
    '𬡻': 1,
    '𬢇': 1,
    '𬢈': 1,
    '𬢉': 1,
    '𬢊': 1,
    '𬢋': 1,
    '𬢌': 1,
    '𬢍': 1,
    '𬢎': 1,
    '𬢏': 1,
    '𬢐': 1,
    '𬢑': 1,
    '𬢒': 1,
    '𬢓': 1,
    '𬢔': 1,
    '𬢕': 1,
    '𬢪': 1,
    '𬢯': 1,
    '𬢳': 1,
    '𬣀': 1,
    '𬣍': 2,
    '𬣘': 2,
    '𬣙': 1,
    '𬣚': 1,
    '𬣛': 1,
    '𬣜': 1,
    '𬣝': 1,
    '𬣞': 1,
    '𬣟': 1,
    '𬣠': 1,
    '𬣡': 1,
    '𬣢': 1,
    '𬣣': 1,
    '𬣤': 1,
    '𬣥': 1,
    '𬣦': 1,
    '𬣧': 1,
    '𬣨': 1,
    '𬣩': 1,
    '𬣪': 1,
    '𬣫': 1,
    '𬣬': 1,
    '𬣭': 1,
    '𬣮': 1,
    '𬣯': 1,
    '𬣰': 1,
    '𬣱': 1,
    '𬣲': 1,
    '𬣳': 1,
    '𬣴': 1,
    '𬣵': 1,
    '𬣶': 1,
    '𬣷': 1,
    '𬣸': 1,
    '𬣹': 1,
    '𬣺': 1,
    '𬣻': 1,
    '𬣼': 1,
    '𬣽': 1,
    '𬣾': 1,
    '𬣿': 1,
    '𬤀': 1,
    '𬤁': 1,
    '𬤂': 1,
    '𬤃': 1,
    '𬤄': 1,
    '𬤅': 1,
    '𬤆': 1,
    '𬤇': 1,
    '𬤈': 1,
    '𬤉': 1,
    '𬤊': 1,
    '𬤋': 1,
    '𬤌': 1,
    '𬤍': 1,
    '𬤎': 1,
    '𬤏': 1,
    '𬤐': 1,
    '𬤑': 1,
    '𬤒': 1,
    '𬤓': 1,
    '𬤔': 1,
    '𬤕': 1,
    '𬤖': 1,
    '𬤗': 1,
    '𬤘': 1,
    '𬤙': 1,
    '𬤚': 1,
    '𬤛': 1,
    '𬤜': 1,
    '𬤝': 1,
    '𬤞': 1,
    '𬤟': 1,
    '𬤠': 1,
    '𬤡': 1,
    '𬤢': 1,
    '𬤣': 1,
    '𬤤': 1,
    '𬤥': 1,
    '𬤦': 1,
    '𬤧': 1,
    '𬤨': 1,
    '𬤩': 1,
    '𬤪': 1,
    '𬤫': 1,
    '𬤬': 1,
    '𬤭': 1,
    '𬤮': 1,
    '𬤯': 1,
    '𬤰': 1,
    '𬤱': 1,
    '𬤷': 1,
    '𬥄': 1,
    '𬥈': 1,
    '𬥲': 2,
    '𬥳': 1,
    '𬥴': 1,
    '𬥵': 1,
    '𬥶': 1,
    '𬥷': 1,
    '𬥸': 1,
    '𬥹': 1,
    '𬥺': 1,
    '𬥻': 1,
    '𬥼': 1,
    '𬥽': 1,
    '𬥾': 1,
    '𬥿': 1,
    '𬦀': 1,
    '𬦅': 1,
    '𬦆': 1,
    '𬦣': 1,
    '𬦥': 1,
    '𬦧': 1,
    '𬦩': 1,
    '𬦫': 1,
    '𬦯': 1,
    '𬦴': 1,
    '𬦵': 1,
    '𬦹': 1,
    '𬦻': 1,
    '𬦾': 1,
    '𬧀': 1,
    '𬧃': 1,
    '𬧑': 1,
    '𬧔': 1,
    '𬧙': 2,
    '𬧚': 1,
    '𬧛': 1,
    '𬧢': 1,
    '𬧤': 1,
    '𬧩': 1,
    '𬨁': 1,
    '𬨂': 1,
    '𬨃': 1,
    '𬨄': 1,
    '𬨅': 1,
    '𬨆': 1,
    '𬨇': 1,
    '𬨈': 1,
    '𬨉': 1,
    '𬨋': 1,
    '𬨌': 1,
    '𬨍': 1,
    '𬨎': 1,
    '𬨏': 1,
    '𬨐': 1,
    '𬨑': 1,
    '𬨒': 1,
    '𬨓': 1,
    '𬨔': 1,
    '𬩎': 1,
    '𬩽': 1,
    '𬩾': 1,
    '𬪍': 1,
    '𬪧': 1,
    '𬪨': 1,
    '𬪩': 1,
    '𬪫': 1,
    '𬪯': 1,
    '𬪺': 1,
    '𬫉': 2,
    '𬫍': 2,
    '𬬇': 1,
    '𬬧': 1,
    '𬬨': 1,
    '𬬩': 1,
    '𬬪': 1,
    '𬬫': 1,
    '𬬬': 1,
    '𬬭': 1,
    '𬬮': 1,
    '𬬯': 1,
    '𬬰': 1,
    '𬬱': 1,
    '𬬲': 1,
    '𬬳': 1,
    '𬬴': 1,
    '𬬵': 1,
    '𬬶': 1,
    '𬬷': 1,
    '𬬸': 1,
    '𬬹': 1,
    '𬬺': 1,
    '𬬻': 1,
    '𬬼': 1,
    '𬬽': 1,
    '𬬾': 1,
    '𬬿': 1,
    '𬭀': 1,
    '𬭁': 1,
    '𬭂': 1,
    '𬭃': 1,
    '𬭅': 1,
    '𬭆': 1,
    '𬭇': 1,
    '𬭈': 1,
    '𬭉': 1,
    '𬭊': 1,
    '𬭋': 1,
    '𬭌': 1,
    '𬭍': 1,
    '𬭎': 1,
    '𬭏': 1,
    '𬭐': 1,
    '𬭑': 1,
    '𬭓': 1,
    '𬭔': 1,
    '𬭕': 1,
    '𬭖': 1,
    '𬭗': 1,
    '𬭘': 1,
    '𬭙': 1,
    '𬭚': 1,
    '𬭛': 1,
    '𬭜': 1,
    '𬭝': 1,
    '𬭞': 1,
    '𬭟': 1,
    '𬭠': 1,
    '𬭡': 1,
    '𬭢': 1,
    '𬭣': 1,
    '𬭤': 1,
    '𬭥': 1,
    '𬭦': 1,
    '𬭨': 1,
    '𬭩': 1,
    '𬭪': 1,
    '𬭫': 1,
    '𬭬': 1,
    '𬭭': 1,
    '𬭯': 1,
    '𬭰': 1,
    '𬭱': 1,
    '𬭲': 1,
    '𬭳': 1,
    '𬭴': 1,
    '𬭵': 1,
    '𬭶': 1,
    '𬭷': 1,
    '𬭸': 1,
    '𬭹': 1,
    '𬭺': 1,
    '𬭻': 1,
    '𬭼': 1,
    '𬭽': 1,
    '𬭾': 1,
    '𬭿': 1,
    '𬮀': 1,
    '𬮁': 1,
    '𬮂': 1,
    '𬮃': 1,
    '𬮄': 1,
    '𬮇': 2,
    '𬮍': 2,
    '𬮘': 1,
    '𬮙': 1,
    '𬮜': 1,
    '𬮝': 1,
    '𬮟': 1,
    '𬮠': 1,
    '𬮡': 1,
    '𬮢': 1,
    '𬮣': 1,
    '𬮤': 1,
    '𬮥': 1,
    '𬮧': 1,
    '𬮨': 1,
    '𬮩': 1,
    '𬮪': 1,
    '𬮬': 1,
    '𬮭': 1,
    '𬮮': 1,
    '𬮯': 1,
    '𬮰': 1,
    '𬮱': 1,
    '𬮲': 1,
    '𬮳': 1,
    '𬮴': 1,
    '𬮵': 1,
    '𬮸': 1,
    '𬮹': 1,
    '𬮺': 1,
    '𬮻': 1,
    '𬮿': 1,
    '𬯀': 1,
    '𬯅': 1,
    '𬯊': 1,
    '𬯎': 1,
    '𬯘': 2,
    '𬰡': 1,
    '𬰣': 1,
    '𬰤': 1,
    '𬰥': 1,
    '𬰱': 1,
    '𬰲': 1,
    '𬰳': 1,
    '𬰴': 1,
    '𬰵': 1,
    '𬰶': 1,
    '𬰷': 1,
    '𬰸': 1,
    '𬰺': 1,
    '𬱂': 2,
    '𬱈': 2,
    '𬱓': 1,
    '𬱔': 1,
    '𬱕': 1,
    '𬱖': 1,
    '𬱗': 1,
    '𬱘': 1,
    '𬱙': 1,
    '𬱚': 1,
    '𬱛': 1,
    '𬱜': 1,
    '𬱝': 1,
    '𬱞': 1,
    '𬱟': 1,
    '𬱠': 1,
    '𬱡': 1,
    '𬱢': 1,
    '𬱣': 1,
    '𬱤': 1,
    '𬱥': 1,
    '𬱦': 1,
    '𬱧': 1,
    '𬱨': 1,
    '𬱩': 1,
    '𬱪': 1,
    '𬱫': 1,
    '𬱬': 1,
    '𬱭': 1,
    '𬱮': 1,
    '𬱯': 1,
    '𬱰': 1,
    '𬱱': 1,
    '𬱲': 1,
    '𬱳': 1,
    '𬱵': 1,
    '𬱷': 1,
    '𬱸': 1,
    '𬱺': 1,
    '𬱼': 1,
    '𬱽': 1,
    '𬱾': 1,
    '𬱿': 1,
    '𬲀': 1,
    '𬲅': 1,
    '𬲆': 1,
    '𬲕': 1,
    '𬲚': 2,
    '𬲛': 2,
    '𬲥': 1,
    '𬲦': 1,
    '𬲧': 1,
    '𬲨': 1,
    '𬲩': 1,
    '𬲪': 1,
    '𬲫': 1,
    '𬲬': 1,
    '𬲭': 1,
    '𬲮': 1,
    '𬲯': 1,
    '𬲰': 1,
    '𬲱': 1,
    '𬲲': 1,
    '𬲳': 1,
    '𬲴': 1,
    '𬲵': 1,
    '𬲶': 1,
    '𬲷': 1,
    '𬲸': 1,
    '𬲹': 1,
    '𬲺': 1,
    '𬲻': 1,
    '𬲼': 1,
    '𬲽': 1,
    '𬲾': 1,
    '𬲿': 1,
    '𬳀': 1,
    '𬳁': 1,
    '𬳂': 1,
    '𬳃': 1,
    '𬳄': 1,
    '𬳅': 1,
    '𬳆': 1,
    '𬳇': 1,
    '𬳈': 1,
    '𬳉': 1,
    '𬳊': 1,
    '𬳋': 1,
    '𬳌': 1,
    '𬳍': 1,
    '𬳎': 1,
    '𬳐': 1,
    '𬳑': 1,
    '𬳒': 1,
    '𬳓': 1,
    '𬳔': 1,
    '𬳙': 1,
    '𬳟': 1,
    '𬳳': 1,
    '𬳴': 1,
    '𬳵': 1,
    '𬳶': 1,
    '𬳷': 1,
    '𬳸': 1,
    '𬳹': 1,
    '𬳺': 1,
    '𬳻': 1,
    '𬳼': 1,
    '𬳽': 1,
    '𬳾': 1,
    '𬳿': 1,
    '𬴀': 1,
    '𬴁': 1,
    '𬴂': 1,
    '𬴃': 1,
    '𬴄': 1,
    '𬴅': 1,
    '𬴆': 1,
    '𬴇': 1,
    '𬴈': 1,
    '𬴉': 1,
    '𬴊': 1,
    '𬴋': 1,
    '𬴌': 1,
    '𬴍': 1,
    '𬴎': 1,
    '𬴏': 1,
    '𬴐': 1,
    '𬴨': 1,
    '𬴩': 1,
    '𬵂': 2,
    '𬵃': 2,
    '𬵨': 2,
    '𬵮': 2,
    '𬶀': 1,
    '𬶁': 1,
    '𬶂': 1,
    '𬶃': 1,
    '𬶄': 1,
    '𬶅': 1,
    '𬶆': 1,
    '𬶇': 1,
    '𬶈': 1,
    '𬶉': 1,
    '𬶊': 1,
    '𬶋': 1,
    '𬶌': 1,
    '𬶍': 1,
    '𬶎': 1,
    '𬶏': 1,
    '𬶐': 1,
    '𬶑': 1,
    '𬶒': 1,
    '𬶓': 1,
    '𬶔': 1,
    '𬶕': 1,
    '𬶖': 1,
    '𬶗': 1,
    '𬶙': 1,
    '𬶚': 1,
    '𬶛': 1,
    '𬶜': 1,
    '𬶝': 1,
    '𬶞': 1,
    '𬶟': 1,
    '𬶠': 1,
    '𬶡': 1,
    '𬶢': 1,
    '𬶣': 1,
    '𬶤': 1,
    '𬶥': 1,
    '𬶦': 1,
    '𬶧': 1,
    '𬶨': 1,
    '𬶩': 1,
    '𬶪': 1,
    '𬶫': 1,
    '𬶬': 1,
    '𬶭': 1,
    '𬶮': 1,
    '𬶯': 1,
    '𬶰': 1,
    '𬶱': 1,
    '𬶲': 1,
    '𬶳': 1,
    '𬶴': 1,
    '𬶵': 1,
    '𬶶': 1,
    '𬶷': 1,
    '𬶸': 1,
    '𬶹': 1,
    '𬶺': 1,
    '𬶻': 1,
    '𬶼': 2,
    '𬷈': 2,
    '𬷕': 1,
    '𬷻': 1,
    '𬷼': 1,
    '𬷽': 1,
    '𬷾': 1,
    '𬷿': 1,
    '𬸀': 1,
    '𬸁': 1,
    '𬸂': 1,
    '𬸃': 1,
    '𬸄': 1,
    '𬸅': 1,
    '𬸆': 1,
    '𬸈': 1,
    '𬸉': 1,
    '𬸊': 1,
    '𬸋': 1,
    '𬸌': 1,
    '𬸍': 1,
    '𬸎': 1,
    '𬸏': 1,
    '𬸐': 1,
    '𬸑': 1,
    '𬸒': 1,
    '𬸓': 1,
    '𬸔': 1,
    '𬸕': 1,
    '𬸖': 1,
    '𬸗': 1,
    '𬸘': 1,
    '𬸙': 1,
    '𬸚': 1,
    '𬸛': 1,
    '𬸜': 1,
    '𬸝': 1,
    '𬸞': 1,
    '𬸟': 1,
    '𬸠': 1,
    '𬸡': 1,
    '𬸢': 1,
    '𬸣': 1,
    '𬸤': 1,
    '𬸥': 1,
    '𬸦': 1,
    '𬸧': 1,
    '𬸨': 1,
    '𬸩': 1,
    '𬸪': 1,
    '𬸫': 1,
    '𬸬': 1,
    '𬸭': 1,
    '𬸮': 1,
    '𬸯': 1,
    '𬸰': 1,
    '𬸱': 1,
    '𬸵': 1,
    '𬸶': 1,
    '𬸷': 1,
    '𬸸': 1,
    '𬸹': 1,
    '𬸾': 1,
    '𬹂': 2,
    '𬹅': 1,
    '𬹆': 1,
    '𬹇': 1,
    '𬹈': 1,
    '𬹉': 1,
    '𬹊': 1,
    '𬹋': 1,
    '𬹌': 1,
    '𬹍': 1,
    '𬹎': 1,
    '𬹕': 1,
    '𬹖': 1,
    '𬹗': 1,
    '𬹘': 1,
    '𬹣': 1,
    '𬹤': 1,
    '𬹭': 1,
    '𬹺': 1,
    '𬹻': 1,
    '𬹼': 1,
    '𬹽': 1,
    '𬹾': 1,
    '𬹿': 1,
    '𬺀': 1,
    '𬺁': 1,
    '𬺂': 1,
    '𬺃': 1,
    '𬺄': 1,
    '𬺅': 1,
    '𬺆': 1,
    '𬺇': 1,
    '𬺈': 1,
    '𬺉': 1,
    '𬺊': 1,
    '𬺋': 1,
    '𬺌': 1,
    '𬺍': 1,
    '𬺎': 1,
    '𬺏': 1,
    '𬺐': 1,
    '𬺑': 1,
    '𬺒': 1,
    '𬺓': 1,
    '𬺔': 1,
    '𬺕': 1,
    '𬺖': 1,
    '𬺛': 1,
    '𬺜': 1,
    '𬺝': 1,
    '𬺟': 1,
    '𬻮': 1,
    '𬾖': 1,
    '𬾣': 1,
    '𭂖': 2,
    '𭄛': 1,
    '𭇀': 1,
    '𭇉': 1,
    '𭇙': 1,
    '𭇜': 1,
    '𭇡': 1,
    '𭇯': 1,
    '𭇴': 1,
    '𭈈': 1,
    '𭈉': 1,
    '𭈜': 1,
    '𭈟': 1,
    '𭈮': 1,
    '𭉗': 1,
    '𭉨': 1,
    '𭉼': 1,
    '𭉾': 2,
    '𭊸': 1,
    '𭎂': 1,
    '𭎜': 1,
    '𭏦': 1,
    '𭏸': 1,
    '𭑙': 2,
    '𭑸': 1,
    '𭑹': 1,
    '𭓀': 1,
    '𭕆': 1,
    '𭗡': 2,
    '𭘓': 1,
    '𭘚': 1,
    '𭚦': 1,
    '𭜼': 2,
    '𭝋': 1,
    '𭝫': 1,
    '𭞄': 1,
    '𭠙': 1,
    '𭠽': 1,
    '𭡆': 1,
    '𭡜': 1,
    '𭡵': 1,
    '𭢋': 1,
    '𭢒': 2,
    '𭢕': 1,
    '𭢝': 1,
    '𭣇': 1,
    '𭣧': 1,
    '𭤎': 1,
    '𭤰': 1,
    '𭥓': 1,
    '𭧋': 1,
    '𭧒': 2,
    '𭧖': 2,
    '𭨡': 2,
    '𭩚': 1,
    '𭩛': 1,
    '𭩰': 1,
    '𭪆': 1,
    '𭫀': 1,
    '𭫙': 1,
    '𭫝': 1,
    '𭭈': 1,
    '𭰎': 1,
    '𭰒': 1,
    '𭰗': 1,
    '𭰥': 1,
    '𭱀': 1,
    '𭱊': 1,
    '𭱘': 2,
    '𭲫': 1,
    '𭴊': 1,
    '𭴳': 1,
    '𭶙': 2,
    '𭹜': 1,
    '𭹰': 2,
    '𭻍': 1,
    '𭻔': 1,
    '𮀡': 1,
    '𮀤': 1,
    '𮀪': 1,
    '𮀲': 1,
    '𮅎': 1,
    '𮆏': 1,
    '𮇔': 1,
    '𮇤': 1,
    '𮉠': 1,
    '𮉡': 1,
    '𮉢': 1,
    '𮉣': 1,
    '𮉤': 1,
    '𮉥': 1,
    '𮉧': 1,
    '𮉨': 1,
    '𮉩': 1,
    '𮉪': 1,
    '𮉫': 1,
    '𮉬': 1,
    '𮉭': 1,
    '𮉮': 1,
    '𮉯': 1,
    '𮌌': 1,
    '𮎍': 1,
    '𮏀': 1,
    '𮏺': 1,
    '𮐚': 1,
    '𮐨': 1,
    '𮔂': 1,
    '𮔅': 1,
    '𮔊': 1,
    '𮖁': 1,
    '𮖃': 1,
    '𮖱': 1,
    '𮙊': 1,
    '𮙋': 1,
    '𮛗': 1,
    '𮜗': 2,
    '𮜶': 1,
    '𮝴': 1,
    '𮝵': 1,
    '𮝷': 1,
    '𮝸': 1,
    '𮝹': 1,
    '𮝺': 1,
    '𮟽': 2,
    '𮠞': 1,
    '𮠳': 1,
    '𮡈': 2,
    '𮢅': 2,
    '𮢆': 2,
    '𮣲': 1,
    '𮣳': 1,
    '𮣴': 1,
    '𮣵': 1,
    '𮣶': 1,
    '𮤏': 2,
    '𮤒': 2,
    '𮤫': 1,
    '𮤬': 1,
    '𮤭': 1,
    '𮤮': 1,
    '𮤯': 1,
    '𮤲': 1,
    '𮤳': 1,
    '𮤶': 1,
    '𮤷': 1,
    '𮤸': 1,
    '𮦅': 1,
    '𮦗': 2,
    '𮦚': 1,
    '𮧴': 1,
    '𮧵': 1,
    '𮨭': 2,
    '𮨴': 1,
    '𮨵': 1,
    '𮨻': 2,
    '𮩛': 1,
    '𮩜': 1,
    '𮩝': 1,
    '𮩞': 1,
    '𮪡': 1,
    '𮪢': 1,
    '𮪣': 1,
    '𮪤': 1,
    '𮪥': 1,
    '𮫂': 1,
    '𮬛': 1,
    '𮬜': 1,
    '𮬝': 1,
    '𮬞': 1,
    '𮬟': 1,
    '𮬠': 1,
    '𮬡': 1,
    '𮬢': 1,
    '𮬣': 1,
    '𮬤': 1,
    '𮭡': 1,
    '𮭢': 1,
    '𮭤': 1,
    '𮭥': 1,
    '𮭦': 1,
    '𮭨': 1,
    '𮭪': 1,
    '𮭰': 1,
    '𮮅': 1,
    '𮮇': 1,
    '𮯙': 1,
    '𮯵': 1,
    '𮯸': 1,
    '𮯹': 1,
    '𮯻': 1,
    '𮰄': 1,
    '𮰉': 1,
    '𮰔': 1,
    '𮰠': 1,
    '𮰸': 1,
    '𮰻': 1,
    '𮰽': 1,
    '𮰾': 1,
    '𮰿': 1,
    '𮱁': 1,
    '𮱆': 1,
    '𮱇': 1,
    '𮱊': 1,
    '𮱐': 1,
    '𮱒': 1,
    '𮱔': 1,
    '𮱕': 1,
    '𮱚': 2,
    '𮱣': 2,
    '𮱦': 1,
    '𮱩': 1,
    '𮱯': 1,
    '𮱱': 2,
    '𮱵': 1,
    '𮲀': 1,
    '𮲁': 1,
    '𮲂': 1,
    '𮲃': 1,
    '𮲄': 1,
    '𮲅': 1,
    '𮲇': 1,
    '𮲏': 1,
    '𮲔': 1,
    '𮲚': 1,
    '𮲛': 1,
    '𮲟': 1,
    '𮲨': 1,
    '𮲮': 1,
    '𮲰': 1,
    '𮲲': 1,
    '𮲶': 1,
    '𮲸': 1,
    '𮲺': 1,
    '𮳃': 1,
    '𮳄': 1,
    '𮳅': 1,
    '𮳆': 1,
    '𮳈': 1,
    '𮳍': 1,
    '𮳎': 1,
    '𮳏': 1,
    '𮳖': 1,
    '𮳗': 1,
    '𮳠': 1,
    '𮳢': 1,
    '𮳧': 1,
    '𮳬': 1,
    '𮳯': 1,
    '𮳱': 1,
    '𮳴': 1,
    '𮳶': 1,
    '𮳸': 1,
    '𮳺': 1,
    '𮴂': 1,
    '𮴅': 1,
    '𮴆': 1,
    '𮴇': 1,
    '𮴊': 1,
    '𮴌': 1,
    '𮴏': 1,
    '𮴑': 1,
    '𮴒': 1,
    '𮴓': 1,
    '𮴔': 1,
    '𮴕': 1,
    '𮴗': 1,
    '𮴘': 1,
    '𮴚': 1,
    '𮴠': 1,
    '𮴥': 1,
    '𮴶': 1,
    '𮴿': 1,
    '𮵅': 1,
    '𮵆': 1,
    '𮵊': 1,
    '𮵙': 1,
    '𮵚': 1,
    '𮵠': 1,
    '𮵭': 1,
    '𮵮': 1,
    '𮵱': 1,
    '𮵿': 1,
    '𮶀': 1,
    '𮶁': 1,
    '𮶂': 1,
    '𮶅': 1,
    '𮶔': 1,
    '𮶝': 1,
    '𮶞': 1,
    '𮶩': 1,
    '𮶬': 1,
    '𮶳': 1,
    '𮶷': 1,
    '𮷁': 1,
    '𮷄': 1,
    '𮷅': 1,
    '𮷆': 1,
    '𮷇': 1,
    '𮷈': 1,
    '𮷉': 1,
    '𮷊': 1,
    '𮷖': 1,
    '𮷗': 1,
    '𮷙': 1,
    '𮷝': 1,
    '𮷥': 1,
    '𮷨': 1,
    '𮷵': 1,
    '𮷶': 1,
    '𮷷': 1,
    '𮷸': 1,
    '𮷹': 1,
    '𮷺': 1,
    '𮷻': 1,
    '𮷼': 1,
    '𮷽': 1,
    '𮷿': 1,
    '𮸂': 1,
    '𮸃': 1,
    '𮸄': 1,
    '𮸅': 1,
    '𮸆': 1,
    '𮸈': 1,
    '𮸉': 1,
    '𮸊': 1,
    '𮸋': 1,
    '𮸌': 1,
    '𮸏': 1,
    '𮸐': 1,
    '𮸑': 1,
    '𮸒': 1,
    '𮸔': 1,
    '𮸕': 1,
    '𮸘': 1,
    '𮸙': 1,
    '𮸚': 1,
    '𮸝': 1,
    '𮸞': 1,
    '𮸟': 1,
    '𮸠': 1,
    '𮸣': 1,
    '𮸥': 1,
    '𮸦': 1,
    '𮸧': 1,
    '𮸮': 1,
    '𮸶': 1,
    '𮸷': 1,
    '𮸻': 1,
    '𮸼': 1,
    '𮸽': 1,
    '𮸾': 2,
    '𮹀': 1,
    '𮹂': 1,
    '𮹄': 1,
    '𮹅': 1,
    '𮹉': 1,
    '𮹋': 1,
    '𮹌': 1,
    '𮹓': 1,
    '𮹕': 1,
    '𮹗': 1,
    '𮹙': 1,
    '𮹜': 1,
    '𮹝': 1,
    '𰀡': 1,
    '𰀢': 1,
    '𰁈': 1,
    '𰁜': 1,
    '𰁧': 1,
    '𰁸': 1,
    '𰁾': 1,
    '𰂁': 1,
    '𰂃': 1,
    '𰂋': 1,
    '𰂎': 1,
    '𰂏': 1,
    '𰂗': 1,
    '𰂜': 1,
    '𰂠': 2,
    '𰂦': 1,
    '𰂭': 1,
    '𰂴': 2,
    '𰂻': 1,
    '𰃆': 1,
    '𰃮': 1,
    '𰃳': 1,
    '𰃴': 2,
    '𰃶': 1,
    '𰃷': 1,
    '𰃻': 1,
    '𰃿': 1,
    '𰄁': 1,
    '𰄞': 1,
    '𰄭': 1,
    '𰅔': 1,
    '𰅥': 1,
    '𰅦': 1,
    '𰅻': 1,
    '𰆕': 1,
    '𰆙': 1,
    '𰆚': 1,
    '𰇀': 1,
    '𰇊': 1,
    '𰇎': 1,
    '𰇕': 1,
    '𰇖': 1,
    '𰇘': 1,
    '𰇠': 1,
    '𰇡': 1,
    '𰇣': 1,
    '𰇥': 1,
    '𰇲': 1,
    '𰇼': 1,
    '𰈆': 1,
    '𰈇': 1,
    '𰈊': 1,
    '𰈍': 1,
    '𰈓': 1,
    '𰈝': 2,
    '𰈮': 1,
    '𰈯': 1,
    '𰈶': 1,
    '𰉀': 2,
    '𰉁': 1,
    '𰉄': 1,
    '𰉘': 1,
    '𰉙': 1,
    '𰉚': 1,
    '𰉣': 1,
    '𰉥': 1,
    '𰉩': 1,
    '𰉪': 1,
    '𰉱': 1,
    '𰉽': 1,
    '𰊂': 1,
    '𰊅': 1,
    '𰊈': 1,
    '𰊑': 1,
    '𰊛': 1,
    '𰊟': 1,
    '𰊡': 1,
    '𰊢': 1,
    '𰋆': 2,
    '𰋖': 1,
    '𰋸': 1,
    '𰋹': 1,
    '𰋽': 1,
    '𰋾': 1,
    '𰌀': 1,
    '𰌂': 1,
    '𰌆': 1,
    '𰌇': 1,
    '𰌉': 1,
    '𰌙': 1,
    '𰌦': 1,
    '𰌷': 1,
    '𰎌': 1,
    '𰎎': 1,
    '𰎏': 1,
    '𰎐': 1,
    '𰎑': 1,
    '𰎔': 1,
    '𰎖': 1,
    '𰎛': 1,
    '𰎝': 1,
    '𰎞': 1,
    '𰎠': 1,
    '𰎢': 1,
    '𰎦': 1,
    '𰎫': 1,
    '𰎴': 1,
    '𰎷': 1,
    '𰎹': 1,
    '𰎼': 2,
    '𰏁': 1,
    '𰏓': 1,
    '𰏕': 1,
    '𰏜': 1,
    '𰏟': 1,
    '𰏲': 1,
    '𰏶': 1,
    '𰏼': 1,
    '𰏽': 1,
    '𰐚': 1,
    '𰐾': 1,
    '𰑁': 1,
    '𰑄': 1,
    '𰑅': 1,
    '𰑔': 1,
    '𰑕': 1,
    '𰑙': 1,
    '𰑟': 1,
    '𰑥': 1,
    '𰑧': 1,
    '𰑪': 1,
    '𰑫': 1,
    '𰑬': 1,
    '𰑵': 1,
    '𰑸': 1,
    '𰑿': 1,
    '𰒆': 1,
    '𰒒': 1,
    '𰒖': 1,
    '𰓄': 1,
    '𰓆': 1,
    '𰓔': 1,
    '𰓕': 1,
    '𰓗': 1,
    '𰓙': 1,
    '𰓜': 1,
    '𰓝': 1,
    '𰓟': 1,
    '𰓤': 1,
    '𰓧': 1,
    '𰓬': 1,
    '𰓱': 1,
    '𰓷': 1,
    '𰓻': 1,
    '𰓼': 1,
    '𰔇': 1,
    '𰔋': 1,
    '𰔠': 2,
    '𰔫': 2,
    '𰔲': 1,
    '𰔶': 1,
    '𰔺': 2,
    '𰕁': 1,
    '𰕅': 1,
    '𰕈': 1,
    '𰕐': 1,
    '𰕭': 1,
    '𰖈': 1,
    '𰖏': 1,
    '𰖚': 1,
    '𰖠': 1,
    '𰖩': 1,
    '𰖻': 2,
    '𰗅': 1,
    '𰗆': 1,
    '𰗓': 1,
    '𰗖': 1,
    '𰗘': 1,
    '𰗙': 1,
    '𰗚': 1,
    '𰗛': 1,
    '𰗜': 1,
    '𰗡': 1,
    '𰗢': 1,
    '𰗦': 1,
    '𰗨': 1,
    '𰗬': 1,
    '𰗵': 1,
    '𰗹': 1,
    '𰗺': 1,
    '𰘀': 1,
    '𰘅': 1,
    '𰘈': 1,
    '𰘓': 1,
    '𰘠': 1,
    '𰘣': 1,
    '𰘩': 1,
    '𰘯': 2,
    '𰘳': 1,
    '𰘶': 1,
    '𰘸': 1,
    '𰙋': 1,
    '𰙎': 1,
    '𰙑': 1,
    '𰙕': 1,
    '𰚂': 2,
    '𰚍': 1,
    '𰚔': 1,
    '𰚣': 2,
    '𰚦': 1,
    '𰚪': 1,
    '𰚬': 1,
    '𰚱': 1,
    '𰛉': 1,
    '𰛊': 1,
    '𰛏': 1,
    '𰛒': 1,
    '𰛛': 1,
    '𰛡': 1,
    '𰛣': 1,
    '𰛤': 1,
    '𰛥': 1,
    '𰛦': 1,
    '𰛨': 1,
    '𰛩': 1,
    '𰛪': 1,
    '𰛮': 1,
    '𰛱': 1,
    '𰛲': 1,
    '𰛵': 1,
    '𰛺': 1,
    '𰛻': 1,
    '𰛽': 1,
    '𰜐': 1,
    '𰜜': 1,
    '𰜝': 1,
    '𰜢': 1,
    '𰜨': 1,
    '𰜳': 1,
    '𰝅': 1,
    '𰝋': 1,
    '𰝍': 1,
    '𰝗': 1,
    '𰝜': 2,
    '𰝞': 1,
    '𰝟': 1,
    '𰝢': 2,
    '𰝤': 1,
    '𰝾': 1,
    '𰞇': 1,
    '𰞉': 1,
    '𰞍': 1,
    '𰞤': 1,
    '𰞲': 1,
    '𰞳': 1,
    '𰞷': 1,
    '𰞻': 1,
    '𰟄': 1,
    '𰟘': 1,
    '𰟫': 2,
    '𰠛': 1,
    '𰠫': 1,
    '𰠲': 1,
    '𰠴': 1,
    '𰠹': 1,
    '𰡄': 1,
    '𰡉': 1,
    '𰡊': 1,
    '𰡋': 1,
    '𰡎': 1,
    '𰡏': 1,
    '𰡐': 1,
    '𰡓': 2,
    '𰡔': 1,
    '𰡞': 1,
    '𰡢': 1,
    '𰡩': 1,
    '𰡰': 1,
    '𰡵': 1,
    '𰡻': 1,
    '𰡽': 1,
    '𰢄': 1,
    '𰢢': 1,
    '𰢤': 1,
    '𰢦': 1,
    '𰣢': 1,
    '𰣦': 1,
    '𰣩': 1,
    '𰣫': 1,
    '𰣬': 1,
    '𰣯': 1,
    '𰣶': 1,
    '𰣼': 1,
    '𰣽': 1,
    '𰤓': 1,
    '𰤕': 1,
    '𰤨': 1,
    '𰤫': 1,
    '𰤬': 1,
    '𰤽': 1,
    '𰥊': 1,
    '𰥒': 1,
    '𰥛': 1,
    '𰥞': 1,
    '𰥠': 1,
    '𰥢': 1,
    '𰥣': 1,
    '𰥨': 1,
    '𰥪': 1,
    '𰥭': 1,
    '𰥹': 1,
    '𰦔': 1,
    '𰦜': 1,
    '𰦦': 1,
    '𰦨': 1,
    '𰦭': 1,
    '𰦰': 1,
    '𰦴': 1,
    '𰦷': 1,
    '𰦾': 1,
    '𰦿': 1,
    '𰧃': 1,
    '𰧇': 1,
    '𰧈': 1,
    '𰧉': 1,
    '𰧎': 1,
    '𰧔': 1,
    '𰧘': 1,
    '𰧰': 1,
    '𰧻': 1,
    '𰧾': 1,
    '𰨖': 1,
    '𰨜': 1,
    '𰨦': 1,
    '𰨳': 1,
    '𰩅': 1,
    '𰩏': 1,
    '𰩓': 1,
    '𰩧': 1,
    '𰩮': 1,
    '𰩲': 1,
    '𰩸': 1,
    '𰩹': 1,
    '𰩺': 1,
    '𰩻': 1,
    '𰪊': 1,
    '𰪏': 1,
    '𰪣': 1,
    '𰪪': 1,
    '𰪫': 1,
    '𰪭': 1,
    '𰪶': 1,
    '𰪼': 1,
    '𰪿': 1,
    '𰫆': 2,
    '𰫋': 1,
    '𰫏': 2,
    '𰫖': 1,
    '𰫛': 2,
    '𰫳': 2,
    '𰫼': 1,
    '𰫽': 1,
    '𰫿': 1,
    '𰬀': 1,
    '𰬁': 1,
    '𰬂': 1,
    '𰬃': 1,
    '𰬅': 1,
    '𰬆': 1,
    '𰬇': 1,
    '𰬈': 1,
    '𰬉': 1,
    '𰬋': 1,
    '𰬌': 1,
    '𰬍': 1,
    '𰬎': 1,
    '𰬏': 1,
    '𰬐': 1,
    '𰬑': 1,
    '𰬒': 1,
    '𰬓': 1,
    '𰬔': 1,
    '𰬖': 1,
    '𰬗': 1,
    '𰬘': 1,
    '𰬙': 1,
    '𰬚': 1,
    '𰬛': 1,
    '𰬜': 1,
    '𰬝': 1,
    '𰬞': 1,
    '𰬟': 1,
    '𰬠': 1,
    '𰬡': 1,
    '𰬢': 1,
    '𰬣': 1,
    '𰬤': 1,
    '𰬥': 1,
    '𰬦': 1,
    '𰬧': 1,
    '𰬨': 1,
    '𰬩': 1,
    '𰬪': 1,
    '𰬫': 1,
    '𰬬': 1,
    '𰬭': 1,
    '𰬮': 1,
    '𰬯': 1,
    '𰬰': 1,
    '𰬱': 1,
    '𰬲': 1,
    '𰬳': 1,
    '𰬴': 1,
    '𰬵': 1,
    '𰬶': 1,
    '𰬷': 1,
    '𰬸': 1,
    '𰬹': 1,
    '𰬺': 1,
    '𰬻': 1,
    '𰬼': 1,
    '𰬽': 1,
    '𰬾': 1,
    '𰬿': 1,
    '𰭀': 1,
    '𰭁': 1,
    '𰭄': 1,
    '𰭔': 1,
    '𰭗': 1,
    '𰭚': 1,
    '𰭢': 1,
    '𰭣': 1,
    '𰭹': 1,
    '𰮅': 1,
    '𰮇': 1,
    '𰮙': 1,
    '𰮝': 1,
    '𰮭': 1,
    '𰮲': 1,
    '𰯂': 1,
    '𰯋': 1,
    '𰯎': 1,
    '𰯲': 2,
    '𰰆': 1,
    '𰰋': 1,
    '𰰌': 1,
    '𰰏': 1,
    '𰰑': 1,
    '𰰠': 1,
    '𰰡': 1,
    '𰰢': 1,
    '𰰤': 1,
    '𰰨': 1,
    '𰰮': 1,
    '𰰱': 1,
    '𰰳': 1,
    '𰰴': 1,
    '𰰵': 1,
    '𰰶': 1,
    '𰰷': 1,
    '𰰹': 1,
    '𰰺': 1,
    '𰰾': 1,
    '𰰿': 1,
    '𰱀': 1,
    '𰱇': 1,
    '𰱈': 1,
    '𰱉': 1,
    '𰱊': 1,
    '𰱌': 1,
    '𰱍': 1,
    '𰱐': 1,
    '𰱑': 1,
    '𰱛': 1,
    '𰱝': 1,
    '𰱟': 1,
    '𰱦': 1,
    '𰱩': 1,
    '𰱮': 1,
    '𰱯': 1,
    '𰱱': 1,
    '𰱲': 1,
    '𰱾': 1,
    '𰲁': 1,
    '𰲂': 1,
    '𰲒': 1,
    '𰲖': 1,
    '𰲟': 1,
    '𰲠': 1,
    '𰲫': 1,
    '𰲬': 1,
    '𰲮': 1,
    '𰲯': 1,
    '𰲰': 1,
    '𰲲': 1,
    '𰲳': 1,
    '𰲴': 1,
    '𰲵': 1,
    '𰲶': 1,
    '𰲸': 1,
    '𰲹': 1,
    '𰲺': 1,
    '𰲻': 1,
    '𰳁': 1,
    '𰳂': 1,
    '𰳄': 1,
    '𰳆': 1,
    '𰳊': 1,
    '𰳗': 1,
    '𰳚': 1,
    '𰳲': 1,
    '𰳵': 1,
    '𰳸': 1,
    '𰳹': 1,
    '𰳺': 1,
    '𰳻': 1,
    '𰳼': 1,
    '𰴂': 1,
    '𰴏': 2,
    '𰴕': 1,
    '𰴖': 1,
    '𰴗': 1,
    '𰴘': 1,
    '𰴙': 1,
    '𰴚': 1,
    '𰴛': 1,
    '𰴜': 1,
    '𰴝': 1,
    '𰴞': 1,
    '𰴢': 1,
    '𰴣': 1,
    '𰴤': 1,
    '𰴥': 1,
    '𰴦': 2,
    '𰴯': 1,
    '𰴽': 2,
    '𰵊': 1,
    '𰵌': 1,
    '𰵍': 1,
    '𰵎': 1,
    '𰵏': 1,
    '𰵐': 1,
    '𰵑': 1,
    '𰵒': 1,
    '𰵓': 1,
    '𰵔': 1,
    '𰵖': 1,
    '𰵗': 1,
    '𰵘': 1,
    '𰵙': 1,
    '𰵚': 1,
    '𰵛': 1,
    '𰵜': 1,
    '𰵝': 1,
    '𰵞': 1,
    '𰵠': 1,
    '𰵡': 1,
    '𰵢': 1,
    '𰵣': 1,
    '𰵤': 1,
    '𰵥': 1,
    '𰵦': 1,
    '𰵧': 1,
    '𰵨': 1,
    '𰵩': 1,
    '𰵪': 1,
    '𰵫': 1,
    '𰵬': 1,
    '𰵭': 1,
    '𰵮': 1,
    '𰵯': 1,
    '𰵰': 1,
    '𰵱': 1,
    '𰵲': 1,
    '𰵳': 1,
    '𰵴': 1,
    '𰵵': 1,
    '𰵶': 1,
    '𰵷': 1,
    '𰵸': 1,
    '𰵹': 1,
    '𰵺': 1,
    '𰵻': 1,
    '𰵼': 1,
    '𰵽': 1,
    '𰵾': 1,
    '𰵿': 1,
    '𰶀': 1,
    '𰶁': 1,
    '𰶂': 1,
    '𰶃': 1,
    '𰶄': 1,
    '𰶅': 1,
    '𰶆': 1,
    '𰶇': 1,
    '𰶈': 1,
    '𰶉': 1,
    '𰶊': 1,
    '𰶋': 1,
    '𰶌': 1,
    '𰶍': 1,
    '𰶎': 1,
    '𰶏': 1,
    '𰶑': 1,
    '𰶔': 1,
    '𰶨': 1,
    '𰶬': 1,
    '𰷞': 1,
    '𰷠': 1,
    '𰷡': 1,
    '𰷢': 1,
    '𰷤': 1,
    '𰷥': 1,
    '𰷦': 1,
    '𰷧': 1,
    '𰷨': 1,
    '𰷩': 1,
    '𰷪': 1,
    '𰷫': 1,
    '𰷬': 1,
    '𰷭': 1,
    '𰷮': 1,
    '𰷴': 1,
    '𰷵': 1,
    '𰷶': 1,
    '𰷸': 1,
    '𰸇': 1,
    '𰸈': 1,
    '𰸊': 1,
    '𰸎': 1,
    '𰸐': 1,
    '𰸔': 1,
    '𰸚': 1,
    '𰸛': 1,
    '𰸞': 1,
    '𰸦': 1,
    '𰹀': 1,
    '𰹈': 2,
    '𰹯': 1,
    '𰹱': 1,
    '𰹲': 1,
    '𰹳': 1,
    '𰹴': 1,
    '𰹵': 1,
    '𰹶': 1,
    '𰹷': 1,
    '𰹸': 1,
    '𰹺': 1,
    '𰹻': 1,
    '𰹼': 1,
    '𰹽': 1,
    '𰹾': 1,
    '𰹿': 1,
    '𰺀': 1,
    '𰺁': 1,
    '𰺂': 1,
    '𰺃': 1,
    '𰺄': 1,
    '𰺅': 1,
    '𰺆': 1,
    '𰺇': 1,
    '𰺈': 1,
    '𰺉': 1,
    '𰺊': 1,
    '𰺋': 1,
    '𰺌': 1,
    '𰺍': 1,
    '𰺎': 1,
    '𰺏': 1,
    '𰺐': 1,
    '𰺑': 1,
    '𰺒': 1,
    '𰺓': 1,
    '𰺔': 1,
    '𰺕': 1,
    '𰺖': 1,
    '𰺗': 1,
    '𰺘': 1,
    '𰺙': 1,
    '𰺚': 1,
    '𰺛': 1,
    '𰺜': 1,
    '𰺝': 1,
    '𰺞': 1,
    '𰺟': 1,
    '𰺠': 1,
    '𰺡': 1,
    '𰺢': 1,
    '𰺣': 1,
    '𰺤': 1,
    '𰺨': 1,
    '𰺭': 1,
    '𰺲': 1,
    '𰺷': 1,
    '𰻆': 1,
    '𰻝': 1,
    '𰻞': 2,
    '𰻡': 1,
    '𰻦': 1,
    '𰻨': 1,
    '𰻮': 1,
    '𰻳': 1,
    '𰼅': 1,
    '𰼋': 1,
    '𰼏': 1,
    '𰼑': 1,
    '𰼻': 1,
    '𰽕': 1,
    '𰽖': 1,
    '𰽗': 1,
    '𰽘': 1,
    '𰽚': 1,
    '𰽛': 1,
    '𰽜': 1,
    '𰽝': 1,
    '𰽞': 1,
    '𰽠': 1,
    '𰽡': 1,
    '𰽢': 1,
    '𰽣': 1,
    '𰽥': 1,
    '𰽦': 1,
    '𰽧': 1,
    '𰽨': 1,
    '𰽩': 1,
    '𰽫': 1,
    '𰽬': 1,
    '𰽭': 1,
    '𰽮': 1,
    '𰽯': 1,
    '𰽰': 1,
    '𰽱': 1,
    '𰽲': 1,
    '𰽳': 1,
    '𰽴': 1,
    '𰽵': 1,
    '𰽶': 1,
    '𰽷': 1,
    '𰽸': 1,
    '𰽹': 1,
    '𰽺': 1,
    '𰽻': 1,
    '𰽼': 1,
    '𰽽': 1,
    '𰽾': 1,
    '𰽿': 1,
    '𰾀': 1,
    '𰾁': 1,
    '𰾃': 1,
    '𰾄': 1,
    '𰾅': 1,
    '𰾆': 1,
    '𰾇': 1,
    '𰾈': 1,
    '𰾉': 1,
    '𰾊': 1,
    '𰾋': 1,
    '𰾌': 1,
    '𰾍': 1,
    '𰾎': 1,
    '𰾏': 1,
    '𰾐': 1,
    '𰾑': 1,
    '𰾒': 1,
    '𰾓': 1,
    '𰾕': 1,
    '𰾖': 1,
    '𰾗': 1,
    '𰾘': 1,
    '𰾙': 1,
    '𰾚': 1,
    '𰾛': 1,
    '𰾜': 1,
    '𰾝': 1,
    '𰾞': 1,
    '𰾟': 1,
    '𰾡': 1,
    '𰾢': 1,
    '𰾣': 1,
    '𰾤': 1,
    '𰾥': 1,
    '𰾦': 1,
    '𰾧': 1,
    '𰾨': 1,
    '𰾩': 1,
    '𰾪': 1,
    '𰾫': 1,
    '𰾬': 1,
    '𰾭': 1,
    '𰾮': 1,
    '𰾯': 1,
    '𰾰': 1,
    '𰾱': 1,
    '𰾲': 1,
    '𰾳': 1,
    '𰾴': 1,
    '𰾵': 1,
    '𰾶': 1,
    '𰾷': 1,
    '𰾸': 1,
    '𰾹': 1,
    '𰾺': 1,
    '𰾻': 1,
    '𰾼': 1,
    '𰾽': 1,
    '𰾾': 1,
    '𰾿': 1,
    '𰿀': 1,
    '𰿁': 1,
    '𰿂': 1,
    '𰿃': 1,
    '𰿄': 1,
    '𰿅': 1,
    '𰿆': 1,
    '𰿇': 1,
    '𰿈': 1,
    '𰿉': 1,
    '𰿊': 1,
    '𰿖': 1,
    '𰿢': 2,
    '𰿥': 1,
    '𰿦': 1,
    '𰿧': 1,
    '𰿨': 1,
    '𰿩': 1,
    '𰿪': 1,
    '𰿫': 1,
    '𰿬': 1,
    '𰿭': 1,
    '𰿯': 1,
    '𰿰': 1,
    '𰿳': 1,
    '𰿴': 1,
    '𰿵': 1,
    '𰿸': 1,
    '𰿹': 1,
    '𰿺': 1,
    '𰿻': 1,
    '𰿾': 1,
    '𱀑': 1,
    '𱀡': 1,
    '𱁒': 1,
    '𱁞': 1,
    '𱁱': 1,
    '𱁳': 1,
    '𱁴': 1,
    '𱁶': 1,
    '𱁷': 1,
    '𱁹': 1,
    '𱁺': 1,
    '𱁽': 1,
    '𱁾': 1,
    '𱂃': 1,
    '𱂄': 1,
    '𱂅': 1,
    '𱂆': 1,
    '𱂇': 1,
    '𱂈': 1,
    '𱂉': 1,
    '𱂊': 1,
    '𱂋': 1,
    '𱂌': 1,
    '𱂍': 1,
    '𱂎': 1,
    '𱂐': 1,
    '𱂠': 1,
    '𱂡': 1,
    '𱂢': 1,
    '𱂣': 1,
    '𱂤': 1,
    '𱂥': 1,
    '𱂦': 1,
    '𱂧': 1,
    '𱂨': 1,
    '𱂩': 1,
    '𱂫': 1,
    '𱂬': 1,
    '𱂭': 1,
    '𱂮': 1,
    '𱂯': 1,
    '𱂰': 1,
    '𱂱': 1,
    '𱂲': 1,
    '𱂳': 1,
    '𱂴': 1,
    '𱂵': 1,
    '𱂶': 1,
    '𱂷': 1,
    '𱂸': 1,
    '𱂺': 1,
    '𱂻': 1,
    '𱃔': 1,
    '𱃕': 1,
    '𱃖': 1,
    '𱃗': 1,
    '𱃘': 1,
    '𱃙': 1,
    '𱃚': 1,
    '𱃛': 1,
    '𱃜': 1,
    '𱃝': 1,
    '𱃞': 1,
    '𱃟': 1,
    '𱃠': 1,
    '𱃡': 2,
    '𱃢': 2,
    '𱃪': 2,
    '𱃱': 1,
    '𱃲': 1,
    '𱃳': 1,
    '𱃴': 1,
    '𱃵': 1,
    '𱃷': 1,
    '𱃸': 1,
    '𱃹': 1,
    '𱃺': 1,
    '𱃼': 1,
    '𱃽': 1,
    '𱃾': 1,
    '𱃿': 1,
    '𱄀': 1,
    '𱄁': 1,
    '𱄂': 1,
    '𱄃': 1,
    '𱄄': 1,
    '𱄅': 1,
    '𱄆': 1,
    '𱄇': 1,
    '𱄈': 1,
    '𱄉': 1,
    '𱄊': 1,
    '𱄼': 1,
    '𱄽': 1,
    '𱄾': 1,
    '𱄿': 1,
    '𱅀': 1,
    '𱅁': 1,
    '𱅂': 1,
    '𱅃': 1,
    '𱅄': 1,
    '𱅅': 1,
    '𱅇': 1,
    '𱅈': 1,
    '𱅉': 1,
    '𱅊': 1,
    '𱅋': 1,
    '𱅍': 1,
    '𱅎': 1,
    '𱅏': 1,
    '𱅐': 1,
    '𱅒': 1,
    '𱅓': 1,
    '𱅔': 1,
    '𱅕': 1,
    '𱅖': 1,
    '𱅗': 1,
    '𱅘': 1,
    '𱅙': 1,
    '𱅚': 1,
    '𱅛': 1,
    '𱅜': 1,
    '𱅝': 1,
    '𱅞': 1,
    '𱅟': 1,
    '𱅠': 1,
    '𱅡': 1,
    '𱅢': 1,
    '𱅣': 1,
    '𱅤': 1,
    '𱅥': 1,
    '𱅦': 1,
    '𱅧': 1,
    '𱅨': 1,
    '𱅩': 1,
    '𱅪': 1,
    '𱅫': 1,
    '𱅬': 1,
    '𱅮': 1,
    '𱆀': 1,
    '𱆁': 1,
    '𱆃': 1,
    '𱆄': 1,
    '𱆅': 1,
    '𱆆': 1,
    '𱆈': 1,
    '𱆌': 1,
    '𱆍': 1,
    '𱆖': 1,
    '𱆙': 1,
    '𱆚': 1,
    '𱆛': 1,
    '𱆥': 2,
    '𱇋': 2,
    '𱇍': 1,
    '𱇎': 1,
    '𱇏': 1,
    '𱇐': 1,
    '𱇑': 1,
    '𱇒': 1,
    '𱇓': 1,
    '𱇔': 1,
    '𱇕': 1,
    '𱇖': 1,
    '𱇗': 1,
    '𱇘': 1,
    '𱇙': 1,
    '𱇚': 1,
    '𱇛': 1,
    '𱇜': 1,
    '𱇝': 1,
    '𱇞': 1,
    '𱇟': 1,
    '𱇠': 1,
    '𱇡': 1,
    '𱇢': 1,
    '𱇣': 1,
    '𱇤': 1,
    '𱇥': 1,
    '𱇦': 1,
    '𱇧': 1,
    '𱇨': 1,
    '𱇩': 1,
    '𱇪': 1,
    '𱇫': 1,
    '𱇬': 1,
    '𱇭': 1,
    '𱇮': 1,
    '𱇯': 1,
    '𱇰': 1,
    '𱇱': 1,
    '𱇲': 1,
    '𱇳': 1,
    '𱇴': 1,
    '𱇵': 1,
    '𱇶': 1,
    '𱇷': 1,
    '𱇸': 1,
    '𱇹': 1,
    '𱇺': 1,
    '𱇻': 1,
    '𱇼': 1,
    '𱇽': 1,
    '𱇾': 1,
    '𱇿': 1,
    '𱈀': 1,
    '𱈁': 1,
    '𱈂': 1,
    '𱈃': 1,
    '𱈄': 1,
    '𱈅': 1,
    '𱈆': 1,
    '𱈇': 1,
    '𱈈': 1,
    '𱈉': 1,
    '𱈊': 1,
    '𱈋': 1,
    '𱈌': 1,
    '𱈍': 1,
    '𱈎': 1,
    '𱈏': 1,
    '𱈐': 1,
    '𱈑': 1,
    '𱈒': 1,
    '𱈓': 1,
    '𱈔': 1,
    '𱈕': 1,
    '𱈖': 1,
    '𱈗': 1,
    '𱈘': 1,
    '𱈙': 1,
    '𱈚': 1,
    '𱈛': 1,
    '𱈜': 1,
    '𱉇': 1,
    '𱉈': 1,
    '𱉉': 1,
    '𱉊': 1,
    '𱉋': 1,
    '𱉌': 1,
    '𱉍': 1,
    '𱉎': 1,
    '𱉏': 1,
    '𱉐': 1,
    '𱉑': 1,
    '𱉒': 1,
    '𱉓': 1,
    '𱉔': 1,
    '𱉕': 1,
    '𱉖': 1,
    '𱉗': 1,
    '𱉘': 1,
    '𱉙': 1,
    '𱉚': 1,
    '𱉛': 1,
    '𱉜': 1,
    '𱉝': 1,
    '𱉞': 1,
    '𱉟': 1,
    '𱉠': 1,
    '𱉡': 1,
    '𱉢': 1,
    '𱉣': 1,
    '𱉤': 1,
    '𱉥': 1,
    '𱉦': 1,
    '𱉧': 1,
    '𱉨': 1,
    '𱉩': 1,
    '𱉪': 1,
    '𱉫': 1,
    '𱉬': 1,
    '𱉭': 1,
    '𱉮': 1,
    '𱉯': 1,
    '𱉱': 1,
    '𱉲': 1,
    '𱉳': 1,
    '𱉴': 1,
    '𱉵': 1,
    '𱉶': 1,
    '𱉷': 1,
    '𱉸': 1,
    '𱉹': 1,
    '𱉺': 1,
    '𱉻': 1,
    '𱉼': 1,
    '𱉽': 1,
    '𱉾': 1,
    '𱉿': 1,
    '𱊀': 1,
    '𱊁': 1,
    '𱊂': 1,
    '𱊃': 1,
    '𱊄': 1,
    '𱊅': 1,
    '𱊆': 1,
    '𱊇': 1,
    '𱊈': 1,
    '𱊉': 1,
    '𱊊': 1,
    '𱊋': 1,
    '𱊌': 1,
    '𱊍': 1,
    '𱊎': 1,
    '𱊏': 1,
    '𱊐': 1,
    '𱊑': 1,
    '𱊒': 1,
    '𱊓': 1,
    '𱊔': 1,
    '𱊕': 1,
    '𱊖': 1,
    '𱊗': 1,
    '𱊘': 1,
    '𱊙': 1,
    '𱊚': 1,
    '𱊛': 1,
    '𱊜': 1,
    '𱊝': 1,
    '𱊞': 1,
    '𱊟': 1,
    '𱊠': 1,
    '𱊡': 1,
    '𱊢': 1,
    '𱊣': 1,
    '𱊤': 1,
    '𱊥': 1,
    '𱊦': 1,
    '𱊧': 1,
    '𱊨': 1,
    '𱊩': 1,
    '𱊪': 1,
    '𱊫': 1,
    '𱊬': 1,
    '𱊭': 1,
    '𱊮': 1,
    '𱊯': 1,
    '𱊰': 1,
    '𱊱': 1,
    '𱊲': 1,
    '𱊳': 1,
    '𱊴': 1,
    '𱊵': 1,
    '𱊺': 1,
    '𱊻': 1,
    '𱊼': 1,
    '𱊽': 1,
    '𱋂': 2,
    '𱋄': 1,
    '𱋅': 1,
    '𱋆': 1,
    '𱋇': 1,
    '𱋈': 1,
    '𱋉': 1,
    '𱋊': 1,
    '𱋋': 1,
    '𱋌': 1,
    '𱋍': 1,
    '𱋎': 1,
    '𱋐': 1,
    '𱋑': 1,
    '𱋓': 1,
    '𱋔': 1,
    '𱋕': 1,
    '𱋖': 1,
    '𱋗': 1,
    '𱋘': 1,
    '𱋙': 1,
    '𱋚': 1,
    '𱋜': 1,
    '𱋝': 1,
    '𱋟': 1,
    '𱋠': 1,
    '𱋡': 1,
    '𱋢': 1,
    '𱋣': 1,
    '𱋤': 1,
    '𱋥': 1,
    '𱋦': 1,
    '𱋨': 1,
    '𱋪': 1,
    '𱋫': 1,
    '𱋬': 1,
    '𱋭': 1,
    '𱋮': 1,
    '𱋱': 1,
    '𱋴': 1,
    '𱋶': 1,
    '𱋾': 1,
    '𱋿': 1,
    '𱌀': 1,
    '𱌁': 1,
    '𱌃': 1,
    '𱌄': 1,
    '𱌅': 1,
    '𱌆': 1,
    '𱌇': 1,
    '𱌈': 1,
    '𱌉': 1,
    '𱌊': 1,
    '𱌏': 1,
    '𱌕': 1,
    '𱌖': 1,
    '𱌗': 1,
    '𱌘': 1,
    '𱌙': 1,
    '𱌫': 1,
    '𱌬': 1,
    '𱌭': 1,
    '𱌮': 1,
    '𱌯': 1,
    '𱌰': 1,
    '𱌱': 1,
    '𱌲': 1,
    '𱌳': 1,
    '𱌴': 1,
    '𱌵': 1,
    '𱌶': 1,
    '𱌷': 1,
    '𱌸': 1,
    '𱌹': 1,
    '𱌺': 1,
    '𱌼': 1,
    '𱌽': 1,
    '𱍁': 1,
    '𱍂': 1,
    '𱍄': 1,
    '𱍅': 1,
    '𱍆': 1,
    '𱍇': 1,
    '𱍈': 1,
    '𱍉': 1,
    '𱙋': 1,
    '𱵭': 2,
    '𲁖': 1,
    '𲋢': 1,
    '𲥂': 2,
    '𲪙': 2,
    '𲪼': 2,
    '𲰍': 2,
    '𳅰': 2,
    '𳈆': 2,
    }

def detect_chinese_category(phrase: str) -> int:
    '''
    New function using Unihan data to guess whether a text is
    simplified Chinese, traditional Chinese, both, or something rare
    like a mixture of exclusively simplified with exclusively traditional
    characters.

    Meaning of the bits in the category value returned by this function:
    1 = 1 << 0       simplified Chinese
    2 = 1 << 1       traditional Chinese
    3 = (1 | 1 << 1) used both in simplified *and* traditional Chinese
    4 = 1 << 2       mixture of simplified and traditional Chinese
    '''
    # make sure that we got a unicode string
    if phrase in VARIANTS_TABLE:
        # the complete phrase is in VARIANTS_TABLE, just return the
        # value found:
        return VARIANTS_TABLE[phrase]
    category = 0xFF
    for char in phrase:
        if char in VARIANTS_TABLE:
            category &= VARIANTS_TABLE[char]
        else:
            # If it is not listed in VARIANTS_TABLE, assume it is
            # both simplified and traditional Chinese.
            # It could be something non-Chinese as well then, but
            # if it is non-Chinese, it should also be allowed to
            # occur in any Chinese text and thus classified as
            # both simplified *and* traditional Chinese (the emoji
            # table for example uses many non-Chinese characters)
            category &= (1 | 1 << 1)
    if category == 0:
        # If category is 0 after binary & of the categories of all the
        # characters in the phrase, it means that the phrase contained
        # exclusively simplified *and* exclusively traditional
        # characters at the same time.  For example if the phrase is
        # “乌烏” then “乌” gets category 1 (simplified Chinese)
        # and “烏” gets category 2 (traditional Chinese), the result
        # of the binary & is thus 0. In that case, classify it as
        # category 4 which is for weird, excentric, rare stuff. If the
        # user selects one of the modes “all characters but
        # simplified Chinese first” or “all characters but
        # traditional Chinese first”, phrases with category 4 will be
        # shown but filtered to be shown only at the end of the
        # candidate list.
        category = 1 << 2
    return category
