#
# fixate_package()
# Called by protopkg() to actually create the final package.  It packages
# up the contents of the temporary package build directory.
#
# Parameters:   $1   The package name.
#               $2   The package tree.
#               $3   The embedded package control directory.
#

fixate_package() {
   cd $2

   # first, warn for any zero-length files that may be unintentional
   find . -type f -size 0c | while read file
   do
      echo "WARNING: zero length file $file"
   done

   find . -type f -name '*.gz' -size 20c | while read file
   do
      echo "WARNING: possible empty gzipped file $file"
   done

   # Add more useful stuff to the doinst.sh script
   doinst_rules $2 $3

   # if the control directory is still empty, remove it.  --lj
   rmdir $3 1>/dev/null 2>/dev/null

   # now, create the actual package
   if [ "$VERBOSE" = "y" ]
   then
      echo
      tar -cvf $CWD/$1.tar .
      gzip -9 $CWD/$1.tar
      mv $CWD/$1.tar.gz $CWD/$1.tgz
   else
      tar -cvf $CWD/$1.tar . 2>/dev/null 1>/dev/null
      gzip -9 $CWD/$1.tar 2>/dev/null 1>/dev/null
      mv $CWD/$1.tar.gz $CWD/$1.tgz 2>/dev/null 1>/dev/null
   fi
}
