/* keyresponses.cpp
 * switching station for processing user keypresses
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Matthew Hiller
 */


#include "kbd-custom.h"
#include "keyresponses.h"
#include "articulations.h"
#include "barline.h"
#include "utils.h"

/**
 * keypress event callback 
 * looks up the key press and executes the correct function
 */
void
scorearea_keypress_event (GtkWidget * widget, GdkEventKey * event,
			  gpointer data)
{
  scoreinfo *si = (scoreinfo *) data;
  struct keybinding_info *ki;

  if (si->textview && GTK_WIDGET_IS_SENSITIVE (si->textview))
    {
      /*    printf("Focus is on text window\n"); */
      gtk_widget_draw (si->textview, NULL);
      return;
    }
  /* Look up the keystroke in the keymap and execute the appropriate
   * function */

  if ((ki = lookup_keybinding (si->prefs->the_keymap, event->keyval,
			       event->state)))
    {
      if (ki->callback_action == -1)
			ki->func.nocallback (si);
      else
			ki->func.callback (NULL, si);
		displayhelper(si);
      //gtk_widget_draw (si->scorearea, NULL);
    }
}

/**
 * Reduce the measure width by 10 pixels
 */
void
adjust_measure_less_width_key (scoreinfo *si)
{
  adjustmeasurewidth (si, -10);
}

/**
 * Enlarge the measure width by 10 pixels
 */
void
adjust_measure_more_width_key (scoreinfo *si)
{
  adjustmeasurewidth (si, 10);
}

/**
 * Reduce the staff height by 10 pixels
 */
void
adjust_staff_less_height_key (scoreinfo *si)
{
  adjuststaffheight (si, -10);
}

/**
 * Enlarge the staff height by 10 pixels
 */
void
adjust_staff_more_height_key (scoreinfo *si)
{
  adjuststaffheight (si, 10);

}

/**
 * Remove selection marker
 */
void
unset_selection_key (scoreinfo *si)
{
  si->markstaffnum = 0;
}

/**
 * Insert quarter note into score
 */
void
insert_chord_key (scoreinfo *si)
{
  insertchord (si, 2, FALSE);
}

/**
 * Goto the nearest a
 *
 */
void
go_to_A_key (scoreinfo *si)
{
  shiftcursor (si, 5);
}
/**
 * Goto the nearest b
 *
 */
void
go_to_B_key (scoreinfo *si)
{
  shiftcursor (si, 6);
}
/**
 * Goto the nearest c
 *
 */
void
go_to_C_key (scoreinfo *si)
{
  shiftcursor (si, 0);
}
/**
 * Goto the nearest d
 *
 */
void
go_to_D_key (scoreinfo *si)
{
  shiftcursor (si, 1);
}
/**
 * Goto the nearest e
 *
 */
void
go_to_E_key (scoreinfo *si)
{
  shiftcursor (si, 2);
}
/**
 * Goto the nearest f
 *
 */
void
go_to_F_key (scoreinfo *si)
{
  shiftcursor (si, 3);
}
/**
 * Goto the nearest g
 *
 */
void
go_to_G_key (scoreinfo *si)
{
  shiftcursor (si, 4);
}

/**
 * Move cursor an octave up
 */
void
octave_up_key (scoreinfo *si)
{
  si->cursor_y += 7;
}
/**
 * Move cursor an octave down
 */
void
octave_down_key (scoreinfo *si)
{
  si->cursor_y -= 7;
}

/**
 * Return to default editing mode
 * only score traversal available
 */
void
default_mode (GtkAction * action, scoreinfo *si)
{
  if (si->mode != TRAVERSE)
    si->mode = TRAVERSE;
  gtk_statusbar_push (GTK_STATUSBAR (si->statusbar), si->status_context_id,
		      "Default");
  g_print ("Mode %d\n", si->mode );
  displayhelper(si);
  
}

/**
 * Change to insert mode
 *
 */
void
insert_mode (GtkAction * action, scoreinfo *si)
{
  if (si->mode != INPUTNORMAL)
    si->mode = INPUTNORMAL;
  gtk_statusbar_push (GTK_STATUSBAR (si->statusbar), si->status_context_id,
		      "Insert");
  displayhelper(si);
}

/**
 * Change to replace mode
 * 
 */
void
replace_mode (GtkAction * action, scoreinfo *si)
{
  if (si->mode != REPLACE)
    si->mode = REPLACE;
  gtk_statusbar_push (GTK_STATUSBAR (si->statusbar), si->status_context_id,
		      "Replace");
  displayhelper(si);
}

/**
 * Change to blank mode i.e. insert invisible notes
 */
void 
blank_mode (GtkAction *action, scoreinfo *si)
{
	if (si->mode != INPUTBLANK)
	  si->mode = INPUTBLANK;
	gtk_statusbar_push (GTK_STATUSBAR (si->statusbar), si->status_context_id,
		      "Blank");
  displayhelper(si);
}

/**
 * Toggle into rest mode
 * 
 */
void
rest_toggle_key (GtkAction *action, scoreinfo *si)
{
  if (si->mode != INPUTREST)
    si->mode = INPUTREST;
   
  displayhelper(si);
}

/**
 * Toggle blank mode
 *
 */
void
toggle_blank (scoreinfo *si)
{
  if (si->mode == INPUTNORMAL)
    si->mode = INPUTBLANK;
  else if (si->mode == INPUTBLANK)
    si->mode = INPUTNORMAL;
  else
    si->mode = INPUTREST;
  displayhelper(si);
}

/**
 * Add measure to end of staff / score
 */
void
append_measure_key (scoreinfo *si)
{
  appendmeasures (si, 1);
}

/** 
 * Insert measure at the current 
 */
void
insert_measure_key (scoreinfo *si)
{
  insertmeasures (si, 1);
}


void
insert_chord_0key (scoreinfo *si)
{
  if (si->mode == REPLACE)
    change_pitch (si);
  else if(si->mode == INPUTNORMAL || si->mode == INPUTREST)
    insertchord (si, 0, FALSE);

}

void
insert_chord_1key (scoreinfo *si)
{
  if (si->mode == REPLACE)
   change_pitch (si);
  else if(si->mode == INPUTNORMAL || si->mode == INPUTREST)
    insertchord (si, 1, FALSE);
}

void
insert_chord_2key (scoreinfo *si)
{
  if (si->mode == REPLACE)
    change_pitch (si);
  else if(si->mode == INPUTNORMAL || si->mode == INPUTREST)
    insertchord (si, 2, FALSE);
}

void
insert_chord_3key (scoreinfo *si)
{
  if (si->mode == REPLACE)
    change_pitch (si);
  else if(si->mode == INPUTNORMAL || si->mode == INPUTREST)
    insertchord (si, 3, FALSE);
}

void
insert_chord_4key (scoreinfo *si)
{
  if (si->mode == REPLACE)
    change_pitch (si);
  else if(si->mode == INPUTNORMAL || si->mode == INPUTREST)
    insertchord (si, 4, FALSE);
}

void
insert_chord_5key (scoreinfo *si)
{
  if (si->mode == REPLACE)
    change_pitch (si);
  else if(si->mode == INPUTNORMAL || si->mode == INPUTREST)
    insertchord (si, 5, FALSE);
}

void
insert_chord_6key (scoreinfo *si)
{
  if (si->mode == REPLACE)
    change_pitch (si);
  else if(si->mode == INPUTNORMAL || si->mode == INPUTREST)
    insertchord (si, 6, FALSE);
}

void
insert_rest_0key (scoreinfo *si)
{
  insertchord (si, 0, TRUE);

}

void
insert_rest_1key (scoreinfo *si)
{
  insertchord (si, 1, TRUE);
}

void
insert_rest_2key (scoreinfo *si)
{
  insertchord (si, 2, TRUE);
}

void
insert_rest_3key (scoreinfo *si)
{
  insertchord (si, 3, TRUE);
}

void
insert_rest_4key (scoreinfo *si)
{
  insertchord (si, 4, TRUE);
}

void
insert_rest_5key (scoreinfo *si)
{
  insertchord (si, 5, TRUE);
}

void
insert_rest_6key (scoreinfo *si)
{
  insertchord (si, 6, TRUE);
}


void
insert_blankchord_0key (scoreinfo *si)
{
  si->mode = INPUTBLANK;
  insertchord (si, 0, FALSE);
  si->mode = INPUTNORMAL;
}

void
insert_blankchord_1key (scoreinfo *si)
{
  si->mode = INPUTBLANK;
  insertchord (si, 1, FALSE);
  si->mode = INPUTNORMAL;
}

void
insert_blankchord_2key (scoreinfo *si)
{
 si->mode = INPUTBLANK;
  insertchord (si, 2, FALSE);
  si->mode = INPUTNORMAL;
}

void
insert_blankchord_3key (scoreinfo *si)
{
si->mode = INPUTBLANK;
  insertchord (si, 3, FALSE);
  si->mode = INPUTNORMAL;
}

void
insert_blankchord_4key (scoreinfo *si)
{
	si->mode = INPUTBLANK;
  insertchord (si, 4, FALSE);
  si->mode = INPUTNORMAL;
}

void
insert_blankchord_5key (scoreinfo *si)
{
	si->mode = INPUTBLANK;
  insertchord (si, 5, FALSE);
  si->mode = INPUTNORMAL;
}

void
insert_blankchord_6key (scoreinfo *si)
{
	si->mode = INPUTBLANK;
  insertchord (si, 6, FALSE);
  si->mode = INPUTNORMAL;
}



void
insert_duplet (scoreinfo *si)
{
  inserttuplet (si, DUPLET);
}

void
insert_triplet (scoreinfo *si)
{
  inserttuplet (si, TRIPLET);
}

void
insert_quadtuplet (scoreinfo *si)
{
  inserttuplet (si, QUADTUPLET);
}

void
insert_quintuplet (scoreinfo *si)
{
  inserttuplet (si, QUINTUPLET);
}

void
insert_sextuplet (scoreinfo *si)
{
  inserttuplet (si, SEXTUPLET);
}

void
insert_septuplet (scoreinfo *si)
{
  inserttuplet (si, SEPTUPLET);
}



void
add_tone_key (scoreinfo *si)
{
  tonechange (si, FALSE);
  displayhelper (si);
}

void
remove_tone_key (scoreinfo *si)
{
  tonechange (si, TRUE);
  displayhelper (si);
}

void
backspace_key (scoreinfo *si)
{
  /* remove the object preceding the cursor, within the current measure */
  if (si->cursor_x)
    {
      /* Then move the cursor back */
      cursorleft (si);
      /* And delete */
      deleteobject (si);
    }
}

void
sharpen_key (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  if (curmudelaobj && curmudelaobj->type == STEMDIRECTIVE)
    change_stem_directive (si, DENEMO_STEMUP);
  else
    changeenshift (si, 1);
}

void
flatten_key (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  if (curmudelaobj && curmudelaobj->type == STEMDIRECTIVE)
    change_stem_directive (si, DENEMO_STEMDOWN);
  else
    changeenshift (si, -1);
}

void
tie_notes_key (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    {
      nextmeasure (si);
      object_insert (si, clone_object (curmudelaobj));
      ((chord *) curmudelaobj->object)->is_tied =
	!((chord *) curmudelaobj->object)->is_tied;
    }
}

void
add_dot_key (scoreinfo *si)
{
  changedots (si, 1);
}

void
remove_dot_key (scoreinfo *si)
{
  changedots (si, -1);
}


void
add_accent (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
	  ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(D_ACCENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
    
}

void
add_fermata (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
  ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(FERMATA,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
    
}

void
add_staccato (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
	  ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(STACCATO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
		 
   
}

void
add_tenuto (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);

  /* Equals - toggle whether this note is tied */
  if (curmudelaobj && curmudelaobj->type == CHORD)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TENUTO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}


void
add_trill (scoreinfo *si)
{
/*  note *curr;*/
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TRILL,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void
add_turn (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
   ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TURN,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void
add_mordent (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(MORDENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);

}

void
add_staccatissimo (scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(STACCATISSIMO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);

}

void add_coda(scoreinfo *si)
{
  mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(CODA,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);

	
}


void add_flageolet(scoreinfo *si) 
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(FLAGEOLET,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_open(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(OPEN,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
	
}

void add_prallmordent(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(PRALLMORDENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_prallprall(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(PRALLPRALL,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_prall(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(PRALL,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_reverseturn(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(REVERSETURN,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_segno(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(SEGNO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_sforzato(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(SFORZATO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_stopped(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(STOPPED,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_thumb(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(THUMB,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_trillelement(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TRILLELEMENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_trill_element(scoreinfo *si) 
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(TRILLELEMENT,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}
void add_upprall(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(UPPRALL,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

void add_arpeggio(scoreinfo *si)
{
	mudelaobject *curmudelaobj = (mudelaobject *)
    (si->currentobject ? si->currentobject->data : NULL);
  if (curmudelaobj && curmudelaobj->type == CHORD &&
      ((chord *) curmudelaobj->object)->tones)
    ((chord *)curmudelaobj->object)->ornamentlist = 
				  insert_ornament_list(D_ARPEGGIO,
					  					    ((chord *)curmudelaobj->object)->ornamentlist);
}

	

void
set_grace (scoreinfo *si)
{
  insertgrace (si);
}

void
force_cautionary (scoreinfo *si)
{
  mudelaobject *theobj =
    si->currentobject ? (mudelaobject *) si->currentobject->data : NULL;
  if (theobj && theobj->type == CHORD)
    caution (si);

}

void
change_pitch (scoreinfo *si)
{
 if(si->mode == REPLACE)
 {
  //mudelaobject *theobj =
  //  si->currentobject ? (mudelaobject *) si->currentobject->data : NULL;
  	 tonechange(si,TRUE);
    tonechange(si,FALSE);
  }
 // addtone(theobj, si->cursor_y, si->cursoraccs[si->staffletter_y],
	//	 si->cursorclef);
	displayhelper(si);
}


void
insert_doublebar (scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname (_("Double"))));
}

void
insert_endbar(scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname ( _("End"))));
}

void 
insert_openrepeat(scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname (_("Open Repeat"))));
}

void insert_closerepeat(scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname (_("Close Repeat"))));
}

void insert_opencloserepeat(scoreinfo *si)
{
	object_insert (si, newbarline (barlinefromname (_("Double"))));
}


/**
 * Wrapper function to create new treble clef and insert into the score
 */
void newcleftreble (scoreinfo *si)
{
  object_insert(si, newclefobj(DENEMO_TREBLE_CLEF));
}
/**
 * Wrapper function to create new bass clef and insert into the score
 */
void newclefbass (scoreinfo *si)
{
  object_insert(si, newclefobj(DENEMO_BASS_CLEF));
}
/**
 * Wrapper function to create new alto clef and insert into the score
 */
void newclefalto (scoreinfo *si)
{
  object_insert(si, newclefobj(DENEMO_ALTO_CLEF));
}
/**
 * Wrapper function to create new treble_8 clef and insert into the score
 */
void newclefg8 (scoreinfo *si)
{
  object_insert(si, newclefobj(DENEMO_G_8_CLEF));
}
/**
 * Wrapper function to create new tenor clef and insert into the score
 */
void newcleftenor (scoreinfo *si)
{
  object_insert(si, newclefobj(DENEMO_TENOR_CLEF));
}
/**
 * Wrapper function to create new soprano clef and insert into the score
 */
void newclefsoprano (scoreinfo *si)
{
  object_insert(si, newclefobj(DENEMO_SOPRANO_CLEF));
}
/**
 * Wrapper function to create new 4/4 time sig and insert into the score
 */
void newtimesig44(scoreinfo *si)
{
	object_insert(si, newtimesigobj(4,4));
}
/**
 * Wrapper function to create new 2/4 time sig and insert into the score
 */
void newtimesig24(scoreinfo *si)
{
	object_insert(si, newtimesigobj(2,4));
}

/**
 * Wrapper function to create new 3/4 time sig and insert into the score
 */
void newtimesig34(scoreinfo *si)
{
	object_insert(si, newtimesigobj(3,4));
}
/**
 * Wrapper function to create new 6/4 time sig and insert into the score
 */
void newtimesig64(scoreinfo *si)
{
	object_insert(si, newtimesigobj(6,4));
}
/**
 * Wrapper function to create new 5/4 time sig and insert into the score
 */
void newtimesig54(scoreinfo *si)
{
	object_insert(si, newtimesigobj(5,4));
}
/**
 * Wrapper function to create new 3/8 time sig and insert into the score
 */
void newtimesig38(scoreinfo *si)
{
	object_insert(si, newtimesigobj(3,8));
}
/**
 * Wrapper function to create new 6/8 time sig and insert into the score
 */
void newtimesig68(scoreinfo *si)
{
	object_insert(si, newtimesigobj(6,8));
}
/**
 * Wrapper function to create new 9/8 time sig and insert into the score
 */
void newtimesig98(scoreinfo *si)
{
	object_insert(si, newtimesigobj(9,8));
}
/**
 * Wrapper function to create new 12/8 time sig and insert into the score
 */
void newtimesig128(scoreinfo *si)
{
	object_insert(si, newtimesigobj(12,8));
}
/**
 * Wrapper function to create new 2/2 time sig and insert into the score
 */
void newtimesig22(scoreinfo *si)
{
	object_insert(si, newtimesigobj(2,2));
}
/**
 * Wrapper function to create new 3/2 time sig and insert into the score
 */
void newtimesig32(scoreinfo *si)
{
	object_insert(si, newtimesigobj(3,2));
}

/**
 * Wrapper function to create new 4/2 time sig and insert into the score
 */
void newtimesig42(scoreinfo *si)
{
	object_insert(si, newtimesigobj(4,2));
}



void newkeysigcmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(0,1,0));
}

void newkeysiggmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(1,1,0));
}

void newkeysigdmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(2,1,0));
}

void newkeysigamaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(3,1,0));
}

void newkeysigemaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(4,1,0));
}

void newkeysigbmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(5,1,0));
}

void newkeysigfsharpmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(6,1,0));
}

void newkeysigcsharpmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(7,1,0));
}

void newkeysigfmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(-1,1,0));
}

void newkeysigbflatmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(-2,1,0));
}

void newkeysigeflatmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(-3,1,0));
}

void newkeysigaflatmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(-4,1,0));
}

void newkeysigdflatmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(-5,1,0));
}

void newkeysiggflatmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(-6,1,0));
}

void newkeysigcflatmaj(scoreinfo *si)
{
	object_insert(si, newkeyobj(-7,1,0));
}

void newkeysigamin(scoreinfo *si)
{
	object_insert(si, newkeyobj(0,0,0));
}
void newkeysigemin(scoreinfo *si)
{
	object_insert(si, newkeyobj(1,0,0));
}
void newkeysigbmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(2,0,0));
}

void newkeysigfsharpmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(3,0,0));
}

void newkeysigcsharpmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(4,0,0));
}

void newkeysiggsharpmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(5,0,0));
}

void newkeysigdsharpmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(6,0,0));
}

void newkeysigasharpmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(7,0,0));
}
void newkeysigdmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(-1,0,0));
}

void newkeysiggmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(-2,0,0));
}

void newkeysigcmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(-3,0,0));
}
void newkeysigfmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(-4,0,0));
}

void newkeysigbflatmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(-5,0,0));
}

void newkeysigeflatmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(-6,0,0));
}

void newkeysigaflatmin(scoreinfo *si)
{
	object_insert(si, newkeyobj(-7,0,0));
}


//Functions to set the initial key signature
void setkeysigcmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 0,1);
	//displayhelper(si);
}

void setkeysiggmaj(scoreinfo *si)
{
   staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 1,1);
	//displayhelper(si);
}

void setkeysigdmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 2,1);
}

void setkeysigamaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 3,1);
}

void setkeysigemaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 4,1);
}

void setkeysigbmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 5,1);
}

void setkeysigfsharpmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 6,1);
}

void setkeysigcsharpmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 7,1);
}

void setkeysigfmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -1,1);
}

void setkeysigbflatmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -2,1);
}

void setkeysigeflatmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff,-3,1);
}

void setkeysigaflatmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -4,1);
}

void setkeysigdflatmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff,-5,1);
}

void setkeysiggflatmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -6,1);
}

void setkeysigcflatmaj(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -7,1);
}

void setkeysigamin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 0,0);
}
void setkeysigemin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 1,0);
}
void setkeysigbmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 2,0);
}

void setkeysigfsharpmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 3,0);
}

void setkeysigcsharpmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 4,0);
}

void setkeysiggsharpmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 5,0);
}

void setkeysigdsharpmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 6,0);
}

void setkeysigasharpmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, 7,0);
}
void setkeysigdmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -1,0);
}

void setkeysiggmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -2,0);
}

void setkeysigcmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -3,0);
}
void setkeysigfmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -4,0);
}

void setkeysigbflatmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -5,0);
}

void setkeysigeflatmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff, -6,0);
}

void setkeysigaflatmin(scoreinfo *si)
{
	staff *curstaff = (staff *)si->currentstaff->data;
	setinitialkeysig(curstaff,-7,0);
}


void settimesig22(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si, curstaff, 2,2, TRUE);
}

void settimesig42(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 4,2, TRUE);	
}

void settimesig32(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 3,2, TRUE);
}

void settimesig44(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 4,4, TRUE);
}

void settimesig54(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si, curstaff, 5,4, TRUE);
}

void settimesig24(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 2,4, TRUE);
}

void settimesig34(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 3,4, TRUE);
}

void settimesig68(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 6,8, TRUE);
}

void settimesig128(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 12,8, TRUE);
}

void settimesig38(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 3,8, TRUE);
}

void settimesig98(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 9,8, TRUE);
}

void settimesig64(scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		set_timesig(si,curstaff, 6,4, TRUE);
}

void setcleftreble (scoreinfo *si)
{
   staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		setinitialclef(si,curstaff, DENEMO_TREBLE_CLEF);
}

void setclefbass (scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		setinitialclef(si,curstaff, DENEMO_BASS_CLEF);
}

void setclefg8 (scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		setinitialclef(si,curstaff, DENEMO_G_8_CLEF);
}

void setclefalto (scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		setinitialclef(si,curstaff, DENEMO_ALTO_CLEF);
}

void setcleftenor (scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		setinitialclef(si,curstaff, DENEMO_TENOR_CLEF);
}

void setclefsoprano (scoreinfo *si)
{
	staff *curstaff = (staff *) si->currentstaff->data;
	if(curstaff)
		setinitialclef(si,curstaff, DENEMO_SOPRANO_CLEF);
}
