/* moveviewport.h
   header file for functions that change leftmeasurenum, rightmeasurenum,
   top_measure, bottom_measure

   for Denemo, a gtk+ frontend to GNU Lilypond
   (c) 2000-2005 Matthew Hiller
*/
#ifndef MOVEVIEWPORT_H
#define MOVEVIEWPORT_H

#include <denemo/denemo.h>

void
update_hscrollbar (struct scoreinfo *si);

void
update_vscrollbar (struct scoreinfo *si);

void
set_rightmeasurenum (struct scoreinfo *si);

void
set_bottom_staff (struct scoreinfo *si);

void
isoffleftside (struct scoreinfo *si);

void
isoffrightside (struct scoreinfo *si);

void
move_viewport_up (struct scoreinfo *si);

void
move_viewport_down (struct scoreinfo *si);

void
set_currentmeasurenum (struct scoreinfo *si, gint dest);

void
vertical_scroll (GtkAdjustment *adjust, struct scoreinfo *si);

void
horizontal_scroll (GtkAdjustment *adjust, struct scoreinfo *si);

void set_currentstaffnum(struct scoreinfo *si, gint dest);

#endif
