%%
%% %CopyrightBegin%
%% 
%% Copyright Ericsson AB 2008-2009. All Rights Reserved.
%% 
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% %CopyrightEnd%
%%
-module(re_testoutput1_split_test).
-compile(export_all).
-include("test_server.hrl").
%% This file is generated by running run_pcre_tests:gen_split_test("re_SUITE_data/testoutput1")
join([]) -> [];
join([A]) -> [A];
join([H|T]) -> [H,<<":">>|join(T)].
run() ->
?line <<"">> = iolist_to_binary(join(re:split("the quick brown fox","the quick brown fox",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("the quick brown fox","the quick brown fox",[{parts,
                                                                                                                                                                                                                              2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("the quick brown fox","the quick brown fox",[]))), 
?line <<"The quick brown FOX">> = iolist_to_binary(join(re:split("The quick brown FOX","the quick brown fox",[trim]))), 
?line <<"The quick brown FOX">> = iolist_to_binary(join(re:split("The quick brown FOX","the quick brown fox",[{parts,
                                                                                                                                                                                                                              2}]))), 
?line <<"The quick brown FOX">> = iolist_to_binary(join(re:split("The quick brown FOX","the quick brown fox",[]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","the quick brown fox",[trim]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","the quick brown fox",[{parts,
                                                                                                                                                                                                                                                                              2}]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","the quick brown fox",[]))), 
?line <<"What do you know about THE QUICK BROWN FOX?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","the quick brown fox",[trim]))), 
?line <<"What do you know about THE QUICK BROWN FOX?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","the quick brown fox",[{parts,
                                                                                                                                                                                                                                                                              2}]))), 
?line <<"What do you know about THE QUICK BROWN FOX?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","the quick brown fox",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("the quick brown fox","The quick brown fox",[caseless,
                                                                                                                                                                                                                            trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("the quick brown fox","The quick brown fox",[caseless,
                                                                                                                                                                                                                              {parts,
                                                                                                                                                                                                                               2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("the quick brown fox","The quick brown fox",[caseless]))), 
?line <<"">> = iolist_to_binary(join(re:split("The quick brown FOX","The quick brown fox",[caseless,
                                                                                                                                                                                                                            trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("The quick brown FOX","The quick brown fox",[caseless,
                                                                                                                                                                                                                              {parts,
                                                                                                                                                                                                                               2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("The quick brown FOX","The quick brown fox",[caseless]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","The quick brown fox",[caseless,
                                                                                                                                                                                                                                                                            trim]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","The quick brown fox",[caseless,
                                                                                                                                                                                                                                                                              {parts,
                                                                                                                                                                                                                                                                               2}]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","The quick brown fox",[caseless]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","The quick brown fox",[caseless,
                                                                                                                                                                                                                                                                            trim]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","The quick brown fox",[caseless,
                                                                                                                                                                                                                                                                              {parts,
                                                                                                                                                                                                                                                                               2}]))), 
?line <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","The quick brown fox",[caseless]))), 
?line <<"">> = iolist_to_binary(join(re:split("abcd	

9;$\\?caxyz","abcd\\t\\n\\r\\f\\a\\e\\071\\x3b\\$\\\\\\?caxyz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcd	

9;$\\?caxyz","abcd\\t\\n\\r\\f\\a\\e\\071\\x3b\\$\\\\\\?caxyz",[{parts,
                                                                                                    2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcd	

9;$\\?caxyz","abcd\\t\\n\\r\\f\\a\\e\\071\\x3b\\$\\\\\\?caxyz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                        2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                        2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                          2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                            2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                          2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                            2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                            2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                  2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                    2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                      2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                        2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("abxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                          2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aabxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aabxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aabxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                  2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                    2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("abcxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                            2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aabcxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aabcxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aabcxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                    2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                      2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                        2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                          2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABBzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABBzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABBzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<">>>">> = iolist_to_binary(join(re:split(">>>aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<">>>:">> = iolist_to_binary(join(re:split(">>>aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                  2}]))), 
?line <<">>>:">> = iolist_to_binary(join(re:split(">>>aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<">">> = iolist_to_binary(join(re:split(">aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<">:">> = iolist_to_binary(join(re:split(">aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
?line <<">:">> = iolist_to_binary(join(re:split(">aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<">>>>">> = iolist_to_binary(join(re:split(">>>>abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<">>>>:">> = iolist_to_binary(join(re:split(">>>>abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                  2}]))), 
?line <<">>>>:">> = iolist_to_binary(join(re:split(">>>>abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"abxyzpqrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<"abxyzpqrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                      2}]))), 
?line <<"abxyzpqrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"abxyzpqrrrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<"abxyzpqrrrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                          2}]))), 
?line <<"abxyzpqrrrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"abxyzpqrrrabxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrabxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<"abxyzpqrrrabxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrabxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                      2}]))), 
?line <<"abxyzpqrrrabxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrabxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                            2}]))), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                      2}]))), 
?line <<"aaaabcxyzzzzpqrrrabbbxyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<"aaabcxyzpqrrrabbxyyyypqqqqqqqAzz">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
?line <<"aaabcxyzpqrrrabbxyyyypqqqqqqqAzz">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                          2}]))), 
?line <<"aaabcxyzpqrrrabbxyyyypqqqqqqqAzz">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
?line <<":abc">> = iolist_to_binary(join(re:split("abczz","^(abc){1,2}zz",[trim]))), 
?line <<":abc:">> = iolist_to_binary(join(re:split("abczz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                      2}]))), 
?line <<":abc:">> = iolist_to_binary(join(re:split("abczz","^(abc){1,2}zz",[]))), 
?line <<":abc">> = iolist_to_binary(join(re:split("abcabczz","^(abc){1,2}zz",[trim]))), 
?line <<":abc:">> = iolist_to_binary(join(re:split("abcabczz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                            2}]))), 
?line <<":abc:">> = iolist_to_binary(join(re:split("abcabczz","^(abc){1,2}zz",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(abc){1,2}zz",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                                  2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(abc){1,2}zz",[]))), 
?line <<"zz">> = iolist_to_binary(join(re:split("zz","^(abc){1,2}zz",[trim]))), 
?line <<"zz">> = iolist_to_binary(join(re:split("zz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                2}]))), 
?line <<"zz">> = iolist_to_binary(join(re:split("zz","^(abc){1,2}zz",[]))), 
?line <<"abcabcabczz">> = iolist_to_binary(join(re:split("abcabcabczz","^(abc){1,2}zz",[trim]))), 
?line <<"abcabcabczz">> = iolist_to_binary(join(re:split("abcabcabczz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                                  2}]))), 
?line <<"abcabcabczz">> = iolist_to_binary(join(re:split("abcabcabczz","^(abc){1,2}zz",[]))), 
?line <<">>abczz">> = iolist_to_binary(join(re:split(">>abczz","^(abc){1,2}zz",[trim]))), 
?line <<">>abczz">> = iolist_to_binary(join(re:split(">>abczz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                          2}]))), 
?line <<">>abczz">> = iolist_to_binary(join(re:split(">>abczz","^(abc){1,2}zz",[]))), 
?line <<":b">> = iolist_to_binary(join(re:split("bc","^(b+?|a){1,2}?c",[trim]))), 
?line <<":b:">> = iolist_to_binary(join(re:split("bc","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                    2}]))), 
?line <<":b:">> = iolist_to_binary(join(re:split("bc","^(b+?|a){1,2}?c",[]))), 
?line <<":b">> = iolist_to_binary(join(re:split("bbc","^(b+?|a){1,2}?c",[trim]))), 
?line <<":b:">> = iolist_to_binary(join(re:split("bbc","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                      2}]))), 
?line <<":b:">> = iolist_to_binary(join(re:split("bbc","^(b+?|a){1,2}?c",[]))), 
?line <<":bb">> = iolist_to_binary(join(re:split("bbbc","^(b+?|a){1,2}?c",[trim]))), 
?line <<":bb:">> = iolist_to_binary(join(re:split("bbbc","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                        2}]))), 
?line <<":bb:">> = iolist_to_binary(join(re:split("bbbc","^(b+?|a){1,2}?c",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("bac","^(b+?|a){1,2}?c",[trim]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                      2}]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bac","^(b+?|a){1,2}?c",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("bbac","^(b+?|a){1,2}?c",[trim]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bbac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                        2}]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bbac","^(b+?|a){1,2}?c",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("aac","^(b+?|a){1,2}?c",[trim]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("aac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                      2}]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("aac","^(b+?|a){1,2}?c",[]))), 
?line <<":bbbbbbbbbbb">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+?|a){1,2}?c",[trim]))), 
?line <<":bbbbbbbbbbb:">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                                          2}]))), 
?line <<":bbbbbbbbbbb:">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+?|a){1,2}?c",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+?|a){1,2}?c",[trim]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                                          2}]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+?|a){1,2}?c",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+?|a){1,2}?c",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                                      2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+?|a){1,2}?c",[]))), 
?line <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+?|a){1,2}?c",[trim]))), 
?line <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                        2}]))), 
?line <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+?|a){1,2}?c",[]))), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+?|a){1,2}?c",[trim]))), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                                            2}]))), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+?|a){1,2}?c",[]))), 
?line <<":b">> = iolist_to_binary(join(re:split("bc","^(b+|a){1,2}c",[trim]))), 
?line <<":b:">> = iolist_to_binary(join(re:split("bc","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                2}]))), 
?line <<":b:">> = iolist_to_binary(join(re:split("bc","^(b+|a){1,2}c",[]))), 
?line <<":bb">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}c",[trim]))), 
?line <<":bb:">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                  2}]))), 
?line <<":bb:">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}c",[]))), 
?line <<":bbb">> = iolist_to_binary(join(re:split("bbbc","^(b+|a){1,2}c",[trim]))), 
?line <<":bbb:">> = iolist_to_binary(join(re:split("bbbc","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                    2}]))), 
?line <<":bbb:">> = iolist_to_binary(join(re:split("bbbc","^(b+|a){1,2}c",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("bac","^(b+|a){1,2}c",[trim]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                  2}]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bac","^(b+|a){1,2}c",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("bbac","^(b+|a){1,2}c",[trim]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bbac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                    2}]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bbac","^(b+|a){1,2}c",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("aac","^(b+|a){1,2}c",[trim]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("aac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                  2}]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("aac","^(b+|a){1,2}c",[]))), 
?line <<":bbbbbbbbbbb">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+|a){1,2}c",[trim]))), 
?line <<":bbbbbbbbbbb:">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                                      2}]))), 
?line <<":bbbbbbbbbbb:">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+|a){1,2}c",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+|a){1,2}c",[trim]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                                      2}]))), 
?line <<":a:">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+|a){1,2}c",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+|a){1,2}c",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                                  2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+|a){1,2}c",[]))), 
?line <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+|a){1,2}c",[trim]))), 
?line <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                    2}]))), 
?line <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+|a){1,2}c",[]))), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+|a){1,2}c",[trim]))), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                                        2}]))), 
?line <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+|a){1,2}c",[]))), 
?line <<":b">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}?bc",[trim]))), 
?line <<":b:">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}?bc",[{parts,
                                                                                                                                                                                      2}]))), 
?line <<":b:">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}?bc",[]))), 
?line <<":ba">> = iolist_to_binary(join(re:split("babc","^(b*|ba){1,2}?bc",[trim]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("babc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                          2}]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("babc","^(b*|ba){1,2}?bc",[]))), 
?line <<":ba">> = iolist_to_binary(join(re:split("bbabc","^(b*|ba){1,2}?bc",[trim]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("bbabc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                            2}]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("bbabc","^(b*|ba){1,2}?bc",[]))), 
?line <<":ba">> = iolist_to_binary(join(re:split("bababc","^(b*|ba){1,2}?bc",[trim]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("bababc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                              2}]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("bababc","^(b*|ba){1,2}?bc",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b*|ba){1,2}?bc",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                                        2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b*|ba){1,2}?bc",[]))), 
?line <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(b*|ba){1,2}?bc",[trim]))), 
?line <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                                2}]))), 
?line <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(b*|ba){1,2}?bc",[]))), 
?line <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(b*|ba){1,2}?bc",[trim]))), 
?line <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                                  2}]))), 
?line <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(b*|ba){1,2}?bc",[]))), 
?line <<":ba">> = iolist_to_binary(join(re:split("babc","^(ba|b*){1,2}?bc",[trim]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("babc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                          2}]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("babc","^(ba|b*){1,2}?bc",[]))), 
?line <<":ba">> = iolist_to_binary(join(re:split("bbabc","^(ba|b*){1,2}?bc",[trim]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("bbabc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                            2}]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("bbabc","^(ba|b*){1,2}?bc",[]))), 
?line <<":ba">> = iolist_to_binary(join(re:split("bababc","^(ba|b*){1,2}?bc",[trim]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("bababc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                              2}]))), 
?line <<":ba:">> = iolist_to_binary(join(re:split("bababc","^(ba|b*){1,2}?bc",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(ba|b*){1,2}?bc",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                                        2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(ba|b*){1,2}?bc",[]))), 
?line <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(ba|b*){1,2}?bc",[trim]))), 
?line <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                                2}]))), 
?line <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(ba|b*){1,2}?bc",[]))), 
?line <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(ba|b*){1,2}?bc",[trim]))), 
?line <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                                  2}]))), 
?line <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(ba|b*){1,2}?bc",[]))), 
?line <<"">> = iolist_to_binary(join(re:split(";z","^\\ca\\cA\\c[\\c{\\c:",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split(";z","^\\ca\\cA\\c[\\c{\\c:",[{parts,
                                                                                                                                                                                                           2}]))), 
?line <<":">> = iolist_to_binary(join(re:split(";z","^\\ca\\cA\\c[\\c{\\c:",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("athing","^[ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("athing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("athing","^[ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("bthing","^[ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("bthing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("bthing","^[ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("]thing","^[ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("]thing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("]thing","^[ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("cthing","^[ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("cthing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("cthing","^[ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("dthing","^[ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("dthing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("dthing","^[ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("ething","^[ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("ething","^[ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("ething","^[ab\\]cde]",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[ab\\]cde]",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[ab\\]cde]",[{parts,
                                                                                                                                                                                               2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[ab\\]cde]",[]))), 
?line <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[ab\\]cde]",[trim]))), 
?line <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
?line <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[ab\\]cde]",[]))), 
?line <<"[thing">> = iolist_to_binary(join(re:split("[thing","^[ab\\]cde]",[trim]))), 
?line <<"[thing">> = iolist_to_binary(join(re:split("[thing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
?line <<"[thing">> = iolist_to_binary(join(re:split("[thing","^[ab\\]cde]",[]))), 
?line <<"\\thing">> = iolist_to_binary(join(re:split("\\thing","^[ab\\]cde]",[trim]))), 
?line <<"\\thing">> = iolist_to_binary(join(re:split("\\thing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                         2}]))), 
?line <<"\\thing">> = iolist_to_binary(join(re:split("\\thing","^[ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("]thing","^[]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("]thing","^[]cde]",[{parts,
                                                                                                                                                                            2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("]thing","^[]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("cthing","^[]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("cthing","^[]cde]",[{parts,
                                                                                                                                                                            2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("cthing","^[]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("dthing","^[]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("dthing","^[]cde]",[{parts,
                                                                                                                                                                            2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("dthing","^[]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("ething","^[]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("ething","^[]cde]",[{parts,
                                                                                                                                                                            2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("ething","^[]cde]",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[]cde]",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[]cde]",[{parts,
                                                                                                                                                                                      2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[]cde]",[]))), 
?line <<"athing">> = iolist_to_binary(join(re:split("athing","^[]cde]",[trim]))), 
?line <<"athing">> = iolist_to_binary(join(re:split("athing","^[]cde]",[{parts,
                                                                                                                                                                            2}]))), 
?line <<"athing">> = iolist_to_binary(join(re:split("athing","^[]cde]",[]))), 
?line <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[]cde]",[trim]))), 
?line <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[]cde]",[{parts,
                                                                                                                                                                            2}]))), 
?line <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("[thing","^[^ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("[thing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("[thing","^[^ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("\\thing","^[^ab\\]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("\\thing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                           2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("\\thing","^[^ab\\]cde]",[]))), 
?line <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^ab\\]cde]",[trim]))), 
?line <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                                 2}]))), 
?line <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^ab\\]cde]",[]))), 
?line <<"athing">> = iolist_to_binary(join(re:split("athing","^[^ab\\]cde]",[trim]))), 
?line <<"athing">> = iolist_to_binary(join(re:split("athing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<"athing">> = iolist_to_binary(join(re:split("athing","^[^ab\\]cde]",[]))), 
?line <<"bthing">> = iolist_to_binary(join(re:split("bthing","^[^ab\\]cde]",[trim]))), 
?line <<"bthing">> = iolist_to_binary(join(re:split("bthing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<"bthing">> = iolist_to_binary(join(re:split("bthing","^[^ab\\]cde]",[]))), 
?line <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^ab\\]cde]",[trim]))), 
?line <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^ab\\]cde]",[]))), 
?line <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^ab\\]cde]",[trim]))), 
?line <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^ab\\]cde]",[]))), 
?line <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^ab\\]cde]",[trim]))), 
?line <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^ab\\]cde]",[]))), 
?line <<"ething">> = iolist_to_binary(join(re:split("ething","^[^ab\\]cde]",[trim]))), 
?line <<"ething">> = iolist_to_binary(join(re:split("ething","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<"ething">> = iolist_to_binary(join(re:split("ething","^[^ab\\]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("athing","^[^]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("athing","^[^]cde]",[{parts,
                                                                                                                                                                              2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("athing","^[^]cde]",[]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^]cde]",[trim]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^]cde]",[{parts,
                                                                                                                                                                              2}]))), 
?line <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^]cde]",[]))), 
?line <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^]cde]",[trim]))), 
?line <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^]cde]",[{parts,
                                                                                                                                                                                        2}]))), 
?line <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^]cde]",[]))), 
?line <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^]cde]",[trim]))), 
?line <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^]cde]",[{parts,
                                                                                                                                                                              2}]))), 
?line <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^]cde]",[]))), 
?line <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^]cde]",[trim]))), 
?line <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^]cde]",[{parts,
                                                                                                                                                                              2}]))), 
?line <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^]cde]",[]))), 
?line <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^]cde]",[trim]))), 
?line <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^]cde]",[{parts,
                                                                                                                                                                              2}]))), 
?line <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^]cde]",[]))), 
?line <<"ething">> = iolist_to_binary(join(re:split("ething","^[^]cde]",[trim]))), 
?line <<"ething">> = iolist_to_binary(join(re:split("ething","^[^]cde]",[{parts,
                                                                                                                                                                              2}]))), 
?line <<"ething">> = iolist_to_binary(join(re:split("ething","^[^]cde]",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("","^\\",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("","^\\",[{parts,
                                                                                                                                                             2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("","^\\",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("","^",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("","^",[{parts,
                                                                                                                                                        2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("","^",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("0","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("0","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("0","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("1","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("1","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("1","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("2","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("2","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("2","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("3","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("3","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("3","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("4","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("4","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("4","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("5","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("5","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("5","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("6","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("6","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("6","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("7","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("7","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("7","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("8","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("8","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("8","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("9","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("9","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("9","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("10","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("10","^[0-9]+$",[{parts,
                                                                                                                                                                       2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("10","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("100","^[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("100","^[0-9]+$",[{parts,
                                                                                                                                                                         2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("100","^[0-9]+$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[0-9]+$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[0-9]+$",[{parts,
                                                                                                                                                                                         2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[0-9]+$",[]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","^[0-9]+$",[trim]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","^[0-9]+$",[{parts,
                                                                                                                                                                         2}]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","^[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("enter","^.*nter",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("enter","^.*nter",[{parts,
                                                                                                                                                                          2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("enter","^.*nter",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("inter","^.*nter",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("inter","^.*nter",[{parts,
                                                                                                                                                                          2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("inter","^.*nter",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("uponter","^.*nter",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("uponter","^.*nter",[{parts,
                                                                                                                                                                              2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("uponter","^.*nter",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("xxx0","^xxx[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("xxx0","^xxx[0-9]+$",[{parts,
                                                                                                                                                                                 2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("xxx0","^xxx[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("xxx1234","^xxx[0-9]+$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("xxx1234","^xxx[0-9]+$",[{parts,
                                                                                                                                                                                       2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("xxx1234","^xxx[0-9]+$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^xxx[0-9]+$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^xxx[0-9]+$",[{parts,
                                                                                                                                                                                               2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^xxx[0-9]+$",[]))), 
?line <<"xxx">> = iolist_to_binary(join(re:split("xxx","^xxx[0-9]+$",[trim]))), 
?line <<"xxx">> = iolist_to_binary(join(re:split("xxx","^xxx[0-9]+$",[{parts,
                                                                                                                                                                               2}]))), 
?line <<"xxx">> = iolist_to_binary(join(re:split("xxx","^xxx[0-9]+$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("x123","^.+[0-9][0-9][0-9]$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("x123","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                 2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("x123","^.+[0-9][0-9][0-9]$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("xx123","^.+[0-9][0-9][0-9]$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("xx123","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("xx123","^.+[0-9][0-9][0-9]$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("123456","^.+[0-9][0-9][0-9]$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("123456","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("123456","^.+[0-9][0-9][0-9]$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+[0-9][0-9][0-9]$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                               2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+[0-9][0-9][0-9]$",[]))), 
?line <<"123">> = iolist_to_binary(join(re:split("123","^.+[0-9][0-9][0-9]$",[trim]))), 
?line <<"123">> = iolist_to_binary(join(re:split("123","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                               2}]))), 
?line <<"123">> = iolist_to_binary(join(re:split("123","^.+[0-9][0-9][0-9]$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("x1234","^.+[0-9][0-9][0-9]$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("x1234","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("x1234","^.+[0-9][0-9][0-9]$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("x123","^.+?[0-9][0-9][0-9]$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("x123","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("x123","^.+?[0-9][0-9][0-9]$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("xx123","^.+?[0-9][0-9][0-9]$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("xx123","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("xx123","^.+?[0-9][0-9][0-9]$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("123456","^.+?[0-9][0-9][0-9]$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("123456","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                       2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("123456","^.+?[0-9][0-9][0-9]$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+?[0-9][0-9][0-9]$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                                 2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+?[0-9][0-9][0-9]$",[]))), 
?line <<"123">> = iolist_to_binary(join(re:split("123","^.+?[0-9][0-9][0-9]$",[trim]))), 
?line <<"123">> = iolist_to_binary(join(re:split("123","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                 2}]))), 
?line <<"123">> = iolist_to_binary(join(re:split("123","^.+?[0-9][0-9][0-9]$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("x1234","^.+?[0-9][0-9][0-9]$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("x1234","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("x1234","^.+?[0-9][0-9][0-9]$",[]))), 
?line <<":abc:pqr">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
?line <<":abc:pqr:">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                                     2}]))), 
?line <<":abc:pqr:">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                   2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
?line <<"!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
?line <<"!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                               2}]))), 
?line <<"!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
?line <<"abc!=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
?line <<"abc!=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                               2}]))), 
?line <<"abc!=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
?line <<"abc!pqr=apquxz:ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz:ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
?line <<"abc!pqr=apquxz:ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz:ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                                     2}]))), 
?line <<"abc!pqr=apquxz:ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz:ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
?line <<"abc!pqr=apquxz.ixr.zzz.ac.ukk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.ukk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
?line <<"abc!pqr=apquxz.ixr.zzz.ac.ukk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.ukk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                                       2}]))), 
?line <<"abc!pqr=apquxz.ixr.zzz.ac.ukk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.ukk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
?line <<"Well, we need a colon: somewhere">> = iolist_to_binary(join(re:split("Well, we need a colon: somewhere",":",[trim]))), 
?line <<"Well, we need a colon: somewhere">> = iolist_to_binary(join(re:split("Well, we need a colon: somewhere",":",[{parts,
                                                                                                                                                                                                                    2}]))), 
?line <<"Well, we need a colon: somewhere">> = iolist_to_binary(join(re:split("Well, we need a colon: somewhere",":",[]))), 
?line <<"*** Fail if we don't">> = iolist_to_binary(join(re:split("*** Fail if we don't",":",[trim]))), 
?line <<"*** Fail if we don't">> = iolist_to_binary(join(re:split("*** Fail if we don't",":",[{parts,
                                                                                                                                                                                                    2}]))), 
?line <<"*** Fail if we don't">> = iolist_to_binary(join(re:split("*** Fail if we don't",":",[]))), 
?line <<":0abc">> = iolist_to_binary(join(re:split("0abc","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    trim]))), 
?line <<":0abc:">> = iolist_to_binary(join(re:split("0abc","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                      {parts,
                                                                                                                                                                                       2}]))), 
?line <<":0abc:">> = iolist_to_binary(join(re:split("0abc","([\\da-f:]+)$",[caseless]))), 
?line <<":abc">> = iolist_to_binary(join(re:split("abc","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  trim]))), 
?line <<":abc:">> = iolist_to_binary(join(re:split("abc","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    {parts,
                                                                                                                                                                                     2}]))), 
?line <<":abc:">> = iolist_to_binary(join(re:split("abc","([\\da-f:]+)$",[caseless]))), 
?line <<":fed">> = iolist_to_binary(join(re:split("fed","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  trim]))), 
?line <<":fed:">> = iolist_to_binary(join(re:split("fed","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    {parts,
                                                                                                                                                                                     2}]))), 
?line <<":fed:">> = iolist_to_binary(join(re:split("fed","([\\da-f:]+)$",[caseless]))), 
?line <<":E">> = iolist_to_binary(join(re:split("E","([\\da-f:]+)$",[caseless,
                                                                                                                                                                              trim]))), 
?line <<":E:">> = iolist_to_binary(join(re:split("E","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                {parts,
                                                                                                                                                                                 2}]))), 
?line <<":E:">> = iolist_to_binary(join(re:split("E","([\\da-f:]+)$",[caseless]))), 
?line <<":::">> = iolist_to_binary(join(re:split("::","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                trim]))), 
?line <<"::::">> = iolist_to_binary(join(re:split("::","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  {parts,
                                                                                                                                                                                   2}]))), 
?line <<"::::">> = iolist_to_binary(join(re:split("::","([\\da-f:]+)$",[caseless]))), 
?line <<":5f03:12C0::932e">> = iolist_to_binary(join(re:split("5f03:12C0::932e","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                          trim]))), 
?line <<":5f03:12C0::932e:">> = iolist_to_binary(join(re:split("5f03:12C0::932e","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                            {parts,
                                                                                                                                                                                                             2}]))), 
?line <<":5f03:12C0::932e:">> = iolist_to_binary(join(re:split("5f03:12C0::932e","([\\da-f:]+)$",[caseless]))), 
?line <<"fed :def">> = iolist_to_binary(join(re:split("fed def","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                          trim]))), 
?line <<"fed :def:">> = iolist_to_binary(join(re:split("fed def","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                            {parts,
                                                                                                                                                                                             2}]))), 
?line <<"fed :def:">> = iolist_to_binary(join(re:split("fed def","([\\da-f:]+)$",[caseless]))), 
?line <<"Any old stu:ff">> = iolist_to_binary(join(re:split("Any old stuff","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                      trim]))), 
?line <<"Any old stu:ff:">> = iolist_to_binary(join(re:split("Any old stuff","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                        {parts,
                                                                                                                                                                                                         2}]))), 
?line <<"Any old stu:ff:">> = iolist_to_binary(join(re:split("Any old stuff","([\\da-f:]+)$",[caseless]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                  trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                    {parts,
                                                                                                                                                                                                     2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","([\\da-f:]+)$",[caseless]))), 
?line <<"0zzz">> = iolist_to_binary(join(re:split("0zzz","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    trim]))), 
?line <<"0zzz">> = iolist_to_binary(join(re:split("0zzz","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                      {parts,
                                                                                                                                                                                       2}]))), 
?line <<"0zzz">> = iolist_to_binary(join(re:split("0zzz","([\\da-f:]+)$",[caseless]))), 
?line <<"gzzz">> = iolist_to_binary(join(re:split("gzzz","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    trim]))), 
?line <<"gzzz">> = iolist_to_binary(join(re:split("gzzz","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                      {parts,
                                                                                                                                                                                       2}]))), 
?line <<"gzzz">> = iolist_to_binary(join(re:split("gzzz","([\\da-f:]+)$",[caseless]))), 
?line <<"fed ">> = iolist_to_binary(join(re:split("fed ","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    trim]))), 
?line <<"fed ">> = iolist_to_binary(join(re:split("fed ","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                      {parts,
                                                                                                                                                                                       2}]))), 
?line <<"fed ">> = iolist_to_binary(join(re:split("fed ","([\\da-f:]+)$",[caseless]))), 
?line <<"Any old rubbish">> = iolist_to_binary(join(re:split("Any old rubbish","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                          trim]))), 
?line <<"Any old rubbish">> = iolist_to_binary(join(re:split("Any old rubbish","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                            {parts,
                                                                                                                                                                                                             2}]))), 
?line <<"Any old rubbish">> = iolist_to_binary(join(re:split("Any old rubbish","([\\da-f:]+)$",[caseless]))), 
?line <<":1:2:3">> = iolist_to_binary(join(re:split(".1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
?line <<":1:2:3:">> = iolist_to_binary(join(re:split(".1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                           2}]))), 
?line <<":1:2:3:">> = iolist_to_binary(join(re:split(".1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
?line <<":12:123:0">> = iolist_to_binary(join(re:split("A.12.123.0","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
?line <<":12:123:0:">> = iolist_to_binary(join(re:split("A.12.123.0","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                                   2}]))), 
?line <<":12:123:0:">> = iolist_to_binary(join(re:split("A.12.123.0","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                                     2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
?line <<".1.2.3333">> = iolist_to_binary(join(re:split(".1.2.3333","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
?line <<".1.2.3333">> = iolist_to_binary(join(re:split(".1.2.3333","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                                 2}]))), 
?line <<".1.2.3333">> = iolist_to_binary(join(re:split(".1.2.3333","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
?line <<"1.2.3">> = iolist_to_binary(join(re:split("1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
?line <<"1.2.3">> = iolist_to_binary(join(re:split("1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                         2}]))), 
?line <<"1.2.3">> = iolist_to_binary(join(re:split("1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
?line <<"1234.2.3">> = iolist_to_binary(join(re:split("1234.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
?line <<"1234.2.3">> = iolist_to_binary(join(re:split("1234.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                               2}]))), 
?line <<"1234.2.3">> = iolist_to_binary(join(re:split("1234.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
?line <<":1:non-sp1:non-sp2">> = iolist_to_binary(join(re:split("1 IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[trim]))), 
?line <<":1:non-sp1:non-sp2:">> = iolist_to_binary(join(re:split("1 IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[{parts,
                                                                                                                                                                                                                                                                                                                       2}]))), 
?line <<":1:non-sp1:non-sp2:">> = iolist_to_binary(join(re:split("1 IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[]))), 
?line <<":1:non-sp1:non-sp2">> = iolist_to_binary(join(re:split("1    IN    SOA    non-sp1    non-sp2   (","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[trim]))), 
?line <<":1:non-sp1:non-sp2:">> = iolist_to_binary(join(re:split("1    IN    SOA    non-sp1    non-sp2   (","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[{parts,
                                                                                                                                                                                                                                                                                                                                                     2}]))), 
?line <<":1:non-sp1:non-sp2:">> = iolist_to_binary(join(re:split("1    IN    SOA    non-sp1    non-sp2   (","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[{parts,
                                                                                                                                                                                                                                                                                           2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[]))), 
?line <<"1IN SOA non-sp1 non-sp2(">> = iolist_to_binary(join(re:split("1IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[trim]))), 
?line <<"1IN SOA non-sp1 non-sp2(">> = iolist_to_binary(join(re:split("1IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[{parts,
                                                                                                                                                                                                                                                                                                                     2}]))), 
?line <<"1IN SOA non-sp1 non-sp2(">> = iolist_to_binary(join(re:split("1IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("a.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
?line <<"::">> = iolist_to_binary(join(re:split("a.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                             2}]))), 
?line <<"::">> = iolist_to_binary(join(re:split("a.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("Z.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
?line <<"::">> = iolist_to_binary(join(re:split("Z.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                             2}]))), 
?line <<"::">> = iolist_to_binary(join(re:split("Z.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("2.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
?line <<"::">> = iolist_to_binary(join(re:split("2.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                             2}]))), 
?line <<"::">> = iolist_to_binary(join(re:split("2.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
?line <<":.pq-r">> = iolist_to_binary(join(re:split("ab-c.pq-r.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
?line <<":.pq-r:">> = iolist_to_binary(join(re:split("ab-c.pq-r.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                             2}]))), 
?line <<":.pq-r:">> = iolist_to_binary(join(re:split("ab-c.pq-r.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
?line <<":.uk">> = iolist_to_binary(join(re:split("sxk.zzz.ac.uk.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
?line <<":.uk:">> = iolist_to_binary(join(re:split("sxk.zzz.ac.uk.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                                     2}]))), 
?line <<":.uk:">> = iolist_to_binary(join(re:split("sxk.zzz.ac.uk.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
?line <<":.y-">> = iolist_to_binary(join(re:split("x-.y-.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
?line <<":.y-:">> = iolist_to_binary(join(re:split("x-.y-.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                     2}]))), 
?line <<":.y-:">> = iolist_to_binary(join(re:split("x-.y-.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                               2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
?line <<"-abc.peq.">> = iolist_to_binary(join(re:split("-abc.peq.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
?line <<"-abc.peq.">> = iolist_to_binary(join(re:split("-abc.peq.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                           2}]))), 
?line <<"-abc.peq.">> = iolist_to_binary(join(re:split("-abc.peq.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("*.a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<"::::">> = iolist_to_binary(join(re:split("*.a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                  2}]))), 
?line <<"::::">> = iolist_to_binary(join(re:split("*.a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<":0-a">> = iolist_to_binary(join(re:split("*.b0-a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<":0-a:::">> = iolist_to_binary(join(re:split("*.b0-a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                        2}]))), 
?line <<":0-a:::">> = iolist_to_binary(join(re:split("*.b0-a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<":3-b:.c">> = iolist_to_binary(join(re:split("*.c3-b.c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<":3-b:.c::">> = iolist_to_binary(join(re:split("*.c3-b.c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                            2}]))), 
?line <<":3-b:.c::">> = iolist_to_binary(join(re:split("*.c3-b.c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<":-a:.b-c:-c">> = iolist_to_binary(join(re:split("*.c-a.b-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<":-a:.b-c:-c:">> = iolist_to_binary(join(re:split("*.c-a.b-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                              2}]))), 
?line <<":-a:.b-c:-c:">> = iolist_to_binary(join(re:split("*.c-a.b-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                                  2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<"*.0">> = iolist_to_binary(join(re:split("*.0","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<"*.0">> = iolist_to_binary(join(re:split("*.0","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                  2}]))), 
?line <<"*.0">> = iolist_to_binary(join(re:split("*.0","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<"*.a-">> = iolist_to_binary(join(re:split("*.a-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<"*.a-">> = iolist_to_binary(join(re:split("*.a-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                    2}]))), 
?line <<"*.a-">> = iolist_to_binary(join(re:split("*.a-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<"*.a-b.c-">> = iolist_to_binary(join(re:split("*.a-b.c-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<"*.a-b.c-">> = iolist_to_binary(join(re:split("*.a-b.c-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                            2}]))), 
?line <<"*.a-b.c-">> = iolist_to_binary(join(re:split("*.a-b.c-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<"*.c-a.0-c">> = iolist_to_binary(join(re:split("*.c-a.0-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
?line <<"*.c-a.0-c">> = iolist_to_binary(join(re:split("*.c-a.0-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                              2}]))), 
?line <<"*.c-a.0-c">> = iolist_to_binary(join(re:split("*.c-a.0-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
?line <<":de:abd:e">> = iolist_to_binary(join(re:split("abde","^(?=ab(de))(abd)(e)",[trim]))), 
?line <<":de:abd:e:">> = iolist_to_binary(join(re:split("abde","^(?=ab(de))(abd)(e)",[{parts,
                                                                                                                                                                                                2}]))), 
?line <<":de:abd:e:">> = iolist_to_binary(join(re:split("abde","^(?=ab(de))(abd)(e)",[]))), 
?line <<"::abd:f">> = iolist_to_binary(join(re:split("abdf","^(?!(ab)de|x)(abd)(f)",[trim]))), 
?line <<"::abd:f:">> = iolist_to_binary(join(re:split("abdf","^(?!(ab)de|x)(abd)(f)",[{parts,
                                                                                                                                                                                                    2}]))), 
?line <<"::abd:f:">> = iolist_to_binary(join(re:split("abdf","^(?!(ab)de|x)(abd)(f)",[]))), 
?line <<":abcd:cd:ab:cd">> = iolist_to_binary(join(re:split("abcd","^(?=(ab(cd)))(ab)",[trim]))), 
?line <<":abcd:cd:ab:cd">> = iolist_to_binary(join(re:split("abcd","^(?=(ab(cd)))(ab)",[{parts,
                                                                                                                                                                                            2}]))), 
?line <<":abcd:cd:ab:cd">> = iolist_to_binary(join(re:split("abcd","^(?=(ab(cd)))(ab)",[]))), 
?line <<":.d">> = iolist_to_binary(join(re:split("a.b.c.d","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                  trim]))), 
?line <<":.d:">> = iolist_to_binary(join(re:split("a.b.c.d","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                    {parts,
                                                                                                                                                                                                                     2}]))), 
?line <<":.d:">> = iolist_to_binary(join(re:split("a.b.c.d","^[\\da-f](\\.[\\da-f])*$",[caseless]))), 
?line <<":.D">> = iolist_to_binary(join(re:split("A.B.C.D","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                  trim]))), 
?line <<":.D:">> = iolist_to_binary(join(re:split("A.B.C.D","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                    {parts,
                                                                                                                                                                                                                     2}]))), 
?line <<":.D:">> = iolist_to_binary(join(re:split("A.B.C.D","^[\\da-f](\\.[\\da-f])*$",[caseless]))), 
?line <<":.C">> = iolist_to_binary(join(re:split("a.b.c.1.2.3.C","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                              trim]))), 
?line <<":.C:">> = iolist_to_binary(join(re:split("a.b.c.1.2.3.C","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                                {parts,
                                                                                                                                                                                                                                 2}]))), 
?line <<":.C:">> = iolist_to_binary(join(re:split("a.b.c.1.2.3.C","^[\\da-f](\\.[\\da-f])*$",[caseless]))), 
?line <<"">> = iolist_to_binary(join(re:split("\"1234\"","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
?line <<"::">> = iolist_to_binary(join(re:split("\"1234\"","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                        2}]))), 
?line <<"::">> = iolist_to_binary(join(re:split("\"1234\"","^\\\".*\\\"\\s*(;.*)?$",[]))), 
?line <<":;">> = iolist_to_binary(join(re:split("\"abcd\" ;","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
?line <<":;:">> = iolist_to_binary(join(re:split("\"abcd\" ;","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                            2}]))), 
?line <<":;:">> = iolist_to_binary(join(re:split("\"abcd\" ;","^\\\".*\\\"\\s*(;.*)?$",[]))), 
?line <<":; rhubarb">> = iolist_to_binary(join(re:split("\"\" ; rhubarb","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
?line <<":; rhubarb:">> = iolist_to_binary(join(re:split("\"\" ; rhubarb","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                                    2}]))), 
?line <<":; rhubarb:">> = iolist_to_binary(join(re:split("\"\" ; rhubarb","^\\\".*\\\"\\s*(;.*)?$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                          2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\\".*\\\"\\s*(;.*)?$",[]))), 
?line <<"\"1234\" : things">> = iolist_to_binary(join(re:split("\"1234\" : things","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
?line <<"\"1234\" : things">> = iolist_to_binary(join(re:split("\"1234\" : things","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                                          2}]))), 
?line <<"\"1234\" : things">> = iolist_to_binary(join(re:split("\"1234\" : things","^\\\".*\\\"\\s*(;.*)?$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("","^$",[trim]))), 
?line <<"">> = iolist_to_binary(join(re:split("","^$",[{parts,
                                                                                                                                                       2}]))), 
?line <<"">> = iolist_to_binary(join(re:split("","^$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^$",[{parts,
                                                                                                                                                                             2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("ab c","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("ab c","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                  {parts,
                                                                                                                                                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("ab c","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                              trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                                {parts,
                                                                                                                                                                                                                                                                                                                 2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                              trim]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                {parts,
                                                                                                                                                                                                                                                                                                 2}]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended]))), 
?line <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                    trim]))), 
?line <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                      {parts,
                                                                                                                                                                                                                                                                                                       2}]))), 
?line <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended]))), 
?line <<"">> = iolist_to_binary(join(re:split("ab c","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("ab c","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[{parts,
                                                                                                                                                                                                                                                                                                          2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("ab c","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[{parts,
                                                                                                                                                                                                                                                                                                                        2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[trim]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[{parts,
                                                                                                                                                                                                                                                                                                        2}]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[]))), 
?line <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[trim]))), 
?line <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[{parts,
                                                                                                                                                                                                                                                                                                              2}]))), 
?line <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("a bcd","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                        trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("a bcd","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                          {parts,
                                                                                                                                                                                                           2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("a bcd","^   a\\ b[c ]d       $",[extended]))), 
?line <<"">> = iolist_to_binary(join(re:split("a b d","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                        trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("a b d","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                          {parts,
                                                                                                                                                                                                           2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("a b d","^   a\\ b[c ]d       $",[extended]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                                    trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                                      {parts,
                                                                                                                                                                                                                       2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^   a\\ b[c ]d       $",[extended]))), 
?line <<"abcd">> = iolist_to_binary(join(re:split("abcd","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                      trim]))), 
?line <<"abcd">> = iolist_to_binary(join(re:split("abcd","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                        {parts,
                                                                                                                                                                                                         2}]))), 
?line <<"abcd">> = iolist_to_binary(join(re:split("abcd","^   a\\ b[c ]d       $",[extended]))), 
?line <<"ab d">> = iolist_to_binary(join(re:split("ab d","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                      trim]))), 
?line <<"ab d">> = iolist_to_binary(join(re:split("ab d","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                        {parts,
                                                                                                                                                                                                         2}]))), 
?line <<"ab d">> = iolist_to_binary(join(re:split("ab d","^   a\\ b[c ]d       $",[extended]))), 
?line <<":abc:bc:c:def:ef:f:hij:ij:j:klm:lm:m">> = iolist_to_binary(join(re:split("abcdefhijklm","^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$",[trim]))), 
?line <<":abc:bc:c:def:ef:f:hij:ij:j:klm:lm:m:">> = iolist_to_binary(join(re:split("abcdefhijklm","^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$",[{parts,
                                                                                                                                                                                                                                                       2}]))), 
?line <<":abc:bc:c:def:ef:f:hij:ij:j:klm:lm:m:">> = iolist_to_binary(join(re:split("abcdefhijklm","^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$",[]))), 
?line <<":bc:c:ef:f:ij:j:lm:m">> = iolist_to_binary(join(re:split("abcdefhijklm","^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$",[trim]))), 
?line <<":bc:c:ef:f:ij:j:lm:m:">> = iolist_to_binary(join(re:split("abcdefhijklm","^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$",[{parts,
                                                                                                                                                                                                                                                                       2}]))), 
?line <<":bc:c:ef:f:ij:j:lm:m:">> = iolist_to_binary(join(re:split("abcdefhijklm","^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("a+ Z0+
","^[\\w][\\W][\\s][\\S][\\d][\\D][\\b][\\n][\\c]][\\022]",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("a+ Z0+
","^[\\w][\\W][\\s][\\S][\\d][\\D][\\b][\\n][\\c]][\\022]",[{parts,
                                                                                      2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("a+ Z0+
","^[\\w][\\W][\\s][\\S][\\d][\\D][\\b][\\n][\\c]][\\022]",[]))), 
?line <<"">> = iolist_to_binary(join(re:split(".^$(*+)|{?,?}","^[.^$|()*+?{,}]+",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split(".^$(*+)|{?,?}","^[.^$|()*+?{,}]+",[{parts,
                                                                                                                                                                                                               2}]))), 
?line <<":">> = iolist_to_binary(join(re:split(".^$(*+)|{?,?}","^[.^$|()*+?{,}]+",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("z","^a*\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("z","^a*\\w",[{parts,
                                                                                                                                                                 2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("z","^a*\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("az","^a*\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("az","^a*\\w",[{parts,
                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("az","^a*\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaz","^a*\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaz","^a*\\w",[{parts,
                                                                                                                                                                       2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaz","^a*\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("a","^a*\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("a","^a*\\w",[{parts,
                                                                                                                                                                 2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("a","^a*\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aa","^a*\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aa","^a*\\w",[{parts,
                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aa","^a*\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaa","^a*\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaa","^a*\\w",[{parts,
                                                                                                                                                                       2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaa","^a*\\w",[]))), 
?line <<":+">> = iolist_to_binary(join(re:split("a+","^a*\\w",[trim]))), 
?line <<":+">> = iolist_to_binary(join(re:split("a+","^a*\\w",[{parts,
                                                                                                                                                                   2}]))), 
?line <<":+">> = iolist_to_binary(join(re:split("a+","^a*\\w",[]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a*\\w",[trim]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a*\\w",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a*\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("z","^a*?\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("z","^a*?\\w",[{parts,
                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("z","^a*?\\w",[]))), 
?line <<":z">> = iolist_to_binary(join(re:split("az","^a*?\\w",[trim]))), 
?line <<":z">> = iolist_to_binary(join(re:split("az","^a*?\\w",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":z">> = iolist_to_binary(join(re:split("az","^a*?\\w",[]))), 
?line <<":aaz">> = iolist_to_binary(join(re:split("aaaz","^a*?\\w",[trim]))), 
?line <<":aaz">> = iolist_to_binary(join(re:split("aaaz","^a*?\\w",[{parts,
                                                                                                                                                                         2}]))), 
?line <<":aaz">> = iolist_to_binary(join(re:split("aaaz","^a*?\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("a","^a*?\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("a","^a*?\\w",[{parts,
                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("a","^a*?\\w",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("aa","^a*?\\w",[trim]))), 
?line <<":a">> = iolist_to_binary(join(re:split("aa","^a*?\\w",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":a">> = iolist_to_binary(join(re:split("aa","^a*?\\w",[]))), 
?line <<":aaa">> = iolist_to_binary(join(re:split("aaaa","^a*?\\w",[trim]))), 
?line <<":aaa">> = iolist_to_binary(join(re:split("aaaa","^a*?\\w",[{parts,
                                                                                                                                                                         2}]))), 
?line <<":aaa">> = iolist_to_binary(join(re:split("aaaa","^a*?\\w",[]))), 
?line <<":+">> = iolist_to_binary(join(re:split("a+","^a*?\\w",[trim]))), 
?line <<":+">> = iolist_to_binary(join(re:split("a+","^a*?\\w",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":+">> = iolist_to_binary(join(re:split("a+","^a*?\\w",[]))), 
?line <<":a+">> = iolist_to_binary(join(re:split("aa+","^a*?\\w",[trim]))), 
?line <<":a+">> = iolist_to_binary(join(re:split("aa+","^a*?\\w",[{parts,
                                                                                                                                                                       2}]))), 
?line <<":a+">> = iolist_to_binary(join(re:split("aa+","^a*?\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("az","^a+\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("az","^a+\\w",[{parts,
                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("az","^a+\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaz","^a+\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaz","^a+\\w",[{parts,
                                                                                                                                                                       2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaz","^a+\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aa","^a+\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aa","^a+\\w",[{parts,
                                                                                                                                                                   2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aa","^a+\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaa","^a+\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaa","^a+\\w",[{parts,
                                                                                                                                                                       2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaa","^a+\\w",[]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a+\\w",[trim]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a+\\w",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a+\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("az","^a+?\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("az","^a+?\\w",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("az","^a+?\\w",[]))), 
?line <<":az">> = iolist_to_binary(join(re:split("aaaz","^a+?\\w",[trim]))), 
?line <<":az">> = iolist_to_binary(join(re:split("aaaz","^a+?\\w",[{parts,
                                                                                                                                                                         2}]))), 
?line <<":az">> = iolist_to_binary(join(re:split("aaaz","^a+?\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aa","^a+?\\w",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aa","^a+?\\w",[{parts,
                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aa","^a+?\\w",[]))), 
?line <<":aa">> = iolist_to_binary(join(re:split("aaaa","^a+?\\w",[trim]))), 
?line <<":aa">> = iolist_to_binary(join(re:split("aaaa","^a+?\\w",[{parts,
                                                                                                                                                                         2}]))), 
?line <<":aa">> = iolist_to_binary(join(re:split("aaaa","^a+?\\w",[]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a+?\\w",[trim]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a+?\\w",[{parts,
                                                                                                                                                                       2}]))), 
?line <<":+">> = iolist_to_binary(join(re:split("aa+","^a+?\\w",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("1234567890","^\\d{8}\\w{2,}",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234567890","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                                    2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234567890","^\\d{8}\\w{2,}",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("12345678ab","^\\d{8}\\w{2,}",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("12345678ab","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                                    2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("12345678ab","^\\d{8}\\w{2,}",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("12345678__","^\\d{8}\\w{2,}",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("12345678__","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                                    2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("12345678__","^\\d{8}\\w{2,}",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\d{8}\\w{2,}",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                                      2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\d{8}\\w{2,}",[]))), 
?line <<"1234567">> = iolist_to_binary(join(re:split("1234567","^\\d{8}\\w{2,}",[trim]))), 
?line <<"1234567">> = iolist_to_binary(join(re:split("1234567","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                              2}]))), 
?line <<"1234567">> = iolist_to_binary(join(re:split("1234567","^\\d{8}\\w{2,}",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                              2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                              2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                                2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}$",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                                2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}$",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[aeiou\\d]{4,5}$",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                                            2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[aeiou\\d]{4,5}$",[]))), 
?line <<"123456">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}$",[trim]))), 
?line <<"123456">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                                  2}]))), 
?line <<"123456">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}$",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}?",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                             2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}?",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}?",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                             2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}?",[]))), 
?line <<":5">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}?",[trim]))), 
?line <<":5">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                               2}]))), 
?line <<":5">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}?",[]))), 
?line <<":a">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}?",[trim]))), 
?line <<":a">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                               2}]))), 
?line <<":a">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}?",[]))), 
?line <<":56">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}?",[trim]))), 
?line <<":56">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                                 2}]))), 
?line <<":56">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}?",[]))), 
?line <<":abc:abc">> = iolist_to_binary(join(re:split("abc=abcabc","\\A(abc|def)=(\\1){2,3}\\Z",[trim]))), 
?line <<":abc:abc:">> = iolist_to_binary(join(re:split("abc=abcabc","\\A(abc|def)=(\\1){2,3}\\Z",[{parts,
                                                                                                                                                                                                                             2}]))), 
?line <<":abc:abc:">> = iolist_to_binary(join(re:split("abc=abcabc","\\A(abc|def)=(\\1){2,3}\\Z",[]))), 
?line <<":def:def">> = iolist_to_binary(join(re:split("def=defdefdef","\\A(abc|def)=(\\1){2,3}\\Z",[trim]))), 
?line <<":def:def:">> = iolist_to_binary(join(re:split("def=defdefdef","\\A(abc|def)=(\\1){2,3}\\Z",[{parts,
                                                                                                                                                                                                                                   2}]))), 
?line <<":def:def:">> = iolist_to_binary(join(re:split("def=defdefdef","\\A(abc|def)=(\\1){2,3}\\Z",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","\\A(abc|def)=(\\1){2,3}\\Z",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","\\A(abc|def)=(\\1){2,3}\\Z",[{parts,
                                                                                                                                                                                                                               2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","\\A(abc|def)=(\\1){2,3}\\Z",[]))), 
?line <<"abc=defdef">> = iolist_to_binary(join(re:split("abc=defdef","\\A(abc|def)=(\\1){2,3}\\Z",[trim]))), 
?line <<"abc=defdef">> = iolist_to_binary(join(re:split("abc=defdef","\\A(abc|def)=(\\1){2,3}\\Z",[{parts,
                                                                                                                                                                                                                             2}]))), 
?line <<"abc=defdef">> = iolist_to_binary(join(re:split("abc=defdef","\\A(abc|def)=(\\1){2,3}\\Z",[]))), 
?line <<":a:b:c:d:e:f:g:h:i:j:k:cd">> = iolist_to_binary(join(re:split("abcdefghijkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[trim]))), 
?line <<":a:b:c:d:e:f:g:h:i:j:k:cd:">> = iolist_to_binary(join(re:split("abcdefghijkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[{parts,
                                                                                                                                                                                                                                                                                                     2}]))), 
?line <<":a:b:c:d:e:f:g:h:i:j:k:cd:">> = iolist_to_binary(join(re:split("abcdefghijkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[]))), 
?line <<":a:b:c:d:e:f:g:h:i:j:k:cd">> = iolist_to_binary(join(re:split("abcdefghijkkkkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[trim]))), 
?line <<":a:b:c:d:e:f:g:h:i:j:k:cd:">> = iolist_to_binary(join(re:split("abcdefghijkkkkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[{parts,
                                                                                                                                                                                                                                                                                                           2}]))), 
?line <<":a:b:c:d:e:f:g:h:i:j:k:cd:">> = iolist_to_binary(join(re:split("abcdefghijkkkkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[]))), 
?line <<":cataract:aract:ract::3">> = iolist_to_binary(join(re:split("cataract cataract23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[trim]))), 
?line <<":cataract:aract:ract::3:">> = iolist_to_binary(join(re:split("cataract cataract23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[{parts,
                                                                                                                                                                                                                                                                       2}]))), 
?line <<":cataract:aract:ract::3:">> = iolist_to_binary(join(re:split("cataract cataract23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[]))), 
?line <<":catatonic:atonic:tonic::3">> = iolist_to_binary(join(re:split("catatonic catatonic23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[trim]))), 
?line <<":catatonic:atonic:tonic::3:">> = iolist_to_binary(join(re:split("catatonic catatonic23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[{parts,
                                                                                                                                                                                                                                                                           2}]))), 
?line <<":catatonic:atonic:tonic::3:">> = iolist_to_binary(join(re:split("catatonic catatonic23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[]))), 
?line <<":caterpillar:erpillar:::3">> = iolist_to_binary(join(re:split("caterpillar caterpillar23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[trim]))), 
?line <<":caterpillar:erpillar:::3:">> = iolist_to_binary(join(re:split("caterpillar caterpillar23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[{parts,
                                                                                                                                                                                                                                                                                   2}]))), 
?line <<":caterpillar:erpillar:::3:">> = iolist_to_binary(join(re:split("caterpillar caterpillar23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[]))), 
?line <<":abcd::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]",[trim]))), 
?line <<":abcd::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]",[{parts,
                                                                                                                                                                                                                                                                                                                                                                                                                                    2}]))), 
?line <<":abcd::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]",[]))), 
?line <<":Sep ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[trim]))), 
?line <<":Sep ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[{parts,
                                                                                                                                                                                                                                                                                                                                                              2}]))), 
?line <<":Sep ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[]))), 
?line <<":Sep  ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep  1 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[trim]))), 
?line <<":Sep  ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep  1 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[{parts,
                                                                                                                                                                                                                                                                                                                                                              2}]))), 
?line <<":Sep  ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep  1 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[{parts,
                                                                                                                                                                                                                                                                                                              2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[]))), 
?line <<"From abcd  Sep 01 12:33:02 1997">> = iolist_to_binary(join(re:split("From abcd  Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[trim]))), 
?line <<"From abcd  Sep 01 12:33:02 1997">> = iolist_to_binary(join(re:split("From abcd  Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[{parts,
                                                                                                                                                                                                                                                                                                                                                      2}]))), 
?line <<"From abcd  Sep 01 12:33:02 1997">> = iolist_to_binary(join(re:split("From abcd  Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall,trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall,{parts,2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall]))), 
?line <<"">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall,
                                                                                                                                                                      trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall,
                                                                                                                                                                        {parts,
                                                                                                                                                                         2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall]))), 
?line <<"the quick :	 fox">> = iolist_to_binary(join(re:split("the quick brown	 fox","\\w+(?=\\t)",[trim]))), 
?line <<"the quick :	 fox">> = iolist_to_binary(join(re:split("the quick brown	 fox","\\w+(?=\\t)",[{parts,
                                                                                                                                                                                                                             2}]))), 
?line <<"the quick :	 fox">> = iolist_to_binary(join(re:split("the quick brown	 fox","\\w+(?=\\t)",[]))), 
?line <<"foobar is :lish see?">> = iolist_to_binary(join(re:split("foobar is foolish see?","foo(?!bar)(.*)",[trim]))), 
?line <<"foobar is :lish see?:">> = iolist_to_binary(join(re:split("foobar is foolish see?","foo(?!bar)(.*)",[{parts,
                                                                                                                                                                                                                          2}]))), 
?line <<"foobar is :lish see?:">> = iolist_to_binary(join(re:split("foobar is foolish see?","foo(?!bar)(.*)",[]))), 
?line <<"foobar c: etc">> = iolist_to_binary(join(re:split("foobar crowbar etc","(?:(?!foo)...|^.{0,2})bar(.*)",[trim]))), 
?line <<"foobar c: etc:">> = iolist_to_binary(join(re:split("foobar crowbar etc","(?:(?!foo)...|^.{0,2})bar(.*)",[{parts,
                                                                                                                                                                                                                                                2}]))), 
?line <<"foobar c: etc:">> = iolist_to_binary(join(re:split("foobar crowbar etc","(?:(?!foo)...|^.{0,2})bar(.*)",[]))), 
?line <<":rel">> = iolist_to_binary(join(re:split("barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[trim]))), 
?line <<":rel:">> = iolist_to_binary(join(re:split("barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[{parts,
                                                                                                                                                                                                                        2}]))), 
?line <<":rel:">> = iolist_to_binary(join(re:split("barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[]))), 
?line <<":rel">> = iolist_to_binary(join(re:split("2barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[trim]))), 
?line <<":rel:">> = iolist_to_binary(join(re:split("2barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[{parts,
                                                                                                                                                                                                                          2}]))), 
?line <<":rel:">> = iolist_to_binary(join(re:split("2barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[]))), 
?line <<":rel">> = iolist_to_binary(join(re:split("A barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[trim]))), 
?line <<":rel:">> = iolist_to_binary(join(re:split("A barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[{parts,
                                                                                                                                                                                                                            2}]))), 
?line <<":rel:">> = iolist_to_binary(join(re:split("A barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[]))), 
?line <<":abc:456">> = iolist_to_binary(join(re:split("abc456","^(\\D*)(?=\\d)(?!123)",[trim]))), 
?line <<":abc:456">> = iolist_to_binary(join(re:split("abc456","^(\\D*)(?=\\d)(?!123)",[{parts,
                                                                                                                                                                                                          2}]))), 
?line <<":abc:456">> = iolist_to_binary(join(re:split("abc456","^(\\D*)(?=\\d)(?!123)",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\D*)(?=\\d)(?!123)",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\D*)(?=\\d)(?!123)",[{parts,
                                                                                                                                                                                                                    2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\D*)(?=\\d)(?!123)",[]))), 
?line <<"abc123">> = iolist_to_binary(join(re:split("abc123","^(\\D*)(?=\\d)(?!123)",[trim]))), 
?line <<"abc123">> = iolist_to_binary(join(re:split("abc123","^(\\D*)(?=\\d)(?!123)",[{parts,
                                                                                                                                                                                                          2}]))), 
?line <<"abc123">> = iolist_to_binary(join(re:split("abc123","^(\\D*)(?=\\d)(?!123)",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("1234","^1234(?# test newlines
  inside)",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234","^1234(?# test newlines
  inside)",[{parts,2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234","^1234(?# test newlines
  inside)",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("1234","^1234 #comment in extended re
  ",[extended,trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234","^1234 #comment in extended re
  ",[extended,{parts,2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("1234","^1234 #comment in extended re
  ",[extended]))), 
?line <<"">> = iolist_to_binary(join(re:split("abcd","#rhubarb
  abcd",[extended,trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcd","#rhubarb
  abcd",[extended,{parts,2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcd","#rhubarb
  abcd",[extended]))), 
?line <<"">> = iolist_to_binary(join(re:split("abcd","^abcd#rhubarb",[extended,
                                                                                                                                                                                  trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcd","^abcd#rhubarb",[extended,
                                                                                                                                                                                    {parts,
                                                                                                                                                                                     2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abcd","^abcd#rhubarb",[extended]))), 
?line <<":a:b">> = iolist_to_binary(join(re:split("aaab","^(a)\\1{2,3}(.)",[trim]))), 
?line <<":a:b:">> = iolist_to_binary(join(re:split("aaab","^(a)\\1{2,3}(.)",[{parts,
                                                                                                                                                                                         2}]))), 
?line <<":a:b:">> = iolist_to_binary(join(re:split("aaab","^(a)\\1{2,3}(.)",[]))), 
?line <<":a:b">> = iolist_to_binary(join(re:split("aaaab","^(a)\\1{2,3}(.)",[trim]))), 
?line <<":a:b:">> = iolist_to_binary(join(re:split("aaaab","^(a)\\1{2,3}(.)",[{parts,
                                                                                                                                                                                           2}]))), 
?line <<":a:b:">> = iolist_to_binary(join(re:split("aaaab","^(a)\\1{2,3}(.)",[]))), 
?line <<":a:a:b">> = iolist_to_binary(join(re:split("aaaaab","^(a)\\1{2,3}(.)",[trim]))), 
?line <<":a:a:b">> = iolist_to_binary(join(re:split("aaaaab","^(a)\\1{2,3}(.)",[{parts,
                                                                                                                                                                                             2}]))), 
?line <<":a:a:b">> = iolist_to_binary(join(re:split("aaaaab","^(a)\\1{2,3}(.)",[]))), 
?line <<":a:a:ab">> = iolist_to_binary(join(re:split("aaaaaab","^(a)\\1{2,3}(.)",[trim]))), 
?line <<":a:a:ab">> = iolist_to_binary(join(re:split("aaaaaab","^(a)\\1{2,3}(.)",[{parts,
                                                                                                                                                                                               2}]))), 
?line <<":a:a:ab">> = iolist_to_binary(join(re:split("aaaaaab","^(a)\\1{2,3}(.)",[]))), 
?line <<"the ">> = iolist_to_binary(join(re:split("the abc","(?!^)abc",[trim]))), 
?line <<"the :">> = iolist_to_binary(join(re:split("the abc","(?!^)abc",[{parts,
                                                                                                                                                                                2}]))), 
?line <<"the :">> = iolist_to_binary(join(re:split("the abc","(?!^)abc",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?!^)abc",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?!^)abc",[{parts,
                                                                                                                                                                                        2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?!^)abc",[]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","(?!^)abc",[trim]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","(?!^)abc",[{parts,
                                                                                                                                                                        2}]))), 
?line <<"abc">> = iolist_to_binary(join(re:split("abc","(?!^)abc",[]))), 
?line <<"">> = iolist_to_binary(join(re:split("abc","(?=^)abc",[trim]))), 
?line <<":">> = iolist_to_binary(join(re:split("abc","(?=^)abc",[{parts,
                                                                                                                                                                        2}]))), 
?line <<":">> = iolist_to_binary(join(re:split("abc","(?=^)abc",[]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?=^)abc",[trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?=^)abc",[{parts,
                                                                                                                                                                                        2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?=^)abc",[]))), 
?line <<"the abc">> = iolist_to_binary(join(re:split("the abc","(?=^)abc",[trim]))), 
?line <<"the abc">> = iolist_to_binary(join(re:split("the abc","(?=^)abc",[{parts,
                                                                                                                                                                                2}]))), 
?line <<"the abc">> = iolist_to_binary(join(re:split("the abc","(?=^)abc",[]))), 
?line <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*|b)",[trim]))), 
?line <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*|b)",[{parts,
                                                                                                                                                                                                  2}]))), 
?line <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*|b)",[]))), 
?line <<":abbbbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*|b)",[trim]))), 
?line <<":abbbbb:">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*|b)",[{parts,
                                                                                                                                                                                                    2}]))), 
?line <<":abbbbb:">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*|b)",[]))), 
?line <<":a:bbbbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*?|b)",[trim]))), 
?line <<":a:bbbbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*?|b)",[{parts,
                                                                                                                                                                                                      2}]))), 
?line <<":a:bbbbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*?|b)",[]))), 
?line <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*?|b)",[trim]))), 
?line <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*?|b)",[{parts,
                                                                                                                                                                                                    2}]))), 
?line <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*?|b)",[]))), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"A missing angle <user.where">> = iolist_to_binary(join(re:split("A missing angle <user.where","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"A missing angle <user.where">> = iolist_to_binary(join(re:split("A missing angle <user.where","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"A missing angle <user.where">> = iolist_to_binary(join(re:split("A missing angle <user.where","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"The quick brown fox">> = iolist_to_binary(join(re:split("The quick brown fox","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
?line <<"The quick brown fox">> = iolist_to_binary(join(re:split("The quick brown fox","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
?line <<"The quick brown fox">> = iolist_to_binary(join(re:split("The quick brown fox","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
?line <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
?line <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
?line <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
?line <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
?line <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
?line <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
?line <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
?line <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
?line <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
?line <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
?line <<"A missing angle <user.where">> = iolist_to_binary(join(re:split("A missing angle <user.where","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                 