/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k1(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k1_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x80, 0xdb, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0xc0, 0xa6, 0xdc, 0xb7, 
		0xff, 0xff, 0x0f, 0x00, 0x51, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x8d, 0xb7, 0xf3, 0xb7, 0xc3, 0xd1, 0xf2, 0xb7, 
		0x38, 0x18, 0xf4, 0xb7, 0xc4, 0x1f, 0xf4, 0xb7, 
		0xa0, 0xdc, 0x83, 0xbf, 0x08, 0x00, 0x00, 0x00, 
		0x4b, 0xa5, 0xf3, 0xb7, 0x34, 0x80, 0x04, 0x08, 
		0x07, 0x00, 0x00, 0x00, 0x28, 0xd9, 0x83, 0xbf, 
		0x03, 0x00, 0x00, 0x00, 0xae, 0xd9, 0x83, 0xbf, 
		0x00, 0xe4, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x34, 0x80, 0x04, 0x08, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k1_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x2c, 0xf3, 0xdc, 0xb7, 
		0x08, 0xad, 0xf2, 0xb7, 0xf8, 0xac, 0xf2, 0xb7, 
		0x46, 0x83, 0x04, 0x08, 0x50, 0xd5, 0x83, 0xbf, 
		0x60, 0x80, 0xf3, 0xb7, 0x46, 0x83, 0x04, 0x08, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xac, 0x53, 0xdd, 0xb7, 
		0xa4, 0xd5, 0x83, 0xbf, 0x00, 0x00, 0x00, 0x00, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x08, 0x06, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0x07, 0x00, 0x00, 0x00, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k2(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k2_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x80, 0xdb, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0x0f, 0x00, 0x51, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x8d, 0xb7, 0xf3, 0xb7, 0xc3, 0xd1, 0xf2, 0xb7, 
		0x38, 0x18, 0xf4, 0xb7, 0xc4, 0x1f, 0xf4, 0xb7, 
		0xa0, 0xdc, 0x83, 0xbf, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x28, 0xd9, 0x83, 0xbf, 
		0x03, 0x00, 0x00, 0x00, 0xae, 0xd9, 0x83, 0xbf, 
		0x00, 0xe4, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x34, 0x80, 0x04, 0x08, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k2_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0xf8, 0xac, 0xf2, 0xb7, 
		0x46, 0x83, 0x04, 0x08, 0x50, 0xd5, 0x83, 0xbf, 
		0x60, 0x80, 0xf3, 0xb7, 0x46, 0x83, 0x04, 0x08, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0xac, 0x53, 0xdd, 0xb7, 
		0xa4, 0xd5, 0x83, 0xbf, 0x0c, 0x00, 0x00, 0x00, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0xf8, 0xac, 0xf2, 0xb7, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k3(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k3_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x80, 0xdb, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xc3, 0xd1, 0xf2, 0xb7, 
		0x38, 0x18, 0xf4, 0xb7, 0xc4, 0x1f, 0xf4, 0xb7, 
		0xa0, 0xdc, 0x83, 0xbf, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x28, 0xd9, 0x83, 0xbf, 
		0x03, 0x00, 0x00, 0x00, 0xae, 0xd9, 0x83, 0xbf, 
		0x00, 0xe4, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x34, 0x80, 0x04, 0x08, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x27, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k3_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x46, 0x83, 0x04, 0x08, 0x50, 0xd5, 0x83, 0xbf, 
		0x60, 0x80, 0xf3, 0xb7, 0x46, 0x83, 0x04, 0x08, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0xf8, 0xac, 0xf2, 0xb7, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 53
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k4(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k4_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x80, 0xdb, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x38, 0x18, 0xf4, 0xb7, 0xc4, 0x1f, 0xf4, 0xb7, 
		0xa0, 0xdc, 0x83, 0xbf, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0xae, 0xd9, 0x83, 0xbf, 
		0x00, 0xe4, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x34, 0x80, 0x04, 0x08, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k4_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x50, 0xd5, 0x83, 0xbf, 
		0x60, 0x80, 0xf3, 0xb7, 0x46, 0x83, 0x04, 0x08, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 24
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k5(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k5_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x80, 0xdb, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xc4, 0x1f, 0xf4, 0xb7, 
		0xa0, 0xdc, 0x83, 0xbf, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xae, 0xd9, 0x83, 0xbf, 
		0x00, 0xe4, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x34, 0x80, 0x04, 0x08, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k5_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x60, 0x80, 0xf3, 0xb7, 0x46, 0x83, 0x04, 0x08, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 14
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k6(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k6_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xdc, 0x83, 0xbf, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0xe4, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x34, 0x80, 0x04, 0x08, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k6_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x46, 0x83, 0x04, 0x08, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 8
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 9
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k7(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k7_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x34, 0x80, 0x04, 0x08, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x37, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k7_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k8(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k8_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x38, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k8_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k9(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k9_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x39, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k9_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k10(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k10_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x27, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x30, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k10_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 53
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k11(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k11_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x31, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k11_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 24
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k12(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k12_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x32, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k12_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 14
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k13(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k13_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x33, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k13_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 8
   Output channel 0 increment = 3
   Output channel 1 bits = 8
   Output channel 1 increment = 3
   Output channel 2 bits = 8
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 9
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k14(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k14_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0xd0, 0x85, 0x04, 0x08, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x34, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k14_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k15(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k15_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x35, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k15_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k16(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k16_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x36, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k16_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k17(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k17_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x27, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x37, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k17_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 53
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k18(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k18_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x38, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k18_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 24
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k19(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k19_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x31, 0x39, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k19_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 14
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k20(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k20_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x30, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k20_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 8
   Output channel 0 increment = 4
   Output channel 1 bits = 8
   Output channel 1 increment = 4
   Output channel 2 bits = 8
   Output channel 2 increment = 4
   Output channel 3 bits = 8
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 9
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k21(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k21_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x4c, 0x69, 0x6e, 0x75, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x79, 0x72, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x31, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k21_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k22(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k22_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x32, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k22_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k23(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k23_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x33, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k23_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 27
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k24(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k24_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x1b, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x34, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k24_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 40
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k25(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k25_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x35, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k25_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 19
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k26(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k26_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x36, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k26_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 11
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k27(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k27_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x37, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k27_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 8
   Output channel 0 increment = 5
   Output channel 1 bits = 8
   Output channel 1 increment = 5
   Output channel 2 bits = 8
   Output channel 2 increment = 5
   Output channel 3 bits = 8
   Output channel 3 increment = 5
   Output channel 4 bits = 8
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 8
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k28(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k28_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x74, 0x6c, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x38, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k28_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k29(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 6) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k29_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x36, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x32, 0x39, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k29_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k30(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 6) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k30_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x36, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x30, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k30_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 27
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k31(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 6) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k31_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x1b, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x36, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x31, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k31_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 40
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k32(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 6) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k32_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x36, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x32, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k32_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 19
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k33(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 6) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k33_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x36, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x33, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k33_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 11
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k34(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 6) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k34_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x36, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x34, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k34_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 6
   Output channel 0 bits = 8
   Output channel 0 increment = 6
   Output channel 1 bits = 8
   Output channel 1 increment = 6
   Output channel 2 bits = 8
   Output channel 2 increment = 6
   Output channel 3 bits = 8
   Output channel 3 increment = 6
   Output channel 4 bits = 8
   Output channel 4 increment = 6
   Output channel 5 bits = 8
   Output channel 5 increment = 6
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 8
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k35(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 6) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k35_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x36, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x35, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k35_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 12 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k36(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 7) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k36_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x37, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x36, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k36_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 12 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k37(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 7) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k37_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x37, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x37, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k37_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 31
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 12 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k38(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 7) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k38_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x1f, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x37, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x38, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k38_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 45
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 12 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k39(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 7) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k39_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x37, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x33, 0x39, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k39_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 20
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 12 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k40(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 7) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k40_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x37, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x30, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k40_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 12
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 12 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k41(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 7) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k41_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x37, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x31, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k41_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 7
   Output channel 0 bits = 8
   Output channel 0 increment = 7
   Output channel 1 bits = 8
   Output channel 1 increment = 7
   Output channel 2 bits = 8
   Output channel 2 increment = 7
   Output channel 3 bits = 8
   Output channel 3 increment = 7
   Output channel 4 bits = 8
   Output channel 4 increment = 7
   Output channel 5 bits = 8
   Output channel 5 increment = 7
   Output channel 6 bits = 8
   Output channel 6 increment = 7
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 8
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 12 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k42(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 7) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k42_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x37, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x32, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k42_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0xdc, 0x60, 0xef, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k43(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 8) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova3 >> 24) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k43_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x38, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x33, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k43_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k44(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 8) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova3 >> 24) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k44_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x38, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x34, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k44_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 31
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k45(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 8) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova3 >> 24) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k45_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x1f, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x38, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x35, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k45_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 45
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k46(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 8) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova3 >> 24) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k46_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x38, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x36, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k46_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 20
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k47(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 8) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova3 >> 24) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k47_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x38, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x37, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k47_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 12
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k48(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 8) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova3 >> 24) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k48_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x38, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x38, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k48_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 8
   Output channel 0 bits = 8
   Output channel 0 increment = 8
   Output channel 1 bits = 8
   Output channel 1 increment = 8
   Output channel 2 bits = 8
   Output channel 2 increment = 8
   Output channel 3 bits = 8
   Output channel 3 increment = 8
   Output channel 4 bits = 8
   Output channel 4 increment = 8
   Output channel 5 bits = 8
   Output channel 5 increment = 8
   Output channel 6 bits = 8
   Output channel 6 increment = 8
   Output channel 7 bits = 8
   Output channel 7 increment = 8
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 8
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 16)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned char *)((p) + (off) * 1))

static void
imdi_k49(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned char *op0 = (unsigned char *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer ot5 = (pointer)p->out_tables[5];
	pointer ot6 = (pointer)p->out_tables[6];
	pointer ot7 = (pointer)p->out_tables[7];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 8) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value accumulator */
		unsigned int ova3;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3  = IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_FE(imp, vof, 2) * vwe;	/* Accumulate weighted output values */
				ova3 += IM_FE(imp, vof, 3) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
			oti = ((ova2 >> 24) & 0xff);	/* Extract integer part of result */
			op0[5] = OT_E(ot5, oti);	/* Write result */
			oti = ((ova3 >> 8) & 0xff);	/* Extract integer part of result */
			op0[6] = OT_E(ot6, oti);	/* Write result */
			oti = ((ova3 >> 24) & 0xff);	/* Extract integer part of result */
			op0[7] = OT_E(ot7, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k49_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x38, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x38, 0x5f, 0x66, 0x00, 
		0x8e, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x34, 0x39, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k49_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 16
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k50(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k50_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x30, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k50_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 16
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k51(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k51_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x31, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k51_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 16
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k52(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k52_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x27, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x32, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k52_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 16
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 53
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k53(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k53_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x33, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k53_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 16
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 24
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k54(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k54_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x34, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k54_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 16
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 14
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k55(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k55_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x35, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k55_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 1
   Output channel 0 bits = 16
   Output channel 0 increment = 1
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 9
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 4)

/* Interpolation table - get vertex values */
#define IM_PE(p, v) *((unsigned int *)((p) + 0 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k56(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 1) {
		unsigned int ova0;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_PE
#undef OT_E

static void
imdi_k56_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x31, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x36, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k56_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0xa1, 0xd4, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x31, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xa0, 0xd6, 0x83, 0xbf, 0x8b, 0x22, 0xe2, 0xb7, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 16
   Output channel 0 increment = 3
   Output channel 1 bits = 16
   Output channel 1 increment = 3
   Output channel 2 bits = 16
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k57(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k57_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x37, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k57_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 16
   Output channel 0 increment = 3
   Output channel 1 bits = 16
   Output channel 1 increment = 3
   Output channel 2 bits = 16
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k58(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k58_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x38, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k58_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 16
   Output channel 0 increment = 3
   Output channel 1 bits = 16
   Output channel 1 increment = 3
   Output channel 2 bits = 16
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k59(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k59_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x27, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x35, 0x39, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k59_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 16
   Output channel 0 increment = 3
   Output channel 1 bits = 16
   Output channel 1 increment = 3
   Output channel 2 bits = 16
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 53
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k60(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k60_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x30, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k60_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 16
   Output channel 0 increment = 3
   Output channel 1 bits = 16
   Output channel 1 increment = 3
   Output channel 2 bits = 16
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 24
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k61(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k61_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x31, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k61_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 16
   Output channel 0 increment = 3
   Output channel 1 bits = 16
   Output channel 1 increment = 3
   Output channel 2 bits = 16
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 14
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k62(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k62_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x32, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k62_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 3
   Output channel 0 bits = 16
   Output channel 0 increment = 3
   Output channel 1 bits = 16
   Output channel 1 increment = 3
   Output channel 2 bits = 16
   Output channel 2 increment = 3
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 9
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 4 + (v) * 8))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k63(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 3) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k63_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x33, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x33, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k63_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0xff, 0xff, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xf4, 0xd5, 0x83, 0xbf, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x14, 0xda, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 16
   Output channel 0 increment = 4
   Output channel 1 bits = 16
   Output channel 1 increment = 4
   Output channel 2 bits = 16
   Output channel 2 increment = 4
   Output channel 3 bits = 16
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k64(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k64_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x34, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k64_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 16
   Output channel 0 increment = 4
   Output channel 1 bits = 16
   Output channel 1 increment = 4
   Output channel 2 bits = 16
   Output channel 2 increment = 4
   Output channel 3 bits = 16
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k65(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k65_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x35, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k65_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 16
   Output channel 0 increment = 4
   Output channel 1 bits = 16
   Output channel 1 increment = 4
   Output channel 2 bits = 16
   Output channel 2 increment = 4
   Output channel 3 bits = 16
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 39
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k66(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k66_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x27, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x36, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k66_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 16
   Output channel 0 increment = 4
   Output channel 1 bits = 16
   Output channel 1 increment = 4
   Output channel 2 bits = 16
   Output channel 2 increment = 4
   Output channel 3 bits = 16
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 53
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k67(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k67_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x37, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k67_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 16
   Output channel 0 increment = 4
   Output channel 1 bits = 16
   Output channel 1 increment = 4
   Output channel 2 bits = 16
   Output channel 2 increment = 4
   Output channel 3 bits = 16
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 24
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k68(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo4, wo5);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo5;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k68_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x36, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x38, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k68_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 7
   Input channel 0 bits = 8
   Input channel 0 increment = 7
   Input channel 1 bits = 8
   Input channel 1 increment = 7
   Input channel 2 bits = 8
   Input channel 2 increment = 7
   Input channel 3 bits = 8
   Input channel 3 increment = 7
   Input channel 4 bits = 8
   Input channel 4 increment = 7
   Input channel 5 bits = 8
   Input channel 5 increment = 7
   Input channel 6 bits = 8
   Input channel 6 increment = 7
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 16
   Output channel 0 increment = 4
   Output channel 1 bits = 16
   Output channel 1 increment = 4
   Output channel 2 bits = 16
   Output channel 2 increment = 4
   Output channel 3 bits = 16
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 14
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k69(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 7 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 7, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo5, wo6);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo6;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k69_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x37, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x36, 0x39, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k69_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 8
   Input channel 0 bits = 8
   Input channel 0 increment = 8
   Input channel 1 bits = 8
   Input channel 1 increment = 8
   Input channel 2 bits = 8
   Input channel 2 increment = 8
   Input channel 3 bits = 8
   Input channel 3 increment = 8
   Input channel 4 bits = 8
   Input channel 4 increment = 8
   Input channel 5 bits = 8
   Input channel 5 increment = 8
   Input channel 6 bits = 8
   Input channel 6 increment = 8
   Input channel 7 bits = 8
   Input channel 7 increment = 8
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 4
   Output channel 0 bits = 16
   Output channel 0 increment = 4
   Output channel 1 bits = 16
   Output channel 1 increment = 4
   Output channel 2 bits = 16
   Output channel 2 increment = 4
   Output channel 3 bits = 16
   Output channel 3 increment = 4
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 9
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 8)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 8 + (c) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k70(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 8 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer it6 = (pointer)p->in_tables[6];
	pointer it7 = (pointer)p->in_tables[7];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 8, op0 += 4) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			unsigned int wo6;	/* Weighting value and vertex offset variable */
			unsigned int wo7;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				ti_i += IT_IX(it6, ip0[6]);
				wo6   = IT_WO(it6, ip0[6]);
				ti_i += IT_IX(it7, ip0[7]);
				wo7   = IT_WO(it7, ip0[7]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo0, wo6);
				CEX(wo0, wo7);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo1, wo6);
				CEX(wo1, wo7);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
				CEX(wo2, wo6);
				CEX(wo2, wo7);
				CEX(wo3, wo4);
				CEX(wo3, wo5);
				CEX(wo3, wo6);
				CEX(wo3, wo7);
				CEX(wo4, wo5);
				CEX(wo4, wo6);
				CEX(wo4, wo7);
				CEX(wo5, wo6);
				CEX(wo5, wo7);
				CEX(wo6, wo7);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo5 & 0x7fffff);	/* Extract offset value */
				wo5 = (wo5 >> 23);		/* Extract weighting value */
				vwe = wo4 - wo5;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo6 & 0x7fffff);	/* Extract offset value */
				wo6 = (wo6 >> 23);		/* Extract weighting value */
				vwe = wo5 - wo6;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo7 & 0x7fffff);	/* Extract offset value */
				wo7 = (wo7 >> 23);		/* Extract weighting value */
				vwe = wo6 - wo7;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo7;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef OT_E

static void
imdi_k70_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x38, 0x5f, 0x34, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x37, 0x30, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k70_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0x34, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x52, 0xca, 0x04, 0x08, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x14, 0xda, 0x83, 0xbf, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 1
   Input channel 0 bits = 8
   Input channel 0 increment = 1
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 16
   Output channel 0 increment = 5
   Output channel 1 bits = 16
   Output channel 1 increment = 5
   Output channel 2 bits = 16
   Output channel 2 increment = 5
   Output channel 3 bits = 16
   Output channel 3 increment = 5
   Output channel 4 bits = 16
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 0
   Interpolation table index bits = 8
   Simplex table max resolution = 1
   Interpolation table max resolution = 255
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned char *)((p) + 0 + (off) * 1))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 4)

/* Simplex table - get weighting/offset value */
#define SX_WO(p, v) *((unsigned short *)((p) + (v) * 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k71(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 1 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 1, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				
				imp = im_base + IM_O(ti >> 0);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0x0);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vowr;	/* Vertex offset/weight value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vowr = SX_WO(swp, 0);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vowr = SX_WO(swp, 1);	/* Read vertex offset+weighting values */
				vof = (vowr & 0x7f);	/* Extract offset value */
				vwe = (vowr >> 7);	/* Extract weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k71_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x31, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x37, 0x31, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k71_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 3
   Input channel 0 bits = 8
   Input channel 0 increment = 3
   Input channel 1 bits = 8
   Input channel 1 increment = 3
   Input channel 2 bits = 8
   Input channel 2 increment = 3
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 16
   Output channel 0 increment = 5
   Output channel 1 bits = 16
   Output channel 1 increment = 5
   Output channel 2 bits = 16
   Output channel 2 increment = 5
   Output channel 3 bits = 16
   Output channel 3 increment = 5
   Output channel 4 bits = 16
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 12
   Interpolation table index bits = 20
   Simplex table max resolution = 16
   Interpolation table max resolution = 101
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table inter & simplex indexes */
#define IT_IT(p, off) *((unsigned int *)((p) + 0 + (off) * 4))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 16)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k72(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 3 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 3, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti;	/* Simplex+Interpolation index variable */
				
				ti  = IT_IT(it0, ip0[0]);
				ti += IT_IT(it1, ip0[1]);
				ti += IT_IT(it2, ip0[2]);
				
				imp = im_base + IM_O(ti >> 12);		/* Extract interp. index and comp. entry */
				swp = sw_base + SW_O(ti & 0xfff);	/* Extract simplex index and comp. entry */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IT
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k72_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x65, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x33, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x37, 0x32, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k72_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 4
   Input channel 0 bits = 8
   Input channel 0 increment = 4
   Input channel 1 bits = 8
   Input channel 1 increment = 4
   Input channel 2 bits = 8
   Input channel 2 increment = 4
   Input channel 3 bits = 8
   Input channel 3 increment = 4
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 16
   Output channel 0 increment = 5
   Output channel 1 bits = 16
   Output channel 1 increment = 5
   Output channel 2 bits = 16
   Output channel 2 increment = 5
   Output channel 3 bits = 16
   Output channel 3 increment = 5
   Output channel 4 bits = 16
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Simplex table index bits       = 32
   Interpolation table index bits = 32
   Simplex table max resolution = 255
   Interpolation table max resolution = 27
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Input table simplex index enty */
#define IT_SX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Simplex weighting table access */
#define SW_O(off) ((off) * 20)

/* Simplex table - get weighting value */
#define SX_WE(p, v) *((unsigned short *)((p) + (v) * 4 + 0))

/* Simplex table - get offset value */
#define SX_VO(p, v) *((unsigned short *)((p) + (v) * 4 + 2))

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k73(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 4 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer sw_base = (pointer)p->sw_table;
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 4, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer swp;
			pointer imp;
			{
				unsigned int ti_s;	/* Simplex index variable */
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				ti_s  = IT_SX(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				ti_s += IT_SX(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				ti_s += IT_SX(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				ti_s += IT_SX(it3, ip0[3]);
				
				swp = sw_base + SW_O(ti_s);		/* Compute simplex table entry pointer */
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
			}
			{
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = SX_VO(swp, 0);	/* Read vertex offset value */
				vwe = SX_WE(swp, 0);	/* Read vertex weighting value */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 1);	/* Read vertex offset value */
				vwe = SX_WE(swp, 1);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 2);	/* Read vertex offset value */
				vwe = SX_WE(swp, 2);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 3);	/* Read vertex offset value */
				vwe = SX_WE(swp, 3);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof = SX_VO(swp, 4);	/* Read vertex offset value */
				vwe = SX_WE(swp, 4);	/* Read vertex weighting value */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_IX
#undef IT_SX
#undef SW_O
#undef SX_WE
#undef SX_VO
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k73_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x1b, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x34, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x37, 0x33, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k73_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 5
   Input channel 0 bits = 8
   Input channel 0 increment = 5
   Input channel 1 bits = 8
   Input channel 1 increment = 5
   Input channel 2 bits = 8
   Input channel 2 increment = 5
   Input channel 3 bits = 8
   Input channel 3 increment = 5
   Input channel 4 bits = 8
   Input channel 4 increment = 5
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 16
   Output channel 0 increment = 5
   Output channel 1 bits = 16
   Output channel 1 increment = 5
   Output channel 2 bits = 16
   Output channel 2 increment = 5
   Output channel 3 bits = 16
   Output channel 3 increment = 5
   Output channel 4 bits = 16
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 40
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k74(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 5 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 5, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo3, wo4);
			}
			{
				unsigned int nvof;	/* Next vertex offset value */
				unsigned int vof;	/* Vertex offset value */
				unsigned int vwe;	/* Vertex weighting */
				
				vof = 0;				/* First vertex offset is 0 */
				nvof = (wo0 & 0x7fffff);	/* Extract offset value */
				wo0 = (wo0 >> 23);		/* Extract weighting value */
				vwe = 256 - wo0;		/* Baricentric weighting */
				ova0  = IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1  = IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2  = IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo1 & 0x7fffff);	/* Extract offset value */
				wo1 = (wo1 >> 23);		/* Extract weighting value */
				vwe = wo0 - wo1;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo2 & 0x7fffff);	/* Extract offset value */
				wo2 = (wo2 >> 23);		/* Extract weighting value */
				vwe = wo1 - wo2;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo3 & 0x7fffff);	/* Extract offset value */
				wo3 = (wo3 >> 23);		/* Extract weighting value */
				vwe = wo2 - wo3;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				nvof = (wo4 & 0x7fffff);	/* Extract offset value */
				wo4 = (wo4 >> 23);		/* Extract weighting value */
				vwe = wo3 - wo4;		/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
				vof += nvof;			/* Move to next vertex */
				vwe = wo4;				/* Baricentric weighting */
				ova0 += IM_FE(imp, vof, 0) * vwe;	/* Accumulate weighted output values */
				ova1 += IM_FE(imp, vof, 1) * vwe;	/* Accumulate weighted output values */
				ova2 += IM_PE(imp, vof) * vwe;	/* Accumulate last weighted output values */
			}
		}
		{
			unsigned int oti;	/* Vertex offset value */
			oti = ((ova0 >> 8) & 0xff);	/* Extract integer part of result */
			op0[0] = OT_E(ot0, oti);	/* Write result */
			oti = ((ova0 >> 24) & 0xff);	/* Extract integer part of result */
			op0[1] = OT_E(ot1, oti);	/* Write result */
			oti = ((ova1 >> 8) & 0xff);	/* Extract integer part of result */
			op0[2] = OT_E(ot2, oti);	/* Write result */
			oti = ((ova1 >> 24) & 0xff);	/* Extract integer part of result */
			op0[3] = OT_E(ot3, oti);	/* Write result */
			oti = ((ova2 >> 8) & 0xff);	/* Extract integer part of result */
			op0[4] = OT_E(ot4, oti);	/* Write result */
		}
	}
}
#undef IT_WO
#undef IT_IX
#undef CEX
#undef IM_O
#undef IM_FE
#undef IM_PE
#undef OT_E

static void
imdi_k74_gen(
genspec *g			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x05, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 
		0x74, 0x20, 0x32, 0x30, 0x30, 0x34, 0x20, 0x47, 
		0x72, 0x61, 0x65, 0x6d, 0x65, 0x20, 0x57, 0x2e, 
		0x20, 0x47, 0x69, 0x6c, 0x6c, 0x00, 0x04, 0x08, 
		0x04, 0xad, 0xf2, 0xb7, 0xc5, 0x83, 0x04, 0x08, 
		0x50, 0xad, 0xf2, 0xb7, 0x6c, 0x6c, 0xdd, 0xb7, 
		0x34, 0xda, 0x83, 0xbf, 0xf6, 0x35, 0xf3, 0xb7, 
		0x8b, 0xca, 0xdd, 0xb7, 0xbb, 0x83, 0x04, 0x08, 
		0x31, 0x20, 0x4d, 0x6f, 0x6e, 0x20, 0x46, 0x65, 
		0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x94, 0x07, 0x00, 0x00, 
		0x4e, 0xcb, 0xdd, 0xb7, 0xfc, 0x79, 0xdd, 0xb7, 
		0x2c, 0xf3, 0xdc, 0xb7, 0x35, 0x5f, 0x35, 0x5f, 
		0x69, 0x38, 0x5f, 0x69, 0x31, 0x36, 0x5f, 0x66, 
		0x00, 0xff, 0x77, 0x01, 0x9b, 0x83, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0x00, 0x00, 0x00, 0x00, 
		0xac, 0xb1, 0xf2, 0xb7, 0xf8, 0xda, 0x83, 0xbf, 
		0xc9, 0x37, 0xf3, 0xb7, 0x40, 0x82, 0x04, 0x08, 
		0xb4, 0xda, 0x83, 0xbf, 0x58, 0xb1, 0xf2, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x80, 0xb0, 0xdc, 0xb7, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x28, 0x6e, 0x6f, 0xb4, 0xda, 0x83, 0xbf, 
		0x69, 0x6d, 0x64, 0x69, 0x5f, 0x6b, 0x37, 0x34, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0x77, 0x01, 
		0x20, 0xdb, 0x83, 0xbf, 0x00, 0xb0, 0xf2, 0xb7, 
		0x9b, 0x83, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 
		0x1b, 0xfa, 0x83, 0xbf, 0xee, 0xb1, 0xec, 0xb7, 
		0x98, 0xc8, 0x04, 0x08, 0xe8, 0xf0, 0x04, 0x08, 
		0xc8, 0xda, 0x83, 0xbf, 0xdd, 0x84, 0x04, 0x08, 
		0xdc, 0x60, 0xef, 0xb7, 0x80, 0xdb, 0x83, 0xbf, 
		0xe8, 0xda, 0x83, 0xbf, 0xb3, 0xc8, 0x04, 0x08, 
		0x38, 0x18, 0xf4, 0xb7, 0xdc, 0x60, 0xef, 0xb7, 
		0x00, 0xf0, 0x04, 0x08 
	};	/* Structure image */
	
	memcpy(g, data, sizeof(data));	/* Initialise the structure */
}

static void
imdi_k74_tab(
tabspec *t			/* structure to be initialised */
) {
	static unsigned char data[] = {
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 
		0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
		0x20, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x14, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x09, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
		0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
		0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
		0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xff, 0xff, 0xff, 0xff, 0xdc, 0x60, 0xef, 0xb7, 
		0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0xdc, 0xd6, 0x83, 0xbf, 0x14, 0xda, 0x83, 0xbf, 
		0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 
		0x21, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff, 
		0x14, 0xda, 0x83, 0xbf, 0xff, 0xff, 0xff, 0xff 
	};	/* Structure image */
	
	memcpy(t, data, sizeof(data));	/* Initialise the structure */
}






/* Integer Multi-Dimensional Interpolation */
/* Interpolation Kernel Code */
/* Generated by cgen */
/* Copyright 2000 - 2002 Graeme W. Gill */
/* This material is licenced under the GNU GENERAL PUBLIC LICENCE :- */

/* see the Licence.txt file for licencing details.*/


/*
   Interpolation kernel specs:

   Input channels per pixel = 6
   Input channel 0 bits = 8
   Input channel 0 increment = 6
   Input channel 1 bits = 8
   Input channel 1 increment = 6
   Input channel 2 bits = 8
   Input channel 2 increment = 6
   Input channel 3 bits = 8
   Input channel 3 increment = 6
   Input channel 4 bits = 8
   Input channel 4 increment = 6
   Input channel 5 bits = 8
   Input channel 5 increment = 6
   Input is channel interleaved
   Input channels are separate words
   Input value extraction is done in input table lookup

   Output channels per pixel = 5
   Output channel 0 bits = 16
   Output channel 0 increment = 5
   Output channel 1 bits = 16
   Output channel 1 increment = 5
   Output channel 2 bits = 16
   Output channel 2 increment = 5
   Output channel 3 bits = 16
   Output channel 3 increment = 5
   Output channel 4 bits = 16
   Output channel 4 increment = 5
   Output is channel interleaved

   Output channels are separate words
   Weight+voffset bits       = 32
   Interpolation table index bits = 32
   Interpolation table max resolution = 19
 */

/*
   Machine architecture specs:

   Little endian
   Reading and writing pixel values separately
   Pointer size = 32 bits

   Ordinal size  8 bits is known as 'unsigned char'
   Ordinal size 16 bits is known as 'unsigned short'
   Ordinal size 32 bits is known as 'unsigned int'
   Natural ordinal is 'unsigned int'

   Integer size  8 bits is known as 'signed char'
   Integer size 16 bits is known as 'short'
   Integer size 32 bits is known as 'int'
   Natural integer is 'int'

 */

#ifndef  IMDI_INCLUDED
#include <memory.h>
#include "imdi_imp.h"
#define  IMDI_INCLUDED
#endif  /* IMDI_INCLUDED */

#ifndef DEFINED_pointer
#define DEFINED_pointer
typedef unsigned char * pointer;
#endif

/* Input table interp. index */
#define IT_IX(p, off) *((unsigned int *)((p) + 0 + (off) * 8))

/* Input table input weighting/offset value enty */
#define IT_WO(p, off) *((unsigned int *)((p) + 4 + (off) * 8))

/* Conditional exchange for sorting */
#define CEX(A, B) if (A < B) { A ^= B; B ^= A; A ^= B; }

/* Interpolation multi-dim. table access */
#define IM_O(off) ((off) * 12)

/* Interpolation table - get vertex values */
#define IM_FE(p, v, c) *((unsigned int *)((p) + (v) * 4 + (c) * 4))
#define IM_PE(p, v) *((unsigned int *)((p) + 8 + (v) * 4))

/* Output table indexes */
#define OT_E(p, off) *((unsigned short *)((p) + (off) * 2))

static void
imdi_k75(
imdi *s,			/* imdi context */
void **outp,		/* pointer to output pointers */
void **inp,		/* pointer to input pointers */
unsigned int npix	/* Number of pixels to process */
) {
	imdi_imp *p = (imdi_imp *)(s->impl);
	unsigned char *ip0 = (unsigned char *)inp[0];
	unsigned short *op0 = (unsigned short *)outp[0];
	unsigned char *ep = ip0 + npix * 6 ;
	pointer it0 = (pointer)p->in_tables[0];
	pointer it1 = (pointer)p->in_tables[1];
	pointer it2 = (pointer)p->in_tables[2];
	pointer it3 = (pointer)p->in_tables[3];
	pointer it4 = (pointer)p->in_tables[4];
	pointer it5 = (pointer)p->in_tables[5];
	pointer ot0 = (pointer)p->out_tables[0];
	pointer ot1 = (pointer)p->out_tables[1];
	pointer ot2 = (pointer)p->out_tables[2];
	pointer ot3 = (pointer)p->out_tables[3];
	pointer ot4 = (pointer)p->out_tables[4];
	pointer im_base = (pointer)p->im_table;
	
	for(;ip0 < ep; ip0 += 6, op0 += 5) {
		unsigned int ova0;	/* Output value accumulator */
		unsigned int ova1;	/* Output value accumulator */
		unsigned int ova2;	/* Output value partial accumulator */
		{
			pointer imp;
			unsigned int wo0;	/* Weighting value and vertex offset variable */
			unsigned int wo1;	/* Weighting value and vertex offset variable */
			unsigned int wo2;	/* Weighting value and vertex offset variable */
			unsigned int wo3;	/* Weighting value and vertex offset variable */
			unsigned int wo4;	/* Weighting value and vertex offset variable */
			unsigned int wo5;	/* Weighting value and vertex offset variable */
			{
				unsigned int ti_i;	/* Interpolation index variable */
				
				ti_i  = IT_IX(it0, ip0[0]);
				wo0   = IT_WO(it0, ip0[0]);
				ti_i += IT_IX(it1, ip0[1]);
				wo1   = IT_WO(it1, ip0[1]);
				ti_i += IT_IX(it2, ip0[2]);
				wo2   = IT_WO(it2, ip0[2]);
				ti_i += IT_IX(it3, ip0[3]);
				wo3   = IT_WO(it3, ip0[3]);
				ti_i += IT_IX(it4, ip0[4]);
				wo4   = IT_WO(it4, ip0[4]);
				ti_i += IT_IX(it5, ip0[5]);
				wo5   = IT_WO(it5, ip0[5]);
				
				imp = im_base + IM_O(ti_i);		/* Compute interp. table entry pointer */
				
				/* Sort weighting values and vertex offset values */
				CEX(wo0, wo1);
				CEX(wo0, wo2);
				CEX(wo0, wo3);
				CEX(wo0, wo4);
				CEX(wo0, wo5);
				CEX(wo1, wo2);
				CEX(wo1, wo3);
				CEX(wo1, wo4);
				CEX(wo1, wo5);
				CEX(wo2, wo3);
				CEX(wo2, wo4);
				CEX(wo2, wo5);
		