package Date::Manip::TZ::amgoos00;
# Copyright (c) 2008-2009 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Tue Nov 24 11:04:25 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::amgoos00 - Support for the America/Goose_Bay time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION='6.05';

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,19,58,20],'-04:01:40',[-4,-1,-40],
          'LMT',0,[1884,1,1,4,1,39],[1883,12,31,23,59,59],
          '0001010200:00:00','0001010119:58:20','1884010104:01:39','1883123123:59:59' ],
     ],
   1884 =>
     [
        [ [1884,1,1,4,1,40],[1884,1,1,0,30,48],'-03:30:52',[-3,-30,-52],
          'NST',0,[1918,4,14,5,30,51],[1918,4,14,1,59,59],
          '1884010104:01:40','1884010100:30:48','1918041405:30:51','1918041401:59:59' ],
     ],
   1918 =>
     [
        [ [1918,4,14,5,30,52],[1918,4,14,3,0,0],'-02:30:52',[-2,-30,-52],
          'NDT',1,[1918,10,31,4,30,51],[1918,10,31,1,59,59],
          '1918041405:30:52','1918041403:00:00','1918103104:30:51','1918103101:59:59' ],
        [ [1918,10,31,4,30,52],[1918,10,31,1,0,0],'-03:30:52',[-3,-30,-52],
          'NST',0,[1935,3,30,3,30,51],[1935,3,29,23,59,59],
          '1918103104:30:52','1918103101:00:00','1935033003:30:51','1935032923:59:59' ],
     ],
   1935 =>
     [
        [ [1935,3,30,3,30,52],[1935,3,30,0,0,52],'-03:30:00',[-3,-30,0],
          'NST',0,[1936,5,11,3,29,59],[1936,5,10,23,59,59],
          '1935033003:30:52','1935033000:00:52','1936051103:29:59','1936051023:59:59' ],
     ],
   1936 =>
     [
        [ [1936,5,11,3,30,0],[1936,5,11,1,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1936,10,5,2,29,59],[1936,10,4,23,59,59],
          '1936051103:30:00','1936051101:00:00','1936100502:29:59','1936100423:59:59' ],
        [ [1936,10,5,2,30,0],[1936,10,4,23,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1937,5,10,3,29,59],[1937,5,9,23,59,59],
          '1936100502:30:00','1936100423:00:00','1937051003:29:59','1937050923:59:59' ],
     ],
   1937 =>
     [
        [ [1937,5,10,3,30,0],[1937,5,10,1,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1937,10,4,2,29,59],[1937,10,3,23,59,59],
          '1937051003:30:00','1937051001:00:00','1937100402:29:59','1937100323:59:59' ],
        [ [1937,10,4,2,30,0],[1937,10,3,23,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1938,5,9,3,29,59],[1938,5,8,23,59,59],
          '1937100402:30:00','1937100323:00:00','1938050903:29:59','1938050823:59:59' ],
     ],
   1938 =>
     [
        [ [1938,5,9,3,30,0],[1938,5,9,1,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1938,10,3,2,29,59],[1938,10,2,23,59,59],
          '1938050903:30:00','1938050901:00:00','1938100302:29:59','1938100223:59:59' ],
        [ [1938,10,3,2,30,0],[1938,10,2,23,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1939,5,15,3,29,59],[1939,5,14,23,59,59],
          '1938100302:30:00','1938100223:00:00','1939051503:29:59','1939051423:59:59' ],
     ],
   1939 =>
     [
        [ [1939,5,15,3,30,0],[1939,5,15,1,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1939,10,2,2,29,59],[1939,10,1,23,59,59],
          '1939051503:30:00','1939051501:00:00','1939100202:29:59','1939100123:59:59' ],
        [ [1939,10,2,2,30,0],[1939,10,1,23,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1940,5,13,3,29,59],[1940,5,12,23,59,59],
          '1939100202:30:00','1939100123:00:00','1940051303:29:59','1940051223:59:59' ],
     ],
   1940 =>
     [
        [ [1940,5,13,3,30,0],[1940,5,13,1,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1940,10,7,2,29,59],[1940,10,6,23,59,59],
          '1940051303:30:00','1940051301:00:00','1940100702:29:59','1940100623:59:59' ],
        [ [1940,10,7,2,30,0],[1940,10,6,23,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1941,5,12,3,29,59],[1941,5,11,23,59,59],
          '1940100702:30:00','1940100623:00:00','1941051203:29:59','1941051123:59:59' ],
     ],
   1941 =>
     [
        [ [1941,5,12,3,30,0],[1941,5,12,1,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1941,10,6,2,29,59],[1941,10,5,23,59,59],
          '1941051203:30:00','1941051201:00:00','1941100602:29:59','1941100523:59:59' ],
        [ [1941,10,6,2,30,0],[1941,10,5,23,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1942,5,11,3,29,59],[1942,5,10,23,59,59],
          '1941100602:30:00','1941100523:00:00','1942051103:29:59','1942051023:59:59' ],
     ],
   1942 =>
     [
        [ [1942,5,11,3,30,0],[1942,5,11,1,0,0],'-02:30:00',[-2,-30,0],
          'NWT',1,[1945,8,14,22,59,59],[1945,8,14,20,29,59],
          '1942051103:30:00','1942051101:00:00','1945081422:59:59','1945081420:29:59' ],
     ],
   1945 =>
     [
        [ [1945,8,14,23,0,0],[1945,8,14,20,30,0],'-02:30:00',[-2,-30,0],
          'NPT',1,[1945,9,30,4,29,59],[1945,9,30,1,59,59],
          '1945081423:00:00','1945081420:30:00','1945093004:29:59','1945093001:59:59' ],
        [ [1945,9,30,4,30,0],[1945,9,30,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1946,5,12,5,29,59],[1946,5,12,1,59,59],
          '1945093004:30:00','1945093001:00:00','1946051205:29:59','1946051201:59:59' ],
     ],
   1946 =>
     [
        [ [1946,5,12,5,30,0],[1946,5,12,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1946,10,6,4,29,59],[1946,10,6,1,59,59],
          '1946051205:30:00','1946051203:00:00','1946100604:29:59','1946100601:59:59' ],
        [ [1946,10,6,4,30,0],[1946,10,6,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1947,5,11,5,29,59],[1947,5,11,1,59,59],
          '1946100604:30:00','1946100601:00:00','1947051105:29:59','1947051101:59:59' ],
     ],
   1947 =>
     [
        [ [1947,5,11,5,30,0],[1947,5,11,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1947,10,5,4,29,59],[1947,10,5,1,59,59],
          '1947051105:30:00','1947051103:00:00','1947100504:29:59','1947100501:59:59' ],
        [ [1947,10,5,4,30,0],[1947,10,5,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1948,5,9,5,29,59],[1948,5,9,1,59,59],
          '1947100504:30:00','1947100501:00:00','1948050905:29:59','1948050901:59:59' ],
     ],
   1948 =>
     [
        [ [1948,5,9,5,30,0],[1948,5,9,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1948,10,3,4,29,59],[1948,10,3,1,59,59],
          '1948050905:30:00','1948050903:00:00','1948100304:29:59','1948100301:59:59' ],
        [ [1948,10,3,4,30,0],[1948,10,3,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1949,5,8,5,29,59],[1949,5,8,1,59,59],
          '1948100304:30:00','1948100301:00:00','1949050805:29:59','1949050801:59:59' ],
     ],
   1949 =>
     [
        [ [1949,5,8,5,30,0],[1949,5,8,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1949,10,2,4,29,59],[1949,10,2,1,59,59],
          '1949050805:30:00','1949050803:00:00','1949100204:29:59','1949100201:59:59' ],
        [ [1949,10,2,4,30,0],[1949,10,2,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1950,5,14,5,29,59],[1950,5,14,1,59,59],
          '1949100204:30:00','1949100201:00:00','1950051405:29:59','1950051401:59:59' ],
     ],
   1950 =>
     [
        [ [1950,5,14,5,30,0],[1950,5,14,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1950,10,8,4,29,59],[1950,10,8,1,59,59],
          '1950051405:30:00','1950051403:00:00','1950100804:29:59','1950100801:59:59' ],
        [ [1950,10,8,4,30,0],[1950,10,8,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1951,4,29,5,29,59],[1951,4,29,1,59,59],
          '1950100804:30:00','1950100801:00:00','1951042905:29:59','1951042901:59:59' ],
     ],
   1951 =>
     [
        [ [1951,4,29,5,30,0],[1951,4,29,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1951,9,30,4,29,59],[1951,9,30,1,59,59],
          '1951042905:30:00','1951042903:00:00','1951093004:29:59','1951093001:59:59' ],
        [ [1951,9,30,4,30,0],[1951,9,30,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1952,4,27,5,29,59],[1952,4,27,1,59,59],
          '1951093004:30:00','1951093001:00:00','1952042705:29:59','1952042701:59:59' ],
     ],
   1952 =>
     [
        [ [1952,4,27,5,30,0],[1952,4,27,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1952,9,28,4,29,59],[1952,9,28,1,59,59],
          '1952042705:30:00','1952042703:00:00','1952092804:29:59','1952092801:59:59' ],
        [ [1952,9,28,4,30,0],[1952,9,28,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1953,4,26,5,29,59],[1953,4,26,1,59,59],
          '1952092804:30:00','1952092801:00:00','1953042605:29:59','1953042601:59:59' ],
     ],
   1953 =>
     [
        [ [1953,4,26,5,30,0],[1953,4,26,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1953,9,27,4,29,59],[1953,9,27,1,59,59],
          '1953042605:30:00','1953042603:00:00','1953092704:29:59','1953092701:59:59' ],
        [ [1953,9,27,4,30,0],[1953,9,27,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1954,4,25,5,29,59],[1954,4,25,1,59,59],
          '1953092704:30:00','1953092701:00:00','1954042505:29:59','1954042501:59:59' ],
     ],
   1954 =>
     [
        [ [1954,4,25,5,30,0],[1954,4,25,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1954,9,26,4,29,59],[1954,9,26,1,59,59],
          '1954042505:30:00','1954042503:00:00','1954092604:29:59','1954092601:59:59' ],
        [ [1954,9,26,4,30,0],[1954,9,26,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1955,4,24,5,29,59],[1955,4,24,1,59,59],
          '1954092604:30:00','1954092601:00:00','1955042405:29:59','1955042401:59:59' ],
     ],
   1955 =>
     [
        [ [1955,4,24,5,30,0],[1955,4,24,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1955,9,25,4,29,59],[1955,9,25,1,59,59],
          '1955042405:30:00','1955042403:00:00','1955092504:29:59','1955092501:59:59' ],
        [ [1955,9,25,4,30,0],[1955,9,25,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1956,4,29,5,29,59],[1956,4,29,1,59,59],
          '1955092504:30:00','1955092501:00:00','1956042905:29:59','1956042901:59:59' ],
     ],
   1956 =>
     [
        [ [1956,4,29,5,30,0],[1956,4,29,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1956,9,30,4,29,59],[1956,9,30,1,59,59],
          '1956042905:30:00','1956042903:00:00','1956093004:29:59','1956093001:59:59' ],
        [ [1956,9,30,4,30,0],[1956,9,30,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1957,4,28,5,29,59],[1957,4,28,1,59,59],
          '1956093004:30:00','1956093001:00:00','1957042805:29:59','1957042801:59:59' ],
     ],
   1957 =>
     [
        [ [1957,4,28,5,30,0],[1957,4,28,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1957,9,29,4,29,59],[1957,9,29,1,59,59],
          '1957042805:30:00','1957042803:00:00','1957092904:29:59','1957092901:59:59' ],
        [ [1957,9,29,4,30,0],[1957,9,29,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1958,4,27,5,29,59],[1958,4,27,1,59,59],
          '1957092904:30:00','1957092901:00:00','1958042705:29:59','1958042701:59:59' ],
     ],
   1958 =>
     [
        [ [1958,4,27,5,30,0],[1958,4,27,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1958,9,28,4,29,59],[1958,9,28,1,59,59],
          '1958042705:30:00','1958042703:00:00','1958092804:29:59','1958092801:59:59' ],
        [ [1958,9,28,4,30,0],[1958,9,28,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1959,4,26,5,29,59],[1959,4,26,1,59,59],
          '1958092804:30:00','1958092801:00:00','1959042605:29:59','1959042601:59:59' ],
     ],
   1959 =>
     [
        [ [1959,4,26,5,30,0],[1959,4,26,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1959,9,27,4,29,59],[1959,9,27,1,59,59],
          '1959042605:30:00','1959042603:00:00','1959092704:29:59','1959092701:59:59' ],
        [ [1959,9,27,4,30,0],[1959,9,27,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1960,4,24,5,29,59],[1960,4,24,1,59,59],
          '1959092704:30:00','1959092701:00:00','1960042405:29:59','1960042401:59:59' ],
     ],
   1960 =>
     [
        [ [1960,4,24,5,30,0],[1960,4,24,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1960,10,30,4,29,59],[1960,10,30,1,59,59],
          '1960042405:30:00','1960042403:00:00','1960103004:29:59','1960103001:59:59' ],
        [ [1960,10,30,4,30,0],[1960,10,30,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1961,4,30,5,29,59],[1961,4,30,1,59,59],
          '1960103004:30:00','1960103001:00:00','1961043005:29:59','1961043001:59:59' ],
     ],
   1961 =>
     [
        [ [1961,4,30,5,30,0],[1961,4,30,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1961,10,29,4,29,59],[1961,10,29,1,59,59],
          '1961043005:30:00','1961043003:00:00','1961102904:29:59','1961102901:59:59' ],
        [ [1961,10,29,4,30,0],[1961,10,29,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1962,4,29,5,29,59],[1962,4,29,1,59,59],
          '1961102904:30:00','1961102901:00:00','1962042905:29:59','1962042901:59:59' ],
     ],
   1962 =>
     [
        [ [1962,4,29,5,30,0],[1962,4,29,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1962,10,28,4,29,59],[1962,10,28,1,59,59],
          '1962042905:30:00','1962042903:00:00','1962102804:29:59','1962102801:59:59' ],
        [ [1962,10,28,4,30,0],[1962,10,28,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1963,4,28,5,29,59],[1963,4,28,1,59,59],
          '1962102804:30:00','1962102801:00:00','1963042805:29:59','1963042801:59:59' ],
     ],
   1963 =>
     [
        [ [1963,4,28,5,30,0],[1963,4,28,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1963,10,27,4,29,59],[1963,10,27,1,59,59],
          '1963042805:30:00','1963042803:00:00','1963102704:29:59','1963102701:59:59' ],
        [ [1963,10,27,4,30,0],[1963,10,27,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1964,4,26,5,29,59],[1964,4,26,1,59,59],
          '1963102704:30:00','1963102701:00:00','1964042605:29:59','1964042601:59:59' ],
     ],
   1964 =>
     [
        [ [1964,4,26,5,30,0],[1964,4,26,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1964,10,25,4,29,59],[1964,10,25,1,59,59],
          '1964042605:30:00','1964042603:00:00','1964102504:29:59','1964102501:59:59' ],
        [ [1964,10,25,4,30,0],[1964,10,25,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1965,4,25,5,29,59],[1965,4,25,1,59,59],
          '1964102504:30:00','1964102501:00:00','1965042505:29:59','1965042501:59:59' ],
     ],
   1965 =>
     [
        [ [1965,4,25,5,30,0],[1965,4,25,3,0,0],'-02:30:00',[-2,-30,0],
          'NDT',1,[1965,10,31,4,29,59],[1965,10,31,1,59,59],
          '1965042505:30:00','1965042503:00:00','1965103104:29:59','1965103101:59:59' ],
        [ [1965,10,31,4,30,0],[1965,10,31,1,0,0],'-03:30:00',[-3,-30,0],
          'NST',0,[1966,3,15,5,29,59],[1966,3,15,1,59,59],
          '1965103104:30:00','1965103101:00:00','1966031505:29:59','1966031501:59:59' ],
     ],
   1966 =>
     [
        [ [1966,3,15,5,30,0],[1966,3,15,1,30,0],'-04:00:00',[-4,0,0],
          'AST',0,[1966,4,24,5,59,59],[1966,4,24,1,59,59],
          '1966031505:30:00','1966031501:30:00','1966042405:59:59','1966042401:59:59' ],
        [ [1966,4,24,6,0,0],[1966,4,24,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1966,10,30,4,59,59],[1966,10,30,1,59,59],
          '1966042406:00:00','1966042403:00:00','1966103004:59:59','1966103001:59:59' ],
        [ [1966,10,30,5,0,0],[1966,10,30,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1967,4,30,5,59,59],[1967,4,30,1,59,59],
          '1966103005:00:00','1966103001:00:00','1967043005:59:59','1967043001:59:59' ],
     ],
   1967 =>
     [
        [ [1967,4,30,6,0,0],[1967,4,30,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1967,10,29,4,59,59],[1967,10,29,1,59,59],
          '1967043006:00:00','1967043003:00:00','1967102904:59:59','1967102901:59:59' ],
        [ [1967,10,29,5,0,0],[1967,10,29,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1968,4,28,5,59,59],[1968,4,28,1,59,59],
          '1967102905:00:00','1967102901:00:00','1968042805:59:59','1968042801:59:59' ],
     ],
   1968 =>
     [
        [ [1968,4,28,6,0,0],[1968,4,28,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1968,10,27,4,59,59],[1968,10,27,1,59,59],
          '1968042806:00:00','1968042803:00:00','1968102704:59:59','1968102701:59:59' ],
        [ [1968,10,27,5,0,0],[1968,10,27,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1969,4,27,5,59,59],[1969,4,27,1,59,59],
          '1968102705:00:00','1968102701:00:00','1969042705:59:59','1969042701:59:59' ],
     ],
   1969 =>
     [
        [ [1969,4,27,6,0,0],[1969,4,27,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1969,10,26,4,59,59],[1969,10,26,1,59,59],
          '1969042706:00:00','1969042703:00:00','1969102604:59:59','1969102601:59:59' ],
        [ [1969,10,26,5,0,0],[1969,10,26,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1970,4,26,5,59,59],[1970,4,26,1,59,59],
          '1969102605:00:00','1969102601:00:00','1970042605:59:59','1970042601:59:59' ],
     ],
   1970 =>
     [
        [ [1970,4,26,6,0,0],[1970,4,26,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1970,10,25,4,59,59],[1970,10,25,1,59,59],
          '1970042606:00:00','1970042603:00:00','1970102504:59:59','1970102501:59:59' ],
        [ [1970,10,25,5,0,0],[1970,10,25,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1971,4,25,5,59,59],[1971,4,25,1,59,59],
          '1970102505:00:00','1970102501:00:00','1971042505:59:59','1971042501:59:59' ],
     ],
   1971 =>
     [
        [ [1971,4,25,6,0,0],[1971,4,25,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1971,10,31,4,59,59],[1971,10,31,1,59,59],
          '1971042506:00:00','1971042503:00:00','1971103104:59:59','1971103101:59:59' ],
        [ [1971,10,31,5,0,0],[1971,10,31,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1972,4,30,5,59,59],[1972,4,30,1,59,59],
          '1971103105:00:00','1971103101:00:00','1972043005:59:59','1972043001:59:59' ],
     ],
   1972 =>
     [
        [ [1972,4,30,6,0,0],[1972,4,30,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1972,10,29,4,59,59],[1972,10,29,1,59,59],
          '1972043006:00:00','1972043003:00:00','1972102904:59:59','1972102901:59:59' ],
        [ [1972,10,29,5,0,0],[1972,10,29,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1973,4,29,5,59,59],[1973,4,29,1,59,59],
          '1972102905:00:00','1972102901:00:00','1973042905:59:59','1973042901:59:59' ],
     ],
   1973 =>
     [
        [ [1973,4,29,6,0,0],[1973,4,29,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1973,10,28,4,59,59],[1973,10,28,1,59,59],
          '1973042906:00:00','1973042903:00:00','1973102804:59:59','1973102801:59:59' ],
        [ [1973,10,28,5,0,0],[1973,10,28,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1974,4,28,5,59,59],[1974,4,28,1,59,59],
          '1973102805:00:00','1973102801:00:00','1974042805:59:59','1974042801:59:59' ],
     ],
   1974 =>
     [
        [ [1974,4,28,6,0,0],[1974,4,28,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1974,10,27,4,59,59],[1974,10,27,1,59,59],
          '1974042806:00:00','1974042803:00:00','1974102704:59:59','1974102701:59:59' ],
        [ [1974,10,27,5,0,0],[1974,10,27,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1975,4,27,5,59,59],[1975,4,27,1,59,59],
          '1974102705:00:00','1974102701:00:00','1975042705:59:59','1975042701:59:59' ],
     ],
   1975 =>
     [
        [ [1975,4,27,6,0,0],[1975,4,27,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1975,10,26,4,59,59],[1975,10,26,1,59,59],
          '1975042706:00:00','1975042703:00:00','1975102604:59:59','1975102601:59:59' ],
        [ [1975,10,26,5,0,0],[1975,10,26,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1976,4,25,5,59,59],[1976,4,25,1,59,59],
          '1975102605:00:00','1975102601:00:00','1976042505:59:59','1976042501:59:59' ],
     ],
   1976 =>
     [
        [ [1976,4,25,6,0,0],[1976,4,25,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1976,10,31,4,59,59],[1976,10,31,1,59,59],
          '1976042506:00:00','1976042503:00:00','1976103104:59:59','1976103101:59:59' ],
        [ [1976,10,31,5,0,0],[1976,10,31,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1977,4,24,5,59,59],[1977,4,24,1,59,59],
          '1976103105:00:00','1976103101:00:00','1977042405:59:59','1977042401:59:59' ],
     ],
   1977 =>
     [
        [ [1977,4,24,6,0,0],[1977,4,24,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1977,10,30,4,59,59],[1977,10,30,1,59,59],
          '1977042406:00:00','1977042403:00:00','1977103004:59:59','1977103001:59:59' ],
        [ [1977,10,30,5,0,0],[1977,10,30,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1978,4,30,5,59,59],[1978,4,30,1,59,59],
          '1977103005:00:00','1977103001:00:00','1978043005:59:59','1978043001:59:59' ],
     ],
   1978 =>
     [
        [ [1978,4,30,6,0,0],[1978,4,30,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1978,10,29,4,59,59],[1978,10,29,1,59,59],
          '1978043006:00:00','1978043003:00:00','1978102904:59:59','1978102901:59:59' ],
        [ [1978,10,29,5,0,0],[1978,10,29,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1979,4,29,5,59,59],[1979,4,29,1,59,59],
          '1978102905:00:00','1978102901:00:00','1979042905:59:59','1979042901:59:59' ],
     ],
   1979 =>
     [
        [ [1979,4,29,6,0,0],[1979,4,29,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1979,10,28,4,59,59],[1979,10,28,1,59,59],
          '1979042906:00:00','1979042903:00:00','1979102804:59:59','1979102801:59:59' ],
        [ [1979,10,28,5,0,0],[1979,10,28,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1980,4,27,5,59,59],[1980,4,27,1,59,59],
          '1979102805:00:00','1979102801:00:00','1980042705:59:59','1980042701:59:59' ],
     ],
   1980 =>
     [
        [ [1980,4,27,6,0,0],[1980,4,27,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1980,10,26,4,59,59],[1980,10,26,1,59,59],
          '1980042706:00:00','1980042703:00:00','1980102604:59:59','1980102601:59:59' ],
        [ [1980,10,26,5,0,0],[1980,10,26,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1981,4,26,5,59,59],[1981,4,26,1,59,59],
          '1980102605:00:00','1980102601:00:00','1981042605:59:59','1981042601:59:59' ],
     ],
   1981 =>
     [
        [ [1981,4,26,6,0,0],[1981,4,26,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1981,10,25,4,59,59],[1981,10,25,1,59,59],
          '1981042606:00:00','1981042603:00:00','1981102504:59:59','1981102501:59:59' ],
        [ [1981,10,25,5,0,0],[1981,10,25,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1982,4,25,5,59,59],[1982,4,25,1,59,59],
          '1981102505:00:00','1981102501:00:00','1982042505:59:59','1982042501:59:59' ],
     ],
   1982 =>
     [
        [ [1982,4,25,6,0,0],[1982,4,25,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1982,10,31,4,59,59],[1982,10,31,1,59,59],
          '1982042506:00:00','1982042503:00:00','1982103104:59:59','1982103101:59:59' ],
        [ [1982,10,31,5,0,0],[1982,10,31,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1983,4,24,5,59,59],[1983,4,24,1,59,59],
          '1982103105:00:00','1982103101:00:00','1983042405:59:59','1983042401:59:59' ],
     ],
   1983 =>
     [
        [ [1983,4,24,6,0,0],[1983,4,24,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1983,10,30,4,59,59],[1983,10,30,1,59,59],
          '1983042406:00:00','1983042403:00:00','1983103004:59:59','1983103001:59:59' ],
        [ [1983,10,30,5,0,0],[1983,10,30,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1984,4,29,5,59,59],[1984,4,29,1,59,59],
          '1983103005:00:00','1983103001:00:00','1984042905:59:59','1984042901:59:59' ],
     ],
   1984 =>
     [
        [ [1984,4,29,6,0,0],[1984,4,29,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1984,10,28,4,59,59],[1984,10,28,1,59,59],
          '1984042906:00:00','1984042903:00:00','1984102804:59:59','1984102801:59:59' ],
        [ [1984,10,28,5,0,0],[1984,10,28,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1985,4,28,5,59,59],[1985,4,28,1,59,59],
          '1984102805:00:00','1984102801:00:00','1985042805:59:59','1985042801:59:59' ],
     ],
   1985 =>
     [
        [ [1985,4,28,6,0,0],[1985,4,28,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1985,10,27,4,59,59],[1985,10,27,1,59,59],
          '1985042806:00:00','1985042803:00:00','1985102704:59:59','1985102701:59:59' ],
        [ [1985,10,27,5,0,0],[1985,10,27,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1986,4,27,5,59,59],[1986,4,27,1,59,59],
          '1985102705:00:00','1985102701:00:00','1986042705:59:59','1986042701:59:59' ],
     ],
   1986 =>
     [
        [ [1986,4,27,6,0,0],[1986,4,27,3,0,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1986,10,26,4,59,59],[1986,10,26,1,59,59],
          '1986042706:00:00','1986042703:00:00','1986102604:59:59','1986102601:59:59' ],
        [ [1986,10,26,5,0,0],[1986,10,26,1,0,0],'-04:00:00',[-4,0,0],
          'AST',0,[1987,4,5,4,0,59],[1987,4,5,0,0,59],
          '1986102605:00:00','1986102601:00:00','1987040504:00:59','1987040500:00:59' ],
     ],
   1987 =>
     [
        [ [1987,4,5,4,1,0],[1987,4,5,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1987,10,25,3,0,59],[1987,10,25,0,0,59],
          '1987040504:01:00','1987040501:01:00','1987102503:00:59','1987102500:00:59' ],
        [ [1987,10,25,3,1,0],[1987,10,24,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1988,4,3,4,0,59],[1988,4,3,0,0,59],
          '1987102503:01:00','1987102423:01:00','1988040304:00:59','1988040300:00:59' ],
     ],
   1988 =>
     [
        [ [1988,4,3,4,1,0],[1988,4,3,2,1,0],'-02:00:00',[-2,0,0],
          'ADDT',1,[1988,10,30,2,0,59],[1988,10,30,0,0,59],
          '1988040304:01:00','1988040302:01:00','1988103002:00:59','1988103000:00:59' ],
        [ [1988,10,30,2,1,0],[1988,10,29,22,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1989,4,2,4,0,59],[1989,4,2,0,0,59],
          '1988103002:01:00','1988102922:01:00','1989040204:00:59','1989040200:00:59' ],
     ],
   1989 =>
     [
        [ [1989,4,2,4,1,0],[1989,4,2,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1989,10,29,3,0,59],[1989,10,29,0,0,59],
          '1989040204:01:00','1989040201:01:00','1989102903:00:59','1989102900:00:59' ],
        [ [1989,10,29,3,1,0],[1989,10,28,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1990,4,1,4,0,59],[1990,4,1,0,0,59],
          '1989102903:01:00','1989102823:01:00','1990040104:00:59','1990040100:00:59' ],
     ],
   1990 =>
     [
        [ [1990,4,1,4,1,0],[1990,4,1,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1990,10,28,3,0,59],[1990,10,28,0,0,59],
          '1990040104:01:00','1990040101:01:00','1990102803:00:59','1990102800:00:59' ],
        [ [1990,10,28,3,1,0],[1990,10,27,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1991,4,7,4,0,59],[1991,4,7,0,0,59],
          '1990102803:01:00','1990102723:01:00','1991040704:00:59','1991040700:00:59' ],
     ],
   1991 =>
     [
        [ [1991,4,7,4,1,0],[1991,4,7,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1991,10,27,3,0,59],[1991,10,27,0,0,59],
          '1991040704:01:00','1991040701:01:00','1991102703:00:59','1991102700:00:59' ],
        [ [1991,10,27,3,1,0],[1991,10,26,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1992,4,5,4,0,59],[1992,4,5,0,0,59],
          '1991102703:01:00','1991102623:01:00','1992040504:00:59','1992040500:00:59' ],
     ],
   1992 =>
     [
        [ [1992,4,5,4,1,0],[1992,4,5,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1992,10,25,3,0,59],[1992,10,25,0,0,59],
          '1992040504:01:00','1992040501:01:00','1992102503:00:59','1992102500:00:59' ],
        [ [1992,10,25,3,1,0],[1992,10,24,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1993,4,4,4,0,59],[1993,4,4,0,0,59],
          '1992102503:01:00','1992102423:01:00','1993040404:00:59','1993040400:00:59' ],
     ],
   1993 =>
     [
        [ [1993,4,4,4,1,0],[1993,4,4,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1993,10,31,3,0,59],[1993,10,31,0,0,59],
          '1993040404:01:00','1993040401:01:00','1993103103:00:59','1993103100:00:59' ],
        [ [1993,10,31,3,1,0],[1993,10,30,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1994,4,3,4,0,59],[1994,4,3,0,0,59],
          '1993103103:01:00','1993103023:01:00','1994040304:00:59','1994040300:00:59' ],
     ],
   1994 =>
     [
        [ [1994,4,3,4,1,0],[1994,4,3,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1994,10,30,3,0,59],[1994,10,30,0,0,59],
          '1994040304:01:00','1994040301:01:00','1994103003:00:59','1994103000:00:59' ],
        [ [1994,10,30,3,1,0],[1994,10,29,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1995,4,2,4,0,59],[1995,4,2,0,0,59],
          '1994103003:01:00','1994102923:01:00','1995040204:00:59','1995040200:00:59' ],
     ],
   1995 =>
     [
        [ [1995,4,2,4,1,0],[1995,4,2,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1995,10,29,3,0,59],[1995,10,29,0,0,59],
          '1995040204:01:00','1995040201:01:00','1995102903:00:59','1995102900:00:59' ],
        [ [1995,10,29,3,1,0],[1995,10,28,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1996,4,7,4,0,59],[1996,4,7,0,0,59],
          '1995102903:01:00','1995102823:01:00','1996040704:00:59','1996040700:00:59' ],
     ],
   1996 =>
     [
        [ [1996,4,7,4,1,0],[1996,4,7,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1996,10,27,3,0,59],[1996,10,27,0,0,59],
          '1996040704:01:00','1996040701:01:00','1996102703:00:59','1996102700:00:59' ],
        [ [1996,10,27,3,1,0],[1996,10,26,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1997,4,6,4,0,59],[1997,4,6,0,0,59],
          '1996102703:01:00','1996102623:01:00','1997040604:00:59','1997040600:00:59' ],
     ],
   1997 =>
     [
        [ [1997,4,6,4,1,0],[1997,4,6,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1997,10,26,3,0,59],[1997,10,26,0,0,59],
          '1997040604:01:00','1997040601:01:00','1997102603:00:59','1997102600:00:59' ],
        [ [1997,10,26,3,1,0],[1997,10,25,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1998,4,5,4,0,59],[1998,4,5,0,0,59],
          '1997102603:01:00','1997102523:01:00','1998040504:00:59','1998040500:00:59' ],
     ],
   1998 =>
     [
        [ [1998,4,5,4,1,0],[1998,4,5,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1998,10,25,3,0,59],[1998,10,25,0,0,59],
          '1998040504:01:00','1998040501:01:00','1998102503:00:59','1998102500:00:59' ],
        [ [1998,10,25,3,1,0],[1998,10,24,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[1999,4,4,4,0,59],[1999,4,4,0,0,59],
          '1998102503:01:00','1998102423:01:00','1999040404:00:59','1999040400:00:59' ],
     ],
   1999 =>
     [
        [ [1999,4,4,4,1,0],[1999,4,4,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[1999,10,31,3,0,59],[1999,10,31,0,0,59],
          '1999040404:01:00','1999040401:01:00','1999103103:00:59','1999103100:00:59' ],
        [ [1999,10,31,3,1,0],[1999,10,30,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2000,4,2,4,0,59],[2000,4,2,0,0,59],
          '1999103103:01:00','1999103023:01:00','2000040204:00:59','2000040200:00:59' ],
     ],
   2000 =>
     [
        [ [2000,4,2,4,1,0],[2000,4,2,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2000,10,29,3,0,59],[2000,10,29,0,0,59],
          '2000040204:01:00','2000040201:01:00','2000102903:00:59','2000102900:00:59' ],
        [ [2000,10,29,3,1,0],[2000,10,28,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2001,4,1,4,0,59],[2001,4,1,0,0,59],
          '2000102903:01:00','2000102823:01:00','2001040104:00:59','2001040100:00:59' ],
     ],
   2001 =>
     [
        [ [2001,4,1,4,1,0],[2001,4,1,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2001,10,28,3,0,59],[2001,10,28,0,0,59],
          '2001040104:01:00','2001040101:01:00','2001102803:00:59','2001102800:00:59' ],
        [ [2001,10,28,3,1,0],[2001,10,27,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2002,4,7,4,0,59],[2002,4,7,0,0,59],
          '2001102803:01:00','2001102723:01:00','2002040704:00:59','2002040700:00:59' ],
     ],
   2002 =>
     [
        [ [2002,4,7,4,1,0],[2002,4,7,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2002,10,27,3,0,59],[2002,10,27,0,0,59],
          '2002040704:01:00','2002040701:01:00','2002102703:00:59','2002102700:00:59' ],
        [ [2002,10,27,3,1,0],[2002,10,26,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2003,4,6,4,0,59],[2003,4,6,0,0,59],
          '2002102703:01:00','2002102623:01:00','2003040604:00:59','2003040600:00:59' ],
     ],
   2003 =>
     [
        [ [2003,4,6,4,1,0],[2003,4,6,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2003,10,26,3,0,59],[2003,10,26,0,0,59],
          '2003040604:01:00','2003040601:01:00','2003102603:00:59','2003102600:00:59' ],
        [ [2003,10,26,3,1,0],[2003,10,25,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2004,4,4,4,0,59],[2004,4,4,0,0,59],
          '2003102603:01:00','2003102523:01:00','2004040404:00:59','2004040400:00:59' ],
     ],
   2004 =>
     [
        [ [2004,4,4,4,1,0],[2004,4,4,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2004,10,31,3,0,59],[2004,10,31,0,0,59],
          '2004040404:01:00','2004040401:01:00','2004103103:00:59','2004103100:00:59' ],
        [ [2004,10,31,3,1,0],[2004,10,30,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2005,4,3,4,0,59],[2005,4,3,0,0,59],
          '2004103103:01:00','2004103023:01:00','2005040304:00:59','2005040300:00:59' ],
     ],
   2005 =>
     [
        [ [2005,4,3,4,1,0],[2005,4,3,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2005,10,30,3,0,59],[2005,10,30,0,0,59],
          '2005040304:01:00','2005040301:01:00','2005103003:00:59','2005103000:00:59' ],
        [ [2005,10,30,3,1,0],[2005,10,29,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2006,4,2,4,0,59],[2006,4,2,0,0,59],
          '2005103003:01:00','2005102923:01:00','2006040204:00:59','2006040200:00:59' ],
     ],
   2006 =>
     [
        [ [2006,4,2,4,1,0],[2006,4,2,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2006,10,29,3,0,59],[2006,10,29,0,0,59],
          '2006040204:01:00','2006040201:01:00','2006102903:00:59','2006102900:00:59' ],
        [ [2006,10,29,3,1,0],[2006,10,28,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2007,3,11,4,0,59],[2007,3,11,0,0,59],
          '2006102903:01:00','2006102823:01:00','2007031104:00:59','2007031100:00:59' ],
     ],
   2007 =>
     [
        [ [2007,3,11,4,1,0],[2007,3,11,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2007,11,4,3,0,59],[2007,11,4,0,0,59],
          '2007031104:01:00','2007031101:01:00','2007110403:00:59','2007110400:00:59' ],
        [ [2007,11,4,3,1,0],[2007,11,3,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2008,3,9,4,0,59],[2008,3,9,0,0,59],
          '2007110403:01:00','2007110323:01:00','2008030904:00:59','2008030900:00:59' ],
     ],
   2008 =>
     [
        [ [2008,3,9,4,1,0],[2008,3,9,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2008,11,2,3,0,59],[2008,11,2,0,0,59],
          '2008030904:01:00','2008030901:01:00','2008110203:00:59','2008110200:00:59' ],
        [ [2008,11,2,3,1,0],[2008,11,1,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2009,3,8,4,0,59],[2009,3,8,0,0,59],
          '2008110203:01:00','2008110123:01:00','2009030804:00:59','2009030800:00:59' ],
     ],
   2009 =>
     [
        [ [2009,3,8,4,1,0],[2009,3,8,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2009,11,1,3,0,59],[2009,11,1,0,0,59],
          '2009030804:01:00','2009030801:01:00','2009110103:00:59','2009110100:00:59' ],
        [ [2009,11,1,3,1,0],[2009,10,31,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2010,3,14,4,0,59],[2010,3,14,0,0,59],
          '2009110103:01:00','2009103123:01:00','2010031404:00:59','2010031400:00:59' ],
     ],
   2010 =>
     [
        [ [2010,3,14,4,1,0],[2010,3,14,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2010,11,7,3,0,59],[2010,11,7,0,0,59],
          '2010031404:01:00','2010031401:01:00','2010110703:00:59','2010110700:00:59' ],
        [ [2010,11,7,3,1,0],[2010,11,6,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2011,3,13,4,0,59],[2011,3,13,0,0,59],
          '2010110703:01:00','2010110623:01:00','2011031304:00:59','2011031300:00:59' ],
     ],
   2011 =>
     [
        [ [2011,3,13,4,1,0],[2011,3,13,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2011,11,6,3,0,59],[2011,11,6,0,0,59],
          '2011031304:01:00','2011031301:01:00','2011110603:00:59','2011110600:00:59' ],
        [ [2011,11,6,3,1,0],[2011,11,5,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2012,3,11,4,0,59],[2012,3,11,0,0,59],
          '2011110603:01:00','2011110523:01:00','2012031104:00:59','2012031100:00:59' ],
     ],
   2012 =>
     [
        [ [2012,3,11,4,1,0],[2012,3,11,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2012,11,4,3,0,59],[2012,11,4,0,0,59],
          '2012031104:01:00','2012031101:01:00','2012110403:00:59','2012110400:00:59' ],
        [ [2012,11,4,3,1,0],[2012,11,3,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2013,3,10,4,0,59],[2013,3,10,0,0,59],
          '2012110403:01:00','2012110323:01:00','2013031004:00:59','2013031000:00:59' ],
     ],
   2013 =>
     [
        [ [2013,3,10,4,1,0],[2013,3,10,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2013,11,3,3,0,59],[2013,11,3,0,0,59],
          '2013031004:01:00','2013031001:01:00','2013110303:00:59','2013110300:00:59' ],
        [ [2013,11,3,3,1,0],[2013,11,2,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2014,3,9,4,0,59],[2014,3,9,0,0,59],
          '2013110303:01:00','2013110223:01:00','2014030904:00:59','2014030900:00:59' ],
     ],
   2014 =>
     [
        [ [2014,3,9,4,1,0],[2014,3,9,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2014,11,2,3,0,59],[2014,11,2,0,0,59],
          '2014030904:01:00','2014030901:01:00','2014110203:00:59','2014110200:00:59' ],
        [ [2014,11,2,3,1,0],[2014,11,1,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2015,3,8,4,0,59],[2015,3,8,0,0,59],
          '2014110203:01:00','2014110123:01:00','2015030804:00:59','2015030800:00:59' ],
     ],
   2015 =>
     [
        [ [2015,3,8,4,1,0],[2015,3,8,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2015,11,1,3,0,59],[2015,11,1,0,0,59],
          '2015030804:01:00','2015030801:01:00','2015110103:00:59','2015110100:00:59' ],
        [ [2015,11,1,3,1,0],[2015,10,31,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2016,3,13,4,0,59],[2016,3,13,0,0,59],
          '2015110103:01:00','2015103123:01:00','2016031304:00:59','2016031300:00:59' ],
     ],
   2016 =>
     [
        [ [2016,3,13,4,1,0],[2016,3,13,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2016,11,6,3,0,59],[2016,11,6,0,0,59],
          '2016031304:01:00','2016031301:01:00','2016110603:00:59','2016110600:00:59' ],
        [ [2016,11,6,3,1,0],[2016,11,5,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2017,3,12,4,0,59],[2017,3,12,0,0,59],
          '2016110603:01:00','2016110523:01:00','2017031204:00:59','2017031200:00:59' ],
     ],
   2017 =>
     [
        [ [2017,3,12,4,1,0],[2017,3,12,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2017,11,5,3,0,59],[2017,11,5,0,0,59],
          '2017031204:01:00','2017031201:01:00','2017110503:00:59','2017110500:00:59' ],
        [ [2017,11,5,3,1,0],[2017,11,4,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2018,3,11,4,0,59],[2018,3,11,0,0,59],
          '2017110503:01:00','2017110423:01:00','2018031104:00:59','2018031100:00:59' ],
     ],
   2018 =>
     [
        [ [2018,3,11,4,1,0],[2018,3,11,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2018,11,4,3,0,59],[2018,11,4,0,0,59],
          '2018031104:01:00','2018031101:01:00','2018110403:00:59','2018110400:00:59' ],
        [ [2018,11,4,3,1,0],[2018,11,3,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2019,3,10,4,0,59],[2019,3,10,0,0,59],
          '2018110403:01:00','2018110323:01:00','2019031004:00:59','2019031000:00:59' ],
     ],
   2019 =>
     [
        [ [2019,3,10,4,1,0],[2019,3,10,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2019,11,3,3,0,59],[2019,11,3,0,0,59],
          '2019031004:01:00','2019031001:01:00','2019110303:00:59','2019110300:00:59' ],
        [ [2019,11,3,3,1,0],[2019,11,2,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2020,3,8,4,0,59],[2020,3,8,0,0,59],
          '2019110303:01:00','2019110223:01:00','2020030804:00:59','2020030800:00:59' ],
     ],
   2020 =>
     [
        [ [2020,3,8,4,1,0],[2020,3,8,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2020,11,1,3,0,59],[2020,11,1,0,0,59],
          '2020030804:01:00','2020030801:01:00','2020110103:00:59','2020110100:00:59' ],
        [ [2020,11,1,3,1,0],[2020,10,31,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2021,3,14,4,0,59],[2021,3,14,0,0,59],
          '2020110103:01:00','2020103123:01:00','2021031404:00:59','2021031400:00:59' ],
     ],
   2021 =>
     [
        [ [2021,3,14,4,1,0],[2021,3,14,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2021,11,7,3,0,59],[2021,11,7,0,0,59],
          '2021031404:01:00','2021031401:01:00','2021110703:00:59','2021110700:00:59' ],
        [ [2021,11,7,3,1,0],[2021,11,6,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2022,3,13,4,0,59],[2022,3,13,0,0,59],
          '2021110703:01:00','2021110623:01:00','2022031304:00:59','2022031300:00:59' ],
     ],
   2022 =>
     [
        [ [2022,3,13,4,1,0],[2022,3,13,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2022,11,6,3,0,59],[2022,11,6,0,0,59],
          '2022031304:01:00','2022031301:01:00','2022110603:00:59','2022110600:00:59' ],
        [ [2022,11,6,3,1,0],[2022,11,5,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2023,3,12,4,0,59],[2023,3,12,0,0,59],
          '2022110603:01:00','2022110523:01:00','2023031204:00:59','2023031200:00:59' ],
     ],
   2023 =>
     [
        [ [2023,3,12,4,1,0],[2023,3,12,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2023,11,5,3,0,59],[2023,11,5,0,0,59],
          '2023031204:01:00','2023031201:01:00','2023110503:00:59','2023110500:00:59' ],
        [ [2023,11,5,3,1,0],[2023,11,4,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2024,3,10,4,0,59],[2024,3,10,0,0,59],
          '2023110503:01:00','2023110423:01:00','2024031004:00:59','2024031000:00:59' ],
     ],
   2024 =>
     [
        [ [2024,3,10,4,1,0],[2024,3,10,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2024,11,3,3,0,59],[2024,11,3,0,0,59],
          '2024031004:01:00','2024031001:01:00','2024110303:00:59','2024110300:00:59' ],
        [ [2024,11,3,3,1,0],[2024,11,2,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2025,3,9,4,0,59],[2025,3,9,0,0,59],
          '2024110303:01:00','2024110223:01:00','2025030904:00:59','2025030900:00:59' ],
     ],
   2025 =>
     [
        [ [2025,3,9,4,1,0],[2025,3,9,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2025,11,2,3,0,59],[2025,11,2,0,0,59],
          '2025030904:01:00','2025030901:01:00','2025110203:00:59','2025110200:00:59' ],
        [ [2025,11,2,3,1,0],[2025,11,1,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2026,3,8,4,0,59],[2026,3,8,0,0,59],
          '2025110203:01:00','2025110123:01:00','2026030804:00:59','2026030800:00:59' ],
     ],
   2026 =>
     [
        [ [2026,3,8,4,1,0],[2026,3,8,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2026,11,1,3,0,59],[2026,11,1,0,0,59],
          '2026030804:01:00','2026030801:01:00','2026110103:00:59','2026110100:00:59' ],
        [ [2026,11,1,3,1,0],[2026,10,31,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2027,3,14,4,0,59],[2027,3,14,0,0,59],
          '2026110103:01:00','2026103123:01:00','2027031404:00:59','2027031400:00:59' ],
     ],
   2027 =>
     [
        [ [2027,3,14,4,1,0],[2027,3,14,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2027,11,7,3,0,59],[2027,11,7,0,0,59],
          '2027031404:01:00','2027031401:01:00','2027110703:00:59','2027110700:00:59' ],
        [ [2027,11,7,3,1,0],[2027,11,6,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2028,3,12,4,0,59],[2028,3,12,0,0,59],
          '2027110703:01:00','2027110623:01:00','2028031204:00:59','2028031200:00:59' ],
     ],
   2028 =>
     [
        [ [2028,3,12,4,1,0],[2028,3,12,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2028,11,5,3,0,59],[2028,11,5,0,0,59],
          '2028031204:01:00','2028031201:01:00','2028110503:00:59','2028110500:00:59' ],
        [ [2028,11,5,3,1,0],[2028,11,4,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2029,3,11,4,0,59],[2029,3,11,0,0,59],
          '2028110503:01:00','2028110423:01:00','2029031104:00:59','2029031100:00:59' ],
     ],
   2029 =>
     [
        [ [2029,3,11,4,1,0],[2029,3,11,1,1,0],'-03:00:00',[-3,0,0],
          'ADT',1,[2029,11,4,3,0,59],[2029,11,4,0,0,59],
          '2029031104:01:00','2029031101:01:00','2029110403:00:59','2029110400:00:59' ],
        [ [2029,11,4,3,1,0],[2029,11,3,23,1,0],'-04:00:00',[-4,0,0],
          'AST',0,[2030,3,10,4,0,59],[2030,3,10,0,0,59],
          '2029110403:01:00','2029110323:01:00','2030031004:00:59','2030031000:00:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-03:00:00',
                'stdoff' => '-04:00:00',

               },
   'rules'  => {
                '03' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 'w',
                         'time'    => '00:01:00',
                         'isdst'   => '1',
                         'abb'     => 'ADT',
                        },
                '11' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '00:01:00',
                         'isdst'   => '0',
                         'abb'     => 'AST',
                        },

               },
);

1;
