/*
 * libspe2 - A wrapper to allow direct execution of SPE binaries
 * Copyright (C) 2005 IBM Corp.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License,
 * or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 *  License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software Foundation,
 *   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 * libspe-thread
 * ======
 * 
 * This is a convienience library that provides a pthread-based implementation
 * of a thread model similar to libspe 1.1. In order to be able to use 
 * libspe-base functions, we need the SPE context associated with the pthread 
 * being created.
 */

/**
 * creates a pthread then creates/uses an SPE context, loads image, 
 * and starts execution - asynchronously to the main thread. 
 * For maxmimum flexibility, we allow the main thread to create the SPE
 * context using libspe-base. 
 * If *spectx is NULL, a new SPE context will be created and returned. 
 * Otherwise *spectx is used in the new thread.
 * If the context is created by spe_thread_create, it will be deleted 
 * in spe_thread_wait.
 * 
 */
#include "spethread.h"

int spe_thread_create(  pthread_t *thread,
                        struct spe_context *spectx,
                        spe_program_handle_t *spe_program_handle, void *argp, void *envp, 
                        int flags)
{
}

/**
 * wait for termination of *thread (synchronization)
 * If the context was created by spe_thread_create, it will be deleted in 
 * here in spe_thread_wait
 */
int spe_thread_wait(    pthread_t *thread,
                        struct spe_context *spectx,
                        int *status, 
                        int options)
{
}

/**
 * send signal to *thread
 */
int spe_kill(           pthread_t *thread,
                        struct spe_context * spectx, 
                        int signal)
{
}


