/* unity-lens-filters.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-lens-filters.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dee.h>
#include <float.h>
#include <math.h>


#define UNITY_TYPE_FILTER_COLUMN (unity_filter_column_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

typedef enum  {
	UNITY_FILTER_COLUMN_ID = 0,
	UNITY_FILTER_COLUMN_NAME,
	UNITY_FILTER_COLUMN_ICON_HINT,
	UNITY_FILTER_COLUMN_RENDERER_NAME,
	UNITY_FILTER_COLUMN_RENDERER_STATE,
	UNITY_FILTER_COLUMN_VISIBLE,
	UNITY_FILTER_COLUMN_COLLAPSED,
	UNITY_FILTER_COLUMN_FILTERING
} UnityFilterColumn;

struct _UnityFilterPrivate {
	gchar* _id;
	gchar* _display_name;
	GIcon* _icon_hint;
	UnityFilterRenderer _renderer;
	gboolean _visible;
	gboolean _collapsed;
	gboolean _filtering;
	DeeModel* _model;
	DeeModelIter* _iter;
};

struct _UnityFilterOptionPrivate {
	gchar* _id;
	gchar* _display_name;
	GIcon* _icon_hint;
	gboolean _active;
};

struct _UnityOptionsFilterPrivate {
	UnityOptionsFilterSortType _sort_type;
};

struct _UnityRatingsFilterPrivate {
	gfloat _rating;
};


static gpointer unity_filter_parent_class = NULL;
static gpointer unity_filter_option_parent_class = NULL;
static gpointer unity_options_filter_parent_class = NULL;
static gpointer unity_radio_option_filter_parent_class = NULL;
static gpointer unity_check_option_filter_parent_class = NULL;
static gpointer unity_check_option_filter_compact_parent_class = NULL;
static gpointer unity_ratings_filter_parent_class = NULL;
static gpointer unity_multi_range_filter_parent_class = NULL;

GType unity_filter_column_get_type (void) G_GNUC_CONST;
#define UNITY_FILTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_FILTER, UnityFilterPrivate))
enum  {
	UNITY_FILTER_DUMMY_PROPERTY,
	UNITY_FILTER_ID,
	UNITY_FILTER_DISPLAY_NAME,
	UNITY_FILTER_ICON_HINT,
	UNITY_FILTER_RENDERER,
	UNITY_FILTER_VISIBLE,
	UNITY_FILTER_COLLAPSED,
	UNITY_FILTER_FILTERING
};
void unity_filter_set_model_and_iter (UnityFilter* self, DeeModel* model, DeeModelIter* iter);
static void unity_filter_on_row_changed (UnityFilter* self, DeeModel* model, DeeModelIter* iter);
static void _unity_filter_on_row_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
void unity_filter_set_filtering (UnityFilter* self, gboolean value);
void unity_filter_update (UnityFilter* self, GVariant* properties);
GHashTable* unity_filter_get_hints (UnityFilter* self);
static GHashTable* unity_filter_real_get_hints (UnityFilter* self);
static void unity_filter_real_update (UnityFilter* self, GVariant* properties);
const gchar* unity_filter_get_renderer_name (UnityFilterRenderer renderer);
UnityFilterRenderer unity_filter_renderer_for_name (const gchar* renderer_name);
void unity_filter_set_display_name (UnityFilter* self, const gchar* value);
static void unity_filter_finalize (GObject* obj);
static void _vala_unity_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_FILTER_OPTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_FILTER_OPTION, UnityFilterOptionPrivate))
enum  {
	UNITY_FILTER_OPTION_DUMMY_PROPERTY,
	UNITY_FILTER_OPTION_ID,
	UNITY_FILTER_OPTION_DISPLAY_NAME,
	UNITY_FILTER_OPTION_ICON_HINT,
	UNITY_FILTER_OPTION_ACTIVE
};
void unity_filter_option_set_active (UnityFilterOption* self, gboolean value);
static void unity_filter_option_finalize (GObject* obj);
static void _vala_unity_filter_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_filter_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_OPTIONS_FILTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_OPTIONS_FILTER, UnityOptionsFilterPrivate))
enum  {
	UNITY_OPTIONS_FILTER_DUMMY_PROPERTY,
	UNITY_OPTIONS_FILTER_SORT_TYPE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gint unity_options_filter_sort_by_display_name (UnityFilterOption* f1, UnityFilterOption* f2);
static gint _unity_options_filter_sort_by_display_name_gcompare_func (gconstpointer a, gconstpointer b);
static gint unity_options_filter_sort_by_id (UnityFilterOption* f1, UnityFilterOption* f2);
static gint _unity_options_filter_sort_by_id_gcompare_func (gconstpointer a, gconstpointer b);
static void unity_options_filter_real_update (UnityFilter* base, GVariant* properties);
void unity_options_filter_load_or_update_options (UnityOptionsFilter* self, GVariant* array);
void unity_options_filter_find_and_update_option (UnityOptionsFilter* self, const gchar* id, const gchar* name, const gchar* icon_hint_s, gboolean active);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static GHashTable* unity_options_filter_real_get_hints (UnityFilter* base);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void unity_options_filter_finalize (GObject* obj);
static void _vala_unity_options_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_options_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	UNITY_RADIO_OPTION_FILTER_DUMMY_PROPERTY
};
enum  {
	UNITY_CHECK_OPTION_FILTER_DUMMY_PROPERTY
};
enum  {
	UNITY_CHECK_OPTION_FILTER_COMPACT_DUMMY_PROPERTY
};
#define UNITY_RATINGS_FILTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_RATINGS_FILTER, UnityRatingsFilterPrivate))
enum  {
	UNITY_RATINGS_FILTER_DUMMY_PROPERTY,
	UNITY_RATINGS_FILTER_RATING
};
static void unity_ratings_filter_real_update (UnityFilter* base, GVariant* properties);
void unity_ratings_filter_set_rating (UnityRatingsFilter* self, gfloat value);
static GHashTable* unity_ratings_filter_real_get_hints (UnityFilter* base);
static GVariant* _variant_new16 (gdouble value);
static void unity_ratings_filter_finalize (GObject* obj);
static void _vala_unity_ratings_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_ratings_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	UNITY_MULTI_RANGE_FILTER_DUMMY_PROPERTY
};
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType unity_filter_column_get_type (void) {
	static volatile gsize unity_filter_column_type_id__volatile = 0;
	if (g_once_init_enter (&unity_filter_column_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_FILTER_COLUMN_ID, "UNITY_FILTER_COLUMN_ID", "id"}, {UNITY_FILTER_COLUMN_NAME, "UNITY_FILTER_COLUMN_NAME", "name"}, {UNITY_FILTER_COLUMN_ICON_HINT, "UNITY_FILTER_COLUMN_ICON_HINT", "icon-hint"}, {UNITY_FILTER_COLUMN_RENDERER_NAME, "UNITY_FILTER_COLUMN_RENDERER_NAME", "renderer-name"}, {UNITY_FILTER_COLUMN_RENDERER_STATE, "UNITY_FILTER_COLUMN_RENDERER_STATE", "renderer-state"}, {UNITY_FILTER_COLUMN_VISIBLE, "UNITY_FILTER_COLUMN_VISIBLE", "visible"}, {UNITY_FILTER_COLUMN_COLLAPSED, "UNITY_FILTER_COLUMN_COLLAPSED", "collapsed"}, {UNITY_FILTER_COLUMN_FILTERING, "UNITY_FILTER_COLUMN_FILTERING", "filtering"}, {0, NULL, NULL}};
		GType unity_filter_column_type_id;
		unity_filter_column_type_id = g_enum_register_static ("UnityFilterColumn", values);
		g_once_init_leave (&unity_filter_column_type_id__volatile, unity_filter_column_type_id);
	}
	return unity_filter_column_type_id__volatile;
}


GType unity_filter_renderer_get_type (void) {
	static volatile gsize unity_filter_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&unity_filter_renderer_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_FILTER_RENDERER_CHECK_OPTIONS, "UNITY_FILTER_RENDERER_CHECK_OPTIONS", "check-options"}, {UNITY_FILTER_RENDERER_RADIO_OPTIONS, "UNITY_FILTER_RENDERER_RADIO_OPTIONS", "radio-options"}, {UNITY_FILTER_RENDERER_MULTIRANGE, "UNITY_FILTER_RENDERER_MULTIRANGE", "multirange"}, {UNITY_FILTER_RENDERER_RATINGS, "UNITY_FILTER_RENDERER_RATINGS", "ratings"}, {UNITY_FILTER_RENDERER_CHECK_OPTIONS_COMPACT, "UNITY_FILTER_RENDERER_CHECK_OPTIONS_COMPACT", "check-options-compact"}, {0, NULL, NULL}};
		GType unity_filter_renderer_type_id;
		unity_filter_renderer_type_id = g_enum_register_static ("UnityFilterRenderer", values);
		g_once_init_leave (&unity_filter_renderer_type_id__volatile, unity_filter_renderer_type_id);
	}
	return unity_filter_renderer_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _unity_filter_on_row_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_filter_on_row_changed (self, _sender, iter);
}


void unity_filter_set_model_and_iter (UnityFilter* self, DeeModel* model, DeeModelIter* iter) {
	DeeModel* _tmp0_;
	DeeModel* _tmp1_;
	DeeModelIter* _tmp2_;
	DeeModel* _tmp3_;
	DeeModel* _tmp4_;
	DeeModelIter* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp1_;
	_tmp2_ = iter;
	self->priv->_iter = _tmp2_;
	_tmp3_ = self->priv->_model;
	g_signal_connect_object (_tmp3_, "row-changed", (GCallback) _unity_filter_on_row_changed_dee_model_row_changed, self, 0);
	_tmp4_ = model;
	_tmp5_ = iter;
	unity_filter_on_row_changed (self, _tmp4_, _tmp5_);
}


static void unity_filter_on_row_changed (UnityFilter* self, DeeModel* model, DeeModelIter* iter) {
	DeeModelIter* _tmp0_;
	DeeModelIter* _tmp1_;
	DeeModel* _tmp2_;
	DeeModelIter* _tmp3_;
	gboolean _tmp4_ = FALSE;
	DeeModel* _tmp5_;
	DeeModelIter* _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* properties;
	GVariant* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = iter;
	_tmp1_ = self->priv->_iter;
	if (_tmp0_ != _tmp1_) {
		return;
	}
	_tmp2_ = model;
	_tmp3_ = iter;
	_tmp4_ = dee_model_get_bool (_tmp2_, _tmp3_, (guint) UNITY_FILTER_COLUMN_FILTERING);
	unity_filter_set_filtering (self, _tmp4_);
	_tmp5_ = model;
	_tmp6_ = iter;
	_tmp7_ = dee_model_get_value (_tmp5_, _tmp6_, (guint) UNITY_FILTER_COLUMN_RENDERER_STATE);
	properties = _tmp7_;
	_tmp8_ = properties;
	unity_filter_update (self, _tmp8_);
	_g_variant_unref0 (properties);
}


static GHashTable* unity_filter_real_get_hints (UnityFilter* self) {
	g_critical ("Type `%s' does not implement abstract method `unity_filter_get_hints'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GHashTable* unity_filter_get_hints (UnityFilter* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return UNITY_FILTER_GET_CLASS (self)->get_hints (self);
}


static void unity_filter_real_update (UnityFilter* self, GVariant* properties) {
	g_critical ("Type `%s' does not implement abstract method `unity_filter_update'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_filter_update (UnityFilter* self, GVariant* properties) {
	g_return_if_fail (self != NULL);
	UNITY_FILTER_GET_CLASS (self)->update (self, properties);
}


const gchar* unity_filter_get_renderer_name (UnityFilterRenderer renderer) {
	const gchar* result = NULL;
	UnityFilterRenderer _tmp0_;
	_tmp0_ = renderer;
	switch (_tmp0_) {
		case UNITY_FILTER_RENDERER_CHECK_OPTIONS:
		{
			result = "filter-checkoption";
			return result;
		}
		case UNITY_FILTER_RENDERER_CHECK_OPTIONS_COMPACT:
		{
			result = "filter-checkoption-compact";
			return result;
		}
		case UNITY_FILTER_RENDERER_RADIO_OPTIONS:
		{
			result = "filter-radiooption";
			return result;
		}
		case UNITY_FILTER_RENDERER_RATINGS:
		{
			result = "filter-ratings";
			return result;
		}
		case UNITY_FILTER_RENDERER_MULTIRANGE:
		{
			result = "filter-multirange";
			return result;
		}
		default:
		{
			result = "invalid-renderer";
			return result;
		}
	}
}


UnityFilterRenderer unity_filter_renderer_for_name (const gchar* renderer_name) {
	UnityFilterRenderer result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	g_return_val_if_fail (renderer_name != NULL, 0);
	_tmp0_ = renderer_name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("filter-checkoption")))) {
		switch (0) {
			default:
			{
				result = UNITY_FILTER_RENDERER_CHECK_OPTIONS;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("filter-checkoption-compact")))) {
		switch (0) {
			default:
			{
				result = UNITY_FILTER_RENDERER_CHECK_OPTIONS_COMPACT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("filter-radiooption")))) {
		switch (0) {
			default:
			{
				result = UNITY_FILTER_RENDERER_RADIO_OPTIONS;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("filter-ratings")))) {
		switch (0) {
			default:
			{
				result = UNITY_FILTER_RENDERER_RATINGS;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("filter-multirange")))) {
		switch (0) {
			default:
			{
				result = UNITY_FILTER_RENDERER_MULTIRANGE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = UNITY_FILTER_RENDERER_RATINGS;
				return result;
			}
		}
	}
}


UnityFilter* unity_filter_construct (GType object_type) {
	UnityFilter * self = NULL;
	self = (UnityFilter*) g_object_new (object_type, NULL);
	return self;
}


const gchar* unity_filter_get_id (UnityFilter* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void unity_filter_set_id (UnityFilter* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* unity_filter_get_display_name (UnityFilter* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}


void unity_filter_set_display_name (UnityFilter* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	g_object_notify ((GObject *) self, "display-name");
}


GIcon* unity_filter_get_icon_hint (UnityFilter* self) {
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_hint;
	result = _tmp0_;
	return result;
}


static void unity_filter_set_icon_hint (UnityFilter* self, GIcon* value) {
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_icon_hint);
	self->priv->_icon_hint = _tmp1_;
	g_object_notify ((GObject *) self, "icon-hint");
}


UnityFilterRenderer unity_filter_get_renderer (UnityFilter* self) {
	UnityFilterRenderer result;
	UnityFilterRenderer _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_renderer;
	result = _tmp0_;
	return result;
}


static void unity_filter_set_renderer (UnityFilter* self, UnityFilterRenderer value) {
	UnityFilterRenderer _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_renderer = _tmp0_;
	g_object_notify ((GObject *) self, "renderer");
}


gboolean unity_filter_get_visible (UnityFilter* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_visible;
	result = _tmp0_;
	return result;
}


void unity_filter_set_visible (UnityFilter* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_visible = _tmp0_;
	g_object_notify ((GObject *) self, "visible");
}


gboolean unity_filter_get_collapsed (UnityFilter* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_collapsed;
	result = _tmp0_;
	return result;
}


static void unity_filter_set_collapsed (UnityFilter* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_collapsed = _tmp0_;
	g_object_notify ((GObject *) self, "collapsed");
}


gboolean unity_filter_get_filtering (UnityFilter* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_filtering;
	result = _tmp0_;
	return result;
}


void unity_filter_set_filtering (UnityFilter* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_filtering = _tmp0_;
	g_object_notify ((GObject *) self, "filtering");
}


static void unity_filter_class_init (UnityFilterClass * klass) {
	unity_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilterPrivate));
	UNITY_FILTER_CLASS (klass)->get_hints = unity_filter_real_get_hints;
	UNITY_FILTER_CLASS (klass)->update = unity_filter_real_update;
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_ICON_HINT, g_param_spec_object ("icon-hint", "icon-hint", "icon-hint", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_RENDERER, g_param_spec_enum ("renderer", "renderer", "renderer", UNITY_TYPE_FILTER_RENDERER, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_VISIBLE, g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_COLLAPSED, g_param_spec_boolean ("collapsed", "collapsed", "collapsed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_FILTERING, g_param_spec_boolean ("filtering", "filtering", "filtering", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("changed", UNITY_TYPE_FILTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_filter_instance_init (UnityFilter * self) {
	self->priv = UNITY_FILTER_GET_PRIVATE (self);
}


static void unity_filter_finalize (GObject* obj) {
	UnityFilter * self;
	self = UNITY_FILTER (obj);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_icon_hint);
	_g_object_unref0 (self->priv->_model);
	G_OBJECT_CLASS (unity_filter_parent_class)->finalize (obj);
}


GType unity_filter_get_type (void) {
	static volatile gsize unity_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilter), 0, (GInstanceInitFunc) unity_filter_instance_init, NULL };
		GType unity_filter_type_id;
		unity_filter_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&unity_filter_type_id__volatile, unity_filter_type_id);
	}
	return unity_filter_type_id__volatile;
}


static void _vala_unity_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilter * self;
	self = UNITY_FILTER (object);
	switch (property_id) {
		case UNITY_FILTER_ID:
		g_value_set_string (value, unity_filter_get_id (self));
		break;
		case UNITY_FILTER_DISPLAY_NAME:
		g_value_set_string (value, unity_filter_get_display_name (self));
		break;
		case UNITY_FILTER_ICON_HINT:
		g_value_set_object (value, unity_filter_get_icon_hint (self));
		break;
		case UNITY_FILTER_RENDERER:
		g_value_set_enum (value, unity_filter_get_renderer (self));
		break;
		case UNITY_FILTER_VISIBLE:
		g_value_set_boolean (value, unity_filter_get_visible (self));
		break;
		case UNITY_FILTER_COLLAPSED:
		g_value_set_boolean (value, unity_filter_get_collapsed (self));
		break;
		case UNITY_FILTER_FILTERING:
		g_value_set_boolean (value, unity_filter_get_filtering (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilter * self;
	self = UNITY_FILTER (object);
	switch (property_id) {
		case UNITY_FILTER_ID:
		unity_filter_set_id (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_DISPLAY_NAME:
		unity_filter_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_ICON_HINT:
		unity_filter_set_icon_hint (self, g_value_get_object (value));
		break;
		case UNITY_FILTER_RENDERER:
		unity_filter_set_renderer (self, g_value_get_enum (value));
		break;
		case UNITY_FILTER_VISIBLE:
		unity_filter_set_visible (self, g_value_get_boolean (value));
		break;
		case UNITY_FILTER_COLLAPSED:
		unity_filter_set_collapsed (self, g_value_get_boolean (value));
		break;
		case UNITY_FILTER_FILTERING:
		unity_filter_set_filtering (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityFilterOption* unity_filter_option_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean active) {
	UnityFilterOption * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GIcon* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = display_name;
	_tmp2_ = icon_hint;
	_tmp3_ = active;
	self = (UnityFilterOption*) g_object_new (object_type, "id", _tmp0_, "display-name", _tmp1_, "icon-hint", _tmp2_, "active", _tmp3_, NULL);
	return self;
}


UnityFilterOption* unity_filter_option_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean active) {
	return unity_filter_option_construct (UNITY_TYPE_FILTER_OPTION, id, display_name, icon_hint, active);
}


const gchar* unity_filter_option_get_id (UnityFilterOption* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void unity_filter_option_set_id (UnityFilterOption* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* unity_filter_option_get_display_name (UnityFilterOption* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}


static void unity_filter_option_set_display_name (UnityFilterOption* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	g_object_notify ((GObject *) self, "display-name");
}


GIcon* unity_filter_option_get_icon_hint (UnityFilterOption* self) {
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_hint;
	result = _tmp0_;
	return result;
}


static void unity_filter_option_set_icon_hint (UnityFilterOption* self, GIcon* value) {
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_icon_hint);
	self->priv->_icon_hint = _tmp1_;
	g_object_notify ((GObject *) self, "icon-hint");
}


gboolean unity_filter_option_get_active (UnityFilterOption* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


void unity_filter_option_set_active (UnityFilterOption* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_active = _tmp0_;
	g_object_notify ((GObject *) self, "active");
}


static void unity_filter_option_class_init (UnityFilterOptionClass * klass) {
	unity_filter_option_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilterOptionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_filter_option_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_filter_option_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_filter_option_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_OPTION_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_OPTION_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_OPTION_ICON_HINT, g_param_spec_object ("icon-hint", "icon-hint", "icon-hint", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_OPTION_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_filter_option_instance_init (UnityFilterOption * self) {
	self->priv = UNITY_FILTER_OPTION_GET_PRIVATE (self);
}


static void unity_filter_option_finalize (GObject* obj) {
	UnityFilterOption * self;
	self = UNITY_FILTER_OPTION (obj);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_icon_hint);
	G_OBJECT_CLASS (unity_filter_option_parent_class)->finalize (obj);
}


GType unity_filter_option_get_type (void) {
	static volatile gsize unity_filter_option_type_id__volatile = 0;
	if (g_once_init_enter (&unity_filter_option_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilterOptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_filter_option_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilterOption), 0, (GInstanceInitFunc) unity_filter_option_instance_init, NULL };
		GType unity_filter_option_type_id;
		unity_filter_option_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilterOption", &g_define_type_info, 0);
		g_once_init_leave (&unity_filter_option_type_id__volatile, unity_filter_option_type_id);
	}
	return unity_filter_option_type_id__volatile;
}


static void _vala_unity_filter_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilterOption * self;
	self = UNITY_FILTER_OPTION (object);
	switch (property_id) {
		case UNITY_FILTER_OPTION_ID:
		g_value_set_string (value, unity_filter_option_get_id (self));
		break;
		case UNITY_FILTER_OPTION_DISPLAY_NAME:
		g_value_set_string (value, unity_filter_option_get_display_name (self));
		break;
		case UNITY_FILTER_OPTION_ICON_HINT:
		g_value_set_object (value, unity_filter_option_get_icon_hint (self));
		break;
		case UNITY_FILTER_OPTION_ACTIVE:
		g_value_set_boolean (value, unity_filter_option_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_filter_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilterOption * self;
	self = UNITY_FILTER_OPTION (object);
	switch (property_id) {
		case UNITY_FILTER_OPTION_ID:
		unity_filter_option_set_id (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_OPTION_DISPLAY_NAME:
		unity_filter_option_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_OPTION_ICON_HINT:
		unity_filter_option_set_icon_hint (self, g_value_get_object (value));
		break;
		case UNITY_FILTER_OPTION_ACTIVE:
		unity_filter_option_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType unity_options_filter_sort_type_get_type (void) {
	static volatile gsize unity_options_filter_sort_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_options_filter_sort_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL, "UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL", "manual"}, {UNITY_OPTIONS_FILTER_SORT_TYPE_DISPLAY_NAME, "UNITY_OPTIONS_FILTER_SORT_TYPE_DISPLAY_NAME", "display-name"}, {UNITY_OPTIONS_FILTER_SORT_TYPE_ID, "UNITY_OPTIONS_FILTER_SORT_TYPE_ID", "id"}, {0, NULL, NULL}};
		GType unity_options_filter_sort_type_type_id;
		unity_options_filter_sort_type_type_id = g_enum_register_static ("UnityOptionsFilterSortType", values);
		g_once_init_leave (&unity_options_filter_sort_type_type_id__volatile, unity_options_filter_sort_type_type_id);
	}
	return unity_options_filter_sort_type_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gint _unity_options_filter_sort_by_display_name_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = unity_options_filter_sort_by_display_name (a, b);
	return result;
}


static gint _unity_options_filter_sort_by_id_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = unity_options_filter_sort_by_id (a, b);
	return result;
}


UnityFilterOption* unity_options_filter_add_option (UnityOptionsFilter* self, const gchar* id, const gchar* display_name, GIcon* icon_hint) {
	UnityFilterOption* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GIcon* _tmp2_;
	UnityFilterOption* _tmp3_;
	UnityFilterOption* option;
	UnityOptionsFilterSortType _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = display_name;
	_tmp2_ = icon_hint;
	_tmp3_ = unity_filter_option_new (_tmp0_, _tmp1_, _tmp2_, FALSE);
	option = _tmp3_;
	_tmp4_ = self->priv->_sort_type;
	switch (_tmp4_) {
		case UNITY_OPTIONS_FILTER_SORT_TYPE_DISPLAY_NAME:
		{
			UnityFilterOption* _tmp5_;
			UnityFilterOption* _tmp6_;
			_tmp5_ = option;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			self->options = g_list_insert_sorted (self->options, _tmp6_, _unity_options_filter_sort_by_display_name_gcompare_func);
			break;
		}
		case UNITY_OPTIONS_FILTER_SORT_TYPE_ID:
		{
			UnityFilterOption* _tmp7_;
			UnityFilterOption* _tmp8_;
			_tmp7_ = option;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			self->options = g_list_insert_sorted (self->options, _tmp8_, _unity_options_filter_sort_by_id_gcompare_func);
			break;
		}
		default:
		case UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL:
		{
			UnityFilterOption* _tmp9_;
			UnityFilterOption* _tmp10_;
			_tmp9_ = option;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			self->options = g_list_append (self->options, _tmp10_);
			break;
		}
	}
	g_signal_emit_by_name ((UnityFilter*) self, "changed");
	result = option;
	return result;
}


static gint unity_options_filter_sort_by_display_name (UnityFilterOption* f1, UnityFilterOption* f2) {
	gint result = 0;
	UnityFilterOption* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UnityFilterOption* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	g_return_val_if_fail (f1 != NULL, 0);
	g_return_val_if_fail (f2 != NULL, 0);
	_tmp0_ = f1;
	_tmp1_ = unity_filter_option_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = f2;
	_tmp4_ = unity_filter_option_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
	result = _tmp6_;
	return result;
}


static gint unity_options_filter_sort_by_id (UnityFilterOption* f1, UnityFilterOption* f2) {
	gint result = 0;
	UnityFilterOption* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UnityFilterOption* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	g_return_val_if_fail (f1 != NULL, 0);
	g_return_val_if_fail (f2 != NULL, 0);
	_tmp0_ = f1;
	_tmp1_ = unity_filter_option_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = f2;
	_tmp4_ = unity_filter_option_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
	result = _tmp6_;
	return result;
}


UnityFilterOption* unity_options_filter_get_option (UnityOptionsFilter* self, const gchar* id) {
	UnityFilterOption* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->options;
	{
		GList* option_collection = NULL;
		GList* option_it = NULL;
		option_collection = _tmp0_;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp1_;
			UnityFilterOption* option = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp1_;
			{
				UnityFilterOption* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp2_ = option;
				_tmp3_ = unity_filter_option_get_id (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = id;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					result = option;
					return result;
				}
				_g_object_unref0 (option);
			}
		}
	}
	result = NULL;
	return result;
}


/**
   * Removes a FilterOption from the OptionsFilter.
   *
   * @return: true if a FilterOption was removed, false if FilterOption with
   * given id couldn't be found.
   */
gboolean unity_options_filter_remove_option (UnityOptionsFilter* self, const gchar* id) {
	gboolean result = FALSE;
	GList* element;
	GList* _tmp13_;
	GList* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	element = NULL;
	{
		GList* _tmp0_;
		GList* _tmp1_ = NULL;
		GList* it;
		_tmp0_ = self->options;
		_tmp1_ = g_list_first (_tmp0_);
		it = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				GList* _tmp6_;
				GList* _tmp7_;
				gconstpointer _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					GList* _tmp4_;
					GList* _tmp5_;
					_tmp4_ = it;
					_tmp5_ = _tmp4_->next;
					it = _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = it;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = it;
				_tmp8_ = _tmp7_->data;
				_tmp9_ = unity_filter_option_get_id ((UnityFilterOption*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = id;
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
					GList* _tmp12_;
					_tmp12_ = it;
					element = _tmp12_;
					break;
				}
			}
		}
	}
	_tmp13_ = element;
	if (_tmp13_ != NULL) {
		GList* _tmp14_;
		GList* _tmp15_;
		_tmp14_ = element;
		_g_object_unref0 (_tmp14_->data);
		_tmp14_->data = NULL;
		_tmp15_ = element;
		self->options = g_list_delete_link (self->options, _tmp15_);
		g_signal_emit_by_name ((UnityFilter*) self, "changed");
	}
	_tmp16_ = element;
	result = _tmp16_ != NULL;
	return result;
}


static void unity_options_filter_real_update (UnityFilter* base, GVariant* properties) {
	UnityOptionsFilter * self;
	GVariantIter* iter = NULL;
	GVariant* _tmp0_;
	self = (UnityOptionsFilter*) base;
	g_return_if_fail (properties != NULL);
	_tmp0_ = properties;
	g_variant_get (_tmp0_, "a{sv}", &iter, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				GVariantIter* _tmp5_;
				gsize _tmp6_ = 0UL;
				gchar* key = NULL;
				GVariant* val = NULL;
				GVariantIter* _tmp7_;
				const gchar* _tmp8_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = iter;
				_tmp6_ = g_variant_iter_n_children (_tmp5_);
				if (!(((gsize) _tmp4_) < _tmp6_)) {
					break;
				}
				_tmp7_ = iter;
				g_variant_iter_next (_tmp7_, "{sv}", &key, &val, NULL);
				_tmp8_ = key;
				if (g_strcmp0 (_tmp8_, "options") == 0) {
					GVariant* _tmp9_;
					_tmp9_ = val;
					unity_options_filter_load_or_update_options (self, _tmp9_);
				}
				_g_variant_unref0 (val);
				_g_free0 (key);
			}
		}
	}
	g_signal_emit_by_name ((UnityFilter*) self, "changed");
	_g_variant_iter_free0 (iter);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void unity_options_filter_load_or_update_options (UnityOptionsFilter* self, GVariant* array) {
	GVariantIter* iter = NULL;
	GVariant* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** option_ids;
	gint option_ids_length1;
	gint _option_ids_size_;
	GList* _tmp16_;
	guint _tmp17_ = 0U;
	gchar** _tmp18_;
	gint _tmp18__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (array != NULL);
	_tmp0_ = array;
	g_variant_get (_tmp0_, "a(sssb)", &iter, NULL);
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	option_ids = _tmp1_;
	option_ids_length1 = 0;
	_option_ids_size_ = option_ids_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				GVariantIter* _tmp6_;
				gsize _tmp7_ = 0UL;
				gchar* b_id = NULL;
				gchar* b_name = NULL;
				gchar* b_icon_hint = NULL;
				gboolean b_active = FALSE;
				GVariantIter* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gboolean _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = iter;
				_tmp7_ = g_variant_iter_n_children (_tmp6_);
				if (!(((gsize) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = iter;
				g_variant_iter_next (_tmp8_, "(sssb)", &b_id, &b_name, &b_icon_hint, &b_active, NULL);
				_tmp9_ = b_id;
				_tmp10_ = b_name;
				_tmp11_ = b_icon_hint;
				_tmp12_ = b_active;
				unity_options_filter_find_and_update_option (self, _tmp9_, _tmp10_, _tmp11_, _tmp12_);
				_tmp13_ = option_ids;
				_tmp13__length1 = option_ids_length1;
				_tmp14_ = b_id;
				_tmp15_ = g_strdup (_tmp14_);
				_vala_array_add1 (&option_ids, &option_ids_length1, &_option_ids_size_, _tmp15_);
				_g_free0 (b_icon_hint);
				_g_free0 (b_name);
				_g_free0 (b_id);
			}
		}
	}
	_tmp16_ = self->options;
	_tmp17_ = g_list_length (_tmp16_);
	_tmp18_ = option_ids;
	_tmp18__length1 = option_ids_length1;
	if (_tmp17_ != ((guint) _tmp18__length1)) {
		GList* _tmp19_;
		GList* l;
		_tmp19_ = self->options;
		l = _tmp19_;
		while (TRUE) {
			GList* _tmp20_;
			GList* _tmp21_;
			gconstpointer _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* id;
			GList* _tmp25_;
			GList* to_remove;
			GList* _tmp26_;
			GList* _tmp27_;
			const gchar* _tmp28_;
			gchar** _tmp29_;
			gint _tmp29__length1;
			_tmp20_ = l;
			if (!(_tmp20_ != NULL)) {
				break;
			}
			_tmp21_ = l;
			_tmp22_ = _tmp21_->data;
			_tmp23_ = unity_filter_option_get_id ((UnityFilterOption*) _tmp22_);
			_tmp24_ = _tmp23_;
			id = _tmp24_;
			_tmp25_ = l;
			to_remove = _tmp25_;
			_tmp26_ = l;
			_tmp27_ = _tmp26_->next;
			l = _tmp27_;
			_tmp28_ = id;
			_tmp29_ = option_ids;
			_tmp29__length1 = option_ids_length1;
			if (!_vala_string_array_contains (_tmp29_, _tmp29__length1, _tmp28_)) {
				GList* _tmp30_;
				GList* _tmp31_;
				_tmp30_ = to_remove;
				_g_object_unref0 (_tmp30_->data);
				_tmp30_->data = NULL;
				_tmp31_ = to_remove;
				self->options = g_list_delete_link (self->options, _tmp31_);
			}
		}
	}
	option_ids = (_vala_array_free (option_ids, option_ids_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_iter_free0 (iter);
}


void unity_options_filter_find_and_update_option (UnityOptionsFilter* self, const gchar* id, const gchar* name, const gchar* icon_hint_s, gboolean active) {
	GList* _tmp0_;
	GIcon* icon_hint;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GIcon* _tmp17_;
	gboolean _tmp18_;
	UnityFilterOption* _tmp19_;
	UnityFilterOption* option;
	UnityFilterOption* _tmp20_;
	UnityFilterOption* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_hint_s != NULL);
	_tmp0_ = self->options;
	{
		GList* option_collection = NULL;
		GList* option_it = NULL;
		option_collection = _tmp0_;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp1_;
			UnityFilterOption* option = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp1_;
			{
				UnityFilterOption* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp2_ = option;
				_tmp3_ = unity_filter_option_get_id (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = id;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					UnityFilterOption* _tmp6_;
					gboolean _tmp7_;
					_tmp6_ = option;
					_tmp7_ = active;
					unity_filter_option_set_active (_tmp6_, _tmp7_);
					_g_object_unref0 (option);
					return;
				}
				_g_object_unref0 (option);
			}
		}
	}
	icon_hint = NULL;
	{
		const gchar* _tmp8_;
		_tmp8_ = icon_hint_s;
		if (g_strcmp0 (_tmp8_, "") != 0) {
			const gchar* _tmp9_;
			GIcon* _tmp10_ = NULL;
			GIcon* _tmp11_;
			_tmp9_ = icon_hint_s;
			_tmp10_ = g_icon_new_for_string (_tmp9_, &_inner_error_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
			_g_object_unref0 (icon_hint);
			icon_hint = _tmp11_;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = icon_hint_s;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("unity-lens-filters.vala:302: Unable to parse GIcon data '%s': %s", _tmp12_, _tmp14_);
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (icon_hint);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = id;
	_tmp16_ = name;
	_tmp17_ = icon_hint;
	_tmp18_ = active;
	_tmp19_ = unity_filter_option_new (_tmp15_, _tmp16_, _tmp17_, _tmp18_);
	option = _tmp19_;
	_tmp20_ = option;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	self->options = g_list_append (self->options, _tmp21_);
	_g_object_unref0 (option);
	_g_object_unref0 (icon_hint);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GHashTable* unity_options_filter_real_get_hints (UnityFilter* base) {
	UnityOptionsFilter * self;
	GHashTable* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* b;
	GList* _tmp4_;
	GHashTable* _tmp28_;
	GHashTable* hash;
	gchar* _tmp29_;
	GVariantBuilder* _tmp30_;
	GVariant* _tmp31_ = NULL;
	GVariant* _tmp32_;
	self = (UnityOptionsFilter*) base;
	_tmp0_ = g_variant_type_new ("a(sssb)");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	b = _tmp3_;
	_tmp4_ = self->options;
	{
		GList* option_collection = NULL;
		GList* option_it = NULL;
		option_collection = _tmp4_;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp5_;
			UnityFilterOption* option = NULL;
			_tmp5_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp5_;
			{
				gchar* _tmp6_ = NULL;
				UnityFilterOption* _tmp7_;
				GIcon* _tmp8_;
				GIcon* _tmp9_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* icon_string;
				GVariantBuilder* _tmp17_;
				UnityFilterOption* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				UnityFilterOption* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				UnityFilterOption* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				_tmp7_ = option;
				_tmp8_ = unity_filter_option_get_icon_hint (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ != NULL) {
					UnityFilterOption* _tmp10_;
					GIcon* _tmp11_;
					GIcon* _tmp12_;
					gchar* _tmp13_ = NULL;
					_tmp10_ = option;
					_tmp11_ = unity_filter_option_get_icon_hint (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_icon_to_string (_tmp12_);
					_g_free0 (_tmp6_);
					_tmp6_ = _tmp13_;
				} else {
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("");
					_g_free0 (_tmp6_);
					_tmp6_ = _tmp14_;
				}
				_tmp15_ = _tmp6_;
				_tmp16_ = g_strdup (_tmp15_);
				icon_string = _tmp16_;
				_tmp17_ = b;
				_tmp18_ = option;
				_tmp19_ = unity_filter_option_get_id (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = option;
				_tmp22_ = unity_filter_option_get_display_name (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = icon_string;
				_tmp25_ = option;
				_tmp26_ = unity_filter_option_get_active (_tmp25_);
				_tmp27_ = _tmp26_;
				g_variant_builder_add (_tmp17_, "(sssb)", _tmp20_, _tmp23_, _tmp24_, _tmp27_, NULL);
				_g_free0 (icon_string);
				_g_free0 (_tmp6_);
				_g_object_unref0 (option);
			}
		}
	}
	_tmp28_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	hash = _tmp28_;
	_tmp29_ = g_strdup ("options");
	_tmp30_ = b;
	_tmp31_ = g_variant_builder_end (_tmp30_);
	_tmp32_ = g_variant_ref_sink (_tmp31_);
	g_hash_table_insert (hash, _tmp29_, _tmp32_);
	result = hash;
	_g_variant_builder_unref0 (b);
	return result;
}


UnityOptionsFilter* unity_options_filter_construct (GType object_type) {
	UnityOptionsFilter * self = NULL;
	self = (UnityOptionsFilter*) unity_filter_construct (object_type);
	return self;
}


UnityOptionsFilter* unity_options_filter_new (void) {
	return unity_options_filter_construct (UNITY_TYPE_OPTIONS_FILTER);
}


UnityOptionsFilterSortType unity_options_filter_get_sort_type (UnityOptionsFilter* self) {
	UnityOptionsFilterSortType result;
	UnityOptionsFilterSortType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_sort_type;
	result = _tmp0_;
	return result;
}


void unity_options_filter_set_sort_type (UnityOptionsFilter* self, UnityOptionsFilterSortType value) {
	UnityOptionsFilterSortType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_sort_type = _tmp0_;
	g_object_notify ((GObject *) self, "sort-type");
}


static void unity_options_filter_class_init (UnityOptionsFilterClass * klass) {
	unity_options_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityOptionsFilterPrivate));
	UNITY_FILTER_CLASS (klass)->update = unity_options_filter_real_update;
	UNITY_FILTER_CLASS (klass)->get_hints = unity_options_filter_real_get_hints;
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_options_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_options_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_options_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_OPTIONS_FILTER_SORT_TYPE, g_param_spec_enum ("sort-type", "sort-type", "sort-type", UNITY_OPTIONS_FILTER_TYPE_SORT_TYPE, UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_options_filter_instance_init (UnityOptionsFilter * self) {
	self->priv = UNITY_OPTIONS_FILTER_GET_PRIVATE (self);
	self->priv->_sort_type = UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL;
}


static void unity_options_filter_finalize (GObject* obj) {
	UnityOptionsFilter * self;
	self = UNITY_OPTIONS_FILTER (obj);
	__g_list_free__g_object_unref0_0 (self->options);
	G_OBJECT_CLASS (unity_options_filter_parent_class)->finalize (obj);
}


GType unity_options_filter_get_type (void) {
	static volatile gsize unity_options_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_options_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityOptionsFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_options_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityOptionsFilter), 0, (GInstanceInitFunc) unity_options_filter_instance_init, NULL };
		GType unity_options_filter_type_id;
		unity_options_filter_type_id = g_type_register_static (UNITY_TYPE_FILTER, "UnityOptionsFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_options_filter_type_id__volatile, unity_options_filter_type_id);
	}
	return unity_options_filter_type_id__volatile;
}


static void _vala_unity_options_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityOptionsFilter * self;
	self = UNITY_OPTIONS_FILTER (object);
	switch (property_id) {
		case UNITY_OPTIONS_FILTER_SORT_TYPE:
		g_value_set_enum (value, unity_options_filter_get_sort_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_options_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityOptionsFilter * self;
	self = UNITY_OPTIONS_FILTER (object);
	switch (property_id) {
		case UNITY_OPTIONS_FILTER_SORT_TYPE:
		unity_options_filter_set_sort_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityRadioOptionFilter* unity_radio_option_filter_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityRadioOptionFilter * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GIcon* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = display_name;
	_tmp2_ = icon_hint;
	_tmp3_ = collapsed;
	self = (UnityRadioOptionFilter*) g_object_new (object_type, "id", _tmp0_, "display-name", _tmp1_, "icon-hint", _tmp2_, "collapsed", _tmp3_, "renderer", UNITY_FILTER_RENDERER_RADIO_OPTIONS, "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityRadioOptionFilter* unity_radio_option_filter_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_radio_option_filter_construct (UNITY_TYPE_RADIO_OPTION_FILTER, id, display_name, icon_hint, collapsed);
}


UnityFilterOption* unity_radio_option_filter_get_active_option (UnityRadioOptionFilter* self) {
	UnityFilterOption* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((UnityOptionsFilter*) self)->options;
	{
		GList* option_collection = NULL;
		GList* option_it = NULL;
		option_collection = _tmp0_;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp1_;
			UnityFilterOption* option = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp1_;
			{
				UnityFilterOption* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = option;
				_tmp3_ = unity_filter_option_get_active (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					result = option;
					return result;
				}
				_g_object_unref0 (option);
			}
		}
	}
	result = NULL;
	return result;
}


static void unity_radio_option_filter_class_init (UnityRadioOptionFilterClass * klass) {
	unity_radio_option_filter_parent_class = g_type_class_peek_parent (klass);
}


static void unity_radio_option_filter_instance_init (UnityRadioOptionFilter * self) {
}


GType unity_radio_option_filter_get_type (void) {
	static volatile gsize unity_radio_option_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_radio_option_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityRadioOptionFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_radio_option_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityRadioOptionFilter), 0, (GInstanceInitFunc) unity_radio_option_filter_instance_init, NULL };
		GType unity_radio_option_filter_type_id;
		unity_radio_option_filter_type_id = g_type_register_static (UNITY_TYPE_OPTIONS_FILTER, "UnityRadioOptionFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_radio_option_filter_type_id__volatile, unity_radio_option_filter_type_id);
	}
	return unity_radio_option_filter_type_id__volatile;
}


UnityCheckOptionFilter* unity_check_option_filter_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityCheckOptionFilter * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GIcon* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = display_name;
	_tmp2_ = icon_hint;
	_tmp3_ = collapsed;
	self = (UnityCheckOptionFilter*) g_object_new (object_type, "id", _tmp0_, "display-name", _tmp1_, "icon-hint", _tmp2_, "collapsed", _tmp3_, "renderer", UNITY_FILTER_RENDERER_CHECK_OPTIONS, "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityCheckOptionFilter* unity_check_option_filter_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_check_option_filter_construct (UNITY_TYPE_CHECK_OPTION_FILTER, id, display_name, icon_hint, collapsed);
}


static void unity_check_option_filter_class_init (UnityCheckOptionFilterClass * klass) {
	unity_check_option_filter_parent_class = g_type_class_peek_parent (klass);
}


static void unity_check_option_filter_instance_init (UnityCheckOptionFilter * self) {
}


GType unity_check_option_filter_get_type (void) {
	static volatile gsize unity_check_option_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_check_option_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityCheckOptionFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_check_option_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityCheckOptionFilter), 0, (GInstanceInitFunc) unity_check_option_filter_instance_init, NULL };
		GType unity_check_option_filter_type_id;
		unity_check_option_filter_type_id = g_type_register_static (UNITY_TYPE_OPTIONS_FILTER, "UnityCheckOptionFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_check_option_filter_type_id__volatile, unity_check_option_filter_type_id);
	}
	return unity_check_option_filter_type_id__volatile;
}


UnityCheckOptionFilterCompact* unity_check_option_filter_compact_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityCheckOptionFilterCompact * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GIcon* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = display_name;
	_tmp2_ = icon_hint;
	_tmp3_ = collapsed;
	self = (UnityCheckOptionFilterCompact*) g_object_new (object_type, "id", _tmp0_, "display-name", _tmp1_, "icon-hint", _tmp2_, "collapsed", _tmp3_, "renderer", UNITY_FILTER_RENDERER_CHECK_OPTIONS_COMPACT, "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityCheckOptionFilterCompact* unity_check_option_filter_compact_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_check_option_filter_compact_construct (UNITY_TYPE_CHECK_OPTION_FILTER_COMPACT, id, display_name, icon_hint, collapsed);
}


static void unity_check_option_filter_compact_class_init (UnityCheckOptionFilterCompactClass * klass) {
	unity_check_option_filter_compact_parent_class = g_type_class_peek_parent (klass);
}


static void unity_check_option_filter_compact_instance_init (UnityCheckOptionFilterCompact * self) {
}


GType unity_check_option_filter_compact_get_type (void) {
	static volatile gsize unity_check_option_filter_compact_type_id__volatile = 0;
	if (g_once_init_enter (&unity_check_option_filter_compact_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityCheckOptionFilterCompactClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_check_option_filter_compact_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityCheckOptionFilterCompact), 0, (GInstanceInitFunc) unity_check_option_filter_compact_instance_init, NULL };
		GType unity_check_option_filter_compact_type_id;
		unity_check_option_filter_compact_type_id = g_type_register_static (UNITY_TYPE_OPTIONS_FILTER, "UnityCheckOptionFilterCompact", &g_define_type_info, 0);
		g_once_init_leave (&unity_check_option_filter_compact_type_id__volatile, unity_check_option_filter_compact_type_id);
	}
	return unity_check_option_filter_compact_type_id__volatile;
}


UnityRatingsFilter* unity_ratings_filter_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityRatingsFilter * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GIcon* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = display_name;
	_tmp2_ = icon_hint;
	_tmp3_ = collapsed;
	self = (UnityRatingsFilter*) g_object_new (object_type, "id", _tmp0_, "display-name", _tmp1_, "icon-hint", _tmp2_, "collapsed", _tmp3_, "renderer", UNITY_FILTER_RENDERER_RATINGS, "rating", 0.0f, "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityRatingsFilter* unity_ratings_filter_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_ratings_filter_construct (UNITY_TYPE_RATINGS_FILTER, id, display_name, icon_hint, collapsed);
}


static void unity_ratings_filter_real_update (UnityFilter* base, GVariant* properties) {
	UnityRatingsFilter * self;
	GVariantIter* iter = NULL;
	GVariant* _tmp0_;
	self = (UnityRatingsFilter*) base;
	g_return_if_fail (properties != NULL);
	_tmp0_ = properties;
	g_variant_get (_tmp0_, "a{sv}", &iter, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				GVariantIter* _tmp5_;
				gsize _tmp6_ = 0UL;
				gchar* key = NULL;
				GVariant* val = NULL;
				GVariantIter* _tmp7_;
				const gchar* _tmp8_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = iter;
				_tmp6_ = g_variant_iter_n_children (_tmp5_);
				if (!(((gsize) _tmp4_) < _tmp6_)) {
					break;
				}
				_tmp7_ = iter;
				g_variant_iter_next (_tmp7_, "{sv}", &key, &val, NULL);
				_tmp8_ = key;
				if (g_strcmp0 (_tmp8_, "rating") == 0) {
					GVariant* _tmp9_;
					gdouble _tmp10_ = 0.0;
					_tmp9_ = val;
					_tmp10_ = g_variant_get_double (_tmp9_);
					unity_ratings_filter_set_rating (self, (gfloat) _tmp10_);
				}
				_g_variant_unref0 (val);
				_g_free0 (key);
			}
		}
	}
	g_signal_emit_by_name ((UnityFilter*) self, "changed");
	_g_variant_iter_free0 (iter);
}


static GVariant* _variant_new16 (gdouble value) {
	return g_variant_ref_sink (g_variant_new_double (value));
}


static GHashTable* unity_ratings_filter_real_get_hints (UnityFilter* base) {
	UnityRatingsFilter * self;
	GHashTable* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* hash;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	self = (UnityRatingsFilter*) base;
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	hash = _tmp0_;
	_tmp1_ = g_strdup ("rating");
	_tmp2_ = _variant_new16 (0.0);
	g_hash_table_insert (hash, _tmp1_, _tmp2_);
	result = hash;
	return result;
}


gfloat unity_ratings_filter_get_rating (UnityRatingsFilter* self) {
	gfloat result;
	gfloat _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->_rating;
	result = _tmp0_;
	return result;
}


void unity_ratings_filter_set_rating (UnityRatingsFilter* self, gfloat value) {
	gfloat _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rating = _tmp0_;
	g_object_notify ((GObject *) self, "rating");
}


static void unity_ratings_filter_class_init (UnityRatingsFilterClass * klass) {
	unity_ratings_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityRatingsFilterPrivate));
	UNITY_FILTER_CLASS (klass)->update = unity_ratings_filter_real_update;
	UNITY_FILTER_CLASS (klass)->get_hints = unity_ratings_filter_real_get_hints;
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_ratings_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_ratings_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_ratings_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_RATINGS_FILTER_RATING, g_param_spec_float ("rating", "rating", "rating", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_ratings_filter_instance_init (UnityRatingsFilter * self) {
	self->priv = UNITY_RATINGS_FILTER_GET_PRIVATE (self);
}


static void unity_ratings_filter_finalize (GObject* obj) {
	UnityRatingsFilter * self;
	self = UNITY_RATINGS_FILTER (obj);
	G_OBJECT_CLASS (unity_ratings_filter_parent_class)->finalize (obj);
}


GType unity_ratings_filter_get_type (void) {
	static volatile gsize unity_ratings_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_ratings_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityRatingsFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_ratings_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityRatingsFilter), 0, (GInstanceInitFunc) unity_ratings_filter_instance_init, NULL };
		GType unity_ratings_filter_type_id;
		unity_ratings_filter_type_id = g_type_register_static (UNITY_TYPE_FILTER, "UnityRatingsFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_ratings_filter_type_id__volatile, unity_ratings_filter_type_id);
	}
	return unity_ratings_filter_type_id__volatile;
}


static void _vala_unity_ratings_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityRatingsFilter * self;
	self = UNITY_RATINGS_FILTER (object);
	switch (property_id) {
		case UNITY_RATINGS_FILTER_RATING:
		g_value_set_float (value, unity_ratings_filter_get_rating (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_ratings_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityRatingsFilter * self;
	self = UNITY_RATINGS_FILTER (object);
	switch (property_id) {
		case UNITY_RATINGS_FILTER_RATING:
		unity_ratings_filter_set_rating (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityMultiRangeFilter* unity_multi_range_filter_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityMultiRangeFilter * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GIcon* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = display_name;
	_tmp2_ = icon_hint;
	_tmp3_ = collapsed;
	self = (UnityMultiRangeFilter*) g_object_new (object_type, "id", _tmp0_, "display-name", _tmp1_, "icon-hint", _tmp2_, "collapsed", _tmp3_, "renderer", UNITY_FILTER_RENDERER_MULTIRANGE, "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityMultiRangeFilter* unity_multi_range_filter_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_multi_range_filter_construct (UNITY_TYPE_MULTI_RANGE_FILTER, id, display_name, icon_hint, collapsed);
}


UnityFilterOption* unity_multi_range_filter_get_first_active (UnityMultiRangeFilter* self) {
	UnityFilterOption* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((UnityOptionsFilter*) self)->options;
	{
		GList* option_collection = NULL;
		GList* option_it = NULL;
		option_collection = _tmp0_;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp1_;
			UnityFilterOption* option = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp1_;
			{
				UnityFilterOption* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = option;
				_tmp3_ = unity_filter_option_get_active (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					result = option;
					return result;
				}
				_g_object_unref0 (option);
			}
		}
	}
	result = NULL;
	return result;
}


UnityFilterOption* unity_multi_range_filter_get_last_active (UnityMultiRangeFilter* self) {
	UnityFilterOption* result = NULL;
	UnityFilterOption* ret;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	_tmp0_ = ((UnityOptionsFilter*) self)->options;
	{
		GList* option_collection = NULL;
		GList* option_it = NULL;
		option_collection = _tmp0_;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp1_;
			UnityFilterOption* option = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp1_;
			{
				UnityFilterOption* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = option;
				_tmp3_ = unity_filter_option_get_active (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					UnityFilterOption* _tmp5_;
					UnityFilterOption* _tmp6_;
					_tmp5_ = option;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (ret);
					ret = _tmp6_;
				}
				_g_object_unref0 (option);
			}
		}
	}
	result = ret;
	return result;
}


static void unity_multi_range_filter_class_init (UnityMultiRangeFilterClass * klass) {
	unity_multi_range_filter_parent_class = g_type_class_peek_parent (klass);
}


static void unity_multi_range_filter_instance_init (UnityMultiRangeFilter * self) {
}


GType unity_multi_range_filter_get_type (void) {
	static volatile gsize unity_multi_range_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_multi_range_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMultiRangeFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_multi_range_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMultiRangeFilter), 0, (GInstanceInitFunc) unity_multi_range_filter_instance_init, NULL };
		GType unity_multi_range_filter_type_id;
		unity_multi_range_filter_type_id = g_type_register_static (UNITY_TYPE_OPTIONS_FILTER, "UnityMultiRangeFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_multi_range_filter_type_id__volatile, unity_multi_range_filter_type_id);
	}
	return unity_multi_range_filter_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



