'\" t
.\" Manual page created with latex2man on Thu Aug  5 10:00:51 CEST 2004
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_INIT\\_LOCAL" "3" "05 August 2004" "Programming Library " "Programming Library "
.SH NAME
unw_init_local
\-\- initialize cursor for local unwinding 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_init_local(unw_cursor_t *c,
unw_context_t *ctxt);
.br
.PP
.SH DESCRIPTION

.PP
The unw_init_local()
routine initializes the unwind cursor 
pointed to by c
with the machine\-state in the context structure 
pointed to by ctxt\&.
As such, the machine\-state pointed to by 
ctxt
identifies the initial stack frame at which unwinding 
starts. The machine\-state must remain valid for the duration for 
which the cursor c
is in use. 
.PP
The unw_init_local()
routine can be used only for unwinding in 
the address space of the current process (i.e., for local unwinding). 
For all other cases, unw_init_remote()
must be used instead. 
From a behavioral point of view, the call: 
.PP
.Vb
    ret = unw_init_local(&cursor, &ucontext);
.Ve
is equivalent to: 
.PP
.Vb
    ret = unw_init_remote(&cursor, unw_local_addr_space,
                          &ucontext);
.Ve
However, unwind performance may be better when using 
unw_init_local().
Also, unw_init_local()
is 
available even when UNW_LOCAL_ONLY
has been defined before 
including <libunwind.h>,
whereas unw_init_remote()
is not. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_init_local()
returns 0. 
Otherwise the negative value of one of the error\-codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_init_local()
is thread\-safe as well as safe to use from a 
signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EINVAL
 unw_init_local()
was called in a 
version of libunwind
which supports remote unwinding only 
(this normally happens when calling unw_init_local()
for a 
cross\-platform version of libunwind).
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_EBADREG
 A register needed by unw_init_local()
wasn\&'t accessible. 
.PP
.SH SEE ALSO

.PP
libunwind(3),
unw_init_remote(3)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br 
Hewlett\-Packard Labs
.br 
Palo\-Alto, CA 94304
.br 
Email: \fBdavidm@hpl.hp.com\fP
.br
WWW: \fBhttp://www.hpl.hp.com/research/linux/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
