.\" Converted with mdoc2man 0.2
.\" from NiH: zip_set_archive_comment.mdoc,v 1.1 2006/04/23 12:47:30 wiz Exp 
.\" $NiH: zip_set_archive_comment.mdoc,v 1.1 2006/04/23 12:47:30 wiz Exp $
.\"
.\" zip_set_archive_comment.mdoc \-- set zip archive comment
.\" Copyright (C) 2006 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_SET_ARCHIVE_COMMENT 3 "April 23, 2006" NiH
.SH "NAME"
zip_set_archive_comment \- set zip archive comment
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
int
zip_set_archive_comment(struct zip *archive); \
"const char *comment" "int *lenp"
.SH "DESCRIPTION"
The
zip_set_archive_comment
function sets the comment for the entire zip archive.
If
\fBcomment\fR
is
\fBNULL\fR
and
\fBlen\fR
is 0, the archive comment will be removed.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_set_archive_comment
fails if:
.RS
.TP 4
[ZIP_ER_INVAL]
\fBlen\fR
is less than 0 or longer than the maximum comment length in a zip file
(65535).
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.RE
.SH "SEE ALSO"
libzip(3),
zip_get_archive_comment(3),
zip_get_file_comment(3),
zip_set_file_comment(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
