#!/bin/sh

if [ `grep -qs '^Purpose: PRIMARY' /CurrentlyBuilding; echo $?` -ne 0 ] ||
   [ `grep -Pqs '^Component: main|restricted' /CurrentlyBuilding; echo $?` -ne 0 ]; then
    echo "No primary archive build or not targetting main|restricted -> not generating l10n content."
    exit 0
fi

if [ "`dpkg-architecture -qDEB_BUILD_ARCH`" != "i386" ]; then
    echo "No i386 build -> not generating l10n content."
    exit 0
fi

# Generating translation templates for general messages as well as those
# extractable from XML files.
mkdir -p po
extract-messages.sh
extract-xml.sh
if [ -n "$(ls -A po/)" ]; then
  for file in po/*pot; do
      sed "s/charset=CHARSET/charset=UTF-8/" -i $file;
  done
fi
