# Only include the folling if we are on a buildd AND doing a PRIMARY/archive 
# build AND the architecture is i386.
ifeq ($(shell grep -qs '^Purpose: PRIMARY' /CurrentlyBuilding && echo 0),0)
ifeq ($(shell grep -Pqs '^Component: main|restricted' /CurrentlyBuilding && echo 0),0)

DEB_BUILD_ARCH := $(shell dpkg-architecture -qDEB_BUILD_ARCH)

clean::
ifeq ($(DEB_BUILD_ARCH),i386)
	if [ -z $${KUBUNTU_NO_DELETE_POT} ]; then \
	    rm -rf po/*.pot; \
	fi;
else
	@echo "No i386 build -> not cleaning l10n content."
endif

#Kubuntu specific, Launchpad translations support, create .pot translation templates
common-install-prehook-impl::
ifeq ($(DEB_BUILD_ARCH),i386)
	mkdir -p po
	extract-messages.sh
	extract-xml.sh
	-for file in po/*pot; do \
		sed "s/charset=CHARSET/charset=UTF-8/" -i $$file; \
	done
else
	@echo "No i386 build -> not generating l10n content."
endif

endif
endif
