Index: b/setup.py
===================================================================
--- a/setup.py
+++ b/setup.py
@@ -7,7 +7,13 @@
 import sys
 
 from distutils.command.build_ext import build_ext
-from distutils import sysconfig
+try:
+    import sysconfig
+    host_platform = sysconfig.get_platform()
+except:
+    from distutils import sysconfig
+    host_platform = sys.platform
+
 from setuptools import Extension, setup, find_packages
 
 
@@ -68,6 +74,7 @@
     import _tkinter
 except ImportError:
     _tkinter = None
+    print('XXXXX _tkinter not found XXXXX')
 
 
 NAME = 'Pillow'
@@ -83,6 +90,38 @@
 
 class pil_build_ext(build_ext):
 
+    def add_gcc_paths(self):
+        gcc = sysconfig.get_config_var('CC')
+        tmpfile = os.path.join(self.build_temp, 'gccpaths')
+        if not os.path.exists(self.build_temp):
+            os.makedirs(self.build_temp)
+        ret = os.system('%s -E -v - </dev/null 2>%s 1>/dev/null' % (gcc, tmpfile))
+        is_gcc = False
+        in_incdirs = False
+        inc_dirs = []
+        lib_dirs = []
+        try:
+            if ret >> 8 == 0:
+                with open(tmpfile) as fp:
+                    for line in fp.readlines():
+                        if line.startswith("gcc version"):
+                            is_gcc = True
+                        elif line.startswith("#include <...>"):
+                            in_incdirs = True
+                        elif line.startswith("End of search list"):
+                            in_incdirs = False
+                        elif is_gcc and line.startswith("LIBRARY_PATH"):
+                            for d in line.strip().split("=")[1].split(":"):
+                                d = os.path.normpath(d)
+                                if '/gcc/' not in d:
+                                    _add_directory(self.compiler.library_dirs,
+                                                   d)
+                        elif is_gcc and in_incdirs and '/gcc/' not in line:
+                            _add_directory(self.compiler.include_dirs,
+                                           line.strip())
+        finally:
+            os.unlink(tmpfile)
+
     def build_extensions(self):
 
         global TCL_ROOT
@@ -107,12 +146,12 @@
         #
         # add platform directories
 
-        if sys.platform == "cygwin":
+        if host_platform == "cygwin":
             # pythonX.Y.dll.a is in the /usr/lib/pythonX.Y/config directory
             _add_directory(library_dirs, os.path.join(
                 "/usr/lib", "python%s" % sys.version[:3], "config"))
 
-        elif sys.platform == "darwin":
+        elif host_platform == "darwin":
             # attempt to make sure we pick freetype2 over other versions
             _add_directory(include_dirs, "/sw/include/freetype2")
             _add_directory(include_dirs, "/sw/lib/freetype2/include")
@@ -126,10 +165,8 @@
             _add_directory(library_dirs, "/usr/X11/lib")
             _add_directory(include_dirs, "/usr/X11/include")
 
-        elif sys.platform.startswith("linux"):
-            # XXX Kludge. Above /\ we brute force support multiarch. Here we
-            # try Barry's more general approach. Afterward, something should
-            # work ;-)
+        elif host_platform.startswith("linux"):
+            self.add_gcc_paths()
             self.add_multiarch_paths()
 
         _add_directory(library_dirs, "/usr/local/lib")
@@ -204,13 +241,13 @@
         if _find_include_file(self, "zlib.h"):
             if _find_library_file(self, "z"):
                 feature.zlib = "z"
-            elif sys.platform == "win32" and _find_library_file(self, "zlib"):
+            elif host_platform == "win32" and _find_library_file(self, "zlib"):
                 feature.zlib = "zlib"  # alternative name
 
         if _find_include_file(self, "jpeglib.h"):
             if _find_library_file(self, "jpeg"):
                 feature.jpeg = "jpeg"
-            elif sys.platform == "win32" and _find_library_file(self,
+            elif host_platform == "win32" and _find_library_file(self,
                     "libjpeg"):
                 feature.jpeg = "libjpeg"  # alternative name
 
@@ -271,7 +308,7 @@
         if feature.zlib:
             libs.append(feature.zlib)
             defs.append(("HAVE_LIBZ", None))
-        if sys.platform == "win32":
+        if host_platform == "win32":
             libs.extend(["kernel32", "user32", "gdi32"])
         if struct.unpack("h", "\0\1".encode('ascii'))[0] == 1:
             defs.append(("WORDS_BIGENDIAN", None))
@@ -296,12 +333,12 @@
 
         if os.path.isfile("_imagingcms.c") and feature.lcms:
             extra = []
-            if sys.platform == "win32":
+            if host_platform == "win32":
                 extra.extend(["user32", "gdi32"])
             exts.append(Extension(
                 "_imagingcms", ["_imagingcms.c"], libraries=["lcms"] + extra))
 
-        if sys.platform == "darwin":
+        if host_platform == "darwin":
             # locate Tcl/Tk frameworks
             frameworks = []
             framework_roots = [
@@ -351,7 +388,7 @@
         print("-" * 68)
         print("version      %s" % VERSION)
         v = sys.version.split("[")
-        print("platform     %s %s" % (sys.platform, v[0].strip()))
+        print("platform     %s %s" % (host_platform, v[0].strip()))
         for v in v[1:]:
             print("             [%s" % v.strip())
         print("-" * 68)
