
from qt import QFrame, QHBoxLayout, QVBoxLayout, QTimer, SIGNAL, QString
from kdecore import i18n, KConfigSkeleton
from kdeui import KPushButton, KConfigDialog, KTextEdit

iconName = 'configure'
labelText = 'KConfigDialog'
docParts = ('kdeui', 'KConfigDialog')
helpText = ("")


class SampleSettings(KConfigSkeleton):
    def __init__(self):
        KConfigSkeleton.__init__(self)
        self.anyString = QString()

        self.setCurrentGroup("Strings")
        self.addItemString("Test", self.anyString, "Default Value")

        self.setCurrentGroup("Booleans")
        self.addItemBool("Any Bool", False)


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Config Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showConfigDialog)


    def showConfigDialog(self):
        config = SampleSettings()
        dlg = KConfigDialog(self, 'Sampler Config', config)
        self.strings = StringsSettings(self)
        self.bools = BoolSettings(self)
        dlg.addPage(self.strings, 'Strings', 'Strings')
        dlg.addPage(self.bools, 'Bools', 'Bools')        
        dlg.exec_loop()


class StringsSettings(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.text = KTextEdit('A String', '', self)


class BoolSettings(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.text = KTextEdit('A Bool', '', self)
            
