""" Testing utils - run this test with 'python -m testing.test_utils' """

import unittest
import launchpadbugs.utils as utils

class _utilsTest(unittest.TestCase):
    invalid_url = ["","www.google.de"]
    url = { "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521": "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521",
            "/ubuntu/+source/bughelper/+bug/88521": "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521",
            "launchpad.net/ubuntu/+source/bughelper/+bug/88521": "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521",
            "https://launchpad.net/bugs/88521": "https://launchpad.net/bugs/88521",
            "bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521": "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521",
            "/ubuntu/+source/bughelper/+bug/88521/+editpage": "https://bugs.launchpad.net/ubuntu/+source/bughelper/+bug/88521/+editpage",
            "/buglog-data/+bug/120593/attachments/120512": "https://bugs.launchpad.net/buglog-data/+bug/120593/attachments/120512"}
            
    def test_valid_lp_url(self):
        for k,i in _utilsTest.url.iteritems():
            self.assertEqual(utils.valid_lp_url(k, utils.BUG), i)
            
    def test_valid_lp_url_error(self):
        for i in _utilsTest.invalid_url:
            self.assertRaises(ValueError, utils.valid_lp_url, i, utils.BUG)
    

if __name__ == '__main__':
    suite = unittest.TestLoader().loadTestsFromTestCase(_utilsTest)
    unittest.TextTestRunner(verbosity=2).run(suite)
