/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFESpotLightElement.h"

#include "JSSVGAnimatedNumber.h"
#include "SVGFESpotLightElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFESpotLightElement);

/* Hash table */

static const HashTableValue JSSVGFESpotLightElementTableValues[10] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementX), (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementY), (intptr_t)0 },
    { "z", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementZ), (intptr_t)0 },
    { "pointsAtX", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementPointsAtX), (intptr_t)0 },
    { "pointsAtY", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementPointsAtY), (intptr_t)0 },
    { "pointsAtZ", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementPointsAtZ), (intptr_t)0 },
    { "specularExponent", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementSpecularExponent), (intptr_t)0 },
    { "limitingConeAngle", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementLimitingConeAngle), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFESpotLightElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFESpotLightElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGFESpotLightElementTableValues, 0 };
#else
    { 32, 31, JSSVGFESpotLightElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGFESpotLightElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFESpotLightElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFESpotLightElementConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGFESpotLightElementConstructorTableValues, 0 };
#endif

class JSSVGFESpotLightElementConstructor : public DOMConstructorObject {
public:
    JSSVGFESpotLightElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGFESpotLightElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGFESpotLightElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGFESpotLightElementConstructor::s_info = { "SVGFESpotLightElementConstructor", 0, &JSSVGFESpotLightElementConstructorTable, 0 };

bool JSSVGFESpotLightElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFESpotLightElementConstructor, DOMObject>(exec, &JSSVGFESpotLightElementConstructorTable, this, propertyName, slot);
}

bool JSSVGFESpotLightElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFESpotLightElementConstructor, DOMObject>(exec, &JSSVGFESpotLightElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFESpotLightElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFESpotLightElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFESpotLightElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGFESpotLightElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFESpotLightElementPrototype::s_info = { "SVGFESpotLightElementPrototype", 0, &JSSVGFESpotLightElementPrototypeTable, 0 };

JSObject* JSSVGFESpotLightElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFESpotLightElement>(exec, globalObject);
}

const ClassInfo JSSVGFESpotLightElement::s_info = { "SVGFESpotLightElement", &JSSVGElement::s_info, &JSSVGFESpotLightElementTable, 0 };

JSSVGFESpotLightElement::JSSVGFESpotLightElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFESpotLightElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGFESpotLightElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFESpotLightElementPrototype(JSSVGFESpotLightElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFESpotLightElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFESpotLightElement, Base>(exec, &JSSVGFESpotLightElementTable, this, propertyName, slot);
}

bool JSSVGFESpotLightElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFESpotLightElement, Base>(exec, &JSSVGFESpotLightElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFESpotLightElementX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* castedThis = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpotLightElement* imp = static_cast<SVGFESpotLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFESpotLightElementY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* castedThis = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpotLightElement* imp = static_cast<SVGFESpotLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFESpotLightElementZ(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* castedThis = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpotLightElement* imp = static_cast<SVGFESpotLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->zAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFESpotLightElementPointsAtX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* castedThis = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpotLightElement* imp = static_cast<SVGFESpotLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->pointsAtXAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFESpotLightElementPointsAtY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* castedThis = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpotLightElement* imp = static_cast<SVGFESpotLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->pointsAtYAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFESpotLightElementPointsAtZ(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* castedThis = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpotLightElement* imp = static_cast<SVGFESpotLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->pointsAtZAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFESpotLightElementSpecularExponent(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* castedThis = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpotLightElement* imp = static_cast<SVGFESpotLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->specularExponentAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFESpotLightElementLimitingConeAngle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* castedThis = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFESpotLightElement* imp = static_cast<SVGFESpotLightElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->limitingConeAngleAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFESpotLightElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFESpotLightElement* domObject = static_cast<JSSVGFESpotLightElement*>(asObject(slotBase));
    return JSSVGFESpotLightElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGFESpotLightElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFESpotLightElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
