/* session-list.c generated by valac 0.18.1, the Vala compiler
 * generated from session-list.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <lightdm.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>


#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;
typedef struct _FadableBoxPrivate FadableBoxPrivate;

#define TYPE_PROMPT_BOX (prompt_box_get_type ())
#define PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT_BOX, PromptBox))
#define PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT_BOX, PromptBoxClass))
#define IS_PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT_BOX))
#define IS_PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT_BOX))
#define PROMPT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT_BOX, PromptBoxClass))

typedef struct _PromptBox PromptBox;
typedef struct _PromptBoxClass PromptBoxClass;
typedef struct _PromptBoxPrivate PromptBoxPrivate;

#define TYPE_FADING_LABEL (fading_label_get_type ())
#define FADING_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADING_LABEL, FadingLabel))
#define FADING_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADING_LABEL, FadingLabelClass))
#define IS_FADING_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADING_LABEL))
#define IS_FADING_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADING_LABEL))
#define FADING_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADING_LABEL, FadingLabelClass))

typedef struct _FadingLabel FadingLabel;
typedef struct _FadingLabelClass FadingLabelClass;

#define TYPE_FLAT_BUTTON (flat_button_get_type ())
#define FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAT_BUTTON, FlatButton))
#define FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLAT_BUTTON, FlatButtonClass))
#define IS_FLAT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAT_BUTTON))
#define IS_FLAT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLAT_BUTTON))
#define FLAT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLAT_BUTTON, FlatButtonClass))

typedef struct _FlatButton FlatButton;
typedef struct _FlatButtonClass FlatButtonClass;

#define TYPE_SESSION_PROMPT (session_prompt_get_type ())
#define SESSION_PROMPT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_PROMPT, SessionPrompt))
#define SESSION_PROMPT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SESSION_PROMPT, SessionPromptClass))
#define IS_SESSION_PROMPT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_PROMPT))
#define IS_SESSION_PROMPT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SESSION_PROMPT))
#define SESSION_PROMPT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SESSION_PROMPT, SessionPromptClass))

typedef struct _SessionPrompt SessionPrompt;
typedef struct _SessionPromptClass SessionPromptClass;
typedef struct _SessionPromptPrivate SessionPromptPrivate;

#define TYPE_TOGGLE_BOX (toggle_box_get_type ())
#define TOGGLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLE_BOX, ToggleBox))
#define TOGGLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOGGLE_BOX, ToggleBoxClass))
#define IS_TOGGLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLE_BOX))
#define IS_TOGGLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOGGLE_BOX))
#define TOGGLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOGGLE_BOX, ToggleBoxClass))

typedef struct _ToggleBox ToggleBox;
typedef struct _ToggleBoxClass ToggleBoxClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_UNITY_GREETER (unity_greeter_get_type ())
#define UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNITY_GREETER, UnityGreeter))
#define UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNITY_GREETER, UnityGreeterClass))
#define IS_UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNITY_GREETER))
#define IS_UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNITY_GREETER))
#define UNITY_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNITY_GREETER, UnityGreeterClass))

typedef struct _UnityGreeter UnityGreeter;
typedef struct _UnityGreeterClass UnityGreeterClass;
typedef struct _UnityGreeterPrivate UnityGreeterPrivate;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;
typedef struct _GreeterListPrivate GreeterListPrivate;

#define TYPE_DASH_BOX (dash_box_get_type ())
#define DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BOX, DashBox))
#define DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BOX, DashBoxClass))
#define IS_DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BOX))
#define IS_DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BOX))
#define DASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BOX, DashBoxClass))

typedef struct _DashBox DashBox;
typedef struct _DashBoxClass DashBoxClass;

#define GREETER_LIST_TYPE_MODE (greeter_list_mode_get_type ())

#define TYPE_SESSION_LIST (session_list_get_type ())
#define SESSION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_LIST, SessionList))
#define SESSION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SESSION_LIST, SessionListClass))
#define IS_SESSION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_LIST))
#define IS_SESSION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SESSION_LIST))
#define SESSION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SESSION_LIST, SessionListClass))

typedef struct _SessionList SessionList;
typedef struct _SessionListClass SessionListClass;
typedef struct _SessionListPrivate SessionListPrivate;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _FadableBox {
	GtkEventBox parent_instance;
	FadableBoxPrivate * priv;
};

struct _FadableBoxClass {
	GtkEventBoxClass parent_class;
	void (*draw_full_alpha) (FadableBox* self, cairo_t* c);
};

struct _PromptBox {
	FadableBox parent_instance;
	PromptBoxPrivate * priv;
	GtkGrid* box_grid;
	GtkGrid* name_grid;
	FadingLabel* name_label;
	FlatButton* option_button;
	GtkWidget* small_box_widget;
	FadingLabel* small_name_label;
	gint start_row;
	gint last_row;
};

struct _PromptBoxClass {
	FadableBoxClass parent_class;
	GtkGrid* (*create_name_grid) (PromptBox* self);
	GtkGrid* (*create_small_name_grid) (PromptBox* self);
	void (*set_start_row) (PromptBox* self);
	void (*reset_last_row) (PromptBox* self);
	void (*add_static_prompts) (PromptBox* self);
};

struct _SessionPrompt {
	PromptBox parent_instance;
	SessionPromptPrivate * priv;
};

struct _SessionPromptClass {
	PromptBoxClass parent_class;
};

struct _SessionPromptPrivate {
	gchar* _session;
	gchar* _default_session;
	ToggleBox* box;
};

struct _UnityGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGreeterPrivate * priv;
	gboolean test_mode;
};

struct _UnityGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGreeter *self);
};

typedef enum  {
	GREETER_LIST_MODE_ENTRY,
	GREETER_LIST_MODE_SCROLLING
} GreeterListMode;

struct _GreeterList {
	FadableBox parent_instance;
	GreeterListPrivate * priv;
	gchar* greeter_authenticating_user;
	gboolean _always_show_manual;
	GList* entries;
	DashBox* greeter_box;
	GreeterListMode mode;
	gboolean will_clear;
	gboolean prompted;
	gchar* test_username;
	gboolean test_is_authenticated;
};

struct _GreeterListClass {
	FadableBoxClass parent_class;
	gchar* (*get_selected_id) (GreeterList* self);
	void (*focus_prompt) (GreeterList* self);
	void (*show_authenticated) (GreeterList* self, gboolean successful);
	void (*insert_entry) (GreeterList* self, PromptBox* entry);
	void (*add_manual_entry) (GreeterList* self);
	gint (*get_position_y) (GreeterList* self, gdouble position);
	void (*setup_prompt_box) (GreeterList* self, gboolean fade);
	void (*show_prompt_cb) (GreeterList* self, const gchar* text, LightDMPromptType type);
	void (*authentication_complete_cb) (GreeterList* self);
	void (*start_authentication) (GreeterList* self);
	gchar* (*get_lightdm_session) (GreeterList* self);
	void (*test_start_authentication) (GreeterList* self);
};

struct _SessionList {
	GreeterList parent_instance;
	SessionListPrivate * priv;
};

struct _SessionListClass {
	GreeterListClass parent_class;
};

struct _SessionListPrivate {
	gchar* _session;
	gchar* _default_session;
	SessionPrompt* prompt;
};


static gpointer session_prompt_parent_class = NULL;
extern UnityGreeter* unity_greeter_singleton;
static gpointer session_list_parent_class = NULL;
static GHashTable* session_list_badges;
static GHashTable* session_list_badges = NULL;

GType fade_tracker_get_type (void) G_GNUC_CONST;
GType fadable_get_type (void) G_GNUC_CONST;
GType fadable_box_get_type (void) G_GNUC_CONST;
GType prompt_box_get_type (void) G_GNUC_CONST;
GType fading_label_get_type (void) G_GNUC_CONST;
GType flat_button_get_type (void) G_GNUC_CONST;
GType session_prompt_get_type (void) G_GNUC_CONST;
GType toggle_box_get_type (void) G_GNUC_CONST;
#define SESSION_PROMPT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SESSION_PROMPT, SessionPromptPrivate))
enum  {
	SESSION_PROMPT_DUMMY_PROPERTY,
	SESSION_PROMPT_SESSION,
	SESSION_PROMPT_DEFAULT_SESSION
};
SessionPrompt* session_prompt_new (const gchar* id, const gchar* session, const gchar* default_session);
SessionPrompt* session_prompt_construct (GType object_type, const gchar* id, const gchar* session, const gchar* default_session);
static void session_prompt_selected_cb (SessionPrompt* self);
const gchar* toggle_box_get_selected_key (ToggleBox* self);
const gchar* session_prompt_get_session (SessionPrompt* self);
static void session_prompt_set_session (SessionPrompt* self, const gchar* value);
const gchar* session_prompt_get_default_session (SessionPrompt* self);
static void session_prompt_set_default_session (SessionPrompt* self, const gchar* value);
static GObject * session_prompt_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void prompt_box_set_label (PromptBox* self, const gchar* value);
ToggleBox* toggle_box_new (const gchar* default_key, const gchar* starting_key);
ToggleBox* toggle_box_construct (GType object_type, const gchar* default_key, const gchar* starting_key);
gpointer unity_greeter_ref (gpointer instance);
void unity_greeter_unref (gpointer instance);
GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_unity_greeter (GValue* value, gpointer v_object);
void value_take_unity_greeter (GValue* value, gpointer v_object);
gpointer value_get_unity_greeter (const GValue* value);
GType unity_greeter_get_type (void) G_GNUC_CONST;
void toggle_box_add_item (ToggleBox* self, const gchar* key, const gchar* label, GdkPixbuf* icon);
GdkPixbuf* session_list_get_badge (const gchar* session);
static void _session_prompt_selected_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void prompt_box_attach_item (PromptBox* self, GtkWidget* w, gboolean add_style_class);
static void session_prompt_finalize (GObject* obj);
static void _vala_session_prompt_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_session_prompt_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType greeter_list_get_type (void) G_GNUC_CONST;
GType dash_box_get_type (void) G_GNUC_CONST;
GType greeter_list_mode_get_type (void) G_GNUC_CONST;
GType session_list_get_type (void) G_GNUC_CONST;
#define SESSION_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SESSION_LIST, SessionListPrivate))
enum  {
	SESSION_LIST_DUMMY_PROPERTY,
	SESSION_LIST_SESSION,
	SESSION_LIST_DEFAULT_SESSION
};
GType background_get_type (void) G_GNUC_CONST;
GType menu_bar_get_type (void) G_GNUC_CONST;
SessionList* session_list_new (Background* bg, MenuBar* mb, const gchar* session, const gchar* default_session);
SessionList* session_list_construct (GType object_type, Background* bg, MenuBar* mb, const gchar* session, const gchar* default_session);
static SessionPrompt* session_list_add_session_prompt (SessionList* self, const gchar* id);
const gchar* session_list_get_session (SessionList* self);
const gchar* session_list_get_default_session (SessionList* self);
static void __lambda21_ (SessionList* self, gchar** responses, int responses_length1);
static void ___lambda21__prompt_box_respond (PromptBox* _sender, gchar** response, int response_length1, gpointer self);
void greeter_list_add_entry (GreeterList* self, PromptBox* entry);
static void session_list_real_add_manual_entry (GreeterList* base);
static void session_list_real_show_authenticated (GreeterList* base, gboolean successful);
static gchar* session_list_get_badge_name (const gchar* session);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void session_list_set_session (SessionList* self, const gchar* value);
static void session_list_set_default_session (SessionList* self, const gchar* value);
static GObject * session_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void session_list_finalize (GObject* obj);
static void _vala_session_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_session_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


SessionPrompt* session_prompt_construct (GType object_type, const gchar* id, const gchar* session, const gchar* default_session) {
	SessionPrompt * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = session;
	_tmp2_ = default_session;
	self = (SessionPrompt*) g_object_new (object_type, "id", _tmp0_, "session", _tmp1_, "default-session", _tmp2_, NULL);
	return self;
}


SessionPrompt* session_prompt_new (const gchar* id, const gchar* session, const gchar* default_session) {
	return session_prompt_construct (TYPE_SESSION_PROMPT, id, session, default_session);
}


static void session_prompt_selected_cb (SessionPrompt* self) {
	ToggleBox* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->box;
	_tmp1_ = toggle_box_get_selected_key (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	g_signal_emit_by_name ((PromptBox*) self, "respond", _tmp5_, 1);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
}


const gchar* session_prompt_get_session (SessionPrompt* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_session;
	result = _tmp0_;
	return result;
}


static void session_prompt_set_session (SessionPrompt* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_session);
	self->priv->_session = _tmp1_;
	g_object_notify ((GObject *) self, "session");
}


const gchar* session_prompt_get_default_session (SessionPrompt* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_session;
	result = _tmp0_;
	return result;
}


static void session_prompt_set_default_session (SessionPrompt* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_default_session);
	self->priv->_default_session = _tmp1_;
	g_object_notify ((GObject *) self, "default-session");
}


static void _session_prompt_selected_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	session_prompt_selected_cb (self);
}


static GObject * session_prompt_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SessionPrompt * self;
	const gchar* _tmp0_ = NULL;
	FadingLabel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ToggleBox* _tmp4_;
	UnityGreeter* _tmp5_;
	gboolean _tmp6_;
	ToggleBox* _tmp35_;
	ToggleBox* _tmp36_;
	ToggleBox* _tmp37_;
	parent_class = G_OBJECT_CLASS (session_prompt_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SESSION_PROMPT, SessionPrompt);
	_tmp0_ = _ ("Select desktop environment");
	prompt_box_set_label ((PromptBox*) self, _tmp0_);
	_tmp1_ = ((PromptBox*) self)->name_label;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->_default_session;
	_tmp3_ = self->priv->_session;
	_tmp4_ = toggle_box_new (_tmp2_, _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp4_;
	_tmp5_ = unity_greeter_singleton;
	_tmp6_ = _tmp5_->test_mode;
	if (_tmp6_) {
		ToggleBox* _tmp7_;
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_;
		ToggleBox* _tmp10_;
		GdkPixbuf* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_;
		ToggleBox* _tmp13_;
		GdkPixbuf* _tmp14_ = NULL;
		GdkPixbuf* _tmp15_;
		_tmp7_ = self->priv->box;
		_tmp8_ = session_list_get_badge ("gnome");
		_tmp9_ = _tmp8_;
		toggle_box_add_item (_tmp7_, "gnome", "GNOME", _tmp9_);
		_g_object_unref0 (_tmp9_);
		_tmp10_ = self->priv->box;
		_tmp11_ = session_list_get_badge ("kde");
		_tmp12_ = _tmp11_;
		toggle_box_add_item (_tmp10_, "kde", "KDE", _tmp12_);
		_g_object_unref0 (_tmp12_);
		_tmp13_ = self->priv->box;
		_tmp14_ = session_list_get_badge ("ubuntu");
		_tmp15_ = _tmp14_;
		toggle_box_add_item (_tmp13_, "ubuntu", "Ubuntu", _tmp15_);
		_g_object_unref0 (_tmp15_);
	} else {
		GList* _tmp16_ = NULL;
		_tmp16_ = lightdm_get_sessions ();
		{
			GList* session_collection = NULL;
			GList* session_it = NULL;
			session_collection = _tmp16_;
			for (session_it = session_collection; session_it != NULL; session_it = session_it->next) {
				LightDMSession* session = NULL;
				session = (LightDMSession*) session_it->data;
				{
					LightDMSession* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					LightDMSession* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					ToggleBox* _tmp23_;
					LightDMSession* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					LightDMSession* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					LightDMSession* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					GdkPixbuf* _tmp33_ = NULL;
					GdkPixbuf* _tmp34_;
					_tmp17_ = session;
					_tmp18_ = lightdm_session_get_key (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = session;
					_tmp21_ = lightdm_session_get_name (_tmp20_);
					_tmp22_ = _tmp21_;
					g_debug ("session-list.vala:49: Adding session %s (%s)", _tmp19_, _tmp22_);
					_tmp23_ = self->priv->box;
					_tmp24_ = session;
					_tmp25_ = lightdm_session_get_key (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = session;
					_tmp28_ = lightdm_session_get_name (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = session;
					_tmp31_ = lightdm_session_get_key (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = session_list_get_badge (_tmp32_);
					_tmp34_ = _tmp33_;
					toggle_box_add_item (_tmp23_, _tmp26_, _tmp29_, _tmp34_);
					_g_object_unref0 (_tmp34_);
				}
			}
		}
	}
	_tmp35_ = self->priv->box;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::selected-key", (GCallback) _session_prompt_selected_cb_g_object_notify, self, 0);
	_tmp36_ = self->priv->box;
	gtk_widget_show ((GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->box;
	prompt_box_attach_item ((PromptBox*) self, (GtkWidget*) _tmp37_, TRUE);
	return obj;
}


static void session_prompt_class_init (SessionPromptClass * klass) {
	session_prompt_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SessionPromptPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_session_prompt_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_session_prompt_set_property;
	G_OBJECT_CLASS (klass)->constructor = session_prompt_constructor;
	G_OBJECT_CLASS (klass)->finalize = session_prompt_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_PROMPT_SESSION, g_param_spec_string ("session", "session", "session", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_PROMPT_DEFAULT_SESSION, g_param_spec_string ("default-session", "default-session", "default-session", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void session_prompt_instance_init (SessionPrompt * self) {
	self->priv = SESSION_PROMPT_GET_PRIVATE (self);
}


static void session_prompt_finalize (GObject* obj) {
	SessionPrompt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SESSION_PROMPT, SessionPrompt);
	_g_free0 (self->priv->_session);
	_g_free0 (self->priv->_default_session);
	_g_object_unref0 (self->priv->box);
	G_OBJECT_CLASS (session_prompt_parent_class)->finalize (obj);
}


GType session_prompt_get_type (void) {
	static volatile gsize session_prompt_type_id__volatile = 0;
	if (g_once_init_enter (&session_prompt_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SessionPromptClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_prompt_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionPrompt), 0, (GInstanceInitFunc) session_prompt_instance_init, NULL };
		GType session_prompt_type_id;
		session_prompt_type_id = g_type_register_static (TYPE_PROMPT_BOX, "SessionPrompt", &g_define_type_info, 0);
		g_once_init_leave (&session_prompt_type_id__volatile, session_prompt_type_id);
	}
	return session_prompt_type_id__volatile;
}


static void _vala_session_prompt_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SessionPrompt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SESSION_PROMPT, SessionPrompt);
	switch (property_id) {
		case SESSION_PROMPT_SESSION:
		g_value_set_string (value, session_prompt_get_session (self));
		break;
		case SESSION_PROMPT_DEFAULT_SESSION:
		g_value_set_string (value, session_prompt_get_default_session (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_session_prompt_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SessionPrompt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SESSION_PROMPT, SessionPrompt);
	switch (property_id) {
		case SESSION_PROMPT_SESSION:
		session_prompt_set_session (self, g_value_get_string (value));
		break;
		case SESSION_PROMPT_DEFAULT_SESSION:
		session_prompt_set_default_session (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


SessionList* session_list_construct (GType object_type, Background* bg, MenuBar* mb, const gchar* session, const gchar* default_session) {
	SessionList * self = NULL;
	Background* _tmp0_;
	MenuBar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (bg != NULL, NULL);
	g_return_val_if_fail (mb != NULL, NULL);
	_tmp0_ = bg;
	_tmp1_ = mb;
	_tmp2_ = session;
	_tmp3_ = default_session;
	self = (SessionList*) g_object_new (object_type, "background", _tmp0_, "menubar", _tmp1_, "session", _tmp2_, "default-session", _tmp3_, NULL);
	return self;
}


SessionList* session_list_new (Background* bg, MenuBar* mb, const gchar* session, const gchar* default_session) {
	return session_list_construct (TYPE_SESSION_LIST, bg, mb, session, default_session);
}


static void __lambda21_ (SessionList* self, gchar** responses, int responses_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	_tmp0_ = responses;
	_tmp0__length1 = responses_length1;
	_tmp1_ = _tmp0_[0];
	g_signal_emit_by_name (self, "session-clicked", _tmp1_);
}


static void ___lambda21__prompt_box_respond (PromptBox* _sender, gchar** response, int response_length1, gpointer self) {
	__lambda21_ (self, response, response_length1);
}


static SessionPrompt* session_list_add_session_prompt (SessionList* self, const gchar* id) {
	SessionPrompt* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SessionPrompt* _tmp3_;
	SessionPrompt* e;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = self->priv->_session;
	_tmp2_ = self->priv->_default_session;
	_tmp3_ = session_prompt_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	e = _tmp3_;
	g_signal_connect_object ((PromptBox*) e, "respond", (GCallback) ___lambda21__prompt_box_respond, self, 0);
	greeter_list_add_entry ((GreeterList*) self, (PromptBox*) e);
	result = e;
	return result;
}


static void session_list_real_add_manual_entry (GreeterList* base) {
	SessionList * self;
	self = (SessionList*) base;
}


static void session_list_real_show_authenticated (GreeterList* base, gboolean successful) {
	SessionList * self;
	self = (SessionList*) base;
}


static gchar* session_list_get_badge_name (const gchar* session) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	g_return_val_if_fail (session != NULL, NULL);
	_tmp0_ = session;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("ubuntu")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("ubuntu-2d"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("ubuntu_badge.png");
				result = _tmp4_;
				return result;
			}
		}
	} else if ((((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("gnome-classic")))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("gnome-fallback"))))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("gnome-shell"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("gnome"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("gnome_badge.png");
				result = _tmp5_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("kde")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("kde-plasma"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("kde_badge.png");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("xterm")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("recovery_console_badge.png");
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("remote-login")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("remote_login_help.png");
				result = _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* session_list_get_badge (const gchar* session) {
	GdkPixbuf* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* name;
	const gchar* _tmp2_;
	GHashTable* _tmp12_;
	GHashTable* _tmp16_;
	const gchar* _tmp17_;
	gconstpointer _tmp18_ = NULL;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (session != NULL, NULL);
	_tmp0_ = session;
	_tmp1_ = session_list_get_badge_name (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* maybe_name;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* maybe_path;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = session;
		_tmp4_ = g_strdup_printf ("custom_%s_badge.png", _tmp3_);
		maybe_name = _tmp4_;
		_tmp5_ = maybe_name;
		_tmp6_ = g_build_filename (PKGDATADIR, _tmp5_, NULL, NULL);
		maybe_path = _tmp6_;
		_tmp7_ = maybe_path;
		_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = maybe_name;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (name);
			name = _tmp10_;
		} else {
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("unknown_badge.png");
			_g_free0 (name);
			name = _tmp11_;
		}
		_g_free0 (maybe_path);
		_g_free0 (maybe_name);
	}
	_tmp12_ = session_list_badges;
	if (_tmp12_ == NULL) {
		GHashFunc _tmp13_;
		GEqualFunc _tmp14_;
		GHashTable* _tmp15_;
		_tmp13_ = g_str_hash;
		_tmp14_ = g_str_equal;
		_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (session_list_badges);
		session_list_badges = _tmp15_;
	}
	_tmp16_ = session_list_badges;
	_tmp17_ = name;
	_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
	_tmp19_ = _g_object_ref0 ((GdkPixbuf*) _tmp18_);
	pixbuf = _tmp19_;
	_tmp20_ = pixbuf;
	if (_tmp20_ == NULL) {
		{
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			GdkPixbuf* _tmp24_;
			GdkPixbuf* _tmp25_;
			GdkPixbuf* _tmp26_;
			GHashTable* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			GdkPixbuf* _tmp30_;
			GdkPixbuf* _tmp31_;
			_tmp21_ = name;
			_tmp22_ = g_build_filename (PKGDATADIR, _tmp21_, NULL, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = gdk_pixbuf_new_from_file (_tmp23_, &_inner_error_);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			_tmp26_ = _tmp25_;
			if (_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp26_;
			_tmp27_ = session_list_badges;
			_tmp28_ = name;
			_tmp29_ = g_strdup (_tmp28_);
			_tmp30_ = pixbuf;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			g_hash_table_insert (_tmp27_, _tmp29_, _tmp31_);
		}
		goto __finally17;
		__catch17_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp32_;
			GError* _tmp33_;
			const gchar* _tmp34_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp32_ = name;
			_tmp33_ = e;
			_tmp34_ = _tmp33_->message;
			g_debug ("session-list.vala:149: Error loading badge %s: %s", _tmp32_, _tmp34_);
			_g_error_free0 (e);
		}
		__finally17:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = pixbuf;
	_g_free0 (name);
	return result;
}


const gchar* session_list_get_session (SessionList* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_session;
	result = _tmp0_;
	return result;
}


static void session_list_set_session (SessionList* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_session);
	self->priv->_session = _tmp1_;
	g_object_notify ((GObject *) self, "session");
}


const gchar* session_list_get_default_session (SessionList* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_session;
	result = _tmp0_;
	return result;
}


static void session_list_set_default_session (SessionList* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_default_session);
	self->priv->_default_session = _tmp1_;
	g_object_notify ((GObject *) self, "default-session");
}


static GObject * session_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SessionList * self;
	SessionPrompt* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (session_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SESSION_LIST, SessionList);
	_tmp0_ = session_list_add_session_prompt (self, "session");
	_g_object_unref0 (self->priv->prompt);
	self->priv->prompt = _tmp0_;
	return obj;
}


static void session_list_class_init (SessionListClass * klass) {
	session_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SessionListPrivate));
	GREETER_LIST_CLASS (klass)->add_manual_entry = session_list_real_add_manual_entry;
	GREETER_LIST_CLASS (klass)->show_authenticated = session_list_real_show_authenticated;
	G_OBJECT_CLASS (klass)->get_property = _vala_session_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_session_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = session_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = session_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_LIST_SESSION, g_param_spec_string ("session", "session", "session", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SESSION_LIST_DEFAULT_SESSION, g_param_spec_string ("default-session", "default-session", "default-session", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("session_clicked", TYPE_SESSION_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void session_list_instance_init (SessionList * self) {
	self->priv = SESSION_LIST_GET_PRIVATE (self);
}


static void session_list_finalize (GObject* obj) {
	SessionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SESSION_LIST, SessionList);
	_g_free0 (self->priv->_session);
	_g_free0 (self->priv->_default_session);
	_g_object_unref0 (self->priv->prompt);
	G_OBJECT_CLASS (session_list_parent_class)->finalize (obj);
}


GType session_list_get_type (void) {
	static volatile gsize session_list_type_id__volatile = 0;
	if (g_once_init_enter (&session_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SessionListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionList), 0, (GInstanceInitFunc) session_list_instance_init, NULL };
		GType session_list_type_id;
		session_list_type_id = g_type_register_static (TYPE_GREETER_LIST, "SessionList", &g_define_type_info, 0);
		g_once_init_leave (&session_list_type_id__volatile, session_list_type_id);
	}
	return session_list_type_id__volatile;
}


static void _vala_session_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SessionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SESSION_LIST, SessionList);
	switch (property_id) {
		case SESSION_LIST_SESSION:
		g_value_set_string (value, session_list_get_session (self));
		break;
		case SESSION_LIST_DEFAULT_SESSION:
		g_value_set_string (value, session_list_get_default_session (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_session_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SessionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SESSION_LIST, SessionList);
	switch (property_id) {
		case SESSION_LIST_SESSION:
		session_list_set_session (self, g_value_get_string (value));
		break;
		case SESSION_LIST_DEFAULT_SESSION:
		session_list_set_default_session (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



