# vsdump: test program to dump and parse content of vsd file
#
# Copyright (C) 2006-2007	Valek Filippov (frob@df.ru)
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 3 or later of the GNU General Public
# License as published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
# USA
import vsdoc
import struct
import tree
import math

def fill(rect,doc,data,cr):
##    8 29 FillPattern
    offFG = 19
    offBG = 25
    FG = ord(data[offFG])
    r = ord(data[offBG])
    g = ord(data[offBG+1])
    b = ord(data[offBG+2])
    fgcolor = doc.colors[FG]
    cr.set_source_rgb (fgcolor.r/255.0,fgcolor.g/255.0,fgcolor.b/255.0)
    print 'FG color num: %x, color: #%02x%02x%02x\
      BG color: #%02x%02x%02x'%(FG,fgcolor.r,fgcolor.g,fgcolor.b,r,g,b)

def line(rect,doc,data,cr):
    offFlags = 50
    offClr = 28
    flags = ord(data[offFlags])
##    if flags&1 == 1:
    clr = ord(data[offClr])
    color = doc.colors[clr]
##    cr.set_source_rgb (color.r/255,color.g/255,color.b/255)
##    cr.save()
    doc.savenum = clr
    print 'Flags: %x. Line color num: %x, color: #%02x%02x%02x'%(flags,clr,color.r,color.g,color.b)

def char(rect,doc,data,cr):
    offClr = 25
    offSize = 37
    clr = ord(data[offClr])
    color = doc.colors[clr]
    cr.set_source_rgb (color.r/255.0,color.g/255.0,color.b/255.0)
    [size] = struct.unpack('<d', data[offSize:offSize+8])
    print 'FontSize: %.3f  %x'%(size,ord(data[36]))
    cr.set_font_size(25.4*size)
#    cr.show_text(doc.text)
#    cr.set_source_rgba(1,1,1,1)
#    doc.text = ''
    print 'Char color num: %x, color: #%02x%02x%02x'%(clr,color.r,color.g,color.b)
    
def text(rect,doc,data,cr):
    offset = 27
    if doc.version == 11:
        str=unicode(data[offset:],'utf-16').encode('utf-8')
    else:
        str = unicode(data[offset:],'cp1251').encode('utf-8')
    cr.set_source_rgb(0,0,0)
    doc.text = str
    print 'Text ',str
    
def moveto(rect,doc,data,cr):
    offX = 20
    offY = 29
    [x] = struct.unpack('<d', data[offX:offX+8])
    [y] = struct.unpack('<d', data[offY:offY+8])
    cr.move_to(x*25.4,-y*25.4)
    print "MoveTo: %u %u"%(x*25.4,doc.pages[0].height-y*25.4)

def arcto(rect,doc,data,cr):
    offX = 20
    offY = 29
    offA = 38
    [x] = struct.unpack('<d', data[offX:offX+8])
    [y] = struct.unpack('<d', data[offY:offY+8])
    [a] = struct.unpack('<d', data[offA:offA+8])
    x1,y1 = cr.get_current_point()
    x = 25.4*x
    y = 25.4*y
    a = 25.4*a
    flag = 0
    radius = (4.*a*a+(x-x1)**2+(y-y1)**2)/(8.*a)
    if radius < 0:
        radius = -radius
        flag = 1
    if round(y1) < 0:
        zone = 0
    else:
        zone = 1
    len = ((y-y1)*(y-y1)+(x-x1)*(x-x1))**0.5
    if flag == 0 and zone == 1:
        xc = -((x1 + x)/2. + (radius-a)*(y1-y)/len)
        yc = -((y1 + y)/2. + (radius-a)*(x-x1)/len)
        ang1 = math.atan2((y1-yc),(x1-xc))
        ang2 = math.atan2((y+yc),(x-xc)) # for arc2 and arc3
        cr.arc_negative(xc, yc, radius, ang1, -ang2)
    if flag == 0 and zone == 0:
        xc = (x1 + x)/2. + (radius-a)*(y-y1)/len
        yc = (y1 + y)/2. + (radius-a)*(x1-x)/len
        ang1 = math.atan2((y1-yc),(x1-xc))
        ang2 = math.atan2((y+yc),(x-xc)) # for arc2 and arc3
        cr.arc_negative(xc, yc, radius, ang1, -ang2)
    if flag == 1 and zone == 0:
        xc = -((x1 + x)/2. + (-a-radius)*(y-y1)/len)
        yc = (y1 + y)/2. + (-a-radius)*(x1-x)/len
        ang1 = math.atan2((y1-yc),(x1-xc))
        ang2 = math.atan2((yc-y),(x-xc)) # for arc2 and arc3
        cr.arc(xc, yc, radius, ang1, -ang2)
    if flag == 1 and zone == 1:
        xc = (x1 + x)/2. + (-radius-a)*(y1-y)/len
        yc = -((y1 + y)/2. + (-radius-a)*(x-x1)/len)
        ang1 = math.atan2((y1-yc),(x1-xc))
        ang2 = math.atan2((y+yc),(x-xc)) # for arc2 and arc3
        cr.arc(xc, yc, radius, ang1, -ang2)
    print "ArcTo: %u %u %u %u %u"%(xc,yc,radius,ang1*180/math.pi,-ang2*180/math.pi)
    
def lineto(rect,doc,data,cr):
    offset1 = 20
    offset2 = 29
    [x] = struct.unpack('<d', data[offset1:offset1+8])
    [y] = struct.unpack('<d', data[offset2:offset2+8])
    cr.line_to(x*25.4,-y*25.4)
    print "LineTo: %u %u"%(x*25.4,-y*25.4)

def ellipse(rect,doc,data,cr):
    offX = 20
    offY = 29
    offA = 38
    offB = 47
    offC = 56
    offD = 65
    [x] = struct.unpack('<d', data[offX:offX+8])
    [y] = struct.unpack('<d', data[offY:offY+8])
    [a] = struct.unpack('<d', data[offA:offA+8])
    [b] = struct.unpack('<d', data[offB:offB+8])
    [c] = struct.unpack('<d', data[offC:offC+8])
    [d] = struct.unpack('<d', data[offD:offD+8])
    cr.move_to(x*25.4,-y*25.4)
    cr.save()
    cr.translate(x*25.4,-y*25.4)
    cr.move_to((a-x)*25.4, (b-y)*25.4)
    cr.scale((a-x)*25.4, (d-y)*25.4)
    cr.arc(0.,0.,1.,0.,2.0*math.pi)
    cr.move_to(x*25.4, -y*25.4)
    cr.restore()
    print 'Ellipse: %u %u %u %u %u %u'%(x*25.4,doc.pages[0].height-y*25.4,a*25.4,b*25.4,c*25.4,d*25.4)

def xform1d(rect,doc,data,cr):
    offX = 20
    offY = 29
    [x] = struct.unpack('<d', data[offX:offX+8])
    [y] = struct.unpack('<d', data[offY:offY+8])
    cr.move_to(x*25.4,doc.pages[0].height-y*25.4)
    print 'XForm1D: %u %u'%(x*25.4,y*25.4)
    
def xform(rect,doc,data,cr):
    offX = 20
    offY = 29
    offW = 38
    offH = 47    
    offAng = 74
    [x] = struct.unpack('<d', data[offX:offX+8])
    [y] = struct.unpack('<d', data[offY:offY+8])
    [w] = struct.unpack('<d', data[offW:offW+8])
    [h] = struct.unpack('<d', data[offH:offH+8])
    [ang] = struct.unpack('<d', data[offAng:offAng+8])
    cr.save()
    cr.translate((x-w/2)*25.4,doc.pages[0].height-(y-h/2)*25.4)
    if ang != 0:
        cr.rotate(-ang)
    print 'XForm X.Y: %u %u %.2f'%((x-w/2)*25.4,doc.pages[0].height-(y-h/2)*25.4,ang)

def shapetype(rect,doc,data,cr):
    if doc.text != '':
        cr.show_text(doc.text)
        doc.text = ''
	cr.restore()
        cr.set_source_rgba(1,1,1,0)
	cr.stroke()
    else:
        cr.fill_preserve()
	cr.restore()
	if doc.savenum != None:
    	    color = doc.colors[doc.savenum]
    	    cr.set_source_rgb (color.r/255.0,color.g/255.0,color.b/255.0)
    	    doc.savenum = None
	cr.stroke()
    print 'Shape!'
    cr.set_source_rgb(0,0,0)
    
def pageprops(rect,doc,data,cr):
    offW = 20
    offH = 29
    [w] = struct.unpack('<d', data[offW:offW+8])
    [h] = struct.unpack('<d', data[offH:offH+8])
    doc.pages[0].width = w*25.4
    doc.pages[0].height = h*25.4
    ratio = min(rect.width/(w*25.4),rect.height/(h*25.4))
##    cr.save()
    cr.scale(ratio/1.25,ratio/1.25)
    cr.translate(w*25.4/8,h*25.4/8)
    cr.rectangle(0,0,w*25.4,h*25.4)

def page(rect,doc,data,cr):
    page = vsdoc.page()
    doc.pages.append(page)
    offW = 53
    offH = 61
