# vsdump: test program to dump and parse content of vsd file
#
# Copyright (C) 2006-2007	Valek Filippov (frob@df.ru)
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 3 or later of the GNU General Public
# License as published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
# USA
import gtk
import gobject
import math
import chunks

class pointer:
    type = 0
    address = 0
    offset = 0
    length = 0
    format = 0
    path = '' # here I'm going to store path to TreeStore row with this pointer
    data = '' # here I'm going to store content of suitable part of vsd file

class vsdoc:
    def __init__(self):
        self.colors = [] #color()
        self.fonts = [] #font()
        self.pages = [] #page()
        self.pntrs = [] #pointer()
        self.version = 0
        self.savenum = None
        self.text = ''
        
    def usage():
    ##        class_vsdoc = vsdoc()
        class_pntrs = pointer()
        class_pages = page()
        class_vsdoc.pntrs.append(class_pntrs)
        class_vsdoc.pages.append(class_pages)
        
class color:
    r = 0.0
    g = 0.0
    b = 0.0

class font:
    name = ''

class cell:
    value = ''
    formula = ''

class row:
    cells = [] #cell()

class section:
    rows = [] #row()
    
class shape:
    shapes = [] #shape()
    sections = []# section()

class page:
    width = 0
    height = 0
    shapes = [] #shape()
    name = ''

class chunk:
    type = 0    #dword
    IX = 0        #dword
    unkn1 = 0   #dword
    length = 0  #dword
    unkn2 = 0   #word
    unkn3 = 0   #byte
    data = ''

class VsdFace(gtk.DrawingArea):
    def __init__(self,pagepntr,model,doc):
        self.pagepntr = pagepntr
        self.model = model
        self.doc = doc
        super(VsdFace, self).__init__()
        # gtk.Widget signals
        self.connect("expose_event", self.expose)
        self._dragging = False # true if the interface is being dragged
        
    def expose(self, widget, event):
        context = widget.window.cairo_create()
        # set a clip region for the expose event
        context.rectangle(event.area.x, event.area.y,event.area.width, event.area.height)
        context.clip()
        self.draw(context)
        return False

    def draw(self, context):
        rect = self.get_allocation()
        iter = self.model.iter_children(self.pagepntr.path)
        context.set_source_rgb(1,1,1)
        for i in range(self.model.iter_n_children(self.pagepntr.path)):
            chunks.parse_page(rect,self.doc,self.model,iter,context)
            iter = self.model.iter_nth_child(self.pagepntr.path,i+1)

        if self.doc.text != '':
            context.show_text(self.doc.text)
            self.doc.text = ''
            context.restore()
            context.set_source_rgba(1,1,1,0)
            context.stroke()
        else:
            context.fill_preserve()
            if self.doc.savenum != None:
                color = self.doc.colors[self.doc.savenum]
                context.set_source_rgb (color.r/255.0,color.g/255.0,color.b/255.0)
                self.doc.savenum = None
                context.stroke()
            context.restore()
            context.stroke()
        return
