// ==UserScript==
// @include       https://twitter.com/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['doc', 'banners', 'page-outer', 'global-nav-home', 'global-new-tweet-button'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    function checkMessangesCount() {
        var title;
        var search = document.getElementsByClassName('search-query')[0];
        if (search) { // stream for #tag
            title = search.textContent;
        }
        if (document.getElementsByClassName('module mini-profile')[0]) { // home screen
            title = _("Tweets");
        }

        if (title) {
            var count = '0';
            var countElement = document.getElementsByClassName('new-tweets-bar js-new-tweets-bar')[0];
            if (countElement) {
                count = countElement.textContent.match(/\d+/)[0];
            }
            // empty callback raise current tab
            reportTestState(title + count);
            Unity.MessagingIndicator.showIndicator(title, { count: count,
                                                            callback: function () {} });
        }
    }
    setInterval(wrapCallback(checkMessangesCount), 3000);
}

var login;
var callback;
if (isCorrectPage()) {
    var prefix = 'https://twitter.com/';

    var profileLink = document.evaluate('//a[@data-nav="profile"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
    login = profileLink.href;

    if (login.substr(0, prefix.length) === prefix) {
        login = login.substr(prefix.length);
    } else {
        login = null;
    }
    callback = wrapCallback(messagingIndicatorSetup);
}
Unity.init({ name: "Twitter",
             login: login,
             domain: 'twitter.com',
             homepage: 'https://twitter.com/',
             iconUrl: "icon://unity-webapps-twitter",
             onInit: callback });
