// ==UserScript==
// @include       https://www.google.*/reader/view/*
// @include       http://www.google.*/reader/view/*
// @require       utils.js
// @require       google-common.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

/**
 * Validates the page for functional tests.
 * 
 */
function selfTest() {
    if (!checkCount().length) {
        return;
    }

    reportTestState('PASS SELF TEST');
};

function forEachFolder(callback) {
    function expandNode(node, path) {
        var i, childs = node.childNodes;
        for (i = 0; i < childs.length; i++) {
            var link = childs[i].childNodes[1];

            callback(link.textContent, link.href, path);
            var title = link.textContent.match(/^[^(]+/)[0];
            if (childs[i].childNodes.length > 2) {
                expandNode(childs[i].childNodes[2], path + '/' + title);
            }
        }
    }
    var root = document.evaluate('//div[@id="sub-tree-container"]/ul/li/ul',
                                 document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
    expandNode(root, '/Subscriptions');
}

function isCorrectPage() {
    var i, ids = ['reading-list-unread-count'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function checkCount() {
    var res = [];
    forEachFolder(function (text, link, path) {
        var title = text.match(/^[^(]+/)[0];
        var count = '0';
        if (text.match(/\d+/)) {
            count = text.match(/\d+/)[0];
        }
        res.push({ name: trim(title), count: count, callback: makeRedirector(link) });
    });
    return res;
}

function getCurrent() {
    return document.evaluate('//a[@class="link tree-link-selected"]/div[2]',
                             document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.textContent;
}

function messagingIndicatorSetup() {
    var indicatorsController = new Indicators(checkCount);
    window.onpopstate = function () {
	if (!getCurrent()) {
	    indicatorsController.visited(getCurrent());
	}
    };

    doMainMenuIntegration(document);
    forEachFolder(function (text, link, path) {
        var title = text.match(/^[^(]+/)[0];
        Unity.addAction(path + '/' + title, makeRedirector(link.href));
    });

    selfTest();
}

if (isCorrectPage()) {
    Unity.init({ name: 'Google Reader',
		 domain: window.location.hostname,
                 homepage: 'http://' + window.location.hostname + '/reader/view/',
		 iconUrl: 'icon://unity-webapps-google-reader',
                 onInit: wrapCallback(messagingIndicatorSetup) });
}
