// ==UserScript==
// @include		  http://tumblr.com/*
// @include		  http://*.tumblr.com/*
// @include       https://tumblr.com/*
// @include		  https://*.tumblr.com/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1.0);

function integrateDashboard() {
	function setLauncherCount() {
		// checks both messages and new post count, sums them, and displays a launcher counter.
		var i, total = 0, elements = document.getElementsByClassName("tab_notice_value");
		for (i = 0; i < elements.length; i++) {
			var count = elements[i].innerHTML;
			if (count > 0) {
				total += parseInt(count, 10);
			}
		}
		if (total > 0) {
			Unity.Launcher.setLauncherCount(total);
		} else {
			Unity.Launcher.clearCount();
		}
	}

	function checkNewMessageCount() {
		var ib = document.getElementById("inbox_button");
		var count = document.evaluate('a//span[@class="tab_notice_value"]', ib, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
		if (count === null) {
			count = 0;
		} else {
			count = parseInt(count.innerHTML, 10);
		}
		Unity.MessagingIndicator.showIndicator(_("Inbox"), { count: count,
			  onIndicatorActivated: makeRedirector("http://tumblr.com/inbox") });
	}

	Unity.addAction('/Post/Text', makeRedirector('http://tumblr.com/new/text'));
	Unity.addAction('/Post/Link', makeRedirector('http://tumblr.com/new/link'));
	Unity.addAction('/Post/Chat', makeRedirector('http://tumblr.com/new/chat'));
	Unity.addAction('/Post/Photo', makeRedirector('http://tumblr.com/new/photo'));
	Unity.addAction('/Post/Quote', makeRedirector('http://tumblr.com/new/quote'));
	Unity.addAction('/Post/Audio', makeRedirector('http://tumblr.com/new/audio'));
	Unity.addAction('/Post/Video', makeRedirector('http://tumblr.com/new/video'));

	setLauncherCount();
	checkNewMessageCount();
	setInterval(wrapCallback(setLauncherCount), 5000);
	setInterval(wrapCallback(checkNewMessageCount), 5000);
}

function integrateTumblrblog() {
	// parse tumblr controls and add hud actions

	Unity.Launcher.addAction(_("Dashboard"), makeRedirector("http://tumblr.com/dashboard"));
}

function isDashboard() {
    var i, ids = ['content', 'tabs_outter_container'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function isTumblrBlog() {
	return document.getElementById("tumblr_controls");
}

function setupTumblr() {
	if (isDashboard()) {
		integrateDashboard();
	} else if (isTumblrBlog()) {
		integrateTumblrblog();
	}
}

Unity.init({ name: "Tumblr",
	     iconUrl: "http://assets.tumblr.com/images/logo.png",
	     onInit: wrapCallback(setupTumblr),
	     homepage: 'https://www.tumblr.com/',
	     domain: "tumblr.com" });
