// ==UserScript==
// @include       http://*.mail.yahoo.com/*
// @include       https://*.mail.yahoo.com/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

/**
 * Validates the page for functional tests.
 * 
 */
function selfTest() {
    if (!getComposeMessageNode() || !getCheckMailNode()) {
        return;
    }
    if (!checkMessagesCount().length) {
        return;
    }

    reportTestState('PASS SELF TEST');
};

function getComposeMessageNode() {
    return document.getElementById('main-btn-new').firstChild;
}

function getCheckMailNode() {
    return document.getElementById('btn-checkmail');
}

function checkMessagesCount() {
    var container = document.getElementById('Inbox');
    var indicators = [];

    var i, count = document.getElementById('inbox-count').textContent;

    if (!count.length) {
      count = '0';
    }

    function activateNode() {
      launchClickEvent(this);
    }
    indicators.push({ name: _("Inbox"),
		      count: count,
                      callback: activateNode.bind(container) });

    var snapshot = document.evaluate('//ul[@id="custom-folders"]/li/a',
                                   document, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);
    for (i = 0; i < snapshot.snapshotLength; i++) {
      var node = snapshot.snapshotItem(i);
      count = '0';
      if (node.lastChild.textContent.length) {
        count = node.lastChild.textContent;
      }
    
      if (node.firstChild.textContent.length) {
        indicators.push({ name: node.firstChild.textContent,
	 		  callback: activateNode.bind(node.parentNode),
                          count: count });
      }
    }
    return indicators;
}

function isCorrectPage() {
    var i, ids = ['inbox-count', 'Inbox'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    var _indicators = [];
    var checkMessagesCountWrapper = function () {
        _indicators = checkMessagesCount();
        return _indicators;
    };

    var indicatorsController = new Indicators(checkMessagesCountWrapper);
    setInterval(function () {
	getCheckMailNode().click();
    }, 3000);
    window.onfocus = function () {
	for (var i = 0; i < _indicators.length; i++) {
	    indicatorsController.visited(_indicators[i].name);
	}
    };

    function composeNewMessage() {
        var compose = getComposeMessageNode();
        launchClickEvent(compose);
    }
    Unity.MessagingIndicator.addAction(_("Compose New Message"),
                                       wrapCallback(composeNewMessage));

    selfTest();
}

if (isCorrectPage()) {
    Unity.init({ name: 'Yahoo Mail',
                 domain: 'mail.yahoo.com',
		 homepage: 'https://mail.yahoo.com',
                 iconUrl: "icon://unity-webapps-yahoo-mail",
                 onInit: wrapCallback(messagingIndicatorSetup) });

}
