function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._state++;
            this._browser.injectScript(makeAuthorizer('email', 'pass', this._login, this._password));
        } else {
            this._browser.finish();
        }
    },

    validateCallLog: function (log, out) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('facebook', log[0].args[0].name, 'facebook');

        assertEquals('Unity.init', log[2].func, 'Unity.init');
        assertEquals('Login', log[2].args[0].login, this._login);

        var found = false, i;
        for (i = 0; i < out.length; i++) {
            if (out[i] === 'PASS SELF TEST') {
                found = true;
            }
        }
        assertTrue('PASS SELF TEST', found);
    },

    scriptName: 'FacebookMessenger/FacebookMessenger.user.js'
};