function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('Email', 'Passwd', this._login, this._password));
        } else if (this._state >= 2) {
            this._browser.finish();
        }
        this._state++;
    },

    validateCallLog: function (log, out) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Google Reader', log[0].args[0].name, 'Google Reader');
        assertEquals('Unity.MessagingIndicator.clearIndicators', log[1].func, 'Unity.MessagingIndicator.clearIndicators');

        assertEquals('Unity.addAction', log[log.length - 1].func, 'Unity.addAction');
        assertFalse(log.length < 10);

        var found = false, i;
        for (i = 0; i < out.length; i++) {
            if (out[i] === 'PASS SELF TEST') {
                found = true;
            }
        }
        assertTrue('PASS SELF TEST', found);
    },

    scriptName: 'GoogleReader/GoogleReader.user.js'
};
